/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.util;

import at.cdes.util.ConfigurationHelper;
import at.cdes.util.OperatingSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Configuration {
    private String instanceName;
    private Properties config = null;
    private static final Logger logger = Logger.getLogger(Configuration.class);
    private OperatingSystem operating_system;
    public static final String JUNIT_CONF_RESOURCE_PROPERTY_NAME = "at.cdes.junit.conf-resource";
    public static final String JUNIT_DEFAULT_CONF_RESOURCE = "at/cdes/test/junit/cdes.conf";
    public static final String JUNIT_INSTANCE_NAME = "at.cdes.junit";

    public Configuration(String instanceName) {
        this.instanceName = instanceName;
        this.operating_system = ConfigurationHelper.getOperationSystemStatic();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String instanceName = ConfigurationHelper.getInstanceNameStatic();
        Configuration config = new Configuration(instanceName);
        config.printConfiguration(System.out);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public synchronized Properties getConfig() {
        this.checkProps();
        return this.config;
    }

    public void printConfiguration(PrintStream out) throws FileNotFoundException, IOException {
        this.checkProps();
        TreeMap<String, String> propsByName = new TreeMap<String, String>();
        Enumeration<?> e = this.config.propertyNames();
        while (e.hasMoreElements()) {
            String paramName = e.nextElement().toString();
            propsByName.put(paramName, this.config.getProperty(paramName));
        }
        Set sortedPropNames = propsByName.keySet();
        for (String paramName : sortedPropNames) {
            out.println(paramName + "=" + propsByName.get(paramName));
        }
        out.println("System.getProperty(os.name) says: " + System.getProperty("os.name"));
        out.println("The Operating System seems to be: " + (this.inWindows() ? "WINDOWS" : "UNIX"));
    }

    private static String buildDerbyURL(String host, String port, String db, String props) {
        StringBuffer url = new StringBuffer("jdbc:derby:");
        if (host != null) {
            url.append("//");
            url.append(host);
            if (port != null) {
                url.append(':');
                url.append(port);
            }
        }
        File abs = new File(db);
        db = abs.getAbsolutePath();
        url.append(db);
        if (props != null) {
            url.append(';');
            url.append(props);
        }
        return url.toString();
    }

    private static String buildMySQLURL(String host, String port, String db, String props) {
        StringBuffer url = new StringBuffer("jdbc:mysql://");
        url.append(host);
        if (port != null) {
            url.append(':');
            url.append(port);
        }
        url.append("/");
        url.append(db);
        if (props != null && props.length() > 0) {
            url.append(props);
        }
        return url.toString();
    }

    private static String buildMSSqlURL(String host, String port, String db, String props) {
        StringBuffer url = new StringBuffer("jdbc:sqlserver://");
        url.append(host);
        if (port != null) {
            url.append(':');
            url.append(port);
        }
        url.append(";databaseName=");
        url.append(db);
        if (props != null && props.length() > 0) {
            if (!props.startsWith(";")) {
                url.append(";");
            }
            url.append(props);
        }
        return url.toString();
    }

    public synchronized void checkProps() {
        if (this.config != null) {
            return;
        }
        this.config = new Properties();
        try {
            this.readFiles();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.checkParamValue("cdesignd_host", "127.0.0.1");
        this.checkParamValue("cdesignd_port", 3455, 1, 65535);
        this.checkParamValue("cdesignd_min_client_pool_size", 8, 1, 25);
        this.checkParamValue("cdesignd_max_client_pool_size", 16, 1, 200);
        this.checkParamValue("seeder_nthreads", 0, 0, 8);
        this.checkParamValue("seeder_max_tries", 5, 1, 100);
        this.checkParamValue("seeder_max_queue_size", 10000, 100, 1000000);
        this.checkParamValue("seeder_tile_resolutions", "72.0,1,102.0,2,144.0,2,51.0,3,36.0,4,204.0,5,288.0,6");
        this.checkParamValue("temp_dir", this.inWindows() ? System.getenv("TEMP") : "/tmp");
        this.checkParamValue("export_base_dir", this.config.getProperty("temp_dir"));
        if (this.config.getProperty("mysql_db") != null) {
            this.checkParamValue("mysql_db", "CDES");
            this.checkParamValue("mysql_driver", "com.mysql.jdbc.Driver");
            this.checkParamValue("mysql_host", "127.0.0.1");
            this.checkParamValue("mysql_password", "cdes");
            this.checkParamValue("mysql_port", 3306, 1, 65535);
            this.checkParamValue("mysql_user", "cdes");
            this.overwriteParamValue("db_db", this.config.getProperty("mysql_db"));
            this.overwriteParamValue("db_driver", this.config.getProperty("mysql_driver"));
            this.overwriteParamValue("db_host", this.config.getProperty("mysql_host"));
            this.overwriteParamValue("db_password", this.config.getProperty("mysql_password"));
            this.overwriteParamValue("db_port", this.config.getProperty("mysql_port"));
            this.overwriteParamValue("db_user", this.config.getProperty("mysql_user"));
            this.overwriteParamValue("db_url", Configuration.buildMySQLURL(this.config.getProperty("mysql_host"), this.config.getProperty("mysql_port"), this.config.getProperty("mysql_db"), this.config.getProperty("mysql_properties")));
            this.overwriteParamValue("hibernate_dialect", "org.hibernate.dialect.MySQLInnoDBDialect");
        } else if (this.config.getProperty("mssql_db") != null) {
            this.checkParamValue("mssql_db", "CDES");
            this.checkParamValue("mssql_driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
            this.checkParamValue("mssql_host", "127.0.0.1");
            this.checkParamValue("mssql_user", "cdes");
            this.overwriteParamValue("db_db", this.config.getProperty("mssql_db"));
            this.overwriteParamValue("db_driver", this.config.getProperty("mssql_driver"));
            this.overwriteParamValue("db_host", this.config.getProperty("mssql_host"));
            this.overwriteParamValue("db_password", this.config.getProperty("mssql_password"));
            String port = this.config.getProperty("mssql_port");
            if (port != null) {
                this.overwriteParamValue("db_port", port);
            }
            this.overwriteParamValue("db_user", this.config.getProperty("mssql_user"));
            this.overwriteParamValue("db_url", Configuration.buildMSSqlURL(this.config.getProperty("mssql_host"), port, this.config.getProperty("mssql_db"), this.config.getProperty("mssql_properties")));
            this.overwriteParamValue("hibernate_dialect", "org.hibernate.dialect.SQLServerDialect");
        } else if (this.config.getProperty("derby_db") != null) {
            String host = this.config.getProperty("derby_host");
            String port = this.config.getProperty("derby_port");
            String user = this.config.getProperty("derby_user");
            String password = this.config.getProperty("derby_password");
            if (host == null) {
                this.checkParamValue("derby_driver", "org.apache.derby.jdbc.EmbeddedDriver");
            } else {
                this.checkParamValue("derby_driver", "org.apache.derby.jdbc.ClientDriver");
                this.checkParamValue("derby_db", "cdes");
                this.checkParamValue("derby_password", "cdes");
            }
            this.overwriteParamValue("db_db", this.config.getProperty("derby_db"));
            this.overwriteParamValue("db_driver", this.config.getProperty("derby_driver"));
            this.overwriteParamValue("db_host", host != null ? host : "");
            this.overwriteParamValue("db_password", password != null ? password : "");
            this.overwriteParamValue("db_port", port != null ? port : "");
            this.overwriteParamValue("db_user", user != null ? user : "");
            String db = this.config.getProperty("derby_db");
            String props = this.config.getProperty("derby_properties");
            this.overwriteParamValue("db_url", Configuration.buildDerbyURL(host, port, db, props));
            this.overwriteParamValue("hibernate_dialect", "org.hibernate.dialect.DerbyDialect");
        }
        this.checkParamValue("db_validation_query", "");
        logger.info((Object)("Using database [" + this.config.getProperty("db_url") + "]."));
        String prop = this.config.getProperty("drop_tables_on_startup");
        if (prop == null) {
            this.overwriteParamValue("drop_tables_on_startup", "false");
        } else if (!this.instanceName.equals(JUNIT_INSTANCE_NAME) || System.getProperty("at.cdes.appserver") != null) {
            this.overwriteParamValue("drop_tables_on_startup", "false");
        }
        this.checkParamValue("login_regex", "");
        this.checkParamValue("db_disable_schemacheck", "no");
        this.checkParamValue("db_initial_connections", 4, 0, 100);
        this.checkParamValue("db_max_active_connections", 8, -1, 100);
        this.checkParamValue("db_max_idle_connections", 8, -1, 100);
        this.checkParamValue("db_min_idle_connections", 1, 0, 100);
        this.checkParamValue("db_max_wait", 3000, -1, 60000);
        this.checkParamValue("hibernate_max_fetch_depth", 2, 0, 4);
        this.checkParamValue("hibernate_use_second_level_cache", "false");
        this.checkParamValue("hibernate_use_query_cache", "true");
        String ehcache_url = "conf/spring/ehcache.xml";
        if ("true".equals(this.config.getProperty("hibernate_use_second_level_cache"))) {
            File ehcache_xml = new File(ConfigurationHelper.getInstanceConfigFileName(this.operating_system, this.instanceName, "ehcache.xml"));
            if (!ehcache_xml.exists() && !(ehcache_xml = new File(ConfigurationHelper.getGlobalConfigFileName(this.operating_system, "ehcache.xml"))).exists()) {
                ehcache_xml = null;
            }
            if (ehcache_xml != null) {
                ehcache_url = ehcache_xml.toURI().toString();
            }
            logger.info((Object)("Hibernate ehcache configured from URL [" + ehcache_url + "]."));
            if ("false".equals(this.config.getProperty("hibernate_use_query_cache"))) {
                logger.info((Object)"Hibernate query cache is deactivated.");
            }
        } else {
            logger.info((Object)"Hibernate ehcache is deactivated.");
        }
        this.config.setProperty("hibernate_second_level_cache_config_location", ehcache_url);
        this.checkParamValue("remote_interface_port", 3456, 1, 65535);
        this.checkParamValue("max_remote_clients", 128, 1, 2048);
        this.checkParamValue("min_client_pool_size", 4, 1, 25);
        this.checkParamValue("max_client_pool_size", 8, 1, 100);
        this.checkParamValue("client_idle_timeout", 60000, 5000, 3600000);
        this.checkParamValue("server_keystore_path", "");
        this.checkParamValue("server_keystore_password", "");
        this.checkParamValue("server_key_password", "");
        this.checkParamValue("client_keystore_path", "");
        this.checkParamValue("client_keystore_password", "");
        this.checkParamValue("client_key_password", "");
        this.checkParamValue("remoting_input_buffer_size", 1424, 0, 65535);
        this.checkParamValue("remoting_output_buffer_size", 1424, 0, 65535);
        this.checkParamValue("mailutils_pollIntervalMillis", 60000, 1, 3600000);
        this.checkParamValue("mailutils_sleepPerMailMillis", 1000, 1, 10000);
        this.checkParamValue("mailutils_smtphost", "localhost");
        this.checkParamValue("mailutils_senderAdr", "cdes@cdes.at");
        this.checkParamValue("mailutils_senderName", "c.des Plattform");
        this.checkParamValue("disable_sending", "no");
        this.checkParamValue("cert_operator_dn", "O=EV-i, C=AT");
        this.checkParamValue("cert_rootca_years", 5, 1, 99);
        this.checkParamValue("cert_usercert_years", 3, 1, 99);
        this.checkParamValue("application_url", "http://localhost:8080/cdes/app");
        this.checkParamValue("application_name", "c.des concurrent design");
        this.checkParamValue("application_welcome_string", "c.des concurrent design");
        this.checkParamValue("ext_manual_url", "");
        this.checkParamValue("tab_viewmode", 0, 0, 2);
        this.checkParamValue("cdesignd_pdf_border", 56.69291338582677, 0.0, 288.0);
        this.checkParamValue("OOO_LISTEN_HOST", "127.0.0.1");
        this.checkParamValue("OOO_LISTEN_PORT", 8100, 1, 65535);
        this.checkParamValue("OOO_LISTEN_URL", "socket,host=" + this.getOOoListenHost() + ",port=" + this.getOOoListenPort() + ";urp;");
        this.checkParamValue("OOO_CONNECT_HOST", "127.0.0.1");
        this.checkParamValue("OOO_CONNECT_PORT", 8100, 1, 65535);
        this.checkParamValue("OOO_CONNECT_URL", "socket,host=" + this.getOOoConnectHost() + ",port=" + this.getOOoConnectPort() + ";urp;");
        this.checkParamValue("global_readonly", "no");
        this.checkParamValue("temporary_extract_db_name", ("tmp_" + this.getStringValue("db_db") + "_extract").toLowerCase());
        this.config.setProperty("instance_name", this.instanceName);
        this.checkParamValue("repository_reviewcycle_backup", "");
        this.checkParamValue("repository_attachment_backup", "");
        this.checkParamValue("repository_label_backup", "");
        this.checkParamValue("repository_original_document_backup", "");
        this.checkParamValue("repository_document_ref_backup", "");
        this.checkParamValue("enable_png_tiled_preview", "yes");
        this.checkParamValue("enable_released_pdc_editing", "yes");
        this.checkParamValue("enable_locale_selection", "no");
        this.checkParamValue("enable_customer_logo", "yes");
        this.checkParamValue("max_email_attachment_filesize", 7400000, 0, Integer.MAX_VALUE);
        this.checkParamValue("outdated_files_remover_execution_hour", 0, 0, 23);
        this.checkParamValue("archive_job_expiration_days", 0, 0, 100);
        this.checkParamValue("original_document_expiration_days", 0, 0, 100);
        this.checkParamValue("use_document_subtypes", 1, 0, Integer.MAX_VALUE);
        this.checkParamValue("show_as_built_links", "no");
        this.checkParamValue("pdf_zip_compression_factor_estimate", 0.964, 0.0, 1.0);
        this.checkParamValue("plt_zip_compression_factor_estimate", 0.272, 0.0, 1.0);
        this.checkParamValue("max_archive_download_size", 0, 0, Integer.MAX_VALUE);
        this.checkParamValue("reverse_preduration", "no");
    }

    public void checkParamValue(String name, String failbackValue) {
        this.checkProps();
        String cur_value = this.config.getProperty(name);
        if (cur_value == null || cur_value.length() == 0) {
            this.config.setProperty(name, failbackValue);
        }
    }

    public void overwriteParamValue(String name, String failbackValue) {
        this.config.setProperty(name, failbackValue);
    }

    private String getStringValue(String name) {
        this.checkProps();
        return this.config.getProperty(name);
    }

    private void checkParamValue(String name, Integer failbackValue, int min, int max) {
        try {
            Integer nv;
            String cur_value = this.config.getProperty(name);
            if (cur_value != null && cur_value.length() > 0 && (nv = Integer.valueOf(cur_value)) >= min && nv <= max) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.config.setProperty(name, String.valueOf(failbackValue));
    }

    private void checkParamValue(String name, Double failbackValue, double min, double max) {
        try {
            Double nv;
            String cur_value = this.config.getProperty(name);
            if (cur_value != null && cur_value.length() > 0 && (nv = Double.valueOf(cur_value)) >= min && nv <= max) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.config.setProperty(name, String.valueOf(failbackValue));
    }

    private Integer getIntegerValue(String name) {
        return Integer.valueOf(this.config.getProperty(name));
    }

    private void readFiles() throws FileNotFoundException, IOException {
        String globalFileName = ConfigurationHelper.getGlobalConfigFileName(this.operating_system, "cdes.conf");
        if (this.instanceName.equals(JUNIT_INSTANCE_NAME)) {
            String resource = System.getProperty(JUNIT_CONF_RESOURCE_PROPERTY_NAME, JUNIT_DEFAULT_CONF_RESOURCE);
            logger.info((Object)("Configuration.readFiles(" + this.instanceName + "): Reading global config resource [" + resource + "]."));
            this.config.load(this.getClass().getClassLoader().getResourceAsStream(resource));
        } else {
            File globalFile = new File(globalFileName);
            if (globalFile.canRead()) {
                logger.info((Object)("Configuration.readFiles(" + this.instanceName + "): Reading global config file " + globalFileName));
                this.config.load(new FileInputStream(globalFile));
            } else {
                logger.error((Object)("Configuration.readFiles(" + this.instanceName + "): Cannot read global config file " + globalFileName));
            }
        }
        String instanceFileName = ConfigurationHelper.getInstanceConfigFileName(this.operating_system, this.instanceName, "cdes.conf");
        File instanceFile = new File(instanceFileName);
        if (instanceFile.canRead()) {
            logger.info((Object)("Configuration.readFiles(" + this.instanceName + "): Reading instance config file " + instanceFileName));
            this.config.load(new FileInputStream(instanceFile));
        } else {
            logger.warn((Object)("Configuration.readFiles(" + this.instanceName + "): Cannot read instance config file " + instanceFileName));
        }
    }

    public OperatingSystem getOperatingSystem() {
        return this.operating_system;
    }

    public boolean inWindows() {
        this.checkProps();
        return this.getOperatingSystem() == OperatingSystem.WINDOWS;
    }

    public String getTomcatDir() {
        this.checkProps();
        return this.getStringValue("tomcat_dir");
    }

    public String getTempDir() {
        this.checkProps();
        return this.getStringValue("temp_dir");
    }

    public String getRepositoryAttachment() {
        this.checkProps();
        return this.getStringValue("repository_attachment");
    }

    public String getRepositoryReviewcycle() {
        this.checkProps();
        return this.getStringValue("repository_reviewcycle");
    }

    public String getRepositoryUpload() {
        this.checkProps();
        return this.getStringValue("repository_upload");
    }

    public String getRepositoryLabel() {
        this.checkProps();
        return this.getStringValue("repository_label");
    }

    public String getRepositoryDocumentRef() {
        this.checkProps();
        return this.getStringValue("repository_document_ref");
    }

    public String getRepositoryOriginalDocument() {
        this.checkProps();
        return this.getStringValue("repository_original_document");
    }

    public Integer getMailutilsPollIntervalMillis() {
        this.checkProps();
        return this.getIntegerValue("mailutils_pollIntervalMillis");
    }

    public Integer getMailutilsSleepPerMailMillis() {
        this.checkProps();
        return this.getIntegerValue("mailutils_sleepPerMailMillis");
    }

    public String getMailutilsSmtphost() {
        this.checkProps();
        return this.getStringValue("mailutils_smtphost");
    }

    public String getCertOperatorDN() {
        this.checkProps();
        return this.getStringValue("cert_operator_dn");
    }

    public Integer getCertRootCAYears() {
        this.checkProps();
        return this.getIntegerValue("cert_rootca_years");
    }

    public Integer getCertUserCertYears() {
        this.checkProps();
        return this.getIntegerValue("cert_usercert_years");
    }

    public String getApplicationURL() {
        this.checkProps();
        return this.getStringValue("application_url");
    }

    public String getApplicationWelcomeString() {
        this.checkProps();
        return this.getStringValue("application_welcome_string");
    }

    public String getOOoConnectHost() {
        this.checkProps();
        return this.getStringValue("OOO_CONNECT_HOST");
    }

    public String getOOoListenHost() {
        this.checkProps();
        return this.getStringValue("OOO_LISTEN_HOST");
    }

    public Integer getOOoConnectPort() {
        this.checkProps();
        return this.getIntegerValue("OOO_CONNECT_PORT");
    }

    public Integer getOOoListenPort() {
        this.checkProps();
        return this.getIntegerValue("OOO_LISTEN_PORT");
    }

    public String getOOoConnectURL() {
        this.checkProps();
        return this.getStringValue("OOO_CONNECT_URL");
    }

    public String getOOoListenURL() {
        this.checkProps();
        return this.getStringValue("OOO_LISTEN_URL");
    }

    public String getMailUtilsSenderAdr() {
        this.checkProps();
        return this.getStringValue("mailutils_senderAdr");
    }

    public String getMailUtilsSenderName() {
        this.checkProps();
        return this.getStringValue("mailutils_senderName");
    }

    public String getDatabaseName() {
        this.checkProps();
        return this.config.getProperty("db_db");
    }

    public String getDatabaseDriver() {
        this.checkProps();
        return this.config.getProperty("db_driver");
    }

    public String getDatabaseHost() {
        this.checkProps();
        return this.config.getProperty("db_host");
    }

    public String getDatabasePassword() {
        this.checkProps();
        return this.config.getProperty("db_password");
    }

    public String getDatabaseUser() {
        this.checkProps();
        return this.config.getProperty("db_user");
    }

    public String getDatabasePort() {
        this.checkProps();
        return this.config.getProperty("db_port");
    }

    public String getDatabaseURL() {
        this.checkProps();
        return this.config.getProperty("db_url");
    }

    public String getTempExtractDbName() {
        this.checkProps();
        return this.config.getProperty("temporary_extract_db_name");
    }

    public boolean isTiledPngPopupEnabled() {
        return "yes".equals(this.getStringValue("enable_png_tiled_preview"));
    }

    public boolean isReleasedPlanDeliverCatalogueEditModeEnabled() {
        return "yes".equals(this.getStringValue("enable_released_pdc_editing"));
    }

    public boolean isLocaleSelectionEnabled() {
        return "yes".equals(this.getStringValue("enable_locale_selection"));
    }

    public boolean isEnableCustomerLogo() {
        return "yes".equals(this.getStringValue("enable_customer_logo"));
    }

    public boolean isAsBuiltEditorEnabled() {
        return "yes".equals(this.getStringValue("show_as_built_links"));
    }

    public boolean isEmailAttachmentFilesizePermitted(int attachmentFilesize) {
        int maxFilesize = Integer.parseInt(this.config.getProperty("max_email_attachment_filesize"));
        return attachmentFilesize <= maxFilesize;
    }

    public String getMaxEmailAttachmentFilesize() {
        int maxFilesize = Integer.parseInt(this.config.getProperty("max_email_attachment_filesize"));
        double maxFilesizeInMb = (float)maxFilesize / 1024.0f / 1024.0f;
        DecimalFormat formatter = new DecimalFormat("#0.00");
        return formatter.format(maxFilesizeInMb);
    }

    public int getOutdatedFilesRemoverExecutionHour() {
        return Integer.parseInt(this.config.getProperty("outdated_files_remover_execution_hour"));
    }

    public int getArchiveJobExpirationDays() {
        return Integer.parseInt(this.config.getProperty("archive_job_expiration_days"));
    }

    public int getOriginalDocumentExpirationDays() {
        return Integer.parseInt(this.config.getProperty("original_document_expiration_days"));
    }

    public int useDocumentSubtypes() {
        return Integer.parseInt(this.config.getProperty("use_document_subtypes"));
    }

    public int getMaximumArchiveDownloadSize() {
        return Integer.parseInt(this.config.getProperty("max_archive_download_size"));
    }

    public boolean reversePreduration() {
        return "yes".equals(this.getStringValue("reverse_preduration"));
    }

    public String getGWTRedirectUrl() {
        String url = this.getStringValue("gwt_redirect_url");
        return url;
    }
}

