/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeListener;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.mail.EMail;
import at.cdes.bo.data.mail.EMailAttachment;
import at.cdes.bo.data.mail.EMailSnippet;
import at.cdes.bo.data.mail.EMailSnippetVisitor;
import at.cdes.bo.data.mail.FutureEMail;
import at.cdes.bo.data.mail.FutureEMailVisitor;
import at.cdes.bo.data.mail.MailModes;
import at.cdes.bo.data.mail.NodeListenerEMailSnippet;
import at.cdes.bo.data.mail.StatusEMailSnippet;
import at.cdes.bo.data.mail.TaskEMailSnippet;
import at.cdes.bo.data.mail.TaskFutureEMail;
import at.cdes.bo.data.meta.PlanningNotificationDateMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationTextMetaInformation;
import at.cdes.bo.data.object.CDESObject;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.planningNotification.PlanningNotification;
import at.cdes.bo.data.planningNotification.PlanningNotificationOrder;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.task.DocumentTask;
import at.cdes.bo.data.task.DocumentVersionTask;
import at.cdes.bo.data.task.OriginalDocumentTask;
import at.cdes.bo.data.task.OriginalDocumentTaskDone;
import at.cdes.bo.data.task.PlotOrderAcceptanceTask;
import at.cdes.bo.data.task.PlotOrderAcceptanceTaskDone;
import at.cdes.bo.data.task.ReviewCycleEntryTask;
import at.cdes.bo.data.task.ReviewCycleEntryTaskDone;
import at.cdes.bo.data.task.ReviewCyclePlottTask;
import at.cdes.bo.data.task.ReviewCyclePlottTaskDone;
import at.cdes.bo.data.task.ReviewableTask;
import at.cdes.bo.data.task.ReviewableTaskDone;
import at.cdes.bo.data.task.SelectCellConnectionTask;
import at.cdes.bo.data.task.SelectCellConnectionTaskDone;
import at.cdes.bo.data.task.Task;
import at.cdes.bo.data.task.TaskVisitor;
import at.cdes.bo.data.workflow.WorkflowActivity;
import at.cdes.bo.data.workflow.WorkflowActivityHistoryEntry;
import at.cdes.bo.data.workflow.WorkflowActivityNotificationSnippet;
import at.cdes.bo.data.workflow.WorkflowActivityNotificationSnippetComparator;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.data.workflow.WorkflowActivitySortingHelper;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.bo.mime.MimeSourceFactory;
import at.cdes.bo.service.JobInfo;
import at.cdes.controller.actionhandler.login.URLMapper;
import at.cdes.controller.helper.DataSourceHelper;
import at.cdes.db.dao.CertificateDAO;
import at.cdes.db.dao.EMailAttachmentDAO;
import at.cdes.db.dao.EMailDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.PlanningNotificationDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.WorkflowActivityNotificationSnippetDAO;
import at.cdes.db.dao.WorkflowEntityDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.service.MailOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.EMailAttachmentSizeException;
import at.cdes.util.DateHelper;
import at.cdes.util.ParameterHelper;
import at.cdes.util.TapestryI18nHelper;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.UnsupportedDataTypeException;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.clazzes.fancymail.mail.EMailException;
import org.clazzes.fancymail.mail.IEMail;
import org.clazzes.fancymail.mail.SimpleEMail;
import org.clazzes.util.comparators.InvalidExpressionSyntaxException;
import org.clazzes.util.comparators.POJOComparatorFactory;
import org.clazzes.util.datetime.ISO8601Format;
import org.clazzes.util.datetime.UtcTimestamp;
import org.hibernate.proxy.HibernateProxy;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.xnap.commons.i18n.I18n;

public class MailOperationsImpl
implements MailOperations {
    private EMailDAO mailDAO;
    private EMailAttachmentDAO mailAttachmentDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private CertificateDAO certificateDAO;
    private String senderAdr;
    private String senderName;
    private String applicationName;
    private String debugMailDestination;
    private Bundle blueprintBundle;
    private URLMapper urlMapper;
    private MimeSourceFactory mimeSourceFactory;
    protected ProjectParticipationDAO projectParticipationDAO;
    private HolidayCalculatorFactory holidayCalculatorFactory;
    private WorkflowActivityNotificationSnippetDAO workflowActivityNotificationSnippetDAO;
    private PlanningNotificationDAO planningNotificationDAO;
    private WorkflowEntityDAO workflowEntityDAO;
    private int maxEmailAttachmentFilesize;
    private static final String LINE_BREAK = "\r\n";
    private static final String INDENT = "  ";
    private static Logger logger = Logger.getLogger(MailOperationsImpl.class);

    public MailOperationsImpl() {
        logger.info((Object)"Add mailcap MIME entries to javax.mail (workaround for CDES-1679).");
        MailcapCommandMap mc = new MailcapCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    @Override
    public void createSimpleMail(String to_mailadr, String to_mailname, String subject, CharSequence body) {
        String[] toAddresses = this.getSeparatedEmailAddresses(to_mailadr);
        for (int i = 0; i < toAddresses.length; ++i) {
            EMail mail = new EMail();
            mail.setStatus(2);
            mail.setSender(this.buildSenderIA());
            mail.setToAdr(toAddresses[i]);
            mail.setToName(to_mailname);
            mail.setSubject(subject);
            mail.setBody(body.toString());
            mail.setCreated(Calendar.getInstance().getTime());
            this.mailDAO.insert(mail);
        }
    }

    @Override
    public void createSimpleMailReply2(String to_mailadr, String to_mailname, String subject, CharSequence body, String reply_mailadr) {
        String[] toAddresses = this.getSeparatedEmailAddresses(to_mailadr);
        for (int i = 0; i < toAddresses.length; ++i) {
            EMail mail = new EMail();
            mail.setStatus(2);
            mail.setSender(this.buildSenderIA());
            mail.setToAdr(toAddresses[i]);
            mail.setToName(to_mailname);
            mail.setSubject(subject);
            mail.setBody(body.toString());
            mail.setReplyToAdr(reply_mailadr);
            mail.setCreated(Calendar.getInstance().getTime());
            this.mailDAO.insert(mail);
        }
    }

    @Override
    public void createSimpleMailReply(OrganisationPerson toOrgPerson, String subject, CharSequence body, String replyTo) {
        String[] toAddresses = this.getSeparatedEmailAddresses(toOrgPerson.getEmailAddress());
        for (int i = 0; i < toAddresses.length; ++i) {
            EMail mail = new EMail();
            mail.setStatus(2);
            mail.setSender(this.buildSenderIA());
            mail.setToAdr(toAddresses[i]);
            mail.setToName(toOrgPerson.getPerson().getCommonName());
            mail.setSubject(subject);
            mail.setBody(body.toString());
            mail.setOrganisationPerson(toOrgPerson);
            mail.setReplyToAdr(replyTo);
            mail.setCreated(Calendar.getInstance().getTime());
            this.mailDAO.insert(mail);
        }
    }

    @Override
    public EMail createSimpleMailSingleReceiver(String to_mailadr, String to_mailname, String subject, CharSequence body) {
        EMail mail = new EMail();
        mail.setStatus(2);
        mail.setSender(this.buildSenderIA());
        mail.setToAdr(to_mailadr);
        mail.setToName(to_mailname);
        mail.setSubject(subject);
        mail.setBody(body.toString());
        mail.setCreated(Calendar.getInstance().getTime());
        return this.mailDAO.insert(mail);
    }

    @Override
    public boolean createLateTaskFutureEmail(ProjectParticipation participation, Task task) {
        HolidayCalculator holicalc = this.holidayCalculatorFactory.getInstance(participation.getProject());
        int daysBetween = holicalc.getWorkingDaysBetween(task.getEndDate(), Calendar.getInstance());
        if (daysBetween == 0) {
            return false;
        }
        UtcTimestamp sendTime = new UtcTimestamp(task.getEndDate());
        TaskFutureEMail ts = new TaskFutureEMail();
        ts.setType(-2);
        ts.setParticipationId(participation.getId());
        ts.setTask(task);
        ts.setSendTime(sendTime.toCalendar());
        this.mailDAO.insertFutureEMail(ts);
        return true;
    }

    public EMailDAO getMailDAO() {
        return this.mailDAO;
    }

    public void setMailDAO(EMailDAO md) {
        this.mailDAO = md;
    }

    @Override
    public void insertMail(EMail m) {
        this.mailDAO.insert(m);
    }

    @Override
    public void updateMail(EMail m) {
        this.mailDAO.update(m);
    }

    @Override
    public void deleteMail(EMail m) {
        List<EMailAttachment> attachments = this.mailAttachmentDAO.getAllForEMail(m.getId());
        for (EMailAttachment attachment : attachments) {
            this.mailAttachmentDAO.delete(attachment);
        }
        this.mailDAO.delete(m);
    }

    public String getSenderAdr() {
        return this.senderAdr;
    }

    public void setSenderAdr(String senderAdr) {
        this.senderAdr = senderAdr;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        if (senderName.startsWith("\"")) {
            senderName = senderName.substring(1);
        }
        if (senderName.endsWith("\"")) {
            senderName = senderName.substring(0, senderName.length() - 1);
        }
        this.senderName = senderName;
    }

    protected InternetAddress buildSenderIA() {
        InternetAddress sender;
        if (this.getSenderName() != null && this.getSenderName().length() > 0) {
            try {
                sender = new InternetAddress(this.getSenderAdr(), this.getSenderName());
            }
            catch (UnsupportedEncodingException e) {
                Object sender2 = null;
                throw new RuntimeException("Encoding problem, should be impossible.");
            }
        }
        try {
            sender = new InternetAddress(this.getSenderAdr());
        }
        catch (AddressException e) {
            throw new RuntimeException("Invalid sender email address", e);
        }
        return sender;
    }

    private void makeSnippetEMail(List<EMailSnippet> emailSnippets, Integer organisationPersonId) {
        OrganisationPerson organisationPerson = this.organisationPersonDAO.get(organisationPersonId);
        Locale locale = new Locale(organisationPerson.getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        HashMap<Integer, ProjectSnippets> ps = new HashMap<Integer, ProjectSnippets>();
        if (emailSnippets != null) {
            for (EMailSnippet snippet : emailSnippets) {
                Project prj = snippet.getProject();
                if (!ps.containsKey(prj.getId())) {
                    ps.put(prj.getId(), new ProjectSnippets(prj));
                }
                ((ProjectSnippets)ps.get(prj.getId())).addSnippet(snippet);
                this.mailDAO.deleteSnippet(snippet);
            }
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        boolean is_empty = true;
        sb.append(String.format(locale, i18n.tr("Automatisch generiertes e-mail durch %s."), this.applicationName));
        sb.append(LINE_BREAK);
        sb.append(LINE_BREAK);
        for (ProjectSnippets p : ps.values()) {
            if (!p.format(++i, sb, locale, i18n, organisationPersonId)) continue;
            is_empty = false;
        }
        if (!is_empty) {
            String applicationUrl = this.urlMapper.getURL(organisationPerson);
            sb.append(LINE_BREAK);
            sb.append(LINE_BREAK);
            sb.append(String.format(locale, i18n.tr("Sie erreichen die Planpr\u00fcfplattform unter dem link %s"), applicationUrl));
            sb.append(LINE_BREAK);
            sb.append(LINE_BREAK);
            sb.append("_________________________________________");
            sb.append(LINE_BREAK);
            sb.append(i18n.tr("generiert durch Planpr\u00fcfplattform c.des"));
            sb.append(LINE_BREAK);
            this.createSimpleMailReply(organisationPerson, this.applicationName, sb, null);
        }
    }

    public void setHolidayCalculatorFactory(HolidayCalculatorFactory holidayCalculatorFactory) {
        this.holidayCalculatorFactory = holidayCalculatorFactory;
    }

    public HolidayCalculatorFactory getHolidayCalculatorFactory() {
        return this.holidayCalculatorFactory;
    }

    @Override
    public void createSnippetsFromFutureEMails(Calendar now) {
        List<FutureEMail> futureMails = this.mailDAO.getFutureMailsToSend(now);
        TreeMap futuresByOPId = new TreeMap();
        for (FutureEMail femail : futureMails) {
            ProjectParticipation participation = this.projectParticipationDAO.get(femail.getParticipationId());
            if (participation.getStatus() != 0) {
                this.mailDAO.deleteFutureEMail(femail);
                continue;
            }
            ArrayList<ProjectParticipant> projectParticipants = new ArrayList<ProjectParticipant>();
            if (femail.isMainParticipantOnly()) {
                projectParticipants.add(participation.getMainParticipant());
            } else {
                projectParticipants.addAll(participation.getProjectParticipants().values());
            }
            for (ProjectParticipant p : projectParticipants) {
                Integer orgPId = p.getOrganisationPerson().getId();
                if (!futuresByOPId.containsKey(orgPId)) {
                    futuresByOPId.put(orgPId, new LinkedList());
                }
                ((List)futuresByOPId.get(orgPId)).add(femail);
            }
        }
        for (Integer opId : futuresByOPId.keySet()) {
            OrganisationPerson op = this.organisationPersonDAO.get(opId);
            if (op.getEmailSendMode().equals(MailModes.NEVER) || op.isInActive()) continue;
            List fms = (List)futuresByOPId.get(opId);
            for (FutureEMail fm : fms) {
                Calendar sendTime = fm.getSendTime();
                if (op.getEmailSendTime() != null && MailModes.BRIEF.equals(op.getEmailSendMode())) {
                    if (sendTime.before(now)) {
                        sendTime = new GregorianCalendar();
                        sendTime.set(11, 0);
                        sendTime.set(12, 0);
                        sendTime.set(13, 0);
                    }
                    sendTime.add(12, op.getEmailSendTime());
                    if (sendTime.before(now)) {
                        sendTime.add(5, 1);
                    }
                }
                TaskEMailSnippet ts = new TaskEMailSnippet();
                ts.setOrganisationPersonId(opId);
                ts.setSendTime(sendTime);
                ts.setTask(((TaskFutureEMail)fm).getTask());
                ts.setType(((TaskFutureEMail)fm).getType());
                this.mailDAO.insertSnippet(ts);
            }
        }
        for (FutureEMail fm : futureMails) {
            this.mailDAO.deleteFutureEMail(fm);
        }
    }

    @Override
    public void collectSnippets(Calendar now) {
        EMailSnippet snippet;
        List snippets = this.mailDAO.getSnippetsToSend(now);
        Iterator it = snippets.iterator();
        Integer organisationPersonId = null;
        ArrayList<EMailSnippet> emailSnippets = null;
        do {
            EMailSnippet eMailSnippet = snippet = it.hasNext() ? (EMailSnippet)it.next() : null;
            if (!(organisationPersonId == null || snippet != null && snippet.getOrganisationPersonId().equals(organisationPersonId))) {
                this.makeSnippetEMail(emailSnippets, organisationPersonId);
                emailSnippets = null;
                if (snippet != null && Thread.currentThread().isInterrupted()) {
                    logger.warn((Object)"collectSnippets: Stopping prematurely due to a stop request.");
                    return;
                }
            }
            if (snippet == null) continue;
            if (emailSnippets == null) {
                emailSnippets = new ArrayList<EMailSnippet>();
                organisationPersonId = snippet.getOrganisationPersonId();
            }
            emailSnippets.add(snippet);
        } while (snippet != null);
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO ppDAO) {
        this.projectParticipationDAO = ppDAO;
    }

    public void setApplicationName(String applicationName) {
        if (applicationName.startsWith("\"")) {
            applicationName = applicationName.substring(1);
        }
        if (applicationName.endsWith("\"")) {
            applicationName = applicationName.substring(0, applicationName.length() - 1);
        }
        this.applicationName = applicationName;
    }

    @Override
    public void createBroadcastMail(String subject, String message, List<OrganisationPerson> receivers, String replyTo) {
        for (OrganisationPerson receiver : receivers) {
            this.createSimpleMailReply(receiver, subject, message, replyTo);
        }
    }

    public Collection<? extends IEMail> getMailsToSend() throws EMailException {
        Version version;
        List mails = this.mailDAO.getNextToSend();
        if (this.debugMailDestination != null && this.debugMailDestination.length() > 0 && (version = this.blueprintBundle.getVersion()).toString().endsWith("SNAPSHOT")) {
            Vector<InternetAddress> to = new Vector<InternetAddress>();
            try {
                to.add(new InternetAddress(this.debugMailDestination));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (IEMail mail : mails) {
                if (mail instanceof SimpleEMail) {
                    SimpleEMail simpleEmail = (SimpleEMail)mail;
                    logger.info((Object)("Sending SimpleEMail to " + this.debugMailDestination + "] because of debug setting."));
                    simpleEmail.setRecipientsTo(to);
                    if (simpleEmail.getRecipientsCc() != null) {
                        simpleEmail.setRecipientsCc(to);
                    }
                    if (simpleEmail.getRecipientsBcc() == null) continue;
                    simpleEmail.setRecipientsBcc(to);
                    continue;
                }
                if (!(mail instanceof EMail)) continue;
                EMail defaultMail = (EMail)mail;
                logger.info((Object)("Sending EMail [" + defaultMail.getId() + "] to " + this.debugMailDestination + "] because of debug setting."));
                defaultMail.setToAdr(this.debugMailDestination);
                if (defaultMail.getToCCAdr() != null) {
                    defaultMail.setToCCAdr(this.debugMailDestination);
                }
                if (defaultMail.getToBCCAdr() == null) continue;
                defaultMail.setToBCCAdr(this.debugMailDestination);
            }
        }
        return mails;
    }

    public void reportMailTransmissionAttempt(IEMail mail) {
        if (mail instanceof EMail) {
            EMail email = (EMail)mail;
            if (email.isSent()) {
                email.setStatus(6);
                email.setLastErrorText("2xx OK EMail Sent");
                email.setSentAt(new Date());
            } else {
                email.setStatus(7);
                email.setSentAt(null);
                email.setErrorCount(email.getErrorCount() + 1);
            }
            if (email.getId() == null) {
                this.mailDAO.insert(email);
            } else {
                this.mailDAO.update(email);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillMimeMessage(MimeMessage mm, IEMail withEMail) throws EMailException, MessagingException {
        if (!(withEMail instanceof EMail)) {
            throw new EMailException("Unsupported IEmail type [" + withEMail.getClass() + "].");
        }
        EMail email = (EMail)withEMail;
        IMimeInputStream mimeStream = null;
        try {
            List<EMailAttachment> attachments;
            mm.setSubject(email.getSubject(), "UTF-8");
            InternetAddress sender = email.getSender();
            if (sender == null) {
                sender = this.buildSenderIA();
            }
            mm.setSender((Address)sender);
            mm.setFrom((Address)sender);
            String replyToAdr = email.getReplyToAdr();
            if (replyToAdr != null) {
                Address[] replyToArr = new Address[]{new InternetAddress(replyToAdr)};
                mm.setReplyTo(replyToArr);
            }
            String toName = email.getToName();
            InternetAddress rcpt = null;
            if (toName != null && toName.length() > 0) {
                try {
                    rcpt = new InternetAddress(email.getToAdr(), toName, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new EMailException("Encoding problem, should be impossible.");
                }
            } else {
                rcpt = new InternetAddress(email.getToAdr());
            }
            mm.addRecipient(Message.RecipientType.TO, (Address)rcpt);
            if (email.getToCCAdr() != null) {
                mm.addRecipients(Message.RecipientType.CC, email.getToCCAdr());
            }
            if (email.getToBCCAdr() != null) {
                mm.addRecipients(Message.RecipientType.BCC, email.getToBCCAdr());
            }
            if ((attachments = this.mailAttachmentDAO.getAllForEMail(email.getId())) != null && attachments.size() > 0) {
                try {
                    MimeMultipart mimeMultipart = new MimeMultipart();
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setText(email.getBody());
                    mimeMultipart.addBodyPart((BodyPart)bodyPart);
                    for (EMailAttachment attachment : attachments) {
                        MimeBodyPart attachmentPart = new MimeBodyPart();
                        VisitlessMimeSource mimeSource = this.mimeSourceFactory.getMimeSource(attachment.getMimeSource());
                        Object[] parameters = ParameterHelper.parseParametersString(attachment.getParameters());
                        mimeStream = mimeSource.getMimeStream(parameters);
                        DataSource dataSource = DataSourceHelper.toDataSource(mimeStream);
                        attachmentPart.setDataHandler(new DataHandler(dataSource));
                        attachmentPart.setDescription(mimeStream.getPrettyName(), "UTF8");
                        attachmentPart.setFileName(mimeStream.getPrettyName());
                        mimeMultipart.addBodyPart((BodyPart)attachmentPart);
                    }
                    mm.setContent((Multipart)mimeMultipart);
                }
                catch (PreviewException e) {
                    logger.warn((Object)("Error constructing email attachment(email.id=" + email.getId() + ")."), (Throwable)e);
                    throw new EMailException("Error constructing email attachment", (Throwable)e);
                }
                catch (UnsupportedDataTypeException e) {
                    logger.error((Object)("UnsupportedDataTypeException constructing email attachment(email.id=" + email.getId() + ")."), (Throwable)e);
                    throw new EMailException("UnsupportedDataTypeException constructing email attachment", (Throwable)e);
                }
            } else {
                mm.setText(email.getBody(), "UTF-8");
            }
            email.setMimeInputStream(mimeStream);
            mimeStream = null;
        }
        finally {
            try {
                if (mimeStream != null) {
                    mimeStream.close();
                }
            }
            catch (Throwable e) {
                logger.warn((Object)"Error closing MIME input stream upon mail retrieval error", e);
            }
        }
    }

    public void setMailAttachmentDAO(EMailAttachmentDAO mailAttachmentDao) {
        this.mailAttachmentDAO = mailAttachmentDao;
    }

    @Override
    public void createAttachmentMailForProjectParticipation(DocumentVersion documentVersion, ProjectParticipation pp) {
        String toAdr = pp.getAttachmentEmailAddress();
        if (toAdr == null || toAdr.length() <= 0) {
            return;
        }
        Object[] parameters = new Object[]{documentVersion.getId()};
        String toName = pp.getMainParticipant().getOrganisationPerson().getPerson().getCommonName();
        Locale locale = new Locale(pp.getMainParticipant().getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        logger.info((Object)("creating attachment mail for ProjectParticipationID [" + pp.getId() + "]"));
        StringBuffer sb = new StringBuffer();
        ObjectPlanner objectPlanner = documentVersion.getDocument().getObjectPlanner();
        CDESObject object = objectPlanner.getObject();
        SubProject subProject = object.getObjectList().getSubProject();
        Project project = subProject.getProject();
        sb.append(i18n.tr("Netzwerk") + " " + project.getNetwork().getName() + "\n");
        sb.append(i18n.tr("Projekt") + " " + project.getCode() + "/" + project.getName() + "\n");
        sb.append(i18n.tr("Subprojekt") + " " + subProject.getCode() + "/" + subProject.getName() + "\n");
        sb.append(i18n.tr("Objekt") + " " + object.getCode() + "/" + object.getName() + "\n");
        sb.append(i18n.tr("Objektblatt") + " " + objectPlanner.getCode() + "/" + objectPlanner.getArea() + "\n");
        sb.append(i18n.tr("Plannummer") + " " + documentVersion.getName() + "\n");
        if (toAdr.contains(";")) {
            toAdr = toAdr.replaceAll(";", ",");
        }
        String[] toAddresses = toAdr.split(",");
        for (int i = 0; i < toAddresses.length; ++i) {
            if (toAddresses[i].length() <= 0) continue;
            this.createAttachmentMail(toAddresses[i], toName, i18n.tr("Planzustellung c.des"), sb, "documentVersionPdfMimeSource", parameters, pp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAttachmentMail(String to_mailadr, String to_mailname, String subject, CharSequence body, String mimeSourceName, Object[] parameters, ProjectParticipation pp) {
        long attachmentFilesize = 0L;
        VisitlessMimeSource mimeSource = this.mimeSourceFactory.getMimeSource(mimeSourceName);
        IMimeInputStream mimeStream = null;
        try {
            mimeStream = mimeSource.getMimeStream(parameters);
            attachmentFilesize = mimeStream.getStreamSize();
            Integer documentVersionId = (Integer)parameters[0];
            logger.info((Object)("creating attachment mail for [" + to_mailname + "] with address [" + to_mailadr + "], documentVersionId [" + documentVersionId + ": attachmentFilesize=[" + attachmentFilesize + "]"));
            if (attachmentFilesize > (long)this.maxEmailAttachmentFilesize) {
                throw new EMailAttachmentSizeException();
            }
        }
        catch (Exception e) {
            if (e instanceof EMailAttachmentSizeException) {
                logger.error((Object)("Error in creating attachment email - maximum filesize exceeded (filesize=[" + attachmentFilesize + "])"), (Throwable)e);
                Collection participants = pp.getProjectParticipants().values();
                for (ProjectParticipant part : participants) {
                    if (part.getOrganisationPerson().isInActive()) continue;
                    Locale locale = new Locale(part.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
                    I18n i18n = I18nFactory.getI18n(locale);
                    StringBuilder sb = new StringBuilder();
                    Formatter formatter = new Formatter(sb, locale);
                    formatter.format(i18n.tr("Im Zuge eines automatischen Benachrichtigungsereignisses durch die Planpr\u00fcfplattform c.des ist das gew\u00fcnschte Versenden des folgenden Planes als Dateianhang fehlgeschlagen, da die maximale Dateigr\u00f6\u00dfe von %1$s bytes \u0fcberschritten wurde. Bitte laden Sie den Plan manuell \u00fcber die %2$s-Plattform herunter.\n\n"), this.maxEmailAttachmentFilesize, this.applicationName);
                    this.createSimpleMailSingleReceiver(part.getOrganisationPerson().getEmailAddress(), part.getOrganisationPerson().getPerson().getCommonName(), subject, "*** " + i18n.tr("Automatische Planzustellung durch Planpr\u00fcfplattform c.des") + " ***\n\n" + sb.toString() + body + "\n_________________________________________\n" + i18n.tr("generiert durch Planpr\u00fcfplattform c.des"));
                }
                return;
            }
            logger.error((Object)"Error in testing attachment file size", (Throwable)e);
        }
        finally {
            if (mimeStream != null) {
                try {
                    mimeStream.close();
                }
                catch (Throwable e) {
                    logger.warn((Object)"Error closing attachment stream", e);
                }
            }
        }
        Locale locale = new Locale(pp.getProject().getLocalisation().getCountry().getCode2());
        I18n i18n = I18nFactory.getI18n(locale);
        EMail email = this.createSimpleMailSingleReceiver(to_mailadr, to_mailname, subject, "*** " + i18n.tr("Automatische Planzustellung durch Planpr\u00fcfplattform c.des") + " ***\n\n" + body + "\n_________________________________________\n" + i18n.tr("generiert durch Planpr\u00fcfplattform c.des"));
        EMailAttachment attachment = new EMailAttachment();
        attachment.setEMail(email);
        attachment.setMimeSource(mimeSourceName);
        try {
            attachment.setParameters(ParameterHelper.constructParametersString(parameters));
        }
        catch (UnsupportedDataTypeException e) {
            throw new RuntimeException("Invalid parameters", e);
        }
        this.mailAttachmentDAO.insert(attachment);
    }

    @Override
    public void createJobNotificationMail(JobInfo job, String subject, String body) {
        if (job == null) {
            logger.error((Object)"Can't send E-Mail, job is null.");
            return;
        }
        Integer certId = job.getCertificateId();
        if (job == null) {
            logger.error((Object)"Can't send E-Mail, certId is null.");
            return;
        }
        if (certId == null) {
            logger.error((Object)("Can't send E-Mail, No Certificate found for job [" + job.getMethodName() + ", certId=null."));
            return;
        }
        CDESCertificate cert = this.certificateDAO.get(certId);
        if (cert == null) {
            logger.error((Object)("Can't send E-Mail, No Certificate found for job [" + job.getMethodName() + ", certId=[" + certId + "]."));
            return;
        }
        OrganisationPerson op = cert.getOrganisationPerson();
        if (op == null) {
            logger.error((Object)("Can't send E-Mail, No OrganisationPerson found for job [" + job.getMethodName() + "], certId=[" + certId + "]."));
            return;
        }
        this.createSimpleMailReply(op, subject, body, this.senderAdr);
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    @Override
    public List getEmails(String receiverAddress, Integer status, Date from, Date to, Integer limit, Date createdFrom, Date createdTo, String sortColumn, boolean ascending) {
        return this.mailDAO.getEmails(receiverAddress, status, from, to, limit, createdFrom, createdTo, sortColumn, ascending);
    }

    @Override
    public EMail getEmail(Integer id) {
        return this.mailDAO.get(id);
    }

    public void setMimeSourceFactory(MimeSourceFactory mimeSourceFactory) {
        this.mimeSourceFactory = mimeSourceFactory;
    }

    public void setUrlMapper(URLMapper urlMapper) {
        this.urlMapper = urlMapper;
    }

    @Override
    public void deleteOrganisationPersonReferences(Integer orgPersonId) {
        List<EMail> mails = this.mailDAO.getAllEmailsForOrganisationPerson(orgPersonId);
        for (EMail mail : mails) {
            mail.setOrganisationPerson(null);
            this.mailDAO.update(mail);
        }
    }

    @Override
    public void deleteAllLateTaskFutureEmailsForParticipationId(Integer participationId) {
        Collection<TaskFutureEMail> futureMailsOfProjectParticipation = this.mailDAO.getFutureMailsOfProjectParticipation(participationId);
        for (FutureEMail futureEMail : futureMailsOfProjectParticipation) {
            this.mailDAO.deleteFutureEMail(futureEMail);
        }
    }

    @Override
    public void createLateTaskEmails(List<OrganisationPerson> recipients, List<Task> allLateTasksOfProject, Project project) {
        for (OrganisationPerson organisationPerson : recipients) {
            organisationPerson = this.organisationPersonDAO.get(organisationPerson.getId());
            Locale locale = new Locale(organisationPerson.getPerson().getPersonVariables(false).getUserLocale());
            I18n i18n = I18nFactory.getI18n(locale);
            StringBuffer sb = new StringBuffer();
            sb.append(String.format(locale, i18n.tr("Automatisch generiertes e-mail durch %s."), this.applicationName));
            sb.append(LINE_BREAK);
            sb.append(LINE_BREAK);
            sb.append(i18n.tr("Folgende von Ihnen \u00fcberwachte Aufgaben sind versp\u00e4tet:"));
            sb.append(LINE_BREAK);
            sb.append("Projekt: " + project.getCode() + " - " + project.getName() + " [" + project.getNetwork().getName() + "]");
            sb.append(LINE_BREAK);
            sb.append(LINE_BREAK);
            for (Task task : allLateTasksOfProject) {
                ProjectParticipation participation;
                DocumentVersion documentVersion = null;
                Document document = null;
                ProjectParticipant responsibleParticipant = null;
                if (task instanceof ReviewableTask) {
                    documentVersion = ((ReviewableTask)task).getDocumentVersion();
                    document = documentVersion.getDocument();
                    participation = this.projectParticipationDAO.get(((ReviewableTask)task).getProjectParticipationId());
                    responsibleParticipant = participation.getMainParticipant();
                } else if (task instanceof ReviewCycleEntryTask) {
                    document = ((ReviewCycleEntryTask)task).getDocument();
                    participation = this.projectParticipationDAO.get(((ReviewCycleEntryTask)task).getProjectParticipationId());
                    responsibleParticipant = participation.getMainParticipant();
                } else if (task instanceof SelectCellConnectionTask) {
                    documentVersion = ((SelectCellConnectionTask)task).getDocumentVersion();
                    document = documentVersion.getDocument();
                    participation = this.projectParticipationDAO.get(((SelectCellConnectionTask)task).getProjectParticipationId());
                    responsibleParticipant = participation.getMainParticipant();
                } else {
                    logger.debug((Object)("Unable to determine Type of task with id [" + task.getId() + "]."));
                    continue;
                }
                CDESObject obj = document.getObjectPlanner().getObject();
                ReviewCycleNode node = null;
                if (documentVersion != null) {
                    node = documentVersion.getActualReviewCycleNode();
                }
                sb.append(INDENT);
                sb.append(INDENT);
                if (documentVersion == null) {
                    sb.append(" " + i18n.tr("Plan") + ": " + document.getName());
                } else {
                    sb.append(" " + i18n.tr("Plan") + ": " + documentVersion.getName());
                }
                sb.append(" " + TapestryI18nHelper.getLocaleString(document.getContent(), i18n.getResources().getLocale().getLanguage()));
                sb.append(LINE_BREAK);
                if (task instanceof DocumentTask) {
                    sb.append(i18n.tr("Aufenthalt") + ": " + task.getName());
                    sb.append(LINE_BREAK);
                } else {
                    sb.append(i18n.tr("Aufenthalt") + ": " + TapestryI18nHelper.getLocaleString(node.getReviewCycleCell().getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(" - ");
                    sb.append(TapestryI18nHelper.getLocaleString(node.getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(LINE_BREAK);
                }
                if (task.getEndDate() != null) {
                    sb.append(INDENT);
                    sb.append("Termin: " + new UtcTimestamp(task.getEndDate()).toString(ISO8601Format.DATE_FORMAT));
                    sb.append(LINE_BREAK);
                }
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(i18n.tr("verantwortlich") + ": " + responsibleParticipant.getOrganisationPerson().getOrganisation().getName() + " (" + responsibleParticipant.getOrganisationPerson().getPerson().getCommonName() + ")");
                sb.append(LINE_BREAK);
                sb.append(LINE_BREAK);
            }
            String applicationUrl = this.urlMapper.getURL(organisationPerson);
            sb.append(LINE_BREAK);
            sb.append(String.format(locale, i18n.tr("Sie erreichen die Planpr\u00fcfplattform unter dem link %s"), applicationUrl));
            sb.append(LINE_BREAK);
            sb.append(LINE_BREAK);
            sb.append("_________________________________________");
            sb.append(LINE_BREAK);
            sb.append(i18n.tr("generiert durch Planpr\u00fcfplattform c.des"));
            sb.append(LINE_BREAK);
            this.createSimpleMailReply(organisationPerson, "c.des concurrent design", sb.toString(), null);
        }
    }

    private String[] getSeparatedEmailAddresses(String addressString) {
        if (addressString.contains(";")) {
            addressString = addressString.replaceAll(";", ",");
        }
        return addressString.split(",");
    }

    public void setMaxEmailAttachmentFilesize(int size) {
        this.maxEmailAttachmentFilesize = size;
    }

    @Override
    public void createWorkflowActivityNotificationSnippets() {
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<WorkflowActivityNotificationSnippet> snippets = this.workflowActivityNotificationSnippetDAO.getAllBeforeNow();
        HashMap snippetsByOrgPerson = new HashMap();
        for (WorkflowActivityNotificationSnippet snippet : snippets) {
            if (snippetsByOrgPerson.get(snippet.getOrganisationPerson().getId()) == null) {
                snippetsByOrgPerson.put(snippet.getOrganisationPerson().getId(), new ArrayList());
            }
            ((List)snippetsByOrgPerson.get(snippet.getOrganisationPerson().getId())).add(snippet);
        }
        for (List usersSnippets : snippetsByOrgPerson.values()) {
            ArrayList<Integer> processedWorkflowActivityIds = new ArrayList<Integer>();
            OrganisationPerson orgPerson = ((WorkflowActivityNotificationSnippet)usersSnippets.get(0)).getOrganisationPerson();
            Locale locale = new Locale(orgPerson.getPerson().getPersonVariables(false).getUserLocale());
            Map<Integer, List<WorkflowActivityNotificationSnippet>> activitiesByPlanningNotification = WorkflowActivitySortingHelper.sortByPlanningNotification(usersSnippets);
            I18n i18n = I18nFactory.getI18n(locale);
            StringBuffer sb = new StringBuffer();
            sb.append(String.format(locale, i18n.tr("Automatisch generiertes e-mail durch %s."), this.applicationName));
            sb.append(LINE_BREAK);
            sb.append(LINE_BREAK);
            sb.append(i18n.tr("Im Bescheid\u00fcberwachungskatalog wurden folgende Aktivit\u00e4ten durchgef\u00fchrt:"));
            sb.append(LINE_BREAK);
            for (Integer planningNotificationId : activitiesByPlanningNotification.keySet()) {
                PlanningNotification pn = this.planningNotificationDAO.get(planningNotificationId);
                String networkName = pn.getNetwork().getName();
                String projectsName = "";
                for (Project project : pn.getAssociatedProjects().values()) {
                    projectsName = projectsName + project.getName() + " ";
                }
                sb.append(LINE_BREAK);
                sb.append(i18n.tr("Projekt") + " [" + i18n.tr("Netzwerk") + "]: " + projectsName + " [" + networkName + "]");
                sb.append(LINE_BREAK);
                sb.append(i18n.tr("Bescheid") + ": " + pn.getTitle());
                sb.append(LINE_BREAK);
                Map<Integer, List<WorkflowActivityNotificationSnippet>> activitiesByPlanningNotificationOrder = WorkflowActivitySortingHelper.sortByPlanningNotificationOrder(activitiesByPlanningNotification.get(planningNotificationId));
                for (Integer planningNotificationOrderId : activitiesByPlanningNotificationOrder.keySet()) {
                    List<WorkflowActivityNotificationSnippet> mailSnippets = activitiesByPlanningNotificationOrder.get(planningNotificationOrderId);
                    Collections.sort(mailSnippets, new WorkflowActivityNotificationSnippetComparator());
                    PlanningNotificationOrder pno = this.workflowEntityDAO.getPlanningNotificationOrder(planningNotificationOrderId);
                    sb.append(i18n.tr("Vorgabe") + ": " + i18n.tr("Lfd. Nummer") + " " + pno.getSerialNumber() + ", " + pno.getText());
                    sb.append(LINE_BREAK);
                    for (WorkflowActivityNotificationSnippet snip : mailSnippets) {
                        WorkflowActivity activity = snip.getWorkflowActivity();
                        if (processedWorkflowActivityIds.contains(activity.getId())) continue;
                        if (activity instanceof HibernateProxy) {
                            HibernateProxy proxy = (HibernateProxy)activity;
                            activity = (WorkflowActivity)proxy.writeReplace();
                        }
                        if (activity instanceof WorkflowActivityPositionResult) {
                            WorkflowActivityPositionResult result = (WorkflowActivityPositionResult)activity;
                            String phase = null;
                            if (result.getFirstMetaInformation() != null) {
                                PlanningNotificationMetaInformation metaInfo = result.getFirstMetaInformation();
                                if (metaInfo instanceof PlanningNotificationTextMetaInformation) {
                                    phase = ((PlanningNotificationTextMetaInformation)metaInfo).getValue();
                                } else if (metaInfo instanceof PlanningNotificationDateMetaInformation) {
                                    phase = DateHelper.formatDefaultDate(((PlanningNotificationDateMetaInformation)metaInfo).getValue().getTime());
                                }
                            }
                            sb.append(i18n.tr("Knoten") + ": " + result.getWorkflowNodeName() + " (" + i18n.tr("initiiert f\u00fcr") + " " + result.getTokenInitiator() + ")" + LINE_BREAK);
                            if (phase != null && phase.length() > 0) {
                                sb.append(i18n.tr("Baulos") + ": " + phase + LINE_BREAK);
                            }
                            sb.append(i18n.tr("Pr\u00fcfer") + ": " + result.getReviewer() + LINE_BREAK);
                            sb.append(i18n.tr("Ergebnis") + ": " + result.getResult() + LINE_BREAK);
                            sb.append(i18n.tr("Datum") + ": " + dtf.format(result.getIssued()) + LINE_BREAK);
                            sb.append(LINE_BREAK);
                        } else if (activity instanceof WorkflowActivityHistoryEntry) {
                            WorkflowActivityHistoryEntry entry = (WorkflowActivityHistoryEntry)activity;
                            if (entry.isAdministrative()) {
                                this.workflowActivityNotificationSnippetDAO.delete(snip.getId());
                                continue;
                            }
                            sb.append(i18n.tr("Knoten") + ": " + entry.getWorkflowNodeName() + LINE_BREAK);
                            sb.append(i18n.tr("Ereignis") + ": " + entry.getDescription() + LINE_BREAK);
                            sb.append(i18n.tr("Datum") + ": " + dtf.format(entry.getIssued()) + LINE_BREAK);
                            sb.append(LINE_BREAK);
                        }
                        processedWorkflowActivityIds.add(activity.getId());
                        this.workflowActivityNotificationSnippetDAO.delete(snip.getId());
                    }
                    sb.append("__________________________________________________________________________________");
                    sb.append(LINE_BREAK);
                }
            }
            String applicationUrl = this.urlMapper.getURL(orgPerson);
            applicationUrl = applicationUrl + "/cdes-ui/#page=planningNotificationTaskList";
            sb.append(LINE_BREAK);
            sb.append(String.format(locale, i18n.tr("Sie erreichen die Planpr\u00fcfplattform unter dem link %s"), applicationUrl));
            sb.append(LINE_BREAK);
            sb.append(LINE_BREAK);
            sb.append(i18n.tr("generiert durch Planpr\u00fcfplattform c.des"));
            sb.append(LINE_BREAK);
            this.createSimpleMailReply(orgPerson, "c.des concurrent design", sb.toString(), null);
        }
    }

    public void setWorkflowActivityNotificationSnippetDAO(WorkflowActivityNotificationSnippetDAO workflowActivityNotificationSnippetDAO) {
        this.workflowActivityNotificationSnippetDAO = workflowActivityNotificationSnippetDAO;
    }

    public void setPlanningNotificationDAO(PlanningNotificationDAO planningNotificationDAO) {
        this.planningNotificationDAO = planningNotificationDAO;
    }

    public void setWorkflowEntityDAO(WorkflowEntityDAO workflowEntitiyDAO) {
        this.workflowEntityDAO = workflowEntitiyDAO;
    }

    public void setDebugMailDestination(String debugMailDestination) {
        this.debugMailDestination = debugMailDestination;
    }

    public void setBlueprintBundle(Bundle blueprintBundle) {
        this.blueprintBundle = blueprintBundle;
    }

    private class ProjectSnippets
    implements TaskVisitor,
    EMailSnippetVisitor,
    FutureEMailVisitor {
        Project project;
        List<ReviewableTask> new_review_tasks;
        List<ReviewableTask> rescheduled_review_tasks;
        List<ReviewableTask> review_task_reminders;
        List<Task> late_tasks_monitor;
        List<SelectCellConnectionTask> upload_tasks;
        List<SelectCellConnectionTask> cell_connection_reminders;
        List<ReviewCycleEntryTask> initial_upload_tasks;
        List<ReviewCycleEntryTask> rescheduled_initial_upload_tasks;
        List<ReviewCycleEntryTask> rcycle_entry_reminders;
        List<ReviewCyclePlottTask> plottOrder_tasks;
        List<OriginalDocumentTask> originalDocument_tasks;
        List<DocumentVersion> released_dvs;
        List<DocumentVersion> release_denied_dvs;
        List<DocumentVersion> invalidated_dvs;
        List<DocumentVersion> invalidated_all_dvs;
        List<DocumentVersion> deleted_dvs;
        List<DocumentVersion> revised_dvs;
        List<DocumentVersion> provided_orgDvs;
        List<DocumentVersion> declined_orgDvs;
        List<DocumentVersion> tasks_invalidated_dvs;
        List<DocumentVersion> tasks_obsoleted_dvs;
        int current_task_snippet_type;
        List<NodeListenerEMailSnippet> nodeListenerSnippets;

        public ProjectSnippets(Project _project) {
            this.project = _project;
            this.new_review_tasks = new ArrayList<ReviewableTask>();
            this.rescheduled_review_tasks = new ArrayList<ReviewableTask>();
            this.review_task_reminders = new ArrayList<ReviewableTask>();
            this.late_tasks_monitor = new ArrayList<Task>();
            this.rcycle_entry_reminders = new ArrayList<ReviewCycleEntryTask>();
            this.upload_tasks = new ArrayList<SelectCellConnectionTask>();
            this.cell_connection_reminders = new ArrayList<SelectCellConnectionTask>();
            this.initial_upload_tasks = new ArrayList<ReviewCycleEntryTask>();
            this.rescheduled_initial_upload_tasks = new ArrayList<ReviewCycleEntryTask>();
            this.plottOrder_tasks = new ArrayList<ReviewCyclePlottTask>();
            this.originalDocument_tasks = new ArrayList<OriginalDocumentTask>();
            this.released_dvs = new ArrayList<DocumentVersion>();
            this.release_denied_dvs = new ArrayList<DocumentVersion>();
            this.deleted_dvs = new ArrayList<DocumentVersion>();
            this.invalidated_dvs = new ArrayList<DocumentVersion>();
            this.invalidated_all_dvs = new ArrayList<DocumentVersion>();
            this.tasks_invalidated_dvs = new ArrayList<DocumentVersion>();
            this.tasks_obsoleted_dvs = new ArrayList<DocumentVersion>();
            this.revised_dvs = new ArrayList<DocumentVersion>();
            this.provided_orgDvs = new ArrayList<DocumentVersion>();
            this.declined_orgDvs = new ArrayList<DocumentVersion>();
            this.current_task_snippet_type = 0;
            this.nodeListenerSnippets = new ArrayList<NodeListenerEMailSnippet>();
        }

        @Override
        public void visit(TaskEMailSnippet snippet) {
            Task task = snippet.getTask();
            this.current_task_snippet_type = snippet.getType();
            task.accept(this);
        }

        @Override
        public void visit(StatusEMailSnippet snippet) {
            switch (snippet.getType()) {
                case 1: {
                    this.released_dvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 7: {
                    this.release_denied_dvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 4: {
                    this.invalidated_dvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 6: {
                    this.deleted_dvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 5: {
                    this.invalidated_all_dvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 2: {
                    this.tasks_invalidated_dvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 3: {
                    this.tasks_obsoleted_dvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 8: {
                    this.revised_dvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 9: {
                    this.provided_orgDvs.add(snippet.getDocumentVersion());
                    break;
                }
                case 10: {
                    this.declined_orgDvs.add(snippet.getDocumentVersion());
                    break;
                }
                default: {
                    logger.warn((Object)String.format("Unhandled StatusEMailSnippet type %d.", snippet.getType()));
                }
            }
        }

        @Override
        public void visit(NodeListenerEMailSnippet snippet) {
            this.nodeListenerSnippets.add(snippet);
        }

        @Override
        public Task visit(ReviewableTask task) {
            switch (this.current_task_snippet_type) {
                case 1: {
                    this.new_review_tasks.add(task);
                    break;
                }
                case 2: {
                    this.rescheduled_review_tasks.add(task);
                    break;
                }
                case -1: {
                    this.review_task_reminders.add(task);
                    break;
                }
                case -2: {
                    this.late_tasks_monitor.add(task);
                    break;
                }
                default: {
                    logger.warn((Object)String.format("Unhandled TaskEMailSnippet type [%d] for ReviewTask.", this.current_task_snippet_type));
                }
            }
            return task;
        }

        @Override
        public Task visit(SelectCellConnectionTask task) {
            switch (this.current_task_snippet_type) {
                case 1: {
                    this.upload_tasks.add(task);
                    break;
                }
                case -1: {
                    this.cell_connection_reminders.add(task);
                    break;
                }
                case -2: {
                    this.late_tasks_monitor.add(task);
                    break;
                }
                default: {
                    logger.warn((Object)String.format("Unhandled TaskEMailSnippet type [%d] for SelecCellConnectionTask.", this.current_task_snippet_type));
                }
            }
            return task;
        }

        @Override
        public Task visit(ReviewableTaskDone task) {
            logger.warn((Object)("makeSnippetEMail: Unhandled ReviewableTaskDone " + task.getId()));
            return task;
        }

        @Override
        public Task visit(SelectCellConnectionTaskDone task) {
            logger.warn((Object)("makeSnippetEMail: Unhandled SelectCellConnectionTaskDone " + task.getId()));
            return task;
        }

        @Override
        public Task visit(ReviewCycleEntryTask task) {
            switch (this.current_task_snippet_type) {
                case 1: {
                    this.initial_upload_tasks.add(task);
                    break;
                }
                case 2: {
                    this.rescheduled_initial_upload_tasks.add(task);
                    break;
                }
                case -1: {
                    this.rcycle_entry_reminders.add(task);
                    break;
                }
                case -2: {
                    this.late_tasks_monitor.add(task);
                    break;
                }
                default: {
                    logger.warn((Object)String.format("Unhandled TaskEMailSnippet type [%d] for ReviewCycleEntryTask.", this.current_task_snippet_type));
                }
            }
            return task;
        }

        @Override
        public Task visit(ReviewCycleEntryTaskDone task) {
            logger.warn((Object)("makeSnippetEMail: Unhandled ReviewCycleEntryTaskDone " + task.getId()));
            return task;
        }

        @Override
        public Object visit(ReviewCyclePlottTask task) {
            switch (this.current_task_snippet_type) {
                case 1: {
                    this.plottOrder_tasks.add(task);
                    break;
                }
                default: {
                    logger.warn((Object)String.format("Unhandled TaskEMailSnippet type [%d] for ReviewCyclePlottTask.", this.current_task_snippet_type));
                }
            }
            return task;
        }

        @Override
        public Object visit(ReviewCyclePlottTaskDone task) {
            logger.warn((Object)("makeSnippetEMail: Unhandled ReviewCyclePlottTaskDone " + task.getId()));
            return task;
        }

        @Override
        public Object visit(OriginalDocumentTask task) {
            switch (this.current_task_snippet_type) {
                case 1: {
                    this.originalDocument_tasks.add(task);
                    break;
                }
                default: {
                    logger.warn((Object)String.format("Unhandled TaskEMailSnippet type [%d] for ReviewCyclePlottTask.", this.current_task_snippet_type));
                }
            }
            return task;
        }

        @Override
        public Object visit(OriginalDocumentTaskDone task) {
            logger.warn((Object)("makeSnippetEMail: Unhandled OriginalDocumentTaskDone " + task.getId()));
            return task;
        }

        @Override
        public Object visit(PlotOrderAcceptanceTask task) {
            logger.warn((Object)("makeSnippetEMail: Unhandled PlotOrderAcceptanceTask " + task.getId()));
            return task;
        }

        @Override
        public Object visit(PlotOrderAcceptanceTaskDone task) {
            logger.warn((Object)("makeSnippetEMail: Unhandled PlotOrderAcceptanceTaskDone " + task.getId()));
            return task;
        }

        @Override
        public void visit(TaskFutureEMail taskFutureEMail) {
            Task task = taskFutureEMail.getTask();
            this.current_task_snippet_type = taskFutureEMail.getType();
            task.accept(this);
        }

        public void addSnippet(EMailSnippet snippet) {
            snippet.accept(this);
        }

        private void appendDocumentVersionTasks(StringBuffer sb, List<? extends DocumentVersionTask> tasks, Comparator documentVersionTaskComparator, I18n i18n, boolean isReminder, Integer organisationPersonId) {
            Collections.sort(tasks, documentVersionTaskComparator);
            DocumentVersionTask last = null;
            Integer lastNodeId = null;
            Object lastObjectPlannerId = null;
            Integer lastObjectId = null;
            for (DocumentVersionTask documentVersionTask : tasks) {
                if (last != null && documentVersionTaskComparator.compare(documentVersionTask, last) == 0) continue;
                DocumentVersion documentVersion = documentVersionTask.getDocumentVersion();
                Document document = documentVersion.getDocument();
                ObjectPlanner objPlanner = document.getObjectPlanner();
                CDESObject obj = document.getObjectPlanner().getObject();
                ReviewCycleNode node = documentVersion.getActualReviewCycleNode();
                if (lastNodeId == null || !lastNodeId.equals(node.getId())) {
                    lastNodeId = node.getId();
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(TapestryI18nHelper.getLocaleString(node.getReviewCycleCell().getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(" - ");
                    sb.append(TapestryI18nHelper.getLocaleString(node.getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(":");
                    sb.append(MailOperationsImpl.LINE_BREAK);
                    lastObjectId = null;
                }
                if (lastObjectId == null || !lastObjectId.equals(obj.getId())) {
                    lastObjectId = obj.getId();
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("Objekt") + " " + obj.getCode() + ":");
                    sb.append(MailOperationsImpl.LINE_BREAK);
                }
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(" " + i18n.tr("Plan") + " " + documentVersion.getName());
                sb.append(" " + TapestryI18nHelper.getLocaleString(document.getContent(), i18n.getResources().getLocale().getLanguage()));
                if (isReminder) {
                    sb.append(MailOperationsImpl.INDENT);
                    ProjectParticipation participation = MailOperationsImpl.this.projectParticipationDAO.get(documentVersionTask.getProjectParticipationId());
                    HolidayCalculator holidayCalc = MailOperationsImpl.this.getHolidayCalculatorFactory().getInstance(participation.getProject());
                    int daysToDeadline = holidayCalc.getWorkingDaysBetween(new UtcTimestamp().toCalendar(), documentVersionTask.getEndDate());
                    String suffix = daysToDeadline == 1 ? " Werktag" : " Werktagen";
                    sb.append("in " + daysToDeadline + suffix);
                } else if (documentVersionTask.getEndDate() != null) {
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("zum Termin") + ": " + new UtcTimestamp(documentVersionTask.getEndDate()).toString(ISO8601Format.DATE_FORMAT));
                }
                ProjectParticipation tasksProjectParticipation = MailOperationsImpl.this.projectParticipationDAO.get(documentVersionTask.getProjectParticipationId());
                if (!tasksProjectParticipation.getMainParticipant().getOrganisationPerson().getId().equals(organisationPersonId)) {
                    sb.append(i18n.tr(" [stellvertretend]"));
                }
                sb.append(MailOperationsImpl.LINE_BREAK);
                last = documentVersionTask;
            }
        }

        private void appendDocumentTasks(StringBuffer sb, List<? extends DocumentTask> tasks, Comparator documentTaskComparator, I18n i18n, boolean isReminder, Integer organisationPersonId) {
            Collections.sort(tasks, documentTaskComparator);
            DocumentTask last = null;
            Integer lastObjectId = null;
            for (DocumentTask documentTask : tasks) {
                if (last != null && documentTaskComparator.compare(documentTask, last) == 0) continue;
                Document document = documentTask.getDocument();
                CDESObject obj = document.getObjectPlanner().getObject();
                if (lastObjectId == null || !lastObjectId.equals(obj.getId())) {
                    lastObjectId = obj.getId();
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("Objekt") + " " + obj.getCode() + ":");
                    sb.append(MailOperationsImpl.LINE_BREAK);
                }
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(" Plan " + document.getName());
                sb.append(" " + TapestryI18nHelper.getLocaleString(document.getContent(), i18n.getResources().getLocale().getLanguage()));
                if (isReminder) {
                    sb.append(MailOperationsImpl.INDENT);
                    ProjectParticipation participation = MailOperationsImpl.this.projectParticipationDAO.get(documentTask.getProjectParticipationId());
                    HolidayCalculator holidayCalc = MailOperationsImpl.this.getHolidayCalculatorFactory().getInstance(participation.getProject());
                    int daysToDeadline = holidayCalc.getWorkingDaysBetween(new UtcTimestamp().toCalendar(), documentTask.getEndDate());
                    String suffix = daysToDeadline == 1 ? " Werktag" : " Werktagen";
                    sb.append("in " + daysToDeadline + suffix);
                } else if (documentTask.getEndDate() != null) {
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("zum Termin") + ": " + new UtcTimestamp(documentTask.getEndDate()).toString(ISO8601Format.DATE_FORMAT));
                }
                ProjectParticipation tasksProjectParticipation = MailOperationsImpl.this.projectParticipationDAO.get(documentTask.getProjectParticipationId());
                if (!tasksProjectParticipation.getMainParticipant().getOrganisationPerson().getId().equals(organisationPersonId)) {
                    sb.append(i18n.tr(" [stellvertretend]"));
                }
                sb.append(MailOperationsImpl.LINE_BREAK);
                last = documentTask;
            }
        }

        private void appendDocumentVersions(StringBuffer sb, List<DocumentVersion> documentVersions, Comparator documentVersionComparator, I18n i18n, boolean versionOnly, boolean withNodeInfo) {
            Collections.sort(documentVersions, documentVersionComparator);
            DocumentVersion last = null;
            Integer lastNodeId = null;
            Integer lastObjectId = null;
            for (DocumentVersion documentVersion : documentVersions) {
                if (last != null && documentVersionComparator.compare(documentVersion, last) == 0) continue;
                Document document = documentVersion.getDocument();
                CDESObject obj = document.getObjectPlanner().getObject();
                ReviewCycleNode node = documentVersion.getActualReviewCycleNode();
                if (!(versionOnly || !withNodeInfo || lastNodeId != null && lastNodeId.equals(node.getId()))) {
                    lastNodeId = node.getId();
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(TapestryI18nHelper.getLocaleString(node.getReviewCycleCell().getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(" - ");
                    sb.append(TapestryI18nHelper.getLocaleString(node.getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(":");
                    sb.append(MailOperationsImpl.LINE_BREAK);
                    lastObjectId = null;
                }
                if (!(versionOnly || lastObjectId != null && lastObjectId.equals(obj.getId()))) {
                    lastObjectId = obj.getId();
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("Objekt") + " " + obj.getCode() + ":");
                    sb.append(MailOperationsImpl.LINE_BREAK);
                }
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(" " + i18n.tr("Plan") + " " + documentVersion.getName());
                sb.append(" " + TapestryI18nHelper.getLocaleString(document.getContent(), i18n.getResources().getLocale().getLanguage()));
                if (!versionOnly && document.getEndDate() != null) {
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("zum Termin") + ": " + new UtcTimestamp(document.getEndDate().getTime()).toString(ISO8601Format.DATE_FORMAT));
                }
                sb.append(MailOperationsImpl.LINE_BREAK);
                last = documentVersion;
            }
        }

        private void appendNodeListenerSnippets(StringBuffer sb, List<NodeListenerEMailSnippet> snippets, Comparator nodeListenerSnippetComparator, I18n i18n, Integer organisationPersonId) {
            Collections.sort(snippets, nodeListenerSnippetComparator);
            NodeListenerEMailSnippet last = null;
            Integer lastNodeId = null;
            Integer lastListenerId = null;
            Integer lastObjectId = null;
            for (NodeListenerEMailSnippet snippet : snippets) {
                if (last != null && nodeListenerSnippetComparator.compare(snippet, last) == 0) continue;
                DocumentVersion documentVersion = snippet.getDocumentVersion();
                Document document = documentVersion.getDocument();
                CDESObject obj = document.getObjectPlanner().getObject();
                ReviewCycleNodeListener listener = snippet.getNodeListener();
                ReviewCycleNode node = listener.getReviewCycleNode();
                if (lastNodeId == null || !lastNodeId.equals(node.getId()) || lastListenerId == null || !lastListenerId.equals(listener.getId())) {
                    lastNodeId = node.getId();
                    lastListenerId = listener.getId();
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(TapestryI18nHelper.getLocaleString(node.getReviewCycleCell().getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(" - ");
                    sb.append(TapestryI18nHelper.getLocaleString(node.getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(" - ");
                    sb.append(TapestryI18nHelper.getLocaleString(listener.getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(":");
                    sb.append(MailOperationsImpl.LINE_BREAK);
                    lastObjectId = null;
                }
                if (lastObjectId == null || !lastObjectId.equals(obj.getId())) {
                    lastObjectId = obj.getId();
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("Objekt") + " " + obj.getCode() + ":");
                    sb.append(MailOperationsImpl.LINE_BREAK);
                }
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(" " + i18n.tr("Plan") + " " + documentVersion.getName());
                sb.append(" " + TapestryI18nHelper.getLocaleString(document.getContent(), i18n.getResources().getLocale().getLanguage()));
                if (document.getEndDate() != null) {
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("zum Termin") + ": " + new UtcTimestamp(document.getEndDate().getTime()).toString(ISO8601Format.DATE_FORMAT));
                }
                if (!snippet.getOrganisationPersonId().equals(organisationPersonId)) {
                    sb.append(i18n.tr(" [stellvertretend]"));
                }
                sb.append(MailOperationsImpl.LINE_BREAK);
                last = snippet;
            }
        }

        private void appendLateTaskMonitors(StringBuffer sb, List<Task> tasks, Comparator taskComparator, I18n i18n) {
            Collections.sort(tasks, taskComparator);
            ArrayList<Integer> processedTasks = new ArrayList<Integer>();
            for (Task task : tasks) {
                ProjectParticipation participation;
                if (processedTasks.contains(task.getId())) continue;
                processedTasks.add(task.getId());
                DocumentVersion documentVersion = null;
                Document document = null;
                ProjectParticipant responsibleParticipant = null;
                if (task instanceof ReviewableTask) {
                    documentVersion = ((ReviewableTask)task).getDocumentVersion();
                    document = documentVersion.getDocument();
                    participation = MailOperationsImpl.this.projectParticipationDAO.get(((ReviewableTask)task).getProjectParticipationId());
                    responsibleParticipant = participation.getMainParticipant();
                } else if (task instanceof ReviewCycleEntryTask) {
                    document = ((ReviewCycleEntryTask)task).getDocument();
                    documentVersion = null;
                    participation = MailOperationsImpl.this.projectParticipationDAO.get(((ReviewCycleEntryTask)task).getProjectParticipationId());
                    responsibleParticipant = participation.getMainParticipant();
                } else if (task instanceof SelectCellConnectionTask) {
                    documentVersion = ((SelectCellConnectionTask)task).getDocumentVersion();
                    document = documentVersion.getDocument();
                    participation = MailOperationsImpl.this.projectParticipationDAO.get(((SelectCellConnectionTask)task).getProjectParticipationId());
                    responsibleParticipant = participation.getMainParticipant();
                } else {
                    logger.debug((Object)("Unable to determine Type of task with id [" + task.getId() + "]."));
                    continue;
                }
                CDESObject obj = document.getObjectPlanner().getObject();
                ReviewCycleNode node = documentVersion != null ? documentVersion.getActualReviewCycleNode() : null;
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.INDENT);
                if (documentVersion == null) {
                    sb.append(" " + i18n.tr("Plan") + ": " + document.getName());
                } else {
                    sb.append(" " + i18n.tr("Plan") + ": " + documentVersion.getName());
                }
                sb.append(" " + TapestryI18nHelper.getLocaleString(document.getContent(), i18n.getResources().getLocale().getLanguage()));
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.LINE_BREAK);
                if (task instanceof DocumentTask) {
                    sb.append(i18n.tr("Aufenthalt") + ": " + task.getName());
                } else {
                    sb.append(i18n.tr("Aufenthalt") + ": " + TapestryI18nHelper.getLocaleString(node.getReviewCycleCell().getName(), i18n.getResources().getLocale().getLanguage()));
                    sb.append(" - ");
                    sb.append(TapestryI18nHelper.getLocaleString(node.getName(), i18n.getResources().getLocale().getLanguage()));
                }
                sb.append(MailOperationsImpl.LINE_BREAK);
                if (task.getEndDate() != null) {
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append("Termin: " + new UtcTimestamp(task.getEndDate()).toString(ISO8601Format.DATE_FORMAT));
                    sb.append(MailOperationsImpl.LINE_BREAK);
                }
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(i18n.tr("verantwortlich") + ": " + responsibleParticipant.getOrganisationPerson().getOrganisation().getName() + " (" + responsibleParticipant.getOrganisationPerson().getPerson().getCommonName() + ")");
                sb.append(MailOperationsImpl.LINE_BREAK);
            }
        }

        private void appendPlottOrderTasks(StringBuffer sb, List<ReviewCyclePlottTask> tasks, Comparator plottOrderComparator, I18n i18n, Integer organisationPersonId) {
            Collections.sort(tasks, plottOrderComparator);
            ReviewCyclePlottTask last = null;
            long jobNumber = 0L;
            int plottItems = 0;
            for (ReviewCyclePlottTask task : tasks) {
                ProjectParticipation tasksProjectParticipation;
                if (last != null && plottOrderComparator.compare(task, last) == 0) continue;
                jobNumber = task.getOrder().getJobNumber();
                plottItems = task.getOrder().getOrderItems().size();
                sb.append(MailOperationsImpl.INDENT);
                sb.append(" " + i18n.tr("Auftragsnummer") + ": " + jobNumber);
                sb.append(" " + i18n.tr("Anzahl Positionen") + ": " + plottItems);
                if (task.getEndDate() != null) {
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("zum Termin") + ": " + new UtcTimestamp(task.getEndDate()).toString(ISO8601Format.DATE_FORMAT));
                }
                if (!(tasksProjectParticipation = MailOperationsImpl.this.projectParticipationDAO.get(task.getProjectParticipationId())).getMainParticipant().getOrganisationPerson().getId().equals(organisationPersonId)) {
                    sb.append(i18n.tr(" [stellvertretend]"));
                }
                sb.append(MailOperationsImpl.LINE_BREAK);
                last = task;
            }
        }

        private void appendOriginalDocumentVersions(StringBuffer sb, List<OriginalDocumentTask> tasks, Comparator originalDocumentVersionComparator, I18n i18n) {
            Collections.sort(tasks, originalDocumentVersionComparator);
            OriginalDocumentTask last = null;
            Integer lastObjectId = null;
            for (OriginalDocumentTask task : tasks) {
                if (last != null && originalDocumentVersionComparator.compare(task, last) == 0) continue;
                DocumentVersion documentVersion = task.getDocumentVersion();
                Document document = documentVersion.getDocument();
                CDESObject obj = document.getObjectPlanner().getObject();
                if (lastObjectId == null || !lastObjectId.equals(obj.getId())) {
                    lastObjectId = obj.getId();
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("Objekt") + " " + obj.getCode() + ":");
                    sb.append(MailOperationsImpl.LINE_BREAK);
                }
                sb.append(MailOperationsImpl.INDENT);
                sb.append(MailOperationsImpl.INDENT);
                sb.append(" " + i18n.tr("Plan") + " " + documentVersion.getName());
                sb.append(" " + TapestryI18nHelper.getLocaleString(document.getContent(), i18n.getResources().getLocale().getLanguage()));
                if (task.getEndDate() != null) {
                    sb.append(MailOperationsImpl.INDENT);
                    sb.append(i18n.tr("zum Termin") + ": " + new UtcTimestamp(task.getEndDate()).toString(ISO8601Format.DATE_FORMAT));
                }
                sb.append(MailOperationsImpl.LINE_BREAK);
                last = task;
            }
        }

        public boolean format(int i, StringBuffer sb, Locale locale, I18n i18n, Integer organisationPersonId) {
            Comparator originalDocumentVersionComparator;
            Comparator plottOrderComparator;
            Comparator documentVersionComparator;
            Comparator documentTaskComparator;
            Comparator nodeListenerSnippetComparator;
            Comparator documentVersionTaskComparator;
            Comparator taskComparator;
            if (this.new_review_tasks.size() <= 0 && this.rescheduled_review_tasks.size() <= 0 && this.rescheduled_initial_upload_tasks.size() <= 0 && this.initial_upload_tasks.size() <= 0 && this.upload_tasks.size() <= 0 && this.tasks_invalidated_dvs.size() <= 0 && this.released_dvs.size() <= 0 && this.release_denied_dvs.size() <= 0 && this.deleted_dvs.size() <= 0 && this.invalidated_dvs.size() <= 0 && this.invalidated_all_dvs.size() <= 0 && this.tasks_obsoleted_dvs.size() <= 0 && this.nodeListenerSnippets.size() <= 0 && this.plottOrder_tasks.size() <= 0 && this.originalDocument_tasks.size() <= 0 && this.originalDocument_tasks.size() <= 0 && this.late_tasks_monitor.size() <= 0 && this.review_task_reminders.size() <= 0 && this.rcycle_entry_reminders.size() <= 0 && this.cell_connection_reminders.size() <= 0 && this.provided_orgDvs.size() <= 0 && this.declined_orgDvs.size() <= 0) {
                return false;
            }
            POJOComparatorFactory pf = new POJOComparatorFactory(locale);
            try {
                taskComparator = pf.getComparator(Task.class, "endDate", true);
                documentVersionTaskComparator = pf.getComparator(DocumentVersionTask.class, "documentVersion.{actualReviewCycleNode.{reviewCycleCell.position|position}|document.{objectPlanner.object.code|number}}", true);
                nodeListenerSnippetComparator = pf.getComparator(NodeListenerEMailSnippet.class, "{nodeListener.{reviewCycleNode.{reviewCycleCell.position|position}|id}|documentVersion.document.{objectPlanner.object.code|number}}", true);
                documentTaskComparator = pf.getComparator(DocumentTask.class, "document.{objectPlanner.object.code|number}", true);
                documentVersionComparator = pf.getComparator(DocumentVersion.class, "{actualReviewCycleNode.{reviewCycleCell.position|position}|document.{objectPlanner.object.code|number}}", true);
                plottOrderComparator = pf.getComparator(ReviewCyclePlottTask.class, "order.jobNumber", true);
                originalDocumentVersionComparator = pf.getComparator(OriginalDocumentTask.class, "documentVersion.document.{objectPlanner.object.code|number}", true);
            }
            catch (InvalidExpressionSyntaxException e) {
                logger.error((Object)"invalid ReviewableTask comparator expression.", (Throwable)e);
                throw new ActionException("invalid ReviewableTask comparator expression.", e);
            }
            sb.append(String.format("%d) " + i18n.tr("Projekt") + " %s - %s [%s]:", i, this.project.getCode(), this.project.getName(), this.project.getNetwork().getName()));
            if (this.review_task_reminders.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Die folgenden Pr\u00fcfaufgaben sind in K\u00fcrze zu erledigen:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersionTasks(sb, this.review_task_reminders, documentVersionTaskComparator, i18n, true, organisationPersonId);
            }
            if (this.rcycle_entry_reminders.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Die folgenden Pl\u00e4ne sind in K\u00fcrze auf die Plattform zu laden:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentTasks(sb, this.rcycle_entry_reminders, documentTaskComparator, i18n, true, organisationPersonId);
            }
            if (this.cell_connection_reminders.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Die folgenden Pl\u00e4ne sind in K\u00fcrze erneut auf die Plattform zu laden:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersionTasks(sb, this.cell_connection_reminders, documentVersionTaskComparator, i18n, true, organisationPersonId);
            }
            if (this.new_review_tasks.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Pl\u00e4ne sind zur Planpr\u00fcfung eingegangen:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersionTasks(sb, this.new_review_tasks, documentVersionTaskComparator, i18n, false, organisationPersonId);
            }
            if (this.rescheduled_review_tasks.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Die Termine Ihrer Pr\u00fcfaufgaben f\u00fcr folgende Pl\u00e4ne wurden ge\u00e4ndert:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersionTasks(sb, this.rescheduled_review_tasks, documentVersionTaskComparator, i18n, false, organisationPersonId);
            }
            if (this.initial_upload_tasks.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Die Termine folgender Planlieferkatalogeintr\u00e4ge wurden freigegeben."));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Die entsprechenden Aufgaben wurden f\u00fcr Sie generiert:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentTasks(sb, this.initial_upload_tasks, documentTaskComparator, i18n, false, organisationPersonId);
            }
            if (this.rescheduled_initial_upload_tasks.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Die Termine folgender Planlieferkatalogeintr\u00e4ge wurden ge\u00e4ndert:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentTasks(sb, this.rescheduled_initial_upload_tasks, documentTaskComparator, i18n, false, organisationPersonId);
            }
            if (this.upload_tasks.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Pl\u00e4ne sind fertig gepr\u00fcft und warten auf Ihre Einarbeitungen:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersionTasks(sb, this.upload_tasks, documentVersionTaskComparator, i18n, false, organisationPersonId);
            }
            if (this.tasks_invalidated_dvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Pl\u00e4ne wurden f\u00fcr ung\u00fcltig erkl\u00e4rt:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.tasks_invalidated_dvs, documentVersionComparator, i18n, false, true);
            }
            if (this.released_dvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Pl\u00e4ne wurden freigegeben:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.released_dvs, documentVersionComparator, i18n, false, false);
            }
            if (this.release_denied_dvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Die Freigabe folgender Pl\u00e4ne wurden abgelehnt:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.release_denied_dvs, documentVersionComparator, i18n, false, false);
            }
            if (this.invalidated_dvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Pl\u00e4ne wurden f\u00fcr ung\u00fcltig erkl\u00e4rt und gehen zu einem sp\u00e4teren Zeitpunkt erneut in den Pr\u00fclauf:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.invalidated_dvs, documentVersionComparator, i18n, false, true);
            }
            if (this.invalidated_all_dvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Pl\u00e4ne entfallen ersatzlos:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.invalidated_all_dvs, documentVersionComparator, i18n, false, true);
            }
            if (this.deleted_dvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Pl\u00e4ne wurden gel\u00f6scht und gehen erneut in den Pr\u00fclauf:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.deleted_dvs, documentVersionComparator, i18n, false, true);
            }
            if (this.tasks_obsoleted_dvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Ihre Pr\u00fcfaufgaben f\u00fcr folgende Pl\u00e4ne sind obsolet, weil Sie aus der Pr\u00fcfmatrix ausgetragen wurden:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.tasks_obsoleted_dvs, documentVersionComparator, i18n, false, true);
            }
            if (this.nodeListenerSnippets.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("F\u00fcr folgende Pl\u00e4ne wurde die Benachrichtigung \u00fcber das Eintreten eines Ereignisses konfiguriert:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendNodeListenerSnippets(sb, this.nodeListenerSnippets, nodeListenerSnippetComparator, i18n, organisationPersonId);
            }
            if (this.late_tasks_monitor.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende von Ihnen \u00fcberwachte Aufgaben sind versp\u00e4tet:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendLateTaskMonitors(sb, this.late_tasks_monitor, taskComparator, i18n);
            }
            if (this.revised_dvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Pl\u00e4ne wurden ung\u00fcltig erkl\u00e4rt, da eine Revision freigegeben wurde:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.revised_dvs, documentVersionComparator, i18n, false, true);
            }
            if (this.plottOrder_tasks.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Folgende Plotauftr\u00e4ge sind eingegangen:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendPlottOrderTasks(sb, this.plottOrder_tasks, plottOrderComparator, i18n, organisationPersonId);
            }
            if (this.originalDocument_tasks.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Zu folgenden Pl\u00e4nen wurde ein Original angefordert:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendOriginalDocumentVersions(sb, this.originalDocument_tasks, originalDocumentVersionComparator, i18n);
            }
            if (this.provided_orgDvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Zu folgenden Pl\u00e4nen wurde ein Original bereitgestellt:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.provided_orgDvs, documentVersionComparator, i18n, true, true);
            }
            if (this.declined_orgDvs.size() > 0) {
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(i18n.tr("Zu folgenden Pl\u00e4nen wurde die Bereitstellung des Originals abgelehnt:"));
                sb.append(MailOperationsImpl.LINE_BREAK);
                sb.append(MailOperationsImpl.LINE_BREAK);
                this.appendDocumentVersions(sb, this.declined_orgDvs, documentVersionComparator, i18n, true, true);
            }
            sb.append(MailOperationsImpl.LINE_BREAK);
            return true;
        }
    }
}

