/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.svg;

import at.cdes.svg.IMarkupWriter;
import at.cdes.svg.PathKit;
import at.cdes.svg.RectangleDefinitionContainer;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SvgRenderKit {
    static final Logger log = Logger.getLogger(SvgRenderKit.class);
    public static final String ACTUAL_HEIGHT_ATTR = "at.cdes.tapestry.components.svg::height";
    public static final String ACTUAL_WIDTH_ATTR = "at.cdes.tapestry.components.svg::width";
    public static final String ACTUAL_BOUNDING_BOX = "at.cdes.tapestry.components.svg::boundingbox";
    public static final int NOCORNER = 0;
    public static final int CORNER_LINEAR_RIGHT = 1;
    public static final int CORNER_LINEAR_LEFT = 2;
    public static final int CORNER_LINEAR_BOTH = 3;
    public static final int CORNER_ROUND_RIGHT = 4;
    public static final int CORNER_ROUND_LEFT = 5;
    public static final int CORNER_ROUND_BOTH = 6;
    public static final int CORNER_LINEAR_RIGHT_INV = -1;
    public static final int CORNER_LINEAR_LEFT_INV = -2;
    public static final int CORNER_LINEAR_BOTH_INV = -3;
    public static final int LEFT_LINE = 1;
    public static final int RIGHT_LINE = 2;
    public static final int TOP_LINE = 4;
    public static final int BOTTOM_LINE = 8;
    public static final int LEFT_OPEN = 14;
    public static final int RIGHT_OPEN = 13;

    public static void addText(IMarkupWriter writer, double x, double y, String style, String content, String transform) {
        writer.begin("text");
        writer.attribute("x", Double.toString(x));
        writer.attribute("y", Double.toString(y));
        writer.attribute("style", style);
        if (transform != null) {
            writer.attribute("transform", transform);
        }
        writer.print(content);
        writer.end("text");
    }

    public static void addLine(IMarkupWriter writer, double x1, double y1, double x2, double y2, String style) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Drawing line: (" + x1 + "," + y1 + ") --> (" + x2 + "," + y2 + ")"));
        }
        writer.beginEmpty("line");
        writer.attribute("x1", Double.toString(x1));
        writer.attribute("y1", Double.toString(y1));
        writer.attribute("x2", Double.toString(x2));
        writer.attribute("y2", Double.toString(y2));
        writer.attribute("style", style);
    }

    public static void addPolygon(IMarkupWriter writer, double[] points, String style) {
        String pointString = "";
        for (int i = 0; i < points.length; ++i) {
            pointString = pointString + points[i] + (i % 2 == 0 ? " " : ", ");
        }
        writer.beginEmpty("polygon");
        writer.attribute("points", pointString);
        writer.attribute("style", style);
    }

    public static void addUse(IMarkupWriter writer, String href, String transform) {
        writer.beginEmpty("use");
        writer.attribute("xlink:href", href);
        if (transform != null) {
            writer.attribute("transform", transform);
        }
    }

    public static void addRec(IMarkupWriter writer, double x, double y, double width, double height, String style, String id) {
        writer.beginEmpty("rect");
        writer.attribute("x", Double.toString(x));
        writer.attribute("y", Double.toString(y));
        if (width < 0.0) {
            x += width;
            width *= -1.0;
        }
        if (height < 0.0) {
            y += height;
            height *= -1.0;
        }
        writer.attribute("width", Double.toString(width));
        writer.attribute("height", Double.toString(height));
        writer.attribute("style", style);
        if (id != null) {
            StringTokenizer st = new StringTokenizer(id, "=");
            if (st.countTokens() > 1) {
                String attributeName = st.nextToken();
                if (attributeName.equals(new String("filter"))) {
                    writer.attribute("filter", st.nextToken());
                }
            } else {
                writer.attribute("id", id);
            }
        }
    }

    public static void addRec(IMarkupWriter writer, RectangleDefinitionContainer defs, String style, int lines) {
        String styleRect = "";
        String stylePath = "fill:none; ";
        if (style != null) {
            StringTokenizer st = new StringTokenizer(style, ";");
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.contains("opacity")) {
                    if (nextToken.contains("fill-opacity")) {
                        styleRect = styleRect + nextToken + ";";
                        continue;
                    }
                    if (nextToken.contains("stroke-opacity")) {
                        stylePath = stylePath + nextToken + ";";
                        continue;
                    }
                    styleRect = styleRect + nextToken + ";";
                    stylePath = stylePath + nextToken + ";";
                    continue;
                }
                if (nextToken.contains("fill")) {
                    styleRect = styleRect + nextToken + ";";
                    continue;
                }
                stylePath = stylePath + nextToken + ";";
            }
        }
        double lry = defs.getLry();
        double lrx = defs.getLrx();
        double rry = defs.getRry();
        double rrx = defs.getRrx();
        double x = defs.getX();
        double y = defs.getY();
        double width = defs.getWidth();
        double height = defs.getHeight();
        if (lry > 0.0 || lrx > 0.0 || rrx > 0.0 || rry > 0.0) {
            SvgRenderKit.addRec(writer, defs, styleRect, false, false);
            lry = defs.getLry();
            lrx = defs.getLrx();
            rry = defs.getRry();
            rrx = defs.getRrx();
            x = defs.getX();
            y = defs.getY();
            width = defs.getWidth();
            height = defs.getHeight();
        } else {
            writer.beginEmpty("rect");
            writer.attribute("x", Double.toString(x));
            writer.attribute("y", Double.toString(y));
            writer.attribute("width", Double.toString(width));
            writer.attribute("height", Double.toString(height));
            writer.attribute("style", styleRect);
        }
        String path = PathKit.getAbsoluteMoveTo(x, y);
        path = (lines & 4) == 4 ? path + PathKit.getRelativeHorizontalLineTo(width) : path + PathKit.getRelativeMoveTo(width, 0.0);
        if ((lines & 2) == 2) {
            if (rrx == 0.0 && rry == 0.0) {
                path = path + PathKit.getRelativeVerticalLineTo(height);
            } else {
                path = path + PathKit.getRelativeLineto(rrx, rry);
                path = path + PathKit.getRelativeVerticalLineTo(height - 2.0 * rry);
                path = path + PathKit.getRelativeLineto(-rrx, rry);
            }
        } else {
            path = path + PathKit.getRelativeMoveTo(0.0, height);
        }
        path = (lines & 8) == 8 ? path + PathKit.getRelativeHorizontalLineTo(-width) : path + PathKit.getRelativeMoveTo(-width, 0.0);
        if ((lines & 1) == 1) {
            if (lrx == 0.0 && lry == 0.0) {
                path = path + PathKit.getRelativeVerticalLineTo(-height);
            } else {
                path = path + PathKit.getRelativeLineto(-lrx, -lry);
                path = path + PathKit.getRelativeVerticalLineTo(-(height - 2.0 * lry));
                path = path + PathKit.getRelativeLineto(lrx, -lry);
            }
        }
        writer.beginEmpty("path");
        writer.attribute("d", path);
        writer.attribute("style", stylePath);
        writer.closeTag();
    }

    private static RectangleDefinitionContainer calculateRectangleDefinitions(RectangleDefinitionContainer recDef, boolean lcircle, boolean rcircle) {
        int lsweepFlag;
        double lrx = recDef.getLrx();
        double lry = recDef.getLry();
        double rrx = recDef.getRrx();
        double rry = recDef.getRry();
        double width = recDef.getWidth();
        double height = recDef.getHeight();
        boolean rlessThanZero = rrx < 0.0 || rry < 0.0;
        boolean llessThanZero = lrx < 0.0 || lry < 0.0;
        int rsweepFlag = rlessThanZero ? 0 : 1;
        int n = lsweepFlag = llessThanZero ? 0 : 1;
        if (width / 2.0 < Math.abs(lrx)) {
            lrx = width / 2.0;
        }
        if (width / 2.0 < Math.abs(rrx)) {
            rrx = width / 2.0;
        }
        lrx = lcircle || !llessThanZero ? Math.abs(lrx) : -Math.abs(lrx);
        lry = Math.abs(lry);
        rrx = rcircle || !rlessThanZero ? Math.abs(rrx) : -Math.abs(rrx);
        if (height < 2.0 * (rry = Math.abs(rry))) {
            rry = height / 2.0;
        }
        if (height < 2.0 * lry) {
            lry = height / 2.0;
        }
        double left = !lcircle && llessThanZero ? 0.0 : Math.abs(lrx);
        double right = !rcircle && rlessThanZero ? 0.0 : Math.abs(rrx);
        double realWidth = width - (left + right);
        recDef.setWidth(realWidth);
        recDef.setX(recDef.getX() + left);
        recDef.setLrx(lrx);
        recDef.setLry(lry);
        recDef.setRrx(rrx);
        recDef.setRry(rry);
        recDef.setRsweepFlag(rsweepFlag);
        recDef.setLsweepFlag(lsweepFlag);
        return recDef;
    }

    public static void addRec(IMarkupWriter writer, RectangleDefinitionContainer recDef, String style, boolean lcircle, boolean rcircle) {
        recDef = SvgRenderKit.calculateRectangleDefinitions(recDef, lcircle, rcircle);
        double lrx = recDef.getLrx();
        double lry = recDef.getLry();
        double rrx = recDef.getRrx();
        double rry = recDef.getRry();
        double width = recDef.getWidth();
        double height = recDef.getHeight();
        int rsweepFlag = recDef.getRsweepFlag();
        int lsweepFlag = recDef.getLsweepFlag();
        boolean redges = true;
        boolean ledges = true;
        if (Math.abs(rrx) <= 0.0 || Math.abs(rry) <= 0.0) {
            redges = false;
        }
        if (Math.abs(lrx) <= 0.0 || Math.abs(lry) <= 0.0) {
            ledges = false;
        }
        writer.beginEmpty("path");
        writer.attribute("d", PathKit.getAbsoluteMoveTo(recDef.getX(), recDef.getY()) + PathKit.getRelativeHorizontalLineTo(width) + (redges ? (rcircle ? PathKit.getEllipticalArc(rrx, rry, 0.0, 0, rsweepFlag, rrx, rry) : PathKit.getRelativeLineto(rrx, rry)) + PathKit.getRelativeVerticalLineTo(height - 2.0 * rry) + (rcircle ? PathKit.getEllipticalArc(rrx, rry, 0.0, 0, rsweepFlag, -rrx, rry) : PathKit.getRelativeLineto(-rrx, rry)) : PathKit.getRelativeVerticalLineTo(height)) + PathKit.getRelativeHorizontalLineTo(-width) + (ledges ? (lcircle ? PathKit.getEllipticalArc(lrx, lry, 0.0, 0, lsweepFlag, -lrx, -lry) : PathKit.getRelativeLineto(-lrx, -lry)) + PathKit.getRelativeVerticalLineTo(-(height - 2.0 * lry)) + (lcircle ? PathKit.getEllipticalArc(lrx, lry, 0.0, 0, lsweepFlag, lrx, -lry) : PathKit.getRelativeLineto(lrx, -lry)) : PathKit.getRelativeVerticalLineTo(-height)) + " z");
        writer.attribute("style", style);
        writer.closeTag();
    }

    public static void addRec(IMarkupWriter writer, double x, double y, double rx, double ry, double width, double height, String style, String id) {
        writer.beginEmpty("rect");
        writer.attribute("x", Double.toString(x));
        writer.attribute("y", Double.toString(y));
        writer.attribute("rx", Double.toString(rx));
        writer.attribute("ry", Double.toString(ry));
        writer.attribute("width", Double.toString(width));
        writer.attribute("height", Double.toString(height));
        writer.attribute("style", style);
        if (id != null) {
            StringTokenizer st = new StringTokenizer(id, "=");
            if (st.countTokens() > 1) {
                String attributeName = st.nextToken();
                if (attributeName.equals(new String("filter"))) {
                    writer.attribute("filter", st.nextToken());
                }
            } else {
                writer.attribute("id", id);
            }
        }
        writer.closeTag();
    }

    public static String getMonth(int i) {
        if (i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    public static String getYear(int firstYearInt) {
        String year = String.valueOf(firstYearInt);
        return year.substring(2);
    }

    public static void addCircle(IMarkupWriter writer, double cx, double cy, double r, String style) {
        writer.beginEmpty("circle");
        writer.attribute("cx", Double.toString(cx));
        writer.attribute("cy", Double.toString(cy));
        writer.attribute("r", Double.toString(r));
        if (style != null) {
            writer.attribute("style", style);
        }
    }

    public static void addMilestone(IMarkupWriter writer, double x, double y, double height, double width, String style) {
        if (width < 0.0 || height < 0.0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"width and height need to be greater than 1/100");
            }
            return;
        }
        double moveX = width / 2.0;
        double moveY = height / 2.0;
        String path = PathKit.getAbsoluteMoveTo(x, y - moveY) + PathKit.getRelativeLineto(moveX, moveY) + PathKit.getRelativeLineto(-moveX, moveY) + PathKit.getRelativeLineto(-moveX, -moveY) + PathKit.getRelativeLineto(moveX, -moveY);
        writer.beginEmpty("path");
        writer.attribute("d", path);
        writer.attribute("style", style);
    }
}

