/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.svg;

import at.cdes.batik.BatikSvgException;
import at.cdes.batik.BatikSvgRendererOperations;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.bo.plot.SimpleBoundingBox;
import at.cdes.service.exception.ActionException;
import at.cdes.svg.IMarkupWriter;
import at.cdes.svg.RectangleDefinitionContainer;
import at.cdes.svg.SvgRenderKit;
import at.cdes.util.DateHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.clazzes.util.datetime.CalendarHelper;

public class SvgReviewHelper {
    private static String style = "stroke:black; stroke-width:1px;";
    static final Logger logger = Logger.getLogger(SvgReviewHelper.class);

    public static int drawDateWeeks(IMarkupWriter writer, BatikSvgRendererOperations renderer, int projectDurationInWeeks, Calendar start, SimpleBoundingBox box, HolidayCalculatorFactory holifactory, Project project) {
        double toDayPos;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"draw weeks");
        }
        HolidayCalculator holiCalc = null;
        if (project != null) {
            holiCalc = holifactory.getInstance(project);
        }
        SimpleDateFormat df = null;
        if (project != null) {
            String s = project.getLocalisation().getCountry().getCode2();
            Locale loc = Locale.ENGLISH;
            if (s.equalsIgnoreCase(new String("AT")) || s.equalsIgnoreCase(new String("DE"))) {
                loc = Locale.GERMAN;
            }
            if (s.equalsIgnoreCase("IT")) {
                loc = Locale.ITALIAN;
            }
            df = new SimpleDateFormat("MMMMM yy", loc);
        } else {
            df = new SimpleDateFormat("MMMMM yy");
        }
        double width = box.getUrx() - box.getLlx();
        int placeForAxis = 30;
        double basic = Math.floor(width / (double)projectDurationInWeeks);
        Calendar startDate = Calendar.getInstance(Locale.GERMAN);
        startDate.setTimeInMillis(start.getTimeInMillis());
        startDate.set(7, startDate.getFirstDayOfWeek());
        SimpleDateFormat logDate = new SimpleDateFormat("dd.MM.yy");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("startDate " + logDate.format(startDate.getTime())));
        }
        Calendar endDate = (Calendar)start.clone();
        endDate.add(5, projectDurationInWeeks * 7);
        ArrayList<Calendar> holidays = new ArrayList<Calendar>();
        if (holiCalc != null) {
            holidays.addAll(holiCalc.getHolidaysBetween(startDate, endDate));
        }
        for (Calendar cal : holidays) {
            double holi;
            if (cal.get(7) == 7 || cal.get(7) == 1 || !((holi = SvgReviewHelper.getXPositionFromStart(true, startDate, cal, basic)) < basic * (double)projectDurationInWeeks)) continue;
            SvgRenderKit.addRec(writer, box.getLlx() + holi, box.getUry() - 30.0, basic / 7.0, 30.0, "fill:#96bbdf; opacity:.3;", null);
        }
        Calendar toDay = Calendar.getInstance();
        if (endDate.after(toDay) && (toDayPos = SvgReviewHelper.getXPositionFromStart(true, startDate, toDay, basic)) < basic * (double)projectDurationInWeeks) {
            SvgRenderKit.addRec(writer, box.getLlx() + toDayPos, box.getUry() - 30.0, basic / 7.0, 30.0, "fill:#ffffff;", null);
            SvgRenderKit.addRec(writer, box.getLlx() + toDayPos, box.getUry() - 30.0, basic / 7.0, 30.0, "fill:#ff0000; opacity:.3;", null);
        }
        int kw = startDate.get(3);
        for (int i = 1; i <= projectDurationInWeeks; ++i) {
            String kwString;
            SvgRenderKit.addRec(writer, box.getLlx() + (double)i * basic - 2.0 * (basic / 7.0), box.getUry() - 30.0, 2.0 * (basic / 7.0), 30.0, "fill:#96bbdf; opacity:.3;", null);
            if (i <= projectDurationInWeeks - 1) {
                SvgRenderKit.addLine(writer, box.getLlx() + (double)i * basic, box.getUry() - 30.0, box.getLlx() + (double)i * basic, box.getUry() - 15.0, style);
            } else {
                SvgRenderKit.addLine(writer, box.getLlx() + (double)i * basic, box.getUry() - 30.0, box.getLlx() + (double)i * basic, box.getUry(), style);
            }
            double dayBasic = box.getLlx() + (double)(i - 1) * basic;
            for (int j = 1; j < 7; ++j) {
                SvgRenderKit.addLine(writer, dayBasic + (double)j * basic / 7.0, box.getUry() - 30.0, dayBasic + (double)j * basic / 7.0, box.getUry() - 27.5, style);
            }
            double shiftToLeft = 0.0;
            String string = kwString = basic > 50.0 ? "KW " + kw : String.valueOf(kw);
            if (kwString.length() > 4) {
                shiftToLeft = 2.5;
            }
            SvgRenderKit.addText(writer, box.getLlx() + (basic / 2.0 - 10.0) + (double)(i - 1) * basic - shiftToLeft, box.getUry() - 17.5, "font-family:verdana; font-size:10px;", kwString, null);
            if (kw == startDate.getActualMaximum(3)) {
                kw = 1;
                continue;
            }
            ++kw;
        }
        SvgRenderKit.addLine(writer, box.getLlx(), box.getUry() - 30.0, box.getLlx() + basic * (double)projectDurationInWeeks, box.getUry() - 30.0, style);
        SvgRenderKit.addLine(writer, box.getLlx(), box.getUry() - 30.0, box.getLlx(), box.getUry(), style);
        SvgRenderKit.addLine(writer, box.getLlx(), box.getUry() - 15.0, box.getLlx() + basic * (double)projectDurationInWeeks, box.getUry() - 15.0, style);
        SvgRenderKit.addLine(writer, box.getLlx(), box.getUry(), box.getLlx() + basic * (double)projectDurationInWeeks, box.getUry(), style);
        int days = SvgReviewHelper.calculateDaysToDraw(startDate, endDate);
        int startDay = 1;
        int countWeeks = 0;
        boolean justStarted = true;
        double xposition = box.getLlx();
        for (int i = 0; i < days; ++i) {
            int day;
            if (startDay % 7 == 0) {
                ++countWeeks;
            }
            if ((day = startDate.get(5)) == 1 || justStarted) {
                double size;
                int d = 0;
                if (justStarted) {
                    d = startDate.getActualMaximum(5) - day;
                    justStarted = false;
                } else {
                    d = startDate.getActualMaximum(5);
                    xposition = basic / 7.0 * (double)(startDay % 7 - 1) + basic * (double)countWeeks + box.getLlx();
                }
                double spaceForText = basic / 7.0 * (double)d;
                if (xposition + spaceForText > box.getLlx() + basic * (double)projectDurationInWeeks) {
                    spaceForText = box.getLlx() + basic * (double)projectDurationInWeeks - xposition;
                }
                String timeString = df.format(startDate.getTime());
                try {
                    size = renderer.getTextWidth("Verdana", timeString) * 10.0;
                }
                catch (BatikSvgException e) {
                    throw new ActionException("error calculating text width", e);
                }
                if (spaceForText > size) {
                    double tmp = spaceForText / 2.0 - size / 2.0;
                    SvgRenderKit.addText(writer, xposition + tmp, box.getUry() - 2.5, "font-family:verdana; font-size:10px;", timeString, null);
                }
                if (xposition < box.getUrx()) {
                    SvgRenderKit.addLine(writer, xposition, box.getUry() - 15.0, xposition, box.getUry(), style);
                }
            }
            startDay = startDay == 7 ? 1 : ++startDay;
            startDate.set(5, day + 1);
        }
        return placeForAxis;
    }

    public static int drawDate(IMarkupWriter writer, int projectDurationInDays, Calendar start, SimpleBoundingBox box) {
        Calendar cal = (Calendar)start.clone();
        Calendar stop = (Calendar)cal.clone();
        stop.add(5, projectDurationInDays);
        double width = box.getUrx() - box.getLlx();
        double basic = width / (double)projectDurationInDays;
        double bottom = box.getUry();
        boolean vertical = basic * 31.0 < 40.0;
        int placeForAxis = vertical ? 40 : 20;
        SvgRenderKit.addLine(writer, box.getLlx(), bottom - (double)placeForAxis, box.getUrx(), bottom - (double)placeForAxis, style);
        SvgRenderKit.addLine(writer, box.getLlx(), bottom, box.getUrx(), bottom, style);
        SvgRenderKit.addLine(writer, box.getLlx(), bottom - (double)placeForAxis, box.getLlx(), bottom, style);
        double stepBasis = box.getLlx();
        while (cal.before(stop)) {
            double spaceThisMonth = basic * (double)cal.getActualMaximum(5);
            double x = spaceThisMonth + stepBasis;
            if (x > box.getUrx()) {
                x = box.getUrx();
                spaceThisMonth = x - stepBasis;
            }
            SvgRenderKit.addLine(writer, x, bottom - (double)placeForAxis, x, bottom, style);
            if (vertical && spaceThisMonth > 10.0 || spaceThisMonth > 30.0) {
                double xText = stepBasis;
                xText = spaceThisMonth < 40.0 && vertical ? (xText += spaceThisMonth / 2.0) : (spaceThisMonth > 40.0 ? (xText += spaceThisMonth / 2.0 - 10.0) : (xText += 2.0));
                SvgRenderKit.addText(writer, xText, bottom - 5.0, "font-family:verdana; font-size:10px;", SvgRenderKit.getMonth(cal.get(2) + 1) + "/" + SvgRenderKit.getYear(cal.get(1)), vertical ? "rotate(-90," + xText + "," + (bottom - 2.0) + ")" : null);
            }
            stepBasis = x;
            cal.add(2, 1);
        }
        return placeForAxis;
    }

    public static double getXPositionFromDate(Calendar startDate, Calendar actualDate, double spacePerDay) {
        if (actualDate.before(startDate)) {
            return -1.0;
        }
        int days = 0;
        days = SvgReviewHelper.calculateDaysToDraw(startDate, actualDate);
        return (double)days * spacePerDay;
    }

    public static double getXPositionFromStart(boolean drawWeeks, Calendar startDate, Calendar actualDate, double spacePerTimeUnit) {
        if (actualDate.before(startDate)) {
            return -1.0;
        }
        if (drawWeeks) {
            int weeks = SvgReviewHelper.calculateWeeksToDraw(startDate, actualDate) - 1;
            int dayOfWeek = actualDate.get(7) - actualDate.getFirstDayOfWeek();
            return (double)weeks * spacePerTimeUnit + spacePerTimeUnit / 7.0 * (double)((dayOfWeek + 7) % 7);
        }
        int days = 0;
        Calendar start = (Calendar)startDate.clone();
        int startMonth = startDate.get(2);
        int actMonth = actualDate.get(2);
        int actYear = actualDate.get(1);
        for (int startYear = startDate.get(1); startYear < actYear; ++startYear) {
            while (startMonth <= 11) {
                days += start.getActualMaximum(5);
                ++startMonth;
                start.add(2, 1);
            }
            startMonth = 0;
        }
        while (startMonth < actMonth) {
            days += start.getActualMaximum(5);
            ++startMonth;
            start.add(2, 1);
        }
        return (double)(days += actualDate.get(5)) * spacePerTimeUnit;
    }

    public static Calendar getActualEndDateOfReviewCycle(List<ReviewCycleCellResult> cellResults) {
        Date date = cellResults.get(cellResults.size() - 1).getDocumentDepartureDate();
        ReviewCycleResultOption cellResultOption = cellResults.get(cellResults.size() - 1).getReviewCycleResultOption();
        if (date == null) {
            date = cellResults.get(cellResults.size() - 1).getDocumentArrivalDate();
            ArrayList<ReviewCycleNodeResult> nodes = new ArrayList<ReviewCycleNodeResult>();
            nodes.addAll(cellResults.get(cellResults.size() - 1).getReviewCycleNodeResultsSortedByPosition(true));
            for (ReviewCycleNodeResult node : nodes) {
                if (node.getDocumentDepartureDate() != null && date.before(node.getDocumentDepartureDate())) {
                    date = node.getDocumentDepartureDate();
                    continue;
                }
                if (node.getDocumentDepartureDate() != null || node.getReviewCycleNode().isEndOfReviewCycle() && (cellResultOption == null || !cellResultOption.isFinishCell())) continue;
                date = Calendar.getInstance().getTime();
            }
        }
        Calendar endDate = DateHelper.getCalendar(date);
        return endDate;
    }

    public static String getDateFormat(SimpleDateFormat df, Calendar cal) {
        String ret = "null";
        if (cal != null && df != null) {
            ret = df.format(cal.getTime());
        }
        return ret;
    }

    public static SimpleBoundingBox getSimpleBoundingBox(double llx, double lly, double urx, double ury) {
        SimpleBoundingBox box = new SimpleBoundingBox();
        box.setLlx(llx);
        box.setLly(lly);
        box.setUrx(urx);
        box.setUry(ury);
        return box;
    }

    public static int calculateDaysToDraw(Calendar startDate, Calendar endDate) {
        if (CalendarHelper.DATE_ONLY_COMPARATOR.compare(startDate, endDate) < 0) {
            return CalendarHelper.daysBetween((Calendar)startDate, (Calendar)endDate) + 1;
        }
        return CalendarHelper.daysBetween((Calendar)endDate, (Calendar)startDate) + 1;
    }

    public static int calculateMonthToDraw(Calendar startDate, Calendar endDate) {
        if (CalendarHelper.DATE_ONLY_COMPARATOR.compare(startDate, endDate) < 0) {
            return CalendarHelper.monthsBetween((Calendar)startDate, (Calendar)endDate) + 1;
        }
        return CalendarHelper.monthsBetween((Calendar)endDate, (Calendar)startDate) + 1;
    }

    public static int calculateWeeksToDraw(Calendar startDate, Calendar endDate) {
        if (CalendarHelper.DATE_ONLY_COMPARATOR.compare(startDate, endDate) < 0) {
            return CalendarHelper.weeksBetween((Calendar)startDate, (Calendar)endDate, (int)startDate.getFirstDayOfWeek()) + 1;
        }
        return CalendarHelper.weeksBetween((Calendar)endDate, (Calendar)startDate, (int)startDate.getFirstDayOfWeek()) + 1;
    }

    public static RectangleDefinitionContainer createRectangleDefinitions(double x, double y, double lrx, double lry, double rrx, double rry, double width, double height) {
        RectangleDefinitionContainer rectDefs = new RectangleDefinitionContainer();
        rectDefs.setX(x);
        rectDefs.setY(y);
        rectDefs.setLrx(lrx);
        rectDefs.setLry(lry);
        rectDefs.setRrx(rrx);
        rectDefs.setRry(rry);
        rectDefs.setWidth(width);
        rectDefs.setHeight(height);
        return rectDefs;
    }

    public static int calculateTypeOfEdges(ReviewCycleNode node, String logMethode, boolean delayed) {
        int nodePosition = node.getPosition();
        int typeOfEdges = nodePosition == 1 ? 2 : 0;
        typeOfEdges += node.isEndOfCell() && !delayed ? 1 : 0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(logMethode + "node= " + node.getName() + "position= " + nodePosition + " is Endnode= " + node.isEndOfCell() + " typeOfEdges= " + typeOfEdges));
        }
        return typeOfEdges;
    }
}

