/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.person;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.PersonVariables;
import at.cdes.bo.data.role.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Person
implements CdesDataObject {
    static final long serialVersionUID = 1L;
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_MARKED_FOR_DELETION = 1;
    public static final int STATUS_INVALID = 2;
    private Map<Integer, OrganisationPerson> organisationPersons;
    private Integer id;
    private String name;
    private String surName;
    private String title;
    private String gender;
    private Role role;
    private boolean permission;
    private PersonVariables variables;
    private PersonVariables hijackedVariables;
    private String login;
    private String password;
    private Long lastPasswordChangeTs;
    private String securityQuestion;
    private String questionEncryptedPassword;
    private int status;

    public boolean isInvalidated() {
        return this.status == 2;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getGivenName() {
        return this.name;
    }

    public void setGivenName(String name) {
        this.name = name;
    }

    public String getSurName() {
        return this.surName;
    }

    public void setSurName(String surName) {
        this.surName = surName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isHasTitle() {
        return this.title != null && this.title.length() > 0;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public boolean isFemale() {
        return this.gender.equals("f");
    }

    public boolean isMale() {
        return this.gender.equals("m");
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public Map<Integer, OrganisationPerson> getOrganisationPersons() {
        return this.organisationPersons;
    }

    public void setOrganisationPersons(Map<Integer, OrganisationPerson> organisationPersons) {
        this.organisationPersons = organisationPersons;
    }

    public String getCommonName() {
        String commonName = this.name.length() > 0 && this.surName.length() > 0 ? this.name + " " + this.surName : this.name + this.surName;
        return commonName;
    }

    public String getInverseCommonName() {
        String inverseCommonName = this.name.length() > 0 && this.surName.length() > 0 ? this.surName + " " + this.name : this.surName + this.name;
        return inverseCommonName;
    }

    public String getInverseCommonNameLowerCase() {
        return this.getInverseCommonName().toLowerCase();
    }

    public boolean isZtPermission() {
        return this.permission;
    }

    public void setZtPermission(boolean permission) {
        this.permission = permission;
    }

    public PersonVariables getPersonVariables(boolean isHijacked) {
        if (isHijacked) {
            return this.getHijackedVariables();
        }
        return this.getVariables();
    }

    public PersonVariables getVariables() {
        return this.variables;
    }

    public void setVariables(PersonVariables variables) {
        this.variables = variables;
    }

    public PersonVariables getHijackedVariables() {
        return this.hijackedVariables;
    }

    public void setHijackedVariables(PersonVariables hijackedVariables) {
        this.hijackedVariables = hijackedVariables;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQuestionEncryptedPassword() {
        return this.questionEncryptedPassword;
    }

    public void setQuestionEncryptedPassword(String questionEncryptedPassword) {
        this.questionEncryptedPassword = questionEncryptedPassword;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Person.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Person other = (Person)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List getValidOrganisationPersons() {
        Collection<OrganisationPerson> orgPersons = this.organisationPersons.values();
        ArrayList<OrganisationPerson> ret = new ArrayList<OrganisationPerson>();
        for (OrganisationPerson orgPerson : orgPersons) {
            if (orgPerson.isInActive()) continue;
            ret.add(orgPerson);
        }
        return ret;
    }

    public Long getLastPasswordChangeTs() {
        return this.lastPasswordChangeTs;
    }

    public void setLastPasswordChangeTs(Long lastPasswordChangeTs) {
        this.lastPasswordChangeTs = lastPasswordChangeTs;
    }
}

