/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.document;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.document.BaseDocumentVersion;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.sec.DigestCalculatorType;
import java.util.ArrayList;

public class DocumentVersion
extends BaseDocumentVersion
implements CdesDataObject {
    static final long serialVersionUID = 1L;
    public static final int INREVIEW = 1;
    public static final int RELEASEDPOSITIV = 2;
    public static final int RELEASEDNEGATIV = 3;
    public static final int INVALIDATEDVERSION = 4;
    public static final int INVALIDATEDALL = 5;
    public static final int NOTINREVIEW = 6;
    public static final int DELETED = 7;
    public static final int PREREVIEWED = 8;
    public static final int ACTIVE = 9;
    public static final int ASBUILT = 10;
    public static final int NOTUPLOADED = 11;
    public static final int REPLACED = 12;
    public static final int ABORTED = 13;
    private Integer id;
    private Document document;
    private ReviewCycleNodeInstanceImpl actualReviewCycleNodeInstance;
    private String fileDigest;
    private DigestCalculatorType fileDigestDigester;
    private int status;

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public ReviewCycleNode getActualReviewCycleNode() {
        return this.actualReviewCycleNodeInstance.getReviewCycleNode();
    }

    public ReviewCycleNodeInstanceImpl getActualReviewCycleNodeInstance() {
        return this.actualReviewCycleNodeInstance;
    }

    public void setActualReviewCycleNodeInstance(ReviewCycleNodeInstanceImpl actualReviewCycleNodeInstance) {
        this.actualReviewCycleNodeInstance = actualReviewCycleNodeInstance;
    }

    public String getFileDigest() {
        return this.fileDigest;
    }

    public void setFileDigest(String fileDigest) {
        this.fileDigest = fileDigest;
    }

    public DigestCalculatorType getFileDigester() {
        return this.fileDigestDigester;
    }

    public void setFileDigester(DigestCalculatorType fileDigestDigester) {
        this.fileDigestDigester = fileDigestDigester;
    }

    public String getVersionPart() {
        return this.getVersionPartA() + this.getVersionPartSeperator() + this.getVersionPartB();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isInreview() {
        return this.status == 1;
    }

    public boolean isReleased() {
        return this.status == 2;
    }

    public boolean isInvalidated() {
        return this.status == 4;
    }

    public boolean isInvalidatedAll() {
        return this.status == 5;
    }

    public boolean isDeleted() {
        return this.status == 7;
    }

    public boolean isAborted() {
        return this.status == 13;
    }

    public boolean isReplaced() {
        return this.status == 12;
    }

    public boolean isInvalidatedOrDeleted() {
        return this.status == 4 || this.status == 5 || this.status == 7 || this.status == 13;
    }

    public boolean isReleasedInvalidatedOrDeleted() {
        return this.status == 2 || this.status == 4 || this.status == 5 || this.status == 7 || this.status == 8 || this.status == 13;
    }

    public boolean isInAction() {
        return this.status == 1 || this.status == 4 || this.status == 3 || this.status == 7;
    }

    public boolean isReleasedNegative() {
        return this.status == 3;
    }

    public boolean isLastDocumentVersion() {
        BaseDocumentVersion lastVersion;
        ArrayList<DocumentVersion> ret = new ArrayList<DocumentVersion>();
        ret.addAll(this.getDocument().getAllDocumentVersions());
        BaseDocumentVersion baseDocumentVersion = lastVersion = ret.isEmpty() ? null : (DocumentVersion)ret.get(ret.size() - 1);
        if (lastVersion != null && lastVersion.getReactivatedDocumentVersion() != null) {
            lastVersion = lastVersion.getReactivatedDocumentVersion();
        }
        return lastVersion != null && ((DocumentVersion)lastVersion).getId().equals(this.id);
    }

    public boolean isInvalidSubProject() {
        return this.getDocument().getObjectPlanner().getObject().getObjectList().getSubProject().isInvalidated();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!DocumentVersion.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        DocumentVersion other = (DocumentVersion)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

