/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.object;

import at.cdes.bo.data.document.AsBuiltDocumentTO;
import at.cdes.bo.data.object.AsBuiltObjectPlannerPositionTO;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.object.ObjectPlannerPositionImpl;
import at.cdes.bo.data.object.ReleasedCDESObject;
import at.cdes.bo.data.project.ProjectParticipation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.xnap.commons.i18n.I18n;

public class AsBuiltObjectTO
implements Serializable {
    private static final long serialVersionUID = 2057726416024696253L;
    public static final int AS_BUILT_OBJECT = 0;
    public static final int AS_BUILT_OBJECT_PLANNER = 1;
    private int type;
    private Integer id;
    private String code;
    private String name;
    private boolean selected;
    private boolean alreadyCopied;
    private boolean duplicatedCode;
    private boolean hasDocumentVersions;
    private boolean hasReleasedVersions;
    private List<AsBuiltObjectTO> objectPlanners;
    private String plannerName;
    private String assignablePlannerName;
    private String reviewCycleInstanceName;
    private Integer reviewCycleInstanceId;
    private HashMap<Integer, AsBuiltObjectPlannerPositionTO> objectPlannerPositions;
    private List<AsBuiltDocumentTO> documentVersions;
    private boolean plannerUnchangable;
    private String sourceSubProjectText;

    public AsBuiltObjectTO(CDESObjectImpl object, boolean alreadyCopied) {
        this.type = 0;
        this.id = object.getId();
        this.code = object.getCode();
        this.name = object.getName();
        this.selected = false;
        this.duplicatedCode = false;
        this.alreadyCopied = alreadyCopied;
        this.setObjectPlanners(new ArrayList<AsBuiltObjectTO>());
        this.hasReleasedVersions = object.getReleasedVersions() != null && !object.getReleasedVersions().isEmpty();
    }

    public AsBuiltObjectTO(ReleasedCDESObject object, boolean alreadyCopied) {
        this.type = 0;
        this.id = object.getId();
        this.code = object.getCode();
        this.name = object.getName();
        this.selected = false;
        this.duplicatedCode = false;
        this.alreadyCopied = alreadyCopied;
        this.setObjectPlanners(new ArrayList<AsBuiltObjectTO>());
    }

    public AsBuiltObjectTO(ObjectPlannerImpl objectPlanner, boolean alreadyCopied, I18n i18n) {
        Collection<Object> positions;
        this.type = 1;
        this.id = objectPlanner.getId();
        this.code = objectPlanner.getCode();
        this.name = objectPlanner.getArea();
        this.selected = false;
        this.duplicatedCode = false;
        this.alreadyCopied = alreadyCopied;
        this.hasDocumentVersions = false;
        this.plannerUnchangable = false;
        boolean bl = this.hasReleasedVersions = objectPlanner.getReleasedVersions() != null && !objectPlanner.getReleasedVersions().isEmpty();
        if (objectPlanner.getPlanner() != null && objectPlanner.getAsBuiltReference() != null && objectPlanner.getAsBuiltReference().getPlanner() != null && objectPlanner.getPlanner().getId().equals(objectPlanner.getAsBuiltReference().getPlanner().getId())) {
            this.selected = true;
        }
        ProjectParticipation planner = objectPlanner.getPlanner();
        ProjectParticipation assignablePlanner = null;
        if (!this.selected) {
            assignablePlanner = objectPlanner.getAsBuiltReference() != null ? objectPlanner.getAsBuiltReference().getPlanner() : null;
        } else {
            positions = objectPlanner.getPositions().values();
            for (ObjectPlannerPosition objectPlannerPosition : positions) {
                if (!objectPlannerPosition.getRole().isContractorRole()) continue;
                assignablePlanner = objectPlannerPosition.getProjectParticipation().getAsBuiltPlannerParticipation();
                break;
            }
        }
        if (planner != null) {
            this.plannerName = planner.getOrganisation().getName() + " (" + planner.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + ")";
        } else {
            this.plannerName = i18n.tr("Kein Planer definiert");
            this.plannerUnchangable = true;
        }
        if (assignablePlanner != null) {
            this.setAssignablePlannerName(assignablePlanner.getOrganisation().getName() + " (" + assignablePlanner.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + ")");
        } else {
            this.setAssignablePlannerName(i18n.tr("Kein Planer definiert"));
        }
        if (objectPlanner.getReviewCycleInstance() != null) {
            this.reviewCycleInstanceName = objectPlanner.getReviewCycleInstance().getName();
            this.reviewCycleInstanceId = objectPlanner.getReviewCycleInstance().getId();
        }
        this.objectPlannerPositions = new HashMap();
        positions = objectPlanner.getPositionsSortedByName();
        for (ObjectPlannerPositionImpl objectPlannerPositionImpl : positions) {
            if (objectPlannerPositionImpl.getProjectParticipation() == null) continue;
            this.objectPlannerPositions.put(objectPlannerPositionImpl.getId(), new AsBuiltObjectPlannerPositionTO(objectPlannerPositionImpl.getId(), objectPlannerPositionImpl.getRole().getName(), objectPlannerPositionImpl.getProjectParticipation().getOrganisation().getName() + " (" + objectPlannerPositionImpl.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + ")"));
        }
    }

    public String getPositionName(Integer positionId) {
        if (this.objectPlannerPositions == null || this.objectPlannerPositions.get(positionId) == null) {
            return null;
        }
        return this.objectPlannerPositions.get(positionId).getName();
    }

    public String getPositionAssignee(Integer positionId) {
        if (this.objectPlannerPositions == null || this.objectPlannerPositions.get(positionId) == null) {
            return null;
        }
        return this.objectPlannerPositions.get(positionId).getAssignee();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setAlreadyCopied(boolean alreadyCopied) {
        this.alreadyCopied = alreadyCopied;
    }

    public boolean isAlreadyCopied() {
        return this.alreadyCopied;
    }

    public void setObjectPlanners(List<AsBuiltObjectTO> objectPlanners) {
        this.objectPlanners = objectPlanners;
    }

    public List<AsBuiltObjectTO> getObjectPlanners() {
        return this.objectPlanners;
    }

    public void setPlannerName(String plannerName) {
        this.plannerName = plannerName;
    }

    public String getPlannerName() {
        return this.plannerName;
    }

    public void setReviewCycleInstanceName(String reviewCycleInstanceName) {
        this.reviewCycleInstanceName = reviewCycleInstanceName;
    }

    public String getReviewCycleInstanceName() {
        return this.reviewCycleInstanceName;
    }

    public void setReviewCycleInstanceId(Integer reviewCycleInstanceId) {
        this.reviewCycleInstanceId = reviewCycleInstanceId;
    }

    public Integer getReviewCycleInstanceId() {
        return this.reviewCycleInstanceId;
    }

    public void setHasDocumentVersions(boolean hasDocumentVersions) {
        this.hasDocumentVersions = hasDocumentVersions;
    }

    public boolean isHasDocumentVersions() {
        return this.hasDocumentVersions;
    }

    public void setHasReleasedVersions(boolean hasReleasedVersions) {
        this.hasReleasedVersions = hasReleasedVersions;
    }

    public boolean isHasReleasedVersions() {
        return this.hasReleasedVersions;
    }

    public void setObjectPlannerPositions(HashMap<Integer, AsBuiltObjectPlannerPositionTO> objectPlannerPositions) {
        this.objectPlannerPositions = objectPlannerPositions;
    }

    public HashMap<Integer, AsBuiltObjectPlannerPositionTO> getObjectPlannerPositions() {
        return this.objectPlannerPositions;
    }

    public void setDocumentVersions(List<AsBuiltDocumentTO> documentVersions) {
        this.documentVersions = documentVersions;
    }

    public List<AsBuiltDocumentTO> getDocumentVersions() {
        return this.documentVersions;
    }

    public void setPlannerUnchangable(boolean plannerUnchangable) {
        this.plannerUnchangable = plannerUnchangable;
    }

    public boolean isPlannerUnchangable() {
        return this.plannerUnchangable;
    }

    public boolean isAllPlannersUnchangable() {
        if (this.type == 1 || this.objectPlanners == null || this.objectPlanners.isEmpty()) {
            return true;
        }
        for (AsBuiltObjectTO op : this.objectPlanners) {
            if (op.isPlannerUnchangable() || op.isHasDocumentVersions() || op.isHasReleasedVersions()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllObjectPlannersAlreadyCopied() {
        if (this.type == 1 || this.objectPlanners == null || this.objectPlanners.isEmpty()) {
            return true;
        }
        for (AsBuiltObjectTO op : this.objectPlanners) {
            if (op.isAlreadyCopied()) continue;
            return false;
        }
        return true;
    }

    public boolean isPossibleToTakeOverDocuments() {
        if (this.documentVersions != null) {
            for (AsBuiltDocumentTO doc : this.documentVersions) {
                if (doc.getStatus() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAllDocumentsTakenOver() {
        if (this.documentVersions != null) {
            for (AsBuiltDocumentTO doc : this.documentVersions) {
                if (doc.isAlreadyCopied()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isContainingSelectedObjectPlanners() {
        if (this.objectPlanners != null) {
            for (AsBuiltObjectTO op : this.objectPlanners) {
                if (!op.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContainingSelectedDocumentVersions() {
        if (this.documentVersions != null) {
            for (AsBuiltDocumentTO doc : this.documentVersions) {
                if (!doc.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public void setSourceSubProjectText(String sourceSubProjectText) {
        this.sourceSubProjectText = sourceSubProjectText;
    }

    public String getSourceSubProjectText() {
        return this.sourceSubProjectText;
    }

    public void setDuplicatedCode(boolean duplicatedCode) {
        this.duplicatedCode = duplicatedCode;
    }

    public boolean isDuplicatedCode() {
        return this.duplicatedCode;
    }

    public void setAssignablePlannerName(String originalPlannerName) {
        this.assignablePlannerName = originalPlannerName;
    }

    public String getAssignablePlannerName() {
        return this.assignablePlannerName;
    }
}

