/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.document;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.service.ReviewOperations;
import at.cdes.service.exception.FrontendException;
import at.cdes.service.exception.UncheckedWrapperException;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class DocumentVersionHelper {
    private static final Logger log = Logger.getLogger(DocumentVersionHelper.class);

    public static DocumentVersion getDocumentVersionWithBoundingBox(ReviewOperations ro, Integer id) {
        DocumentVersion dv = ro.getDocumentVersion(id);
        if (dv.getLlx() == null || dv.getLly() == null || dv.getUrx() == null || dv.getUry() == null) {
            try {
                log.info((Object)("Reclculating bounding box of document version [id=" + dv.getId() + ",name=" + dv.getName() + "]."));
                dv = ro.updateDocumentVersionBoundingBox(dv);
            }
            catch (FrontendException e) {
                log.error((Object)("Failed to reclculate bounding box of document version [id=" + dv.getId() + ",name=" + dv.getName() + "]."), (Throwable)e);
                throw new UncheckedWrapperException(e);
            }
        }
        return dv;
    }

    public static Locale getProjectLocaleFromDocumentVersion(DocumentVersion dv) {
        return new Locale(dv.getDocument().getDocumentList().getSubProject().getProject().getLocalisation().getCountry().getCode2());
    }
}

