/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.file.CDESDataFile;
import at.cdes.bo.file.FileFinder;
import at.cdes.bo.service.JobInfo;
import at.cdes.service.MailOperations;
import at.cdes.service.ServiceInvocationQueue;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.datetime.UtcTimestamp;

public class ServiceInvocationQueueImpl
extends ConcurrentLinkedQueue<JobInfo>
implements ServiceInvocationQueue {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ServiceInvocationQueueImpl.class);
    private Hashtable<Integer, JobInfo> recentJobs = new Hashtable();
    private MailOperations mailOperations;
    private FileFinder fileFinder;
    private Thread thread;
    private int lastId = 0;
    private String requestThreadLocalKey;
    private String cookieThreadLocalKey;

    public void setRequestThreadLocalKey(String requestThreadLocalKey) {
        this.requestThreadLocalKey = requestThreadLocalKey;
    }

    public void setCookieThreadLocalKey(String cookieThreadLocalKey) {
        this.cookieThreadLocalKey = cookieThreadLocalKey;
    }

    public ServiceInvocationQueueImpl() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"instanciated.");
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start called.");
        }
        this.thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        this.thread.start();
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"stop called.");
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info((Object)"started.");
        while (!this.thread.isInterrupted()) {
            JobInfo job = this.getNextInvocation();
            if (job == null) {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Next job is 'null', will leave main loop now ...");
                break;
            }
            UtcTimestamp ended = null;
            Object result = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("going to invoke [" + job.getMethodName() + "] "));
                }
                job.setStarted(new UtcTimestamp(TimeZone.getDefault()));
                ThreadLocalManager.bindResource((String)this.cookieThreadLocalKey, (Object)job.getCookie());
                try {
                    result = job.getJoinpoint().proceed();
                }
                finally {
                    ThreadLocalManager.unbindResource((String)this.cookieThreadLocalKey);
                }
                ended = new UtcTimestamp(TimeZone.getDefault());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result of invocation [" + job.getMethodName() + "] is: [" + (result == null ? "null" : result.toString()) + "]"));
                }
                job.setResult(result);
                job.setEnded(ended);
            }
            catch (Throwable t) {
                result = t;
                ended = new UtcTimestamp(TimeZone.getDefault());
                job.setResult(result);
                job.setEnded(ended);
                log.error((Object)("Can't proceed on joinpoint [" + job.getMethodName() + "]"), t);
                this.sendErrorMail(job, t);
            }
        }
        log.info((Object)("finished, there are [" + this.size() + "] queued invocation's lost."));
    }

    private void sendErrorMail(JobInfo job, Throwable t) {
        StackTraceElement[] stackTrace;
        if (job == null || t == null) {
            return;
        }
        StringBuffer body = new StringBuffer();
        body.append("The invocation of job");
        body.append("\n");
        body.append("\n");
        body.append("Job:          ");
        body.append(job.getMethodName());
        body.append("\n");
        body.append("Stored at:    ");
        body.append(job.getStored().toString());
        body.append("\n");
        body.append("Started at:   ");
        body.append(job.getStarted().toString());
        body.append("\n");
        body.append("Finished at:  ");
        body.append(job.getEnded().toString());
        body.append("\n\n");
        body.append("returned the follwing ERROR:");
        body.append("\n\n");
        body.append(t.getMessage());
        body.append("\n\n\n");
        body.append("Detailed ERROR description:");
        body.append("\n\n");
        for (StackTraceElement ste : stackTrace = t.getStackTrace()) {
            body.append("    ");
            body.append(ste.toString());
            body.append("\n");
        }
        body.append("\n\n\n");
        body.append("This is a generated message. Please do not reply.");
        body.append("\n");
        String subject = "[c.des] ERROR occured at invocation of: " + job.getMethodName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("prepared email subject: " + subject));
            log.debug((Object)("prepared email body:\n" + body.toString()));
        }
        this.mailOperations.createJobNotificationMail(job, subject, body.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInvocation(JobInfo job) {
        HttpServletRequest req = (HttpServletRequest)ThreadLocalManager.getBoundResource((String)this.requestThreadLocalKey);
        if (req == null) {
            log.warn((Object)"No HttpServletRequest stored in thread local.");
        } else {
            job.setCookie(req.getHeader("Cookie"));
        }
        if (job == null) {
            return;
        }
        job.setStored(new UtcTimestamp(TimeZone.getDefault()));
        job.setId(this.generateNextId());
        job.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.cleanupRecentJobs();
        ServiceInvocationQueueImpl serviceInvocationQueueImpl = this;
        synchronized (serviceInvocationQueueImpl) {
            this.getRecentJobs().put(job.getId(), job);
            super.add(job);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Job added: [" + job.getMethodName() + "]."));
            }
            this.notifyAll();
        }
    }

    private synchronized Integer generateNextId() {
        return new Integer(++this.lastId);
    }

    protected synchronized JobInfo getNextInvocation() {
        while (this.isEmpty()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Will wait for one minute to retrieve next MethodInvocation to be invoked ...");
                }
                this.wait(60000L);
            }
            catch (InterruptedException e) {
                log.info((Object)"Interrupted while waiting for next MethodInvocation to be invoked.");
                return null;
            }
        }
        return (JobInfo)this.poll();
    }

    @Override
    public List<JobInfo> getRecentJobInfos() {
        Enumeration<JobInfo> jobs = this.getRecentJobs().elements();
        ArrayList<JobInfo> ret = new ArrayList<JobInfo>(this.getRecentJobs().size());
        while (jobs.hasMoreElements()) {
            ret.add(jobs.nextElement());
        }
        return ret;
    }

    private void cleanupRecentJobs() {
        Enumeration<JobInfo> e = this.getRecentJobs().elements();
        UtcTimestamp border = new UtcTimestamp(TimeZone.getDefault());
        border.add(5, -7);
        Hashtable<Integer, JobInfo> remainingJobs = new Hashtable<Integer, JobInfo>();
        while (e.hasMoreElements()) {
            JobInfo job = e.nextElement();
            if (job.getEnded() == null || job.getEnded().after(border)) {
                remainingJobs.put(job.getId(), job);
                continue;
            }
            try {
                if (!this.deleteRecentJobInfoFile(job.getId())) {
                    log.error((Object)("could not delete physical file of archive for job with id=[" + job.getId() + "]"));
                    continue;
                }
                log.debug((Object)("sucessfully deleted physical file of archive for job with id=[" + job.getId() + "]"));
            }
            catch (FileHandleException e1) {
                log.error((Object)"could not delete physical file of archive", (Throwable)e1);
            }
        }
        this.setRecentJobs(remainingJobs);
    }

    private synchronized Hashtable<Integer, JobInfo> getRecentJobs() {
        return this.recentJobs;
    }

    private synchronized void setRecentJobs(Hashtable<Integer, JobInfo> recentJobs) {
        this.recentJobs = recentJobs;
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }

    @Override
    public JobInfo getRecentJobInfo(Integer id) {
        return this.getRecentJobs().get(id);
    }

    @Override
    public void deleteRecentJobInfo(Integer id) {
        this.getRecentJobs().remove(id);
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    @Override
    public boolean deleteRecentJobInfoFile(Integer jobId) throws FileHandleException {
        JobInfo jobInfo = this.getRecentJobs().get(jobId);
        if (jobInfo != null && jobInfo.getResult() != null) {
            if (jobInfo.getResult() instanceof CDESDataFile) {
                CDESDataFile df = (CDESDataFile)jobInfo.getResult();
                File findFile = this.fileFinder.findFile(df);
                return findFile == null ? false : findFile.delete();
            }
            return true;
        }
        return false;
    }
}

