/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentType;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.data.network.MasterDataSet;
import at.cdes.bo.data.network.Network;
import at.cdes.db.dao.DocumentTypeDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class DocumentTypeDAOHibernate
extends HibernateDaoSupport
implements DocumentTypeDAO {
    @Override
    public DocumentType get(Integer id) {
        return (DocumentType)this.getSession().get(DocumentType.class, (Serializable)id);
    }

    @Override
    public List getAll(Network network, int type, MasterDataSet masterDataSet) {
        Criteria crit = this.getSession().createCriteria(DocumentType.class);
        if (network != null) {
            crit.createCriteria("network").add(Restrictions.idEq((Object)network.getId()));
        }
        if (masterDataSet != null) {
            crit.createCriteria("masterDataSet").add(Restrictions.idEq((Object)masterDataSet.getId()));
        }
        if (type == 1) {
            crit.add(Restrictions.isNull((String)"documentTypeGroup")).add(Restrictions.isEmpty((String)"documentTypes"));
        } else if (type == 0) {
            crit.add(Restrictions.isNotNull((String)"documentTypeGroup"));
        } else if (type == 3) {
            crit.add(Restrictions.isNull((String)"documentTypeGroup"));
        } else if (type == 2) {
            crit.add(Restrictions.isEmpty((String)"documentTypes"));
        }
        crit.addOrder(Order.asc((String)"code"));
        return crit.list();
    }

    @Override
    public DocumentType save(DocumentType cons) {
        return this.get((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public DocumentType update(DocumentType cons) {
        ArrayList labelContents = new ArrayList(cons.getLabelContents().values());
        cons = (DocumentType)this.getSession().merge((Object)cons);
        for (LabelContent lc : labelContents) {
            cons.getLabelContents().put(lc.getId(), lc);
        }
        this.getSession().update((Object)cons);
        return cons;
    }

    @Override
    public void delete(DocumentType cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public void deleteDocumentType(DocumentType type) {
        this.getSession().delete((Object)type);
    }

    @Override
    public boolean isDeletable(DocumentType type) {
        if (type.getLabelContents() != null && type.getLabelContents().size() > 0) {
            return false;
        }
        Criteria crit = this.getSession().createCriteria(DocumentImpl.class);
        crit.createCriteria("documentType").add(Restrictions.idEq((Object)type.getId()));
        List docImpls = crit.list();
        if (docImpls != null && docImpls.size() > 0) {
            return false;
        }
        Criteria crit2 = this.getSession().createCriteria(ReleasedDocument.class);
        crit2.createCriteria("documentType").add(Restrictions.idEq((Object)type.getId()));
        List relDocs = crit.list();
        return relDocs == null || relDocs.size() <= 0;
    }
}

