/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.db.dao.OrganisationDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class OrganisationDAOHibernate
extends HibernateDaoSupport
implements OrganisationDAO {
    static Logger logger = Logger.getLogger(OrganisationDAOHibernate.class);

    @Override
    public Organisation get(Integer id) {
        return (Organisation)this.getSession().load(Organisation.class, (Serializable)id);
    }

    @Override
    public List<Organisation> getByName(String name) {
        Criteria crit = this.getSession().createCriteria(Organisation.class).add((Criterion)Restrictions.like((String)"name", (Object)(name + "%")));
        return crit.list();
    }

    @Override
    public List getAll(Integer networkId, Integer networkMemberId, String filter) {
        Criteria crit = this.getSession().createCriteria(Organisation.class);
        crit.add((Criterion)Restrictions.eq((String)"consortiumHead", (Object)false));
        if (filter != null) {
            if (filter.length() == 1) {
                char c = (filter = filter.toLowerCase()).charAt(0);
                if (c == 'a') {
                    crit.add((Criterion)Restrictions.lt((String)"name", (Object)"b"));
                } else if (c == 'z') {
                    crit.add((Criterion)Restrictions.ge((String)"name", (Object)"z"));
                } else {
                    crit.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)"name", (Object)String.valueOf(c)), (Criterion)Restrictions.lt((String)"name", (Object)String.valueOf((char)(c + '\u0001')))));
                }
            } else {
                crit.add((Criterion)Restrictions.like((String)"name", (Object)(filter + "%")));
            }
        }
        if (networkId != null) {
            crit.createCriteria("networks").add(Restrictions.idEq((Object)networkId));
        } else if (networkMemberId != null) {
            crit.createCriteria("networks").createCriteria("organisations").add(Restrictions.idEq((Object)networkMemberId));
        }
        return crit.list();
    }

    @Override
    public Organisation save(Organisation organisation) {
        return this.get((Integer)this.getSession().save((Object)organisation));
    }

    @Override
    public void delete(Organisation organisation) {
        this.getSession().delete((Object)organisation);
    }

    @Override
    public Organisation update(Organisation organisation) {
        ArrayList consortiums = new ArrayList(organisation.getConsortiums().values());
        ArrayList consirtiumMembers = new ArrayList(organisation.getConsortiumMembers().values());
        ArrayList networks = new ArrayList(organisation.getNetworks().values());
        organisation = (Organisation)this.getSession().merge((Object)organisation);
        for (Organisation cons : consortiums) {
            organisation.getConsortiums().put(cons.getId(), cons);
        }
        for (Organisation consMem : consirtiumMembers) {
            organisation.getConsortiumMembers().put(consMem.getId(), consMem);
        }
        for (Network net : networks) {
            organisation.getNetworks().put(net.getId(), net);
        }
        this.getSession().update((Object)organisation);
        return organisation;
    }

    @Override
    public List<Organisation> getOtherNetworksAll(Integer networkId, String filter) {
        Criteria crit = this.getSession().createCriteria(Organisation.class).add((Criterion)Restrictions.eq((String)"consortiumHead", (Object)false));
        if (filter != null) {
            crit.add((Criterion)Restrictions.like((String)"name", (Object)(filter + "%")));
        }
        if (networkId != null) {
            crit.createCriteria("networks").add(Restrictions.not((Criterion)Restrictions.idEq((Object)networkId)));
        }
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    @Override
    public int getActiveOrganisationCount() {
        Criteria crit = this.getSession().createCriteria(Organisation.class);
        crit.setProjection((Projection)Projections.count((String)"id"));
        List list = crit.list();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        return (Integer)list.get(0);
    }
}

