/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.document;

import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import java.io.Serializable;

public class AsBuiltDocumentTO
implements Serializable {
    private static final long serialVersionUID = -3743557948400932607L;
    public static final int STATUS_NOT_TAKEN_OVER_YET = 0;
    public static final int STATUS_ALREADY_TAKEN_OVER = 1;
    public static final int STATUS_NO_DESTINATION_CELL_FOUND = 2;
    public static final int STATUS_NAME_CONFLICT = 3;
    private Integer id;
    private final String name;
    private final String content;
    private final Integer objectPlannerId;
    private final String objectPlannerText;
    private int status;
    private boolean selected;
    private Integer documentVersionId;
    private String documentVersionName;
    private String destinationDocumentVersionName;
    private String uploadComment;
    private String versionPartA;
    private String versionPartB;
    private String versionPartSeparator;
    private String destinationDocumentImplName;
    private Integer destinationDocumentImplId;

    public AsBuiltDocumentTO(Document destinationDocument, ReleasedObjectPlanner op, int status) {
        DocumentVersion sourceDocumentVersion = null;
        DocumentVersion destinationDocumentlastVersion = destinationDocument.getLastDocumentVersion();
        if (destinationDocumentlastVersion.getAsBuiltReference() != null) {
            sourceDocumentVersion = destinationDocument.getLastDocumentVersion().getAsBuiltReference();
        }
        this.id = destinationDocument.getId();
        this.objectPlannerId = op.getId();
        this.objectPlannerText = op.getCode() + " [" + op.getReviewCycleInstance().getName() + "] " + (op.getPlanner() != null ? op.getPlanner().getOrganisation().getName() : "");
        this.status = status;
        this.selected = false;
        if (destinationDocumentlastVersion != null) {
            this.documentVersionId = destinationDocumentlastVersion.getId();
            if (sourceDocumentVersion != null) {
                this.name = sourceDocumentVersion.getDocument().getName();
                this.content = sourceDocumentVersion.getDocument().getContent();
                this.documentVersionName = sourceDocumentVersion.getName();
                this.destinationDocumentVersionName = destinationDocumentlastVersion.getName();
                this.destinationDocumentImplName = destinationDocument.getName();
            } else {
                this.name = destinationDocument.getName();
                this.content = destinationDocument.getContent();
                this.documentVersionName = destinationDocumentlastVersion.getName();
            }
        } else {
            this.documentVersionName = destinationDocument.getName();
            this.name = destinationDocument.getName();
            this.content = destinationDocument.getContent();
        }
    }

    public AsBuiltDocumentTO(Document document, ReleasedObjectPlanner op, int status, String destinationDocumentVersionName, String versionPartA, String versionPartB, String versionPartSeparator, Integer destinationDocumentImplId, String destinationDocumentImplName) {
        this.id = document.getId();
        this.name = document.getName();
        this.content = document.getContent();
        this.objectPlannerId = op.getId();
        this.objectPlannerText = op.getCode() + " [" + op.getReviewCycleInstance().getName() + "] " + (op.getPlanner() != null ? op.getPlanner().getOrganisation().getName() : "");
        this.status = status;
        this.selected = false;
        if (!this.isAlreadyCopied()) {
            DocumentVersion lastVersion = document.getLastDocumentVersion();
            if (lastVersion != null) {
                this.documentVersionId = lastVersion.getId();
                this.documentVersionName = lastVersion.getName();
            }
            this.destinationDocumentVersionName = destinationDocumentVersionName;
            this.versionPartA = versionPartA;
            this.versionPartB = versionPartB;
            this.versionPartSeparator = versionPartSeparator;
            this.destinationDocumentImplId = destinationDocumentImplId;
            this.destinationDocumentImplName = destinationDocumentImplName;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getObjectPlannerId() {
        return this.objectPlannerId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getObjectPlannerText() {
        return this.objectPlannerText;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.objectPlannerId == null ? 0 : this.objectPlannerId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsBuiltDocumentTO other = (AsBuiltDocumentTO)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.objectPlannerId == null ? other.objectPlannerId != null : !this.objectPlannerId.equals(other.objectPlannerId));
    }

    public void setDocumentVersionId(Integer documentVersionId) {
        this.documentVersionId = documentVersionId;
    }

    public Integer getDocumentVersionId() {
        return this.documentVersionId;
    }

    public void setDocumentVersionName(String documentVersionName) {
        this.documentVersionName = documentVersionName;
    }

    public String getDocumentVersionName() {
        return this.documentVersionName;
    }

    public void setDestinationDocumentVersionName(String destinationDocumentVersionName) {
        this.destinationDocumentVersionName = destinationDocumentVersionName;
    }

    public String getDestinationDocumentVersionName() {
        return this.destinationDocumentVersionName;
    }

    public void setUploadComment(String uploadComment) {
        this.uploadComment = uploadComment;
    }

    public String getUploadComment() {
        return this.uploadComment;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isPossibleToTakeOver() {
        return this.status == 0;
    }

    public boolean isNameConflict() {
        return this.status == 3;
    }

    public boolean isAlreadyCopied() {
        return this.status == 1;
    }

    public boolean isNoDestinationCellFound() {
        return this.status == 2;
    }

    public void setVersionPartA(String versionPartA) {
        this.versionPartA = versionPartA;
    }

    public String getVersionPartA() {
        return this.versionPartA;
    }

    public String getVersionPartB() {
        return this.versionPartB;
    }

    public void setVersionPartB(String versionPartB) {
        this.versionPartB = versionPartB;
    }

    public String getVersionPartSeparator() {
        return this.versionPartSeparator;
    }

    public void setVersionPartSeparator(String versionPartSeparator) {
        this.versionPartSeparator = versionPartSeparator;
    }

    public void setDestinationDocumentImplName(String destinationDocumentImplName) {
        this.destinationDocumentImplName = destinationDocumentImplName;
    }

    public String getDestinationDocumentImplName() {
        return this.destinationDocumentImplName;
    }

    public void setDestinationDocumentImplId(Integer destinationDocumentImplId) {
        this.destinationDocumentImplId = destinationDocumentImplId;
    }

    public Integer getDestinationDocumentImplId() {
        return this.destinationDocumentImplId;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

