/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.action.impl;

import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.role.RoleMapEntry;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ProjectParticipantDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.RoleDAO;
import java.util.List;
import org.apache.log4j.Logger;

public class ProjectValidator {
    protected RoleDAO roleDAO;
    protected ProjectDAO projectDAO;
    protected ProjectParticipationDAO projectParticipationDAO;
    protected ProjectParticipantDAO projectParticipantDAO;
    static Logger logger = Logger.getLogger((String)"Action validation");

    public boolean validateAction(List projectRoles, ActionRule action) {
        for (RoleMapEntry entry : projectRoles) {
            if (!this.validateAction(entry, action)) continue;
            return true;
        }
        return false;
    }

    public boolean validateAction(RoleMapEntry entry, ActionRule action) {
        Role role = this.roleDAO.get(entry.getId());
        return role.hasAction(action.getAction().getName());
    }

    public boolean validateAction(Role role, ActionRule action) {
        return role.hasAction(action.getAction().getName());
    }

    public boolean validateMember(Project project, OrganisationPerson organisationPerson) {
        List participants = this.projectParticipantDAO.getForProjectAndOrganisationPerson(project, organisationPerson);
        return participants != null && participants.size() > 0;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO ppDAO) {
        this.projectParticipationDAO = ppDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }
}

