/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.helper;

import at.cdes.bo.data.meta.PlanningNotificationDateMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationTextMetaInformation;
import at.cdes.bo.data.planningNotification.PlanningNotification;
import at.cdes.oldGwtDto.DateMetaInformationFilterDTO;
import at.cdes.oldGwtDto.MetaInformationFilterDTO;
import at.cdes.oldGwtDto.PNFilterDTO;
import at.cdes.oldGwtDto.TextMetaInformationFilterDTO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class PlanningNotificationFilterEvaluationHelper {
    public static List<PlanningNotification> filterPlanningNotifications(PNFilterDTO filter, List<PlanningNotification> planningNotifications) {
        if (filter == null || PlanningNotificationFilterEvaluationHelper.isFilterEmpty(filter)) {
            return planningNotifications;
        }
        ArrayList<PlanningNotification> memberFilteredNotifications = new ArrayList<PlanningNotification>();
        for (PlanningNotification pn : planningNotifications) {
            boolean isValid = true;
            boolean hasFilterBeenApplied = true;
            if (!hasFilterBeenApplied || isValid) {
                hasFilterBeenApplied = filter.getTitle() != null && filter.getTitle().size() > 0;
                List<String> titleFilters = filter.getTitle();
                boolean anyFilterMatched = false;
                if (titleFilters != null) {
                    for (String titleFilter : titleFilters) {
                        if (pn.getTitle() == null || !pn.getTitle().trim().toLowerCase().contains(titleFilter.trim().toLowerCase())) continue;
                        isValid = true;
                        anyFilterMatched = true;
                    }
                }
                if (!anyFilterMatched && hasFilterBeenApplied) {
                    isValid = false;
                }
            }
            if (!hasFilterBeenApplied || isValid) {
                hasFilterBeenApplied = PlanningNotificationFilterEvaluationHelper.isToFilter(filter.getComment());
                if (PlanningNotificationFilterEvaluationHelper.containsAny(filter.getComment(), pn.getComment(), false)) {
                    isValid = true;
                } else if (hasFilterBeenApplied) {
                    isValid = false;
                }
            }
            if (!isValid) continue;
            memberFilteredNotifications.add(pn);
        }
        ArrayList<PlanningNotification> metaFilteredNotifications = new ArrayList<PlanningNotification>();
        for (PlanningNotification notification : memberFilteredNotifications) {
            boolean allMetaFiltersValid = true;
            if (filter.getMetaFilters() != null) {
                for (MetaInformationFilterDTO metaFilter : filter.getMetaFilters()) {
                    Integer metaTagId = metaFilter.getMetaTagId();
                    boolean multiple = false;
                    ArrayList<PlanningNotificationMetaInformation> metaInfos = new ArrayList<PlanningNotificationMetaInformation>();
                    for (PlanningNotificationMetaInformation currMetaInfo : notification.getPlanningNotificationMetaInformations().values()) {
                        if (!currMetaInfo.getMetaTag().getId().equals(metaTagId)) continue;
                        if (currMetaInfo.getMetaTag().isMultiple()) {
                            multiple = true;
                        }
                        metaInfos.add(currMetaInfo);
                    }
                    if (metaTagId == null || metaFilter.isEmpty()) continue;
                    boolean anyMetaInfoMatches = false;
                    for (PlanningNotificationMetaInformation metaInfo : metaInfos) {
                        if (metaFilter instanceof DateMetaInformationFilterDTO) {
                            Date dateToFilter = null;
                            if (metaInfo instanceof PlanningNotificationDateMetaInformation && ((PlanningNotificationDateMetaInformation)metaInfo).getValue() != null) {
                                dateToFilter = ((PlanningNotificationDateMetaInformation)metaInfo).getValue().getTime();
                            }
                            if (!PlanningNotificationFilterEvaluationHelper.isContained(((DateMetaInformationFilterDTO)metaFilter).getFrom(), ((DateMetaInformationFilterDTO)metaFilter).getUntil(), dateToFilter)) continue;
                            anyMetaInfoMatches = true;
                            continue;
                        }
                        if (!(metaFilter instanceof TextMetaInformationFilterDTO)) continue;
                        String stringToFilter = null;
                        if (!(metaInfo instanceof PlanningNotificationTextMetaInformation)) continue;
                        stringToFilter = ((PlanningNotificationTextMetaInformation)metaInfo).getValue();
                        if (!PlanningNotificationFilterEvaluationHelper.containsAny(((TextMetaInformationFilterDTO)metaFilter).getValue(), stringToFilter, false)) continue;
                        anyMetaInfoMatches = true;
                    }
                    if (anyMetaInfoMatches) continue;
                    allMetaFiltersValid = false;
                }
            }
            if (!allMetaFiltersValid) continue;
            metaFilteredNotifications.add(notification);
        }
        return metaFilteredNotifications;
    }

    private static boolean isFilterEmpty(PNFilterDTO filter) {
        boolean hasFilters = PlanningNotificationFilterEvaluationHelper.isToFilter(filter.getProjectId(), filter.getComment(), filter.getTitle());
        if (hasFilters) {
            return false;
        }
        if (filter.getMetaFilters() != null) {
            for (MetaInformationFilterDTO metaFilter : filter.getMetaFilters()) {
                if ((!(metaFilter instanceof DateMetaInformationFilterDTO) || !PlanningNotificationFilterEvaluationHelper.isToFilter(((DateMetaInformationFilterDTO)metaFilter).getFrom(), ((DateMetaInformationFilterDTO)metaFilter).getUntil())) && (!(metaFilter instanceof TextMetaInformationFilterDTO) || !PlanningNotificationFilterEvaluationHelper.isToFilter(((TextMetaInformationFilterDTO)metaFilter).getValue()))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isToFilter(Object ... values) {
        for (Object value : values) {
            if (value == null || (!(value instanceof String) || ((String)value).trim().isEmpty()) && !(value instanceof Date) && !(value instanceof Integer)) continue;
            return true;
        }
        return false;
    }

    private static boolean isContained(Date filterFromDate, Date filterUntilDate, Calendar dateToFilter) {
        return PlanningNotificationFilterEvaluationHelper.isContained(filterFromDate, filterUntilDate, dateToFilter != null ? dateToFilter.getTime() : null);
    }

    private static boolean isContained(Date filterFromDate, Date filterUntilDate, Date dateToFilter) {
        return dateToFilter != null && (filterFromDate == null || !filterFromDate.after(dateToFilter)) && (filterUntilDate == null || !filterUntilDate.before(dateToFilter));
    }

    private static boolean containsAny(String filterStrings, String stringToFilter, boolean isOROperator) {
        if (filterStrings == null || filterStrings.trim().isEmpty() || stringToFilter == null || stringToFilter.trim().isEmpty()) {
            return false;
        }
        boolean allParts = false;
        for (String fs : filterStrings.trim().toLowerCase().split(" ")) {
            if (isOROperator && stringToFilter.toLowerCase().contains(fs)) {
                return true;
            }
            allParts = stringToFilter.toLowerCase().contains(fs);
        }
        return allParts;
    }
}

