/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.db.SchemaUpdateSnippet;
import at.cdes.db.schema.SchemaUpdate_0_268_Remove;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUpdate_0_269_Remove
implements SchemaUpdateSnippet {
    private static final Logger log = LoggerFactory.getLogger(SchemaUpdate_0_268_Remove.class);

    @Override
    public String getTargetVersion() {
        return "0.269";
    }

    @Override
    public String getUpdateComment() {
        return "Add a delete cascade to position_result_attachment_map.";
    }

    private void addCascade(ISchemaEngine schemaEngine, String table, String foreignKey) throws SQLException {
        log.info("Getting key and table info for {} and {}", (Object)table, (Object)foreignKey);
        TableInfo tableInfo = schemaEngine.fetchTableInfo(table, null);
        if (tableInfo == null) {
            log.error("Did not find table {}.", (Object)table);
            return;
        }
        ForeignKeyInfo keyInfo = tableInfo.getForeignKeyInfo(foreignKey);
        if (keyInfo == null) {
            log.error("Did not find foreign key {} in table {}.", (Object)foreignKey, (Object)table);
            return;
        }
        if (keyInfo.getDeleteRule() == 0) {
            return;
        }
        keyInfo.setDeleteRule((short)0);
        schemaEngine.dropForeignKey(tableInfo, foreignKey);
        schemaEngine.addForeignKey(tableInfo, keyInfo);
    }

    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        this.addCascade(schemaEngine, "position_result_attachment_map", "att_fk");
        this.addCascade(schemaEngine, "position_result_attachment_map", "res_fk");
    }
}

