/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.cycle.listener;

import at.cdes.bo.cycle.EvaluationException;
import at.cdes.bo.cycle.ReviewCycleActionListenerEvaluator;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeActionListenerType;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeInstanceListener;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeListener;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.mail.NodeListenerEMailSnippet;
import at.cdes.bo.data.notification.ReviewCycleNodeInstanceNotification;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.service.ReviewCycleNodeActionListener;
import at.cdes.bo.service.ReviewCycleNodeActionListenerProperty;
import at.cdes.db.dao.EMailDAO;
import at.cdes.db.dao.NotificationDAO;
import at.cdes.db.dao.ReviewCycleNodeResultDAO;
import at.cdes.service.MailOperations;
import java.io.Serializable;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class NotificationListener
implements Serializable,
ReviewCycleNodeActionListener {
    private static Logger log = Logger.getLogger(NotificationListener.class);
    private MailOperations mailOperations;
    private static String mimeSource = "documentVersionMimeSource";
    private static final long serialVersionUID = 1L;
    private final String prettyName = "NotificationListener";
    private NotificationDAO notificationDAO;
    private EMailDAO mailDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewCycleActionListenerEvaluator evaluator;

    @Override
    public void listen(ReviewCycleNodeActionListenerProperty property) {
        ReviewCycleNodeInstanceListener listener = property.getListener();
        DocumentVersion version = property.getVersion();
        Object[] parameters = new Object[]{version.getId()};
        if (!this.evaluate(version, listener.getReviewCycleNodeListener())) {
            return;
        }
        ReviewCycleNodeInstanceImpl nodeInstance = version.getActualReviewCycleNodeInstance();
        List nots = this.notificationDAO.getAll(nodeInstance.getId());
        if (nots == null || nots.size() == 0) {
            return;
        }
        Iterator it = nots.iterator();
        GregorianCalendar now = new GregorianCalendar();
        while (it.hasNext()) {
            ReviewCycleNodeInstanceNotification not = (ReviewCycleNodeInstanceNotification)it.next();
            ReviewCycleNodeListener nodeListener = not.getReviewCycleNodeListener();
            Collection<OrganisationPerson> rec = not.getRecievers();
            if (rec == null) break;
            Iterator<OrganisationPerson> it2 = rec.iterator();
            while (it2.hasNext()) {
                NodeListenerEMailSnippet snippet = new NodeListenerEMailSnippet();
                OrganisationPerson op = it2.next();
                snippet.setOrganisationPersonId(op.getId());
                snippet.setSendTime(op.getNextEMailSendTime(now));
                snippet.setDocumentVersion(version);
                snippet.setNodeListener(nodeListener);
                if (snippet.getSendTime() == null) continue;
                this.mailDAO.insertSnippet(snippet);
            }
            for (ProjectParticipation pp : not.getReference().values()) {
                this.mailOperations.createAttachmentMailForProjectParticipation(version, pp);
            }
        }
    }

    private boolean evaluate(DocumentVersion version, ReviewCycleNodeActionListenerType type) {
        if (type.getRule() == null) {
            return true;
        }
        ReviewCycleNodeResult res = this.reviewCycleNodeResultDAO.get(version.getActualReviewCycleNode(), version);
        try {
            return this.evaluator.evaluateCondition(res, type.getRule());
        }
        catch (EvaluationException e) {
            return false;
        }
    }

    public void setNotificationDAO(NotificationDAO notificationDAO) {
        this.notificationDAO = notificationDAO;
    }

    @Override
    public String getName() {
        return "NotificationListener";
    }

    public void setMailDAO(EMailDAO mailDAO) {
        this.mailDAO = mailDAO;
    }

    public void setRuleEvaluator(ReviewCycleActionListenerEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }
}

