/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.project;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.ProjectParticipantDateHistoryPart;
import at.cdes.bo.data.project.ProjectParticipantDateHistoryPartComparator;
import at.cdes.bo.data.project.ProjectParticipation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ProjectParticipant
implements CdesDataObject {
    static final long serialVersionUID = 1L;
    private Integer id;
    private String inactiveComment;
    private boolean inactive;
    private boolean mainParticipant;
    private OrganisationPerson organisationPerson;
    private ProjectParticipation participation;
    private Date created;
    private Date inactivated;
    private Map dateHistory;

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    public String getInactiveComment() {
        return this.inactiveComment;
    }

    public void setInactiveComment(String inactiveComment) {
        this.inactiveComment = inactiveComment;
    }

    public boolean isMainParticipant() {
        return this.mainParticipant;
    }

    public void setMainParticipant(boolean mainParticipant) {
        this.mainParticipant = mainParticipant;
    }

    public OrganisationPerson getOrganisationPerson() {
        return this.organisationPerson;
    }

    public void setOrganisationPerson(OrganisationPerson organisationPerson) {
        this.organisationPerson = organisationPerson;
    }

    public ProjectParticipation getParticipation() {
        return this.participation;
    }

    public void setParticipation(ProjectParticipation participation) {
        this.participation = participation;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getInactivated() {
        return this.inactivated;
    }

    public void setInactivated(Date inactivated) {
        this.inactivated = inactivated;
    }

    public Map getDateHistory() {
        return this.dateHistory;
    }

    public void setDateHistory(Map dateHistory) {
        this.dateHistory = dateHistory;
    }

    public ProjectParticipantDateHistoryPart getLastDateHistoryPart() {
        List<ProjectParticipantDateHistoryPart> parts = this.getDateHistorySortedByDate(false);
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        return parts.get(0);
    }

    public List<ProjectParticipantDateHistoryPart> getDateHistorySortedByDate(boolean asc) {
        if (this.getDateHistory() == null) {
            return null;
        }
        ArrayList<ProjectParticipantDateHistoryPart> ret = new ArrayList<ProjectParticipantDateHistoryPart>();
        ret.addAll(this.getDateHistory().values());
        Collections.sort(ret, new ProjectParticipantDateHistoryPartComparator(asc));
        return ret;
    }

    public List<Integer> getParticipationParticipantsOrgPersonIds() {
        ArrayList<Integer> orgPersonIds = new ArrayList<Integer>();
        if (this.getParticipation().getProjectParticipants().values() != null && !this.getParticipation().getProjectParticipants().values().isEmpty()) {
            for (ProjectParticipant projectParticipant : this.getParticipation().getProjectParticipants().values()) {
                orgPersonIds.add(projectParticipant.getOrganisationPerson().getId());
            }
        }
        return orgPersonIds;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ProjectParticipant.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ProjectParticipant other = (ProjectParticipant)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

