/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.data.role.RoleType;
import at.cdes.db.dao.RoleDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class RoleDAOHibernate
extends HibernateDaoSupport
implements RoleDAO {
    @Override
    public Role get(Integer id) {
        return (Role)this.getSession().load(Role.class, (Serializable)id);
    }

    public List getAll(Network network) {
        if (network == null) {
            return this.findHibernate("from Role where network is null");
        }
        return this.findHibernate("from Role where network.id = ?", network.getId());
    }

    @Override
    public List getAll(Integer networkId, int projectFlag) {
        boolean range = false;
        if (projectFlag < 0) {
            range = true;
            projectFlag = Math.abs(projectFlag);
        }
        if (projectFlag < 7) {
            if (networkId == null) {
                return this.findHibernate("from Role where network is null and projectFlag " + (range ? ">= ? and projectFlag < 7" : "= ?"), projectFlag);
            }
            Network n = (Network)this.getSession().load(Network.class, (Serializable)networkId);
            return this.findHibernate("from Role where network.id = ? and projectFlag " + (range ? ">= ? and projectFlag < 7" : "= ?"), new Object[]{n.getId(), projectFlag});
        }
        if (networkId == null) {
            return this.findHibernate("from Role where network is null and projectFlag " + (range ? ">= ?" : "= ?"), projectFlag);
        }
        Network n = (Network)this.getSession().load(Network.class, (Serializable)networkId);
        return this.findHibernate("from Role where network.id = ? and projectFlag " + (range ? ">= ?" : "= ?"), new Object[]{n.getId(), projectFlag});
    }

    @Override
    public Role save(Role role) {
        return this.get((Integer)this.getSession().save((Object)role));
    }

    @Override
    public void delete(Role role) {
        this.getSession().delete((Object)role);
    }

    @Override
    public Role update(Role role) {
        this.getSession().update((Object)role);
        return role;
    }

    @Override
    public List getAll(Integer networkId) {
        if (networkId == null) {
            return this.findHibernate("from Role where network is null");
        }
        return this.findHibernate("from Role where network.id = ?", networkId);
    }

    @Override
    public List getAllTypes() {
        return this.loadAllHibernate(RoleType.class);
    }

    @Override
    public List getAllTypesExclusiveType(int type) {
        Criteria crit = this.getSession().createCriteria(RoleType.class);
        crit.add((Criterion)Restrictions.ne((String)"type", (Object)type));
        return crit.list();
    }

    @Override
    public RoleType getType(Integer typeId) {
        return (RoleType)this.getSession().get(RoleType.class, (Serializable)typeId);
    }

    @Override
    public RoleType save(RoleType type) {
        return this.getType((Integer)this.getSession().save((Object)type));
    }

    @Override
    public Role getByMigration(Integer networkId, Integer migrationId) {
        Criteria crit = this.getSession().createCriteria(Role.class);
        crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        crit.createCriteria("roleDefault").add((Criterion)Restrictions.eq((String)"migrateReferenceId", (Object)migrationId));
        return (Role)crit.uniqueResult();
    }

    @Override
    public List getAllRoles() {
        return this.loadAllHibernate(Role.class);
    }
}

