/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.db.dao.AttachmentDAO;
import at.cdes.db.dao.ProjectParticipantDAO;
import at.cdes.ext.preview.DocumentVersionPdfMimeSource;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.clazzes.util.io.IOUtil;

public class DocumentVersionReviewProtocolPdfMimeSource
extends DocumentVersionPdfMimeSource {
    private AttachmentDAO attachmentDAO;
    private ProjectParticipantDAO projectParticipantDAO;

    @Override
    public List<Annotation> getAnnotations(DocumentVersion documentVersion, Object[] parameters) throws IOException, IOError, FileHandleException {
        List<Annotation> ret = super.getAnnotations(documentVersion, parameters);
        List<ReviewCycleNode> nodes = documentVersion.getActualReviewCycleNode().getReviewCycleCell().getReviewCycleNodesSortedByPosition();
        nodes.addAll(documentVersion.getActualReviewCycleNode().getReviewCycleCell().getFreeReviewCycleNodesSortedByPosition());
        for (ReviewCycleNode node : nodes) {
            List<Attachment> attachments = this.attachmentDAO.getAll(documentVersion.getId(), node.getId(), true);
            for (Attachment att : attachments) {
                ReviewCyclePositionResult res;
                Iterator rit;
                File file = this.getFileFinder().findFile(att.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
                ByteArrayMimeInputStream fdf_stream = new ByteArrayMimeInputStream(IOUtil.readByteArrayFromFile((File)file), (double)att.getCreated().getTime() * 0.001, att.getOriginalName(), "application/vnd.fdf");
                ProjectParticipant pp = this.projectParticipantDAO.get(att.getProjectParticipantId());
                String reviewer_name = pp.getOrganisationPerson().getPerson().getCommonName() + ", " + pp.getOrganisationPerson().getOrganisation().getName();
                Map results = att.getResults();
                if (results == null || !(rit = results.values().iterator()).hasNext() || (res = (ReviewCyclePositionResult)rit.next()).getCommentReference() == null && res.getSignature() == null || res.getCommentReference() != null && res.getDigest() == null) continue;
                String color = "";
                if (res.getRealm() != null && res.getRealm().getRedliningColor() != null) {
                    color = res.getRealm().getRedliningColor();
                }
                ret.add(new Annotation((IMimeInputStream)fdf_stream, node.getName(), reviewer_name, color, 1));
            }
        }
        return ret;
    }

    @Override
    public boolean needPDFPostProcessing(DocumentVersion documentVersion, Object[] parameters) {
        if (super.needPDFPostProcessing(documentVersion, parameters)) {
            return true;
        }
        List<Attachment> attachments = this.attachmentDAO.getAll(documentVersion.getId(), null, true);
        return attachments != null && attachments.size() > 0;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }
}

