/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.file.FileFinder;
import at.cdes.bo.plot.TiledImage;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.BoundingBoxWithAngle;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.LabelOperations;
import at.cdes.service.ObjectOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class TemporaryDocumentVersionPngTileMimeSource
implements VisitlessMimeSource {
    private static final Log log = LogFactory.getLog(TemporaryDocumentVersionPngTileMimeSource.class);
    private IHPGLRenderer hpglRenderer;
    private LabelOperations labelOperations;
    private ObjectOperations objectOperations;
    private ReviewOperations reviewOperations;
    private FileFinder fileFinder;

    public String getActionName() {
        return "uploadDocument";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        DocumentImpl document = this.reviewOperations.getDocument(ImplContextHelper.getTemporaryDocumentVersion().getDocumentId());
        SubProject subProject = document.getObjectPlanner().getObject().getObjectList().getSubProject();
        return this.objectOperations.getReleasedObjectPlannerFromList(document.getObjectPlanner().getId(), subProject.getActiveObjectList().getId());
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        int baseSize = (Integer)parameters[0];
        boolean antialias = (Boolean)parameters[1];
        double resolution = (Double)parameters[2];
        int itile = (Integer)parameters[3];
        int jtile = (Integer)parameters[4];
        LabelContent labelContent = null;
        TemporaryDocumentVersion dv = ImplContextHelper.getTemporaryDocumentVersion();
        if (dv.getLabelContentId() != null) {
            labelContent = this.labelOperations.getLabelContent(dv.getLabelContentId());
        }
        int angle = dv.getPreviewRotation();
        if (parameters.length > 5) {
            angle = (Integer)parameters[5];
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("tdv: llx=" + dv.getLlx() + ",lly=" + dv.getLly() + ",urx=" + dv.getUrx() + ",ury=" + dv.getUry() + ",angle=" + angle));
            log.debug((Object)("req:baseSize=" + baseSize + ",antialias=" + antialias + ",resolution=" + resolution + ",itile=" + itile + ",jtile=" + jtile + ",angle=" + angle));
        }
        try (FileMimeInputStream stream = null;){
            IMimeInputStream ret;
            File file = new File(dv.getFileName());
            String unique = this.fileFinder.makeUniqueName(dv.getFileName(), CDESFileRepository.TEMPREPOSITORY);
            stream = new FileMimeInputStream(file, unique, dv.getName() + "." + dv.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv.getFileName()));
            ArrayList<Annotation> annotations = null;
            if (labelContent != null && !dv.isRenderLabelOutsideOfPlan()) {
                annotations = new ArrayList<Annotation>();
                Date creationDate = new Date();
                creationDate.setTime(file.lastModified());
                byte[] fdf_data = this.labelOperations.formatFDFPreview(dv, false);
                ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, 0.001 * (double)file.lastModified(), labelContent.getName(), "application/vnd.fdf");
                annotations.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
            }
            TiledImage ti = new TiledImage(dv, baseSize, resolution, angle);
            BoundingBoxWithAngle tileBox = ti.getTileBox(itile, jtile);
            if (log.isDebugEnabled()) {
                log.debug((Object)("tile:llx=" + tileBox.getLlx() + ",lly=" + tileBox.getLly() + ",urx=" + tileBox.getUrx() + ",ury=" + tileBox.getUry() + ",angle=" + tileBox.getAngle()));
            }
            IMimeInputStream iMimeInputStream = ret = this.hpglRenderer.renderPngTileByResolution((IMimeInputStream)stream, resolution, antialias, tileBox, "", annotations);
            return iMimeInputStream;
        }
    }

    public void setHpglRenderer(IHPGLRenderer hpglRenderer) {
        this.hpglRenderer = hpglRenderer;
    }

    public void setLabelOperations(LabelOperations labelOperations) {
        this.labelOperations = labelOperations;
    }

    public void setObjectOperations(ObjectOperations objectOperations) {
        this.objectOperations = objectOperations;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }
}

