/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.organisation;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.localisation.Country;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.OrganisationPersonComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Organisation
implements CdesDataObject {
    static final long serialVersionUID = 1L;
    private Integer id;
    private Map organisationPersons;
    private boolean consortiumHead;
    private Map networks;
    private Map ownNetworks;
    private String mobileTelephoneNumber;
    private String facsimileNumber;
    private String emailAddress;
    private Map consortiums;
    private Map consortiumMembers;
    private String name;
    private String postalAddress;
    private String postalCode;
    private String localityName;
    private String stateorProvinceName;
    private String telephoneNumber;
    private Country country;

    public Map getOwnNetworks() {
        return this.ownNetworks;
    }

    public void setOwnNetworks(Map ownNetworks) {
        this.ownNetworks = ownNetworks;
    }

    public Map getNetworks() {
        return this.networks;
    }

    public void setNetworks(Map networks) {
        this.networks = networks;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(String address) {
        this.postalAddress = address;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String code) {
        this.postalCode = code;
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String localityName) {
        this.localityName = localityName;
    }

    public String getStateOrProvinceName() {
        return this.stateorProvinceName;
    }

    public void setStateOrProvinceName(String orProvinceName) {
        this.stateorProvinceName = orProvinceName;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String number) {
        this.telephoneNumber = number;
    }

    public String getMobileTelephoneNumber() {
        return this.mobileTelephoneNumber;
    }

    public void setMobileTelephoneNumber(String telephoneNumber) {
        this.mobileTelephoneNumber = telephoneNumber;
    }

    public String getFacsimileNumber() {
        return this.facsimileNumber;
    }

    public void setFacsimileNumber(String facsimileNumber) {
        this.facsimileNumber = facsimileNumber;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean isConsortiumHead() {
        return this.consortiumHead;
    }

    public void setConsortiumHead(boolean consortiumHead) {
        this.consortiumHead = consortiumHead;
    }

    public Map getConsortiums() {
        return this.consortiums;
    }

    public void setConsortiums(Map consortiums) {
        this.consortiums = consortiums;
    }

    public Map getOrganisationPersons() {
        return this.organisationPersons;
    }

    public void setOrganisationPersons(Map organisationPersons) {
        this.organisationPersons = organisationPersons;
    }

    public Map getConsortiumMembers() {
        return this.consortiumMembers;
    }

    public void setConsortiumMembers(Map members) {
        this.consortiumMembers = members;
    }

    public Map getAllOrganisationPersons() {
        HashMap ret = new HashMap();
        if (this.isConsortiumHead()) {
            Map members = this.getConsortiumMembers();
            if (members == null) {
                return null;
            }
            for (Organisation org : members.values()) {
                ret.putAll(org.getAllOrganisationPersons());
            }
        } else if (this.getOrganisationPersons() != null) {
            ret.putAll(this.getOrganisationPersons());
        }
        return ret;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public List<OrganisationPerson> getOrganisationPersonsSortedByInverseCommonName(Locale locale, boolean isAlphabetical) {
        ArrayList<OrganisationPerson> ops = new ArrayList<OrganisationPerson>();
        Map opMap = this.getAllOrganisationPersons();
        if (opMap != null && !opMap.isEmpty()) {
            Collection allOps = opMap.values();
            for (OrganisationPerson op : allOps) {
                if (op.getPerson().isInvalidated()) continue;
                ops.add(op);
            }
        }
        Collections.sort(ops, new OrganisationPersonComparator(locale, true, isAlphabetical));
        return ops;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Organisation.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Organisation other = (Organisation)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

