/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.document.NumberCalculatorException;
import at.cdes.api.dto.PlanDeliverSearchModel;
import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentBase;
import at.cdes.bo.data.document.DocumentDateHistoryPart;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentList;
import at.cdes.bo.data.document.DocumentListImpl;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.document.DocumentType;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.PDCDocumentTO;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.data.document.ReleasedDocumentListVersionComparator;
import at.cdes.bo.data.network.MasterDataSet;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.object.CDESObject;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.object.PDCObjectPlannerTO;
import at.cdes.bo.data.object.PDCObjectTO;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.sec.CDESSignature;
import at.cdes.bo.data.sec.DigestCalculatorType;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.bo.number.NumberCalculator;
import at.cdes.bo.number.PDCNumberRegistryFactory;
import at.cdes.bo.object.ObjectListHelper;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestCalculatorFactory;
import at.cdes.bo.sec.signature.SignatureCalculator;
import at.cdes.bo.sec.signature.SignatureCalculatorException;
import at.cdes.bo.sec.signature.SignatureCalculatorFactory;
import at.cdes.controller.apiHelper.SubProjectCopyContainer;
import at.cdes.controller.documentNumber.DocumentNumberRegistry;
import at.cdes.controller.number.OgnlNumberCalculator;
import at.cdes.db.dao.DigestCalculatorDAO;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.db.dao.DocumentListDAO;
import at.cdes.db.dao.DocumentRefDAO;
import at.cdes.db.dao.DocumentTypeDAO;
import at.cdes.db.dao.DocumentVersionDAO;
import at.cdes.db.dao.MasterDataSetDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.ObjectDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ProjectParticipantDAO;
import at.cdes.db.dao.SignatureDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.service.PlanDeliverCatalogueOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.FrontendException;
import at.cdes.service.exception.WrongPasswordException;
import at.cdes.util.ImplContextHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.clazzes.util.comparators.InvalidExpressionSyntaxException;
import org.xnap.commons.i18n.I18n;

public class PlanDeliverCatalogueOperationsImpl
implements PlanDeliverCatalogueOperations {
    private DocumentListDAO documentListDAO;
    private DocumentDAO documentDAO;
    private SubProjectDAO subProjectDAO;
    private SignatureDAO signatureDAO;
    private DigestCalculatorFactory digestCalculatorFactory;
    private SignatureCalculatorFactory signatureCalculatorFactory;
    private ObjectDAO objectDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private DocumentTypeDAO documentTypeDAO;
    private NetworkDAO networkDAO;
    private MasterDataSetDAO masterDataSetDAO;
    private OgnlNumberCalculator ognlNumberCalculator;
    private HolidayCalculatorFactory holidayCalculatorFactory;
    private DigestCalculatorDAO digestCalculatorDAO;
    private ProjectDAO projectDAO;
    private TaskOperations taskOperations;
    private ReviewOperations reviewOperations;
    private PDCNumberRegistryFactory pdcNumberRegistryFactory;
    private DocumentVersionDAO documentVersionDAO;
    private DocumentRefDAO documentRefDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    static Logger logger = Logger.getLogger(PlanDeliverCatalogueOperationsImpl.class);

    @Override
    public DocumentListImpl getDocumentList(Integer documentListId) {
        return this.documentListDAO.get(documentListId);
    }

    @Override
    public ReleasedDocumentList getReleasedDocumentList(Integer documentListId) {
        return this.documentListDAO.getReleased(documentListId);
    }

    @Override
    public ReleasedDocumentList getActiveDocumentList(Integer subProjectId) {
        return this.subProjectDAO.get(subProjectId).getActiveDocumentList();
    }

    @Override
    public DocumentListImpl getUnreleasedDocumentList(Integer subProjectId) {
        return this.subProjectDAO.get(subProjectId).getEditDocumentList();
    }

    @Override
    public ReleasedDocumentList createReleaseable(DocumentListImpl documentList) {
        ReleasedDocumentList released = new ReleasedDocumentList();
        released.initRelease(documentList);
        Iterator it = documentList.getDocuments().values().iterator();
        released.setDigest(null);
        released.setDocuments(new HashMap());
        while (it.hasNext()) {
            DocumentImpl oldDocument = (DocumentImpl)it.next();
            ReleasedDocument document = new ReleasedDocument(oldDocument);
            document.setDocumentList(released);
            document.setDigest(null);
            document.setId(oldDocument.getId());
            released.getDocuments().put(document.getId(), document);
        }
        return released;
    }

    @Override
    public void releaseDocumentList(ReleasedDocumentList released, CDESCertificate cert, ProjectParticipant signer, String password) throws WrongPasswordException, FrontendException {
        DocumentListImpl actual = this.documentListDAO.get(released.getDocumentList().getId());
        SubProject subProject = actual.getSubProject();
        Network network = subProject.getProject().getNetwork();
        ReleasedDocumentList releasedList = subProject.getActiveDocumentList();
        ReleasedObjectList activeObjectList = subProject.getActiveObjectList();
        Iterator it = released.getDocuments().values().iterator();
        ArrayList<ReleasedDocument> dateChangedDocuments = new ArrayList<ReleasedDocument>();
        released.setSubProject(actual.getSubProject());
        released.setDocumentList(actual);
        released.setDigest(null);
        released = this.documentListDAO.save(released);
        released.setDocuments(new HashMap());
        while (it.hasNext()) {
            ReleasedDocument document = (ReleasedDocument)it.next();
            DocumentImpl oldDocument = this.documentDAO.get(document.getDocument().getId());
            document.setDocumentList(released);
            document.setDigest(null);
            document.setDocument(oldDocument);
            document.setDocumentType(oldDocument.getDocumentType());
            document.setObjectPlanner(oldDocument.getObjectPlanner());
            document.setModified(oldDocument.getModified());
            document.setId(null);
            released.getDocuments().remove(oldDocument.getId());
            document = this.documentDAO.save(document);
            if (oldDocument.getReleasedVersions() == null) {
                oldDocument.setReleasedVersions(new HashMap());
            }
            oldDocument.getReleasedVersions().put(document.getId(), document);
            oldDocument.setModified(0);
            this.documentDAO.update(oldDocument);
            released.getDocuments().put(document.getId(), document);
            DocumentBase oldReleased = null;
            if (releasedList != null) {
                oldReleased = this.documentDAO.getReleased(oldDocument.getId(), releasedList.getId());
            }
            if (oldReleased != null && oldReleased.getStartDate() != null) {
                if (!oldReleased.getStartDate().equals(document.getStartDate())) {
                    document.setDateChanged(true);
                }
            } else if (document.getStartDate() != null) {
                document.setDateChanged(true);
            }
            if (oldReleased != null && oldReleased.getEndDate() != null) {
                if (!oldReleased.getEndDate().equals(document.getEndDate())) {
                    document.setDateChanged(true);
                }
            } else if (document.getEndDate() != null) {
                document.setDateChanged(true);
            }
            if (!document.isDateChanged()) continue;
            dateChangedDocuments.add(document);
        }
        try {
            DigestCalculator hc = this.digestCalculatorFactory.getDigestCalculator(network, released);
            DigestCalculatorType type = this.digestCalculatorDAO.get(hc.getClass().getName());
            released.setDigest(hc.getDigest(released));
            released.setDigestCalculatorType(type);
            this.documentListDAO.update(released);
            for (ReleasedDocument document : released.getDocuments().values()) {
                document.setDigest(hc.getDigest(document));
                document.setDigestCalculatorType(type);
                this.documentDAO.update(document);
            }
            String toSign = new String(hc.getSignableContent(released));
            SignatureCalculator sc = this.signatureCalculatorFactory.getSignatureCalculator(network, released);
            CDESSignature signature = sc.createSignature(signer, toSign, cert, password);
            signature = this.signatureDAO.save(signature);
            released.setSignature(signature);
            this.documentListDAO.update(released);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("DocumentList Release", e);
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("DocumentList Release", e);
        }
        catch (Exception e) {
            throw new ActionException("DocumentList Release", e);
        }
        actual.setVersion(actual.getVersion() + 1);
        if (subProject.getReleasedDocumentLists() == null) {
            subProject.setReleasedDocumentLists(new TreeSet(new ReleasedDocumentListVersionComparator()));
        }
        subProject.getReleasedDocumentLists().add(released);
        this.subProjectDAO.update(subProject);
        this.documentListDAO.update(actual);
        this.taskOperations.updateReviewTasks(dateChangedDocuments, activeObjectList);
    }

    @Override
    public DocumentImpl getDocument(Integer id) {
        return this.documentDAO.get(id);
    }

    @Override
    public ReleasedDocument getReleasedDocument(Integer id) {
        return this.documentDAO.getReleased(id);
    }

    @Override
    public List<DocumentImpl> getPlanDeliverCataloguePart(Integer objectId) {
        CDESObjectImpl o = this.objectDAO.getCDESObject(objectId);
        ArrayList<DocumentImpl> res = new ArrayList<DocumentImpl>();
        if (o.getObjectPlanners() == null || o.getObjectPlanners().isEmpty()) {
            return res;
        }
        for (ObjectPlanner op : o.getObjectPlanners().values()) {
            if (op.getDocuments() == null) continue;
            res.addAll(op.getDocuments().values());
        }
        return res;
    }

    public void setObjectDAO(ObjectDAO objectDAO) {
        this.objectDAO = objectDAO;
    }

    @Override
    public void updatePlanDeliverCatalogue(List<DocumentImpl> updates, List<Integer> deletes, Integer projectId, ProjectParticipant participant) {
        ObjectPlanner op = null;
        try {
            OgnlNumberCalculator numCalc = this.ognlNumberCalculator;
            Project project = this.projectDAO.get(projectId);
            DocumentNumberRegistry numberRenderer = new DocumentNumberRegistry();
            HolidayCalculator hcalc = this.holidayCalculatorFactory.getInstance(project);
            ReleasedDocumentList releasedList = null;
            if (updates != null) {
                for (DocumentImpl impl : updates) {
                    if (impl.getContent() == null || impl.getNumber() == null || impl.getContent().length() == 0 || impl.getNumber() <= 0) continue;
                    List<DocumentDateHistoryPart> dateHistory = impl.getDateHistorySortedByDate(false);
                    if (releasedList == null) {
                        releasedList = impl.getDocumentList().getSubProject().getActiveDocumentList();
                    }
                    impl.setDocumentType(this.documentTypeDAO.get(impl.getDocumentType().getId()));
                    if (op == null) {
                        op = impl.getObjectPlanner();
                    }
                    impl.setName(numCalc.getNumber((Document)impl, impl.getDocumentList().getSubProject().getProject(), false));
                    GregorianCalendar startDate = new GregorianCalendar();
                    DocumentDateHistoryPart part = new DocumentDateHistoryPart();
                    part.setDocument(impl);
                    part.setEditDate(new Date(System.currentTimeMillis()));
                    part.setProjectParticipant(participant);
                    if (impl.getStartDate() != null) {
                        startDate.setTime(impl.getStartDate());
                    }
                    GregorianCalendar endDate = new GregorianCalendar();
                    if (impl.getEndDate() != null) {
                        endDate.setTime(impl.getEndDate());
                    }
                    if (impl.getStartDate() != null && impl.getEndDate() != null) {
                        impl.setDuration(hcalc.getWorkingDaysBetween(startDate, endDate));
                    } else {
                        impl.setDuration(null);
                    }
                    boolean dateStartChanged = true;
                    boolean dateEndChanged = true;
                    if (dateHistory == null || dateHistory.isEmpty()) {
                        if (impl.getStartDate() == null && impl.getEndDate() == null) {
                            dateStartChanged = false;
                            dateEndChanged = false;
                        }
                    } else {
                        Iterator iterator = dateHistory.iterator();
                        if (iterator.hasNext()) {
                            DocumentDateHistoryPart hist = (DocumentDateHistoryPart)iterator.next();
                            dateStartChanged = !(hist.getStartDate() == null && impl.getStartDate() == null || hist.getStartDate() != null && hist.getStartDate().equals(impl.getStartDate()));
                            dateEndChanged = !(hist.getEndDate() == null && impl.getEndDate() == null || hist.getEndDate() != null && hist.getEndDate().equals(impl.getEndDate()));
                        }
                    }
                    if (dateStartChanged || dateEndChanged) {
                        part.setStartDate(impl.getStartDate());
                        part.setEndDate(impl.getEndDate());
                        if (dateStartChanged && dateEndChanged) {
                            part.setModType(3);
                        } else if (dateStartChanged) {
                            part.setModType(1);
                        } else if (dateEndChanged) {
                            part.setModType(2);
                        }
                        part = this.documentDAO.insert(part);
                        if (impl.getDateHistory() == null) {
                            impl.setDateHistory(new HashMap());
                        }
                        impl.getDateHistory().put(part.getId(), part);
                    }
                    ReleasedDocument oldReleased = null;
                    if (releasedList != null) {
                        oldReleased = this.documentDAO.getReleased(impl.getId(), releasedList.getId());
                    }
                    impl.setModified(0);
                    if (oldReleased != null) {
                        if (!impl.getName().equals(oldReleased.getName())) {
                            impl.setModified(3);
                        }
                        if (!impl.getContent().equals(oldReleased.getContent())) {
                            impl.setModified(3);
                        }
                        if (!impl.getScale().equals(oldReleased.getScale())) {
                            impl.setModified(3);
                        }
                        if (oldReleased.getStartDate() != null) {
                            if (impl.getStartDate() == null || oldReleased.getStartDate().getTime() != impl.getStartDate().getTime()) {
                                impl.setModified(2);
                            }
                        } else if (impl.getStartDate() != null) {
                            impl.setModified(2);
                        }
                        if (oldReleased.getEndDate() != null) {
                            if (impl.getEndDate() == null || oldReleased.getEndDate().getTime() != impl.getEndDate().getTime()) {
                                impl.setModified(2);
                            }
                        } else if (impl.getEndDate() != null) {
                            impl.setModified(2);
                        }
                    } else {
                        impl.setModified(1);
                    }
                    this.documentDAO.update(impl);
                }
            }
            if (deletes == null) {
                return;
            }
            Iterator<Serializable> it = deletes.iterator();
            while (it.hasNext()) {
                DocumentImpl doc = this.documentDAO.get((Integer)it.next());
                op.getDocuments().remove(doc.getId());
                this.deleteDocument(doc);
                updates.remove(doc);
            }
            if (numberRenderer != null && op != null) {
                CDESObject o = op.getObject();
                ArrayList docs = new ArrayList();
                Collection ops = o.getObjectPlanners().values();
                if (numberRenderer.isObjectPlannerUniqueKey(project)) {
                    docs.addAll(op.getDocuments().values());
                } else {
                    for (ObjectPlanner planner : ops) {
                        docs.addAll(planner.getDocuments().values());
                    }
                }
                numberRenderer.checkUniqueness(docs);
            }
        }
        catch (NumberCalculatorException e) {
            throw new ActionException("Update PlandDeliverCatalogueEntries", e);
        }
    }

    public void deleteDocumentDateHistory(DocumentImpl doc) {
        if (doc.getDateHistory() == null) {
            return;
        }
        Collection parts = doc.getDateHistory().values();
        for (DocumentDateHistoryPart part : parts) {
            this.documentDAO.delete(part);
        }
    }

    @Override
    public List<DocumentType> getDocumentTypes(Integer networkId, int type, Integer masterDataSetId) {
        Network n = this.networkDAO.get(networkId);
        MasterDataSet mds = null;
        if (masterDataSetId != null) {
            mds = this.masterDataSetDAO.getMasterDataSet(masterDataSetId);
        }
        return this.documentTypeDAO.getAll(n, type, mds);
    }

    @Override
    public Collection<DocumentImpl> insertPlanDeliverCatalogueEntries(List<DocumentImpl> inserts, Integer objectPlannerId, Integer projectId, ProjectParticipant projectParticipant) {
        Iterator<DocumentImpl> it = inserts.iterator();
        ArrayList<DocumentImpl> inserted = new ArrayList<DocumentImpl>();
        if (objectPlannerId == null) {
            return null;
        }
        try {
            OgnlNumberCalculator numCalc = this.ognlNumberCalculator;
            Project project = this.projectDAO.get(projectId);
            ObjectPlannerImpl objectPlanner = this.objectPlannerDAO.getObjectPlanner(objectPlannerId);
            DocumentNumberRegistry numberRenderer = new DocumentNumberRegistry();
            HolidayCalculator hcalc = this.holidayCalculatorFactory.getInstance(project);
            if (objectPlanner == null) {
                return null;
            }
            DocumentListImpl dl = objectPlanner.getObject().getObjectList().getSubProject().getEditDocumentList();
            if (dl == null) {
                return null;
            }
            if (dl.getDocuments() == null) {
                dl.setDocuments(new HashMap());
            }
            if (objectPlanner.getDocuments() == null) {
                objectPlanner.setDocuments(new HashMap());
            }
            this.objectPlannerDAO.update(objectPlanner);
            objectPlanner.getDocuments().size();
            while (it.hasNext()) {
                DocumentImpl impl = it.next();
                if (impl.getContent() == null || impl.getNumber() == null || impl.getContent().length() <= 0 || impl.getNumber() <= 0) continue;
                impl.setId(null);
                impl.setDocumentList(dl);
                impl.setObjectPlanner(objectPlanner);
                impl.setName(numCalc.getNumber((Document)impl, dl.getSubProject().getProject(), false));
                GregorianCalendar startDate = new GregorianCalendar();
                if (impl.getStartDate() != null) {
                    startDate.setTime(impl.getStartDate());
                }
                GregorianCalendar endDate = new GregorianCalendar();
                if (impl.getEndDate() != null) {
                    endDate.setTime(impl.getEndDate());
                }
                impl.setDuration(hcalc.getWorkingDaysBetween(startDate, endDate));
                impl.setModified(1);
                impl = this.documentDAO.save(impl);
                inserted.add(impl);
                dl.getDocuments().put(impl.getId(), impl);
                objectPlanner.getDocuments().put(impl.getId(), impl);
                this.objectPlannerDAO.update(objectPlanner);
                this.documentListDAO.update(dl);
                if (impl.getStartDate() == null && impl.getEndDate() == null) continue;
                DocumentDateHistoryPart part = new DocumentDateHistoryPart();
                part.setDocument(impl);
                part.setEditDate(new Date(System.currentTimeMillis()));
                part.setProjectParticipant(projectParticipant);
                part.setStartDate(impl.getStartDate());
                part.setEndDate(impl.getEndDate());
                if (impl.getStartDate() != null && impl.getEndDate() != null) {
                    part.setModType(3);
                } else if (impl.getStartDate() != null) {
                    part.setModType(1);
                } else if (impl.getEndDate() != null) {
                    part.setModType(2);
                }
                part = this.documentDAO.insert(part);
            }
            if (numberRenderer != null && objectPlanner != null) {
                CDESObject o = objectPlanner.getObject();
                ArrayList docs = new ArrayList();
                Collection ops = o.getObjectPlanners().values();
                if (numberRenderer.isObjectPlannerUniqueKey(project)) {
                    docs.addAll(objectPlanner.getDocuments().values());
                } else {
                    for (ObjectPlanner planner : ops) {
                        docs.addAll(planner.getDocuments().values());
                    }
                }
                numberRenderer.checkUniqueness(docs);
            }
        }
        catch (NumberCalculatorException e) {
            throw new ActionException("InsertPlanDeliverCatalogueEntries", e);
        }
        return inserted;
    }

    @Override
    public NumberCalculator getDocumentNumberCalculator() {
        return this.ognlNumberCalculator;
    }

    @Override
    public List<ReleasedDocument> getReleasedPlanDeliverCataloguePart(Integer objectPlannerId, Integer documentListId) {
        return this.documentDAO.getReleasedPlanDeliverCataloguePart(objectPlannerId, documentListId, null);
    }

    @Override
    public List<DocumentImpl> getUnReleasedPlanDeliverCataloguePart(Integer objectPlannerId, Integer documentListId) {
        return this.documentDAO.getUnReleasedPlanDeliverCataloguePart(objectPlannerId, documentListId, null);
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setDigestCalculatorFactory(DigestCalculatorFactory digestCalculatorFactory) {
        this.digestCalculatorFactory = digestCalculatorFactory;
    }

    public void setSignatureCalculatorFactory(SignatureCalculatorFactory signatureCalculatorFactory) {
        this.signatureCalculatorFactory = signatureCalculatorFactory;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setMasterDataSetDAO(MasterDataSetDAO masterDataSetDAO) {
        this.masterDataSetDAO = masterDataSetDAO;
    }

    public void setOgnlNumberCalculator(OgnlNumberCalculator numberCalc) {
        this.ognlNumberCalculator = numberCalc;
    }

    @Override
    public Collection<Calendar> calculateHolidays(Integer projectId) {
        Project project = this.projectDAO.get(projectId);
        GregorianCalendar start = new GregorianCalendar();
        Calendar end = (Calendar)((Calendar)start).clone();
        ((Calendar)start).add(1, -1);
        end.add(1, 3);
        return this.holidayCalculatorFactory.getInstance(project).getHolidaysBetween(start, end);
    }

    public void setHolidayCalculatorFactory(HolidayCalculatorFactory holidayCalculatorFactory) {
        this.holidayCalculatorFactory = holidayCalculatorFactory;
    }

    @Override
    public List<ReleasedDocument> getAllReleasedDocuments(ReleasedDocumentList documentList) {
        if (documentList == null) {
            return null;
        }
        return this.documentDAO.getAllReleased(documentList.getId());
    }

    @Override
    public List<ReleasedDocument> getReleasedDocuments(Integer opImplId, Integer releasedDocumentListId) {
        return this.documentDAO.getReleasedPlanDeliverCataloguePart(opImplId, releasedDocumentListId, null);
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    @Override
    public void deleteDocumentListByID(Integer editDocumentListId) {
        DocumentListImpl edl = this.getDocumentList(editDocumentListId);
        if (edl.getDocuments() != null) {
            Iterator it = edl.getDocuments().values().iterator();
            while (it.hasNext()) {
                this.deleteDocument((DocumentImpl)it.next());
            }
        }
        this.documentListDAO.delete(edl);
    }

    @Override
    public void deleteDocument(DocumentImpl document) {
        this.deleteDocumentDateHistory(document);
        this.taskOperations.deleteDocumentTasks(document.getId());
        this.documentDAO.delete(document);
    }

    public void setTaskOperations(TaskOperations taskOperations) {
        this.taskOperations = taskOperations;
    }

    @Override
    public ReleasedDocument getReleasedDocumentFromList(Integer documentImplId, Integer releasedDocumentListId) {
        return this.documentDAO.getReleased(documentImplId, releasedDocumentListId);
    }

    @Override
    public void invalidateDocument(DocumentImpl impl) {
        DocumentListImpl list = impl.getDocumentList();
        list.getDocuments().remove(list);
        impl.setInvalidated(true);
        this.documentDAO.update(impl);
        this.taskOperations.deleteDocumentTasks(impl.getId());
    }

    @Override
    public void invalidateDocumentsOfObjectPlanner(ObjectPlannerImpl planner) {
        if (planner.getDocuments() != null) {
            Collection documents = planner.getDocuments().values();
            for (DocumentImpl doc : documents) {
                doc.setInvalidated(true);
                this.documentDAO.update(doc);
                this.taskOperations.deleteDocumentTasks(doc.getId());
            }
        }
    }

    @Override
    public DocumentType getDocumentType(Integer id) {
        return this.documentTypeDAO.get(id);
    }

    @Override
    public DocumentType updateDocumentTypes(DocumentType group, List<DocumentType> documentTypes, Network network) {
        group.setNetwork(network);
        group = this.documentTypeDAO.update(group);
        if (documentTypes != null) {
            for (DocumentType type : documentTypes) {
                if (type.getId() != null && type.getId() > 0) {
                    this.documentTypeDAO.update(type);
                    continue;
                }
                if (type.getName() == null || type.getName().length() == 0 || type.getCode() == null || type.getCode().length() == 0) continue;
                type.setNetwork(network);
                if (group.getId() != null) {
                    type.setDocumentTypeGroup(group);
                }
                if (group.getMasterDataSet() != null) {
                    type.setMasterDataSet(group.getMasterDataSet());
                }
                type = this.documentTypeDAO.save(type);
                if (group.getId() == null) continue;
                if (group.getDocumentTypes() == null) {
                    group.setDocumentTypes(new HashMap());
                }
                group.getDocumentTypes().put(type.getId(), type);
            }
        }
        return group.getId() != null ? group : null;
    }

    @Override
    public DocumentType insertDocumentTypes(DocumentType group, List<DocumentType> documentTypes, Network network, MasterDataSet masterDataSet) {
        group.setNetwork(network);
        group.setMasterDataSet(masterDataSet);
        group = this.documentTypeDAO.save(group);
        if (documentTypes != null) {
            for (DocumentType type : documentTypes) {
                if (type.getName() == null || type.getName().length() == 0 || type.getCode() == null || type.getCode().length() == 0) continue;
                type.setNetwork(network);
                if (group.getId() != null) {
                    type.setDocumentTypeGroup(group);
                }
                if (group.getMasterDataSet() != null) {
                    type.setMasterDataSet(masterDataSet);
                }
                type = this.documentTypeDAO.save(type);
                if (group.getId() == null) continue;
                if (group.getDocumentTypes() == null) {
                    group.setDocumentTypes(new HashMap());
                }
                group.getDocumentTypes().put(type.getId(), type);
            }
        }
        return group.getId() != null ? group : null;
    }

    public void setPdcNumberRegistryFactory(PDCNumberRegistryFactory pdcNumberRegistryFactory) {
        this.pdcNumberRegistryFactory = pdcNumberRegistryFactory;
    }

    @Override
    public List<DocumentVersion> getAllDocumentsOfSubproject(List<SubProject> subProjects) {
        LinkedList<DocumentVersion> documentVersions = new LinkedList<DocumentVersion>();
        for (SubProject su : subProjects) {
            DocumentList dl = this.documentListDAO.getBySubproject(su.getId());
            if (dl == null) continue;
            LinkedList documentList = new LinkedList();
            if (dl.getDocuments() != null) {
                documentList.addAll(dl.getDocuments().values());
            }
            for (Document d : documentList) {
                documentVersions.addAll(d.getDocumentVersions().values());
            }
        }
        return documentVersions;
    }

    @Override
    public List<ReleasedDocumentList> getReleasedDocumentListBySubprojectId(int subProjectId) {
        return this.documentListDAO.getAllReleased(subProjectId);
    }

    @Override
    public DocumentType updateDocumentType(DocumentType type) {
        return this.documentTypeDAO.update(type);
    }

    @Override
    public void deleteDocumentType(Integer typeId) {
        DocumentType type = this.documentTypeDAO.get(typeId);
        if (type.getDocumentTypes() != null && type.getDocumentTypes().size() > 0) {
            Collection subTypes = type.getDocumentTypes().values();
            for (DocumentType subType : subTypes) {
                this.documentTypeDAO.delete(subType);
            }
        }
        this.documentTypeDAO.delete(type);
    }

    @Override
    public boolean isDocumentTypeDeletable(DocumentType type) {
        if (type.getDocumentTypes() != null && type.getDocumentTypes().size() > 0) {
            Collection subTypes = type.getDocumentTypes().values();
            for (DocumentType subType : subTypes) {
                if (this.documentTypeDAO.isDeletable(subType)) continue;
                return false;
            }
        }
        return this.documentTypeDAO.isDeletable(type);
    }

    @Override
    public List getAllUnreleasedDocumentsOfObjectPlanner(Integer objectPlannerImplId) {
        return this.documentDAO.getAllUnreleasedByObjectPlanner(objectPlannerImplId);
    }

    @Override
    public PDCObjectTO getFullPlanDeliverCatalogueObject(Integer objectId, boolean isReleased, Integer documentListId, Integer subProjectId, Integer organisationPersonId, Locale locale) {
        CDESObject object = null;
        object = isReleased ? this.objectDAO.getReleasedCDESObject(objectId) : this.objectDAO.getCDESObject(objectId);
        DocumentList docList = null;
        docList = documentListId == null ? this.documentListDAO.getBySubproject(subProjectId) : this.documentListDAO.getReleased(documentListId);
        I18n i18n = I18nFactory.getI18n(locale);
        return this.fillPDCObjectTO(object, docList, organisationPersonId, true, i18n, null, null, true);
    }

    @Override
    public PDCDocumentTO getFullPlanDeliverCatalogueDocument(Integer documentId, boolean isReleased, Locale locale, Integer orgPersonId) {
        DocumentBase doc = null;
        doc = isReleased ? this.documentDAO.getReleased(documentId) : this.documentDAO.get(documentId);
        PDCDocumentTO ret = this.getPDCDocumentTO(doc, I18nFactory.getI18n(locale));
        ObjectPlanner op = doc.getObjectPlanner();
        boolean ownObjectPlanner = false;
        if (op.getPlanner() != null) {
            Collection pps = op.getPlanner().getProjectParticipants().values();
            for (ProjectParticipant pp : pps) {
                if (!pp.getOrganisationPerson().getId().equals(orgPersonId)) continue;
                ownObjectPlanner = true;
                break;
            }
        }
        PDCObjectPlannerTO opTO = new PDCObjectPlannerTO(op);
        opTO.setOwnObjectPlanner(ownObjectPlanner);
        ret.setObjectPlanner(opTO);
        return ret;
    }

    private PDCDocumentTO getPDCDocumentTO(Document doc, I18n i18n) {
        ReviewCycleNodeResult nodeResult;
        DocumentVersion lastVersion = doc.getLastDocumentVersion();
        Date effectiveEndDate = null;
        if (lastVersion != null && (lastVersion.getStatus() == 2 || lastVersion.getStatus() == 10) && (nodeResult = this.reviewOperations.getReviewCycleNodeResult(lastVersion.getActualReviewCycleNode(), lastVersion)) != null) {
            ReviewCyclePositionResult latestPositionResult = this.reviewOperations.getLatestPositionResultOfDocumentVersion(lastVersion.getId());
            if (latestPositionResult == null) {
                effectiveEndDate = nodeResult.getDocumentArrivalDate();
            } else if (latestPositionResult.getReviewCycleResultOption() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus() != null && (latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus().equals(2) || latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus().equals(10))) {
                effectiveEndDate = latestPositionResult.getResultDate();
            }
        }
        return new PDCDocumentTO(doc, effectiveEndDate, i18n);
    }

    private PDCObjectTO fillPDCObjectTO(CDESObject object, DocumentList docList, Integer orgPersonId, boolean isSelected, I18n i18n, PlanDeliverSearchModel pdcSearchModel, String sortColumn, boolean sortOrderAsc) {
        PDCObjectTO objectTO = new PDCObjectTO();
        objectTO.setId(object.getId());
        objectTO.setCode(object.getCode());
        objectTO.setName(object.getName());
        objectTO.setCurrentlySelected(isSelected);
        objectTO.setReadOnly(object.isReadOnly());
        int documentsCount = 0;
        int noStartDateDefinedCount = 0;
        int noEndDateDefinedCount = 0;
        int documentsWithoutVersionSet = 0;
        int countDocsModified = 0;
        ArrayList objectPlanners = new ArrayList(object.getObjectPlanners().values());
        for (ObjectPlanner op : objectPlanners) {
            PDCObjectPlannerTO opTO;
            if (pdcSearchModel != null && pdcSearchModel.getObjectPlannerReleaseId() != null && !pdcSearchModel.getObjectPlannerReleaseId().equals(op.getId().longValue())) continue;
            boolean ownObjectPlanner = false;
            if (op.getPlanner() != null) {
                Collection pps = op.getPlanner().getProjectParticipants().values();
                for (Object pp : pps) {
                    if (pdcSearchModel == null || pdcSearchModel.getOrganisationPersonId() == null || !((ProjectParticipant)pp).getOrganisationPerson().getId().equals(pdcSearchModel.getOrganisationPersonId().intValue())) continue;
                    ownObjectPlanner = true;
                    break;
                }
                if (op.getPositions() != null) {
                    Object pp;
                    Collection opdefs = op.getPositions().values();
                    pp = opdefs.iterator();
                    block22: while (pp.hasNext()) {
                        Object opdef = (ObjectPlannerPosition)pp.next();
                        List opdefPps = this.projectParticipantDAO.getAll(opdef.getProjectParticipation().getId());
                        for (ProjectParticipant pp2 : opdefPps) {
                            if (pdcSearchModel == null || pdcSearchModel.getOrganisationPersonId() == null || !pp2.getOrganisationPerson().getId().equals(pdcSearchModel.getOrganisationPersonId().intValue())) continue;
                            ownObjectPlanner = true;
                            continue block22;
                        }
                    }
                }
            }
            if (!ownObjectPlanner && pdcSearchModel != null && (pdcSearchModel == null || pdcSearchModel.getOrganisationPersonId() != null)) continue;
            objectTO.setOwnPlannerObject(true);
            if (!isSelected) {
                opTO = new PDCObjectPlannerTO();
                opTO.setId(op.getId());
            } else {
                opTO = new PDCObjectPlannerTO(op);
                opTO.setOwnObjectPlanner(ownObjectPlanner);
                opTO.setObject(objectTO);
            }
            List documents = null;
            if (docList != null) {
                documents = docList instanceof ReleasedDocumentList ? this.documentDAO.getReleasedPlanDeliverCataloguePart(((ReleasedObjectPlanner)op).getObjectPlanner().getId(), docList.getId(), pdcSearchModel) : this.documentDAO.getUnReleasedPlanDeliverCataloguePart(((ReleasedObjectPlanner)op).getObjectPlanner().getId(), docList.getId(), pdcSearchModel);
            }
            if (documents != null) {
                if (sortColumn != null) {
                    Comparator comp = null;
                    switch (sortColumn) {
                        case "_documentNameRowObject": {
                            sortColumn = "name";
                            break;
                        }
                        case "_documentContentRowObject": {
                            sortColumn = "content";
                            break;
                        }
                        case "_documentScaleRowObject": {
                            sortColumn = "scale";
                            break;
                        }
                        case "_documentCommentRowObject": {
                            sortColumn = "comment";
                            break;
                        }
                        case "_documentStartDateRowObject": {
                            sortColumn = "startDate";
                            break;
                        }
                        case "_documentEndDateRowObject": {
                            sortColumn = "endDate";
                            break;
                        }
                        case "_duration": {
                            sortColumn = "duration";
                            break;
                        }
                        default: {
                            sortColumn = "name";
                        }
                    }
                    try {
                        comp = ImplContextHelper.getPOJOComparatorFactory().getComparator(Document.class, sortColumn, sortOrderAsc);
                    }
                    catch (InvalidExpressionSyntaxException e) {
                        throw new ActionException("Invalid comparator parameters", e);
                    }
                    if (comp != null) {
                        Collections.sort(documents, comp);
                    }
                }
                for (Document doc : documents) {
                    if (isSelected) {
                        DocumentVersion lastVersion = doc.getLastDocumentVersion();
                        if (lastVersion == null) {
                            ++documentsWithoutVersionSet;
                        }
                        PDCDocumentTO pdcDocumentTO = this.getPDCDocumentTO(doc, i18n);
                        pdcDocumentTO.setObjectPlanner(opTO);
                        opTO.getDocuments().add(pdcDocumentTO);
                    }
                    ++documentsCount;
                    if (doc.getStartDate() == null) {
                        ++noStartDateDefinedCount;
                    }
                    if (doc.getEndDate() == null) {
                        ++noEndDateDefinedCount;
                    }
                    if ((!(doc instanceof DocumentImpl) || ((DocumentImpl)doc).getModified() <= 0) && (!(doc instanceof ReleasedDocument) || ((ReleasedDocument)doc).getModified() <= 0)) continue;
                    ++countDocsModified;
                }
            }
            if (objectTO.getObjectPlanners() == null) {
                objectTO.setObjectPlanners(new ArrayList<PDCObjectPlannerTO>());
            }
            objectTO.getObjectPlanners().add(opTO);
        }
        objectTO.setDocumentsWithoutVersionSet(documentsWithoutVersionSet);
        objectTO.setDocumentsCount(documentsCount + " " + (documentsCount == 1 ? i18n.tr("Dokument") : i18n.tr("Dokumente")));
        if (documentsCount > 0) {
            if (noEndDateDefinedCount == 0 && noStartDateDefinedCount == 0) {
                objectTO.setDeadlines(i18n.tr("alle Termine definiert"));
            } else if (noEndDateDefinedCount == 1 && noStartDateDefinedCount == 1) {
                objectTO.setDeadlines(String.format(i18n.tr("%s Start-/%s Endtermin nicht definiert"), noStartDateDefinedCount, noEndDateDefinedCount));
            } else {
                objectTO.setDeadlines(String.format(i18n.tr("%s Start-/%s Endtermine nicht definiert"), noStartDateDefinedCount, noEndDateDefinedCount));
            }
            if (countDocsModified > 1) {
                objectTO.setDocsModified(String.format(i18n.tr("%s Eintr\u00e4ge ge\u00e4ndert"), countDocsModified));
            } else if (countDocsModified > 0) {
                objectTO.setDocsModified(String.format(i18n.tr("%s Eintrag ge\u00e4ndert"), countDocsModified));
            }
        }
        return objectTO;
    }

    @Override
    public List getPlanDeliverCatalogueDTOs(Integer subProjectId, Integer documentListId, Set<Integer> selectedItems, Integer orgPersonId, Locale locale, String filterString, boolean isOOOMode, boolean isReleasedPDC, PlanDeliverSearchModel pdcSearchModel, String sortColumn, boolean sortOrder) {
        I18n i18n = I18nFactory.getI18n(locale);
        SubProject sp = this.subProjectDAO.get(subProjectId);
        ReleasedObjectList olist = sp.getActiveObjectList();
        ArrayList<PDCObjectTO> objectTOs = new ArrayList<PDCObjectTO>();
        DocumentList docList = null;
        if (documentListId == null && !isReleasedPDC) {
            docList = sp.getEditDocumentList();
        } else if (documentListId != null && isReleasedPDC) {
            docList = this.documentListDAO.getReleased(documentListId);
        }
        ArrayList<CDESObject> objects = new ArrayList<CDESObject>(ObjectListHelper.getObjectsSortedByCode(olist));
        for (CDESObject object : objects) {
            if (object.getObjectPlanners() == null || object.getObjectPlanners().size() == 0 || pdcSearchModel != null && pdcSearchModel.getObjectReleaseId() != null && !pdcSearchModel.getObjectReleaseId().equals(object.getId().longValue()) || filterString != null && filterString.trim().length() > 0 && !object.getCode().toLowerCase().contains(filterString.toLowerCase()) && !object.getName().toLowerCase().contains(filterString.toLowerCase())) continue;
            boolean isSelected = isOOOMode || selectedItems.contains(object.getId());
            objectTOs.add(this.fillPDCObjectTO(object, docList, orgPersonId, isSelected, i18n, pdcSearchModel, sortColumn, sortOrder));
        }
        return objectTOs;
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    @Override
    public SubProjectCopyContainer insertCopyOfDocumentListWithSubElements(Integer sourceSubProjectId, Integer destinationSubProjectId, SubProjectCopyContainer subProjectCopyContainer) throws NumberCalculatorException {
        SubProject sourceSubProject = this.subProjectDAO.get(sourceSubProjectId);
        SubProject destinationSubProject = this.subProjectDAO.get(destinationSubProjectId);
        DocumentListImpl unreleasedSourceDocumentList = sourceSubProject.getEditDocumentList();
        DocumentListImpl unreleasedDestinationDocumentList = new DocumentListImpl();
        unreleasedDestinationDocumentList.setSubProject(destinationSubProject);
        unreleasedDestinationDocumentList.setVersion(unreleasedSourceDocumentList.getVersion());
        this.documentListDAO.save(unreleasedDestinationDocumentList);
        ArrayList<DocumentRef> sourceDocumentRefs = new ArrayList<DocumentRef>();
        ArrayList sourceUnreleasedDocuments = new ArrayList(unreleasedSourceDocumentList.getDocuments().values());
        sourceUnreleasedDocuments.addAll(this.documentDAO.getAllUnreleasedBySubProject(sourceSubProjectId, true));
        for (DocumentImpl sourceDocument : sourceUnreleasedDocuments) {
            Object sourceDateHistory2;
            DocumentImpl destDocument = new DocumentImpl();
            destDocument.setComment(sourceDocument.getComment());
            destDocument.setContent(sourceDocument.getContent());
            destDocument.setDocumentList(unreleasedDestinationDocumentList);
            destDocument.setDuration(sourceDocument.getDuration());
            destDocument.setEndDate(sourceDocument.getEndDate());
            destDocument.setInvalidated(sourceDocument.isInvalidated());
            destDocument.setModified(sourceDocument.getModified());
            destDocument.setNumber(sourceDocument.getNumber());
            ObjectPlannerImpl destinationOP = this.objectPlannerDAO.getObjectPlanner(subProjectCopyContainer.getObjectPlannerImplIds().get(sourceDocument.getObjectPlanner().getId()));
            destDocument.setObjectPlanner(destinationOP);
            destDocument.setScale(sourceDocument.getScale());
            destDocument.setStartDate(sourceDocument.getStartDate());
            destDocument.setVersionSet(sourceDocument.isVersionSet());
            destDocument.setDocumentType(sourceDocument.getDocumentType());
            destDocument.setName(this.ognlNumberCalculator.getDocumentNumberRetroactively(destDocument, sourceSubProject.getProject()));
            destDocument = this.documentDAO.save(destDocument);
            subProjectCopyContainer.getDocumentImplIds().put(sourceDocument.getId(), destDocument.getId());
            sourceDocumentRefs.addAll(sourceDocument.getDocumentRefs().values());
            ArrayList sourceDateHistories = new ArrayList(sourceDocument.getDateHistory().values());
            for (Object sourceDateHistory2 : sourceDateHistories) {
                DocumentDateHistoryPart destDateHistory = new DocumentDateHistoryPart();
                destDateHistory.setDocument(destDocument);
                destDateHistory.setEditDate(((DocumentDateHistoryPart)sourceDateHistory2).getEditDate());
                destDateHistory.setEndDate(((DocumentDateHistoryPart)sourceDateHistory2).getEndDate());
                destDateHistory.setModType(((DocumentDateHistoryPart)sourceDateHistory2).getModType());
                destDateHistory.setOrganisationPerson(((DocumentDateHistoryPart)sourceDateHistory2).getOrganisationPerson());
                destDateHistory.setProjectParticipant(((DocumentDateHistoryPart)sourceDateHistory2).getProjectParticipant());
                destDateHistory.setStartDate(((DocumentDateHistoryPart)sourceDateHistory2).getStartDate());
                destDateHistory = this.documentDAO.insert(destDateHistory);
            }
            Collection<DocumentVersion> sourceDocumentVersions = sourceDocument.getAllDocumentVersions();
            sourceDateHistory2 = sourceDocumentVersions.iterator();
            while (sourceDateHistory2.hasNext()) {
                DocumentVersion sourceDocumentVersion = (DocumentVersion)sourceDateHistory2.next();
                DocumentVersion destDocumentVersion = new DocumentVersion();
                ReviewCycleNodeInstanceImpl destActualRCNI = this.reviewOperations.getReviewCycleNodeInstance(subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().get(sourceDocumentVersion.getActualReviewCycleNodeInstance().getId()));
                destDocumentVersion.setActualReviewCycleNodeInstance(destActualRCNI);
                destDocumentVersion.setAlternativeName(sourceDocumentVersion.getAlternativeName());
                destDocumentVersion.setComment(sourceDocumentVersion.getComment());
                destDocumentVersion.setDocument(destDocument);
                destDocumentVersion.setFileDigest(sourceDocumentVersion.getFileDigest());
                destDocumentVersion.setFileDigester(sourceDocumentVersion.getFileDigester());
                destDocumentVersion.setFileName(sourceDocumentVersion.getFileName());
                destDocumentVersion.setFileType(sourceDocumentVersion.getFileType());
                destDocumentVersion.setIssued(sourceDocumentVersion.getIssued());
                destDocumentVersion.setLabelContentId(sourceDocumentVersion.getLabelContentId());
                destDocumentVersion.setLabelCorrelation(sourceDocumentVersion.getLabelCorrelation());
                destDocumentVersion.setLabelOverlap(sourceDocumentVersion.getLabelOverlap());
                destDocumentVersion.setLabelSeparation(sourceDocumentVersion.getLabelSeparation());
                destDocumentVersion.setLabelXOffset(sourceDocumentVersion.getLabelXOffset());
                destDocumentVersion.setLabelYOffset(sourceDocumentVersion.getLabelYOffset());
                destDocumentVersion.setLlx(sourceDocumentVersion.getLlx());
                destDocumentVersion.setLly(sourceDocumentVersion.getLly());
                destDocumentVersion.setUserUnit(sourceDocumentVersion.getUserUnit());
                destDocumentVersion.setName(destDocument.getName() + this.ognlNumberCalculator.getLastSeperator(destDocument, destDocument.getDocumentList().getSubProject().getProject()) + sourceDocumentVersion.getVersionPartA() + sourceDocumentVersion.getVersionPartSeperator() + sourceDocumentVersion.getVersionPartB());
                destDocumentVersion.setNativeRotation(sourceDocumentVersion.getNativeRotation());
                destDocumentVersion.setPreviewRotation(sourceDocumentVersion.getPreviewRotation());
                destDocumentVersion.setStatus(sourceDocumentVersion.getStatus());
                destDocumentVersion.setUploaded(sourceDocumentVersion.getUploaded());
                destDocumentVersion.setUrx(sourceDocumentVersion.getUrx());
                destDocumentVersion.setUry(sourceDocumentVersion.getUry());
                destDocumentVersion.setUserUnit(sourceDocumentVersion.getUserUnit());
                destDocumentVersion.setVersionPartA(sourceDocumentVersion.getVersionPartA());
                destDocumentVersion.setVersionPartB(sourceDocumentVersion.getVersionPartB());
                destDocumentVersion.setVersionPartSeperator(sourceDocumentVersion.getVersionPartSeperator());
                destDocumentVersion = this.documentVersionDAO.save(destDocumentVersion);
                if (sourceDocumentVersion.getRevisedDocumentVersion() != null) {
                    subProjectCopyContainer.getDocumentVersionsWithRevisionsIds().put(sourceDocumentVersion.getId(), destDocumentVersion.getId());
                }
                subProjectCopyContainer.getDocumentVersionIds().put(sourceDocumentVersion.getId(), destDocumentVersion.getId());
            }
        }
        for (Integer revisedSourceDVId : subProjectCopyContainer.getDocumentVersionsWithRevisionsIds().keySet()) {
            DocumentVersion sourceDV = this.documentVersionDAO.get(revisedSourceDVId);
            DocumentVersion destDV = this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionsWithRevisionsIds().get(revisedSourceDVId));
            DocumentVersion revisedDestDV = this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceDV.getRevisedDocumentVersion().getId()));
            destDV.setRevisedDocumentVersion(revisedDestDV);
            destDV = this.documentVersionDAO.update(destDV);
        }
        for (DocumentRef sourceDocRef : sourceDocumentRefs) {
            DocumentRef destDocRef = new DocumentRef();
            destDocRef.setAttachmentFilename(sourceDocRef.getAttachmentFilename());
            destDocRef.setAttachmentFiletype(sourceDocRef.getAttachmentFiletype());
            destDocRef.setAttachmentOriginalFilename(sourceDocRef.getAttachmentOriginalFilename());
            destDocRef.setComment(sourceDocRef.getComment());
            destDocRef.setCreated(sourceDocRef.getCreated());
            destDocRef.setDigest(sourceDocRef.getDigest());
            destDocRef.setDigestCalculatorType(sourceDocRef.getDigestCalculatorType());
            if (sourceDocRef.getDocument() != null) {
                DocumentImpl destDocRefDoc = this.documentDAO.get(subProjectCopyContainer.getDocumentImplIds().get(sourceDocRef.getDocument().getId()));
                destDocRef.setDocument(destDocRefDoc);
            }
            destDocRef.setGz(sourceDocRef.getGz());
            destDocRef.setRealm(sourceDocRef.getRealm());
            destDocRef.setReference(sourceDocRef.getReference());
            if (sourceDocRef.getReferencedVersion() != null) {
                DocumentVersion destDocRefDocVersion = this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceDocRef.getReferencedVersion().getId()));
                destDocRef.setReferencedVersion(destDocRefDocVersion);
            }
            if (sourceDocRef.getSinceDocumentVersion() != null) {
                DocumentVersion destSinceDV = this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceDocRef.getSinceDocumentVersion().getId()));
                destDocRef.setSinceDocumentVersion(destSinceDV);
            }
            if (sourceDocRef.getUntilDocumentVersion() != null) {
                DocumentVersion destUntilDV = this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceDocRef.getUntilDocumentVersion().getId()));
                destDocRef.setUntilDocumentVersion(destUntilDV);
            }
            destDocRef.setTempDocumentVersionId(sourceDocRef.getTempDocumentVersionId());
            destDocRef.setUrl(sourceDocRef.getUrl());
            destDocRef = this.documentRefDAO.save(destDocRef);
        }
        SortedSet sourceReleasedDocumentLists = sourceSubProject.getReleasedDocumentLists();
        for (ReleasedDocumentList sourceDocList : sourceReleasedDocumentLists) {
            ReleasedDocumentList destDocList = new ReleasedDocumentList();
            destDocList.setDigest(sourceDocList.getDigest());
            destDocList.setDigestCalculatorType(sourceDocList.getDigestCalculatorType());
            destDocList.setDocumentList(unreleasedDestinationDocumentList);
            destDocList.setSignature(sourceDocList.getSignature());
            destDocList.setSubProject(destinationSubProject);
            destDocList.setVersion(sourceDocList.getVersion());
            destDocList = this.documentListDAO.save(destDocList);
            subProjectCopyContainer.getDocumentListReleaseIds().put(sourceDocList.getId(), destDocList.getId());
            ArrayList sourceReleasedDocuments = new ArrayList(sourceDocList.getDocuments().values());
            for (ReleasedDocument sourceDoc : sourceReleasedDocuments) {
                ReleasedDocument destDoc = new ReleasedDocument();
                destDoc.setComment(sourceDoc.getComment());
                destDoc.setContent(sourceDoc.getContent());
                destDoc.setDateChanged(sourceDoc.isDateChanged());
                destDoc.setDigest(sourceDoc.getDigest());
                destDoc.setDigestCalculatorType(sourceDoc.getDigestCalculatorType());
                DocumentImpl destDocImpl = this.documentDAO.get(subProjectCopyContainer.getDocumentImplIds().get(sourceDoc.getDocument().getId()));
                destDoc.setDocument(destDocImpl);
                destDoc.setDocumentList(destDocList);
                destDoc.setDocumentType(sourceDoc.getDocumentType());
                destDoc.setDuration(sourceDoc.getDuration());
                destDoc.setEndDate(sourceDoc.getEndDate());
                destDoc.setModified(sourceDoc.getModified());
                destDoc.setNumber(sourceDoc.getNumber());
                ObjectPlannerImpl destOP = this.objectPlannerDAO.getObjectPlanner(subProjectCopyContainer.getObjectPlannerImplIds().get(sourceDoc.getObjectPlanner().getId()));
                destDoc.setObjectPlanner(destOP);
                destDoc.setScale(sourceDoc.getScale());
                destDoc.setStartDate(sourceDoc.getStartDate());
                destDoc.setVersionSet(sourceDoc.isVersionSet());
                destDoc.setName(this.ognlNumberCalculator.getDocumentNumberRetroactively(destDoc, sourceSubProject.getProject()));
                destDoc = this.documentDAO.save(destDoc);
            }
        }
        return subProjectCopyContainer;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentRefDAO(DocumentRefDAO documentRefDAO) {
        this.documentRefDAO = documentRefDAO;
    }

    public ProjectParticipantDAO getProjectParticipantDAO() {
        return this.projectParticipantDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    @Override
    public DocumentImpl insertAsBuiltCopyOfDocumentImpl(Integer destinationReleasedObjectPlannerId, Integer sourceDocumentImplId) throws NumberCalculatorException {
        ReleasedObjectPlanner destRop = this.objectPlannerDAO.getReleasedObjectPlanner(destinationReleasedObjectPlannerId);
        SubProject destSubProject = destRop.getObject().getObjectList().getSubProject();
        DocumentImpl sourceDoc = this.documentDAO.get(sourceDocumentImplId);
        DocumentImpl destDoc = new DocumentImpl();
        destDoc.setAsBuiltReference(sourceDoc);
        destDoc.setContent(sourceDoc.getContent());
        destDoc.setComment(sourceDoc.getComment());
        destDoc.setDocumentList(destSubProject.getEditDocumentList());
        destDoc.setDocumentType(sourceDoc.getDocumentType());
        destDoc.setModified(1);
        destDoc.setNumber(sourceDoc.getNumber());
        destDoc.setObjectPlanner(destRop.getObjectPlanner());
        destDoc.setScale(sourceDoc.getScale());
        destDoc.setName(this.ognlNumberCalculator.getNumber((Document)destDoc, destSubProject.getProject(), false));
        destDoc.setDocumentRefs(new HashMap<Integer, DocumentRef>());
        return this.documentDAO.save(destDoc);
    }
}

