/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec;

import at.cdes.api.sec.PasswordValidationError;
import at.cdes.bo.data.person.OldPassword;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.sec.TapestryPasswordUtil;
import at.cdes.bo.sec.TapestryPasswordValidator;
import at.cdes.db.dao.OldPasswordDAO;
import at.cdes.db.dao.PersonDAO;
import java.text.Normalizer;
import java.util.List;
import java.util.regex.Pattern;

public class TapestryPasswordValidatorImpl
implements TapestryPasswordValidator {
    private PersonDAO personDAO;
    private OldPasswordDAO oldPasswordDAO;
    private Long maximumNumberOfOldPasswords;
    private Long passwordMinLength;
    public static String pattern = "([a-zA-Z0-9]|\\.|\\\\|-|_|\\/|!|\\?|\\,|:|\\(|\\)|\\[|\\]|\\{|\\}|%|\u00a7|\\$|&|\u20ac|\u00f6|\u00e4|\u00fc|\u00d6|\u00c4|\u00dc|\u00df)*";

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setOldPasswordDAO(OldPasswordDAO oldPasswordDAO) {
        this.oldPasswordDAO = oldPasswordDAO;
    }

    public void setMaximumNumberOfOldPasswords(Long maximumNumberOfOldPasswords) {
        this.maximumNumberOfOldPasswords = maximumNumberOfOldPasswords;
    }

    public void setPasswordMinLength(Long passwordMinLength) {
        this.passwordMinLength = passwordMinLength;
    }

    @Override
    public Integer getPasswordMinLen() {
        return this.passwordMinLength.intValue();
    }

    @Override
    public PasswordValidationError validate(String password, Integer personId) {
        boolean hasOther;
        boolean hasDigit;
        boolean hasUpperCase;
        long minLengthPasswd;
        String normalized = Normalizer.normalize(password, Normalizer.Form.NFC);
        long l = minLengthPasswd = this.passwordMinLength != null && this.passwordMinLength > 0L ? this.passwordMinLength : 8L;
        if ((long)normalized.length() < minLengthPasswd) {
            return PasswordValidationError.TOO_SHORT;
        }
        if (!Pattern.matches(pattern, normalized)) {
            return PasswordValidationError.INVALID_CHARS;
        }
        boolean hasLowerCase = normalized.codePoints().anyMatch(Character::isLowerCase);
        int numberOfCategories = (hasLowerCase ? 1 : 0) + ((hasUpperCase = normalized.codePoints().anyMatch(Character::isUpperCase)) ? 1 : 0) + ((hasDigit = normalized.codePoints().anyMatch(Character::isDigit)) ? 1 : 0) + ((hasOther = normalized.codePoints().anyMatch(c -> !Character.isLowerCase(c) && !Character.isUpperCase(c) && !Character.isDigit(c))) ? 1 : 0);
        if (numberOfCategories < 3) {
            return PasswordValidationError.LACKING_DIVERSITY;
        }
        if (this.maximumNumberOfOldPasswords != null && this.maximumNumberOfOldPasswords > 0L) {
            Person person = this.personDAO.get(personId);
            List<OldPassword> oldPasswords = this.oldPasswordDAO.getByPerson(personId);
            if (oldPasswords.stream().anyMatch(oldPw -> TapestryPasswordUtil.checkPassword(oldPw.getPassword(), password)) || person != null && person.getPassword() != null && TapestryPasswordUtil.checkPassword(person.getPassword(), password)) {
                return PasswordValidationError.OLD_PW;
            }
        }
        return PasswordValidationError.OK;
    }
}

