/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.cycle.ReviewCycleInstanceImpl;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentType;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.DocumentVersionTextField;
import at.cdes.bo.data.label.FreeTextLabelTextField;
import at.cdes.bo.data.label.Label;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.data.label.SignatureTextField;
import at.cdes.bo.data.label.TemporaryCustomTextField;
import at.cdes.bo.data.label.TextField;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.file.FileFinder;
import at.cdes.bo.file.UploadFileHandler;
import at.cdes.bo.label.DocumentVersionTextFieldRenderer;
import at.cdes.bo.label.SampleTextFieldRenderer;
import at.cdes.bo.label.TemporaryDocumentVersionTextFieldRenderer;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestCalculatorFactory;
import at.cdes.controller.helper.DataSourceHelper;
import at.cdes.db.dao.DigestCalculatorDAO;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.db.dao.LabelDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.OrganisationDAO;
import at.cdes.db.dao.ReviewCycleCellConnectionResultDAO;
import at.cdes.db.dao.ReviewCycleDAO;
import at.cdes.db.dao.ReviewCycleEntryResultDAO;
import at.cdes.db.dao.ReviewCycleInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeResultDAO;
import at.cdes.db.dao.ReviewCyclePositionResultDAO;
import at.cdes.preview.api.BoundingBoxWithAngle;
import at.cdes.preview.api.DRMError;
import at.cdes.preview.api.HPGSError;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PatternParameters;
import at.cdes.preview.api.PatternSeekResult;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.api.Timeout;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.LabelOperations;
import at.cdes.service.ReviewCycleOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.DuplicateEntryException;
import at.cdes.service.exception.FileHandleException;
import at.cdes.service.exception.MimeDRMError;
import at.cdes.service.exception.MimeHPGSError;
import at.cdes.service.exception.MimeSeekIOError;
import at.cdes.service.exception.MimeSeekTimeout;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.clazzes.util.io.IOUtil;
import org.clazzes.util.lang.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelOperationsImpl
implements LabelOperations {
    private static final long serialVersionUID = 1L;
    private LabelDAO labelDAO;
    private OrganisationDAO organisationDAO;
    private DocumentDAO documentDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private ReviewCycleInstanceDAO reviewCycleInstanceDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewCyclePositionResultDAO reviewCyclePositionResultDAO;
    private ReviewCycleCellConnectionResultDAO reviewCycleCellConnectionResultDAO;
    private ReviewCycleEntryResultDAO reviewCycleEntryResultDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private UploadFileHandler uploadHandler;
    private DigestCalculatorFactory digestCalculatorFactory;
    private DigestCalculatorDAO digestCalculatorDAO;
    private FileFinder fileFinder;
    private IHPGLRenderer hpglRenderer;
    private ReviewCycleOperations reviewCycleOperations;
    private Double pdfBorder;
    private String applicationUrl;
    private String applicationUrlThreadLocalKey;
    static Logger logger = LoggerFactory.getLogger(LabelOperationsImpl.class);

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public void setApplicationUrlThreadLocalKey(String applicationUrlThreadLocalKey) {
        this.applicationUrlThreadLocalKey = applicationUrlThreadLocalKey;
    }

    private boolean needBorderOffset(String fileType) {
        return !"pdf".equalsIgnoreCase(fileType);
    }

    @Override
    public List getLabelsOfOrganisation(Integer id, Integer cycleId) {
        if (cycleId != null) {
            return this.labelDAO.getAllLabels(id, cycleId);
        }
        return this.labelDAO.getAllLabels(id);
    }

    @Override
    public Label getLabel(Integer labelId) {
        return this.labelDAO.getLabel(labelId);
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    public void setUploadHandler(UploadFileHandler uploadHandler) {
        this.uploadHandler = uploadHandler;
    }

    public void setDigestCalculatorFactory(DigestCalculatorFactory digestCalculatorFactory) {
        this.digestCalculatorFactory = digestCalculatorFactory;
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    @Override
    public byte[] formatFDFSample(LabelContent labelContent, Date date, Integer reviewCycleId) throws IOException {
        double dx = 0.0;
        double dy = 0.0;
        if (this.pdfBorder != null && this.needBorderOffset(labelContent.getFileType())) {
            dx = this.pdfBorder;
            dy = this.pdfBorder;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SampleTextFieldRenderer renderer = new SampleTextFieldRenderer(dx, dy, date);
        Collection allLabelContentTextFields = labelContent.getTextFields().values();
        ArrayList<TextField> labelContentTextFields = new ArrayList<TextField>();
        for (TextField textField : allLabelContentTextFields) {
            if ((reviewCycleId != null || textField.getReviewCycle() != null) && (textField.getReviewCycle() == null || !textField.getReviewCycle().getId().equals(reviewCycleId))) continue;
            labelContentTextFields.add(textField);
        }
        renderer.renderFDFFile(os, labelContentTextFields);
        return os.toByteArray();
    }

    @Override
    public byte[] formatFDF(DocumentVersion documentVersion, boolean respectUserUnit) throws IOException {
        boolean attachedLabel;
        LabelContent labelContent = this.labelDAO.getLabelContent(documentVersion.getLabelContentId());
        double dx = 0.0;
        double dy = 0.0;
        boolean bl = attachedLabel = documentVersion.getLabelCorrelation() == null;
        if (this.pdfBorder != null && this.needBorderOffset(attachedLabel ? labelContent.getFileType() : documentVersion.getFileType())) {
            dx = this.pdfBorder;
            dy = this.pdfBorder;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String applicationUrl = (String)ThreadLocalManager.getBoundResource((String)this.applicationUrlThreadLocalKey);
        DocumentVersionTextFieldRenderer renderer = new DocumentVersionTextFieldRenderer(applicationUrl, documentVersion, dx, dy, respectUserUnit, this.reviewCyclePositionResultDAO, this.reviewCycleCellConnectionResultDAO, this.reviewCycleEntryResultDAO, this.reviewCycleInstanceDAO, this.reviewCycleNodeInstanceDAO, this.reviewCycleNodeResultDAO, this.objectPlannerDAO, null);
        Collection allLabelContentTextFields = labelContent.getTextFields().values();
        ArrayList<TextField> labelContentTextFields = new ArrayList<TextField>();
        ArrayList<Integer> textFieldsNodeId = new ArrayList<Integer>();
        Iterator<ReviewCycleNode> documentsActualReviewCycleNodesIt = documentVersion.getActualReviewCycleNode().getReviewCycleCell().getReviewCycleNodesSortedByPosition().iterator();
        ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(documentVersion.getDocument().getDocumentList().getSubProject().getActiveObjectList().getId(), documentVersion.getDocument().getObjectPlanner().getId());
        for (TextField textField : allLabelContentTextFields) {
            if (textField.getReviewCycle() != null && !textField.getReviewCycle().getId().equals(documentVersion.getDocument().getObjectPlanner().getReviewCycleInstance().getReviewCycle().getId())) continue;
            if (documentsActualReviewCycleNodesIt != null && textField.getReviewCycle() == null && textField instanceof SignatureTextField && documentsActualReviewCycleNodesIt.hasNext()) {
                ReviewCycleNode textFieldsNode = documentsActualReviewCycleNodesIt.next();
                ReviewCycleNodeInstanceRelease textFieldsNodeRel = this.reviewCycleNodeInstanceDAO.getReleased(rop.getReviewCycleInstance().getId(), textFieldsNode.getId());
                List<ReviewCyclePosition> relevantReviewCyclePositions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(textFieldsNodeRel, documentVersion);
                for (ReviewCyclePosition pos : relevantReviewCyclePositions) {
                    if (!pos.getRealm().isSignatureOnLabel()) continue;
                    ((SignatureTextField)textField).setReviewCycleNode(textFieldsNode);
                    break;
                }
            }
            if (textField instanceof SignatureTextField && !textFieldsNodeId.contains(((SignatureTextField)textField).getReviewCycleNode().getId())) {
                textFieldsNodeId.add(((SignatureTextField)textField).getReviewCycleNode().getId());
            } else if (textField instanceof SignatureTextField && textFieldsNodeId.contains(((SignatureTextField)textField).getReviewCycleNode().getId())) {
                ((SignatureTextField)textField).setNodeRefUnique(false);
            }
            labelContentTextFields.add(textField);
        }
        renderer.renderFDFFile(os, labelContentTextFields);
        return os.toByteArray();
    }

    @Override
    public byte[] formatFDFCustomLabel(DocumentVersion documentVersion, List<Pair> customTextFieldValues, List<TemporaryCustomTextField> customTextFields, boolean respectUserUnit) throws IOException {
        LabelContent labelContent = this.labelDAO.getLabelContent(documentVersion.getLabelContentId());
        double dx = 0.0;
        double dy = 0.0;
        if (this.pdfBorder != null && this.needBorderOffset(documentVersion.getFileType())) {
            dx = this.pdfBorder;
            dy = this.pdfBorder;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String applicationUrl = (String)ThreadLocalManager.getBoundResource((String)this.applicationUrlThreadLocalKey);
        DocumentVersionTextFieldRenderer renderer = new DocumentVersionTextFieldRenderer(applicationUrl, documentVersion, dx, dy, respectUserUnit, this.reviewCyclePositionResultDAO, this.reviewCycleCellConnectionResultDAO, this.reviewCycleEntryResultDAO, this.reviewCycleInstanceDAO, this.reviewCycleNodeInstanceDAO, this.reviewCycleNodeResultDAO, this.objectPlannerDAO, customTextFieldValues);
        Collection allLabelContentTextFields = labelContent.getTextFields().values();
        ArrayList<TextField> labelContentTextFields = new ArrayList<TextField>();
        for (TextField textField : allLabelContentTextFields) {
            if (textField.getReviewCycle() != null && !textField.getReviewCycle().getId().equals(documentVersion.getDocument().getObjectPlanner().getReviewCycleInstance().getReviewCycle().getId())) continue;
            labelContentTextFields.add(textField);
        }
        labelContentTextFields.addAll(customTextFields);
        renderer.renderFDFFile(os, labelContentTextFields);
        return os.toByteArray();
    }

    @Override
    public byte[] formatFDFPreview(TemporaryDocumentVersion temporaryDocumentVersion, boolean respectUserUnit) throws IOException {
        LabelContent labelContent = this.labelDAO.getLabelContent(temporaryDocumentVersion.getLabelContentId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        double dx = 0.0;
        double dy = 0.0;
        boolean attachedLabel = false;
        LabelContent label = null;
        if (temporaryDocumentVersion.getLabelContentId() != null) {
            label = this.getLabelContent(temporaryDocumentVersion.getLabelContentId());
        }
        if (temporaryDocumentVersion.getLabelContentId() != null && temporaryDocumentVersion.getLabelCorrelation() == null) {
            attachedLabel = true;
        }
        boolean needBorderOffset = false;
        needBorderOffset = attachedLabel ? this.needBorderOffset(label.getFileType()) : this.needBorderOffset(temporaryDocumentVersion.getFileType());
        if (this.pdfBorder != null && needBorderOffset) {
            dx = this.pdfBorder;
            dy = this.pdfBorder;
        }
        DocumentImpl document = this.documentDAO.get(temporaryDocumentVersion.getDocumentId());
        TemporaryDocumentVersionTextFieldRenderer renderer = new TemporaryDocumentVersionTextFieldRenderer(temporaryDocumentVersion, dx, dy, respectUserUnit, this.documentDAO);
        Collection allLabelContentTextFields = labelContent.getTextFields().values();
        ArrayList<TextField> labelContentTextFields = new ArrayList<TextField>();
        for (TextField textField : allLabelContentTextFields) {
            if (!textField.getReviewCycle().getId().equals(document.getObjectPlanner().getReviewCycleInstance().getReviewCycle().getId())) continue;
            labelContentTextFields.add(textField);
        }
        renderer.renderFDFFile(os, labelContentTextFields);
        return os.toByteArray();
    }

    @Override
    public boolean needToSeekLabel(TemporaryDocumentVersion documentVersion) {
        DocumentImpl document = this.documentDAO.get(documentVersion.getDocumentId());
        ObjectPlanner op = document.getObjectPlanner();
        ReleasedObjectList releasedObjectList = document.getObjectPlanner().getObject().getObjectList().getSubProject().getActiveObjectList();
        ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(releasedObjectList.getId(), op.getId());
        Label label = rop.getReviewCycleInstance().getLabel();
        return !(label == null ? documentVersion.getLlx() != null && documentVersion.getLly() != null && documentVersion.getUrx() != null && documentVersion.getUry() != null : documentVersion.getLabelContentId() != null && documentVersion.getLabelCorrelation() != null && documentVersion.getLabelSeparation() != null && documentVersion.getLabelXOffset() != null && documentVersion.getLabelYOffset() != null);
    }

    @Override
    public DocumentVersion seekLabel(DocumentVersion documentVersion) throws MimeSeekIOError, MimeSeekTimeout, MimeHPGSError, MimeDRMError {
        TemporaryDocumentVersion tdv = new TemporaryDocumentVersion();
        tdv.setName(documentVersion.getName());
        tdv.setDocumentId(documentVersion.getDocument().getId());
        tdv.setFileName(documentVersion.getFileName());
        tdv.setLabelContentId(documentVersion.getLabelContentId());
        tdv = this.seekLabel(tdv, false);
        documentVersion.setPreviewRotation(tdv.getPreviewRotation());
        documentVersion.setLabelCorrelation(tdv.getLabelCorrelation());
        documentVersion.setLabelOverlap(tdv.getLabelOverlap());
        documentVersion.setLabelSeparation(tdv.getLabelSeparation());
        documentVersion.setLabelXOffset(tdv.getLabelXOffset());
        documentVersion.setLabelYOffset(tdv.getLabelYOffset());
        documentVersion.setLabelContentId(tdv.getLabelContentId());
        documentVersion.setLlx(tdv.getLlx());
        documentVersion.setLly(tdv.getLly());
        documentVersion.setUrx(tdv.getUrx());
        documentVersion.setUry(tdv.getUry());
        documentVersion.setUserUnit(tdv.getUserUnit());
        documentVersion.setNativeRotation(tdv.getNativeRotation());
        documentVersion.setNumberOfPages(tdv.getNumberOfPages());
        return documentVersion;
    }

    @Override
    public BoundingBoxWithAngle getBoundingBox(DocumentVersion documentVersion, boolean getLabelsBB) {
        Integer labelContentId = documentVersion.getLabelContentId();
        if (getLabelsBB && labelContentId == null) {
            return null;
        }
        LabelContent labelContent = this.labelDAO.getLabelContent(labelContentId);
        String fileName = null;
        String unique = null;
        FileMimeInputStream stream = null;
        File file = null;
        if (getLabelsBB) {
            unique = this.getFileFinder().makeUniqueName(labelContent.getFileName(), CDESFileRepository.LABELREPOSITORY);
            fileName = labelContent.getFileName();
            try {
                file = this.getFileFinder().findFile(fileName, CDESFileRepository.LABELREPOSITORY);
            }
            catch (FileHandleException e1) {
                e1.printStackTrace();
            }
            try {
                stream = new FileMimeInputStream(file, unique, labelContent.getName() + "." + labelContent.getFileType(), DefaultHttpContext.getInstance().getMimeType(fileName));
            }
            catch (IOError e) {
                e.printStackTrace();
            }
        } else {
            unique = this.getFileFinder().makeUniqueName(documentVersion.getFileName(), CDESFileRepository.PLANREPOSITORY);
            fileName = documentVersion.getFileName();
            try {
                file = this.getFileFinder().findFile(fileName, CDESFileRepository.PLANREPOSITORY);
            }
            catch (FileHandleException e1) {
                e1.printStackTrace();
            }
            try {
                stream = new FileMimeInputStream(file, unique, documentVersion.getName() + "." + documentVersion.getFileType(), DefaultHttpContext.getInstance().getMimeType(fileName));
            }
            catch (IOError e) {
                e.printStackTrace();
            }
        }
        BoundingBoxWithAngle bb = null;
        try {
            bb = this.hpglRenderer.getBoundingBox(stream);
            if (getLabelsBB) {
                bb.setAngle(labelContent.getRotationAngle());
            }
        }
        catch (PreviewException e) {
            e.printStackTrace();
        }
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BoundingBoxWithAngle> getPageBBoxes(TemporaryDocumentVersion documentVersion, boolean isTemporaryDocumentVersion) {
        String fileName = null;
        String unique = null;
        FileMimeInputStream stream = null;
        File file = null;
        CDESFileRepository fileRepository = null;
        fileName = documentVersion.getFileName();
        fileRepository = isTemporaryDocumentVersion ? CDESFileRepository.TEMPREPOSITORY : CDESFileRepository.PLANREPOSITORY;
        unique = this.getFileFinder().makeUniqueName(fileName, fileRepository);
        if (isTemporaryDocumentVersion) {
            file = new File(documentVersion.getFileName());
        } else {
            try {
                file = this.getFileFinder().findFile(fileName, fileRepository);
            }
            catch (FileHandleException e2) {
                e2.printStackTrace();
            }
        }
        try {
            stream = new FileMimeInputStream(file, unique, documentVersion.getName() + "." + documentVersion.getFileType(), DefaultHttpContext.getInstance().getMimeType(fileName));
        }
        catch (IOError e) {
            e.printStackTrace();
        }
        ArrayList<BoundingBoxWithAngle> ret = new ArrayList();
        try {
            ret = this.hpglRenderer.getPageBoundingBoxes(stream);
        }
        catch (PreviewException e) {
            logger.error("hpglRenderer.getPageBoundingBoxes throws PreviewException.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("hpglRenderer.getPageBoundingBoxes throws exception.", (Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable e) {
                logger.warn("Error closing input stream for file [" + unique + "]", e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TemporaryDocumentVersion seekLabel(TemporaryDocumentVersion documentVersion, boolean isTemporaryDocumentVersion) throws MimeSeekIOError, MimeSeekTimeout, MimeHPGSError, MimeDRMError {
        String labelUnique;
        String unique;
        FileMimeInputStream labelStream;
        FileMimeInputStream stream;
        block69: {
            DocumentImpl document = this.documentDAO.get(documentVersion.getDocumentId());
            Network network = document.getDocumentList().getSubProject().getProject().getNetwork();
            Label label = null;
            if (documentVersion.isRenderLabelOutsideOfPlan()) {
                LabelContent outsideLabelContent = this.getLabelContent(documentVersion.getLabelOutsideContentId());
                if (outsideLabelContent == null) {
                    outsideLabelContent = this.getLabelOutsideContent(document.getId(), true);
                }
                if (outsideLabelContent != null) {
                    documentVersion.setLabelContentId(outsideLabelContent.getId());
                    documentVersion.setLabelCorrelation(null);
                }
            } else if (!documentVersion.isLabelIgnored()) {
                ObjectPlanner op = document.getObjectPlanner();
                ReleasedObjectList releasedObjectList = document.getObjectPlanner().getObject().getObjectList().getSubProject().getActiveObjectList();
                ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(releasedObjectList.getId(), op.getId());
                label = rop.getReviewCycleInstance().getLabel();
            }
            if (label == null) {
                if (documentVersion.getLlx() != null && documentVersion.getLly() != null && documentVersion.getUrx() != null && documentVersion.getUry() != null) {
                    documentVersion.setLabelIgnored(true);
                    return documentVersion;
                }
            } else if (documentVersion.getLabelContentId() != null && documentVersion.getLabelCorrelation() != null && documentVersion.getLabelSeparation() != null && documentVersion.getLabelXOffset() != null && documentVersion.getLabelYOffset() != null) {
                return documentVersion;
            }
            stream = null;
            labelStream = null;
            unique = null;
            unique = isTemporaryDocumentVersion ? this.getFileFinder().makeUniqueName(documentVersion.getFileName(), CDESFileRepository.TEMPREPOSITORY) : this.getFileFinder().makeUniqueName(documentVersion.getFileName(), CDESFileRepository.PLANREPOSITORY);
            labelUnique = null;
            int numberOfPages = 0;
            try {
                File file = null;
                file = isTemporaryDocumentVersion ? new File(documentVersion.getFileName()) : this.getFileFinder().findFile(documentVersion.getFileName(), CDESFileRepository.PLANREPOSITORY);
                String fileType = IOUtil.getFileExtension((String)documentVersion.getFileName()).toLowerCase();
                stream = new FileMimeInputStream(file, unique, documentVersion.getName() + "." + fileType, DefaultHttpContext.getInstance().getMimeType(documentVersion.getFileName()));
                if (label == null) {
                    List bbs = null;
                    BoundingBoxWithAngle bb = null;
                    try {
                        bbs = this.hpglRenderer.getPageBoundingBoxes((IMimeInputStream)stream);
                        numberOfPages = bbs.toArray().length;
                    }
                    catch (PreviewException e) {
                        logger.error("hpglRenderer.getPageBoundingBoxes throws PreviewException.", (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error("hpglRenderer.getPageBoundingBoxes throws exception.", (Throwable)e);
                    }
                    finally {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (Throwable e) {
                            logger.warn("Error closing input stream for file [" + unique + "]", e);
                        }
                    }
                    numberOfPages = numberOfPages == 0 ? 1 : numberOfPages;
                    bb = bbs != null ? (BoundingBoxWithAngle)bbs.get(0) : this.hpglRenderer.getBoundingBox((IMimeInputStream)stream);
                    logger.info("getBoundingBox for file [" + unique + "] returned [llx=" + bb.getLlx() + ",lly=" + bb.getLly() + ",urx=" + bb.getUrx() + ",ury=" + bb.getUry() + ",angle=" + bb.getAngle() + ",pages=" + numberOfPages + "]");
                    documentVersion.setLlx(bb.getLlx());
                    documentVersion.setLly(bb.getLly());
                    documentVersion.setUrx(bb.getUrx());
                    documentVersion.setUry(bb.getUry());
                    documentVersion.setUserUnit(bb.getUserUnit());
                    documentVersion.setNativeRotation(bb.getAngle());
                    documentVersion.setPreviewRotation(bb.getAngle());
                    documentVersion.setNumberOfPages(numberOfPages);
                    break block69;
                }
                LabelContent content = null;
                if (documentVersion.getAsBuiltReference() != null && documentVersion.getAsBuiltReference().getLabelContentId() != null) {
                    content = this.labelDAO.getLabelContent(documentVersion.getAsBuiltReference().getLabelContentId());
                } else {
                    DocumentType typegroup = document.getDocumentType();
                    if (typegroup.getDocumentTypeGroup() != null) {
                        typegroup = typegroup.getDocumentTypeGroup();
                    }
                    if (typegroup.getLabelContents() != null && typegroup.getLabelContents().size() > 0) {
                        ArrayList labelContents = new ArrayList(typegroup.getLabelContents().values());
                        for (LabelContent labelContent : labelContents) {
                            if (labelContent.getLabel().getId() != label.getId()) continue;
                            content = labelContent;
                            break;
                        }
                    }
                }
                if (content == null || content.getLabel().getId() != label.getId()) {
                    content = this.labelDAO.getDefaultLabelContent(label);
                }
                File labelFile = this.getFileFinder().findFile(content.getFileName(), CDESFileRepository.LABELREPOSITORY);
                labelUnique = this.getFileFinder().makeUniqueName(content.getFileName(), CDESFileRepository.LABELREPOSITORY);
                labelStream = new FileMimeInputStream(labelFile, labelUnique, content.getName() + "." + content.getFileType(), DefaultHttpContext.getInstance().getMimeType(content.getFileName()));
                PatternSeekResult pp = this.hpglRenderer.seekPattern((IMimeInputStream)stream, (IMimeInputStream)labelStream, content.getRotationAngle());
                PatternParameters[] params = pp.getParameters();
                try {
                    List bbs = this.hpglRenderer.getPageBoundingBoxes((IMimeInputStream)stream);
                    numberOfPages = bbs.toArray().length;
                }
                catch (PreviewException e) {
                    logger.error("hpglRenderer.getPageBoundingBoxes throws PreviewException.", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error("hpglRenderer.getPageBoundingBoxes throws exception.", (Throwable)e);
                }
                finally {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Throwable e) {
                        logger.warn("Error closing input stream for file [" + unique + "]", e);
                    }
                }
                numberOfPages = numberOfPages == 0 ? 1 : numberOfPages;
                logger.info("seekPattern for file [" + unique + "] returned [llx=" + pp.getBoundingBox().getLlx() + ",lly=" + pp.getBoundingBox().getLly() + ",urx=" + pp.getBoundingBox().getUrx() + ",ury=" + pp.getBoundingBox().getUry() + ",angle=" + pp.getBoundingBox().getAngle() + ",pages=" + numberOfPages + "]");
                PatternParameters pfinal = null;
                for (PatternParameters p : params) {
                    logger.info("seekPattern for file [" + unique + "] returned [rotation=" + p.getAngle() + ",correlation=" + p.getCorrelation() + ",overlap=" + p.getOverlap() + ",separation=" + p.getSeparation() + ",dx=" + p.getDx() + ",dy=" + p.getDy() + "]");
                    if (pfinal != null && !(p.getCorrelation() > pfinal.getCorrelation())) continue;
                    pfinal = p;
                }
                if (pfinal == null) {
                    throw new MimeSeekIOError("seekPattern did not return a valid rotation angle.");
                }
                documentVersion.setPreviewRotation(pfinal.getAngle());
                documentVersion.setLabelCorrelation(pfinal.getCorrelation());
                documentVersion.setLabelOverlap(pfinal.getOverlap());
                documentVersion.setLabelSeparation(pfinal.getSeparation());
                documentVersion.setLabelXOffset(pfinal.getDx());
                documentVersion.setLabelYOffset(pfinal.getDy());
                documentVersion.setLabelContentId(content.getId());
                documentVersion.setLlx(pp.getBoundingBox().getLlx());
                documentVersion.setLly(pp.getBoundingBox().getLly());
                documentVersion.setUrx(pp.getBoundingBox().getUrx());
                documentVersion.setUry(pp.getBoundingBox().getUry());
                documentVersion.setUserUnit(pp.getBoundingBox().getUserUnit());
                documentVersion.setNativeRotation(pp.getBoundingBox().getAngle());
                documentVersion.setNumberOfPages(numberOfPages);
            }
            catch (Timeout e) {
                try {
                    if (!logger.isDebugEnabled()) throw new MimeSeekTimeout("Timeout seeking label", e);
                    logger.debug("Timeout seeking label: ", (Throwable)e);
                    throw new MimeSeekTimeout("Timeout seeking label", e);
                    catch (HPGSError e2) {
                        logger.error("HPGSError seeking label: ", (Throwable)e2);
                        throw new MimeHPGSError("HPGSError seeking label", e2);
                    }
                    catch (FileHandleException e3) {
                        logger.error("FileHandleException seeking label: ", (Throwable)e3);
                        throw new MimeSeekIOError("FileHandleException seeking label", e3);
                    }
                    catch (DRMError e4) {
                        logger.error("DRMError seeking label: ", (Throwable)e4);
                        throw new MimeDRMError("DRMError seeking label", e4);
                    }
                    catch (PreviewException e5) {
                        logger.error("IOError seeking label: ", (Throwable)e5);
                        throw new MimeSeekIOError("IOError seeking label: ", e5);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Throwable e6) {
                        logger.warn("Error closing input stream for file [" + unique + "]", e6);
                    }
                    try {
                        if (labelStream == null) throw throwable;
                        labelStream.close();
                        throw throwable;
                    }
                    catch (Throwable e7) {
                        logger.warn("Error closing input stream for label [" + labelUnique + "] during pattern seek of file [" + unique + "]", e7);
                    }
                    throw throwable;
                }
            }
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Throwable e) {
            logger.warn("Error closing input stream for file [" + unique + "]", e);
        }
        try {
            if (labelStream == null) return documentVersion;
            labelStream.close();
            return documentVersion;
        }
        catch (Throwable e) {
            logger.warn("Error closing input stream for label [" + labelUnique + "] during pattern seek of file [" + unique + "]", e);
            return documentVersion;
        }
    }

    public void setReviewCyclePositionResultDAO(ReviewCyclePositionResultDAO reviewCyclePositionResultDAO) {
        this.reviewCyclePositionResultDAO = reviewCyclePositionResultDAO;
    }

    public void setReviewCycleInstanceDAO(ReviewCycleInstanceDAO reviewCycleInstanceDAO) {
        this.reviewCycleInstanceDAO = reviewCycleInstanceDAO;
    }

    public void setHpglRenderer(IHPGLRenderer hpglRenderer) {
        this.hpglRenderer = hpglRenderer;
    }

    protected FileFinder getFileFinder() {
        return this.fileFinder;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setReviewCycleCellConnectionResultDAO(ReviewCycleCellConnectionResultDAO reviewCycleCellConnectionResultDAO) {
        this.reviewCycleCellConnectionResultDAO = reviewCycleCellConnectionResultDAO;
    }

    public void setReviewCycleEntryResultDAO(ReviewCycleEntryResultDAO reviewCycleEntryResultDAO) {
        this.reviewCycleEntryResultDAO = reviewCycleEntryResultDAO;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    @Override
    public void delete(Integer labelId) {
        Label label = this.labelDAO.getLabel(labelId);
        List<ReviewCycleInstanceImpl> instances = this.reviewCycleInstanceDAO.getAllForLabel(label);
        if (instances != null && !instances.isEmpty()) {
            for (ReviewCycleInstanceImpl instance : instances) {
                instance.setLabel(null);
                this.reviewCycleOperations.updateReviewCycleInstance(instance, instance.getSubProject().getId());
            }
        }
        Collection labelContents = label.getLabelContents().values();
        for (LabelContent labelContent : labelContents) {
            this.deleteLabelContent(labelContent.getId());
        }
        this.labelDAO.deleteLabel(label);
    }

    public void setReviewCycleOperations(ReviewCycleOperations reviewCycleOperations) {
        this.reviewCycleOperations = reviewCycleOperations;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setPdfBorder(Double pdfBorder) {
        this.pdfBorder = pdfBorder;
    }

    @Override
    public LabelContent getLabelContent(Integer id) {
        return this.labelDAO.getLabelContent(id);
    }

    @Override
    public LabelContent updateLabelContent(LabelContent labelContent) {
        return this.labelDAO.mergeLabelContent(labelContent);
    }

    @Override
    public void deleteLabelContent(Integer labelContentId) {
        LabelContent labelContent = this.labelDAO.getLabelContent(labelContentId);
        if (labelContent.getTextFields() != null && !labelContent.getTextFields().isEmpty()) {
            Collection fields = labelContent.getTextFields().values();
            for (TextField field : fields) {
                this.labelDAO.deleteTextField(field);
            }
            labelContent.getTextFields().clear();
        }
        this.labelDAO.deleteLabelContent(labelContent);
        if (labelContent.getFileName() != null) {
            try {
                this.uploadHandler.deleteLabelFile(labelContent.getFileName());
            }
            catch (FileHandleException e) {
                e.printStackTrace();
            }
        }
        if (labelContent.getOrigFileName() != null) {
            try {
                this.uploadHandler.deleteLabelFile(labelContent.getOrigFileName());
            }
            catch (FileHandleException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deleteTextField(Integer textFieldId) {
        TextField textField = this.labelDAO.getTextField(textFieldId);
        this.labelDAO.deleteTextField(textField);
    }

    @Override
    public void moveTextField(Integer textFieldId, Integer deltaX, Integer deltaY) {
        TextField textField = this.labelDAO.getTextField(textFieldId);
        textField.setLlx(textField.getLlx() + (double)deltaX.intValue());
        textField.setLly(textField.getLly() + (double)deltaY.intValue());
        textField.setUrx(textField.getUrx() + (double)deltaX.intValue());
        textField.setUry(textField.getUry() + (double)deltaY.intValue());
        this.labelDAO.updateTextField(textField);
    }

    @Override
    public void moveAllTextFields(Integer labelContentId, Integer deltaX, Integer deltaY) {
        LabelContent labelContent = this.labelDAO.getLabelContent(labelContentId);
        if (labelContent.getTextFields() != null && !labelContent.getTextFields().isEmpty()) {
            Collection fields = labelContent.getTextFields().values();
            for (TextField field : fields) {
                this.moveTextField(field.getId(), deltaX, deltaY);
            }
        }
    }

    @Override
    public Label insertLabel(Label label) {
        return this.labelDAO.saveLabel(label);
    }

    @Override
    public Label updateLabel(Label label) {
        return this.labelDAO.updateLabel(label);
    }

    @Override
    public LabelContent insertLabelContent(LabelContent labelContent, Integer organisationId, Integer reviewCycleId, IMimeInputStream orig, IMimeInputStream view) {
        Label label;
        ReviewCycle cycle = null;
        if (reviewCycleId != null) {
            cycle = this.reviewCycleDAO.get(reviewCycleId);
        }
        Organisation org = this.organisationDAO.get(organisationId);
        try {
            DataSource origDS = null;
            DataSource viewDS = null;
            DigestCalculator calc = this.digestCalculatorFactory.getDigestCalculator(null, File.class);
            if (view != null) {
                viewDS = DataSourceHelper.toDataSource(view);
                labelContent.setFileName(this.uploadHandler.saveLabel(view.getPrettyName(), cycle != null ? cycle.getId() : labelContent.getLabel().getId(), org, viewDS.getInputStream()));
                labelContent.setFileType(IOUtil.getFileExtension((String)labelContent.getFileName()));
                labelContent.setFileDigest(calc.getDigest(this.fileFinder.findFile(labelContent.getFileName(), CDESFileRepository.LABELREPOSITORY)));
            }
            if (orig != null) {
                origDS = DataSourceHelper.toDataSource(orig);
                labelContent.setOrigFileName(this.uploadHandler.saveLabel(orig.getPrettyName(), cycle != null ? cycle.getId() : labelContent.getLabel().getId(), org, origDS.getInputStream()));
                labelContent.setOrigFileType(IOUtil.getFileExtension((String)labelContent.getOrigFileName()));
                calc = this.digestCalculatorFactory.getDigestCalculator(null, File.class);
                labelContent.setOrigFileDigest(calc.getDigest(this.fileFinder.findFile(labelContent.getOrigFileName(), CDESFileRepository.LABELREPOSITORY)));
            }
            labelContent.setFileDigestDigester(this.digestCalculatorDAO.get(calc.getClass().getName()));
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("Digesting of the uploaded label failed", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Saving of the uploaded label failed", e);
        }
        catch (IOException e) {
            throw new ActionException("IOException - Saving of the uploaded label failed", e);
        }
        catch (IOError e) {
            throw new ActionException("IOError - Saving of the uploaded label failed", e);
        }
        finally {
            try {
                view.close();
            }
            catch (Throwable e) {
                logger.warn("IOError - Saving of the uploaded label failed", e);
            }
            try {
                orig.close();
            }
            catch (Throwable e) {
                logger.warn("IOError - Saving of the uploaded label failed", e);
            }
        }
        labelContent = this.labelDAO.saveLabelContent(labelContent);
        if (labelContent.getTextFields() == null) {
            labelContent.setTextFields(new HashMap());
        }
        if (((label = this.labelDAO.getLabel(labelContent.getLabel().getId())).getLabelContents() == null || label.getLabelContents().size() <= 1) && this.labelDAO.getDefaultLabelContent(label) == null) {
            labelContent.setDefaultLabelContent(true);
        }
        return this.labelDAO.mergeLabelContent(labelContent);
    }

    @Override
    public LabelContent updateLabelContent2(LabelContent labelContent, List<SignatureTextField> supdates, List<DocumentVersionTextField> dupdates, List<FreeTextLabelTextField> fupdates, List<Integer> sdeletes, List<Integer> ddeletes, List<Integer> fdeletes, IMimeInputStream orig, IMimeInputStream view, Boolean deletedKeysToAdd, Integer alternativeReviewCycleId) {
        TextField newField;
        TextField field;
        Integer id;
        TextField field2;
        int i;
        ReviewCycle cycle = labelContent.getLabel().getReviewCycle();
        Organisation org = labelContent.getLabel().getOrganisation();
        ReviewCycle alternativeReviewCycle = null;
        if (alternativeReviewCycleId != null) {
            alternativeReviewCycle = this.reviewCycleOperations.getReviewCycle(alternativeReviewCycleId);
        }
        for (i = 0; i < supdates.size(); ++i) {
            field2 = supdates.get(i);
            field2.setLabelContent(labelContent);
            if (field2.getReviewCycle() == null) {
                field2.setReviewCycle(labelContent.getLabel().getReviewCycle());
            }
            if (field2.getId() != null) {
                if (((SignatureTextField)field2).getReviewCycleNode().getId() == 1) {
                    ((SignatureTextField)field2).setReviewCycleNode(null);
                }
                field2 = (SignatureTextField)this.labelDAO.updateTextField(field2);
                continue;
            }
            if (((SignatureTextField)field2).getReviewCycleNode() == null) continue;
            if (((SignatureTextField)field2).getReviewCycleNode().getId() == 1) {
                ((SignatureTextField)field2).setReviewCycleNode(null);
            }
            field2 = (SignatureTextField)this.labelDAO.saveTextField(field2);
            labelContent.getTextFields().put(field2.getId(), field2);
        }
        for (i = 0; i < sdeletes.size(); ++i) {
            id = sdeletes.get(i);
            field = (SignatureTextField)this.labelDAO.getTextField(id);
            if (field == null) continue;
            if (!deletedKeysToAdd.booleanValue()) {
                if (((SignatureTextField)field).getReviewCycleNode().getId() == 1) {
                    ((SignatureTextField)field).setReviewCycleNode(null);
                }
                labelContent.getTextFields().remove(field.getId());
                this.labelDAO.deleteTextField(field);
                continue;
            }
            newField = new SignatureTextField();
            newField.setLlx(field.getLlx());
            newField.setLly(field.getLly());
            newField.setUrx(field.getUrx());
            newField.setUry(field.getUry());
            newField.setFont(field.getFont());
            newField.setFontPtSize(field.getFontPtSize());
            newField.setFontStyle(field.getFontStyle());
            newField.setAlignment(field.getAlignment());
            ((SignatureTextField)newField).setReviewCycleNode(alternativeReviewCycle != null ? ((ReviewCycleCell)alternativeReviewCycle.getReviewCycleCellsSortedByPosition().toArray()[0]).getFirstReviewCycleNode() : ((SignatureTextField)field).getReviewCycleNode());
            newField.setLabelContent(labelContent);
            newField.setReviewCycle(alternativeReviewCycle != null ? alternativeReviewCycle : field.getReviewCycle());
            newField = (SignatureTextField)this.labelDAO.saveTextField(newField);
            labelContent.getTextFields().put(newField.getId(), newField);
        }
        for (i = 0; i < dupdates.size(); ++i) {
            field2 = dupdates.get(i);
            field2.setLabelContent(labelContent);
            if (field2.getReviewCycle() == null) {
                field2.setReviewCycle(labelContent.getLabel().getReviewCycle());
            }
            if (field2.getId() != null) {
                field2 = (DocumentVersionTextField)this.labelDAO.updateTextField(field2);
                continue;
            }
            if (((DocumentVersionTextField)field2).getContent() == null || ((DocumentVersionTextField)field2).getContent().length() <= 0) continue;
            field2 = (DocumentVersionTextField)this.labelDAO.saveTextField(field2);
            labelContent.getTextFields().put(field2.getId(), field2);
        }
        for (i = 0; i < ddeletes.size(); ++i) {
            id = ddeletes.get(i);
            field = this.labelDAO.getTextField(id);
            if (field == null) continue;
            if (!deletedKeysToAdd.booleanValue()) {
                labelContent.getTextFields().remove(field.getId());
                this.labelDAO.deleteTextField(field);
                continue;
            }
            newField = new DocumentVersionTextField();
            newField.setLlx(field.getLlx());
            newField.setLly(field.getLly());
            newField.setUrx(field.getUrx());
            newField.setUry(field.getUry());
            newField.setFont(field.getFont());
            newField.setFontPtSize(field.getFontPtSize());
            newField.setFontStyle(field.getFontStyle());
            newField.setAlignment(field.getAlignment());
            ((DocumentVersionTextField)newField).setContent(((DocumentVersionTextField)field).getContent());
            newField.setLabelContent(labelContent);
            newField.setReviewCycle(alternativeReviewCycle != null ? alternativeReviewCycle : field.getReviewCycle());
            newField = (DocumentVersionTextField)this.labelDAO.saveTextField(newField);
            labelContent.getTextFields().put(newField.getId(), newField);
        }
        for (i = 0; i < fupdates.size(); ++i) {
            field2 = fupdates.get(i);
            field2.setLabelContent(labelContent);
            if (field2.getReviewCycle() == null) {
                field2.setReviewCycle(labelContent.getLabel().getReviewCycle());
            }
            if (field2.getId() != null) {
                field2 = (FreeTextLabelTextField)this.labelDAO.updateTextField(field2);
                continue;
            }
            if (((FreeTextLabelTextField)field2).getContent() == null || ((FreeTextLabelTextField)field2).getContent().length() <= 0) continue;
            field2 = (FreeTextLabelTextField)this.labelDAO.saveTextField(field2);
            labelContent.getTextFields().put(field2.getId(), field2);
        }
        for (i = 0; i < fdeletes.size(); ++i) {
            id = fdeletes.get(i);
            field = this.labelDAO.getTextField(id);
            if (field == null) continue;
            if (!deletedKeysToAdd.booleanValue()) {
                labelContent.getTextFields().remove(field.getId());
                this.labelDAO.deleteTextField(field);
                continue;
            }
            newField = new FreeTextLabelTextField();
            newField.setLlx(field.getLlx());
            newField.setLly(field.getLly());
            newField.setUrx(field.getUrx());
            newField.setUry(field.getUry());
            newField.setFont(field.getFont());
            newField.setFontPtSize(field.getFontPtSize());
            newField.setFontStyle(field.getFontStyle());
            newField.setAlignment(field.getAlignment());
            ((FreeTextLabelTextField)newField).setContent(((FreeTextLabelTextField)field).getContent());
            newField.setLabelContent(labelContent);
            newField.setReviewCycle(alternativeReviewCycle != null ? alternativeReviewCycle : field.getReviewCycle());
            newField = (FreeTextLabelTextField)this.labelDAO.saveTextField(newField);
            labelContent.getTextFields().put(newField.getId(), newField);
        }
        try {
            if (view != null) {
                DataSource viewDS = DataSourceHelper.toDataSource(view);
                labelContent.setFileName(this.uploadHandler.saveLabel(view.getPrettyName(), cycle != null ? cycle.getId() : labelContent.getLabel().getId(), org, viewDS.getInputStream()));
                labelContent.setFileType(IOUtil.getFileExtension((String)labelContent.getFileName()));
                DigestCalculator calc = this.digestCalculatorFactory.getDigestCalculator(null, File.class);
                labelContent.setFileDigest(calc.getDigest(this.fileFinder.findFile(labelContent.getFileName(), CDESFileRepository.LABELREPOSITORY)));
                labelContent.setFileDigestDigester(this.digestCalculatorDAO.get(calc.getClass().getName()));
            }
            if (orig != null) {
                DataSource origDS = DataSourceHelper.toDataSource(orig);
                labelContent.setOrigFileName(this.uploadHandler.saveLabel(orig.getPrettyName(), cycle != null ? cycle.getId() : labelContent.getLabel().getId(), org, origDS.getInputStream()));
                labelContent.setOrigFileType(IOUtil.getFileExtension((String)labelContent.getOrigFileName()));
                DigestCalculator calc = this.digestCalculatorFactory.getDigestCalculator(null, File.class);
                labelContent.setOrigFileDigest(calc.getDigest(this.fileFinder.findFile(labelContent.getOrigFileName(), CDESFileRepository.LABELREPOSITORY)));
                labelContent.setFileDigestDigester(this.digestCalculatorDAO.get(calc.getClass().getName()));
            }
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("Digesting of the uploaded label failed", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Saving of the uploaded label failed", e);
        }
        catch (IOException e) {
            throw new ActionException("IOException - Saving of the uploaded label failed", e);
        }
        catch (IOError e) {
            throw new ActionException("IOError - Saving of the uploaded label failed", e);
        }
        finally {
            try {
                if (orig != null) {
                    orig.close();
                }
            }
            catch (Throwable e) {
                throw new ActionException("IOError - Saving of the uploaded label failed", e);
            }
            try {
                if (view != null) {
                    view.close();
                }
            }
            catch (Throwable e) {
                throw new ActionException("IOError - Saving of the uploaded label failed", e);
            }
        }
        return this.labelDAO.mergeLabelContent(labelContent);
    }

    @Override
    public void updateDefaultLabelContent(LabelContent labelContent) {
        Collection lcs = labelContent.getLabel().getLabelContents().values();
        for (LabelContent lc : lcs) {
            if (!lc.isDefaultLabelContent()) continue;
            lc.setDefaultLabelContent(false);
            this.labelDAO.mergeLabelContent(lc);
        }
        labelContent.setDefaultLabelContent(true);
        this.labelDAO.mergeLabelContent(labelContent);
    }

    @Override
    public Label copyLabel(Integer labelId) throws DuplicateEntryException {
        String name;
        Label label = this.labelDAO.getLabel(labelId);
        Label labelCopy = new Label();
        List labels = this.labelDAO.getAllLabels(label.getOrganisation().getId());
        boolean findingUniqueName = true;
        String nameCopy = name = label.getName();
        String postfix = "~";
        int count = 0;
        while (findingUniqueName && count < 99) {
            boolean foundSameName = false;
            for (Label l : labels) {
                if (!l.getName().equals(name + postfix + count)) continue;
                foundSameName = true;
            }
            if (foundSameName) {
                ++count;
                continue;
            }
            nameCopy = name + postfix + count;
            findingUniqueName = false;
        }
        if (nameCopy == null || findingUniqueName) {
            throw new DuplicateEntryException("name", name + postfix + count);
        }
        labelCopy.setName(nameCopy);
        labelCopy.setComment(label.getComment());
        labelCopy.setOrganisation(label.getOrganisation());
        labelCopy.setReviewCycle(label.getReviewCycle());
        labelCopy.setLabelContents(new HashMap());
        labelCopy = this.labelDAO.saveLabel(labelCopy);
        ArrayList originalContents = new ArrayList(label.getLabelContents().values());
        for (LabelContent lc : originalContents) {
            LabelContent copyLC = new LabelContent();
            copyLC.setComment(lc.getComment());
            copyLC.setDefaultLabelContent(lc.isDefaultLabelContent());
            copyLC.setAsBuiltUnchangedDestination(lc.isAsBuiltUnchangedDestination());
            copyLC.setRenderableOutside(lc.isRenderableOutside());
            copyLC.setLabel(labelCopy);
            copyLC.setName(lc.getName());
            copyLC.setRotationAngle(lc.getRotationAngle());
            copyLC.setTextFields(new HashMap());
            try {
                copyLC.setFileName(this.uploadHandler.copyLabel(lc.getLabel(), lc.getFileName()));
                copyLC.setFileType(IOUtil.getFileExtension((String)copyLC.getFileName()));
                if (lc.getOrigFileName() != null && lc.getOrigFileName().length() > 0) {
                    copyLC.setOrigFileName(this.uploadHandler.copyLabel(lc.getLabel(), lc.getOrigFileName()));
                    copyLC.setOrigFileType(IOUtil.getFileExtension((String)copyLC.getOrigFileName()));
                }
                DigestCalculator calc = this.digestCalculatorFactory.getDigestCalculator(null, File.class);
                copyLC.setFileDigest(calc.getDigest(this.fileFinder.findFile(copyLC.getFileName(), CDESFileRepository.LABELREPOSITORY)));
                if (lc.getOrigFileName() != null && lc.getOrigFileName().length() > 0) {
                    calc = this.digestCalculatorFactory.getDigestCalculator(null, File.class);
                    copyLC.setOrigFileDigest(calc.getDigest(this.fileFinder.findFile(copyLC.getOrigFileName(), CDESFileRepository.LABELREPOSITORY)));
                }
                copyLC.setFileDigestDigester(this.digestCalculatorDAO.get(calc.getClass().getName()));
            }
            catch (DigestCalculatorException e) {
                throw new ActionException("Digesting of the uploaded label failed", e);
            }
            catch (FileHandleException e) {
                throw new ActionException("Saving of the uploaded label failed", e);
            }
            labelCopy.getLabelContents().put(copyLC.getId(), copyLC);
            copyLC = this.labelDAO.saveLabelContent(copyLC);
            Map originalDTs = lc.getDocumentTypes();
            HashMap copyDTs = new HashMap();
            for (Object k : originalDTs.keySet()) {
                copyDTs.put(k, originalDTs.get(k));
            }
            copyLC.setDocumentTypes(copyDTs);
            ArrayList textfields = new ArrayList(lc.getTextFields().values());
            for (TextField t : textfields) {
                TextField copyTextfield;
                if (t instanceof DocumentVersionTextField) {
                    copyTextfield = new DocumentVersionTextField();
                    ((DocumentVersionTextField)copyTextfield).setContent(((DocumentVersionTextField)t).getContent());
                } else if (t instanceof SignatureTextField) {
                    copyTextfield = new SignatureTextField();
                    ((SignatureTextField)copyTextfield).setReviewCycleNode(((SignatureTextField)t).getReviewCycleNode());
                } else if (t instanceof FreeTextLabelTextField) {
                    copyTextfield = new FreeTextLabelTextField();
                    ((FreeTextLabelTextField)copyTextfield).setContent(((FreeTextLabelTextField)t).getContent());
                } else {
                    copyTextfield = new TemporaryCustomTextField();
                    ((TemporaryCustomTextField)copyTextfield).setName(((TemporaryCustomTextField)t).getName());
                }
                copyTextfield.setAlignment(t.getAlignment());
                copyTextfield.setFont(t.getFont());
                copyTextfield.setFontPtSize(t.getFontPtSize());
                copyTextfield.setFontStyle(t.getFontStyle());
                copyTextfield.setLlx(t.getLlx());
                copyTextfield.setLly(t.getLly());
                copyTextfield.setUrx(t.getUrx());
                copyTextfield.setUry(t.getUry());
                copyTextfield.setLabelContent(copyLC);
                copyTextfield = this.labelDAO.saveTextField(copyTextfield);
                this.labelDAO.updateLabelContent(copyLC);
                copyLC.getTextFields().put(copyTextfield.getId(), copyTextfield);
            }
        }
        return this.labelDAO.updateLabel(labelCopy);
    }

    @Override
    public void deleteDocumentTypeFromLabelContent(Integer documentTypeId, Integer labelContentId) {
        LabelContent labelContent = this.labelDAO.getLabelContent(labelContentId);
        labelContent.getDocumentTypes().remove(documentTypeId);
        this.updateLabelContent(labelContent);
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    @Override
    public void updateAsBuiltUnchangedDestinationLabelContent(Integer labelContentId, boolean activate) {
        LabelContent labelContent = this.getLabelContent(labelContentId);
        labelContent.setAsBuiltUnchangedDestination(activate);
        this.labelDAO.mergeLabelContent(labelContent);
        if (activate) {
            Collection lcs = labelContent.getLabel().getLabelContents().values();
            for (LabelContent lc : lcs) {
                if (lc.getId().equals(labelContent.getId()) || !lc.isAsBuiltUnchangedDestination()) continue;
                lc.setAsBuiltUnchangedDestination(false);
                this.labelDAO.mergeLabelContent(lc);
            }
        }
    }

    @Override
    public void updateLabelContentRenderableOutside(Integer labelContentId, boolean activate) {
        LabelContent labelContent = this.getLabelContent(labelContentId);
        labelContent.setRenderableOutside(activate);
        this.labelDAO.mergeLabelContent(labelContent);
        if (activate) {
            Collection lcs = labelContent.getLabel().getLabelContents().values();
            for (LabelContent lc : lcs) {
                if (lc.getId().equals(labelContent.getId())) continue;
                lc.setRenderableOutside(false);
                this.labelDAO.mergeLabelContent(lc);
            }
        }
    }

    @Override
    public LabelContent getLabelOutsideContent(Integer documentId, boolean checkAlsoGlobal) {
        DocumentImpl document = this.documentDAO.get(documentId);
        Network network = document.getDocumentList().getSubProject().getProject().getNetwork();
        ObjectPlanner op = document.getObjectPlanner();
        ReleasedObjectList releasedObjectList = document.getObjectPlanner().getObject().getObjectList().getSubProject().getActiveObjectList();
        ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(releasedObjectList.getId(), op.getId());
        LabelContent outsideLabelContent = null;
        if (rop.getReviewCycleInstance().getLabel() != null) {
            ArrayList labelContents = new ArrayList(rop.getReviewCycleInstance().getLabel().getLabelContents().values());
            for (LabelContent labelContent : labelContents) {
                if (!labelContent.isRenderableOutside()) continue;
                outsideLabelContent = labelContent;
                break;
            }
        }
        if (outsideLabelContent == null && checkAlsoGlobal) {
            List allLabels = this.getLabelsOfOrganisation(network.getMaintainer().getId(), null);
            for (Label labelGlobal : allLabels) {
                if (labelGlobal.getReviewCycle() == null && labelGlobal.isActive()) {
                    ArrayList labelContents = new ArrayList(labelGlobal.getLabelContents().values());
                    for (LabelContent labelContent : labelContents) {
                        if (!labelContent.isRenderableOutside()) continue;
                        outsideLabelContent = labelContent;
                        break;
                    }
                }
                if (outsideLabelContent == null) continue;
                break;
            }
        }
        return outsideLabelContent;
    }
}

