/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.network.NetworkPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.role.RoleMap;
import at.cdes.service.NetworkOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.SessionOperations;
import java.util.Iterator;
import java.util.List;

public class SessionOperationsImpl
implements SessionOperations {
    private NetworkOperations networkOperations;
    private ProjectOperations projectOperations;

    @Override
    public RoleMap createRoleMap(Person user) {
        RoleMap roleMap = new RoleMap();
        roleMap.add(user.getRole().getId(), null, null, null, null);
        List networks = this.networkOperations.getNetworksByPersonId(user.getId());
        for (int i = 0; i < networks.size(); ++i) {
            Network network = (Network)networks.get(i);
            Iterator roleIt = network.getNetworkRoles().values().iterator();
            for (NetworkPerson networkPerson : network.getNetworkPersons().values()) {
                if (!user.getOrganisationPersons().containsKey(networkPerson.getOrganisationPerson().getId())) continue;
                roleMap.add(networkPerson.getRole().getId(), network.getId(), null, null, networkPerson.getOrganisationPerson().getId());
            }
            while (roleIt.hasNext()) {
                Role role = (Role)roleIt.next();
                if (!role.isContextDefaultRole()) continue;
                roleMap.add(role.getId(), network.getId(), null, null, null);
            }
        }
        List participants = this.projectOperations.getProjectParticipants(user);
        for (int i = 0; i < participants.size(); ++i) {
            ProjectParticipant participant = (ProjectParticipant)participants.get(i);
            roleMap.add(participant.getParticipation().getRole().getId(), participant.getParticipation().getProject().getNetwork().getId(), participant.getParticipation().getProject().getId(), participant.getParticipation().getId(), participant.getOrganisationPerson().getId());
        }
        return roleMap;
    }

    public void setNetworkOperations(NetworkOperations networkOperations) {
        this.networkOperations = networkOperations;
    }

    public void setProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }
}

