/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.servlet;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class OfflineHttpSession
implements HttpSession {
    private final ServletContext servletContext;
    private final String id;
    private final long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private Hashtable<String, Object> attributes;

    public OfflineHttpSession(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.id = UUID.randomUUID().toString();
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.maxInactiveInterval = -1;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keys();
    }

    public String[] getValueNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keySet().toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, value);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(name);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return false;
    }
}

