/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.document.NumberCalculatorException;
import at.cdes.api.dto.StatutoryDuty;
import at.cdes.api.service.GwtDelegateService;
import at.cdes.bo.cycle.EvaluationException;
import at.cdes.bo.cycle.ReviewCycleCellConnectionEvaluator;
import at.cdes.bo.cycle.listener.ReviewCycleNodeActionListenerRegistry;
import at.cdes.bo.data.HashedObject;
import at.cdes.bo.data.MatrixEditItem;
import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.cycle.AttachedReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.OEBBComment;
import at.cdes.bo.data.cycle.Realm;
import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.cycle.ReviewCycleCommentOption;
import at.cdes.bo.data.cycle.ReviewCycleEntryResult;
import at.cdes.bo.data.cycle.ReviewCycleEntryResultImpl;
import at.cdes.bo.data.cycle.ReviewCycleEntryStatementResult;
import at.cdes.bo.data.cycle.ReviewCycleEntryStatementResultImpl;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionRelease;
import at.cdes.bo.data.cycle.ReviewCyclePositionReleaseImpl;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.ReviewCyclePositionResultDateComparator;
import at.cdes.bo.data.cycle.ReviewCyclePositionResultImpl;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.ReviewCycleStatementResult;
import at.cdes.bo.data.cycle.TemporaryReviewCyclePositionResult;
import at.cdes.bo.data.cycle.TemporaryReviewCyclePositionResultCommentGroup;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnection;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionResultImpl;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionStatementResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionStatementResultImpl;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceRelease;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResultImpl;
import at.cdes.bo.data.cycle.cell.ReviewCycleEntryCondition;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResultImpl;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeInstanceListener;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeListener;
import at.cdes.bo.data.document.AsBuiltDocumentTO;
import at.cdes.bo.data.document.BaseDocumentVersion;
import at.cdes.bo.data.document.CompactReviewStatus;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentBase;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentList;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.DocumentVersionComparator;
import at.cdes.bo.data.document.DocumentVersionStatusChange;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.Label;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.data.mail.NodeListenerEMailSnippet;
import at.cdes.bo.data.mail.StatusEMailSnippet;
import at.cdes.bo.data.meta.MetaInformation;
import at.cdes.bo.data.meta.MetaTag;
import at.cdes.bo.data.meta.PlanningNotificationDateMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationTextMetaInformation;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.network.NetworkNameComparator;
import at.cdes.bo.data.object.AsBuiltObjectTO;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectList;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.planningNotification.PlanningNotification;
import at.cdes.bo.data.planningNotification.PlanningNotificationAttachment;
import at.cdes.bo.data.planningNotification.PlanningNotificationOrder;
import at.cdes.bo.data.planningNotification.PlanningNotificationTemplate;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipantDateHistoryPart;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.review.ReviewCyclePositionEntry;
import at.cdes.bo.data.review.ReviewCycleStatusListEntry;
import at.cdes.bo.data.review.ReviewCycleStatusTO;
import at.cdes.bo.data.search.ReferenceDocumentVersionSearch;
import at.cdes.bo.data.search.ReviewCycleStatusSearch;
import at.cdes.bo.data.sec.CDESSignature;
import at.cdes.bo.data.sec.DigestCalculatorType;
import at.cdes.bo.data.task.AttachedReviewTask;
import at.cdes.bo.data.task.AttachedReviewTaskDone;
import at.cdes.bo.data.task.DocumentVersionTask;
import at.cdes.bo.data.task.DocumentVersionTaskBase;
import at.cdes.bo.data.task.ReviewCycleEntryTask;
import at.cdes.bo.data.task.ReviewCycleEntryTaskDone;
import at.cdes.bo.data.task.ReviewCycleTask;
import at.cdes.bo.data.task.ReviewTask;
import at.cdes.bo.data.task.ReviewTaskDone;
import at.cdes.bo.data.task.ReviewableTask;
import at.cdes.bo.data.task.SelectCellConnectionTask;
import at.cdes.bo.data.task.SelectCellConnectionTaskDone;
import at.cdes.bo.data.task.Task;
import at.cdes.bo.data.task.TaskBase;
import at.cdes.bo.data.workflow.Workflow;
import at.cdes.bo.data.workflow.WorkflowAction;
import at.cdes.bo.data.workflow.WorkflowActionEntityStatusChange;
import at.cdes.bo.data.workflow.WorkflowActionListener;
import at.cdes.bo.data.workflow.WorkflowActionNodeEmailNotification;
import at.cdes.bo.data.workflow.WorkflowActionPrecondition;
import at.cdes.bo.data.workflow.WorkflowActionTokenDeletion;
import at.cdes.bo.data.workflow.WorkflowActionTokenEmailNotification;
import at.cdes.bo.data.workflow.WorkflowActionTokenTransition;
import at.cdes.bo.data.workflow.WorkflowActivity;
import at.cdes.bo.data.workflow.WorkflowActivityHistoryEntry;
import at.cdes.bo.data.workflow.WorkflowActivityNotificationSnippet;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.data.workflow.WorkflowEntity;
import at.cdes.bo.data.workflow.WorkflowEntityStatus;
import at.cdes.bo.data.workflow.WorkflowNode;
import at.cdes.bo.data.workflow.WorkflowNodePosition;
import at.cdes.bo.data.workflow.WorkflowNodePositionResultOption;
import at.cdes.bo.data.workflow.WorkflowNodeTemplate;
import at.cdes.bo.data.workflow.WorkflowTemplate;
import at.cdes.bo.data.workflow.WorkflowToken;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.bo.document.DocumentTranslator;
import at.cdes.bo.file.FileFinder;
import at.cdes.bo.file.UploadFileHandler;
import at.cdes.bo.search.ReviewCycleStatusSearchInterpreter;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestCalculatorFactory;
import at.cdes.bo.sec.signature.SignatureCalculator;
import at.cdes.bo.sec.signature.SignatureCalculatorException;
import at.cdes.bo.sec.signature.SignatureCalculatorFactory;
import at.cdes.bo.service.ReviewCycleNodeActionListener;
import at.cdes.bo.service.ReviewCycleNodeActionListenerProperty;
import at.cdes.controller.apiHelper.ReviewCycleInterpretationHelper;
import at.cdes.controller.apiHelper.SubProjectCopyContainer;
import at.cdes.controller.helper.CdesDTOHelper;
import at.cdes.controller.helper.CompactReviewStatusResultList;
import at.cdes.controller.helper.DataSourceHelper;
import at.cdes.controller.helper.ResultListImpl;
import at.cdes.controller.number.OgnlNumberCalculator;
import at.cdes.db.dao.AttachmentDAO;
import at.cdes.db.dao.DigestCalculatorDAO;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.db.dao.DocumentListDAO;
import at.cdes.db.dao.DocumentRefDAO;
import at.cdes.db.dao.DocumentVersionDAO;
import at.cdes.db.dao.EMailDAO;
import at.cdes.db.dao.LabelDAO;
import at.cdes.db.dao.MetaInformationDAO;
import at.cdes.db.dao.MetaTagDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.ObjectDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.PlanningNotificationDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ProjectParticipantDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.RealmDAO;
import at.cdes.db.dao.ReviewCycleCellConnectionDAO;
import at.cdes.db.dao.ReviewCycleCellConnectionResultDAO;
import at.cdes.db.dao.ReviewCycleCellInstanceDAO;
import at.cdes.db.dao.ReviewCycleCellResultDAO;
import at.cdes.db.dao.ReviewCycleCommentOptionDAO;
import at.cdes.db.dao.ReviewCycleEntryResultDAO;
import at.cdes.db.dao.ReviewCycleInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeListenerDAO;
import at.cdes.db.dao.ReviewCycleNodeResultDAO;
import at.cdes.db.dao.ReviewCyclePositionDAO;
import at.cdes.db.dao.ReviewCyclePositionResultDAO;
import at.cdes.db.dao.ReviewCycleResultOptionDAO;
import at.cdes.db.dao.SignatureDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.db.dao.WorkflowActivityDAO;
import at.cdes.db.dao.WorkflowActivityNotificationSnippetDAO;
import at.cdes.db.dao.WorkflowDAO;
import at.cdes.db.dao.WorkflowEntityDAO;
import at.cdes.db.dao.WorkflowEntityStatusDAO;
import at.cdes.db.dao.WorkflowNodeDAO;
import at.cdes.db.dao.WorkflowNodePositionDAO;
import at.cdes.db.dao.WorkflowNodePositionResultOptionDAO;
import at.cdes.db.dao.WorkflowNodeTemplateDAO;
import at.cdes.db.dao.WorkflowTemplateDAO;
import at.cdes.db.dao.WorkflowTokenDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.msp.SharepointFileClient;
import at.cdes.oldGwtDto.BBoxWithPage;
import at.cdes.oldGwtDto.CDESContext;
import at.cdes.oldGwtDto.DocumentVersionDTO;
import at.cdes.oldGwtDto.FileUploadException;
import at.cdes.oldGwtDto.MetaTagDTO;
import at.cdes.oldGwtDto.MissingPropertyException;
import at.cdes.oldGwtDto.MissingSignatureRightsException;
import at.cdes.oldGwtDto.MissingSignerCertificateException;
import at.cdes.oldGwtDto.NetworkDTO;
import at.cdes.oldGwtDto.OrderFilterDTO;
import at.cdes.oldGwtDto.PNFilterDTO;
import at.cdes.oldGwtDto.PlanningNotificationDTO;
import at.cdes.oldGwtDto.PlanningNotificationDateMetaInformationDTO;
import at.cdes.oldGwtDto.PlanningNotificationMetaInformationDTO;
import at.cdes.oldGwtDto.PlanningNotificationOrderDTO;
import at.cdes.oldGwtDto.PlanningNotificationTaskDTO;
import at.cdes.oldGwtDto.PlanningNotificationTemplateDTO;
import at.cdes.oldGwtDto.PlanningNotificationTextMetaInformationDTO;
import at.cdes.oldGwtDto.ProjectDTO;
import at.cdes.oldGwtDto.ProjectParticipantDTO;
import at.cdes.oldGwtDto.ProjectParticipationDTO;
import at.cdes.oldGwtDto.ReviewContextDTO;
import at.cdes.oldGwtDto.ReviewCycleCommentResultNodeDTO;
import at.cdes.oldGwtDto.ReviewCycleNodeInstanceDTO;
import at.cdes.oldGwtDto.ReviewCycleNodePositionDTO;
import at.cdes.oldGwtDto.ReviewCycleNodeResultDTO;
import at.cdes.oldGwtDto.ReviewCyclePositionResultDTO;
import at.cdes.oldGwtDto.ReviewCycleResultOptionDTO;
import at.cdes.oldGwtDto.ReviewHistoryDTO;
import at.cdes.oldGwtDto.Triple;
import at.cdes.oldGwtDto.UploadResultDTO;
import at.cdes.oldGwtDto.VersionStatementDTO;
import at.cdes.oldGwtDto.WorkflowActivityDTO;
import at.cdes.oldGwtDto.WorkflowActivityHistoryEntryDTO;
import at.cdes.oldGwtDto.WorkflowActivityPositionResultDTO;
import at.cdes.oldGwtDto.WorkflowDTO;
import at.cdes.oldGwtDto.WorkflowException;
import at.cdes.oldGwtDto.WorkflowNodeDTO;
import at.cdes.oldGwtDto.WorkflowNodePositionDTO;
import at.cdes.oldGwtDto.WorkflowNodePositionResultOptionDTO;
import at.cdes.oldGwtDto.WorkflowNodeTemplateDTO;
import at.cdes.oldGwtDto.WorkflowReviewContainerDTO;
import at.cdes.oldGwtDto.WorkflowTemplateDTO;
import at.cdes.preview.api.BoundingBoxWithAngle;
import at.cdes.preview.api.DRMError;
import at.cdes.preview.api.HPGSError;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.api.Timeout;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.AttachmentOperations;
import at.cdes.service.CertificateOperations;
import at.cdes.service.MailOperations;
import at.cdes.service.ObjectOperations;
import at.cdes.service.OrderOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.DefaultException;
import at.cdes.service.exception.FileHandleException;
import at.cdes.service.exception.FrontendException;
import at.cdes.service.exception.MimeDRMError;
import at.cdes.service.exception.MimeHPGSError;
import at.cdes.service.exception.MimeSeekIOError;
import at.cdes.service.exception.MimeSeekTimeout;
import at.cdes.service.exception.ReviewException;
import at.cdes.service.exception.WrongPasswordException;
import at.cdes.util.DateHelper;
import at.cdes.util.ResultList;
import at.cdes.util.TapestryI18nHelper;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.util.PDFTextStripperByArea;
import org.clazzes.util.comparators.InvalidExpressionSyntaxException;
import org.clazzes.util.comparators.POJOComparatorFactory;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.clazzes.util.io.IOUtil;
import org.clazzes.util.lang.Pair;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.xnap.commons.i18n.I18n;

public class ReviewOperationsImpl
implements ReviewOperations {
    private DocumentRefDAO documentRefDAO;
    private DocumentDAO documentDAO;
    private DocumentVersionDAO documentVersionDAO;
    private UploadFileHandler uploadFileHandler;
    private ReviewCycleEntryResultDAO reviewCycleEntryResultDAO;
    private DigestCalculatorFactory digestCalculatorFactory;
    private SignatureCalculatorFactory signatureCalculatorFactory;
    private FileFinder fileFinder;
    private OgnlNumberCalculator ognlNumberCalculator;
    private DigestCalculatorDAO digestCalculatorDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectDAO projectDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private SignatureDAO signatureDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ReviewCyclePositionDAO reviewCyclePositionDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private RealmDAO realmDAO;
    private ReviewCyclePositionResultDAO reviewCyclePositionResultDAO;
    private ReviewCycleCellResultDAO reviewCycleCellResultDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewCycleCellConnectionResultDAO reviewCycleCellConnectionResultDAO;
    private ReviewCycleCellConnectionDAO reviewCycleCellConnectionDAO;
    private ReviewCycleCellConnectionEvaluator reviewCycleCellConnectionEvaluator;
    private ReviewCycleCellInstanceDAO reviewCycleCellInstanceDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ReviewCycleInstanceDAO reviewCycleInstanceDAO;
    private ObjectDAO objectDAO;
    private EMailDAO mailDAO;
    private TaskOperations taskOperations;
    private AttachmentOperations attachmentOperations;
    private ObjectOperations objectOperations;
    private ReviewCycleCommentOptionDAO reviewCycleCommentOptionDAO;
    private ReviewCycleNodeActionListenerRegistry listenerRegistry;
    private ReviewCycleNodeListenerDAO reviewCycleNodeListenerDAO;
    private ReviewCycleStatusSearchInterpreter reviewCycleStatusSearchInterpreter;
    private IHPGLRenderer hpglRenderer;
    private ReviewCycleInterpretationHelper reviewCycleInterpretationHelper;
    private SubProjectDAO subProjectDAO;
    private DocumentListDAO documentListDAO;
    private AttachmentDAO attachmentDAO;
    private HolidayCalculatorFactory holidayCalculatorFactory;
    private String hibernateDialect;
    private CertificateOperations certificateOperations;
    private PlanningNotificationDAO planningNotificationDAO;
    private WorkflowEntityDAO workflowEntityDAO;
    private MetaInformationDAO metaInformationDAO;
    private MetaTagDAO metaTagDAO;
    private WorkflowDAO workflowDAO;
    private WorkflowNodeDAO workflowNodeDAO;
    private WorkflowNodePositionDAO workflowNodePositionDAO;
    private NetworkDAO networkDAO;
    private LabelDAO labelDAO;
    private WorkflowTemplateDAO workflowTemplateDAO;
    private WorkflowTokenDAO workflowTokenDAO;
    private WorkflowActivityDAO workflowActivityDAO;
    private WorkflowNodePositionResultOptionDAO workflowNodePositionResultOptionDAO;
    private WorkflowEntityStatusDAO workflowEntityStatusDAO;
    private WorkflowActivityNotificationSnippetDAO workflowActivityNotificationSnippetDAO;
    private WorkflowNodeTemplateDAO workflowNodeTemplateDAO;
    private OrderOperations orderOperations;
    private MailOperations mailOperations;
    private GwtDelegateService gwtDelegateService;
    private static final Logger log = Logger.getLogger(ReviewOperationsImpl.class);

    public void setDigestCalculatorFactory(DigestCalculatorFactory digestCalculatorFactory) {
        this.digestCalculatorFactory = digestCalculatorFactory;
    }

    public void setReviewCycleStatusSearchInterpreter(ReviewCycleStatusSearchInterpreter reviewCycleStatusSearchInterpreter) {
        this.reviewCycleStatusSearchInterpreter = reviewCycleStatusSearchInterpreter;
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }

    public void setOrderOperations(OrderOperations orderOperations) {
        this.orderOperations = orderOperations;
    }

    public void setWorkflowNodeTemplateDAO(WorkflowNodeTemplateDAO workflowNodeTemplateDAO) {
        this.workflowNodeTemplateDAO = workflowNodeTemplateDAO;
    }

    public void setGwtDelegateService(GwtDelegateService gwtDelegateService) {
        this.gwtDelegateService = gwtDelegateService;
    }

    @Override
    public String uploadTmp(Document document, String fileExtension, IMimeInputStream fis) {
        document = this.documentDAO.get(document.getId());
        try {
            log.info((Object)("uploadTmp: uploading document '" + document.getName() + "' streamsize=[" + fis.getStreamSize() + "]"));
            DataSource ds = DataSourceHelper.toDataSource(fis);
            log.info((Object)("uploadTmp: finished upload of document '" + document.getName() + "'"));
            String string = this.uploadFileHandler.saveUploaded(document, ds.getInputStream(), fileExtension).getAbsolutePath();
            return string;
        }
        catch (FileHandleException e) {
            throw new ActionException("upload tmp", e);
        }
        catch (IOException e) {
            throw new ActionException("IOException upload tmp ", e);
        }
        catch (IOError e) {
            throw new ActionException("IOError upload tmp ", e);
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable e) {
                throw new ActionException("IOError upload tmp ", e);
            }
        }
    }

    @Override
    public String replaceTmp(Document document, String fileExtension, IMimeInputStream fis, String oldFileName) {
        document = this.documentDAO.get(document.getId());
        try {
            DataSource ds = DataSourceHelper.toDataSource(fis);
            String string = this.uploadFileHandler.replaceUploaded(document, ds.getInputStream(), fileExtension, oldFileName);
            return string;
        }
        catch (FileHandleException e) {
            throw new ActionException("Replace uploaded ", e);
        }
        catch (IOError e) {
            throw new ActionException("IOError Replace uploaded ", e);
        }
        catch (IOException e) {
            throw new ActionException("IOException Replace uploaded ", e);
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable e) {
                log.warn((Object)"IOError Replace uploaded - close IMimeInputStream ", e);
            }
        }
    }

    private void createObjectPlannerDefinitionEMailSnippets(DocumentVersion dv, ObjectPlanner objectPlanner, Calendar now) {
        if (dv.getStatus() != 7 && dv.getStatus() != 5 && dv.getStatus() != 4 && dv.getStatus() != 3 && dv.getStatus() != 2) {
            return;
        }
        Map positions = objectPlanner.getPositions();
        if (positions == null) {
            return;
        }
        boolean isRevision = false;
        if (dv.getStatus() == 4 && dv.getLastDocumentVersionRevision() != null && dv.getLastDocumentVersionRevision().getStatus() == 2) {
            isRevision = true;
        }
        int mask = 1;
        if (dv.getStatus() == 3) {
            mask = 2;
        } else if (dv.getStatus() == 4 && !isRevision) {
            mask = 4;
        } else if (dv.getStatus() == 5) {
            mask = 8;
        } else if (dv.getStatus() == 7) {
            mask = 16;
        } else if (isRevision) {
            mask = 32;
        }
        block7: for (ObjectPlannerPosition position : positions.values()) {
            int snippet_type;
            ProjectParticipation pp;
            int check = position.getObjectPlannerPositionDefinition().getStatusNotification() & mask;
            if (log.isDebugEnabled()) {
                log.debug((Object)("checking for notification: ObjectPlannerPositionDefinition#" + position.getObjectPlannerPositionDefinition().getId() + ", mask=" + mask + ", check=" + check + "."));
            }
            if (check == 0 || (pp = position.getProjectParticipation()).getAllParticipants() == null || pp.isInvalidated()) continue;
            switch (dv.getStatus()) {
                case 7: {
                    snippet_type = 6;
                    break;
                }
                case 4: {
                    snippet_type = 4;
                    break;
                }
                case 5: {
                    snippet_type = 5;
                    break;
                }
                case 2: {
                    snippet_type = 1;
                    break;
                }
                case 3: {
                    snippet_type = 7;
                    break;
                }
                default: {
                    continue block7;
                }
            }
            if (snippet_type == 4 && isRevision) {
                snippet_type = 8;
            }
            for (ProjectParticipant p : pp.getProjectParticipants().values()) {
                if (p.getOrganisationPerson().isInActive()) continue;
                StatusEMailSnippet snippet = new StatusEMailSnippet();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("creating status snippet: OrganisationPerson#" + p.getOrganisationPerson().getId() + ", snippet_type=" + snippet_type + "."));
                }
                snippet.setDocumentVersion(dv);
                snippet.setOrganisationPersonId(p.getOrganisationPerson().getId());
                snippet.setSendTime(now);
                snippet.setType(snippet_type);
                this.mailDAO.insertSnippet(snippet);
            }
            this.mailOperations.createAttachmentMailForProjectParticipation(dv, pp);
        }
    }

    public Pair<DocumentVersion, ReviewCycleNodeInstanceRelease> insertDocumentVersion(TemporaryDocumentVersion tdv, ReviewCycleCell cell, Integer status) {
        DocumentVersion version = new DocumentVersion();
        DocumentImpl document = this.documentDAO.get(tdv.getDocumentId());
        version.setDocument(document);
        GregorianCalendar now = new GregorianCalendar();
        version.setUploaded(now.getTime());
        version.setIssued(now.getTime());
        version.setName(tdv.getName());
        if (status == null) {
            version.setStatus(1);
        } else {
            version.setStatus(status);
        }
        version.setVersionPartA(tdv.getVersionPartA());
        version.setVersionPartB(tdv.getVersionPartB());
        version.setVersionPartSeperator(cell.getReviewCycle().getDocumentNumberVersionPart().getSeperator());
        version.setFileName(tdv.getFileName());
        version.setFileType(tdv.getFileType());
        version.setAlternativeName(tdv.getAlternativeName() != null ? tdv.getAlternativeName() : "");
        version.setPreviewRotation(tdv.getPreviewRotation());
        if (!tdv.isLabelIgnored()) {
            version.setLabelCorrelation(tdv.getLabelCorrelation());
            version.setLabelOverlap(tdv.getLabelOverlap());
            version.setLabelSeparation(tdv.getLabelSeparation());
            version.setLabelXOffset(tdv.getLabelXOffset());
            version.setLabelYOffset(tdv.getLabelYOffset());
            version.setLabelContentId(tdv.getLabelContentId());
        }
        version.setLlx(tdv.getLlx());
        version.setLly(tdv.getLly());
        version.setUrx(tdv.getUrx());
        version.setUry(tdv.getUry());
        version.setUserUnit(tdv.getUserUnit());
        version.setNativeRotation(tdv.getNativeRotation());
        version.setNumberOfPages(tdv.getNumberOfPages());
        ReviewCycleNode node = cell.getFirstReviewCycleNode();
        ReleasedObjectList activeObjectList = document.getDocumentList().getSubProject().getActiveObjectList();
        ObjectPlannerImpl impl = (ObjectPlannerImpl)document.getObjectPlanner();
        ReleasedObjectPlanner op = this.objectPlannerDAO.getReleasedObjectPlanner(activeObjectList.getId(), impl.getId());
        ReviewCycleNodeInstanceRelease actualNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(op.getReviewCycleInstance().getId(), node.getId());
        version.setActualReviewCycleNodeInstance(actualNodeInstance.getReviewCycleNodeInstance());
        document.setVersionSet(true);
        this.documentVersionDAO.save(version);
        this.documentDAO.update(document);
        try {
            log.info((Object)("copying uploaded file from temp. rep. deleting the old file with filename=[" + tdv.getFileName() + "] for docVersion=[" + tdv.getName() + "]"));
            version.setFileName(this.uploadFileHandler.copyUploadedDocumentVersion(document, tdv.getFileName()));
        }
        catch (FileHandleException e) {
            throw new ActionException("Insert document Version ", e);
        }
        version.setFileType(IOUtil.getFileExtension((String)version.getFileName()));
        document.setVersionSet(true);
        DocumentVersionStatusChange change = new DocumentVersionStatusChange();
        change.setChangeDate(now);
        change.setDocumentVersionId(version.getId());
        change.setFileName(version.getFileName());
        change.setName(version.getName());
        change.setNewStatus(version.getStatus());
        this.documentVersionDAO.saveStatusChange(change);
        this.createObjectPlannerDefinitionEMailSnippets(version, op, now);
        return new Pair((Object)version, (Object)actualNodeInstance);
    }

    @Override
    public DocumentVersion getDocumentVersion(Integer id) {
        return this.documentVersionDAO.get(id);
    }

    @Override
    public void saveDocumentVersion(DocumentVersion documentVersion) {
        this.documentVersionDAO.save(documentVersion);
    }

    @Override
    public DocumentVersion updateDocumentVersionBoundingBox(DocumentVersion dv) throws MimeSeekIOError, MimeHPGSError, MimeDRMError, MimeSeekTimeout {
        if (dv.getLlx() != null && dv.getLly() != null && dv.getUrx() != null && dv.getUry() != null) {
            return dv;
        }
        FileMimeInputStream stream = null;
        try {
            File file = this.fileFinder.findFile(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique = this.fileFinder.makeUniqueName(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            stream = new FileMimeInputStream(file, unique, dv.getName() + "." + dv.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv.getFileName()));
            BoundingBoxWithAngle bbox = this.hpglRenderer.getBoundingBox((IMimeInputStream)stream);
            dv.setLlx(bbox.getLlx());
            dv.setLly(bbox.getLly());
            dv.setUrx(bbox.getUrx());
            dv.setUry(bbox.getUry());
            dv.setUserUnit(bbox.getUserUnit());
            dv.setNativeRotation(bbox.getAngle());
        }
        catch (Timeout e) {
            log.error((Object)("Timeout fetching bounding box of document version [" + dv.getId() + "]"), (Throwable)e);
            throw new MimeSeekTimeout("Timeout fetching bounding box of document version [" + dv.getId() + "]", e);
        }
        catch (HPGSError e) {
            log.error((Object)("HPGSError fetching bounding box of document version [" + dv.getId() + "]"), (Throwable)e);
            throw new MimeHPGSError("HPGSError fetching bounding box of document version [" + dv.getId() + "]", e);
        }
        catch (DRMError e) {
            log.error((Object)("DRMError fetching bounding box of document version [" + dv.getId() + "]"), (Throwable)e);
            throw new MimeDRMError("DRMError fetching bounding box of document version [" + dv.getId() + "]", e);
        }
        catch (PreviewException e) {
            log.error((Object)("IOError fetching bounding box of document version [" + dv.getId() + "]"), (Throwable)e);
            throw new MimeSeekIOError("IOError fetching bounding box of document version [" + dv.getId() + "]", e);
        }
        catch (FileHandleException e) {
            log.error((Object)"FileHandleException seeking label: ", (Throwable)e);
            throw new MimeSeekIOError("FileHandleException seeking label", e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Unexpected IOError when closing MimeStream", e);
            }
        }
        return this.documentVersionDAO.update(dv);
    }

    @Override
    public ReviewCycleCellConnection getReviewCycleCellConnection(Integer id) {
        return this.reviewCycleCellConnectionDAO.get(id);
    }

    @Override
    public boolean evaluateConnection(DocumentVersion version, ReviewCycleCellConnection connection) {
        ReviewCycleCellResult res = this.reviewCycleCellResultDAO.get(version.getActualReviewCycleNode().getReviewCycleCell().getId(), version.getId());
        return this.evaluateConnection2(res, connection);
    }

    @Override
    public boolean evaluateConnection2ForDojoImpl(DocumentVersion documentVersion, ReviewCycleResultOption resultOption, ReviewCycleCellConnection connection) {
        ReviewCycleCellResultImpl cellResult = new ReviewCycleCellResultImpl();
        cellResult.setDocumentVersion(documentVersion);
        cellResult.setReviewCycleResultOption(resultOption);
        return this.evaluateConnection2(cellResult, connection);
    }

    @Override
    public boolean evaluateConnection2(ReviewCycleCellResult cellResult, ReviewCycleCellConnection connection) {
        try {
            ReleasedObjectList activeObjectList = cellResult.getDocumentVersion().getDocument().getDocumentList().getSubProject().getActiveObjectList();
            ReleasedObjectPlanner objectPlannerRelease = this.objectPlannerDAO.getReleasedObjectPlanner(activeObjectList.getId(), cellResult.getDocumentVersion().getDocument().getObjectPlanner().getId());
            ReviewCycleInstanceRelease cycleInstanceRel = (ReviewCycleInstanceRelease)objectPlannerRelease.getReviewCycleInstance();
            ReviewCycleCellInstanceRelease destinationCellInstRel = this.getReleasedReviewCycleCellInstance(connection.getDestinationCell().getId(), cycleInstanceRel.getId());
            if (destinationCellInstRel != null) {
                return this.reviewCycleCellConnectionEvaluator.evaluateConnection(cellResult, connection);
            }
            return false;
        }
        catch (EvaluationException e) {
            throw new ActionException("Evaluate Connection", e);
        }
    }

    @Override
    public boolean evaluateConnectionForInvalidationUpload(Integer cellResultId, Integer cellConnectionId) {
        ReviewCycleCellResult cellResult = this.reviewCycleCellResultDAO.get(cellResultId);
        ReviewCycleCellConnection connection = this.reviewCycleCellConnectionDAO.get(cellConnectionId);
        ReviewCycleCellResultImpl dummyResult = new ReviewCycleCellResultImpl();
        dummyResult.setDocumentArrivalDate(cellResult.getDocumentArrivalDate());
        dummyResult.setDocumentDepartureDate(cellResult.getDocumentDepartureDate());
        dummyResult.setDocumentVersion(cellResult.getDocumentVersion());
        dummyResult.setFinished(cellResult.isFinished());
        dummyResult.setNextReviewCycleCell(cellResult.getNextReviewCycleCell());
        dummyResult.setPreviousReviewCycleCell(cellResult.getPreviousReviewCycleCell());
        dummyResult.setReviewCycleCell(cellResult.getReviewCycleCell());
        dummyResult.setReviewCycleNodeResults(cellResult.getReviewCycleNodeResults());
        dummyResult.setReviewCycleResultOption(cellResult.getReviewCycleCell().getReviewCycle().getDocumentVersionInvalidationOption());
        return this.evaluateConnection2(dummyResult, connection);
    }

    @Override
    public boolean evaluateEntryCondition(ReviewCycleCell destinationCell) {
        try {
            if (destinationCell.getReviewCycleEntryCondition() != null && destinationCell.getReviewCycleEntryCondition().getRule() != null && destinationCell.getReviewCycleEntryCondition().getRule().length() > 0 && destinationCell.getReviewCycleEntryCondition().getPartARule() != null && destinationCell.getReviewCycleEntryCondition().getPartARule().length() > 0 && destinationCell.getReviewCycleEntryCondition().getPartBRule() != null && destinationCell.getReviewCycleEntryCondition().getPartBRule().length() > 0) {
                return this.reviewCycleCellConnectionEvaluator.evaluateEntryCondition(destinationCell.getReviewCycleEntryCondition());
            }
            return false;
        }
        catch (EvaluationException e) {
            throw new ActionException("Evaluate EntryCondition", e);
        }
    }

    @Override
    public boolean evaluateEntryCondition2(ReviewCycleInstanceRelease cycleInstanceRel, ReviewCycleCell destinationCell) {
        try {
            ReviewCycleCellInstanceRelease destinationCellInstRel = this.getReleasedReviewCycleCellInstance(destinationCell.getId(), cycleInstanceRel.getId());
            if (destinationCellInstRel != null) {
                if (destinationCell.getReviewCycleEntryCondition() != null && destinationCell.getReviewCycleEntryCondition().getRule() != null && destinationCell.getReviewCycleEntryCondition().getRule().length() > 0 && destinationCell.getReviewCycleEntryCondition().getPartARule() != null && destinationCell.getReviewCycleEntryCondition().getPartARule().length() > 0 && destinationCell.getReviewCycleEntryCondition().getPartBRule() != null && destinationCell.getReviewCycleEntryCondition().getPartBRule().length() > 0) {
                    return this.reviewCycleCellConnectionEvaluator.evaluateEntryCondition(destinationCell.getReviewCycleEntryCondition());
                }
                return false;
            }
            return false;
        }
        catch (EvaluationException e) {
            throw new ActionException("Evaluate EntryCondition", e);
        }
    }

    @Override
    public DocumentVersion signReviewCycleCellChange(List temporaryComments, ProjectParticipant signer, String password, ReviewCycleCellConnection connection, TemporaryDocumentVersion tempVersion, DocumentVersion oldDocumentVersion, SelectCellConnectionTask selectCellConnectionTask, CDESCertificate cert, List<ReviewCycleCellConnectionStatementResult> statements, Collection<MatrixEditItem> attachedReviewers, ReviewCycleNodeInstanceRelease nodeInstAttachedR) throws WrongPasswordException, FrontendException {
        CDESSignature sign;
        SignatureCalculator sig;
        DigestCalculator dig;
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        tempVersion = this.generateDocumentVersionNumber2(oldDocumentVersion, connection, tempVersion, locale);
        Pair<DocumentVersion, ReviewCycleNodeInstanceRelease> p = this.insertDocumentVersion(tempVersion, connection.getDestinationCell(), connection.getDocumentVersionStatus());
        DocumentVersion version = (DocumentVersion)p.getFirst();
        SubProject subProject = version.getDocument().getDocumentList().getSubProject();
        ReleasedObjectList objectList = subProject.getActiveObjectList();
        ReviewCycleNodeInstanceImpl versionNodeInstance = oldDocumentVersion.getActualReviewCycleNodeInstance();
        ReviewCycleInstanceRelease instanceReleased = this.reviewCycleInstanceDAO.getReleased(objectList.getId(), versionNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleNodeInstanceRelease versionNodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceReleased.getId(), versionNodeInstance.getReviewCycleNode().getId());
        if (objectList == null) {
            throw new ActionException("No active ObjectList was found in the SubProjekt with id " + subProject.getId());
        }
        if (attachedReviewers != null) {
            this.updateAttachedReviewCyclePositions(attachedReviewers, version, objectList, nodeInstAttachedR.getReviewCycleNodeInstance());
        }
        ReviewCycleCellResultImpl cellResult = (ReviewCycleCellResultImpl)this.reviewCycleCellResultDAO.get(oldDocumentVersion.getActualReviewCycleNode().getReviewCycleCell().getId(), oldDocumentVersion.getId());
        ReviewCycleNodeResultImpl oldNodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(oldDocumentVersion.getActualReviewCycleNode(), oldDocumentVersion);
        try {
            if (!this.reviewCycleCellConnectionEvaluator.evaluateConnection(cellResult, connection)) {
                throw new EvaluationException("The connection is not possible for the given DocumentVersion and CellResult");
            }
        }
        catch (EvaluationException e) {
            throw new ActionException("An evaluation error occured", e);
        }
        ReviewCycleCellConnectionResultImpl connectionResult = new ReviewCycleCellConnectionResultImpl();
        connectionResult.setDestinationDocumentVersion(version);
        connectionResult.setSourceReviewCycleCellResult(cellResult);
        connectionResult.setProjectParticipant(signer);
        connectionResult.setRule(connection.getRule());
        connectionResult.setComment(tempVersion.getComment());
        connectionResult.setSourceDocumentVersion(cellResult.getDocumentVersion());
        connectionResult.setResultDate(new Date());
        ReviewCycleCellResult newCellResult = this.generateNextCellResults(version, objectList, ((ReviewCycleNodeInstanceRelease)p.getSecond()).getReviewCycleCellInstance().getReviewCycleInstance());
        version = newCellResult.getDocumentVersion();
        connectionResult.setDestinationReviewCycleCellResult(newCellResult);
        connectionResult = (ReviewCycleCellConnectionResultImpl)this.reviewCycleCellConnectionResultDAO.save(connectionResult);
        if (statements != null) {
            for (ReviewCycleCellConnectionStatementResult result : statements) {
                result.setReviewCycleCellConnectionResult(connectionResult);
                result = this.reviewCycleCellConnectionResultDAO.save(result);
                if (connectionResult.getStatements() == null) {
                    connectionResult.setStatements(new HashMap());
                }
                connectionResult.getStatements().put(result.getId(), result);
            }
        }
        connectionResult = (ReviewCycleCellConnectionResultImpl)this.reviewCycleCellConnectionResultDAO.update(connectionResult);
        Network network = subProject.getProject().getNetwork();
        try {
            dig = this.digestCalculatorFactory.getDigestCalculator(network, connectionResult);
            DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
            connectionResult.setDigestCalculatorType(t);
            connectionResult.setDigest(dig.getDigest(connectionResult));
            sig = this.signatureCalculatorFactory.getSignatureCalculator(network, connectionResult);
            sign = sig.createSignature(signer, dig.getSignableContent(connectionResult), cert, password);
            sign = this.signatureDAO.save(sign);
            connectionResult.setSignature(sign);
            File file = this.fileFinder.findFile(version.getFileName(), CDESFileRepository.PLANREPOSITORY);
            DigestCalculator fileDig = this.digestCalculatorFactory.getDigestCalculator(network, file);
            version.setFileDigester(this.digestCalculatorDAO.get(fileDig.getClass().getName()));
            version.setFileDigest(fileDig.getDigest(file));
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("A digest error occured", e);
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("A signature error occured", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("A file error occured", e);
        }
        if (temporaryComments != null && !temporaryComments.isEmpty()) {
            try {
                DigestCalculator commentDig = this.digestCalculatorFactory.getDigestCalculator(network, ReviewCyclePositionResult.class);
                this.insertAndDigestPositionComments(temporaryComments, subProject.getActiveObjectList(), subProject.getActiveDocumentList(), oldDocumentVersion, signer, oldNodeResult, commentDig);
                sig = this.signatureCalculatorFactory.getSignatureCalculator(network, connectionResult);
                sign = sig.createSignature(signer, dig.getSignableContent(connectionResult), cert, password);
                sign = this.signatureDAO.save(sign);
                try {
                    this.reviewCycleCellResultDAO.get(connection.getDestinationCell().getId(), version.getId());
                }
                catch (Exception e) {
                    I18n i18n = I18nFactory.getI18n(new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale()));
                    throw new ActionException(i18n.tr("Die Dokumentversion wurde schon upgeloadet"), e);
                }
            }
            catch (DigestCalculatorException e) {
                throw new ActionException("A digest error occured", e);
            }
            catch (SignatureCalculatorException e) {
                throw new ActionException("A signature error occured", e);
            }
            catch (WrongPasswordException e) {
                throw new ActionException("A signature error occured", e);
            }
        }
        oldNodeResult.setFinished(true);
        oldNodeResult.setDocumentDepartureDate(new Date(System.currentTimeMillis()));
        oldNodeResult.setActiveObjectListOfDocumentDeparture(objectList);
        this.reviewCycleNodeResultDAO.update(oldNodeResult);
        cellResult.setDocumentDepartureDate(new Date(System.currentTimeMillis()));
        cellResult.setNextReviewCycleCell(newCellResult.getReviewCycleCell());
        newCellResult.setPreviousReviewCycleCell(cellResult.getReviewCycleCell());
        this.firePostListenersEvent(oldNodeResult.getDocumentVersion(), versionNodeInstanceRelease, objectList);
        this.reviewCycleCellResultDAO.update(cellResult);
        this.reviewCycleCellResultDAO.update(newCellResult);
        this.reviewCycleCellConnectionResultDAO.update(connectionResult);
        if (oldDocumentVersion.getRevisedDocumentVersion() != null && oldDocumentVersion.getRevisedDocumentVersion().getStatus() != 4) {
            version.setRevisedDocumentVersion(oldDocumentVersion.getRevisedDocumentVersion());
        }
        this.documentVersionDAO.update(version);
        if (connection.getDocumentVersionStatusSource() != null) {
            oldDocumentVersion.setStatus(connection.getDocumentVersionStatusSource());
            this.documentVersionDAO.update(oldDocumentVersion);
        }
        if (selectCellConnectionTask != null) {
            this.taskOperations.doSelectCellTask(selectCellConnectionTask, connectionResult);
        }
        this.saveDocumentReferences(tempVersion.getDocumentRefs(), version);
        if (version.getActualReviewCycleNode().isEndNode()) {
            this.invalidateAllRevisedDocumentVersions(version.getDocument().getId());
        }
        return version;
    }

    @Override
    public DocumentVersion signReviewCycleEntryResult(TemporaryDocumentVersion tdv, ProjectParticipant signer, String password, ReviewCycleCell selectedCell, CDESCertificate cert, List<ReviewCycleEntryStatementResult> statements, Collection<MatrixEditItem> attachedReviewers, ReviewCycleNodeInstanceRelease nodeInstAttachedR) throws WrongPasswordException, FrontendException {
        Pair<DocumentVersion, ReviewCycleNodeInstanceRelease> p;
        DocumentVersion documentVersion;
        ObjectPlannerImpl impl;
        SubProject subProject;
        ReleasedObjectList objectList;
        tdv.setName("");
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        Document releasedOrImplDocument = this.documentDAO.get(tdv.getDocumentId());
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = releasedOrImplDocument.getLastReleasedOrImplDocument();
        }
        if ((objectList = (subProject = (impl = (ObjectPlannerImpl)(documentVersion = (DocumentVersion)(p = this.insertDocumentVersion(tdv = this.generateDocumentVersionNumber(releasedOrImplDocument, selectedCell, tdv, locale), selectedCell, selectedCell.getReviewCycleEntryCondition().getDocumentVersionStatus())).getFirst()).getDocument().getObjectPlanner()).getObject().getObjectList().getSubProject()).getActiveObjectList()) == null) {
            throw new ActionException("No active ObjectList was found in the SubProjekt with id " + subProject.getId());
        }
        if (attachedReviewers != null) {
            this.updateAttachedReviewCyclePositions(attachedReviewers, documentVersion, objectList, nodeInstAttachedR.getReviewCycleNodeInstance());
        }
        try {
            ReviewCycleEntryResultImpl res = new ReviewCycleEntryResultImpl();
            ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(subProject.getActiveObjectList().getId(), impl.getId());
            res.setDestinationObjectPlanner(rop);
            this.generateNextCellResults(documentVersion, objectList, ((ReviewCycleNodeInstanceRelease)p.getSecond()).getReviewCycleCellInstance().getReviewCycleInstance());
            res.setDocumentVersion(documentVersion);
            res.setProjectParticipant(signer);
            res.setResultDate(new Date(System.currentTimeMillis()));
            res.setComment(tdv.getComment());
            Network network = signer.getParticipation().getProject().getNetwork();
            DigestCalculator dig = this.digestCalculatorFactory.getDigestCalculator(network, res);
            DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
            res.setDigestCalculatorType(t);
            res.setDigest(dig.getDigest(res));
            File file = this.fileFinder.findFile(documentVersion.getFileName(), CDESFileRepository.PLANREPOSITORY);
            DigestCalculator fileDig = this.digestCalculatorFactory.getDigestCalculator(network, file);
            documentVersion.setFileDigester(this.digestCalculatorDAO.get(fileDig.getClass().getName()));
            documentVersion.setFileDigest(fileDig.getDigest(file));
            SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(network, res);
            CDESSignature sign = sig.createSignature(signer, dig.getSignableContent(res), cert, password);
            sign = this.signatureDAO.save(sign);
            try {
                this.reviewCycleCellResultDAO.get(selectedCell.getId(), documentVersion.getId());
            }
            catch (Exception e) {
                I18n i18n = I18nFactory.getI18n(new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale()));
                throw new ActionException(i18n.tr("Die Dokumentversion wurde schon upgeloadet"), e);
            }
            res.setSignature(sign);
            if (((DocumentImpl)documentVersion.getDocument()).getAsBuiltReference() != null) {
                DocumentImpl asBuiltDocument = ((DocumentImpl)documentVersion.getDocument()).getAsBuiltReference();
                documentVersion.setAsBuiltReference(asBuiltDocument.getLastDocumentVersion());
            }
            this.documentVersionDAO.update(documentVersion);
            this.documentDAO.update((DocumentImpl)documentVersion.getDocument());
            res = (ReviewCycleEntryResultImpl)this.reviewCycleEntryResultDAO.save(res);
            if (statements != null) {
                for (ReviewCycleEntryStatementResult result : statements) {
                    result.setReviewCycleEntryResult(res);
                    result = this.reviewCycleEntryResultDAO.save(result);
                    if (res.getStatements() == null) {
                        res.setStatements(new HashMap());
                    }
                    res.getStatements().put(result.getId(), result);
                }
            }
            this.saveDocumentReferences(tdv.getDocumentRefs(), documentVersion);
            ReviewCycleEntryTask task = this.taskOperations.getReviewCycleEntryTask(documentVersion.getDocument().getId());
            if (task != null) {
                this.taskOperations.doReviewCycleEntryTask(task, res);
            }
            return documentVersion;
        }
        catch (FileHandleException e) {
            throw new ActionException("ReviewCycleEntry", e);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("ReviewCycleEntry ", e);
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("ReviewCycleEntry ", e);
        }
    }

    @Override
    public DocumentVersion invalidateDocumentVersion(Integer documentVersionId, String comment, ProjectParticipant signer, ReviewCycleResultOption reviewCycleResultOption, String password, CDESCertificate cert, boolean isInvalidationUpload, boolean reactivateLastReleasedVersion) throws WrongPasswordException, FrontendException {
        DigestCalculator dig;
        DocumentVersion documentVersion = this.getDocumentVersion(documentVersionId);
        ReleasedObjectList activeObjectList = documentVersion.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        ReleasedDocumentList activeDocumentList = documentVersion.getDocument().getDocumentList().getSubProject().getActiveDocumentList();
        ReviewCycleNodeInstanceImpl versionNodeInstance = documentVersion.getActualReviewCycleNodeInstance();
        ReviewCycleInstanceRelease instanceReleased = this.reviewCycleInstanceDAO.getReleased(activeObjectList.getId(), versionNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleNodeInstanceRelease nodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceReleased.getId(), versionNodeInstance.getReviewCycleNode().getId());
        ReviewCycleNodeResultImpl nodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(versionNodeInstance.getReviewCycleNode(), documentVersion);
        ReviewCyclePositionResultImpl res = new ReviewCyclePositionResultImpl();
        res.setActiveObjectList(activeObjectList);
        res.setActiveDocumentList(activeDocumentList);
        res.setComment(comment);
        res.setDocumentVersion(documentVersion);
        res.setProjectParticipant(signer);
        res.setResultDate(new Date(System.currentTimeMillis()));
        res.setReviewCycleNode(nodeResult.getReviewCycleNode());
        res.setReviewCycleNodeResult(nodeResult);
        res.setAuthorized(reviewCycleResultOption.isAuthorized());
        if (reviewCycleResultOption != null) {
            res.setReviewCycleResultOption(reviewCycleResultOption);
        }
        res = (ReviewCyclePositionResultImpl)this.reviewCyclePositionResultDAO.save(res);
        try {
            dig = this.digestCalculatorFactory.getDigestCalculator(signer.getParticipation().getProject().getNetwork(), res);
            res.setDigestCalculatorType(this.digestCalculatorDAO.get(dig.getClass().getName()));
            res.setDigest(dig.getDigest(res));
            this.reviewCyclePositionResultDAO.update(res);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("Invalidation of the DocumentVersion failed", e);
        }
        try {
            SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(signer.getParticipation().getProject().getNetwork(), res);
            CDESSignature sign = sig.createSignature(signer, dig.getSignableContent(res), cert, password);
            sign = this.signatureDAO.save(sign);
            res.setSignature(sign);
            this.reviewCyclePositionResultDAO.update(res);
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("DocumentVersion invalidation failed", e);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("DocumentVersion invalidation failed", e);
        }
        return this.invalidateDocumentVersion2(documentVersion, reviewCycleResultOption, activeObjectList, nodeInstanceRelease, isInvalidationUpload, reactivateLastReleasedVersion);
    }

    @Override
    public void signFreeReviewCycleNodeResult(DocumentVersion documentVersion, String comment, ProjectParticipant signer, CDESCertificate cert, ReviewCycleNodeInstance freeNodeInstance, String password, List tmpResults) throws WrongPasswordException, FrontendException {
        int i;
        ReleasedObjectList activeObjectList = documentVersion.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        Network network = activeObjectList.getSubProject().getProject().getNetwork();
        ReleasedDocumentList activeDocumentList = documentVersion.getDocument().getDocumentList().getSubProject().getActiveDocumentList();
        ReviewCycleNodeInstanceImpl versionNodeInstance = documentVersion.getActualReviewCycleNodeInstance();
        ReviewCycleInstanceRelease instanceReleased = this.reviewCycleInstanceDAO.getReleased(activeObjectList.getId(), versionNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleNodeInstanceRelease versionNodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceReleased.getId(), versionNodeInstance.getReviewCycleNode().getId());
        ReviewCycleNodeInstanceRelease freeNodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceReleased.getId(), freeNodeInstance.getReviewCycleNode().getId());
        ReviewCycleNodeResultImpl freeNodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(freeNodeInstance.getReviewCycleNode(), documentVersion);
        DigestCalculator dig = null;
        ArrayList<ReviewCyclePositionResult> reviews = new ArrayList<ReviewCyclePositionResult>();
        boolean hasBreakingResult = false;
        for (i = 0; i < tmpResults.size(); ++i) {
            TemporaryReviewCyclePositionResult tRes = (TemporaryReviewCyclePositionResult)tmpResults.get(i);
            ProjectParticipant reviewer = this.projectParticipantDAO.get(tRes.getSignerId());
            ReviewCyclePositionResult res = this.saveOrUpdateReviewCyclePositionResult(activeObjectList, activeDocumentList, documentVersion, tRes, freeNodeResult, reviewer, null);
            if (tRes.getReviewCyleResultOptionId() == null) continue;
            if (res.getReviewCycleResultOption().getCellChangePartA() != null && res.getReviewCycleResultOption().getCellChangePartA().length() > 0 || res.getReviewCycleResultOption().getCellChangePartB() != null && res.getReviewCycleResultOption().getCellChangePartB().length() > 0) {
                try {
                    documentVersion = this.ognlNumberCalculator.getNumber(documentVersion.getDocument(), signer.getParticipation().getProject(), res.getReviewCycleResultOption(), documentVersion, instanceReleased.getReviewCycleInstance().getReviewCycle().getDocumentNumberVersionPart().getSeperator());
                    documentVersion = this.documentVersionDAO.update(documentVersion);
                }
                catch (NumberCalculatorException e) {
                    throw new ActionException("SignReview", e);
                }
            }
            reviews.add(res);
            ArrayList<Attachment> att2Delete = new ArrayList<Attachment>();
            if (res.getAttachments() != null) {
                for (Attachment attachment : res.getAttachments().values()) {
                    if (attachment.getFileName() == null || attachment.getFileName().length() == 0) {
                        att2Delete.add(attachment);
                        continue;
                    }
                    this.attachmentOperations.updateFileDigest(attachment, network);
                }
            }
            for (Attachment attachment : att2Delete) {
                res.getAttachments().remove(attachment.getId());
                this.attachmentOperations.deleteAttachment(attachment.getId());
            }
            try {
                if (dig == null) {
                    dig = this.digestCalculatorFactory.getDigestCalculator(network, res);
                }
                DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
                res.setDigestCalculatorType(t);
                res.setDigest(dig.getDigest(res));
                this.reviewCyclePositionResultDAO.update(res);
                if (res.getReviewCycleResultOption().isFinishCell()) {
                    hasBreakingResult = true;
                    continue;
                }
                if (hasBreakingResult || !this.isNodeFinished(freeNodeInstanceRelease, res.getReviewCycleNodeResult(), res.getDocumentVersion())) continue;
                this.finishReviewCycleNode(freeNodeInstanceRelease, freeNodeResult, activeObjectList, documentVersion, null);
                continue;
            }
            catch (DigestCalculatorException e) {
                throw new ActionException("SignReview", e);
            }
        }
        try {
            for (i = 0; i < reviews.size(); ++i) {
                ReviewCyclePositionResult res = (ReviewCyclePositionResult)reviews.get(i);
                SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(network, res);
                CDESSignature sign = sig.createSignature(signer, dig.getSignableContent(res), cert, password);
                List pres = this.reviewCyclePositionResultDAO.getAllSigned(res.getRealm().getId(), res.getReviewCycleNode().getId(), res.getDocumentVersion().getId(), res.getProjectParticipant().getParticipation().getId());
                for (ReviewCyclePositionResultImpl result : pres) {
                    if (result.getSignature() == null || !result.getId().equals(res.getId())) continue;
                    I18n i18n = I18nFactory.getI18n(new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale()));
                    throw new ActionException(i18n.tr("Der Pr\u00fcfbereich wurde schon signiert"));
                }
                sign = this.signatureDAO.save(sign);
                res.setSignature(sign);
                this.reviewCyclePositionResultDAO.update(res);
            }
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("SignReview", e);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("SignReview", e);
        }
        if (hasBreakingResult) {
            this.finishReviewCycleNode(freeNodeInstanceRelease, freeNodeResult, activeObjectList, documentVersion, null);
            this.invalidateDocumentVersion2(documentVersion, null, activeObjectList, versionNodeInstanceRelease, false, false);
        }
    }

    @Override
    public DocumentVersion invalidateDocumentVersion2(DocumentVersion documentVersion, ReviewCycleResultOption reviewCycleResultOption, ReleasedObjectList activeObjectList, ReviewCycleNodeInstanceRelease nodeInstanceRelease, boolean isInvalidationUpload, boolean reactivateLastReleasedVersion) {
        ReviewCycleNodeResultImpl nodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(nodeInstanceRelease.getReviewCycleNode(), documentVersion);
        ReviewCycle cycle = nodeResult.getReviewCycleNode().getReviewCycleCell().getReviewCycle();
        ReviewCycleNodeInstanceRelease lastNodeInstance = (ReviewCycleNodeInstanceRelease)nodeInstanceRelease.getReviewCycleCellInstance().getLastReviewCycleNodeInstance();
        nodeResult.setReviewCycleResultOption(reviewCycleResultOption);
        this.taskOperations.removeTasks(documentVersion);
        this.finishReviewCycleNode(nodeInstanceRelease, nodeResult, activeObjectList, documentVersion, lastNodeInstance);
        ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(activeObjectList.getId(), documentVersion.getDocument().getObjectPlanner().getId());
        DocumentImpl document = (DocumentImpl)documentVersion.getDocument();
        DocumentVersion sourceDocumentVersion = null;
        ReviewCycleCellConnectionResult cellConnectionResult = this.reviewCycleCellConnectionResultDAO.getByDestinationDocumentVersion(documentVersion.getId());
        if (cellConnectionResult != null) {
            sourceDocumentVersion = cellConnectionResult.getSourceDocumentVersion();
        }
        if (!(lastNodeInstance.getId().equals(nodeInstanceRelease.getId()) || rop == null && cycle.getDocumentInvalidationOption() != null && cycle.getDocumentInvalidationOption().getId().equals(reviewCycleResultOption.getId()))) {
            this.moveDocumentVersionToNode(nodeInstanceRelease, lastNodeInstance, activeObjectList, nodeResult, documentVersion);
        }
        if (cycle.getDocumentVersionDeletedOption() != null && cycle.getDocumentVersionDeletedOption().getId().equals(reviewCycleResultOption.getId())) {
            document.getDocumentVersions().remove(documentVersion.getId());
            if (document.getDeletedDocumentVersions() == null) {
                document.setDeletedDocumentVersions(new HashMap<Integer, DocumentVersion>());
            }
            document.getDeletedDocumentVersions().put(documentVersion.getId(), documentVersion);
            if (document.getDocumentVersions().size() == 0) {
                document.setVersionSet(false);
            }
            this.documentDAO.update(document);
            if (sourceDocumentVersion != null && !reactivateLastReleasedVersion) {
                ReviewCycleNodeInstanceImpl versionNodeInstance = sourceDocumentVersion.getActualReviewCycleNodeInstance();
                ReviewCycleInstanceRelease instanceReleased = this.reviewCycleInstanceDAO.getReleased(activeObjectList.getId(), versionNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
                lastNodeInstance = this.getReleasedReviewCycleNodeInstance3(sourceDocumentVersion.getActualReviewCycleNode().getId(), instanceReleased.getId());
                this.taskOperations.generateSelectCellTask(activeObjectList, sourceDocumentVersion, lastNodeInstance, false, false, true);
            } else {
                ReleasedDocument docRel;
                ReleasedDocumentList docListRel = activeObjectList.getSubProject().getActiveDocumentList();
                if (docListRel != null && (docRel = this.documentDAO.getReleased(document.getId(), docListRel.getId())) != null && docRel.getStartDate() != null && !document.isVersionSet()) {
                    this.taskOperations.generateReviewCycleEntryTask(rop, document);
                }
            }
            if (reactivateLastReleasedVersion && sourceDocumentVersion != null && (sourceDocumentVersion.getStatus() == 4 || sourceDocumentVersion.getStatus() == 10)) {
                log.info((Object)"Reactivating previous documentVersion");
                List<ReviewCycleNodeResultImpl> nodeResults = this.reviewCycleNodeResultDAO.getAllSortedByPosition(sourceDocumentVersion);
                ReviewCycleNodeResultImpl lastNodeResult = nodeResults.get(nodeResults.size() - 1);
                ReviewCycleResultOption lastStatusChangingPositionResultOption = null;
                ReviewCycleResultOption lastResultOptionBeforeInvalidation = null;
                for (ReviewCycleNodeResultImpl nodeRes : nodeResults) {
                    ArrayList positionResults = new ArrayList(nodeRes.getReviewCycleNodePositionResults().values());
                    for (ReviewCyclePositionResult posRes : positionResults) {
                        if (posRes.getReviewCycleResultOption() != null && posRes.getReviewCycleResultOption().getDocumentVersionStatus() != null && posRes.getReviewCycleResultOption().getDocumentVersionStatus() != 4) {
                            lastStatusChangingPositionResultOption = posRes.getReviewCycleResultOption();
                            log.info((Object)("found resultOption with statusChange=[" + posRes.getReviewCycleResultOption().getDocumentVersionStatus() + "]"));
                        }
                        if (posRes.getReviewCycleResultOption() == null || posRes.getReviewCycleResultOption().getDocumentVersionStatus() != null && posRes.getReviewCycleResultOption().getDocumentVersionStatus() == 4) continue;
                        lastResultOptionBeforeInvalidation = posRes.getReviewCycleResultOption();
                    }
                }
                if (sourceDocumentVersion.getStatus() == 4 || sourceDocumentVersion.getStatus() == 10 || sourceDocumentVersion.getStatus() == 12) {
                    if (lastResultOptionBeforeInvalidation != null) {
                        ReviewCycleCellResult cellResult = lastNodeResult.getReviewCycleCellResult();
                        cellResult.setReviewCycleResultOption(lastResultOptionBeforeInvalidation);
                        if (lastNodeResult.getReviewCycleNode().isEndNode()) {
                            cellResult.setNextReviewCycleCell(null);
                            cellResult.setDocumentDepartureDate(null);
                        }
                        this.reviewCycleCellResultDAO.update(cellResult);
                    }
                    if (lastStatusChangingPositionResultOption != null && (lastStatusChangingPositionResultOption.getDocumentVersionStatus() == 1 || lastStatusChangingPositionResultOption.getDocumentVersionStatus() == 2 || lastStatusChangingPositionResultOption.getDocumentVersionStatus() == 3)) {
                        sourceDocumentVersion.setStatus(lastStatusChangingPositionResultOption.getDocumentVersionStatus());
                    } else {
                        sourceDocumentVersion.setStatus(1);
                    }
                    sourceDocumentVersion = this.documentVersionDAO.update(sourceDocumentVersion);
                    if (lastNodeResult.getReviewCycleResultOption() != null) {
                        lastNodeResult.setReviewCycleResultOption(null);
                        lastNodeResult.setFinished(false);
                        lastNodeResult.setDocumentDepartureDate(null);
                        lastNodeResult.setActiveObjectListOfDocumentDeparture(null);
                        lastNodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.update(lastNodeResult);
                        this.insertCreateMissingTasks(lastNodeResult.getId(), true, 0);
                    } else if (nodeResults.size() >= 2 && sourceDocumentVersion.getStatus() != 10 && sourceDocumentVersion.getStatus() != 12) {
                        ReviewCycleNodeResultImpl lastActiveNodeResult = nodeResults.get(nodeResults.size() - 2);
                        lastActiveNodeResult.setReviewCycleResultOption(null);
                        lastActiveNodeResult.setFinished(false);
                        lastActiveNodeResult.setDocumentDepartureDate(null);
                        lastActiveNodeResult.setActiveObjectListOfDocumentDeparture(null);
                        lastActiveNodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.update(lastActiveNodeResult);
                        this.reviewCycleNodeResultDAO.delete(lastNodeResult);
                        ReviewCycleNodeInstanceImpl actualNodeInstance = this.reviewCycleNodeInstanceDAO.getUnreleased(sourceDocumentVersion.getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance(), lastActiveNodeResult.getReviewCycleNode());
                        sourceDocumentVersion.setActualReviewCycleNodeInstance(actualNodeInstance);
                        sourceDocumentVersion = this.documentVersionDAO.update(sourceDocumentVersion);
                        this.insertCreateMissingTasks(lastActiveNodeResult.getId(), true, 0);
                    }
                    documentVersion.setReactivatedDocumentVersion(sourceDocumentVersion);
                    documentVersion = this.documentVersionDAO.update(documentVersion);
                }
            }
        } else if (cycle.getDocumentVersionInvalidationOption() != null && cycle.getDocumentVersionInvalidationOption().getId().equals(reviewCycleResultOption.getId()) && !isInvalidationUpload && (documentVersion.getLastDocumentVersionRevision() == null || documentVersion.getLastDocumentVersionRevision().isDeleted() || documentVersion.getLastDocumentVersionRevision().isInvalidatedAll()) && this.taskOperations.getSelectCellConnectionTasksForDocument(documentVersion.getDocument().getId()).size() == 0) {
            this.taskOperations.generateSelectCellTask(activeObjectList, documentVersion, lastNodeInstance, false, false, true);
        } else if (cycle.getDocumentInvalidationOption() != null && cycle.getDocumentInvalidationOption().getId().equals(reviewCycleResultOption.getId()) || cycle.getDocumentVersionAbortedOption() != null && cycle.getDocumentVersionAbortedOption().getId().equals(reviewCycleResultOption.getId())) {
            if (sourceDocumentVersion != null) {
                this.taskOperations.removeTasks(sourceDocumentVersion);
            }
            this.taskOperations.deleteDocumentTasks(document.getId());
        }
        return documentVersion;
    }

    @Override
    public void signReviewPositionResult(List tmpResults, List tmpComments, String password, ProjectParticipant signer, ReviewableTask reviewTask, CDESCertificate cert) throws WrongPasswordException, FrontendException {
        int i;
        DocumentVersion version = reviewTask.getDocumentVersion();
        if (signer == null) {
            throw new ActionException("The signer was null");
        }
        ReleasedObjectList activeObjectList = version.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        ReleasedDocumentList activeDocumentList = version.getDocument().getDocumentList().getSubProject().getActiveDocumentList();
        Network network = signer.getParticipation().getProject().getNetwork();
        ReviewCycleNode actualNode = version.getActualReviewCycleNode();
        if (reviewTask != null) {
            for (ReviewCyclePosition pos : reviewTask.getReviewCyclePositionReleases().values()) {
                if (pos.getReviewCycleNodeInstance().getReviewCycleNode().getId().equals(actualNode.getId())) continue;
                String msg = "The reviewCyclePosition " + pos.getReviewCycleNodeInstance().getReviewCycleNode().getId() + " of the reviewTask position does not match the current position " + actualNode.getId() + " of the documentVersion " + version.getId() + ".";
                log.error((Object)msg);
                throw new ActionException(msg);
            }
        }
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(actualNode, version);
        DigestCalculator dig = null;
        ArrayList<ReviewCyclePositionResult> reviews = new ArrayList<ReviewCyclePositionResult>();
        ArrayList<Integer> donePositionIds = new ArrayList<Integer>();
        boolean hasBreakingResult = false;
        ObjectPlannerImpl impl = (ObjectPlannerImpl)version.getDocument().getObjectPlanner();
        ReleasedObjectPlanner op = this.objectPlannerDAO.getReleasedObjectPlanner(activeObjectList.getId(), impl.getId());
        ReviewCycleNodeInstanceRelease actualNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(op.getReviewCycleInstance().getId(), version.getActualReviewCycleNode().getId());
        for (i = 0; i < tmpResults.size(); ++i) {
            TemporaryReviewCyclePositionResult tRes = (TemporaryReviewCyclePositionResult)tmpResults.get(i);
            ReviewCyclePositionResult res = this.saveOrUpdateReviewCyclePositionResult(activeObjectList, activeDocumentList, version, tRes, nodeResult, signer, tRes.getOverridingProjectParticipantId());
            if (tRes.getOverridingProjectParticipantId() == null && res.getOverridingProjectParticipant() != null) {
                res.setOverridingProjectParticipant(null);
                res = this.reviewCyclePositionResultDAO.update(res);
            }
            if (tRes.getReviewCyleResultOptionId() == null) continue;
            if (reviewTask != null) {
                if (reviewTask.getReviewCyclePositionReleases().containsKey(tRes.getReviewCyclePositionId())) {
                    donePositionIds.add(tRes.getReviewCyclePositionId());
                } else {
                    log.error((Object)("The review position release ID " + tRes.getReviewCyclePositionId() + " in the temporary result has not been found in the ReviewTask."));
                    throw new ActionException("The review position release ID " + tRes.getReviewCyclePositionId() + " in the temporary result has not been found in the ReviewTask.");
                }
            }
            reviews.add(res);
            ArrayList<Attachment> att2Delete = new ArrayList<Attachment>();
            if (res.getAttachments() != null) {
                for (Attachment attachment : res.getAttachments().values()) {
                    if (attachment.getFileName() == null || attachment.getFileName().length() == 0) {
                        att2Delete.add(attachment);
                        continue;
                    }
                    this.attachmentOperations.updateFileDigest(attachment, network);
                }
            }
            for (Attachment attachment : att2Delete) {
                res.getAttachments().remove(attachment.getId());
                this.attachmentOperations.deleteAttachment(attachment.getId());
            }
            try {
                DocumentVersionStatusChange change;
                Calendar now;
                DocumentVersion revisedVersion;
                if (dig == null) {
                    dig = this.digestCalculatorFactory.getDigestCalculator(network, res);
                }
                DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
                res.setDigestCalculatorType(t);
                res.setDigest(dig.getDigest(res));
                this.reviewCyclePositionResultDAO.update(res);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking if ReviewCycleNode [" + TapestryI18nHelper.getLocalizedString(res.getReviewCycleNode().getName()) + "] with id [" + res.getId() + "] is finished and the DocumentVersion should be moved to next node."));
                }
                if (res.getReviewCycleResultOption().isFinishCell()) {
                    hasBreakingResult = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"ReviewCycleNode is finishing Cell, the ReviewCycle is over");
                    continue;
                }
                if (hasBreakingResult || !this.isNodeFinished(actualNodeInstance, res.getReviewCycleNodeResult(), version)) continue;
                this.moveDocumentVersionToNextNode(actualNodeInstance, activeObjectList, (ReviewCycleNodeResultImpl)res.getReviewCycleNodeResult(), version, false);
                if (version.getRevisedDocumentVersion() != null && version.getStatus() == 2) {
                    revisedVersion = version.getRevisedDocumentVersion();
                    revisedVersion.setStatus(4);
                    revisedVersion = this.documentVersionDAO.update(revisedVersion);
                    now = Calendar.getInstance();
                    change = new DocumentVersionStatusChange();
                    change.setChangeDate(now);
                    change.setDocumentVersionId(revisedVersion.getId());
                    change.setFileName(revisedVersion.getFileName());
                    change.setName(revisedVersion.getName());
                    change.setNewStatus(revisedVersion.getStatus());
                    this.documentVersionDAO.saveStatusChange(change);
                    this.createObjectPlannerDefinitionEMailSnippets(revisedVersion, op, now);
                    continue;
                }
                if (version.getRevisedDocumentVersion() == null || version.getStatus() != 10) continue;
                revisedVersion = version.getRevisedDocumentVersion();
                revisedVersion.setStatus(12);
                revisedVersion = this.documentVersionDAO.update(revisedVersion);
                now = Calendar.getInstance();
                change = new DocumentVersionStatusChange();
                change.setChangeDate(now);
                change.setDocumentVersionId(revisedVersion.getId());
                change.setFileName(revisedVersion.getFileName());
                change.setName(revisedVersion.getName());
                change.setNewStatus(revisedVersion.getStatus());
                this.documentVersionDAO.saveStatusChange(change);
                this.createObjectPlannerDefinitionEMailSnippets(revisedVersion, op, now);
                continue;
            }
            catch (DigestCalculatorException e) {
                throw new ActionException("SignReview", e);
            }
        }
        try {
            this.insertAndDigestPositionComments(tmpComments, activeObjectList, activeDocumentList, version, signer, nodeResult, dig);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("SignReview", e);
        }
        try {
            for (i = 0; i < reviews.size(); ++i) {
                ReviewCyclePositionResult res = (ReviewCyclePositionResult)reviews.get(i);
                SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(network, res);
                CDESSignature sign = sig.createSignature(signer, dig.getSignableContent(res), cert, password);
                ReviewCyclePositionResult pres = this.reviewCyclePositionResultDAO.get(res.getRealm(), res.getReviewCycleNodeResult(), res.getProjectParticipant().getParticipation());
                if (pres != null && pres.getSignature() != null) {
                    throw new ActionException("Der Pr\u00fcfbereich wurde schon signiert");
                }
                sign = this.signatureDAO.save(sign);
                res.setSignature(sign);
                res = this.reviewCyclePositionResultDAO.update(res);
                if ((res.getReviewCycleResultOption().getCellChangePartA() == null || res.getReviewCycleResultOption().getCellChangePartA().length() <= 0) && (res.getReviewCycleResultOption().getCellChangePartB() == null || res.getReviewCycleResultOption().getCellChangePartB().length() <= 0)) continue;
                version = this.ognlNumberCalculator.getNumber(version.getDocument(), signer.getParticipation().getProject(), res.getReviewCycleResultOption(), version, impl.getReviewCycleInstance().getReviewCycle().getDocumentNumberVersionPart().getSeperator());
                version = this.documentVersionDAO.update(version);
            }
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("SignReview", e);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("SignReview", e);
        }
        catch (NumberCalculatorException e) {
            throw new ActionException("SignReview", e);
        }
        if (hasBreakingResult) {
            this.moveDocumentVersionToNextNode(actualNodeInstance, activeObjectList, (ReviewCycleNodeResultImpl)nodeResult, version, true);
        }
        if (reviewTask != null) {
            if (reviewTask instanceof ReviewTask) {
                this.taskOperations.doReviewTask((ReviewTask)reviewTask, reviews, donePositionIds);
            } else if (reviewTask instanceof AttachedReviewTask) {
                this.taskOperations.doAttachedReviewTask((AttachedReviewTask)reviewTask, reviews, donePositionIds);
            }
        }
    }

    private ReviewCycleNodeResultImpl moveDocumentVersionToNode(ReviewCycleNodeInstance actualNodeInstance, ReviewCycleNodeInstance destination, ReleasedObjectList objectList, ReviewCycleNodeResultImpl nodeResult, DocumentVersion documentVersion) {
        documentVersion.setActualReviewCycleNodeInstance(((ReviewCycleNodeInstanceRelease)destination).getReviewCycleNodeInstance());
        documentVersion = this.documentVersionDAO.update(documentVersion);
        ReviewCycleNodeResultImpl destNodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(destination.getReviewCycleNode(), documentVersion);
        if (destNodeResult == null) {
            destNodeResult = (ReviewCycleNodeResultImpl)this.insertReviewCycleNodeResult(documentVersion, documentVersion.getActualReviewCycleNode(), objectList, nodeResult.getReviewCycleCellResult());
        }
        return destNodeResult;
    }

    @Override
    public void moveDocumentVersionToNextNodeFromNodeResult(Integer nodeResultId) {
        ReviewCycleNodeResultImpl nodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(nodeResultId);
        DocumentVersion documentVersion = nodeResult.getDocumentVersion();
        SubProject sp = documentVersion.getDocument().getDocumentList().getSubProject();
        ReleasedObjectList objectList = sp.getActiveObjectList();
        ReviewCycleInstanceRelease instanceRelease = this.reviewCycleInstanceDAO.getReleased(objectList.getId(), documentVersion.getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleNodeInstanceRelease actualNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(instanceRelease.getId(), nodeResult.getReviewCycleNode().getId());
        this.moveDocumentVersionToNextNode(actualNodeInstance, objectList, nodeResult, documentVersion, false);
    }

    @Override
    public DocumentVersion moveDocumentVersionToNextNode(ReviewCycleNodeInstanceRelease actualNodeInstance, ReleasedObjectList objectList, ReviewCycleNodeResultImpl nodeResult, DocumentVersion documentVersion, boolean hasBreakingResult) {
        ReviewCycleCellInstance cellInstance = actualNodeInstance.getReviewCycleCellInstance();
        ReviewCycleNodeInstanceRelease nextNodeInstance = (ReviewCycleNodeInstanceRelease)cellInstance.getNextNodeInstance(actualNodeInstance);
        ReviewCycleResultOption emptyNodeOption = cellInstance.getReviewCycleCell().getReviewCycle().getEmptyNodeOption();
        boolean isEndNode = actualNodeInstance.getReviewCycleNode().isEndNode();
        if (isEndNode) {
            return documentVersion;
        }
        if (nextNodeInstance == null) {
            String msg = "There is no next ReviewCycleNode after the node has received all reviews.";
            log.error((Object)msg);
            throw new ActionException(msg);
        }
        List<ReviewCyclePosition> actualPositions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(actualNodeInstance, documentVersion);
        if (hasBreakingResult || nodeResult.getReviewCycleResultOption() != null && nodeResult.getReviewCycleResultOption().isFinishCell()) {
            nextNodeInstance = (ReviewCycleNodeInstanceRelease)actualNodeInstance.getReviewCycleCellInstance().getLastReviewCycleNodeInstance();
        } else {
            while (!nextNodeInstance.getReviewCycleNode().isEndNode()) {
                List<ReviewCyclePosition> nextPositions;
                OrganisationPerson asBuiltContractorOrgPerson = null;
                ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)documentVersion.getDocument().getObjectPlanner();
                if (objectPlanner.getAsBuiltReference() != null && objectPlanner.getAsBuiltReference().getContractor() != null) {
                    asBuiltContractorOrgPerson = objectPlanner.getAsBuiltReference().getContractor().getMainParticipant().getOrganisationPerson();
                }
                if (!this.reviewCycleInterpretationHelper.verifyReviewCycleNodeSkippingRule(nextNodeInstance, documentVersion, asBuiltContractorOrgPerson) && (nextPositions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nextNodeInstance, documentVersion)) != null && !nextPositions.isEmpty()) break;
                if (actualPositions == null || actualPositions.isEmpty()) {
                    nodeResult.setReviewCycleResultOption(emptyNodeOption);
                }
                this.finishReviewCycleNode(actualNodeInstance, nodeResult, objectList, documentVersion, nextNodeInstance);
                nodeResult = this.moveDocumentVersionToNode(actualNodeInstance, nextNodeInstance, objectList, nodeResult, documentVersion);
                actualNodeInstance = nextNodeInstance;
                if ((nextNodeInstance = (ReviewCycleNodeInstanceRelease)cellInstance.getNextNodeInstance(nextNodeInstance)) != null) continue;
                String msg = "There is no next ReviewCycleNode  while serching for the next node to be reviewed.";
                log.error((Object)msg);
                throw new ActionException(msg);
            }
        }
        if (actualPositions == null || actualPositions.isEmpty()) {
            nodeResult.setReviewCycleResultOption(emptyNodeOption);
        }
        this.finishReviewCycleNode(actualNodeInstance, nodeResult, objectList, documentVersion, nextNodeInstance);
        if (nodeResult.getReviewCycleResultOption() != null && nodeResult.getReviewCycleResultOption().isFinishCell()) {
            nextNodeInstance = (ReviewCycleNodeInstanceRelease)actualNodeInstance.getReviewCycleCellInstance().getLastReviewCycleNodeInstance();
        }
        boolean evaluateCellConnections = nodeResult.getReviewCycleResultOption().isEvaluateCellConnections();
        nodeResult = this.moveDocumentVersionToNode(actualNodeInstance, nextNodeInstance, objectList, nodeResult, documentVersion);
        this.taskOperations.generateReviewTasks(documentVersion, nextNodeInstance, nodeResult.getId(), false, true);
        if (documentVersion.getActualReviewCycleNode().isEndNode()) {
            this.taskOperations.generateSelectCellTask(objectList, documentVersion, nextNodeInstance, false, evaluateCellConnections, true);
        }
        this.documentVersionDAO.evict(documentVersion);
        return documentVersion;
    }

    public ReviewCyclePositionResult saveOrUpdateReviewCyclePositionResult(ReleasedObjectList activeObjectList, DocumentList activeDocumentList, DocumentVersion version, TemporaryReviewCyclePositionResult tRes, ReviewCycleNodeResult nodeResult, ProjectParticipant participant, Integer overridingProjectParticipantId) {
        HashedObject res = null;
        if (tRes.getReviewCyclePositionResultId() == null && tRes.getRealmId() != null) {
            Realm realm = this.realmDAO.get(tRes.getRealmId());
            res = this.reviewCyclePositionResultDAO.get(realm, nodeResult.getReviewCycleNode(), version, participant.getParticipation(), nodeResult.getId());
        } else if (tRes.getReviewCyclePositionResultId() != null) {
            res = this.reviewCyclePositionResultDAO.get(tRes.getReviewCyclePositionResultId());
        }
        if (res == null) {
            res = new ReviewCyclePositionResultImpl();
            res.setActiveObjectList(activeObjectList);
            res.setActiveDocumentList(activeDocumentList);
            res.setComment(tRes.getComment());
            res.setDocumentVersion(version);
            if (overridingProjectParticipantId == null) {
                res.setProjectParticipant(participant);
            } else {
                ReviewCyclePositionReleaseImpl position = this.reviewCyclePositionDAO.getReleased(tRes.getReviewCyclePositionId());
                res.setProjectParticipant(position.getProjectParticipation().getMainParticipant());
            }
            if (tRes.getRealmId() != null) {
                res.setRealm(this.realmDAO.get(tRes.getRealmId()));
            }
            res.setResultDate(new Date(System.currentTimeMillis()));
            res.setReviewCycleNode(nodeResult.getReviewCycleNode());
            res.setReviewCycleNodeResult(nodeResult);
            if (tRes.getOverridingProjectParticipantId() != null) {
                res.setOverridingProjectParticipant(this.projectParticipantDAO.get(tRes.getOverridingProjectParticipantId()));
            }
            if (tRes.getReviewCyleResultOptionId() != null) {
                res.setReviewCycleResultOption(this.reviewCycleResultOptionDAO.get(tRes.getReviewCyleResultOptionId()));
            }
            res = (ReviewCyclePositionResultImpl)this.reviewCyclePositionResultDAO.save((ReviewCyclePositionResult)res);
        } else {
            if (res.getDigest() != null) {
                return res;
            }
            res.setActiveObjectList(activeObjectList);
            res.setActiveDocumentList(activeDocumentList);
            res.setComment(tRes.getComment());
            res.setDocumentVersion(version);
            if (tRes.getOverridingProjectParticipantId() != null) {
                ReviewCyclePositionReleaseImpl released = this.reviewCyclePositionDAO.getReleased(tRes.getReviewCyclePositionId());
                res.setProjectParticipant(released.getProjectParticipation().getMainParticipant());
            } else {
                res.setProjectParticipant(participant);
            }
            res.setRealm(this.realmDAO.get(tRes.getRealmId()));
            res.setResultDate(new Date(System.currentTimeMillis()));
            res.setReviewCycleNode(nodeResult.getReviewCycleNode());
            res.setReviewCycleNodeResult(nodeResult);
            if (tRes.getOverridingProjectParticipantId() != null) {
                res.setOverridingProjectParticipant(this.projectParticipantDAO.get(tRes.getOverridingProjectParticipantId()));
            }
            if (tRes.getReviewCyleResultOptionId() != null) {
                res.setReviewCycleResultOption(this.reviewCycleResultOptionDAO.get(tRes.getReviewCyleResultOptionId()));
            }
            res = this.reviewCyclePositionResultDAO.update((ReviewCyclePositionResult)res);
        }
        return res;
    }

    @Override
    public void saveReviewPositionResults(List tmpResults, List tmpComments, ProjectParticipant participant, DocumentVersion version, ReviewCycleNode node, Map releasedPositions) {
        ReleasedObjectList activeObjectList = version.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        ReleasedDocumentList activeDocumentList = version.getDocument().getDocumentList().getSubProject().getActiveDocumentList();
        ProjectParticipant overriddenParticipant = null;
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(node, version);
        if (tmpResults != null) {
            for (int i = 0; i < tmpResults.size(); ++i) {
                TemporaryReviewCyclePositionResult tRes = (TemporaryReviewCyclePositionResult)tmpResults.get(i);
                if (tRes.getOverridingProjectParticipantId() != null && overriddenParticipant == null) {
                    ReviewCyclePositionReleaseImpl posRes = this.reviewCyclePositionDAO.getReleased(tRes.getReviewCyclePositionId());
                    overriddenParticipant = posRes.getProjectParticipation().getMainParticipant();
                }
                this.saveOrUpdateReviewCyclePositionResult(activeObjectList, activeDocumentList, version, tRes, nodeResult, participant, tRes.getOverridingProjectParticipantId());
                if (releasedPositions == null || releasedPositions.containsKey(tRes.getReviewCyclePositionId())) continue;
                String msg = "The review position release ID [" + tRes.getReviewCyclePositionId() + "] in the temporary result has not been found in the ReviewTask.";
                log.error((Object)msg);
                throw new ActionException(msg);
            }
        }
        this.saveOrUpdateReviewPositionCommentResults(tmpComments, activeObjectList, activeDocumentList, version, participant, nodeResult, overriddenParticipant);
    }

    public List insertAndDigestPositionComments(List comments, ReleasedObjectList objectList, DocumentList documentList, DocumentVersion version, ProjectParticipant signer, ReviewCycleNodeResult nodeResult, DigestCalculator dig) throws DigestCalculatorException {
        if (comments == null || comments.isEmpty()) {
            return null;
        }
        Network network = signer.getParticipation().getProject().getNetwork();
        Date resultDate = new Date(System.currentTimeMillis());
        for (int i = 0; i < comments.size(); ++i) {
            TemporaryReviewCyclePositionResultCommentGroup group = (TemporaryReviewCyclePositionResultCommentGroup)comments.get(i);
            List<TemporaryReviewCyclePositionResult> gComments = group.getComments();
            if (gComments == null) continue;
            for (int j = 0; j < gComments.size(); ++j) {
                TemporaryReviewCyclePositionResult tRes = gComments.get(j);
                if (tRes.getComment() == null) continue;
                ReviewCyclePositionResult res = null;
                if (tRes.getReviewCyclePositionResultId() == null) {
                    ReviewCyclePositionResult originalResult = this.reviewCyclePositionResultDAO.get(tRes.getReferenceId());
                    res = new ReviewCyclePositionResultImpl();
                    res.setActiveObjectList(objectList);
                    res.setActiveDocumentList(documentList);
                    res.setComment(tRes.getComment());
                    res.setDocumentVersion(version);
                    if (tRes.getOverridingProjectParticipantId() != null) {
                        ReviewCyclePositionReleaseImpl posRel = this.reviewCyclePositionDAO.getReleased(tRes.getReviewCyclePositionId());
                        res.setProjectParticipant(posRel.getProjectParticipation().getMainParticipant());
                    } else {
                        res.setProjectParticipant(signer);
                    }
                    res.setRealm(originalResult.getRealm());
                    res.setResultDate(resultDate);
                    res.setReviewCycleNode(nodeResult.getReviewCycleNode());
                    res.setReviewCycleNodeResult(nodeResult);
                    res.setCommentReference(originalResult);
                    res = (ReviewCyclePositionResultImpl)this.reviewCyclePositionResultDAO.save(res);
                    tRes.setReviewCyclePositionId(res.getId());
                } else {
                    res = this.reviewCyclePositionResultDAO.get(tRes.getReviewCyclePositionResultId());
                    res.setActiveObjectList(objectList);
                    res.setActiveDocumentList(documentList);
                    res.setComment(tRes.getComment());
                    res.setDocumentVersion(version);
                    res.setProjectParticipant(signer);
                    res.setResultDate(resultDate);
                    res.setReviewCycleNode(nodeResult.getReviewCycleNode());
                    res.setReviewCycleNodeResult(nodeResult);
                    this.reviewCyclePositionResultDAO.update(res);
                }
                ArrayList<Attachment> att2Delete = new ArrayList<Attachment>();
                if (!(res.getComment() != null && res.getComment().length() != 0 || res.getReviewCycleCommentOption() != null || this.attachmentOperations.isRedliningAttachmentExistent(res.getId()))) {
                    this.reviewCyclePositionResultDAO.delete(res);
                    continue;
                }
                if (res.getAttachments() != null) {
                    for (Attachment attachment : res.getAttachments().values()) {
                        if (attachment.getFileName() == null || attachment.getFileName().length() == 0) {
                            att2Delete.add(attachment);
                            continue;
                        }
                        this.attachmentOperations.updateFileDigest(attachment, network);
                    }
                }
                for (Attachment attachment : att2Delete) {
                    res.getAttachments().remove(attachment.getId());
                    this.attachmentOperations.deleteAttachment(attachment.getId());
                }
                res.setDigestCalculatorType(this.digestCalculatorDAO.get(dig.getClass().getName()));
                res.setDigest(dig.getDigest(res));
            }
        }
        return comments;
    }

    @Override
    public List saveOrUpdateReviewPositionCommentResult(List comments, ProjectParticipant signer, DocumentVersionTask task, ProjectParticipant overriddenProjectParticipant) {
        DocumentVersion version = task.getDocumentVersion();
        ReleasedObjectList activeObjectList = version.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        ReleasedDocumentList activeDocumentList = version.getDocument().getDocumentList().getSubProject().getActiveDocumentList();
        ReviewCycleNode actualNode = version.getActualReviewCycleNode();
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(actualNode, version);
        return this.saveOrUpdateReviewPositionCommentResults(comments, activeObjectList, activeDocumentList, version, signer, nodeResult, overriddenProjectParticipant);
    }

    @Override
    public ReviewCyclePositionResult saveReviewPositionResult(TemporaryReviewCyclePositionResult tRes, ProjectParticipant signer, DocumentVersion version) {
        ReleasedObjectList objectList = version.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        ReleasedDocumentList documentList = version.getDocument().getDocumentList().getSubProject().getActiveDocumentList();
        ReviewCycleNode actualNode = version.getActualReviewCycleNode();
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(actualNode, version);
        return this.saveOrUpdateReviewCyclePositionResult(objectList, documentList, version, tRes, nodeResult, signer, null);
    }

    @Override
    public ReviewCyclePositionResult saveReviewPositionAndNodeResult(TemporaryReviewCyclePositionResult tRes, ProjectParticipant signer, DocumentVersion version, ReviewCycleNode node) {
        ReleasedObjectList objectList = version.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        ReleasedDocumentList documentList = version.getDocument().getDocumentList().getSubProject().getActiveDocumentList();
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(node, version);
        if (nodeResult == null) {
            nodeResult = this.insertReviewCycleNodeResult(version, node, objectList, this.reviewCycleCellResultDAO.get(version.getActualReviewCycleNode().getReviewCycleCell().getId(), version.getId()));
        }
        if (nodeResult == null) {
            I18n i18n = I18nFactory.getI18n(new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale()));
            throw new ActionException(i18n.tr("Es konnte kein Knotenresultat generiert werden"));
        }
        return this.saveOrUpdateReviewCyclePositionResult(objectList, documentList, version, tRes, nodeResult, signer, null);
    }

    public List saveOrUpdateReviewPositionCommentResults(List comments, ReleasedObjectList objectList, DocumentList documentList, DocumentVersion version, ProjectParticipant signer, ReviewCycleNodeResult nodeResult, ProjectParticipant overriddenParticipant) {
        if (comments == null || comments.isEmpty()) {
            return null;
        }
        Date now = Calendar.getInstance().getTime();
        for (int i = 0; i < comments.size(); ++i) {
            TemporaryReviewCyclePositionResultCommentGroup group = (TemporaryReviewCyclePositionResultCommentGroup)comments.get(i);
            List<TemporaryReviewCyclePositionResult> gComments = group.getComments();
            if (gComments == null) continue;
            for (int j = 0; j < gComments.size(); ++j) {
                TemporaryReviewCyclePositionResult tRes = gComments.get(j);
                if (tRes.getComment() == null) continue;
                if (tRes.getReviewCyclePositionResultId() == null) {
                    ReviewCyclePositionResult originalResult = this.reviewCyclePositionResultDAO.get(tRes.getReferenceId());
                    ReviewCyclePositionResultImpl res = new ReviewCyclePositionResultImpl();
                    res.setActiveObjectList(objectList);
                    res.setActiveDocumentList(documentList);
                    res.setComment(tRes.getComment());
                    res.setDocumentVersion(version);
                    if (tRes.getOverridingProjectParticipantId() != null) {
                        res.setProjectParticipant(overriddenParticipant);
                    } else {
                        res.setProjectParticipant(signer);
                    }
                    res.setRealm(originalResult.getRealm());
                    res.setResultDate(now);
                    res.setReviewCycleNode(nodeResult.getReviewCycleNode());
                    res.setReviewCycleNodeResult(nodeResult);
                    res.setCommentReference(originalResult);
                    if (tRes.getOverridingProjectParticipantId() != null) {
                        res.setOverridingProjectParticipant(this.projectParticipantDAO.get(tRes.getOverridingProjectParticipantId()));
                    }
                    if (tRes.getReviewCyleCommentOptionId() != null) {
                        res.setReviewCycleCommentOption(this.reviewCycleCommentOptionDAO.get(tRes.getReviewCyleCommentOptionId()));
                    }
                    res = (ReviewCyclePositionResultImpl)this.reviewCyclePositionResultDAO.save(res);
                    tRes.setReviewCyclePositionId(res.getId());
                    continue;
                }
                ReviewCyclePositionResult res = this.reviewCyclePositionResultDAO.get(tRes.getReviewCyclePositionResultId());
                res.setActiveObjectList(objectList);
                res.setActiveDocumentList(documentList);
                res.setComment(tRes.getComment());
                res.setDocumentVersion(version);
                if (tRes.getOverridingProjectParticipantId() != null) {
                    res.setProjectParticipant(overriddenParticipant);
                } else {
                    res.setProjectParticipant(signer);
                }
                res.setResultDate(now);
                res.setReviewCycleNode(nodeResult.getReviewCycleNode());
                res.setReviewCycleNodeResult(nodeResult);
                if (tRes.getReviewCyleCommentOptionId() != null) {
                    res.setReviewCycleCommentOption(this.reviewCycleCommentOptionDAO.get(tRes.getReviewCyleCommentOptionId()));
                }
                this.reviewCyclePositionResultDAO.update(res);
            }
        }
        return comments;
    }

    @Override
    public ReviewCyclePositionResult getReviewCyclePositionResult2(ReviewCyclePosition pos, DocumentVersion version, Integer reviewCycleNodeResultId) {
        List posResults = this.reviewCyclePositionResultDAO.getUnsigned(pos.getRealm(), pos.getReviewCycleNodeInstance().getReviewCycleNode(), version, pos.getProjectParticipation(), reviewCycleNodeResultId);
        if (posResults.size() == 0) {
            return null;
        }
        if (posResults.size() == 1) {
            return (ReviewCyclePositionResult)posResults.get(0);
        }
        int bestChoise = -1;
        int bestWeight = -1;
        for (int i = 0; i < posResults.size(); ++i) {
            ReviewCyclePositionResult posResult = (ReviewCyclePositionResult)posResults.get(i);
            int weight = 0;
            if (posResult.getReviewCycleResultOption() != null) {
                ++weight;
            }
            if (posResult.getComment() != null && posResult.getComment().length() > 0) {
                ++weight;
                if (posResult.getComment().length() > 100) {
                    ++weight;
                }
                if (bestChoise != -1 && posResults.get(bestChoise) != null && posResult.getComment().length() > ((ReviewCyclePositionResult)posResults.get(bestChoise)).getComment().length()) {
                    --bestWeight;
                }
            }
            if (posResult.getAttachments() != null && !posResult.getAttachments().isEmpty()) {
                ++weight;
            }
            for (Attachment att : posResult.getAttachments().values()) {
                if (!att.isRedliningDelta()) continue;
                weight += 2;
            }
            if (weight <= bestWeight) continue;
            bestChoise = i;
            bestWeight = weight;
        }
        if (posResults.size() > 1) {
            log.warn((Object)("ProjectParticipationId " + pos.getProjectParticipation().getId() + " has more than one [" + posResults.size() + "] reviewCyclePositionResults to documentVersionId [" + version.getId() + "]."));
        }
        for (int j = 0; j < posResults.size(); ++j) {
            ReviewCyclePositionResult pr = (ReviewCyclePositionResult)posResults.get(j);
            if (j == bestChoise) continue;
            log.info((Object)("Deleting reviewCyclePositionResult [id=" + pr.getId() + "] *******************"));
            log.info((Object)("comment=" + pr.getComment()));
            log.info((Object)("resultDate=" + pr.getResultDate()));
            log.info((Object)("reviewCycleResultOptionId=" + (pr.getReviewCycleResultOption() != null && pr.getReviewCycleResultOption().getId() != null ? pr.getReviewCycleResultOption().getId() : "null")));
            if (pr.getAttachments() != null && !pr.getAttachments().isEmpty()) {
                for (Attachment att : pr.getAttachments().values()) {
                    log.info((Object)("attachmentId=" + att.getId() + " fileName=" + att.getFileName()));
                    this.attachmentOperations.deleteAttachment(att.getId());
                }
            }
            this.reviewCyclePositionResultDAO.delete((ReviewCyclePositionResult)posResults.get(j));
            log.info((Object)("Deleted reviewCyclePositionResult [id=" + pr.getId() + "] *******************"));
        }
        return (ReviewCyclePositionResult)posResults.get(bestChoise);
    }

    @Override
    public ReviewCyclePositionResult getReviewCyclePositionResult3(ReviewCyclePositionResult reference, ProjectParticipation participation, ReviewCycleNode node) {
        List posResults = this.reviewCyclePositionResultDAO.getAllUnsigned(reference, participation, node);
        if (posResults.size() == 0) {
            return null;
        }
        if (posResults.size() == 1) {
            return (ReviewCyclePositionResult)posResults.get(0);
        }
        int bestChoise = -1;
        int bestWeight = -1;
        for (int i = 0; i < posResults.size(); ++i) {
            ReviewCyclePositionResult posResult = (ReviewCyclePositionResult)posResults.get(i);
            int weight = 0;
            if (posResult.getReviewCycleCommentOption() != null) {
                ++weight;
            }
            if (posResult.getComment() != null && posResult.getComment().length() > 0) {
                ++weight;
                if (posResult.getComment().length() > 100) {
                    ++weight;
                }
                if (bestChoise != -1 && posResults.get(bestChoise) != null && posResult.getComment().length() > ((ReviewCyclePositionResult)posResults.get(bestChoise)).getComment().length()) {
                    --bestWeight;
                }
            }
            if (posResult.getAttachments() != null && !posResult.getAttachments().isEmpty()) {
                ++weight;
            }
            for (Attachment att : posResult.getAttachments().values()) {
                if (!att.isRedliningDelta()) continue;
                weight += 2;
            }
            if (weight <= bestWeight) continue;
            bestChoise = i;
            bestWeight = weight;
        }
        if (posResults.size() > 1) {
            log.warn((Object)("ProjectParticipationId " + participation.getId() + " has more than one [" + posResults.size() + "] reviewCyclePositionResults to commentReference [" + reference.getId() + "]."));
        }
        for (int j = 0; j < posResults.size(); ++j) {
            ReviewCyclePositionResult pr = (ReviewCyclePositionResult)posResults.get(j);
            if (j == bestChoise) continue;
            log.info((Object)("Deleting reviewCyclePositionResult [id=" + pr.getId() + "] *******************"));
            log.info((Object)("comment=" + pr.getComment()));
            log.info((Object)("resultDate=" + pr.getResultDate()));
            log.info((Object)("reviewCycleCommentOptionId=" + (pr.getReviewCycleCommentOption() != null && pr.getReviewCycleCommentOption().getId() != null ? pr.getReviewCycleCommentOption().getId() : "null")));
            if (pr.getAttachments() != null && !pr.getAttachments().isEmpty()) {
                for (Attachment att : pr.getAttachments().values()) {
                    log.info((Object)("attachmentId=" + att.getId() + " fileName=" + att.getFileName()));
                    this.attachmentOperations.deleteAttachment(att.getId());
                }
            }
            this.reviewCyclePositionResultDAO.delete((ReviewCyclePositionResult)posResults.get(j));
            log.info((Object)("Deleted reviewCyclePositionResult [id=" + pr.getId() + "] *******************"));
        }
        return (ReviewCyclePositionResult)posResults.get(bestChoise);
    }

    @Override
    public List getReviewCyclePositionResults(ReviewCycleNodeResult dest, ReviewCycleNodeResult from) {
        return this.reviewCyclePositionResultDAO.getAll(dest, from);
    }

    public ReviewCycleCellResult generateNextCellResults(DocumentVersion newVersion, ReleasedObjectList objectList, ReviewCycleInstance instance) {
        ReviewCycleCellResult newCellResult = this.insertReviewCycleCellResult(newVersion, newVersion.getActualReviewCycleNode().getReviewCycleCell());
        ReviewCycleNodeResultImpl nodeResult = (ReviewCycleNodeResultImpl)this.insertReviewCycleNodeResult(newVersion, newVersion.getActualReviewCycleNode(), objectList, newCellResult);
        ReviewCycleNodeInstanceRelease nodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(instance.getId(), nodeResult.getReviewCycleNode().getId());
        List<ReviewCyclePosition> positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstance, newVersion);
        boolean skipNode = false;
        if (nodeInstance.getReviewCycleNode().getSkippingRule() != null && !nodeInstance.getReviewCycleNode().getSkippingRule().isEmpty()) {
            OrganisationPerson asBuiltContractorOrgPerson = null;
            ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)newVersion.getDocument().getObjectPlanner();
            if (objectPlanner.getAsBuiltReference() != null && objectPlanner.getAsBuiltReference().getContractor() != null) {
                asBuiltContractorOrgPerson = objectPlanner.getAsBuiltReference().getContractor().getMainParticipant().getOrganisationPerson();
            }
            skipNode = this.reviewCycleInterpretationHelper.verifyReviewCycleNodeSkippingRule(nodeInstance, newVersion, asBuiltContractorOrgPerson);
        }
        if (nodeInstance == null || positions.isEmpty() || skipNode) {
            this.moveDocumentVersionToNextNode(nodeInstance, objectList, nodeResult, nodeResult.getDocumentVersion(), false);
        } else {
            this.taskOperations.generateReviewTasks(newVersion, nodeInstance, null, false, true);
        }
        return newCellResult;
    }

    public void finishReviewCycleCell(ReviewCycleCellResultImpl res, ReviewCycleResultOption opt) {
        res.setFinished(true);
        res.setReviewCycleResultOption(opt);
        this.reviewCycleCellResultDAO.update(res);
    }

    @Override
    public boolean isNodeFinished(ReviewCycleNodeInstance nodeInstance, ReviewCycleNodeResult nodeResult, DocumentVersion version) {
        List<ReviewCyclePosition> positions;
        if (log.isDebugEnabled()) {
            log.debug((Object)"isNodeFinished()...");
        }
        if ((positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstance, version)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No ReviewCyclePositions found, method isNodeFinished() will return true");
            }
            return true;
        }
        ReviewCycleNode node = nodeInstance.getReviewCycleNode();
        boolean foundEmpty = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get ReviewCyclePositionResult(s) for ReviewCylceNode with Id [" + node.getId() + "]."));
        }
        for (ReviewCyclePosition pos : positions) {
            List res;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling ReviewCyclePositionResultDAO.getSigned() with following parameters:");
                log.debug((Object)("DocumentVersion Id is [" + version.getId() + "]."));
                log.debug((Object)("Parameters depending on ReviewCyclePosition with Id [" + pos.getId() + "]."));
                log.debug((Object)("Realm is [" + pos.getRealm().getDescription() + "] with Id [" + pos.getRealm().getId() + "]."));
                log.debug((Object)("ProjectParticipation with Id [" + pos.getProjectParticipation().getId() + "]."));
            }
            if ((res = this.reviewCyclePositionResultDAO.getAllSigned(pos.getRealm().getId(), node.getId(), version.getId(), pos.getProjectParticipation().getId())) != null && res.size() != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Result was [null], method isNodeFinished() will return false");
            }
            foundEmpty = true;
            break;
        }
        return !foundEmpty;
    }

    @Override
    public boolean isNodeFinishedConsideringNodeResult(ReviewCycleNodeInstance nodeInstance, ReviewCycleNodeResult nodeResult, DocumentVersion version) {
        boolean isSerialNodeTypeWithResult;
        if (log.isDebugEnabled()) {
            log.debug((Object)"isNodeFinished()...");
        }
        List<ReviewCyclePosition> positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstance, version);
        Map existingPosResults = nodeResult.getReviewCycleNodePositionResults();
        int numberOfexistingPosResults = 0;
        if (existingPosResults != null) {
            numberOfexistingPosResults = existingPosResults.size();
        }
        boolean bl = isSerialNodeTypeWithResult = numberOfexistingPosResults > 0 && (nodeInstance.getReviewCycleNode().getReviewType() == 1 || nodeInstance.getReviewCycleNode().getReviewType() == 2);
        if (positions == null || positions.isEmpty() || isSerialNodeTypeWithResult) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No ReviewCyclePositions found or isSerialNodeType with existing result, method isNodeFinished() will return true");
            }
            return true;
        }
        ReviewCycleNode node = nodeInstance.getReviewCycleNode();
        boolean foundEmpty = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get ReviewCyclePositionResult(s) for ReviewCylceNode with Id [" + node.getId() + "]."));
        }
        for (ReviewCyclePosition pos : positions) {
            ReviewCyclePositionResult res;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling ReviewCyclePositionResultDAO.getSigned() with following parameters:");
                log.debug((Object)("DocumentVersion Id is [" + version.getId() + "]."));
                log.debug((Object)("Parameters depending on ReviewCyclePosition with Id [" + pos.getId() + "]."));
                log.debug((Object)("Realm is [" + pos.getRealm().getDescription() + "] with Id [" + pos.getRealm().getId() + "]."));
                log.debug((Object)("ProjectParticipation with Id [" + pos.getProjectParticipation().getId() + "]."));
            }
            if ((res = this.reviewCyclePositionResultDAO.getSigned(pos.getRealm().getId(), node.getId(), version.getId(), pos.getProjectParticipation().getId(), nodeResult.getId())) != null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Result was [null], method isNodeFinished() will return false");
            }
            foundEmpty = true;
            break;
        }
        return !foundEmpty;
    }

    private ReviewCycleResultOption calculateNodeResult(ReviewCycleNodeInstance nodeInstance, ReviewCycleNodeResult nodeResult, DocumentVersion version) {
        boolean skipNode = false;
        OrganisationPerson asBuiltContractorOrgPerson = null;
        ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)version.getDocument().getObjectPlanner();
        if (objectPlanner.getAsBuiltReference() != null && objectPlanner.getAsBuiltReference().getContractor() != null) {
            asBuiltContractorOrgPerson = objectPlanner.getAsBuiltReference().getContractor().getMainParticipant().getOrganisationPerson();
        }
        skipNode = this.reviewCycleInterpretationHelper.verifyReviewCycleNodeSkippingRule(nodeInstance, version, asBuiltContractorOrgPerson);
        List<ReviewCyclePosition> positions = null;
        if (nodeInstance != null) {
            positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstance, version);
        }
        if (positions == null || positions.isEmpty() || skipNode) {
            ReviewCycleResultOption opt = nodeResult.getReviewCycleNode().getReviewCycleCell().getReviewCycle().getEmptyNodeOption();
            if (opt == null) {
                return null;
            }
            return opt;
        }
        List reviews = this.reviewCyclePositionResultDAO.getAll(nodeInstance.getReviewCycleNode(), version);
        Iterator<ReviewCyclePosition> it = positions.iterator();
        Map resultOptions = nodeInstance.getReviewCycleNode().getReviewCyclePositionType().getReviewCycleResultOptions();
        if (resultOptions == null) {
            return null;
        }
        Iterator opIt = resultOptions.values().iterator();
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        while (opIt.hasNext()) {
            results.put(((ReviewCycleResultOption)opIt.next()).getId(), 0);
        }
        while (it.hasNext()) {
            ReviewCyclePosition pos = it.next();
            for (int i = 0; i < reviews.size(); ++i) {
                ReviewCyclePositionResult res = (ReviewCyclePositionResult)reviews.get(i);
                if (res.getReviewCycleResultOption() == null || res.getRealm() == null || !pos.getRealm().getId().equals(res.getRealm().getId()) || !pos.getProjectParticipation().getId().equals(res.getProjectParticipant().getParticipation().getId())) continue;
                if (res.getReviewCycleResultOption().isFinishCell()) {
                    return res.getReviewCycleResultOption();
                }
                if (!results.containsKey(res.getReviewCycleResultOption().getId())) {
                    results.put(res.getReviewCycleResultOption().getId(), 0);
                }
                int count = (Integer)results.get(res.getReviewCycleResultOption().getId());
                results.put(res.getReviewCycleResultOption().getId(), ++count);
            }
        }
        Iterator arrIt = results.keySet().iterator();
        Integer index = null;
        while (arrIt.hasNext()) {
            Integer id = (Integer)arrIt.next();
            if (index != null && (Integer)results.get(index) >= (Integer)results.get(id)) continue;
            index = id;
        }
        if (index == null) {
            return null;
        }
        return this.reviewCycleResultOptionDAO.get(index);
    }

    private void setDocumentVersionStatus(DocumentVersion version, ReviewCycleResultOption opt, ReleasedObjectList objectList) {
        if (opt == null || opt.getDocumentVersionStatus() == null) {
            return;
        }
        if (opt.getDocumentVersionStatus() > 0) {
            DocumentVersionStatusChange change = new DocumentVersionStatusChange();
            GregorianCalendar now = new GregorianCalendar();
            change.setChangeDate(now);
            change.setDocumentVersionId(version.getId());
            change.setFileName(version.getFileName());
            change.setName(version.getName());
            change.setOldStatus(version.getStatus());
            change.setNewStatus(opt.getDocumentVersionStatus());
            this.documentVersionDAO.saveStatusChange(change);
            version.setStatus(opt.getDocumentVersionStatus());
            this.documentVersionDAO.update(version);
            ReleasedObjectPlanner op = this.objectPlannerDAO.getReleasedObjectPlanner(objectList.getId(), version.getDocument().getObjectPlanner().getId());
            this.createObjectPlannerDefinitionEMailSnippets(version, op, now);
        }
    }

    public void finishReviewCycleNode(ReviewCycleNodeInstanceRelease nodeInstance, ReviewCycleNodeResultImpl nodeResult, ReleasedObjectList objectList, DocumentVersion version, ReviewCycleNodeInstance nextNodeInstance) {
        nodeResult.setDocumentDepartureDate(new Date(System.currentTimeMillis()));
        nodeResult.setFinished(true);
        nodeResult.setActiveObjectListOfDocumentDeparture(objectList);
        if (nodeResult.getReviewCycleResultOption() == null) {
            ReviewCycleResultOption opt = this.calculateNodeResult(nodeInstance, nodeResult, version);
            if (opt == null) {
                String msg = "It was not possible to calculate a NodeResult";
                log.error((Object)msg);
                throw new ActionException(msg);
            }
            nodeResult.setReviewCycleResultOption(opt);
        }
        this.firePostListenersEvent(version, nodeInstance, objectList);
        this.setDocumentVersionStatus(version, nodeResult.getReviewCycleResultOption(), objectList);
        this.reviewCycleNodeResultDAO.update(nodeResult);
        if (nextNodeInstance != null && nextNodeInstance.getReviewCycleNode().isEndNode()) {
            this.finishReviewCycleCell((ReviewCycleCellResultImpl)nodeResult.getReviewCycleCellResult(), nodeResult.getReviewCycleResultOption());
        }
    }

    public void firePreListenersEvent(DocumentVersion version, ReviewCycleNodeInstanceRelease nodeInstanceReleased, ReleasedObjectList objectList) {
        this.fireListenersEvent(version, nodeInstanceReleased, objectList, true);
    }

    public void firePostListenersEvent(DocumentVersion version, ReviewCycleNodeInstanceRelease nodeInstanceReleased, ReleasedObjectList objectList) {
        this.fireListenersEvent(version, nodeInstanceReleased, objectList, false);
    }

    private void fireListenersEvent(DocumentVersion version, ReviewCycleNodeInstanceRelease nodeInstanceReleased, ReleasedObjectList objectList, boolean pre_listener) {
        Collection<ReviewCycleNodeInstanceListener> listeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(version.getActualReviewCycleNodeInstance().getId());
        ObjectPlannerImpl op = (ObjectPlannerImpl)version.getDocument().getObjectPlanner();
        ReleasedObjectPlanner releasedObjectPlanner = this.objectPlannerDAO.getReleasedObjectPlanner(objectList.getId(), op.getId());
        for (ReviewCycleNodeInstanceListener listener : listeners) {
            ReviewCycleNodeListener type;
            ReviewCycleNodeActionListener listenerExecutor;
            if (pre_listener != listener.getReviewCycleNodeListener().isPreListener() || (listenerExecutor = this.listenerRegistry.lookupListener(type = listener.getReviewCycleNodeListener())) == null) continue;
            listenerExecutor.listen(new ReviewCycleNodeActionListenerProperty(listener, version, nodeInstanceReleased, releasedObjectPlanner));
        }
    }

    public ReviewCycleNodeResult insertReviewCycleNodeResult(DocumentVersion version, ReviewCycleNode node, ObjectList objectList, ReviewCycleCellResult cellResult) {
        ReviewCycleNodeResultImpl nodeResult = new ReviewCycleNodeResultImpl();
        nodeResult.setActiveObjectListOfDocumentArrival(objectList);
        nodeResult.setDocumentArrivalDate(new Date(System.currentTimeMillis()));
        nodeResult.setDocumentVersion(version);
        nodeResult.setFinished(false);
        nodeResult.setReviewCycleNode(node);
        nodeResult.setReviewCycleCellResult(cellResult);
        nodeResult.setReviewCycleResultOption(null);
        if (cellResult.getReviewCycleNodeResults() == null) {
            cellResult.setReviewCycleNodeResults(new HashMap());
        }
        nodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.save(nodeResult);
        cellResult.getReviewCycleNodeResults().put(nodeResult.getId(), nodeResult);
        this.reviewCycleCellResultDAO.update(cellResult);
        ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(objectList.getId(), version.getDocument().getObjectPlanner().getId());
        ReviewCycleNodeInstanceRelease nodeInstanceReleased = this.reviewCycleNodeInstanceDAO.getReleased(rop.getReviewCycleInstance().getId(), node.getId());
        this.firePreListenersEvent(version, nodeInstanceReleased, (ReleasedObjectList)objectList);
        return nodeResult;
    }

    public ReviewCycleCellResult insertReviewCycleCellResult(DocumentVersion version, ReviewCycleCell cell) {
        ReviewCycleCellResultImpl cellResult = new ReviewCycleCellResultImpl();
        cellResult.setDocumentArrivalDate(new Date(System.currentTimeMillis()));
        cellResult.setDocumentVersion(version);
        cellResult.setFinished(false);
        cellResult.setReviewCycleCell(cell);
        cellResult.setReviewCycleResultOption(null);
        return this.reviewCycleCellResultDAO.save(cellResult);
    }

    @Override
    public ProjectParticipant getSigner(Integer organisationPersonId, Integer projectId, String actionName) {
        Project pr;
        if (organisationPersonId == null) {
            return null;
        }
        if (projectId == null) {
            return null;
        }
        OrganisationPerson op = this.organisationPersonDAO.get(organisationPersonId);
        List pps = this.projectParticipantDAO.getAll(op, pr = this.projectDAO.get(projectId), true);
        if (pps == null || pps.isEmpty()) {
            return null;
        }
        if (actionName != null) {
            for (int i = 0; i < pps.size(); ++i) {
                ProjectParticipant part = (ProjectParticipant)pps.get(i);
                if (!part.getParticipation().getRole().hasAction(actionName) || part.isInactive()) continue;
                return part;
            }
        } else {
            for (ProjectParticipant pp : pps) {
                if (pp.isInactive()) continue;
                return pp;
            }
        }
        return null;
    }

    @Override
    public ProjectParticipant getSignerByParticipation(Integer organisationPersonId, Integer projectParticipationId) {
        if (projectParticipationId == null || organisationPersonId == null) {
            return null;
        }
        return this.projectParticipantDAO.get(projectParticipationId, organisationPersonId);
    }

    @Override
    public ProjectParticipant getSignerByPositionAndTaskId(Integer orgPersonId, Integer reviewCyclePositionId, Integer taskId) {
        Task task = this.taskOperations.getTask(taskId);
        if (task instanceof ReviewableTask) {
            return this.getSignerByTask(orgPersonId, reviewCyclePositionId, (ReviewableTask)task);
        }
        throw new ActionException("There was no ReviewableTask found for the given id [" + taskId + "].");
    }

    @Override
    public ProjectParticipant getSignerByTask(Integer organisationPersonId, Integer reviewCyclePositionId, ReviewableTask task) {
        ReviewCyclePositionRelease pos = null;
        if (task == null || task instanceof ReviewTask) {
            pos = this.reviewCyclePositionDAO.getReleased(reviewCyclePositionId);
        } else if (task instanceof AttachedReviewTask) {
            pos = this.reviewCyclePositionDAO.getAttached(reviewCyclePositionId);
        }
        if (pos == null) {
            String msg = "There was no ReviewCyclePosition found to the given id [" + reviewCyclePositionId + "].";
            log.error((Object)msg);
            throw new ActionException(msg);
        }
        OrganisationPerson organisationPerson = this.organisationPersonDAO.get(organisationPersonId);
        if (organisationPerson == null) {
            String msg = "There was no OrganisationPerson found to the given id [" + organisationPersonId + "].";
            log.error((Object)msg);
            throw new ActionException(msg);
        }
        return this.projectParticipantDAO.get(pos.getProjectParticipation().getId(), organisationPersonId);
    }

    @Override
    public List getPossibleUploads(Integer id, int filter) {
        return this.documentDAO.getUploadPossibilties(id, filter);
    }

    @Override
    public List getDocumentVersionsByFilter(Integer id, int filter) {
        if (filter == 3) {
            id = this.objectDAO.getReleasedCDESObject(id).getObject().getId();
            filter = 1;
        }
        return this.documentVersionDAO.getDocumentVersions(id, filter);
    }

    @Override
    public List<ReviewCyclePosition> getReviewRelevantPositions(ReviewCycleNodeInstance nodeInstance, DocumentVersion documentVersion) {
        return this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstance, documentVersion);
    }

    @Override
    public List<AttachedReviewCyclePositionImpl> getAttachedPositions(ReviewCycleNodeInstance nodeInstance, DocumentVersion documentVersion) {
        return this.reviewCycleNodeInstanceDAO.getAttachedReviewCyclePositions(nodeInstance, documentVersion);
    }

    @Override
    public List<AttachedReviewCyclePositionImpl> getAttachedPositionsByPP(ReviewCycleNodeInstance nodeInstance, ProjectParticipation pp) {
        return this.reviewCycleNodeInstanceDAO.getAttachedReviewCyclePositionsByPP(nodeInstance, pp);
    }

    @Override
    public ReviewCycleResultOption getReviewCycleResultOption(Integer id) {
        return this.reviewCycleResultOptionDAO.get(id);
    }

    @Override
    public DocumentImpl getDocument(Integer id) {
        return this.documentDAO.get(id);
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setUploadFileHandler(UploadFileHandler uploadFileHandler) {
        this.uploadFileHandler = uploadFileHandler;
    }

    public void setReviewCycleEntryResultDAO(ReviewCycleEntryResultDAO reviewCycleEntryResultDAO) {
        this.reviewCycleEntryResultDAO = reviewCycleEntryResultDAO;
    }

    public void setSignatureCalculatorFactory(SignatureCalculatorFactory signatureCalculatorFactory) {
        this.signatureCalculatorFactory = signatureCalculatorFactory;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setReviewCyclePositionDAO(ReviewCyclePositionDAO reviewCyclePositionDAO) {
        this.reviewCyclePositionDAO = reviewCyclePositionDAO;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setRealmDAO(RealmDAO realmDAO) {
        this.realmDAO = realmDAO;
    }

    public void setReviewCycleCellResultDAO(ReviewCycleCellResultDAO reviewCycleCellResultDAO) {
        this.reviewCycleCellResultDAO = reviewCycleCellResultDAO;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setReviewCyclePositionResultDAO(ReviewCyclePositionResultDAO reviewCyclePositionResultDAO) {
        this.reviewCyclePositionResultDAO = reviewCyclePositionResultDAO;
    }

    @Override
    public TemporaryDocumentVersion generateDocumentVersionNumber(Document document, ReviewCycleCell destination, TemporaryDocumentVersion tdv, Locale locale) {
        try {
            OgnlNumberCalculator ncalc = this.ognlNumberCalculator;
            if (document instanceof DocumentImpl && ((DocumentImpl)document).getAsBuiltReference() != null) {
                DocumentImpl asBuiltDocRef = this.documentDAO.get(((DocumentImpl)document).getAsBuiltReference().getId());
                DocumentVersion asBuiltDVRef = asBuiltDocRef.getLastDocumentVersion();
                tdv.setAsBuiltReference(asBuiltDVRef);
            } else if (document instanceof ReleasedDocument && ((ReleasedDocument)document).getDocument().getAsBuiltReference() != null) {
                DocumentImpl asBuiltDocRef = this.documentDAO.get(((ReleasedDocument)document).getDocument().getAsBuiltReference().getId());
                DocumentVersion asBuiltDVRef = asBuiltDocRef.getLastDocumentVersion();
                tdv.setAsBuiltReference(asBuiltDVRef);
            }
            tdv.setName(ncalc.getNumber(document, document.getDocumentList().getSubProject().getProject(), destination, (BaseDocumentVersion)tdv));
            tdv.setLastSeperator(ncalc.getLastSeperator(document, document.getDocumentList().getSubProject().getProject()));
            return tdv;
        }
        catch (NumberCalculatorException e) {
            I18n i18n = I18nFactory.getI18n(locale);
            throw new ActionException("Das Nummerpattern konnte nicht durchgef\u00fchrt werden", e);
        }
    }

    @Override
    public void updateDocumentVersionNames(Integer activeSubProjectId, ReviewCycleStatusSearch search, Locale locale) {
        SubProject sp = this.subProjectDAO.get(activeSubProjectId);
        I18n i18n = I18nFactory.getI18n(locale);
        List mappedResults = this.documentDAO.getCompactReviewStatus(sp.getActiveObjectList().getId(), sp.getActiveDocumentList() != null ? sp.getActiveDocumentList().getId() : -1, search, i18n, this.hibernateDialect, activeSubProjectId);
        for (Map result : mappedResults) {
            Integer documentId = (Integer)result.get("documentId");
            if (documentId == null) continue;
            this.updateDocumentVersionNamesOfDocument(documentId);
        }
    }

    @Override
    public void restoreDeletedDocument(Integer documentId) {
        CDESObjectImpl object;
        DocumentImpl document_init = this.documentDAO.get(documentId);
        ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)document_init.getObjectPlanner();
        if (objectPlanner != null && objectPlanner.isInactive()) {
            log.info((Object)("restoring invalid objectPlanner id=" + objectPlanner.getId()));
            objectPlanner.setInactive(false);
            this.objectPlannerDAO.update(objectPlanner);
        }
        if ((object = (CDESObjectImpl)objectPlanner.getObject()) != null && object.isInactive()) {
            log.info((Object)("restoring invalid object id=" + object.getId()));
            object.setInactive(false);
            this.objectDAO.update(object);
        }
        ArrayList<Object> documents = new ArrayList<Object>();
        boolean restoreAllobjectPlannersDocuments = false;
        int numberOfDocuments = 1;
        if (restoreAllobjectPlannersDocuments) {
            documents.addAll(objectPlanner.getDocuments().values());
            numberOfDocuments = documents.size();
        } else {
            documents.add(document_init);
        }
        int counter = 0;
        for (DocumentImpl documentImpl : documents) {
            ++counter;
            if (documentImpl.isInvalidated()) {
                log.info((Object)("restoring invalid document id=" + documentImpl.getId()));
                documentImpl.setInvalidated(false);
                this.documentDAO.update(documentImpl);
            }
            log.info((Object)("------ restoring document # " + counter + "/" + numberOfDocuments + " id=" + documentId + " name= " + documentImpl.getName()));
            DocumentVersion lastDocumentVersion = documentImpl.getLastDocumentVersion();
            boolean isLastDocumentVersion = false;
            if (lastDocumentVersion == null || lastDocumentVersion.getStatus() != 5) continue;
            Collection<DocumentVersion> documentVersions = documentImpl.getDocumentVersions().values();
            for (DocumentVersion documentVersion : documentVersions) {
                int documentVersionStatus;
                ReviewCyclePositionResult resultInvalidateDocument;
                log.info((Object)("restoring documentVersion id=" + documentVersion.getId() + " name= " + documentVersion.getName()));
                if (lastDocumentVersion.getId().equals(documentVersion.getId())) {
                    isLastDocumentVersion = true;
                }
                if ((resultInvalidateDocument = this.getLastReviewCyclePositionResultByOptionValue(documentVersion.getId(), -9)) != null) {
                    log.info((Object)("deleting resultInvalidateDocument id=" + resultInvalidateDocument.getId()));
                    this.reviewCyclePositionResultDAO.delete(resultInvalidateDocument);
                }
                ReviewCyclePositionResult resultInvalidateDocumentVersion = this.getLastReviewCyclePositionResultByOptionValue(documentVersion.getId(), -10);
                ReviewCycleResultOption documentVersionIsInvalidatedResultOption = null;
                boolean documentVersionIsInvalidated = resultInvalidateDocumentVersion != null;
                Integer documentVersionIsInvalidatedStatus = null;
                Date documentVersionIsInvalidatedDate = null;
                if (documentVersionIsInvalidated) {
                    documentVersionIsInvalidatedResultOption = resultInvalidateDocumentVersion.getReviewCycleResultOption();
                    documentVersionIsInvalidatedStatus = resultInvalidateDocumentVersion.getReviewCycleResultOption().getDocumentVersionStatus();
                    documentVersionIsInvalidatedDate = resultInvalidateDocumentVersion.getResultDate();
                }
                ReviewCycleCellResult reviewCycleCellResult = this.getReviewCycleCellResult(documentVersion.getActualReviewCycleNode().getReviewCycleCell().getId(), documentVersion.getId());
                boolean isEndCell = reviewCycleCellResult.getReviewCycleCell().isEndCell();
                List<ReviewCycleNodeResultImpl> nodeResults = this.reviewCycleNodeResultDAO.getAllSortedByPosition(documentVersion);
                ReviewCycleNodeResultImpl lastNodeResult = nodeResults.get(nodeResults.size() - 1);
                ReviewCycleNodeResultImpl lastValidNodeResult = null;
                for (int i = nodeResults.size() - 2; i >= 0; --i) {
                    if (nodeResults.get(i).getReviewCycleResultOption().getValue() == -8) continue;
                    lastValidNodeResult = nodeResults.get(i);
                    break;
                }
                boolean isOpenReview = false;
                if (lastNodeResult.getReviewCycleNode().isEndNode() && lastNodeResult.getReviewCycleResultOption() == null) {
                    isOpenReview = true;
                }
                if (lastNodeResult.getReviewCycleNode().isEndNode()) {
                    if (lastNodeResult.getReviewCycleResultOption() == null) {
                        log.info((Object)("deleting lastNodeResult id=" + lastNodeResult.getId()));
                        this.reviewCycleNodeResultDAO.delete(lastNodeResult);
                        lastValidNodeResult.setReviewCycleResultOption(null);
                        if (isLastDocumentVersion) {
                            lastValidNodeResult.setDocumentDepartureDate(null);
                            lastValidNodeResult.setActiveObjectListOfDocumentDeparture(null);
                            lastValidNodeResult.setFinished(false);
                        }
                        log.info((Object)("updaing lastValidNodeResult id=" + lastValidNodeResult.getId()));
                        this.reviewCycleNodeResultDAO.update(lastValidNodeResult);
                    } else if (documentVersionIsInvalidated) {
                        lastNodeResult.setReviewCycleResultOption(documentVersionIsInvalidatedResultOption);
                        lastNodeResult.setDocumentDepartureDate(documentVersionIsInvalidatedDate);
                        lastNodeResult.setFinished(true);
                        log.info((Object)("updaing lastNodeResult id=" + lastNodeResult.getId()));
                        this.reviewCycleNodeResultDAO.update(lastNodeResult);
                    } else {
                        lastNodeResult.setReviewCycleResultOption(null);
                        if (isLastDocumentVersion) {
                            lastNodeResult.setDocumentDepartureDate(null);
                            lastNodeResult.setActiveObjectListOfDocumentDeparture(null);
                            lastNodeResult.setFinished(false);
                        } else {
                            lastNodeResult.setDocumentDepartureDate(reviewCycleCellResult.getDocumentDepartureDate());
                        }
                        log.info((Object)("updaing lastNodeResult id=" + lastNodeResult.getId()));
                        this.reviewCycleNodeResultDAO.update(lastNodeResult);
                    }
                }
                if (isOpenReview) {
                    reviewCycleCellResult.setReviewCycleResultOption(null);
                    reviewCycleCellResult.setFinished(false);
                } else if (documentVersionIsInvalidated) {
                    reviewCycleCellResult.setReviewCycleResultOption(documentVersionIsInvalidatedResultOption);
                } else {
                    reviewCycleCellResult.setReviewCycleResultOption(lastValidNodeResult.getReviewCycleResultOption());
                    if (!isEndCell) {
                        reviewCycleCellResult.setFinished(false);
                    }
                }
                this.reviewCycleCellResultDAO.update(reviewCycleCellResult);
                ReviewCycleNodeInstanceImpl reviewCycleNodeInst = this.reviewCycleNodeInstanceDAO.getUnreleased(documentVersion.getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance(), lastValidNodeResult.getReviewCycleNode());
                if (isOpenReview) {
                    documentVersion.setActualReviewCycleNodeInstance(reviewCycleNodeInst);
                    documentVersionStatus = 1;
                } else {
                    documentVersionStatus = documentVersionIsInvalidated ? documentVersionIsInvalidatedStatus : (lastValidNodeResult.getReviewCycleResultOption().getDocumentVersionStatus() != null ? lastValidNodeResult.getReviewCycleResultOption().getDocumentVersionStatus() : 1);
                }
                documentVersion.setStatus(documentVersionStatus);
                this.documentVersionDAO.update(documentVersion);
                if (!isLastDocumentVersion || lastValidNodeResult == null || reviewCycleCellResult.isFinished() && (lastValidNodeResult.getReviewCycleResultOption() == null || !lastValidNodeResult.getReviewCycleResultOption().isFinishCell())) continue;
                if (lastValidNodeResult.getReviewCycleResultOption() != null && lastValidNodeResult.getReviewCycleResultOption().isFinishCell() || !isOpenReview && !isEndCell) {
                    log.info((Object)("restoring missing planner tasks for documentVersions id=" + documentVersion.getId() + " lastNodeResult id=" + lastNodeResult.getId()));
                    this.insertCreateMissingTasks(lastNodeResult.getId(), true, 0);
                    continue;
                }
                log.info((Object)("restoring missing tasks for documentVersions id=" + documentVersion.getId() + " lastValidNodeResult id=" + lastValidNodeResult.getId()));
                this.insertCreateMissingTasks(lastValidNodeResult.getId(), true, 0);
            }
        }
    }

    @Override
    public void updateDocumentVersionNamesOfDocument(Integer documentId) {
        DocumentImpl document = this.documentDAO.get(documentId);
        Document releasedOrImplDocument = null;
        if (document instanceof DocumentImpl) {
            releasedOrImplDocument = document.getLastReleasedOrImplDocument();
        }
        String documentName = releasedOrImplDocument.getName();
        Integer documentNumber = releasedOrImplDocument.getNumber();
        Collection<DocumentVersion> docVersions = releasedOrImplDocument.getAllDocumentVersions();
        OgnlNumberCalculator ncalc = this.ognlNumberCalculator;
        String seperator = "";
        try {
            seperator = ncalc.getLastSeperator(releasedOrImplDocument, releasedOrImplDocument.getDocumentList().getSubProject().getProject());
        }
        catch (NumberCalculatorException e) {
            e.printStackTrace();
        }
        for (DocumentVersion docVersion : docVersions) {
            String docVersionName = documentName + seperator + docVersion.getVersionPartA() + docVersion.getVersionPartSeperator() + docVersion.getVersionPartB();
            docVersion.setName(docVersionName);
            this.documentVersionDAO.update(docVersion);
        }
        if (releasedOrImplDocument instanceof DocumentImpl) {
            this.documentDAO.update((DocumentImpl)releasedOrImplDocument);
        } else {
            this.documentDAO.update((ReleasedDocument)releasedOrImplDocument);
        }
    }

    @Override
    public TemporaryDocumentVersion generateDocumentVersionNumber2(DocumentVersion oldVersion, ReviewCycleCellConnection connection, TemporaryDocumentVersion tdv, Locale locale) {
        ReviewCycleCellResult res = this.reviewCycleCellResultDAO.get(connection.getSourceCell().getId(), oldVersion.getId());
        try {
            OgnlNumberCalculator ncalc = this.ognlNumberCalculator;
            Project project = oldVersion.getDocument().getDocumentList().getSubProject().getProject();
            tdv.setName(ncalc.getNumber(connection, res, project, (BaseDocumentVersion)tdv));
            tdv.setLastSeperator(ncalc.getLastSeperator(oldVersion.getDocument(), project));
            return tdv;
        }
        catch (NumberCalculatorException e) {
            I18n i18n = I18nFactory.getI18n(locale);
            throw new ActionException("Das Nummerpattern konnte nicht durchgef\u00fchrt werden", e);
        }
    }

    @Override
    public ReviewCycleCellResult getReviewCycleCellResult(Integer reviewCycleCellId, Integer documentVersionId) {
        return this.reviewCycleCellResultDAO.get(reviewCycleCellId, documentVersionId);
    }

    @Override
    public List<ReviewCycleCellResult> getReviewCycleCellResults(Document document) {
        Collection<DocumentVersion> versions = document.getDocumentVersions().values();
        ArrayList<ReviewCycleCellResult> ret = new ArrayList<ReviewCycleCellResult>(versions.size());
        for (DocumentVersion dv : versions) {
            ret.add(this.getReviewCycleCellResult(dv.getActualReviewCycleNode().getReviewCycleCell().getId(), dv.getId()));
        }
        return ret;
    }

    public void setReviewCycleCellConnectionResultDAO(ReviewCycleCellConnectionResultDAO reviewCycleCellConnectionResultDAO) {
        this.reviewCycleCellConnectionResultDAO = reviewCycleCellConnectionResultDAO;
    }

    public void setReviewCycleCellConnectionEvaluator(ReviewCycleCellConnectionEvaluator reviewCycleCellConnectionEvaluator) {
        this.reviewCycleCellConnectionEvaluator = reviewCycleCellConnectionEvaluator;
    }

    public void setReviewCycleCellConnectionDAO(ReviewCycleCellConnectionDAO reviewCycleCellConnectionDAO) {
        this.reviewCycleCellConnectionDAO = reviewCycleCellConnectionDAO;
    }

    public void setOgnlNumberCalculator(OgnlNumberCalculator numberCalculatorFactory) {
        this.ognlNumberCalculator = numberCalculatorFactory;
    }

    public void setReviewCycleCellInstanceDAO(ReviewCycleCellInstanceDAO reviewCycleCellInstanceDAO) {
        this.reviewCycleCellInstanceDAO = reviewCycleCellInstanceDAO;
    }

    public void setTaskOperations(TaskOperations taskOperations) {
        this.taskOperations = taskOperations;
    }

    public void setObjectOperations(ObjectOperations objectOperations) {
        this.objectOperations = objectOperations;
    }

    @Override
    public ReviewCyclePosition getReviewCyclePositionByNodeInstancePpRealm(ReviewCycleNodeInstance nodeInstance, Integer projectParticipationId, Integer realmId) {
        return this.reviewCyclePositionDAO.getByNodeInstancePpRealm(nodeInstance, projectParticipationId, realmId);
    }

    @Override
    public ReviewCyclePositionResult getReviewCyclePositionResult(Integer id) {
        return this.reviewCyclePositionResultDAO.get(id);
    }

    public ProjectParticipationDAO getProjectParticipationDAO() {
        return this.projectParticipationDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setReviewCycleInstanceDAO(ReviewCycleInstanceDAO reviewCycleInstanceDAO) {
        this.reviewCycleInstanceDAO = reviewCycleInstanceDAO;
    }

    public void setAttachmentOperations(AttachmentOperations attachmentOperations) {
        this.attachmentOperations = attachmentOperations;
    }

    @Override
    public ReviewCycleNodeInstanceRelease getReleasedReviewCycleNodeInstance3(Integer reviewCycleNodeId, Integer actualReviewCycleReleaseId) {
        return this.reviewCycleNodeInstanceDAO.getReleased(actualReviewCycleReleaseId, reviewCycleNodeId);
    }

    @Override
    public ReviewCycleCellInstanceRelease getReleasedReviewCycleCellInstance(Integer reviewCycleCellId, Integer reviewCycleInstanceReleaseId) {
        return this.reviewCycleCellInstanceDAO.getReleased(reviewCycleInstanceReleaseId, reviewCycleCellId);
    }

    public void setObjectDAO(ObjectDAO objectDAO) {
        this.objectDAO = objectDAO;
    }

    public void setReviewCycleCommentOptionDAO(ReviewCycleCommentOptionDAO reviewCycleCommentOptionDAO) {
        this.reviewCycleCommentOptionDAO = reviewCycleCommentOptionDAO;
    }

    @Override
    public ReviewCycleCellConnectionResult getReviewCycleCellConnectionResult(Integer id) {
        return this.reviewCycleCellConnectionResultDAO.get(id);
    }

    @Override
    public ReviewCycleCellConnectionResult getReviewCycleCellConnectionResultByDocumentVersion(Integer documentVersionId) {
        return this.reviewCycleCellConnectionResultDAO.getByDestinationDocumentVersion(documentVersionId);
    }

    @Override
    public ReviewCycleEntryResult getReviewCycleEntryResult(Integer id) {
        return this.reviewCycleEntryResultDAO.get(id);
    }

    @Override
    public ReviewCycleEntryResult getReviewCycleEntryResultByDocumentVersion(Integer documentVersionId) {
        return this.reviewCycleEntryResultDAO.getByDocumentVersion(documentVersionId);
    }

    @Override
    public ReviewCycleEntryStatementResult getReviewCycleEntryStatementResult(Integer id) {
        return this.reviewCycleEntryResultDAO.getStatementResult(id);
    }

    @Override
    public ReviewCycleCellConnectionStatementResult getReviewCycleCellConnectionStatementResult(Integer id) {
        return this.reviewCycleCellConnectionResultDAO.getStatementResult(id);
    }

    public void setListenerRegistry(ReviewCycleNodeActionListenerRegistry listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public List getReviewCycleStatusTOs(Integer activeSubProjectId, ReviewCycleStatusSearch search, Locale locale) {
        if (this.reviewCycleStatusSearchInterpreter == null) {
            this.reviewCycleStatusSearchInterpreter = new ReviewCycleStatusSearchInterpreter();
        }
        boolean mustHaveDocumentVersions = search.getReviewCycleCellId() != null || search.getReviewCycleCellId2() != null || search.getReviewCycleNodeId() != null || search.getReviewCycleNodeId2() != null;
        I18n i18n = I18nFactory.getI18n(locale);
        HolidayCalculator hc = this.holidayCalculatorFactory.getInstance(this.projectDAO.get(search.getProjectId()));
        List documents = this.documentDAO.getDocumentsForReviewStatus(activeSubProjectId, search.getUploadedFrom(), search.getUploadedTo(), search.getDocumentTypeId(), search.getObjectId(), mustHaveDocumentVersions, search.isWithInactivatedObjects());
        if (documents == null) {
            return null;
        }
        ArrayList<ReviewCycleStatusTO> res = new ArrayList<ReviewCycleStatusTO>();
        for (DocumentImpl doc : documents) {
            boolean selected = false;
            DocumentVersion version = doc.getLastDocumentVersion();
            if (version != null && version.getRevisedDocumentVersion() != null && version.getRevisedDocumentVersion().getStatus() != 4 && (version.getStatus() == 4 || version.getStatus() == 7 || version.getStatus() == 5 || search.getDocumentStatus() == 2)) {
                version = version.getRevisedDocumentVersion();
            }
            if (search != null) {
                selected = version != null ? this.reviewCycleStatusSearchInterpreter.checkDocumentVersion(version, search, this.taskOperations, this, hc) : this.reviewCycleStatusSearchInterpreter.checkDocument(doc, search, this.taskOperations, hc);
            }
            if (!selected && search != null) continue;
            res.add(this.createReviewCycleStatusTO(doc, version, i18n, false));
            if (version == null || version.getRevisedDocumentVersion() == null || version.getRevisedDocumentVersion().getStatus() == 4 || search.getDocumentStatus() == 1) continue;
            res.add(this.createReviewCycleStatusTO(doc, version.getRevisedDocumentVersion(), i18n, true));
        }
        return res;
    }

    private ReviewCycleStatusTO createReviewCycleStatusTO(DocumentImpl document, DocumentVersion documentVersion, I18n i18n, boolean isRevisedVersion) {
        SubProject sp = document.getDocumentList().getSubProject();
        SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-dd");
        ReleasedObjectPlanner releasedPlanner = this.objectOperations.getReleasedObjectPlannerFromActiveObjectList(document.getObjectPlanner().getId(), sp.getId());
        if (releasedPlanner == null && ((ObjectPlannerImpl)document.getObjectPlanner()).isInactive()) {
            releasedPlanner = this.objectOperations.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(document.getObjectPlanner().getId(), sp.getId());
        }
        String objectPlannerText = "";
        if (releasedPlanner == null) {
            objectPlannerText = "n/a";
        } else {
            objectPlannerText = objectPlannerText + releasedPlanner.getCode();
            if (releasedPlanner.getReviewCycleInstance() != null) {
                objectPlannerText = objectPlannerText + "[" + releasedPlanner.getReviewCycleInstance().getName() + "]";
            }
            if (releasedPlanner.getPlanner() != null) {
                objectPlannerText = objectPlannerText + "\n" + releasedPlanner.getPlanner().getOrganisation().getName();
            }
            if (releasedPlanner.getObjectPlanner().isInactive()) {
                objectPlannerText = objectPlannerText + "(" + i18n.tr("gel\u00f6scht") + "!)";
            }
        }
        Date effectiveEndDate = null;
        if (documentVersion != null && documentVersion.getStatus() == 2) {
            ReviewCyclePositionResult latestPositionResult = this.reviewCyclePositionResultDAO.getLatestPositionResultOfDocumentVersion(documentVersion.getId());
            if (latestPositionResult == null) {
                ReviewCycleNodeResult nodeResult = this.getReviewCycleNodeResult(documentVersion.getActualReviewCycleNode(), documentVersion);
                if (nodeResult != null) {
                    effectiveEndDate = nodeResult.getDocumentArrivalDate();
                }
            } else if (latestPositionResult.getReviewCycleResultOption() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus().equals(2)) {
                effectiveEndDate = latestPositionResult.getResultDate();
            }
        }
        String statusText = "";
        if (documentVersion != null) {
            statusText = statusText + DocumentTranslator.getStatusName(i18n, documentVersion.getStatus());
            if (effectiveEndDate != null) {
                statusText = statusText + "[" + df.format(effectiveEndDate) + "]";
            }
            ReviewCycleNode activeNode = documentVersion.getActualReviewCycleNode();
            ReleasedDocument relDoc = null;
            ReleasedDocumentList relDocList = document.getDocumentList().getSubProject().getActiveDocumentList();
            if (relDocList != null) {
                relDoc = this.documentDAO.getReleased(document.getId(), relDocList.getId());
            }
            if (!documentVersion.isInvalidatedAll() && (!activeNode.isEndOfReviewCycle() || activeNode.isEndOfReviewCycle() && documentVersion.isInAction()) || documentVersion.getUploaded() != null && relDoc != null && relDoc.getStartDate() != null) {
                statusText = statusText + activeNode.getReviewCycleCell().getName() + " - " + activeNode.getName();
            }
            if (!documentVersion.getId().equals(document.getLastDocumentVersion().getId())) {
                statusText = statusText + "(" + i18n.tr("freigegebene Version weiterhin g\u00fcltig") + ")";
            }
        } else {
            statusText = statusText + DocumentTranslator.getDocumentStatus(i18n, document);
        }
        ReviewCycleStatusTO statusTO = new ReviewCycleStatusTO();
        statusTO.setEntryId(isRevisedVersion ? document.getId() * -1 : document.getId());
        statusTO.setDocumentId(document.getId());
        statusTO.setObjectPlannerText(objectPlannerText);
        statusTO.setStatusText(statusText);
        statusTO.setContent(document.getContent());
        statusTO.setDocumentNumber(document.getNumber());
        statusTO.setReleasedVersionOfRevision(isRevisedVersion);
        if (documentVersion != null) {
            statusTO.setStatus(documentVersion.getStatus());
            statusTO.setDocumentVersionId(documentVersion.getId());
            statusTO.setName(documentVersion.getName());
            statusTO.setUploadDate(df.format(documentVersion.getUploaded()));
        } else {
            statusTO.setStatus(11);
            statusTO.setName(document.getName());
        }
        if (releasedPlanner != null) {
            statusTO.setFromDeletedObjectPlanner(releasedPlanner.getObjectPlanner().isInactive());
            statusTO.setReleasedObjectId(releasedPlanner.getObject().getId());
            statusTO.setReleasedObjectPlannerId(releasedPlanner.getId());
        }
        return statusTO;
    }

    @Override
    public ReviewCycleStatusTO getReviewCycleStatusTO(Integer documentId, Locale locale) {
        I18n i18n = I18nFactory.getI18n(locale);
        DocumentImpl doc = this.getDocument(documentId > 0 ? documentId : documentId * -1);
        if (documentId < 0 && doc.getLastDocumentVersion() != null && doc.getLastDocumentVersion().getRevisedDocumentVersion() != null) {
            DocumentVersion revisedVersion = doc.getLastDocumentVersion().getRevisedDocumentVersion();
            return this.createReviewCycleStatusTO(doc, revisedVersion, i18n, true);
        }
        return this.createReviewCycleStatusTO(doc, doc.getLastDocumentVersion(), i18n, false);
    }

    @Override
    public Collection<ReviewCycleStatusListEntry> getReviewCycleStatus(Integer activeSubProjectId, ReviewCycleStatusSearch search, Integer activeDocumentListId, Locale locale) {
        if (this.reviewCycleStatusSearchInterpreter == null) {
            this.reviewCycleStatusSearchInterpreter = new ReviewCycleStatusSearchInterpreter();
        }
        long from = System.currentTimeMillis();
        ArrayList documents = new ArrayList();
        if (search.getObjectId() != null && !Integer.valueOf(0).equals(search.getObjectId())) {
            documents.addAll(this.documentDAO.getUploaded(search.getObjectId(), 1, search.isUseReleaseDate() ? null : search.getUploadedFrom(), search.isUseReleaseDate() ? null : search.getUploadedTo(), search.getDocumentTypeId(), search.getProjectParticipationId(), activeDocumentListId, search.isWithInactivatedObjects()));
        } else {
            documents.addAll(this.documentDAO.getUploaded(activeSubProjectId, 0, search.isUseReleaseDate() ? null : search.getUploadedFrom(), search.isUseReleaseDate() ? null : search.getUploadedTo(), search.getDocumentTypeId(), search.getProjectParticipationId(), activeDocumentListId, search.isWithInactivatedObjects()));
        }
        long until = System.currentTimeMillis();
        System.setProperty("REVIEWSTATUSDURATION", "[" + (until - from) + "ms]");
        if (documents == null) {
            return null;
        }
        I18n i18n = I18nFactory.getI18n(locale);
        HolidayCalculator hc = this.holidayCalculatorFactory.getInstance(this.projectDAO.get(search.getProjectId()));
        ArrayList<ReviewCycleStatusListEntry> res = new ArrayList<ReviewCycleStatusListEntry>();
        for (Document doc : documents) {
            boolean selected = false;
            DocumentVersion version = doc.getLastDocumentVersion();
            DocumentVersion lastRevision = null;
            if (version != null && version.getRevisedDocumentVersion() != null && version.getRevisedDocumentVersion().getStatus() != 4 && (version.getStatus() == 4 || version.getStatus() == 7 || version.getStatus() == 5 || search.getDocumentStatus() == 2)) {
                lastRevision = version;
                version = version.getRevisedDocumentVersion();
            }
            if (search != null) {
                if (version != null) {
                    selected = this.reviewCycleStatusSearchInterpreter.checkDocumentVersion(version, search, this.taskOperations, this, hc);
                    if (!selected && lastRevision != null && (selected = this.reviewCycleStatusSearchInterpreter.checkDocumentVersion(lastRevision, search, this.taskOperations, this, hc))) {
                        version = lastRevision;
                    }
                } else {
                    selected = this.reviewCycleStatusSearchInterpreter.checkDocument(doc, search, this.taskOperations, hc);
                }
            }
            if (!selected && search != null) continue;
            ReviewCycleStatusListEntry entry = new ReviewCycleStatusListEntry();
            entry.setId(doc.getId());
            if (doc instanceof DocumentImpl) {
                entry.setDocument(doc);
                entry.setReleasedDocument(null);
            } else {
                entry.setDocument(((ReleasedDocument)doc).getDocument());
                entry.setReleasedDocument((ReleasedDocument)doc);
            }
            entry.setDocumentVersion(version);
            if (version != null) {
                entry.setDocumentStatus(DocumentTranslator.getStatusName(i18n, version.getStatus()));
            } else {
                entry.setDocumentStatus(DocumentTranslator.getDocumentStatus(i18n, doc));
            }
            if (doc instanceof DocumentImpl && ((DocumentImpl)doc).isInvalidated()) {
                entry.setDeletedObjectPlanner(true);
            }
            ReviewCycleNode currentNode = null;
            if (doc.getLastDocumentVersion() != null) {
                currentNode = doc.getLastDocumentVersion().getActualReviewCycleNode();
            }
            entry.setCurrentNode(currentNode != null ? TapestryI18nHelper.getLocalizedString(currentNode.getReviewCycleCell().getName()) + " - " + TapestryI18nHelper.getLocalizedString(currentNode.getName()) : "");
            ReleasedObjectPlanner releasedPlanner = this.objectOperations.getReleasedObjectPlannerFromActiveObjectList(doc.getObjectPlanner().getId(), activeSubProjectId);
            if (releasedPlanner == null && ((ObjectPlannerImpl)doc.getObjectPlanner()).isInactive()) {
                entry.setDeletedObjectPlanner(true);
                releasedPlanner = this.objectOperations.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(doc.getObjectPlanner().getId(), activeSubProjectId);
                String plannerText = "";
                plannerText = releasedPlanner != null ? releasedPlanner.getCode() + " [" + releasedPlanner.getReviewCycleInstance().getName() + "] \n" + (releasedPlanner.getPlanner() != null ? releasedPlanner.getPlanner().getOrganisation().getName() : "") : "n/a";
                entry.setObjectPlannerText(plannerText + " (" + i18n.tr("gel\u00f6scht") + "!)");
            } else {
                String opn = releasedPlanner.getCode();
                if (releasedPlanner.getReviewCycleInstance() != null) {
                    opn = opn + " [" + releasedPlanner.getReviewCycleInstance().getName() + "]";
                }
                if (releasedPlanner.getPlanner() != null) {
                    opn = opn + " \n" + releasedPlanner.getPlanner().getOrganisation().getName();
                }
                entry.setObjectPlannerText(opn);
            }
            if (version != null && version.getStatus() == 2) {
                ReviewCyclePositionResult latestPositionResult = this.reviewCyclePositionResultDAO.getLatestPositionResultOfDocumentVersion(version.getId());
                if (latestPositionResult == null) {
                    ReviewCycleNodeResult nodeResult = this.getReviewCycleNodeResult(version.getActualReviewCycleNode(), version);
                    if (nodeResult != null) {
                        entry.setEffectiveEndDate(nodeResult.getDocumentArrivalDate());
                    }
                } else if (latestPositionResult.getReviewCycleResultOption() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus().equals(2)) {
                    entry.setEffectiveEndDate(latestPositionResult.getResultDate());
                }
            }
            res.add(entry);
        }
        long untilSorted = System.currentTimeMillis();
        System.setProperty("REVIEWSTATUSFILTERING", "[" + (untilSorted - until) + "ms]");
        return res;
    }

    @Override
    public ReviewCyclePositionResult getLatestPositionResultOfDocumentVersion(Integer documentVersionId) {
        return this.reviewCyclePositionResultDAO.getLatestPositionResultOfDocumentVersion(documentVersionId);
    }

    @Override
    public ResultList<ReviewCycleStatusListEntry> getReviewCycleStatus2(Integer activeSubProjectId, ReviewCycleStatusSearch search, Integer activeDocumentListId, Locale locale) {
        if (search == null) {
            return null;
        }
        return this.getCompactReviewStatus(activeSubProjectId, search, locale);
    }

    @Override
    public ResultList<ReviewCycleStatusListEntry> getCompactReviewStatus(Integer activeSubProjectId, ReviewCycleStatusSearch search, Locale locale) {
        SubProject sp = this.subProjectDAO.get(activeSubProjectId);
        I18n i18n = I18nFactory.getI18n(locale);
        ArrayList<CompactReviewStatus> results = new ArrayList<CompactReviewStatus>();
        if (sp.getActiveObjectList() == null) {
            return new CompactReviewStatusResultList(this, results, locale, false);
        }
        List mappedResults = this.documentDAO.getCompactReviewStatus(sp.getActiveObjectList().getId(), sp.getActiveDocumentList() != null ? sp.getActiveDocumentList().getId() : -1, search, i18n, this.hibernateDialect, activeSubProjectId);
        List<DocumentVersion> revisedVersions = null;
        HolidayCalculator hc = this.holidayCalculatorFactory.getInstance(this.projectDAO.get(search.getProjectId()));
        if (search.getDocumentStatus() == 2) {
            revisedVersions = this.documentVersionDAO.getReleasedVersionsOfRevisions(activeSubProjectId);
            revisedVersions.addAll(this.documentVersionDAO.getReleasedVersionsOfReactivatedVersions(activeSubProjectId));
        }
        Calendar now = Calendar.getInstance();
        for (Map result : mappedResults) {
            Integer dvId;
            block41: {
                boolean selected;
                block44: {
                    block45: {
                        ReviewCycleTask task;
                        block42: {
                            block43: {
                                int status;
                                int n = status = result.get("dvStatus") == null ? 11 : (Integer)result.get("dvStatus");
                                if (search.getDocumentStatus() == 9 && (status == 5 || status == 4 || status == 7)) {
                                    DocumentVersion version = this.documentVersionDAO.get((Integer)result.get("dvId"));
                                    DocumentVersion revisedVersion = version.getRevisedDocumentVersion();
                                    if (revisedVersion == null) {
                                        log.error((Object)("Status ACTIVE was selected in search and invalid documentVersion with id=[" + result.get("dvId") + "] and status=[" + DocumentTranslator.getStatusName(i18n, status) + "] was selected, skipping this entry."));
                                        continue;
                                    }
                                    if (this.reviewCycleStatusSearchInterpreter == null) {
                                        this.reviewCycleStatusSearchInterpreter = new ReviewCycleStatusSearchInterpreter();
                                    }
                                    if (!this.reviewCycleStatusSearchInterpreter.checkDocumentVersion(revisedVersion, search, this.taskOperations, this, hc)) continue;
                                    ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(sp.getActiveObjectList().getId(), revisedVersion.getDocument().getObjectPlanner().getId());
                                    if (rop == null) {
                                        log.info((Object)("Ignoring revised version [" + revisedVersion.getName() + "] because objectPlanner seems to be deleted"));
                                        continue;
                                    }
                                    Date effectiveEndDate = null;
                                    ReviewCyclePositionResult latestPositionResult = this.reviewCyclePositionResultDAO.getLatestPositionResultOfDocumentVersion(revisedVersion.getId());
                                    if (latestPositionResult == null) {
                                        ReviewCycleNodeResult nodeResult = this.getReviewCycleNodeResult(revisedVersion.getActualReviewCycleNode(), revisedVersion);
                                        if (nodeResult != null) {
                                            effectiveEndDate = nodeResult.getDocumentArrivalDate();
                                        }
                                    } else if (latestPositionResult.getReviewCycleResultOption() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus().equals(2)) {
                                        effectiveEndDate = latestPositionResult.getResultDate();
                                    }
                                    results.add(new CompactReviewStatus(revisedVersion, rop, effectiveEndDate, i18n));
                                    continue;
                                }
                                if (search.getDaysOfDelay() <= 0) break block41;
                                selected = true;
                                if ((Integer)result.get("dvId") == null) break block42;
                                task = this.taskOperations.getFirstTaskOfDocumentVersion((Integer)result.get("dvId"));
                                if (task == null) break block43;
                                switch (search.getDaysOfDelay()) {
                                    case 1: {
                                        if (!search.checkForNoDelay(task, hc)) {
                                            selected = false;
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 2: {
                                        if (!search.checkForDelay(task, hc)) {
                                            selected = false;
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 3: {
                                        if (!search.checkForLongDelay(task, hc)) {
                                            selected = false;
                                            break;
                                        }
                                        break block44;
                                    }
                                }
                                break block44;
                            }
                            selected = false;
                            break block44;
                        }
                        task = this.taskOperations.getReviewCycleEntryTask((Integer)result.get("documentId"));
                        if (task == null) break block45;
                        switch (search.getDaysOfDelay()) {
                            case 1: {
                                if (!search.checkForNoDelay(task, hc)) {
                                    selected = false;
                                    break;
                                }
                                break block44;
                            }
                            case 2: {
                                if (!search.checkForDelay(task, hc)) {
                                    selected = false;
                                    break;
                                }
                                break block44;
                            }
                            case 3: {
                                if (!search.checkForLongDelay(task, hc)) {
                                    selected = false;
                                    break;
                                }
                                break block44;
                            }
                        }
                        break block44;
                    }
                    selected = false;
                }
                if (!selected) continue;
            }
            if (search.isUseReleaseDate() && (search.getUploadedFrom() != null || search.getUploadedTo() != null) && (dvId = (Integer)result.get("dvId")) != null) {
                Calendar until = null;
                if (search.getUploadedTo() != null) {
                    until = Calendar.getInstance();
                    until.setTime(search.getUploadedTo());
                    until.set(11, 23);
                    until.set(12, 59);
                    until.set(13, 59);
                }
                DocumentVersion docVersion = this.documentVersionDAO.get(dvId);
                ReviewCycleNodeResult nodeRes = this.getReviewCycleNodeResult(docVersion.getActualReviewCycleNode(), docVersion);
                Date releaseDate = null;
                if (nodeRes != null && docVersion.getStatus() != 1) {
                    ReviewCyclePositionResult latestPositionResult = this.getLatestPositionResultOfDocumentVersion(docVersion.getId());
                    if (latestPositionResult == null && docVersion.getStatus() == 2) {
                        releaseDate = nodeRes.getDocumentArrivalDate();
                    } else if (latestPositionResult != null && latestPositionResult.getReviewCycleResultOption() != null && Integer.valueOf(2).equals(latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus())) {
                        releaseDate = latestPositionResult.getResultDate();
                    }
                }
                if (releaseDate == null || search.getUploadedFrom() != null && releaseDate.before(search.getUploadedFrom()) || until != null && releaseDate.after(until.getTime())) continue;
            }
            CompactReviewStatus compactReviewStatus = new CompactReviewStatus(result, i18n);
            compactReviewStatus.setFilterStatus(search.getDocumentStatus());
            results.add(compactReviewStatus);
        }
        if (revisedVersions != null && !revisedVersions.isEmpty()) {
            log.info((Object)("Adding " + revisedVersions.size() + " released versions of revisions to result list."));
            if (this.reviewCycleStatusSearchInterpreter == null) {
                this.reviewCycleStatusSearchInterpreter = new ReviewCycleStatusSearchInterpreter();
            }
            for (DocumentVersion dv : revisedVersions) {
                if (!this.reviewCycleStatusSearchInterpreter.checkDocumentVersion(dv, search, this.taskOperations, this, hc)) continue;
                ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(sp.getActiveObjectList().getId(), dv.getDocument().getObjectPlanner().getId());
                if (rop == null) {
                    log.info((Object)("Ignoring revised version [" + dv.getName() + "] because objectPlanner seems to be deleted"));
                    continue;
                }
                Date effectiveEndDate = null;
                ReviewCyclePositionResult latestPositionResult = this.reviewCyclePositionResultDAO.getLatestPositionResultOfDocumentVersion(dv.getId());
                if (latestPositionResult == null) {
                    ReviewCycleNodeResult nodeResult = this.getReviewCycleNodeResult(dv.getActualReviewCycleNode(), dv);
                    if (nodeResult != null) {
                        effectiveEndDate = nodeResult.getDocumentArrivalDate();
                    }
                } else if (latestPositionResult.getReviewCycleResultOption() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus().equals(2)) {
                    effectiveEndDate = latestPositionResult.getResultDate();
                }
                results.add(new CompactReviewStatus(dv, rop, effectiveEndDate, i18n));
            }
        }
        return new CompactReviewStatusResultList(this, results, locale, search.getDocumentStatus() == 2);
    }

    @Override
    public List<ReviewCycleStatusListEntry> reviveCompatReviewStatii(List<CompactReviewStatus> statii, Locale locale, boolean showReleased) {
        I18n i18n = I18nFactory.getI18n(locale);
        ArrayList<ReviewCycleStatusListEntry> res = new ArrayList<ReviewCycleStatusListEntry>();
        for (CompactReviewStatus status : statii) {
            DocumentImpl doc = this.documentDAO.get(status.getDocumentId());
            boolean selected = false;
            DocumentVersion version = doc.getLastDocumentVersion();
            ReviewCycleStatusListEntry entry = new ReviewCycleStatusListEntry();
            if (version != null && version.getRevisedDocumentVersion() != null && version.getRevisedDocumentVersion().getStatus() != 4 && (showReleased || version.getStatus() == 4 || version.getStatus() == 7 || version.getStatus() == 5)) {
                if (showReleased && version.getStatus() != 4 && version.getStatus() != 7 && version.getStatus() != 5) {
                    entry.setReleasedVersionOfRevision(true);
                }
                if (status.getFilterStatus() != version.getStatus() && (status.getFilterStatus() != 6 || version.getStatus() == 2 || version.getStatus() == 5 || version.getStatus() == 7 || version.getStatus() == 8 || version.getStatus() == 11) && (status.getFilterStatus() != 9 || version.getStatus() != 7 && version.getStatus() != 4 && version.getStatus() != 5)) {
                    version = version.getRevisedDocumentVersion();
                }
            }
            entry.setId(doc.getId());
            entry.setDocument(doc);
            ReleasedDocumentList relDocList = doc.getDocumentList().getSubProject().getActiveDocumentList();
            if (relDocList != null) {
                ReleasedDocument relDoc = this.documentDAO.getReleased(doc.getId(), relDocList.getId());
                entry.setReleasedDocument(relDoc != null ? relDoc : null);
            } else {
                entry.setReleasedDocument(null);
            }
            entry.setDocumentVersion(version);
            if (version != null) {
                entry.setDocumentStatus(DocumentTranslator.getStatusName(i18n, version.getStatus()));
            } else {
                entry.setDocumentStatus(DocumentTranslator.getDocumentStatus(i18n, doc));
            }
            if (doc.isInvalidated()) {
                entry.setDeletedObjectPlanner(true);
            }
            ReviewCycleNode currentNode = null;
            if (doc.getLastDocumentVersion() != null) {
                currentNode = doc.getLastDocumentVersion().getActualReviewCycleNode();
            }
            entry.setCurrentNode(currentNode != null ? TapestryI18nHelper.getLocalizedString(currentNode.getReviewCycleCell().getName()) + " - " + TapestryI18nHelper.getLocalizedString(currentNode.getName()) : "");
            ReleasedObjectPlanner releasedPlanner = this.objectOperations.getReleasedObjectPlannerFromActiveObjectList(doc.getObjectPlanner().getId(), doc.getDocumentList().getSubProject().getId());
            if (releasedPlanner == null && ((ObjectPlannerImpl)doc.getObjectPlanner()).isInactive()) {
                entry.setDeletedObjectPlanner(true);
                releasedPlanner = this.objectOperations.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(doc.getObjectPlanner().getId(), doc.getDocumentList().getSubProject().getId());
                String plannerText = "";
                plannerText = releasedPlanner != null ? releasedPlanner.getCode() + " [" + releasedPlanner.getReviewCycleInstance().getName() + "] \n" + (releasedPlanner.getPlanner() != null ? releasedPlanner.getPlanner().getOrganisation().getName() : "") : "n/a";
                entry.setObjectPlannerText(plannerText + " (" + i18n.tr("gel\u00f6scht") + "!)");
            } else {
                String opn = releasedPlanner.getCode();
                if (releasedPlanner.getReviewCycleInstance() != null) {
                    opn = opn + " [" + releasedPlanner.getReviewCycleInstance().getName() + "]";
                }
                if (releasedPlanner.getPlanner() != null) {
                    opn = opn + " \n" + releasedPlanner.getPlanner().getOrganisation().getName();
                }
                entry.setObjectPlannerText(opn);
            }
            if (version != null && version.getStatus() == 2) {
                ReviewCyclePositionResult latestPositionResult = this.reviewCyclePositionResultDAO.getLatestPositionResultOfDocumentVersion(version.getId());
                if (latestPositionResult == null) {
                    ReviewCycleNodeResult nodeResult = this.getReviewCycleNodeResult(version.getActualReviewCycleNode(), version);
                    if (nodeResult != null) {
                        entry.setEffectiveEndDate(nodeResult.getDocumentArrivalDate());
                    }
                } else if (latestPositionResult.getReviewCycleResultOption() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus().equals(2)) {
                    entry.setEffectiveEndDate(latestPositionResult.getResultDate());
                }
            }
            res.add(entry);
        }
        long untilSorted = System.currentTimeMillis();
        return res;
    }

    @Override
    public ResultList<DocumentVersion> getDocumentHighestVersions2(Integer activeSubProjectId, ReviewCycleStatusSearch search) {
        if (search == null) {
            return null;
        }
        return new ResultListImpl<DocumentVersion>(DocumentVersion.class, this.getDocumentHighestVersions(activeSubProjectId, search));
    }

    @Override
    public List getDocumentHighestVersions(Integer activeSubProjectId, ReviewCycleStatusSearch search) {
        ArrayList documents = new ArrayList();
        Integer activeDocumentListId = -1;
        SubProject subProject = this.subProjectDAO.get(activeSubProjectId);
        if (subProject.getActiveDocumentList() != null) {
            activeDocumentListId = subProject.getActiveDocumentList().getId();
        }
        if (search.getObjectId() != null && !Integer.valueOf(0).equals(search.getObjectId())) {
            documents.addAll(this.documentDAO.getUploaded(search.getObjectId(), 1, search.isUseReleaseDate() ? null : search.getUploadedFrom(), search.isUseReleaseDate() ? null : search.getUploadedTo(), search.getDocumentTypeId(), search.getProjectParticipationId(), activeDocumentListId, search.isWithInactivatedObjects()));
        } else {
            documents.addAll(this.documentDAO.getUploaded(activeSubProjectId, 0, search.isUseReleaseDate() ? null : search.getUploadedFrom(), search.isUseReleaseDate() ? null : search.getUploadedTo(), search.getDocumentTypeId(), search.getProjectParticipationId(), activeDocumentListId, search.isWithInactivatedObjects()));
        }
        if (this.reviewCycleStatusSearchInterpreter == null) {
            this.reviewCycleStatusSearchInterpreter = new ReviewCycleStatusSearchInterpreter();
        }
        if (documents == null) {
            return null;
        }
        HolidayCalculator hc = this.holidayCalculatorFactory.getInstance(subProject.getProject());
        ArrayList<DocumentVersion> res = new ArrayList<DocumentVersion>();
        for (int i = 0; i < documents.size(); ++i) {
            Document doc = (Document)documents.get(i);
            boolean selected = false;
            if (doc.getAllDocumentVersions().isEmpty()) continue;
            DocumentVersion version = doc.getLastDocumentVersion();
            if (!(version.getRevisedDocumentVersion() == null || version.getRevisedDocumentVersion().isInvalidatedOrDeleted() || version.getStatus() != 1 && version.getStatus() != 7 && version.getStatus() != 4 || search.getDocumentStatus() == 1)) {
                version = version.getRevisedDocumentVersion();
            }
            if (doc instanceof ReleasedDocument) {
                version.getDocument().setName(doc.getName());
                version.getDocument().setContent(doc.getContent());
                version.getDocument().setComment(doc.getComment());
                version.getDocument().setScale(doc.getScale());
            }
            if (!(selected = this.reviewCycleStatusSearchInterpreter.checkDocumentVersion(version, search, this.taskOperations, this, hc))) continue;
            res.add(version);
        }
        return res;
    }

    @Override
    public void signNonReviewTasks(Collection<ReviewableTask> tasks, Integer organisationPersonId, String comment, String password, CDESCertificate cert) throws WrongPasswordException, FrontendException {
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(organisationPersonId);
        Locale locale = new Locale(orgPerson.getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        for (ReviewableTask task : tasks) {
            DocumentVersion version = task.getDocumentVersion();
            ReviewCycleResultOption reviewCycleResultOption = task.getDocumentVersion().getActualReviewCycleNode().getReviewCyclePositionType().getSampleControlReviewCyclePositionType();
            if (reviewCycleResultOption == null) {
                log.info((Object)"No ResultOption was selected");
            }
            if (!(task instanceof ReviewTask)) {
                throw new ActionException(i18n.tr("Nur Pr\u00fcfaufgaben k\u00f6nnen hier abgehandelt werden"));
            }
            Map positions = task.getReviewCyclePositionReleases();
            if (positions == null) break;
            Collection pc = positions.values();
            ArrayList<TemporaryReviewCyclePositionResult> results = new ArrayList<TemporaryReviewCyclePositionResult>();
            ProjectParticipant signer = null;
            for (ReviewCyclePosition pos : pc) {
                TemporaryReviewCyclePositionResult tRes = new TemporaryReviewCyclePositionResult();
                tRes.setComment(comment);
                tRes.setRealmId(pos.getRealm().getId());
                tRes.setReviewCyclePositionId(pos.getId());
                tRes.setReviewCyleResultOptionId(reviewCycleResultOption.getId());
                ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(version.getActualReviewCycleNode(), version);
                ReviewCyclePositionResult pres = this.reviewCyclePositionResultDAO.get(pos.getRealm(), nodeResult, pos.getProjectParticipation());
                if (pres != null) {
                    if (pres.getSignature() == null) {
                        Collection atts = pres.getAttachments().values();
                        for (Attachment attachment : atts) {
                            this.attachmentOperations.deleteAttachment(attachment.getId());
                        }
                        this.reviewCyclePositionResultDAO.delete(pres);
                    } else {
                        throw new ActionException(i18n.tr("Ein ausgew\u00e4hlter Pr\u00fcfbereich wurde schon signiert"));
                    }
                }
                if (signer == null) {
                    signer = this.getSignerByTask(organisationPersonId, pos.getId(), task);
                }
                ReviewCyclePositionResult res = this.saveReviewPositionResult(tRes, signer, task.getDocumentVersion());
                tRes.setReviewCyclePositionResultId(res.getId());
                results.add(tRes);
            }
            if (signer == null) {
                throw new ActionException(String.format(locale, i18n.tr("Das Dokument %s kann nicht signiert werden!"), version.getName()));
            }
            this.signReviewPositionResult(results, null, password, signer, (ReviewTask)task, cert);
        }
    }

    @Override
    public ReviewCycleNodeResult getReviewCycleNodeResult(ReviewCycleNode node, DocumentVersion version) {
        return this.reviewCycleNodeResultDAO.get(node, version);
    }

    @Override
    public void updateAttachedReviewCyclePositions(Collection<MatrixEditItem> selected, DocumentVersion version, ReleasedObjectList objectList, ReviewCycleNodeInstanceImpl nodeInst) {
        ArrayList<AttachedReviewCyclePositionImpl> positions = new ArrayList<AttachedReviewCyclePositionImpl>();
        if (selected != null) {
            for (MatrixEditItem item : selected) {
                AttachedReviewCyclePositionImpl pos = new AttachedReviewCyclePositionImpl();
                pos.setReviewCycleNodeInstance(nodeInst);
                ProjectParticipation participation = this.projectParticipationDAO.get(item.getYId());
                Realm realm = this.realmDAO.get(item.getXId());
                pos.setProjectParticipation(participation);
                pos.setDocumentVersion(version);
                pos.setRealm(realm);
                pos = this.reviewCyclePositionDAO.save(pos);
                positions.add(pos);
            }
        }
        this.reviewCycleNodeInstanceDAO.merge(nodeInst);
        ReviewCycleInstanceRelease rel = this.reviewCycleInstanceDAO.getReleased(objectList.getId(), nodeInst.getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleNodeInstanceRelease relNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(rel.getId(), nodeInst.getReviewCycleNode().getId());
        this.taskOperations.generateAttachedReviewTasks(version, relNodeInstance, positions, null, false, true);
    }

    @Override
    public void saveDocumentReferences(Collection<DocumentRef> refs, DocumentVersion version) {
        Network network = version.getDocument().getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getNetwork();
        DocumentImpl doc = (DocumentImpl)version.getDocument();
        doc.setDocumentRefs(new HashMap<Integer, DocumentRef>());
        for (DocumentRef ref : refs) {
            if (ref.getId() != null && ref.getId() > 0) {
                DocumentRef oldRef = this.documentRefDAO.get(ref.getId());
                ref.setUntilDocumentVersion(version);
                ref.setDocument(version.getDocument());
                if (oldRef != null) {
                    ref.setSinceDocumentVersion(oldRef.getSinceDocumentVersion());
                } else {
                    ref.setSinceDocumentVersion(version);
                }
                this.documentRefDAO.update(ref);
            } else {
                ref.setId(null);
                ref.setDocument(version.getDocument());
                ref.setSinceDocumentVersion(version);
                ref.setUntilDocumentVersion(version);
                ref.setCreated(ref.getCreated());
                if (ref.getTempDocumentVersionId() != null) {
                    DocumentVersion referencedVersion = this.getDocumentVersion(ref.getTempDocumentVersionId());
                    ref.setReferencedVersion(referencedVersion);
                }
                if ((ref = this.documentRefDAO.save(ref)).getAttachmentFilename() != null) {
                    this.copyDocumentReferenceFromTempToRepository(ref, network);
                }
                ref = this.documentRefDAO.update(ref);
            }
            doc.getDocumentRefs().put(ref.getId(), ref);
        }
        this.documentDAO.update(doc);
    }

    public void setDocumentRefDAO(DocumentRefDAO documentRefDAO) {
        this.documentRefDAO = documentRefDAO;
    }

    @Override
    public ReviewCycleNodeInstanceRelease getReviewCycleNodeInstanceRelease(ReviewCycleNode node, Document document) {
        ReleasedObjectList activeObjectList = document.getDocumentList().getSubProject().getActiveObjectList();
        ObjectPlannerImpl impl = (ObjectPlannerImpl)document.getObjectPlanner();
        ReleasedObjectPlanner op = this.objectPlannerDAO.getReleasedObjectPlanner(activeObjectList.getId(), impl.getId());
        ReviewCycleNodeInstanceRelease actualNodeInstance = null;
        if (op != null) {
            actualNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(op.getReviewCycleInstance().getId(), node.getId());
        }
        return actualNodeInstance;
    }

    @Override
    public ReviewCycleNodeInstanceImpl getReviewCycleNodeInstance(Integer reviewCycleNodeInstanceId) {
        return this.reviewCycleNodeInstanceDAO.get(reviewCycleNodeInstanceId);
    }

    public void setReviewCycleNodeListenerDAO(ReviewCycleNodeListenerDAO reviewCycleNodeListenerDAO) {
        this.reviewCycleNodeListenerDAO = reviewCycleNodeListenerDAO;
    }

    @Override
    public ReviewCycleInstanceRelease getReleasedReviewCycleInstance(Integer releasedObjectListId, Integer reviewCycleInstance) {
        if (releasedObjectListId == null || reviewCycleInstance == null) {
            return null;
        }
        return this.reviewCycleInstanceDAO.getReleased(releasedObjectListId, reviewCycleInstance);
    }

    @Override
    public List<OEBBComment> getOEBBComments(ReviewCycleNodeResult res) {
        return this.reviewCyclePositionResultDAO.getAllOEBBComments(null, res);
    }

    @Override
    public void invalidateDocumentsVersionOfObjectPlanner(ObjectPlannerImpl planner, CDESCertificate cert, ProjectParticipant signer, String password) throws WrongPasswordException, FrontendException {
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        String invalidationResultString = i18n.tr("Objektblatt gel\u00f6scht");
        if (planner.getDocuments() != null && planner.getReviewCycleInstance() != null) {
            ReviewCycle reviewCycle = planner.getReviewCycleInstance().getReviewCycle();
            Collection documents = planner.getDocuments().values();
            for (DocumentImpl impl : documents) {
                List<DocumentVersion> versions = impl.getDocumentVersionsSortedByVersion();
                if (versions == null) continue;
                for (DocumentVersion version : versions) {
                    if (version.getStatus() == reviewCycle.getDocumentInvalidationOption().getDocumentVersionStatus().intValue()) continue;
                    this.invalidateDocumentVersion(version.getId(), invalidationResultString, signer, reviewCycle.getDocumentInvalidationOption(), password, cert, false, false);
                }
            }
        }
    }

    @Override
    public void invalidateDocumentsVersionOfObject(CDESObjectImpl object, CDESCertificate cert, ProjectParticipant signer, String password) throws WrongPasswordException, FrontendException {
        Collection planners;
        if (object.getObjectPlanners() != null) {
            planners = object.getObjectPlanners().values();
            for (ObjectPlannerImpl impl : planners) {
                this.invalidateDocumentsVersionOfObjectPlanner(impl, cert, signer, password);
            }
        }
        if (object.getInactivatedObjectPlanners() != null) {
            planners = object.getInactivatedObjectPlanners().values();
            for (ObjectPlannerImpl impl : planners) {
                this.invalidateDocumentsVersionOfObjectPlanner(impl, cert, signer, password);
            }
        }
    }

    @Override
    public void abortDocumentsVersionOfObject(CDESObjectImpl object, CDESCertificate cert, ProjectParticipant signer, String password) throws WrongPasswordException, FrontendException {
        if (object.getObjectPlanners() != null) {
            Collection planners = object.getObjectPlanners().values();
            for (ObjectPlannerImpl impl : planners) {
                this.abortDocumentsVersionOfObjectPlanner(impl, cert, signer, password);
            }
        }
    }

    @Override
    public void abortDocumentsVersionOfObjectPlanner(ObjectPlannerImpl objectPlanner, CDESCertificate cert, ProjectParticipant signer, String password) throws WrongPasswordException, FrontendException {
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        String invalidationResultString = i18n.tr("Pr\u00fcfung abgebrochen");
        if (objectPlanner.getDocuments() != null && objectPlanner.getReviewCycleInstance() != null) {
            ReviewCycle reviewCycle = objectPlanner.getReviewCycleInstance().getReviewCycle();
            Collection documents = objectPlanner.getDocuments().values();
            for (DocumentImpl doc : documents) {
                List<DocumentVersion> versions = doc.getDocumentVersionsSortedByVersion();
                if (versions != null) {
                    for (DocumentVersion version : versions) {
                        if (!version.isInAction() || version.getStatus() == reviewCycle.getDocumentVersionAbortedOption().getDocumentVersionStatus().intValue()) continue;
                        this.invalidateDocumentVersion(version.getId(), invalidationResultString, signer, reviewCycle.getDocumentVersionAbortedOption(), password, cert, false, false);
                    }
                }
                this.taskOperations.deleteDocumentTasks(doc.getId());
            }
        }
    }

    @Override
    public void deleteAndMove(Integer taskId) {
        DocumentVersionTask task = (DocumentVersionTask)this.taskOperations.getTask(taskId);
        DocumentVersion version = task.getDocumentVersion();
        this.taskOperations.removeTask(taskId);
        SubProject subProject = version.getDocument().getDocumentList().getSubProject();
        ReleasedObjectList objectList = subProject.getActiveObjectList();
        ReviewCycleNodeInstanceImpl versionNodeInstance = version.getActualReviewCycleNodeInstance();
        ReviewCycleInstance instance = versionNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance();
        ReviewCycleInstanceRelease instanceReleased = null;
        instanceReleased = instance instanceof ReviewCycleInstanceRelease ? (ReviewCycleInstanceRelease)instance : this.reviewCycleInstanceDAO.getReleased(objectList.getId(), instance.getId());
        if (instanceReleased != null) {
            ReviewCycleNodeResultImpl nodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(versionNodeInstance.getReviewCycleNode(), version);
            ReviewCycleNodeInstanceRelease versionNodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceReleased.getId(), versionNodeInstance.getReviewCycleNode().getId());
            if (this.isNodeFinished(versionNodeInstanceRelease, nodeResult, version)) {
                this.moveDocumentVersionToNextNode(versionNodeInstanceRelease, objectList, nodeResult, version, false);
            }
        } else {
            String msg = "deleteAndMoveTask: No ReviewCycleInstanceRelease found for taskId=" + task.getId() + ". Task was deleted but not moved.";
            log.error((Object)msg);
        }
    }

    @Override
    public ReviewCycleNodeInstanceRelease getReleasedReviewCycleNodeInstance(Integer reviewCycleNodeInstanceRelId) {
        return this.reviewCycleNodeInstanceDAO.getReleased(reviewCycleNodeInstanceRelId);
    }

    @Override
    public List getDocumentVersions(Integer subProjectId, ReferenceDocumentVersionSearch search) {
        ArrayList documents = new ArrayList();
        if (search.getObjectId() != null) {
            documents.addAll(this.documentDAO.getUploaded(search.getObjectId(), 1));
        } else {
            documents.addAll(this.documentDAO.getUploaded(subProjectId, 0));
        }
        if (this.reviewCycleStatusSearchInterpreter == null) {
            this.reviewCycleStatusSearchInterpreter = new ReviewCycleStatusSearchInterpreter();
        }
        if (documents == null) {
            return null;
        }
        HolidayCalculator hc = this.holidayCalculatorFactory.getInstance(this.projectDAO.get(search.getProjectId()));
        ArrayList<DocumentVersion> res = new ArrayList<DocumentVersion>();
        for (int i = 0; i < documents.size(); ++i) {
            DocumentVersion version;
            Document doc = (Document)documents.get(i);
            boolean selected = false;
            if (doc.getDocumentVersions().isEmpty() || !(selected = this.reviewCycleStatusSearchInterpreter.checkDocumentVersion(version = doc.getLastDocumentVersion(), search, this.taskOperations, this, hc))) continue;
            res.add(version);
        }
        return res;
    }

    @Override
    public void deleteDocumentReference(DocumentRef ref) {
        this.documentRefDAO.delete(ref);
    }

    @Override
    public boolean isDocumentReleased(Integer docId) {
        return this.documentDAO.isDocumentReleased(docId);
    }

    public void setHpglRenderer(IHPGLRenderer hpglRenderer) {
        this.hpglRenderer = hpglRenderer;
    }

    @Override
    public String uploadDocumentRefAttachmentTemporary(String fileName, String fileExtension, IMimeInputStream fis) {
        try {
            DataSource ds = DataSourceHelper.toDataSource(fis);
            String string = this.uploadFileHandler.saveDocumentReferenceAttachmentTemporary(ds.getInputStream(), fileName, fileExtension);
            return string;
        }
        catch (FileHandleException e) {
            throw new ActionException("upload document reference attachment tmp ", e);
        }
        catch (IOException e) {
            throw new ActionException("IOException - upload document reference attachment tmp ", e);
        }
        catch (IOError e) {
            throw new ActionException("IOError - upload document reference attachment tmp ", e);
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable e) {
                throw new ActionException("IOError - upload document reference attachment tmp ", e);
            }
        }
    }

    @Override
    public DocumentRef copyDocumentReferenceFromTempToRepository(DocumentRef reference, Network network) {
        reference = this.uploadFileHandler.copyUploadedDocumentReference(reference);
        reference = this.updateDocumentRefFileDigest(reference, network);
        return reference;
    }

    @Override
    public DocumentRef updateDocumentRefFileDigest(DocumentRef ref, Network network) {
        try {
            File att = this.fileFinder.findFile(ref.getAttachmentFilename(), CDESFileRepository.DOCUMENTREFSREPOSITORY);
            if (att == null) {
                return null;
            }
            DigestCalculator attDig = this.digestCalculatorFactory.getDigestCalculator(network, att);
            DigestCalculatorType type = this.digestCalculatorDAO.get(attDig.getClass().getName());
            ref.setDigest(attDig.getDigest(att));
            ref.setDigestCalculatorType(type);
            return ref;
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught FileHandleException when digesting DocumentRef", e);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("Caught DigestCalculatorException when digesting DocumentRef", e);
        }
    }

    @Override
    public ReviewCyclePositionResult saveReviewCyclePositionResult(ReviewCyclePositionResult result) {
        return this.reviewCyclePositionResultDAO.save(result);
    }

    public void setMailDAO(EMailDAO mailDAO) {
        this.mailDAO = mailDAO;
    }

    @Override
    public ReviewCyclePositionResult insertNewOrGetExistingReviewCyclePositionResult2(ReviewCyclePositionResult commentReference, ProjectParticipation participation, ReviewCycleNode node, ProjectParticipant signer, DocumentVersion docVersion, DocumentList activeDocumentList, ReleasedObjectList activeObjectList, Integer overridingProjectParticipantId) {
        ReviewCyclePositionResult existing = this.getReviewCyclePositionResult3(commentReference, participation, node);
        if (existing == null) {
            ReviewCyclePositionResult newRes = new ReviewCyclePositionResultImpl();
            newRes.setResultDate(new Date(System.currentTimeMillis()));
            newRes.setReviewCycleNode(node);
            newRes.setDocumentVersion(docVersion);
            newRes.setCommentReference(commentReference);
            newRes.setActiveDocumentList(activeDocumentList);
            newRes.setActiveObjectList(activeObjectList);
            if (overridingProjectParticipantId != null) {
                newRes.setOverridingProjectParticipant(this.projectParticipantDAO.get(overridingProjectParticipantId));
            }
            if (overridingProjectParticipantId != null) {
                newRes.setOverridingProjectParticipant(this.projectParticipantDAO.get(overridingProjectParticipantId));
                newRes.setProjectParticipant(participation.getMainParticipant());
            } else {
                newRes.setProjectParticipant(signer);
            }
            newRes = this.saveReviewCyclePositionResult(newRes);
            return newRes;
        }
        if (overridingProjectParticipantId != null) {
            existing.setOverridingProjectParticipant(this.projectParticipantDAO.get(overridingProjectParticipantId));
            existing.setProjectParticipant(participation.getMainParticipant());
        } else {
            existing.setProjectParticipant(signer);
        }
        return existing;
    }

    @Override
    public ReviewCyclePositionResult insertNewOrGetExistingReviewPositionAndNodeResult(ReviewCyclePositionReleaseImpl pos, DocumentVersion version, TemporaryReviewCyclePositionResult tres, ProjectParticipant signer, ReviewCycleNode node) {
        ReviewCyclePositionResult res = this.getReviewCyclePositionResult2(pos, version, null);
        if (res == null) {
            res = this.saveReviewPositionAndNodeResult(tres, signer, version, node);
        }
        return res;
    }

    @Override
    public ReviewCyclePositionResult insertNewOrGetExistingReviewCyclePositionResult(ReviewCyclePositionRelease positionRelease, DocumentVersion version, TemporaryReviewCyclePositionResult tres, ProjectParticipant signer, ReviewableTask task) {
        ReleasedObjectList objectList = version.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        ReleasedDocumentList documentList = version.getDocument().getDocumentList().getSubProject().getActiveDocumentList();
        ReviewCycleNode actualNode = version.getActualReviewCycleNode();
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(actualNode, version);
        ReviewCyclePositionResult res = null;
        if (tres.getOverridingProjectParticipantId() == null) {
            res = this.getReviewCyclePositionResult2(positionRelease, version, nodeResult.getId());
            if (res == null) {
                res = this.saveOrUpdateReviewCyclePositionResult(objectList, documentList, version, tres, nodeResult, signer, null);
            }
        } else {
            res = this.reviewCyclePositionResultDAO.getUnsignedOverridingReviewCyclePositionResult(positionRelease, version, nodeResult.getId(), tres.getOverridingProjectParticipantId());
            List originalResults = this.reviewCyclePositionResultDAO.getUnsigned(positionRelease.getRealm(), nodeResult.getReviewCycleNode(), version, positionRelease.getProjectParticipation(), nodeResult.getId());
            if (originalResults.size() > 0) {
                res = (ReviewCyclePositionResult)originalResults.get(0);
            }
            if (res == null) {
                res = this.saveOrUpdateReviewCyclePositionResult(objectList, documentList, version, tres, nodeResult, signer, tres.getOverridingProjectParticipantId());
            }
        }
        return res;
    }

    @Override
    public void checkFinishedNodeErrors() {
        Calendar start = Calendar.getInstance();
        start.set(2008, 11, 14, 21, 0);
        Calendar end = Calendar.getInstance();
        List nodeResults = this.reviewCycleNodeResultDAO.getAllFinishedWithinTime(start.getTime(), end.getTime());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info((Object)("Found " + nodeResults.size() + " finished ReviewCycleNodeResults within specified time interval (startDate=[" + dateFormat.format(start.getTime()) + "] endDate=[" + dateFormat.format(end.getTime()) + "])"));
        HashMap<Integer, ReviewCyclePosition> uniquePositions = new HashMap<Integer, ReviewCyclePosition>();
        HashMap<Integer, Object> documentVersionFinishedNodeResults = new HashMap<Integer, Object>();
        HashMap<Integer, Object> nodeResultsWithErrors = new HashMap<Integer, Object>();
        for (Object nodeResult : nodeResults) {
            int dvStatus = ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getStatus();
            if (dvStatus == 7 || dvStatus == 4 || dvStatus == 5) continue;
            Collection positionResults = ((ReviewCycleNodeResultImpl)nodeResult).getReviewCycleNodePositionResults().values();
            SubProject sp = ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getDocument().getDocumentList().getSubProject();
            log.info((Object)(">>>>>> DocumentVersion=[" + ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getName() + " (id=" + ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getId() + ")] -> Checking nodeResult for node [" + TapestryI18nHelper.getLocalizedString(((ReviewCycleNodeResultImpl)nodeResult).getReviewCycleNode().getName()) + "] subProject=[" + sp.getCode() + " " + sp.getName() + " (" + sp.getId() + ")] project=[" + sp.getProject().getCode() + " " + sp.getProject().getName() + " (" + sp.getProject().getId() + ")] network=[" + sp.getProject().getNetwork().getName() + " (" + sp.getProject().getNetwork().getId() + ")]"));
            ReviewCycleInstanceRelease instanceRelease = this.reviewCycleInstanceDAO.getReleased(sp.getActiveObjectList().getId(), ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getId());
            ReviewCycleNodeInstanceRelease nodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceRelease.getId(), ((ReviewCycleNodeResultImpl)nodeResult).getReviewCycleNode().getId());
            List<ReviewCyclePosition> positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstanceRelease, ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion());
            for (ReviewCyclePosition position : positions) {
                List results = this.reviewCyclePositionResultDAO.getAllSigned(position.getRealm().getId(), ((ReviewCycleNodeResultImpl)nodeResult).getReviewCycleNode().getId(), ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getId(), position.getProjectParticipation().getId());
                boolean foundError = false;
                if (results.size() == 0) {
                    log.info((Object)("ERROR FOUND: found no results for position with id=[" + position.getId() + "] participation=[" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + "] realm=[" + position.getRealm().getCode() + " " + position.getRealm().getName() + "] -- the documentVersion is currently at node=[" + TapestryI18nHelper.getLocalizedString(((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getActualReviewCycleNode().getName()) + "] with node_instance_id=[" + ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getActualReviewCycleNodeInstance().getId() + "]"));
                    uniquePositions.put(position.getId(), position);
                    foundError = true;
                } else {
                    for (ReviewCyclePositionResult result : results) {
                        if (result.getSignature() != null) continue;
                        log.info((Object)("ERROR FOUND: found result where signature is null resultId=[" + result.getId() + "] participation=[" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + " -> signed by " + result.getProjectParticipant().getOrganisationPerson().getPerson().getCommonName() + ")] realm=[" + position.getRealm().getCode() + " " + position.getRealm().getName() + "]  -- the documentVersion is currently at node=[" + TapestryI18nHelper.getLocalizedString(((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getActualReviewCycleNode().getName()) + "] with node_instance_id=[" + ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getActualReviewCycleNodeInstance().getId() + "]"));
                        uniquePositions.put(position.getId(), position);
                        foundError = true;
                    }
                }
                if (foundError) {
                    nodeResultsWithErrors.put(((ReviewCycleNodeResultImpl)nodeResult).getId(), nodeResult);
                }
                if (!foundError || ((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getDocument().getLastDocumentVersion().getId().equals(((ReviewCycleNodeResultImpl)nodeResult).getDocumentVersion().getId())) continue;
                documentVersionFinishedNodeResults.put(((ReviewCycleNodeResultImpl)nodeResult).getId(), nodeResult);
            }
        }
        log.info((Object)(">>>>> End of check: Found " + uniquePositions.size() + " ReviewCyclePositions with Errors:"));
        Collection positions = uniquePositions.values();
        for (ReviewCyclePosition position : positions) {
            log.info((Object)(">>>> ReviewCyclePosition with id=[" + position.getId() + "] has error: participation=[" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + "] realm=[" + position.getRealm().getCode() + " " + position.getRealm().getName() + "]"));
        }
        log.info((Object)(">>>>> There were " + documentVersionFinishedNodeResults.size() + " errors where DocumentVersions were finished and a new Version was uploaded:"));
        Collection results = documentVersionFinishedNodeResults.values();
        for (ReviewCycleNodeResultImpl res : results) {
            log.info((Object)(">>>>> DocumentVersion " + res.getDocumentVersion().getName() + "with id=[" + res.getDocumentVersion().getId() + "] and nodeResultId=[" + res.getId() + "] at node=[" + TapestryI18nHelper.getLocalizedString(res.getReviewCycleNode().getName()) + "] has been uploaded with a new version"));
        }
        log.info((Object)(">>>>> ReviewCycleNodeResults with errors in total: " + nodeResultsWithErrors.size()));
    }

    @Override
    public void updateRepairFinishedNodeResultErrors(boolean verbose) {
        Calendar start = Calendar.getInstance();
        start.set(2008, 11, 14, 21, 0);
        Calendar end = Calendar.getInstance();
        List nodeResults = this.reviewCycleNodeResultDAO.getAllFinishedWithinTime(start.getTime(), end.getTime());
        log.info((Object)("Found " + nodeResults.size() + " finished ReviewCycleNodeResults within specified time interval"));
        ArrayList<Integer> uniquePositions = new ArrayList<Integer>();
        ArrayList<Integer> repairedDocumentVersions = new ArrayList<Integer>();
        for (ReviewCycleNodeResultImpl nodeResult : nodeResults) {
            for (Integer resultId : repairedDocumentVersions) {
                if (!resultId.equals(nodeResult.getDocumentVersion().getId())) continue;
            }
            int dvStatus = nodeResult.getDocumentVersion().getStatus();
            if (dvStatus == 7 || dvStatus == 4 || dvStatus == 5) continue;
            Collection positionResults = nodeResult.getReviewCycleNodePositionResults().values();
            SubProject sp = nodeResult.getDocumentVersion().getDocument().getDocumentList().getSubProject();
            log.info((Object)(">>>>>> DocumentVersion=[" + nodeResult.getDocumentVersion().getName() + " (id=" + nodeResult.getDocumentVersion().getId() + ")] -> Checking nodeResult for node [" + TapestryI18nHelper.getLocalizedString(nodeResult.getReviewCycleNode().getName()) + "] subProject=[" + sp.getCode() + " " + sp.getName() + " (" + sp.getId() + ")] project=[" + sp.getProject().getCode() + " " + sp.getProject().getName() + " (" + sp.getProject().getId() + ")] network=[" + sp.getProject().getNetwork().getName() + " (" + sp.getProject().getNetwork().getId() + ")]"));
            ReviewCycleInstanceRelease instanceRelease = this.reviewCycleInstanceDAO.getReleased(sp.getActiveObjectList().getId(), nodeResult.getDocumentVersion().getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getId());
            ReviewCycleNodeInstanceRelease nodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceRelease.getId(), nodeResult.getReviewCycleNode().getId());
            List<ReviewCyclePosition> positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstanceRelease, nodeResult.getDocumentVersion());
            block4: for (ReviewCyclePosition position : positions) {
                for (Integer pos : uniquePositions) {
                    if (!pos.equals(position.getId())) continue;
                }
                uniquePositions.add(position.getId());
                List results = this.reviewCyclePositionResultDAO.getAllSigned(position.getRealm().getId(), nodeResult.getReviewCycleNode().getId(), nodeResult.getDocumentVersion().getId(), position.getProjectParticipation().getId());
                boolean foundError = false;
                if (results.size() == 0) {
                    log.info((Object)("ERROR FOUND: found no results for position with id=[" + position.getId() + "] participation=[" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + "] realm=[" + position.getRealm().getCode() + " " + position.getRealm().getName() + "] -- the documentVersion is currently at node=[" + TapestryI18nHelper.getLocalizedString(nodeResult.getDocumentVersion().getActualReviewCycleNode().getName()) + "] with node_instance_id=[" + nodeResult.getDocumentVersion().getActualReviewCycleNodeInstance().getId() + "]"));
                    foundError = true;
                } else {
                    for (ReviewCyclePositionResult result : results) {
                        if (result.getSignature() != null) continue;
                        log.info((Object)("ERROR FOUND: found result where signature is null resultId=[" + result.getId() + "] participation=[" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + " -> signed by " + result.getProjectParticipant().getOrganisationPerson().getPerson().getCommonName() + ")] realm=[" + position.getRealm().getCode() + " " + position.getRealm().getName() + "]  -- the documentVersion is currently at node=[" + TapestryI18nHelper.getLocalizedString(nodeResult.getDocumentVersion().getActualReviewCycleNode().getName()) + "] with node_instance_id=[" + nodeResult.getDocumentVersion().getActualReviewCycleNodeInstance().getId() + "]"));
                        foundError = true;
                    }
                }
                if (!foundError) continue;
                if (!nodeResult.getDocumentVersion().getDocument().getLastDocumentVersion().getId().equals(nodeResult.getDocumentVersion().getId())) {
                    log.info((Object)"FOUND FINISHED DOCUMENTVERSION: documentVersion was finished and a new version was uploaded!");
                    continue;
                }
                log.info((Object)(">>>>>REPAIRING DOCUMENTVERSION[" + nodeResult.getDocumentVersion().getName() + " (id=" + nodeResult.getDocumentVersion().getId() + ")] -> Checking nodeResult for node [" + TapestryI18nHelper.getLocalizedString(nodeResult.getReviewCycleNode().getName()) + "] subProject=[" + sp.getCode() + " " + sp.getName() + " (" + sp.getId() + ")] project=[" + sp.getProject().getCode() + " " + sp.getProject().getName() + " (" + sp.getProject().getId() + ")] network=[" + sp.getProject().getNetwork().getName() + " (" + sp.getProject().getNetwork().getId() + ")]"));
                List nodeInstancesRel = nodeInstanceRelease.getReviewCycleCellInstance().getReviewCycleNodeInstancesSortedByPosition();
                boolean pastActualNodeInstance = false;
                for (ReviewCycleNodeInstanceRelease nodeInstanceRel : nodeInstancesRel) {
                    if (!pastActualNodeInstance) {
                        if (!nodeInstanceRel.getId().equals(nodeInstanceRelease.getId())) continue;
                        pastActualNodeInstance = true;
                        continue;
                    }
                    DocumentVersion dv = nodeResult.getDocumentVersion();
                    repairedDocumentVersions.add(dv.getId());
                    List<ReviewCycleNode> nodes = dv.getActualReviewCycleNode().getReviewCycleCell().getReviewCycleNodesSortedByPosition();
                    for (ReviewCycleNode node : nodes) {
                        ReviewCycleCellResult cellResult;
                        int dv_Status;
                        ReviewCycleNodeResult earliestNodeResult = this.getReviewCycleNodeResult(node, dv);
                        if (earliestNodeResult == null || (dv_Status = nodeResult.getDocumentVersion().getStatus()) == 7 || dv_Status == 4 || dvStatus == 5) continue;
                        Collection position_Results = nodeResult.getReviewCycleNodePositionResults().values();
                        SubProject _sp = nodeResult.getDocumentVersion().getDocument().getDocumentList().getSubProject();
                        ReviewCycleInstanceRelease _instanceRelease = this.reviewCycleInstanceDAO.getReleased(_sp.getActiveObjectList().getId(), nodeResult.getDocumentVersion().getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getId());
                        ReviewCycleNodeInstanceRelease _nodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(_instanceRelease.getId(), nodeResult.getReviewCycleNode().getId());
                        List<ReviewCyclePosition> _positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(_nodeInstanceRelease, nodeResult.getDocumentVersion());
                        boolean _foundError = false;
                        for (ReviewCyclePosition _position : _positions) {
                            for (Integer n : uniquePositions) {
                                if (!n.equals(position.getId())) continue;
                            }
                            uniquePositions.add(position.getId());
                            List _results = this.reviewCyclePositionResultDAO.getAllSigned(position.getRealm().getId(), nodeResult.getReviewCycleNode().getId(), nodeResult.getDocumentVersion().getId(), position.getProjectParticipation().getId());
                            if (_results.size() == 0) {
                                _foundError = true;
                                continue;
                            }
                            for (ReviewCyclePositionResult result : _results) {
                                if (result.getSignature() != null) continue;
                                _foundError = true;
                            }
                        }
                        if (!_foundError) continue;
                        if (!verbose) {
                            dv.setActualReviewCycleNodeInstance(_nodeInstanceRelease.getReviewCycleNodeInstance());
                        }
                        log.info((Object)("found error in reviewCycleNode - first node with error is [" + TapestryI18nHelper.getLocalizedString(_nodeInstanceRelease.getReviewCycleNodeInstance().getReviewCycleNode().getName()) + "] with position=[" + _nodeInstanceRelease.getReviewCycleNodeInstance().getReviewCycleNode().getPosition() + "]"));
                        log.info((Object)(">>>>>> SETTING NEW ACTUALREVIEWCYCLENODE in documentVersoin=[" + dv.getName() + "] with id=[" + dv.getId() + "] at node=[" + TapestryI18nHelper.getLocalizedString(dv.getActualReviewCycleNodeInstance().getReviewCycleNode().getName()) + "] with id=[" + dv.getActualReviewCycleNodeInstance().getReviewCycleNode().getId() + "]"));
                        if (!verbose) {
                            dv = this.documentVersionDAO.update(dv);
                        }
                        if ((cellResult = this.getReviewCycleCellResult(dv.getActualReviewCycleNode().getReviewCycleCell().getId(), dv.getId())) != null && !verbose) {
                            cellResult.setFinished(false);
                            cellResult.setReviewCycleResultOption(null);
                            cellResult = this.reviewCycleCellResultDAO.update(cellResult);
                        }
                        try {
                            List dvTasks = this.taskOperations.getDocumentVersionTasksOfDocumentVersion(dv);
                            for (DocumentVersionTask documentVersionTask : dvTasks) {
                                if (documentVersionTask instanceof ReviewTask) {
                                    ReviewCycleNodeInstanceImpl nodeInstance = this.getReviewCycleNodeInstance(((ReviewTask)documentVersionTask).getReviewCycleNodeInstanceId());
                                    if (nodeInstance.getReviewCycleNode().getId().equals(nodeResult.getReviewCycleNode().getId())) continue;
                                    log.info((Object)(">>>>> DELETING REVIEWTASK with id=[" + documentVersionTask.getId() + "] of documentVersion=[" + dv.getName() + "] docVerId=[" + dv.getId() + "]"));
                                    if (verbose) continue;
                                    this.taskOperations.removeTask(documentVersionTask.getId());
                                    continue;
                                }
                                if (!(documentVersionTask instanceof SelectCellConnectionTask)) continue;
                                log.info((Object)(">>>>> DELETING SELECTCELLCONNECTIONTASK with id=[" + documentVersionTask.getId() + "] of documentVersion=[" + dv.getName() + "] docVerId=[" + dv.getId() + "]"));
                                if (verbose) continue;
                                this.taskOperations.removeTask(documentVersionTask.getId());
                            }
                            continue block4;
                        }
                        catch (RuntimeException e) {
                            log.info((Object)("Caught Exception while processing tasks: " + e.getMessage()));
                            continue block4;
                        }
                    }
                    continue block4;
                }
            }
        }
        log.info((Object)">-<-<-<>-<->><<><- The End -<-<<--<-<->><-<<-<");
    }

    @Override
    public boolean isDocumentVersionInconsistent(Integer documentVersionId) {
        DocumentVersion dv = this.getDocumentVersion(documentVersionId);
        List<ReviewCycleNode> allNodes = dv.getActualReviewCycleNode().getReviewCycleCell().getReviewCycleNodesSortedByPosition();
        for (ReviewCycleNode node : allNodes) {
            int dvStatus;
            ReviewCycleNodeResult nodeResult = this.getReviewCycleNodeResult(node, dv);
            if (nodeResult == null || !nodeResult.isFinished() || nodeResult.getDocumentDepartureDate() == null) continue;
            Calendar start = Calendar.getInstance();
            start.set(2008, 11, 15);
            Calendar end = Calendar.getInstance();
            end.set(2008, 11, 17);
            if (!nodeResult.getDocumentDepartureDate().before(end.getTime()) || !nodeResult.getDocumentDepartureDate().after(start.getTime()) || (dvStatus = nodeResult.getDocumentVersion().getStatus()) == 7 || dvStatus == 4 || dvStatus == 5) continue;
            Collection positionResults = nodeResult.getReviewCycleNodePositionResults().values();
            SubProject sp = nodeResult.getDocumentVersion().getDocument().getDocumentList().getSubProject();
            ReviewCycleInstanceRelease instanceRelease = this.reviewCycleInstanceDAO.getReleased(sp.getActiveObjectList().getId(), nodeResult.getDocumentVersion().getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getId());
            ReviewCycleNodeInstanceRelease nodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceRelease.getId(), nodeResult.getReviewCycleNode().getId());
            List<ReviewCyclePosition> positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstanceRelease, nodeResult.getDocumentVersion());
            for (ReviewCyclePosition position : positions) {
                List results = this.reviewCyclePositionResultDAO.getAllSigned(position.getRealm().getId(), nodeResult.getReviewCycleNode().getId(), nodeResult.getDocumentVersion().getId(), position.getProjectParticipation().getId());
                if (results.size() == 0) {
                    return true;
                }
                for (ReviewCyclePositionResult result : results) {
                    if (result.getSignature() != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int insertCreateMissingTasks(boolean checkAndRestore, int type) {
        int count = 0;
        int countProject = 0;
        int countSubProject = 0;
        log.info((Object)("--------------- starting global check for missing tasks " + (checkAndRestore ? "in restore mode " : "") + "---------------"));
        List projects = this.projectDAO.getAll(null, null, null, null);
        log.info((Object)("-- global check for missing tasks: found " + projects.size() + " projects to check."));
        for (Project project : projects) {
            if (project.getStatus() != 0) continue;
            log.info((Object)("---- check for missing tasks for project: " + project.getCode() + " " + project.getName() + " network: " + project.getNetwork().getName()));
            Collection subProjects = project.getSubProjects().values();
            log.info((Object)("---- global check for missing tasks in project #" + ++countProject + ": found " + subProjects.size() + " subProjects to check."));
            for (SubProject subProject : subProjects) {
                if (subProject.isInvalidated()) continue;
                log.info((Object)("-- global check for missing tasks for project/subproject #" + countProject + "/" + ++countSubProject));
                log.info((Object)("-- check for missing tasks for subProject: " + subProject.getCode() + " " + subProject.getName() + " project: " + project.getCode() + " " + project.getName() + " network: " + project.getNetwork().getName()));
                log.info((Object)("-- " + (count += this.insertCreateMissingTasksOfSubProject(subProject, checkAndRestore, type)) + " missing tasks restored for subProject: " + subProject.getCode() + " " + subProject.getName() + " project: " + project.getCode() + " " + project.getName() + " network: " + project.getNetwork().getName()));
            }
            log.info((Object)("---- " + count + " missing tasks restored for project: " + project.getCode() + " " + project.getName() + " network: " + project.getNetwork().getName()));
        }
        log.info((Object)("--------- a total of " + count + " missing tasks have been restored."));
        log.info((Object)"--------------- finishing global check for missing tasks ---------------");
        return count;
    }

    @Override
    public int insertCreateMissingTasksOfSubProject(SubProject subProject, boolean checkAndRestore, int type) {
        int count = 0;
        if (type == 0 || type == 1 || type == 2) {
            ReleasedObjectList objectListRel = null;
            Object documentListRel = null;
            objectListRel = subProject.getActiveObjectList();
            if (objectListRel == null) {
                return 0;
            }
            ReviewCycleStatusSearch search = new ReviewCycleStatusSearch("temp");
            List documentVersions = this.getDocumentHighestVersions(objectListRel.getSubProject().getId(), search);
            log.info((Object)("starting check for missing reviewTasks and selectCellTasks in " + (checkAndRestore ? "validate and restore mode" : "validate only mode") + " for project/subProject " + subProject.getProject().getCode() + " " + subProject.getProject().getName() + "/" + subProject.getCode() + " " + subProject.getName()));
            for (DocumentVersion documentVersion : documentVersions) {
                ReviewCycleCellInstance actualCellInstance = documentVersion.getActualReviewCycleNodeInstance().getReviewCycleCellInstance();
                ReviewCycleNodeInstanceImpl actualNodeInstance = documentVersion.getActualReviewCycleNodeInstance();
                ReviewCycleNodeResult reviewCycleNodeResult = this.reviewCycleNodeResultDAO.get(actualNodeInstance.getReviewCycleNode(), documentVersion);
                if (reviewCycleNodeResult == null) continue;
                count += this.insertCreateMissingTasks(reviewCycleNodeResult.getId(), checkAndRestore, type);
            }
        }
        if (type == 0 || type == 3) {
            log.info((Object)("starting check for missing plannerEntryTasks in " + (checkAndRestore ? "validate and restore mode" : "validate only mode") + " for project/subProject " + subProject.getProject().getCode() + " " + subProject.getProject().getName() + "/" + subProject.getCode() + " " + subProject.getName()));
            count += this.taskOperations.checkAndRestorePlannerEntryTasks(subProject, checkAndRestore);
        }
        return count;
    }

    @Override
    public int insertCreateMissingTasks(Integer nodeResultId, boolean checkAndRestore, int type) {
        int count = 0;
        int generatedReviewTasks = 0;
        int generatedAttachedReviewTasks = 0;
        int generatedSelectCellTasks = 0;
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(nodeResultId);
        DocumentVersion documentVersion = nodeResult.getDocumentVersion();
        SubProject sp = documentVersion.getDocument().getDocumentList().getSubProject();
        ReviewCycleInstanceRelease instanceRelease = this.reviewCycleInstanceDAO.getReleased(sp.getActiveObjectList().getId(), documentVersion.getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleNodeInstanceRelease nodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceRelease.getId(), nodeResult.getReviewCycleNode().getId());
        if (type == 0 || type == 1 || type == 2) {
            log.info((Object)("checking for obsolete reviewTasks and trying to generate missing tasks for documentVersion=[" + documentVersion.getName() + "] docVerId=[" + documentVersion.getId() + "]"));
            if (!documentVersion.getActualReviewCycleNode().isEndNode()) {
                this.taskOperations.checkForObsoleteReviewTasks(documentVersion, nodeInstanceRelease, nodeResultId, checkAndRestore);
                if (!documentVersion.isReleased()) {
                    if (type == 0 || type == 1) {
                        generatedReviewTasks = this.taskOperations.generateReviewTasks(documentVersion, nodeInstanceRelease, nodeResultId, true, checkAndRestore);
                    }
                    if (type == 0 || type == 2) {
                        generatedAttachedReviewTasks = this.taskOperations.generateAttachedReviewTasks(documentVersion, nodeInstanceRelease, null, nodeResultId, true, checkAndRestore);
                    }
                } else {
                    log.info((Object)"skipping generating reviewTasks because documentVersion is already released.");
                }
            } else {
                log.info((Object)"skipping generating reviewTasks because actualReviewCycleNode is endNode.");
            }
        }
        if (type == 0 || type == 3) {
            ReviewCycleNode prevNode = documentVersion.getActualReviewCycleNode().getReviewCycleCell().getPreviousNode(nodeResult.getReviewCycleNode());
            ReviewCycleNodeResult prevNodeResult = null;
            boolean evaluateCellConnections = false;
            if (prevNode != null && (prevNodeResult = this.reviewCycleNodeResultDAO.get(prevNode, documentVersion)) != null) {
                evaluateCellConnections = prevNodeResult.getReviewCycleResultOption().isEvaluateCellConnections();
            }
            boolean nodeResultIsFinishedandNotInvalidated = nodeResult.isFinished() && !documentVersion.isInvalidated() && !documentVersion.isReleasedNegative();
            boolean isEndCell = nodeResult.getReviewCycleNode().getReviewCycleCell().isEndCell();
            if (documentVersion.isReleased() || documentVersion.getActualReviewCycleNode().isEndNode() && !nodeResultIsFinishedandNotInvalidated && !documentVersion.isInvalidatedAll() && !documentVersion.isDeleted() && (!isEndCell || isEndCell && (evaluateCellConnections || !evaluateCellConnections && (documentVersion.isInvalidated() || documentVersion.isReleasedNegative())))) {
                boolean generated = this.taskOperations.generateSelectCellTask(sp.getActiveObjectList(), documentVersion, nodeInstanceRelease, true, evaluateCellConnections, checkAndRestore);
                if (generated) {
                    ++generatedSelectCellTasks;
                }
            } else {
                log.info((Object)"skipping generating selectCellTask because documentVersion is already released or invalidatedAll or actual node is not endNode or is endNode/endCell not fullfilling required conditions");
            }
        }
        count = generatedReviewTasks + generatedAttachedReviewTasks + generatedSelectCellTasks;
        return count;
    }

    private void deletePossiblePreviouslyCreatedNextNodeResults(DocumentVersion documentVersion, ReviewCycleNode actualReviewCycleNode) {
        List nodeResults = this.reviewCycleNodeResultDAO.getAll(actualReviewCycleNode, documentVersion);
        if (nodeResults == null || nodeResults.isEmpty()) {
            return;
        }
        SubProject sp = documentVersion.getDocument().getObjectPlanner().getObject().getObjectList().getSubProject();
        for (ReviewCycleNodeResult nodeResult : nodeResults) {
            log.warn((Object)("Found a duplicated nodeResult! id=[" + nodeResult.getId() + "] documentVersion=[" + documentVersion.getName() + "] docVerId=[" + documentVersion.getId() + "] actualReviewCycleNodeId=[" + actualReviewCycleNode.getId() + "] subProject=[" + sp.getId() + "] project=[" + sp.getProject().getId() + "] network=[" + sp.getProject().getNetwork().getId() + "]"));
            this.deleteReviewCycleNodeResultWithSubElements(nodeResult, false);
        }
    }

    @Override
    public void deleteReviewCycleNodeResultWithSubElementsId(Integer nodeResultId) {
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(nodeResultId);
        this.deleteReviewCycleNodeResultWithSubElements(nodeResult, true);
    }

    @Override
    public void deleteReviewCycleNodeResultWithSubElements(ReviewCycleNodeResult nodeResult, boolean moveNodeBack) {
        List tasks = this.taskOperations.getDocumentVersionTasksOfDocumentVersion(nodeResult.getDocumentVersion());
        int reviewCycleNodeInstanceId = this.getReviewCycleNodeInstanceRelease(nodeResult.getReviewCycleNode(), nodeResult.getDocumentVersion().getDocument()).getReviewCycleNodeInstance().getId();
        for (DocumentVersionTaskBase task : tasks) {
            if ((!(task instanceof ReviewableTask) || !((ReviewableTask)((Object)task)).getReviewCycleNodeInstanceId().equals(reviewCycleNodeInstanceId)) && !(task instanceof SelectCellConnectionTask)) continue;
            log.warn((Object)("Deleting taskId " + task.getId()));
            this.taskOperations.removeTask(task.getId());
        }
        HashMap<Integer, ReviewCyclePositionResult> deleteFirstList = new HashMap<Integer, ReviewCyclePositionResult>();
        HashMap<Integer, ReviewCyclePositionResult> deleteSecondList = new HashMap<Integer, ReviewCyclePositionResult>();
        ArrayList positionResults = new ArrayList(nodeResult.getReviewCycleNodePositionResults().values());
        for (Object posRes : positionResults) {
            deleteSecondList.put(posRes.getId(), (ReviewCyclePositionResult)posRes);
            List commentingResults = this.reviewCyclePositionResultDAO.getAllCommentingForResult(posRes.getId());
            for (ReviewCyclePositionResult commRes : commentingResults) {
                deleteFirstList.put(commRes.getId(), commRes);
            }
        }
        List commentingResults = this.reviewCyclePositionResultDAO.getAllCommentResultsOfNodeResult(nodeResult.getId());
        commentingResults.addAll(this.reviewCyclePositionResultDAO.getAllCommentingUnsignedEmpty(nodeResult.getDocumentVersion().getId(), nodeResult.getReviewCycleNode().getId()));
        for (Object commRes : commentingResults) {
            deleteFirstList.put(commRes.getId(), (ReviewCyclePositionResult)commRes);
        }
        log.warn((Object)("Deleting " + deleteFirstList.size() + " positionResults which are referencing (commenting) other positionResults"));
        Collection deleteFirsts = deleteFirstList.values();
        for (Object posRes : deleteFirsts) {
            this.deleteReviewCyclePositionResultsWithSubElementsId(posRes.getId(), false, true);
        }
        log.warn((Object)("Deleting " + deleteSecondList.size() + " positionResults"));
        Collection deleteSeconds = deleteSecondList.values();
        for (ReviewCyclePositionResult posRes : deleteSeconds) {
            this.deleteReviewCyclePositionResultsWithSubElementsId(posRes.getId(), true, false);
        }
        DocumentVersion docVersion = nodeResult.getDocumentVersion();
        ReviewCycleNodeInstanceImpl actualReviewCycleNodeInstance = docVersion.getActualReviewCycleNodeInstance();
        ReviewCycleInstance reviewCycleInstance = actualReviewCycleNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance();
        ReviewCycleNodeInstanceImpl reviewCycleNodeInstance = this.reviewCycleNodeInstanceDAO.getUnreleased(reviewCycleInstance, nodeResult.getReviewCycleNode());
        List<AttachedReviewCyclePositionImpl> attachedPositions = this.getAttachedPositions(reviewCycleNodeInstance, docVersion);
        for (AttachedReviewCyclePositionImpl attachedReviewCyclePosition : attachedPositions) {
            log.warn((Object)("Deleting attachedReviewCyclePosition with id=[" + attachedReviewCyclePosition.getId() + "]"));
            this.reviewCyclePositionDAO.delete(attachedReviewCyclePosition);
        }
        log.warn((Object)("Deleting nodeResult with id=[" + nodeResult.getId() + "]"));
        this.reviewCycleNodeResultDAO.delete(nodeResult);
        if (moveNodeBack && actualReviewCycleNodeInstance.getReviewCycleNode().getId().equals(nodeResult.getReviewCycleNode().getId())) {
            ReviewCycleNodeInstanceImpl newActualReviewCycleNodeInstance = null;
            Integer actualPosition = actualReviewCycleNodeInstance.getReviewCycleNode().getPosition();
            ReviewCycleNodeResult newNodeResult = null;
            boolean newActualNodeIsFinished = false;
            boolean newActualNodeHasNoPositions = false;
            if (actualPosition > 1) {
                ReviewCycleNode newActualReviewCycleNode = null;
                List nodeResults = this.reviewCycleNodeResultDAO.getAll(nodeResult.getReviewCycleNode(), docVersion);
                if (nodeResults != null && !nodeResults.isEmpty()) {
                    newActualReviewCycleNode = this.reviewCycleNodeResultDAO.get(nodeResult.getReviewCycleNode(), docVersion).getReviewCycleNode();
                    newActualReviewCycleNodeInstance = this.reviewCycleNodeInstanceDAO.getUnreleased(reviewCycleInstance, newActualReviewCycleNode);
                } else {
                    while (actualPosition > 1) {
                        Integer n = actualPosition;
                        Integer n2 = actualPosition = Integer.valueOf(actualPosition - 1);
                        newActualNodeIsFinished = false;
                        newActualReviewCycleNode = actualReviewCycleNodeInstance.getReviewCycleNode().getReviewCycleCell().getReviewCycleNodeByPosition(actualPosition);
                        newActualReviewCycleNodeInstance = this.reviewCycleNodeInstanceDAO.getUnreleased(reviewCycleInstance, newActualReviewCycleNode);
                        if (newActualReviewCycleNodeInstance == null) continue;
                        newNodeResult = this.reviewCycleNodeResultDAO.get(newActualReviewCycleNode, docVersion);
                        ReviewCycleNodeInstanceRelease newActualReviewCycleNodeInstanceRel = this.reviewCycleNodeInstanceDAO.getLatestReleased(newActualReviewCycleNodeInstance.getId());
                        List<ReviewCyclePosition> positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(newActualReviewCycleNodeInstanceRel, docVersion);
                        if (positions == null || positions.isEmpty()) {
                            if (newNodeResult == null) continue;
                            log.warn((Object)("Deleting empty (no positions) nodeResult with id=[" + newNodeResult.getId() + "]"));
                            this.reviewCycleNodeResultDAO.delete(newNodeResult);
                            newNodeResult = null;
                            continue;
                        }
                        if (newNodeResult != null) {
                            newActualNodeIsFinished = this.isNodeFinishedConsideringNodeResult(newActualReviewCycleNodeInstance, newNodeResult, docVersion);
                            break;
                        }
                        SubProject subProject = docVersion.getDocument().getDocumentList().getSubProject();
                        ReleasedObjectList objectList = subProject.getActiveObjectList();
                        log.info((Object)("Generating new missing nodeResult to newActualReviewCycleNodeInstanceId=[" + newActualReviewCycleNodeInstance.getId() + "]"));
                        newNodeResult = this.moveDocumentVersionToNode(actualReviewCycleNodeInstance, newActualReviewCycleNodeInstanceRel, objectList, (ReviewCycleNodeResultImpl)nodeResult, docVersion);
                    }
                }
            }
            if (newActualReviewCycleNodeInstance != null && newNodeResult != null) {
                log.warn((Object)("Setting documentVersions active node to the node prior the deleted one. New newActualReviewCycleNodeInstanceId=[" + newActualReviewCycleNodeInstance.getId() + "]"));
                docVersion.setActualReviewCycleNodeInstance(newActualReviewCycleNodeInstance);
                Integer newActualDocumentVersionStatus = newNodeResult.getReviewCycleResultOption() != null ? newNodeResult.getReviewCycleResultOption().getDocumentVersionStatus() : null;
                int oldStatus = docVersion.getStatus();
                if (newActualDocumentVersionStatus != null && newActualNodeIsFinished) {
                    docVersion.setStatus(newActualDocumentVersionStatus);
                } else {
                    docVersion.setStatus(1);
                }
                docVersion = this.documentVersionDAO.update(docVersion);
                if (!newActualNodeIsFinished) {
                    ((ReviewCycleNodeResultImpl)newNodeResult).setDocumentVersion(docVersion);
                    ((ReviewCycleNodeResultImpl)newNodeResult).setFinished(false);
                    ((ReviewCycleNodeResultImpl)newNodeResult).setReviewCycleResultOption(null);
                    ((ReviewCycleNodeResultImpl)newNodeResult).setDocumentDepartureDate(null);
                    ((ReviewCycleNodeResultImpl)newNodeResult).setActiveObjectListOfDocumentDeparture(null);
                    this.reviewCycleNodeResultDAO.update(newNodeResult);
                    ReviewCycleCellResult newCellResult = this.reviewCycleCellResultDAO.get(nodeResult.getReviewCycleNode().getReviewCycleCell().getId(), docVersion.getId());
                    ((ReviewCycleCellResultImpl)newCellResult).setDocumentVersion(docVersion);
                    ((ReviewCycleCellResultImpl)newCellResult).setFinished(false);
                    ((ReviewCycleCellResultImpl)newCellResult).setReviewCycleResultOption(newNodeResult.getReviewCycleResultOption());
                    this.reviewCycleCellResultDAO.update(newCellResult);
                    this.insertCreateMissingTasks(newNodeResult.getId(), true, 0);
                }
            }
        }
    }

    private void deleteReviewCyclePositionResultsWithSubElements(ReviewCyclePositionResult posRes) {
        String nrId = "";
        if (posRes.getReviewCycleNodeResult() != null) {
            nrId = posRes.getReviewCycleNodeResult().getId().toString();
        }
        log.warn((Object)("Deleting a ReviewCyclePositionResult id=[" + posRes.getId() + "] nodeResultId=[" + nrId + "]"));
        List tasks = this.taskOperations.getDocumentVersionTasksOfDocumentVersion(posRes.getDocumentVersion());
        for (DocumentVersionTaskBase task : tasks) {
            if ((!(task instanceof ReviewTaskDone) || !((ReviewTaskDone)task).getReviewCyclePositionResults().containsKey(posRes.getId())) && (!(task instanceof AttachedReviewTaskDone) || !((AttachedReviewTaskDone)task).getReviewCyclePositionResults().containsKey(posRes.getId()))) continue;
            this.taskOperations.removeTask(task.getId());
        }
        Collection attachments = posRes.getAttachments().values();
        for (Attachment att : attachments) {
            log.warn((Object)("Deleting attachment with id=[" + att.getId() + "] from positionResult with id=[" + posRes.getId() + "]"));
            this.attachmentOperations.deleteAttachment(att.getId());
        }
        this.reviewCyclePositionResultDAO.delete(posRes);
    }

    @Override
    public void deleteReviewCyclePositionResultsWithSubElementsId(Integer posResId, boolean checkNodeIsFinished, boolean isCommentReference) {
        boolean nodeIsFinished;
        ReviewCyclePositionResult posRes = this.reviewCyclePositionResultDAO.get(posResId);
        if (posRes == null) {
            return;
        }
        log.warn((Object)("Deleting posRes with id=[" + posResId + "]"));
        DocumentVersion docVersion = posRes.getDocumentVersion();
        boolean isLastDocVersion = docVersion.isLastDocumentVersion();
        int oldStatus = docVersion.getStatus();
        SubProject sp = docVersion.getDocument().getDocumentList().getSubProject();
        Project project = sp.getProject();
        Integer posResStatus = null;
        ReviewCycleCellResult cellResult = null;
        ReviewCycleResultOption posResResultOption = null;
        ReviewCycleNodeResult nodeResult = posRes.getReviewCycleNodeResult();
        ReviewCycleNodeInstanceRelease reviewCycleNodeInstanceRel = null;
        if (!isCommentReference) {
            cellResult = posRes.getReviewCycleNodeResult().getReviewCycleCellResult();
            ReviewCycleNode reviewCycleNode = posRes.getReviewCycleNode();
            posResResultOption = posRes.getReviewCycleResultOption();
            posResStatus = posResResultOption != null ? posResResultOption.getDocumentVersionStatus() : null;
            ReviewCycleInstanceRelease reviewCycleInstanceRelease = this.reviewCycleInstanceDAO.getReleased(sp.getActiveObjectList().getId(), docVersion.getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getId());
            reviewCycleNodeInstanceRel = this.reviewCycleNodeInstanceDAO.getReleased(reviewCycleInstanceRelease.getId(), reviewCycleNode.getId());
            List<ReviewCyclePosition> list = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(reviewCycleNodeInstanceRel, docVersion);
        }
        this.deleteReviewCyclePositionResultsWithSubElements(posRes);
        if (nodeResult != null) {
            nodeResult.getReviewCycleNodePositionResults().remove(posRes);
        }
        if (isCommentReference) {
            if (nodeResult != null) {
                this.reviewCycleNodeResultDAO.update(nodeResult);
            }
            return;
        }
        if (isLastDocVersion && posResStatus != null && (posResStatus == 4 || posResStatus == 5 || posResStatus == 7)) {
            if (posResStatus == 7 && docVersion.getDocument().getLastDocumentVersion() != null) {
                Document doc = docVersion.getDocument();
                doc.setVersionSet(true);
                this.documentDAO.update((DocumentImpl)doc);
                ReleasedDocument docRel = this.documentDAO.getReleased(doc.getId(), sp.getActiveDocumentList() != null ? sp.getActiveDocumentList().getId() : null);
                if (docRel != null) {
                    docRel.setVersionSet(true);
                    this.documentDAO.update(docRel);
                }
            }
            ((ReviewCycleNodeResultImpl)nodeResult).setFinished(false);
            ((ReviewCycleNodeResultImpl)nodeResult).setReviewCycleResultOption(null);
            ((ReviewCycleNodeResultImpl)nodeResult).setDocumentDepartureDate(null);
            ((ReviewCycleNodeResultImpl)nodeResult).setActiveObjectListOfDocumentDeparture(null);
            this.reviewCycleNodeResultDAO.update(nodeResult);
            cellResult.setFinished(false);
            cellResult.setReviewCycleResultOption(nodeResult.getReviewCycleResultOption());
            this.reviewCycleCellResultDAO.update(cellResult);
            docVersion.setStatus(1);
            docVersion = this.documentVersionDAO.update(docVersion);
            return;
        }
        if (checkNodeIsFinished && !(nodeIsFinished = this.isNodeFinishedConsideringNodeResult(reviewCycleNodeInstanceRel, nodeResult, docVersion))) {
            ((ReviewCycleNodeResultImpl)nodeResult).setFinished(false);
            ((ReviewCycleNodeResultImpl)nodeResult).setReviewCycleResultOption(null);
            ((ReviewCycleNodeResultImpl)nodeResult).setDocumentDepartureDate(null);
            ((ReviewCycleNodeResultImpl)nodeResult).setActiveObjectListOfDocumentDeparture(null);
            this.reviewCycleNodeResultDAO.update(nodeResult);
            cellResult.setFinished(false);
            cellResult.setReviewCycleResultOption(nodeResult.getReviewCycleResultOption());
            this.reviewCycleCellResultDAO.update(cellResult);
            if (oldStatus == 2) {
                String cellConnectionPartARule = null;
                String cellConnectionPartBRule = null;
                Collection incommingCellConnections = reviewCycleNodeInstanceRel.getReviewCycleCellInstance().getReviewCycleCell().getIncommingConnections().values();
                ReviewCycleCellConnection defaultCellConnection = null;
                for (ReviewCycleCellConnection incommingCellConnection : incommingCellConnections) {
                    if (!incommingCellConnection.isDefaultConnection()) continue;
                    defaultCellConnection = incommingCellConnection;
                    cellConnectionPartARule = defaultCellConnection.getPartARule() != null ? incommingCellConnection.getPartARule() : "";
                    cellConnectionPartBRule = defaultCellConnection.getPartBRule() != null ? incommingCellConnection.getPartBRule() : "";
                    break;
                }
                boolean versionPartChanged = false;
                if (cellConnectionPartARule != null && posResResultOption.getCellChangePartA() != null && posResResultOption.getCellChangePartA().length() > 0) {
                    docVersion.setVersionPartA(cellConnectionPartARule);
                    versionPartChanged = true;
                }
                if (cellConnectionPartBRule != null && posResResultOption.getCellChangePartB() != null && posResResultOption.getCellChangePartB().length() > 0) {
                    docVersion.setVersionPartB(cellConnectionPartBRule);
                    versionPartChanged = true;
                }
                if (versionPartChanged) {
                    ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)docVersion.getDocument().getObjectPlanner();
                    try {
                        docVersion.setName(this.ognlNumberCalculator.getNumber(defaultCellConnection, cellResult, project));
                    }
                    catch (NumberCalculatorException e) {
                        log.warn((Object)("Error when recalculating docVersionName with id=[" + docVersion.getId() + "]"));
                    }
                }
            }
            docVersion.setStatus(1);
            docVersion = this.documentVersionDAO.update(docVersion);
            this.insertCreateMissingTasks(nodeResult.getId(), true, 0);
        }
    }

    @Override
    public void updateMoveBackToActualNodeIfError(boolean verbose) {
        Calendar start = Calendar.getInstance();
        start.set(2008, 11, 14, 21, 0);
        Calendar end = Calendar.getInstance();
        List positionResults = this.reviewCyclePositionResultDAO.getAllSignedWithinTime(start.getTime(), end.getTime());
        HashMap<Integer, DocumentVersion> docVersionsWithError = new HashMap<Integer, DocumentVersion>();
        HashMap<Integer, org.clazzes.util.lang.Triple> docVersionsWithSpecialError = new HashMap<Integer, org.clazzes.util.lang.Triple>();
        for (Object res : positionResults) {
            if (docVersionsWithError.containsKey(((ReviewCyclePositionResultImpl)res).getDocumentVersion().getId())) continue;
            int dv_Status = ((ReviewCyclePositionResultImpl)res).getDocumentVersion().getStatus();
            boolean hasInvalidStatus = false;
            if (dv_Status == 7 || dv_Status == 4 || dv_Status == 5) {
                hasInvalidStatus = true;
            }
            boolean foundError = false;
            if (((ReviewCyclePositionResultImpl)res).getReviewCycleNode().getId().equals(((ReviewCyclePositionResultImpl)res).getDocumentVersion().getActualReviewCycleNode().getId()) || !((ReviewCyclePositionResultImpl)res).getReviewCycleNode().getReviewCycleCell().getId().equals(((ReviewCyclePositionResultImpl)res).getDocumentVersion().getActualReviewCycleNode().getReviewCycleCell().getId())) continue;
            Collection nodeInstances = ((ReviewCyclePositionResultImpl)res).getDocumentVersion().getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleNodeInstances().values();
            ReleasedObjectList activeObjectList = ((ReviewCyclePositionResultImpl)res).getActiveObjectList().getSubProject().getActiveObjectList();
            for (ReviewCycleNodeInstance nodeInstance : nodeInstances) {
                ReviewCycleInstanceRelease cycleInstRel = this.reviewCycleInstanceDAO.getReleased(activeObjectList.getId(), nodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
                ReviewCycleNodeInstanceRelease nodeInstRel = this.reviewCycleNodeInstanceDAO.getReleased(cycleInstRel.getId(), nodeInstance.getReviewCycleNode().getId());
                if (nodeInstance.getReviewCycleNode().getId().equals(((ReviewCyclePositionResultImpl)res).getReviewCycleNode().getId())) {
                    Collection positions = nodeInstRel.getReviewCyclePositions().values();
                    Collection allPosResults = ((ReviewCyclePositionResultImpl)res).getReviewCycleNodeResult().getReviewCycleNodePositionResults().values();
                    for (ReviewCyclePositionRelease pos : positions) {
                        ReviewCyclePositionResult posRes = this.reviewCyclePositionResultDAO.get(pos.getRealm(), ((ReviewCyclePositionResultImpl)res).getReviewCycleNodeResult(), pos.getProjectParticipation());
                        if (posRes == null) {
                            if (!hasInvalidStatus) {
                                docVersionsWithError.put(((ReviewCyclePositionResultImpl)res).getDocumentVersion().getId(), ((ReviewCyclePositionResultImpl)res).getDocumentVersion());
                            }
                            foundError = true;
                            break;
                        }
                        if (posRes.getSignature() != null) continue;
                        if (!hasInvalidStatus) {
                            docVersionsWithError.put(posRes.getDocumentVersion().getId(), posRes.getDocumentVersion());
                        }
                        foundError = true;
                        break;
                    }
                }
                if (!foundError) continue;
                break;
            }
            if (foundError) continue;
            String errorString = "";
            if (((ReviewCyclePositionResultImpl)res).getReviewCycleNodeResult().getReviewCycleResultOption() == null) {
                errorString = errorString + "ReviewCycleResultOption was null; ";
            }
            if (!((ReviewCyclePositionResultImpl)res).getReviewCycleNodeResult().isFinished()) {
                errorString = errorString + "ReviewCycleNodeResult.isFinished() is false; ";
            }
            if (((ReviewCyclePositionResultImpl)res).getReviewCycleNodeResult().getDocumentDepartureDate() == null) {
                errorString = errorString + "ReviewCycleNodeResult.documentDepatureDate is null;";
            }
            if (errorString.equals("") || docVersionsWithSpecialError.containsKey(((ReviewCyclePositionResultImpl)res).getDocumentVersion().getId())) continue;
            docVersionsWithSpecialError.put(((ReviewCyclePositionResultImpl)res).getDocumentVersion().getId(), new org.clazzes.util.lang.Triple((Object)((ReviewCyclePositionResultImpl)res).getDocumentVersion(), (Object)((ReviewCyclePositionResultImpl)res).getReviewCycleNodeResult(), (Object)errorString));
        }
        log.info((Object)(">>>>> >>>>> >>>>> found " + docVersionsWithError.size() + " docVersions with Errors:"));
        Collection docVersions = docVersionsWithError.values();
        for (DocumentVersion dv : docVersions) {
            log.info((Object)(">>>> ERROR IN DOCUMENTVERSION: docVersion=[" + dv.getName() + "] docVerId=[" + dv.getId() + "]"));
            this.insertRepairDV(dv, verbose);
        }
        log.info((Object)("... found " + docVersionsWithSpecialError.size() + " docVersions with regularly finished nodes and missing properties (Special Error w. nodeResults without isFinished/resultOption/depatureDate)"));
        Collection pairs = docVersionsWithSpecialError.values();
        for (org.clazzes.util.lang.Triple pair : pairs) {
            log.info((Object)("........ ERROR IN DOCUMENTVERSION: docVersion=[" + ((DocumentVersion)pair.getFirst()).getName() + "] docVerId=[" + ((DocumentVersion)pair.getFirst()).getId() + "] - Cause: " + (String)pair.getThird()));
            this.setNodeResultValuesToLastPositionResult(((ReviewCycleNodeResult)pair.getSecond()).getId(), verbose);
        }
        log.info((Object)".... Logging finished ....");
    }

    private void setNodeResultValuesToLastPositionResult(Integer nodeResultId, boolean verbose) {
        ReviewCycleNodeResultImpl nodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(nodeResultId);
        Integer documentVersionId = nodeResult.getDocumentVersion().getId();
        log.info((Object)(">>>>> Fixing Special error in docVersion=[" + nodeResult.getDocumentVersion().getName() + "] docVerId=[" + documentVersionId + "]"));
        ReviewCycleInstance cycleInstance = nodeResult.getDocumentVersion().getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance();
        ReviewCycleNodeInstanceImpl nodeInstance = this.reviewCycleNodeInstanceDAO.getUnreleased(cycleInstance, nodeResult.getReviewCycleNode());
        if (!this.isNodeFinished(nodeInstance, nodeResult, nodeResult.getDocumentVersion())) {
            return;
        }
        Collection positionResults = nodeResult.getReviewCycleNodePositionResults().values();
        ReviewCyclePositionResult lastPosRes = null;
        for (ReviewCyclePositionResult posRes : positionResults) {
            if (lastPosRes != null && !posRes.getSignature().getTime().after(lastPosRes.getSignature().getTime())) continue;
            lastPosRes = posRes;
        }
        nodeResult.setFinished(true);
        nodeResult.setReviewCycleResultOption(lastPosRes.getReviewCycleResultOption());
        nodeResult.setDocumentDepartureDate(lastPosRes.getSignature().getTime());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info((Object)(">>>>>>>>>>> Settings for nodeResult: finished=true resultOption=[" + nodeResult.getReviewCycleResultOption().getName() + " (id=" + nodeResult.getReviewCycleResultOption().getId() + ")] departureDate=[" + dateFormat.format(nodeResult.getDocumentDepartureDate()) + "]"));
        if (!verbose) {
            this.reviewCycleNodeResultDAO.update(nodeResult);
        }
    }

    private void insertRepairDV(DocumentVersion dv, boolean verbose) {
        log.info((Object)("Checking document version [id=" + dv.getId() + ",name=" + dv.getName() + "]..."));
        SubProject sp = dv.getDocument().getDocumentList().getSubProject();
        ReviewCycleInstanceRelease instanceRelease = this.reviewCycleInstanceDAO.getReleased(sp.getActiveObjectList().getId(), dv.getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleCellInstanceRelease cellInstance = this.reviewCycleCellInstanceDAO.getReleased(instanceRelease.getId(), dv.getActualReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleCell().getId());
        List nodeInstances = cellInstance.getReviewCycleNodeInstancesSortedByPosition();
        for (ReviewCycleNodeInstanceRelease nodeInstance : nodeInstances) {
            log.info((Object)(" Checking node instance [id=" + nodeInstance.getId() + ",name=" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "]..."));
            List<ReviewCyclePosition> positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(nodeInstance, dv);
            boolean foundError = false;
            for (ReviewCyclePosition position : positions) {
                ReviewCycleCellResult cellResult;
                List results = this.reviewCyclePositionResultDAO.getAllSigned(position.getRealm().getId(), nodeInstance.getReviewCycleNode().getId(), dv.getId(), position.getProjectParticipation().getId());
                log.info((Object)(" Found [" + results.size() + "] for position with id=[" + position.getId() + "] participation=[" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + "] realm=[" + position.getRealm().getCode() + " " + position.getRealm().getName() + "] -- the documentVersion is currently at node=[" + TapestryI18nHelper.getLocalizedString(dv.getActualReviewCycleNode().getName()) + "] with node_instance_id=[" + dv.getActualReviewCycleNodeInstance().getId() + "]"));
                if (results.size() == 0) {
                    foundError = true;
                    log.info((Object)("ERROR FOUND: found no results for position with id=[" + position.getId() + "] participation=[" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + "] realm=[" + position.getRealm().getCode() + " " + position.getRealm().getName() + "] -- the documentVersion is currently at node=[" + TapestryI18nHelper.getLocalizedString(dv.getActualReviewCycleNode().getName()) + "] with node_instance_id=[" + dv.getActualReviewCycleNodeInstance().getId() + "]"));
                }
                if (!foundError) continue;
                log.info((Object)("found error in reviewCycleNode - first node with error is [" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNodeInstance().getReviewCycleNode().getName()) + "] with position=[" + nodeInstance.getReviewCycleNodeInstance().getReviewCycleNode().getPosition() + "]"));
                dv.setActualReviewCycleNodeInstance(nodeInstance.getReviewCycleNodeInstance());
                log.info((Object)(">>>>>> SETTING NEW ACTUALREVIEWCYCLENODE in documentVersoin=[" + dv.getName() + "] with id=[" + dv.getId() + "] at node=[" + TapestryI18nHelper.getLocalizedString(dv.getActualReviewCycleNodeInstance().getReviewCycleNode().getName()) + "] with id=[" + dv.getActualReviewCycleNodeInstance().getReviewCycleNode().getId() + "]"));
                if (!verbose) {
                    dv = this.documentVersionDAO.update(dv);
                }
                if ((cellResult = this.getReviewCycleCellResult(dv.getActualReviewCycleNode().getReviewCycleCell().getId(), dv.getId())) != null && !verbose) {
                    cellResult.setFinished(false);
                    cellResult.setReviewCycleResultOption(null);
                    cellResult = this.reviewCycleCellResultDAO.update(cellResult);
                }
                try {
                    List dvTasks = this.taskOperations.getDocumentVersionTasksOfDocumentVersion(dv);
                    for (DocumentVersionTask dvt : dvTasks) {
                        if (dvt instanceof ReviewTask) {
                            ReviewCycleNodeInstanceImpl _nodeInstance = this.getReviewCycleNodeInstance(((ReviewTask)dvt).getReviewCycleNodeInstanceId());
                            if (_nodeInstance.getReviewCycleNode().getId().equals(nodeInstance.getReviewCycleNode().getId()) || _nodeInstance.getReviewCycleNode().getPosition() == 1) continue;
                            log.info((Object)(">>>>> DELETING REVIEWTASK with id=[" + dvt.getId() + "] of documentVersion=[" + dv.getName() + "] docVerId=[" + dv.getId() + "]"));
                            if (verbose) continue;
                            this.taskOperations.removeTask(dvt.getId());
                            continue;
                        }
                        if (!(dvt instanceof SelectCellConnectionTask)) continue;
                        log.info((Object)(">>>>> DELETING SELECTCELLCONNECTIONTASK with id=[" + dvt.getId() + "] of documentVersion=[" + dv.getName() + "] docVerId=[" + dv.getId() + "]"));
                        if (verbose) continue;
                        this.taskOperations.removeTask(dvt.getId());
                    }
                    break;
                }
                catch (RuntimeException e) {
                    log.info((Object)("Caught Exception while processing tasks: " + e.getMessage()));
                    break;
                }
            }
            if (foundError) break;
            log.info((Object)(" Finished node instance [id=" + nodeInstance.getId() + ",name=" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "]..."));
        }
        log.info((Object)("Finished document version [id=" + dv.getId() + ",name=" + dv.getName() + "]."));
    }

    @Override
    public void deleteDocumentVersionWithSubElements(Integer docVerId) throws ActionException {
        DocumentVersion dv = this.getDocumentVersion(docVerId);
        ReviewCycleCellResult cellResult = this.getReviewCycleCellResult(dv.getActualReviewCycleNode().getReviewCycleCell().getId(), docVerId);
        ReviewCycleCellConnectionResult nextCellConnectionResult = this.reviewCycleCellConnectionResultDAO.getBySourceDocumentVersion(docVerId);
        if (nextCellConnectionResult != null) {
            throw new ActionException("Der Plan \"" + dv.getName() + "\" konnte nicht gel\u00f6scht werden, da nachfolgende Versionen existieren!");
        }
        List docrefsReferencing = this.documentRefDAO.getAllReferencingDocumentVersion(docVerId);
        if (docrefsReferencing.size() > 0) {
            throw new ActionException("Der Plan \"" + dv.getName() + "\" konnte nicht gel\u00f6scht werden, da dieser vom Plan \"" + ((DocumentRef)docrefsReferencing.get(0)).getReferencedVersion().getName() + "\" referenziert wird!");
        }
        List referencesSinceDocVersion = this.documentRefDAO.getAllBetweenDocumentVersionRange(docVerId, null);
        DocumentImpl doc = (DocumentImpl)dv.getDocument();
        List<DocumentVersion> allVersions = doc.getDocumentVersionsSortedByVersion();
        block0: for (Object refSinceDocVersion : referencesSinceDocVersion) {
            for (int i = 0; i < allVersions.size(); ++i) {
                if (!dv.getId().equals(allVersions.get(i).getId())) continue;
                if (i < allVersions.size() - 1) {
                    ((DocumentRef)refSinceDocVersion).setSinceDocumentVersion(allVersions.get(i + 1));
                    this.documentRefDAO.update((DocumentRef)refSinceDocVersion);
                    continue block0;
                }
                this.documentRefDAO.delete((DocumentRef)refSinceDocVersion);
                continue block0;
            }
        }
        List referencesUntilVersion = this.documentRefDAO.getAllBetweenDocumentVersionRange(null, docVerId);
        block2: for (DocumentRef refUntilDocVersion : referencesUntilVersion) {
            for (int i = 0; i < allVersions.size(); ++i) {
                if (!docVerId.equals(allVersions.get(i).getId())) continue;
                if (i > 0) {
                    refUntilDocVersion.setUntilDocumentVersion(allVersions.get(i - 1));
                    this.documentRefDAO.update(refUntilDocVersion);
                    continue block2;
                }
                this.documentRefDAO.delete(refUntilDocVersion);
                continue block2;
            }
        }
        ArrayList nodeResults = new ArrayList(cellResult.getReviewCycleNodeResults().values());
        for (ReviewCycleNodeResult nodeResult : nodeResults) {
            this.deleteReviewCycleNodeResultWithSubElements(nodeResult, false);
        }
        List<StatusEMailSnippet> statusEmailSnippets = this.mailDAO.getStatusEmailSnippets(dv.getId());
        for (StatusEMailSnippet statusEMailSnippet : statusEmailSnippets) {
            this.mailDAO.deleteSnippet(statusEMailSnippet);
        }
        List<NodeListenerEMailSnippet> nodeListenerSnippets = this.mailDAO.getNodeListenerEmailSnippets(dv.getId());
        for (NodeListenerEMailSnippet nodeListenerEMailSnippet : nodeListenerSnippets) {
            this.mailDAO.deleteSnippet(nodeListenerEMailSnippet);
        }
        List list = this.taskOperations.getDocumentVersionTasksOfDocumentVersion(dv);
        for (Object task : list) {
            this.taskOperations.removeTask(((TaskBase)task).getId());
        }
        List list2 = this.reviewCycleCellConnectionResultDAO.getAllPointingToDocumentVersion(docVerId);
        for (ReviewCycleCellConnectionResultImpl connectionResult : list2) {
            List cellConnectionTasksDone = this.taskOperations.getSelectCellConnectionTasksDoneByConnectionResult(connectionResult.getId());
            Iterator iterator = cellConnectionTasksDone.iterator();
            while (iterator.hasNext()) {
                SelectCellConnectionTaskDone task = (SelectCellConnectionTaskDone)iterator.next();
                this.taskOperations.removeTask(task.getId());
            }
            ArrayList statements = new ArrayList(connectionResult.getStatements().values());
            for (ReviewCycleCellConnectionStatementResultImpl statement : statements) {
                this.reviewCycleCellConnectionResultDAO.deleteStatementResult(statement);
            }
            this.reviewCycleCellConnectionResultDAO.delete(connectionResult);
        }
        ReviewCycleEntryResult entryResult = this.reviewCycleEntryResultDAO.getByDocumentVersion(docVerId);
        if (entryResult != null) {
            ArrayList statementResults = new ArrayList(entryResult.getStatements().values());
            for (ReviewCycleEntryStatementResultImpl statementResult : statementResults) {
                this.reviewCycleEntryResultDAO.deleteStatementResult(statementResult);
            }
            ReviewCycleEntryTaskDone entryTaskDone = this.taskOperations.getReviewCycleEntryTaskDoneByEntryResult(entryResult.getId());
            if (entryTaskDone != null) {
                this.taskOperations.removeTask(entryTaskDone.getId());
            }
            this.reviewCycleEntryResultDAO.delete(entryResult);
        }
        this.reviewCycleCellResultDAO.delete(cellResult);
        if (dv.getDocument().getDocumentVersions().size() == 1 && dv.getDocument().isVersionSet()) {
            doc.setVersionSet(false);
            doc = this.documentDAO.update(doc);
        }
        this.orderOperations.deletePlottOrderItemsByDocumentVersion(dv.getId());
        this.documentVersionDAO.delete(dv);
    }

    @Override
    public void deleteInconsistentNodeResults(boolean verbose) {
        Calendar start = Calendar.getInstance();
        start.set(2008, 11, 14, 21, 0);
        Calendar end = Calendar.getInstance();
        Integer deleteCounter = 0;
        Integer deleteCanceledCounter = 0;
        Integer affectedDocVersionsCounter = 0;
        Integer affectedDocVersionsWithSubsequentCounter = 0;
        Integer affectedNodeResultMissingDataCounter = 0;
        List positionResults = this.reviewCyclePositionResultDAO.getAllSignedWithinTime(start.getTime(), end.getTime());
        log.info((Object)">>>>> >>>>> >>>>> starting check for inconsistent nodeResults");
        HashMap<Integer, DocumentVersion> docVersionsWithError = new HashMap<Integer, DocumentVersion>();
        for (ReviewCyclePositionResultImpl res : positionResults) {
            if (docVersionsWithError.containsKey(res.getDocumentVersion().getId())) continue;
            docVersionsWithError.put(res.getDocumentVersion().getId(), res.getDocumentVersion());
        }
        log.info((Object)(">>>>> >>>>> >>>>> found " + docVersionsWithError.size() + " docVersions to check for inconsistent nodeResults"));
        Collection docVersions = docVersionsWithError.values();
        for (DocumentVersion docVersion : docVersions) {
            DocumentVersion lastDocumentVersion;
            log.info((Object)"*************************************************************");
            log.info((Object)(">>>> CHECKING DOCUMENTVERSION: docVersion=[" + docVersion.getName() + "] docVerId=[" + docVersion.getId() + "]"));
            SubProject sp = docVersion.getDocument().getObjectPlanner().getObject().getObjectList().getSubProject();
            log.info((Object)("subProject=[" + sp.getCode() + " " + sp.getName() + " (" + sp.getId() + ")] project=[" + sp.getProject().getCode() + " " + sp.getProject().getName() + " (" + sp.getProject().getId() + ")] network=[" + sp.getProject().getNetwork().getName() + " (" + sp.getProject().getNetwork().getId() + ")]"));
            boolean docVersionAffected = false;
            boolean docVersionsActualNodeInstanceIsFinished = false;
            boolean allLatestNodesAreFinished = true;
            int dv_Status = docVersion.getStatus();
            boolean hasInvalidStatus = false;
            if (dv_Status == 7 || dv_Status == 4 || dv_Status == 5) {
                hasInvalidStatus = true;
            }
            if (hasInvalidStatus) {
                log.info((Object)">>>> To the actual docVersion is invalidated or deleted !!");
            }
            boolean lastDocumentVersionIsReleased = (lastDocumentVersion = docVersion.getDocument().getLastDocumentVersion()).getStatus() == 2 || lastDocumentVersion.getStatus() == 3;
            int i = -1;
            int actualDocVersionIndex = -1;
            List<DocumentVersion> otherDocVersions = docVersion.getDocument().getDocumentVersionsSortedByVersion();
            for (DocumentVersion otherDocVersion : otherDocVersions) {
                ++i;
                if (docVersion.getId().equals(otherDocVersion.getId())) {
                    actualDocVersionIndex = i;
                }
                log.info((Object)(" - otherDocVersion= " + otherDocVersion.getVersionPart()));
            }
            int subsequentDocVersions = i - actualDocVersionIndex;
            ReleasedObjectList activeObjectList = sp.getActiveObjectList();
            ReviewCycleNodeInstanceImpl docVersionsActualNodeInstance = docVersion.getActualReviewCycleNodeInstance();
            Integer docVersionsActualNodePosition = docVersionsActualNodeInstance.getReviewCycleNode().getPosition();
            log.info((Object)(">>>> docVersionsActualNodeInstanceName=[" + docVersionsActualNodeInstance.getReviewCycleNode().getName() + "] docVersionsActualNodePosition=[" + docVersionsActualNodePosition + "]"));
            List nodeInstances = docVersionsActualNodeInstance.getReviewCycleCellInstance().getReviewCycleNodeInstancesSortedByPosition();
            for (ReviewCycleNodeInstance nodeInstance : nodeInstances) {
                log.info((Object)(">>>> CHECKING nodeInstance: name=[" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "] position=[" + nodeInstance.getReviewCycleNode().getPosition() + "]"));
                ReviewCycleInstanceRelease cycleInstRel = this.reviewCycleInstanceDAO.getReleased(activeObjectList.getId(), nodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
                ReviewCycleNodeInstanceRelease nodeInstRel = this.reviewCycleNodeInstanceDAO.getReleased(cycleInstRel.getId(), nodeInstance.getReviewCycleNode().getId());
                Integer nodePosition = nodeInstance.getReviewCycleNode().getPosition();
                boolean isDocVersionsActualNodeInstance = docVersionsActualNodeInstance.getId().equals(nodeInstance.getId());
                List nodeResults = this.reviewCycleNodeResultDAO.getAll(nodeInstance.getReviewCycleNode(), docVersion);
                if (nodeResults != null && !nodeResults.isEmpty()) {
                    Object object;
                    boolean nodeIsFinished;
                    Integer n;
                    log.info((Object)(nodeResults.size() + " reviewCycleNodeResults found"));
                    if (nodeResults.size() > 1) {
                        Integer n2;
                        ReviewCycleNodeResult latestNodeResult = this.reviewCycleNodeResultDAO.get(nodeInstance.getReviewCycleNode(), docVersion);
                        boolean latestNodeIsFinished = this.isNodeFinishedConsideringNodeResult(nodeInstance, latestNodeResult, docVersion);
                        if (!latestNodeIsFinished) {
                            allLatestNodesAreFinished = false;
                        } else {
                            String missingNodeResultDataErrorString = "";
                            if (latestNodeResult.getReviewCycleResultOption() == null) {
                                missingNodeResultDataErrorString = missingNodeResultDataErrorString + "reviewCycleResultOption is null; ";
                            }
                            if (!latestNodeResult.isFinished()) {
                                missingNodeResultDataErrorString = missingNodeResultDataErrorString + "finished is false; ";
                            }
                            if (latestNodeResult.getDocumentDepartureDate() == null) {
                                missingNodeResultDataErrorString = missingNodeResultDataErrorString + "documentDepatureDate is null; ";
                            }
                            if (latestNodeResult.getActiveObjectListOfDocumentDeparture() == null) {
                                missingNodeResultDataErrorString = missingNodeResultDataErrorString + "activeObjectListOfDocumentDeparture is null;";
                            }
                            if (missingNodeResultDataErrorString.length() > 0 && nodePosition > 1 && nodePosition <= docVersionsActualNodePosition) {
                                if (!nodeInstance.getReviewCycleNode().isEndOfCell()) {
                                    n = affectedNodeResultMissingDataCounter;
                                    n2 = affectedNodeResultMissingDataCounter = Integer.valueOf(affectedNodeResultMissingDataCounter + 1);
                                }
                                log.info((Object)("++ actual finished nodeResult has missing data:" + missingNodeResultDataErrorString));
                            }
                        }
                        if (isDocVersionsActualNodeInstance && latestNodeIsFinished) {
                            docVersionsActualNodeInstanceIsFinished = true;
                        }
                        for (ReviewCycleNodeResult nodeResult : nodeResults) {
                            nodeIsFinished = this.isNodeFinishedConsideringNodeResult(nodeInstance, nodeResult, docVersion);
                            log.info((Object)(">> reviewCycleNodeResultId [" + nodeResult.getId() + "] ArrivalDate= " + nodeResult.getDocumentArrivalDate() + " nodeIsFinished=" + nodeIsFinished + " of node [" + nodeInstance.getReviewCycleNode().getName() + "] position=[" + nodePosition + "]"));
                            if (nodePosition > 1 && nodePosition > docVersionsActualNodePosition || nodePosition > 1 && nodePosition <= docVersionsActualNodePosition && !nodeResult.getId().equals(latestNodeResult.getId())) {
                                Integer n3;
                                if (!docVersionsActualNodeInstanceIsFinished && lastDocumentVersionIsReleased) {
                                    log.info((Object)(">>>> CANCELING planed DELETING of reviewCycleNodeResultId [" + nodeResult.getId() + "] of node [" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "] position=[" + nodePosition + "] because lastDocumentVersionIsReleased and docVersionsActualNodeInstance is not finished"));
                                    docVersionAffected = true;
                                    n2 = deleteCanceledCounter;
                                    n3 = deleteCanceledCounter = Integer.valueOf(deleteCanceledCounter + 1);
                                    continue;
                                }
                                log.info((Object)(">>>> DELETING reviewCycleNodeResultId [" + nodeResult.getId() + "] of node [" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "] position=[" + nodePosition + "]"));
                                docVersionAffected = true;
                                n2 = deleteCounter;
                                n3 = deleteCounter = Integer.valueOf(deleteCounter + 1);
                                if (verbose) continue;
                                this.deleteReviewCycleNodeResultWithSubElements(nodeResult, false);
                                continue;
                            }
                            log.info((Object)(">>>> NO ACTION for reviewCycleNodeResultId [" + nodeResult.getId() + "] of node [" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "] position=[" + nodePosition + "]: nodePosition == 1 OR latestNodeResult"));
                        }
                        continue;
                    }
                    if (nodeResults.size() != 1) continue;
                    ReviewCycleNodeResult nodeResult = (ReviewCycleNodeResult)nodeResults.get(0);
                    nodeIsFinished = this.isNodeFinishedConsideringNodeResult(nodeInstance, nodeResult, docVersion);
                    if (!nodeIsFinished) {
                        allLatestNodesAreFinished = false;
                    } else {
                        String missingNodeResultDataErrorString = "";
                        if (nodeResult.getReviewCycleResultOption() == null) {
                            missingNodeResultDataErrorString = missingNodeResultDataErrorString + "reviewCycleResultOption is null; ";
                        }
                        if (!nodeResult.isFinished()) {
                            missingNodeResultDataErrorString = missingNodeResultDataErrorString + "finished is false; ";
                        }
                        if (nodeResult.getDocumentDepartureDate() == null) {
                            missingNodeResultDataErrorString = missingNodeResultDataErrorString + "documentDepatureDate is null; ";
                        }
                        if (nodeResult.getActiveObjectListOfDocumentDeparture() == null) {
                            missingNodeResultDataErrorString = missingNodeResultDataErrorString + "activeObjectListOfDocumentDeparture is null;";
                        }
                        if (missingNodeResultDataErrorString.length() > 0 && nodePosition > 1 && nodePosition <= docVersionsActualNodePosition) {
                            if (!nodeInstance.getReviewCycleNode().isEndOfCell()) {
                                object = affectedNodeResultMissingDataCounter;
                                n = affectedNodeResultMissingDataCounter = Integer.valueOf(affectedNodeResultMissingDataCounter + 1);
                            }
                            log.info((Object)("++ actual finished nodeResult has missing data:" + missingNodeResultDataErrorString));
                        }
                    }
                    if (isDocVersionsActualNodeInstance && nodeIsFinished) {
                        docVersionsActualNodeInstanceIsFinished = true;
                    }
                    log.info((Object)(">> reviewCycleNodeResultId [" + nodeResult.getId() + "] ArrivalDate= " + nodeResult.getDocumentArrivalDate() + " nodeIsFinished=" + nodeIsFinished + " of node [" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "] position=[" + nodePosition + "]"));
                    if (nodePosition > 1 && nodePosition > docVersionsActualNodePosition) {
                        if (!docVersionsActualNodeInstanceIsFinished && lastDocumentVersionIsReleased) {
                            log.info((Object)(">>>> CANCELING planed DELETING of reviewCycleNodeResultId [" + nodeResult.getId() + "] of node [" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "] position=[" + nodePosition + "] because lastDocumentVersionIsReleased and docVersionsActualNodeInstance is not finished"));
                            docVersionAffected = true;
                            Integer n4 = deleteCanceledCounter;
                            deleteCanceledCounter = deleteCanceledCounter + 1;
                            object = deleteCanceledCounter;
                            continue;
                        }
                        log.info((Object)(">>>> DELETING reviewCycleNodeResultId [" + nodeResult.getId() + "] of node [" + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + "] position=[" + nodePosition + "]"));
                        docVersionAffected = true;
                        Integer n5 = deleteCounter;
                        deleteCounter = deleteCounter + 1;
                        object = deleteCounter;
                        if (verbose) continue;
                        this.deleteReviewCycleNodeResultWithSubElements(nodeResult, false);
                        continue;
                    }
                    log.info((Object)">>>> This node is OK");
                    continue;
                }
                log.info((Object)"No reviewCycleNodeResults found");
            }
            if (!docVersionAffected) continue;
            log.info((Object)"----++++> This docVersion has inconsistent nodeResults !!");
            Object object = affectedDocVersionsCounter;
            Integer n = affectedDocVersionsCounter = Integer.valueOf(affectedDocVersionsCounter + 1);
            if (subsequentDocVersions > 0 && !allLatestNodesAreFinished) {
                log.info((Object)("--------> To the actual docVersion there exist " + subsequentDocVersions + " subsequent docVersions, which are invalid !!"));
                object = affectedDocVersionsWithSubsequentCounter;
                n = affectedDocVersionsWithSubsequentCounter = Integer.valueOf(affectedDocVersionsWithSubsequentCounter + 1);
                continue;
            }
            log.info((Object)"--------> To the actual docVersion there exist NO subsequent docVersions, which are invalid !!");
        }
        log.info((Object)">>>>> >>>>> >>>>> FINISHED check for inconsistent nodeResults");
        log.info((Object)(">>>> " + affectedDocVersionsCounter + " documentVersions have inconsistent nodeResults !!"));
        log.info((Object)(">>>> " + affectedDocVersionsWithSubsequentCounter + " documentVersions have subsequent docVersions, which are invalid !!"));
        log.info((Object)(">>>> CANCELED " + deleteCanceledCounter + " planed DELETING of inconsistent nodeResults because lastDocumentVersionIsReleased and docVersionsActualNodeInstance is not finished!!"));
        log.info((Object)(">>>> DELETED " + deleteCounter + " inconsistent nodeResults !!"));
        log.info((Object)(">>>> There are " + affectedNodeResultMissingDataCounter + " nodeResults with missing data !!"));
        log.info((Object)">>>>> >>>>> >>>>> FINISHED report of check for inconsistent nodeResults");
    }

    @Override
    public Integer getNumberOfDocumentVersionsOfProjectWithinTime(Integer projectId, Calendar activeMonth) {
        List versions = this.documentVersionDAO.getAllOfProjectWithinTime(projectId, activeMonth);
        if (versions == null || versions.size() == 0) {
            return null;
        }
        return versions.size();
    }

    @Override
    public ReviewCyclePositionResult getLastReviewCyclePositionResultByOptionValue(Integer documentVersionId, int statusValue) {
        return this.reviewCyclePositionResultDAO.getLastByOptionValue(documentVersionId, statusValue);
    }

    @Override
    public List getAllDocumentRefsFromDocument(Integer docImplId) {
        return this.documentRefDAO.getAllFromDocument(docImplId);
    }

    @Override
    public TemporaryDocumentVersion generateDocumentVersionRevisionNumber(Integer revisedDocumentVersionId, TemporaryDocumentVersion temporaryDocumentVersion) {
        DocumentVersion revisedDocumentVersion = this.getDocumentVersion(revisedDocumentVersionId);
        temporaryDocumentVersion.setName(revisedDocumentVersion.getName());
        temporaryDocumentVersion.setAlternativeName(revisedDocumentVersion.getAlternativeName());
        temporaryDocumentVersion.setVersionPartA(revisedDocumentVersion.getVersionPartA());
        temporaryDocumentVersion.setVersionPartB(revisedDocumentVersion.getVersionPartB());
        temporaryDocumentVersion.setVersionPartSeperator(revisedDocumentVersion.getVersionPartSeperator());
        OgnlNumberCalculator ncalc = this.ognlNumberCalculator;
        Project project = revisedDocumentVersion.getDocument().getDocumentList().getSubProject().getProject();
        try {
            temporaryDocumentVersion.setLastSeperator(ncalc.getLastSeperator(null, project));
        }
        catch (NumberCalculatorException e) {
            throw new ActionException("Das Nummerpattern konnte nicht durchgef\u00fchrt werden", e);
        }
        return temporaryDocumentVersion;
    }

    @Override
    public DocumentVersion signDocumentVersionUploadWithInvalidation(DocumentVersion oldDocumentVersionToInvalidate, List temporaryComments, TemporaryDocumentVersion tempDocumentVersion, ReviewCycleCellConnection connection, List<ReviewCycleCellConnectionStatementResult> statements, Collection<MatrixEditItem> selectedAttachedReviewers, ReviewCycleNodeInstanceRelease nodeInstAttachedR, boolean isAuthorizationCheckboxChecked, String invalidationComment, ProjectParticipant signer, String password, CDESCertificate cert) throws WrongPasswordException, FrontendException {
        ReviewCycleResultOption option = connection.getDestinationCell().getReviewCycle().getDocumentVersionInvalidationOption();
        option.setAuthorized(isAuthorizationCheckboxChecked);
        oldDocumentVersionToInvalidate = this.invalidateDocumentVersion(oldDocumentVersionToInvalidate.getId(), invalidationComment, signer, option, password, cert, true, false);
        return this.signReviewCycleCellChange(temporaryComments, signer, password, connection, tempDocumentVersion, oldDocumentVersionToInvalidate, null, cert, statements, selectedAttachedReviewers, nodeInstAttachedR);
    }

    @Override
    public DocumentVersion signDocumentVersionRevision(TemporaryDocumentVersion tdv, ProjectParticipant signer, String password, CDESCertificate cert, List statements, Collection<MatrixEditItem> attachedReviewers, ReviewCycleNodeInstanceRelease nodeInstAttachedR) throws WrongPasswordException, FrontendException {
        CDESSignature sign;
        ReviewCycleCellConnection connection = this.getReviewCycleCellConnection(tdv.getRevisionCellConnectionId());
        Pair<DocumentVersion, ReviewCycleNodeInstanceRelease> p = this.insertDocumentVersion(tdv, connection.getDestinationCell(), connection.getDocumentVersionStatus());
        DocumentVersion version = (DocumentVersion)p.getFirst();
        version.setRevisedDocumentVersion(tdv.getRevisedDocumentVersion());
        SubProject subProject = version.getDocument().getDocumentList().getSubProject();
        ReleasedObjectList objectList = subProject.getActiveObjectList();
        ReviewCycleNodeInstanceImpl versionNodeInstance = this.reviewCycleNodeInstanceDAO.get(tdv.getRevisedDocumentVersion().getActualReviewCycleNodeInstance().getId());
        ReviewCycleInstanceRelease instanceReleased = this.reviewCycleInstanceDAO.getReleased(objectList.getId(), versionNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleNodeInstanceRelease versionNodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(instanceReleased.getId(), versionNodeInstance.getReviewCycleNode().getId());
        if (objectList == null) {
            throw new ActionException("No active ObjectList was found in the SubProjekt with id " + subProject.getId());
        }
        if (attachedReviewers != null) {
            this.updateAttachedReviewCyclePositions(attachedReviewers, version, objectList, nodeInstAttachedR.getReviewCycleNodeInstance());
        }
        DocumentImpl document = this.documentDAO.get(tdv.getDocumentId());
        Network network = document.getDocumentList().getSubProject().getProject().getNetwork();
        ReviewCycleCellConnectionResultImpl res = new ReviewCycleCellConnectionResultImpl();
        ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(document.getDocumentList().getSubProject().getActiveObjectList().getId(), document.getObjectPlanner().getId());
        DocumentVersion revisedDocumentVersion = this.getDocumentVersion(tdv.getRevisedDocumentVersion().getId());
        res.setDestinationDocumentVersion(version);
        res.setSourceDocumentVersion(revisedDocumentVersion);
        res.setProjectParticipant(signer);
        res.setResultDate(new Date(System.currentTimeMillis()));
        res.setComment(tdv.getComment());
        ReviewCycleCellResultImpl cellResult = (ReviewCycleCellResultImpl)this.reviewCycleCellResultDAO.get(res.getSourceDocumentVersion().getActualReviewCycleNode().getReviewCycleCell().getId(), res.getSourceDocumentVersion().getId());
        ReviewCycleNodeResultImpl oldNodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(revisedDocumentVersion.getActualReviewCycleNode(), revisedDocumentVersion);
        ReviewCycleCellResult newCellResult = this.generateNextCellResults(version, objectList, ((ReviewCycleNodeInstanceRelease)p.getSecond()).getReviewCycleCellInstance().getReviewCycleInstance());
        res.setDestinationReviewCycleCellResult(newCellResult);
        res.setSourceReviewCycleCellResult(cellResult);
        res = (ReviewCycleCellConnectionResultImpl)this.reviewCycleCellConnectionResultDAO.save(res);
        try {
            DigestCalculator dig = this.digestCalculatorFactory.getDigestCalculator(network, res);
            DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
            res.setDigestCalculatorType(t);
            res.setDigest(dig.getDigest(res));
            File file = this.fileFinder.findFile(version.getFileName(), CDESFileRepository.PLANREPOSITORY);
            DigestCalculator fileDig = this.digestCalculatorFactory.getDigestCalculator(network, file);
            version.setFileDigester(this.digestCalculatorDAO.get(fileDig.getClass().getName()));
            version.setFileDigest(fileDig.getDigest(file));
            SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(network, res);
            sign = sig.createSignature(signer, dig.getSignableContent(res), cert, password);
            sign = this.signatureDAO.save(sign);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("Error calculating digest", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Error handling file", e);
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("Error calculating signature", e);
        }
        res.setSignature(sign);
        oldNodeResult.setFinished(true);
        oldNodeResult.setDocumentDepartureDate(new Date(System.currentTimeMillis()));
        oldNodeResult.setActiveObjectListOfDocumentDeparture(objectList);
        this.reviewCycleNodeResultDAO.update(oldNodeResult);
        cellResult.setDocumentDepartureDate(new Date(System.currentTimeMillis()));
        cellResult.setNextReviewCycleCell(newCellResult.getReviewCycleCell());
        newCellResult.setPreviousReviewCycleCell(cellResult.getReviewCycleCell());
        this.firePostListenersEvent(oldNodeResult.getDocumentVersion(), versionNodeInstanceRelease, objectList);
        this.reviewCycleCellResultDAO.update(cellResult);
        this.reviewCycleCellResultDAO.update(newCellResult);
        version = this.documentVersionDAO.update(version);
        this.documentDAO.update((DocumentImpl)version.getDocument());
        res = (ReviewCycleCellConnectionResultImpl)this.reviewCycleCellConnectionResultDAO.update(res);
        this.saveDocumentReferences(tdv.getDocumentRefs(), version);
        return version;
    }

    @Override
    public boolean isDocumentNumberAlreadyInUse(String documentNumber, Integer documentImplId) {
        return this.documentVersionDAO.isDocumentNumberAlreadyInUse(documentNumber, documentImplId);
    }

    @Override
    public void invalidateAllRevisedDocumentVersions(Integer documentId) {
        DocumentImpl document = this.getDocument(documentId);
        List<DocumentVersion> versions = document.getDocumentVersionsSortedByVersion();
        for (DocumentVersion version : versions) {
            if (version.getDocumentVersionRevisions() == null || version.getDocumentVersionRevisions().size() <= 0 || version.getStatus() != 2) continue;
            version.setStatus(4);
            this.documentVersionDAO.update(version);
            Calendar now = Calendar.getInstance();
            DocumentVersionStatusChange change = new DocumentVersionStatusChange();
            change.setChangeDate(now);
            change.setDocumentVersionId(version.getId());
            change.setFileName(version.getFileName());
            change.setName(version.getName());
            change.setNewStatus(version.getStatus());
            this.documentVersionDAO.saveStatusChange(change);
        }
    }

    @Override
    public List getReviewCyclePositionEntries(Integer documentImplId, Integer activeSubProjectId, Locale locale) {
        SubProject activeSubProject = this.subProjectDAO.get(activeSubProjectId);
        ArrayList<ReviewCyclePositionEntry> positionEntries = new ArrayList<ReviewCyclePositionEntry>();
        DocumentImpl document = this.getDocument(documentImplId);
        Collection<DocumentVersion> docVersions = document.getAllDocumentVersions();
        ReleasedObjectList olistRelease = this.objectOperations.getActiveObjectList(activeSubProjectId);
        Project project = olistRelease.getSubProject().getProject();
        ReleasedObjectPlanner releasedPlanner = this.objectOperations.getReleasedObjectPlannerFromActiveObjectList(document.getObjectPlanner().getId(), activeSubProjectId);
        boolean isObjectPlannerDeleted = false;
        if (releasedPlanner == null && (releasedPlanner = this.objectPlannerDAO.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(document.getObjectPlanner().getId(), olistRelease.getObjectList().getId())) != null) {
            isObjectPlannerDeleted = true;
        }
        DocumentBase releasedDocument = null;
        if (olistRelease.getSubProject().getActiveDocumentList() != null) {
            releasedDocument = this.documentDAO.getReleased(document.getId(), olistRelease.getSubProject().getActiveDocumentList().getId());
        }
        Date planDeliverCatalogueStartDate = releasedDocument != null ? releasedDocument.getStartDate() : document.getStartDate();
        Date planDeliverCatalogueEndDate = releasedDocument != null ? releasedDocument.getEndDate() : document.getEndDate();
        String planerNameString = "";
        if (docVersions != null && docVersions.size() > 0) {
            for (DocumentVersion docVersion : docVersions) {
                ReviewCycleNodeResult nodeRes = this.getReviewCycleNodeResult(docVersion.getActualReviewCycleNode(), docVersion);
                Date releaseDate = null;
                if (nodeRes != null && docVersion.getStatus() != 1) {
                    ReviewCyclePositionResult latestPositionResult = this.getLatestPositionResultOfDocumentVersion(docVersion.getId());
                    if (latestPositionResult == null && docVersion.getStatus() == 2) {
                        releaseDate = nodeRes.getDocumentArrivalDate();
                    } else if (latestPositionResult != null && latestPositionResult.getReviewCycleResultOption() != null && Integer.valueOf(2).equals(latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus())) {
                        releaseDate = latestPositionResult.getResultDate();
                    }
                }
                int status = isObjectPlannerDeleted ? 3 : (docVersion.isInvalidatedAll() ? 1 : (docVersion.isInvalidated() ? 2 : 0));
                ReviewCycleCellConnectionResult cellConnectionResult = this.getReviewCycleCellConnectionResultByDocumentVersion(docVersion.getId());
                if (cellConnectionResult != null) {
                    planerNameString = cellConnectionResult.getProjectParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + cellConnectionResult.getProjectParticipant().getParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + ")" + (cellConnectionResult.getProjectParticipant().isMainParticipant() ? "" : " i.V. " + cellConnectionResult.getProjectParticipant().getOrganisationPerson().getPerson().getCommonName());
                    ReviewCyclePositionEntry versionEntry = new ReviewCyclePositionEntry();
                    versionEntry.setType("Upload");
                    versionEntry.setStatus(status);
                    versionEntry.setCellName(cellConnectionResult.getDestinationReviewCycleCellResult().getReviewCycleCell().getName());
                    versionEntry.setDocumentContent(releasedDocument != null ? releasedDocument.getContent() : document.getContent());
                    versionEntry.setDocumentNumber(docVersion.getName());
                    versionEntry.setUnversionedDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
                    versionEntry.setObjectText(releasedPlanner.getObject().getCode() + " " + releasedPlanner.getObject().getName());
                    if (docVersion.isLastDocumentVersion()) {
                        versionEntry.setDocumentStatus(DocumentTranslator.getStatusName(I18nFactory.getI18n(locale), docVersion.getStatus()));
                    }
                    versionEntry.setPlannerName(planerNameString);
                    versionEntry.setReviewerName(planerNameString);
                    versionEntry.setObjectPlannerText(releasedPlanner.getCode() + " " + releasedPlanner.getArea() + (isObjectPlannerDeleted ? " (gel\u00f6scht!)" : ""));
                    versionEntry.setReviewCycleInstanceText(releasedPlanner.getReviewCycleInstance().getName());
                    versionEntry.setDeletedObjectPlanner(isObjectPlannerDeleted);
                    versionEntry.setReviewPositionResultComment(cellConnectionResult.getComment());
                    versionEntry.setUploadDate(docVersion.getUploaded());
                    versionEntry.setSignatureDate(cellConnectionResult.getResultDate());
                    versionEntry.setPlanDeliverCatalogueStartDate(planDeliverCatalogueStartDate);
                    versionEntry.setPlanDeliverCatalogueEndDate(planDeliverCatalogueEndDate);
                    versionEntry.setNodeName(TapestryI18nHelper.getLocalizedString(cellConnectionResult.getSourceDocumentVersion().getActualReviewCycleNode().getName()));
                    versionEntry.setReleaseDate(releaseDate);
                    ReviewCycleNodeInstanceImpl lastNodeInstance = cellConnectionResult.getSourceDocumentVersion().getActualReviewCycleNodeInstance();
                    ReviewCycleNodeInstanceRelease lastNodeInstanceReleased = this.reviewCycleNodeInstanceDAO.getReleased(releasedPlanner.getReviewCycleInstance().getId(), lastNodeInstance.getReviewCycleNode().getId());
                    ReviewCycleNodeResult lastNodeResult = this.reviewCycleNodeResultDAO.get(lastNodeInstance.getReviewCycleNode(), cellConnectionResult.getSourceDocumentVersion());
                    if (lastNodeResult != null && lastNodeResult.getDocumentArrivalDate() != null) {
                        Date effectiveStartDate = lastNodeResult.getDocumentArrivalDate();
                        versionEntry.setEffectiveStartDate(effectiveStartDate);
                        versionEntry.setEffectiveEndDate(cellConnectionResult.getResultDate());
                        HolidayCalculator holidayCalculator = this.holidayCalculatorFactory.getInstance(activeSubProject.getProject());
                        Calendar start = Calendar.getInstance();
                        start.setTime(effectiveStartDate);
                        Calendar end = Calendar.getInstance();
                        end.setTime(cellConnectionResult.getResultDate());
                        int effectiveDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                        versionEntry.setEffectiveDuration(effectiveDuration);
                        versionEntry.setPlannedStartDate(effectiveStartDate);
                        Calendar plannedEndDate = holidayCalculator.addWorkingDays(DateHelper.getCalendar(effectiveStartDate), lastNodeInstanceReleased != null ? lastNodeInstanceReleased.getDuration() : lastNodeInstance.getDuration());
                        versionEntry.setPlannedEndDate(plannedEndDate.getTime());
                        start = Calendar.getInstance();
                        start.setTime(versionEntry.getPlannedStartDate());
                        end = Calendar.getInstance();
                        end.setTime(versionEntry.getPlannedEndDate());
                        int plannedDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                        versionEntry.setPlannedDuration(plannedDuration);
                    }
                    positionEntries.add(versionEntry);
                    if (cellConnectionResult.getStatements() != null && !cellConnectionResult.getStatements().isEmpty()) {
                        for (ReviewCycleStatementResult res : cellConnectionResult.getStatements().values()) {
                            ReviewCyclePositionEntry statementEntry = new ReviewCyclePositionEntry();
                            statementEntry.setType("Stellungnahme");
                            statementEntry.setStatus(status);
                            statementEntry.setReviewPositionResultComment(res.getComment());
                            statementEntry.setRealmName(res.getRealm().getName());
                            statementEntry.setReviewPositionResultText(res.getReviewCycleResultOption().getName());
                            statementEntry.setCellName(cellConnectionResult.getDestinationReviewCycleCellResult().getReviewCycleCell().getName());
                            statementEntry.setDocumentContent(releasedDocument != null ? releasedDocument.getContent() : document.getContent());
                            statementEntry.setDocumentNumber(docVersion.getName());
                            statementEntry.setUnversionedDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
                            statementEntry.setObjectText(releasedPlanner.getObject().getCode() + " " + releasedPlanner.getObject().getName());
                            if (docVersion.isLastDocumentVersion()) {
                                statementEntry.setDocumentStatus(DocumentTranslator.getStatusName(I18nFactory.getI18n(locale), docVersion.getStatus()));
                            }
                            statementEntry.setPlannerName(planerNameString);
                            statementEntry.setReviewerName(planerNameString);
                            statementEntry.setObjectPlannerText(releasedPlanner.getCode() + " " + releasedPlanner.getArea() + (isObjectPlannerDeleted ? " (gel\u00f6scht!)" : ""));
                            statementEntry.setReviewCycleInstanceText(releasedPlanner.getReviewCycleInstance().getName());
                            statementEntry.setDeletedObjectPlanner(isObjectPlannerDeleted);
                            statementEntry.setUploadDate(docVersion.getUploaded());
                            statementEntry.setSignatureDate(cellConnectionResult.getResultDate());
                            statementEntry.setPlanDeliverCatalogueStartDate(planDeliverCatalogueStartDate);
                            statementEntry.setPlanDeliverCatalogueEndDate(planDeliverCatalogueEndDate);
                            statementEntry.setEffectiveEndDate(versionEntry.getEffectiveEndDate());
                            statementEntry.setEffectiveStartDate(versionEntry.getEffectiveStartDate());
                            statementEntry.setPlannedEndDate(versionEntry.getPlannedEndDate());
                            statementEntry.setPlannedStartDate(versionEntry.getPlannedStartDate());
                            statementEntry.setNodeName(TapestryI18nHelper.getLocalizedString(cellConnectionResult.getSourceDocumentVersion().getActualReviewCycleNode().getName()));
                            statementEntry.setReleaseDate(releaseDate);
                            positionEntries.add(statementEntry);
                        }
                    }
                } else {
                    ReviewCycleEntryResult entryResult = this.getReviewCycleEntryResultByDocumentVersion(docVersion.getId());
                    planerNameString = entryResult.getProjectParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + entryResult.getProjectParticipant().getParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + ")" + (entryResult.getProjectParticipant().isMainParticipant() ? "" : " i.V. " + entryResult.getProjectParticipant().getOrganisationPerson().getPerson().getCommonName());
                    ReviewCyclePositionEntry versionEntry = new ReviewCyclePositionEntry();
                    versionEntry.setType("Initialupload");
                    versionEntry.setStatus(status);
                    versionEntry.setCellName(entryResult.getDocumentVersion().getActualReviewCycleNode().getReviewCycleCell().getName());
                    versionEntry.setDocumentContent(releasedDocument != null ? releasedDocument.getContent() : document.getContent());
                    versionEntry.setDocumentNumber(docVersion.getName());
                    versionEntry.setUnversionedDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
                    versionEntry.setObjectText(releasedPlanner.getObject().getCode() + " " + releasedPlanner.getObject().getName());
                    if (docVersion.isLastDocumentVersion()) {
                        versionEntry.setDocumentStatus(DocumentTranslator.getStatusName(I18nFactory.getI18n(locale), docVersion.getStatus()));
                    }
                    versionEntry.setNodeName(TapestryI18nHelper.getLocalizedString(entryResult.getDocumentVersion().getActualReviewCycleNode().getName()));
                    versionEntry.setPlannerName(planerNameString);
                    versionEntry.setReviewerName(planerNameString);
                    versionEntry.setObjectPlannerText(releasedPlanner.getCode() + " " + releasedPlanner.getArea() + (isObjectPlannerDeleted ? " (gel\u00f6scht!)" : ""));
                    versionEntry.setReviewCycleInstanceText(releasedPlanner.getReviewCycleInstance().getName());
                    versionEntry.setDeletedObjectPlanner(isObjectPlannerDeleted);
                    versionEntry.setReviewPositionResultComment(entryResult.getComment());
                    versionEntry.setUploadDate(docVersion.getUploaded());
                    versionEntry.setSignatureDate(entryResult.getResultDate());
                    versionEntry.setPlanDeliverCatalogueStartDate(planDeliverCatalogueStartDate);
                    versionEntry.setPlanDeliverCatalogueEndDate(planDeliverCatalogueEndDate);
                    versionEntry.setEffectiveStartDate(entryResult.getResultDate());
                    if (versionEntry.getPlanDeliverCatalogueStartDate() != null) {
                        HolidayCalculator holidayCalculator = this.holidayCalculatorFactory.getInstance(activeSubProject.getProject());
                        Calendar start = Calendar.getInstance();
                        start.setTime(versionEntry.getPlanDeliverCatalogueStartDate());
                        Calendar end = Calendar.getInstance();
                        end.setTime(versionEntry.getEffectiveStartDate());
                        versionEntry.setPlannedStartDate(versionEntry.getPlanDeliverCatalogueStartDate());
                        int effectiveDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                        versionEntry.setEffectiveDuration(effectiveDuration);
                    }
                    versionEntry.setReleaseDate(releaseDate);
                    positionEntries.add(versionEntry);
                    if (entryResult.getStatements() != null && !entryResult.getStatements().isEmpty()) {
                        for (ReviewCycleStatementResult res : entryResult.getStatements().values()) {
                            ReviewCyclePositionEntry statementEntry = new ReviewCyclePositionEntry();
                            statementEntry.setType("Stellungnahme");
                            statementEntry.setStatus(status);
                            statementEntry.setReviewPositionResultComment(res.getComment());
                            statementEntry.setRealmName(res.getRealm().getName());
                            statementEntry.setReviewPositionResultText(res.getReviewCycleResultOption().getName());
                            statementEntry.setCellName(docVersion.getActualReviewCycleNode().getReviewCycleCell().getName());
                            statementEntry.setDocumentContent(releasedDocument != null ? releasedDocument.getContent() : document.getContent());
                            statementEntry.setDocumentNumber(docVersion.getName());
                            statementEntry.setUnversionedDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
                            statementEntry.setObjectText(releasedPlanner.getObject().getCode() + " " + releasedPlanner.getObject().getName());
                            if (docVersion.isLastDocumentVersion()) {
                                statementEntry.setDocumentStatus(DocumentTranslator.getStatusName(I18nFactory.getI18n(locale), docVersion.getStatus()));
                            }
                            statementEntry.setObjectPlannerText(releasedPlanner.getCode() + " " + releasedPlanner.getArea() + (isObjectPlannerDeleted ? " (gel\u00f6scht!)" : ""));
                            statementEntry.setReviewCycleInstanceText(releasedPlanner.getReviewCycleInstance().getName());
                            statementEntry.setDeletedObjectPlanner(isObjectPlannerDeleted);
                            statementEntry.setUploadDate(docVersion.getUploaded());
                            statementEntry.setSignatureDate(entryResult.getResultDate());
                            statementEntry.setPlanDeliverCatalogueStartDate(planDeliverCatalogueStartDate);
                            statementEntry.setPlanDeliverCatalogueEndDate(planDeliverCatalogueEndDate);
                            statementEntry.setEffectiveEndDate(versionEntry.getEffectiveEndDate());
                            statementEntry.setEffectiveStartDate(versionEntry.getEffectiveStartDate());
                            statementEntry.setPlannedEndDate(versionEntry.getPlannedEndDate());
                            statementEntry.setPlannedStartDate(versionEntry.getPlannedStartDate());
                            statementEntry.setReleaseDate(releaseDate);
                            positionEntries.add(statementEntry);
                        }
                    }
                }
                ReviewCycleCellInstance cellInstance = docVersion.getActualReviewCycleNodeInstance().getReviewCycleCellInstance();
                ReviewCycleCellInstanceRelease cellInstanceRel = this.reviewCycleCellInstanceDAO.getReleasedCell(olistRelease, cellInstance.getReviewCycleInstance(), cellInstance.getReviewCycleCell());
                List nodeInstancesRel = cellInstanceRel.getReviewCycleNodeInstancesSortedByPosition();
                for (ReviewCycleNodeInstanceRelease nodeInstRel : nodeInstancesRel) {
                    ReviewCycleNodeResult reviewCycleNodeResult = this.getReviewCycleNodeResult(nodeInstRel.getReviewCycleNode(), docVersion);
                    Date effectiveStartDate = null;
                    if (reviewCycleNodeResult == null) continue;
                    Pair<Calendar, Calendar> targetDates = this.reviewCycleInterpretationHelper.getTargetDatesForNodeResult(reviewCycleNodeResult, nodeInstRel, project);
                    effectiveStartDate = reviewCycleNodeResult.getDocumentArrivalDate();
                    if (docVersion.isLastDocumentVersion() && (nodeInstRel.getReviewCyclePositions() == null || nodeInstRel.getReviewCyclePositions().isEmpty()) && (reviewCycleNodeResult.getReviewCycleResultOption() != null && reviewCycleNodeResult.getReviewCycleResultOption().getValue() != -8 || reviewCycleNodeResult.getReviewCycleResultOption() == null && reviewCycleNodeResult.getReviewCycleNode().getId().equals(docVersion.getActualReviewCycleNode().getId()) && docVersion.isInAction() && !docVersion.isDeleted() || reviewCycleNodeResult.getReviewCycleNode().isFree())) {
                        ReviewCyclePositionEntry emptyPosEntry = new ReviewCyclePositionEntry();
                        emptyPosEntry.setType("Upload");
                        emptyPosEntry.setStatus(status);
                        emptyPosEntry.setCellName(cellInstance.getReviewCycleCell().getName());
                        emptyPosEntry.setDocumentContent(releasedDocument != null ? releasedDocument.getContent() : document.getContent());
                        emptyPosEntry.setDocumentNumber(docVersion.getName());
                        emptyPosEntry.setUnversionedDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
                        emptyPosEntry.setObjectText(releasedPlanner.getObject().getCode() + " " + releasedPlanner.getObject().getName());
                        if (docVersion.isLastDocumentVersion()) {
                            emptyPosEntry.setDocumentStatus(DocumentTranslator.getStatusName(I18nFactory.getI18n(locale), docVersion.getStatus()));
                        }
                        emptyPosEntry.setNodeName(TapestryI18nHelper.getLocalizedString(nodeInstRel.getReviewCycleNode().getName()));
                        emptyPosEntry.setObjectPlannerText(releasedPlanner.getCode() + " " + releasedPlanner.getArea() + (isObjectPlannerDeleted ? " (gel\u00f6scht!)" : ""));
                        emptyPosEntry.setReviewCycleInstanceText(releasedPlanner.getReviewCycleInstance().getName());
                        emptyPosEntry.setDeletedObjectPlanner(isObjectPlannerDeleted);
                        emptyPosEntry.setPlannerName(planerNameString);
                        emptyPosEntry.setUploadDate(docVersion.getUploaded());
                        emptyPosEntry.setEffectiveEndDate(nodeRes.getDocumentDepartureDate());
                        emptyPosEntry.setEffectiveStartDate(effectiveStartDate);
                        emptyPosEntry.setPlannedStartDate(targetDates.getFirst() != null ? ((Calendar)targetDates.getFirst()).getTime() : null);
                        emptyPosEntry.setPlannedEndDate(targetDates.getSecond() != null ? ((Calendar)targetDates.getSecond()).getTime() : null);
                        HolidayCalculator holidayCalculator = this.holidayCalculatorFactory.getInstance(activeSubProject.getProject());
                        Calendar start = Calendar.getInstance();
                        start.setTime(emptyPosEntry.getEffectiveStartDate());
                        Calendar end = Calendar.getInstance();
                        int effectiveDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                        emptyPosEntry.setEffectiveDuration(effectiveDuration);
                        start = Calendar.getInstance();
                        start.setTime(emptyPosEntry.getPlannedStartDate());
                        end = Calendar.getInstance();
                        end.setTime(emptyPosEntry.getPlannedEndDate());
                        int plannedDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                        emptyPosEntry.setPlannedDuration(plannedDuration);
                        emptyPosEntry.setPlanDeliverCatalogueStartDate(planDeliverCatalogueStartDate);
                        emptyPosEntry.setPlanDeliverCatalogueEndDate(planDeliverCatalogueEndDate);
                        positionEntries.add(emptyPosEntry);
                        continue;
                    }
                    ArrayList positionResults = null;
                    if (reviewCycleNodeResult.getReviewCycleNodePositionResults() != null) {
                        positionResults = new ArrayList(reviewCycleNodeResult.getReviewCycleNodePositionResults().values());
                        Collections.sort(positionResults, new ReviewCyclePositionResultDateComparator());
                        for (ReviewCyclePositionResult result : positionResults) {
                            if (result.getReviewCycleResultOption() == null || result.getSignature() == null) continue;
                            ReviewCyclePositionEntry positionResultEntry = new ReviewCyclePositionEntry();
                            positionResultEntry.setType("Pr\u00fcfung");
                            positionResultEntry.setStatus(status);
                            positionResultEntry.setCellName(cellInstance.getReviewCycleCell().getName());
                            positionResultEntry.setDocumentContent(releasedDocument != null ? releasedDocument.getContent() : document.getContent());
                            positionResultEntry.setDocumentNumber(docVersion.getName());
                            positionResultEntry.setUnversionedDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
                            positionResultEntry.setObjectText(releasedPlanner.getObject().getCode() + " " + releasedPlanner.getObject().getName());
                            if (docVersion.isLastDocumentVersion()) {
                                positionResultEntry.setDocumentStatus(DocumentTranslator.getStatusName(I18nFactory.getI18n(locale), docVersion.getStatus()));
                            }
                            positionResultEntry.setNodeName(TapestryI18nHelper.getLocalizedString(result.getReviewCycleNode().getName()));
                            positionResultEntry.setObjectPlannerText(releasedPlanner.getCode() + " " + releasedPlanner.getArea() + (isObjectPlannerDeleted ? " (gel\u00f6scht!)" : ""));
                            positionResultEntry.setReviewCycleInstanceText(releasedPlanner.getReviewCycleInstance().getName());
                            positionResultEntry.setDeletedObjectPlanner(isObjectPlannerDeleted);
                            positionResultEntry.setPlannerName(planerNameString);
                            positionResultEntry.setReviewerName(result.getProjectParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + result.getProjectParticipant().getParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + ")" + (result.getProjectParticipant().isMainParticipant() ? "" : " i.V. " + result.getProjectParticipant().getOrganisationPerson().getPerson().getCommonName()) + (this.taskOperations.isAttachedReviewPositionResult(result.getId()) ? " [optionale Pr\u00fcfung]" : ""));
                            positionResultEntry.setRealmName(result.getRealm() != null ? result.getRealm().getName() : null);
                            positionResultEntry.setSignatureDate(result.getResultDate());
                            positionResultEntry.setReviewPositionResultComment(result.getComment());
                            positionResultEntry.setReviewPositionResultText(result.getReviewCycleResultOption().getName());
                            positionResultEntry.setUploadDate(docVersion.getUploaded());
                            positionResultEntry.setEffectiveEndDate(result.getResultDate());
                            positionResultEntry.setEffectiveStartDate(effectiveStartDate);
                            HolidayCalculator holidayCalculator = this.holidayCalculatorFactory.getInstance(activeSubProject.getProject());
                            Calendar start = Calendar.getInstance();
                            start.setTime(effectiveStartDate);
                            Calendar end = Calendar.getInstance();
                            end.setTime(result.getResultDate());
                            int effectiveDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                            positionResultEntry.setEffectiveDuration(effectiveDuration);
                            positionResultEntry.setPlannedStartDate(targetDates.getFirst() != null ? ((Calendar)targetDates.getFirst()).getTime() : null);
                            positionResultEntry.setPlannedEndDate(targetDates.getSecond() != null ? ((Calendar)targetDates.getSecond()).getTime() : null);
                            start = Calendar.getInstance();
                            start.setTime(positionResultEntry.getPlannedStartDate());
                            end = Calendar.getInstance();
                            end.setTime(positionResultEntry.getPlannedEndDate());
                            int plannedDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                            positionResultEntry.setPlannedDuration(plannedDuration);
                            positionResultEntry.setPlanDeliverCatalogueStartDate(planDeliverCatalogueStartDate);
                            positionResultEntry.setPlanDeliverCatalogueEndDate(planDeliverCatalogueEndDate);
                            positionResultEntry.setReleaseDate(releaseDate);
                            positionEntries.add(positionResultEntry);
                        }
                    }
                    if (!docVersion.getActualReviewCycleNode().getId().equals(nodeInstRel.getReviewCycleNode().getId()) || this.isNodeFinished(nodeInstRel, reviewCycleNodeResult, docVersion) || docVersion.isReleased() || docVersion.getStatus() == 3 || docVersion.isInvalidatedOrDeleted() || !docVersion.getId().equals(document.getLastDocumentVersion().getId())) continue;
                    ArrayList releasedPositions = new ArrayList(nodeInstRel.getReviewCyclePositions().values());
                    releasedPositions.addAll(this.reviewCyclePositionDAO.getAllAttachedByNodeInstance(nodeInstRel.getReviewCycleNodeInstance().getId(), docVersion.getId()));
                    if (positionResults != null) {
                        block5: for (ReviewCyclePositionResult posRes : positionResults) {
                            if (posRes.getSignature() == null) continue;
                            for (ReviewCyclePositionRelease position : releasedPositions) {
                                if (!posRes.getRealm().getId().equals(position.getRealm().getId()) || !posRes.getProjectParticipant().getParticipation().getId().equals(position.getProjectParticipation().getId())) continue;
                                releasedPositions.remove(position);
                                continue block5;
                            }
                        }
                    }
                    for (ReviewCyclePositionRelease position : releasedPositions) {
                        ReviewCyclePositionEntry positionEntry = new ReviewCyclePositionEntry();
                        positionEntry.setType("offene Pr\u00fcfung");
                        positionEntry.setStatus(status);
                        positionEntry.setUploadDate(docVersion.getUploaded());
                        positionEntry.setObjectPlannerText(releasedPlanner.getCode() + " " + releasedPlanner.getArea() + (isObjectPlannerDeleted ? " (gel\u00f6scht!)" : ""));
                        positionEntry.setReviewCycleInstanceText(releasedPlanner.getReviewCycleInstance().getName());
                        positionEntry.setDeletedObjectPlanner(isObjectPlannerDeleted);
                        positionEntry.setDocumentStatus(DocumentTranslator.getStatusName(I18nFactory.getI18n(locale), docVersion.getStatus()));
                        positionEntry.setCellName(cellInstance.getReviewCycleCell().getName());
                        positionEntry.setNodeName(TapestryI18nHelper.getLocalizedString(nodeInstRel.getReviewCycleNode().getName()));
                        positionEntry.setDocumentNumber(docVersion.getName());
                        positionEntry.setUnversionedDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
                        positionEntry.setObjectText(releasedPlanner.getObject().getCode() + " " + releasedPlanner.getObject().getName());
                        positionEntry.setReleaseDate(releaseDate);
                        positionEntry.setDocumentContent(releasedDocument != null ? releasedDocument.getContent() : document.getContent());
                        positionEntry.setEffectiveStartDate(effectiveStartDate);
                        HolidayCalculator holidayCalculator = this.holidayCalculatorFactory.getInstance(activeSubProject.getProject());
                        Calendar start = Calendar.getInstance();
                        start.setTime(effectiveStartDate);
                        Calendar end = Calendar.getInstance();
                        int effectiveDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                        positionEntry.setEffectiveDuration(effectiveDuration);
                        positionEntry.setPlannedStartDate(targetDates.getFirst() != null ? ((Calendar)targetDates.getFirst()).getTime() : null);
                        positionEntry.setPlannedEndDate(targetDates.getSecond() != null ? ((Calendar)targetDates.getSecond()).getTime() : null);
                        start = Calendar.getInstance();
                        start.setTime(positionEntry.getPlannedStartDate());
                        end = Calendar.getInstance();
                        end.setTime(positionEntry.getPlannedEndDate());
                        int plannedDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                        positionEntry.setPlannedDuration(plannedDuration);
                        positionEntry.setPlanDeliverCatalogueStartDate(planDeliverCatalogueStartDate);
                        positionEntry.setPlanDeliverCatalogueEndDate(planDeliverCatalogueEndDate);
                        positionEntry.setUnreleasedWithRevision(docVersion.getRevisedDocumentVersion() != null && docVersion.getStatus() == 1);
                        positionEntry.setReviewerName(position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + position.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + ")" + (position instanceof AttachedReviewCyclePositionImpl ? " [optionale Pr\u00fcfung]" : ""));
                        positionEntry.setRealmName(position.getRealm().getName());
                        positionEntry.setPlannerName(planerNameString);
                        positionEntries.add(positionEntry);
                    }
                }
            }
        } else {
            Pair<Calendar, Calendar> targetDates = this.reviewCycleInterpretationHelper.getTargetDatesDocumentUpload(releasedDocument != null ? releasedDocument : document, project);
            ReviewCyclePositionEntry documentEntry = new ReviewCyclePositionEntry();
            if (isObjectPlannerDeleted) {
                documentEntry.setStatus(3);
            } else {
                documentEntry.setStatus(0);
            }
            documentEntry.setType("Nicht upgeloadet");
            documentEntry.setDocumentStatus(DocumentTranslator.getDocumentStatus(I18nFactory.getI18n(locale), document));
            documentEntry.setDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
            documentEntry.setUnversionedDocumentNumber(releasedDocument != null ? releasedDocument.getName() : document.getName());
            documentEntry.setObjectText(releasedPlanner.getObject().getCode() + " " + releasedPlanner.getObject().getName());
            documentEntry.setDocumentContent(releasedDocument != null ? releasedDocument.getContent() : document.getContent());
            documentEntry.setPlanDeliverCatalogueStartDate(planDeliverCatalogueStartDate);
            documentEntry.setPlanDeliverCatalogueEndDate(planDeliverCatalogueEndDate);
            documentEntry.setObjectPlannerText(releasedPlanner.getCode() + " " + releasedPlanner.getArea() + (isObjectPlannerDeleted ? " (gel\u00f6scht!)" : ""));
            documentEntry.setReviewCycleInstanceText(releasedPlanner.getReviewCycleInstance().getName());
            documentEntry.setDeletedObjectPlanner(isObjectPlannerDeleted);
            documentEntry.setPlannerName(planerNameString);
            documentEntry.setPlannedStartDate(targetDates.getFirst() != null ? ((Calendar)targetDates.getFirst()).getTime() : null);
            if (documentEntry.getPlannedStartDate() != null) {
                HolidayCalculator holidayCalculator = this.holidayCalculatorFactory.getInstance(activeSubProject.getProject());
                Calendar start = Calendar.getInstance();
                start.setTime(documentEntry.getPlannedStartDate());
                Calendar end = Calendar.getInstance();
                int effectiveDuration = holidayCalculator.getWorkingDaysBetween(start, end);
                documentEntry.setEffectiveDuration(effectiveDuration);
            }
            documentEntry.setPlannerName(releasedPlanner.getPlanner().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " (" + releasedPlanner.getPlanner().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + ")");
            positionEntries.add(documentEntry);
        }
        return positionEntries;
    }

    public void setReviewCycleInterpretationHelper(ReviewCycleInterpretationHelper reviewCycleInterpretationHelper) {
        this.reviewCycleInterpretationHelper = reviewCycleInterpretationHelper;
    }

    @Override
    public void insertRepairConnectionAndEntryResults(boolean checkOnly, Integer networkId) {
        List allEntryResults;
        ProjectParticipation pp;
        ProjectParticipant correctParticipant;
        String orgNames;
        Project project;
        Integer opRelParticipantId;
        ReleasedObjectPlanner opRel;
        List allCellConnectionResults;
        log.info((Object)"######################################################################################################");
        log.info((Object)"####################   InsertRepairConnectionAndEntryResults() START");
        log.info((Object)"######################################################################################################");
        if (networkId == null) {
            log.info((Object)"fetching all CellConnectionResults, network id is null");
            allCellConnectionResults = this.reviewCycleCellConnectionResultDAO.getAll();
        } else {
            log.info((Object)("fetching all CellConnectionResults of network with id=[" + networkId + "]"));
            allCellConnectionResults = this.reviewCycleCellConnectionResultDAO.getAllByNetwork(networkId);
        }
        log.info((Object)"---------------------------------------------------------------------------------------------");
        log.info((Object)(">> Starting to loop through CellConnectionResults, size=[" + allCellConnectionResults.size() + "]"));
        int inconsistentCellConnectionCount = 0;
        int inconsistentEntryResultsCount = 0;
        int repairedCellConnectionResults = 0;
        int repairedEntryResults = 0;
        int errorCount = 0;
        int checkedCellConnectionResultsCount = 1;
        int checkedEntryResultsCount = 1;
        for (ReviewCycleCellConnectionResultImpl connRes : allCellConnectionResults) {
            log.info((Object)("+++++++++++++          working on CellConnectionResult " + checkedCellConnectionResultsCount + " from " + allCellConnectionResults.size()));
            ++checkedCellConnectionResultsCount;
            if (connRes.getSignature() == null) continue;
            try {
                ReviewCycleNodeResult firstNodeRes = connRes.getDestinationReviewCycleCellResult().getReviewCycleNodeResultsSortedByPosition(true).iterator().next();
                opRel = this.objectPlannerDAO.getReleasedObjectPlanner(firstNodeRes.getActiveObjectListOfDocumentArrival().getId(), connRes.getSourceDocumentVersion().getDocument().getObjectPlanner().getId());
                if (opRel == null) {
                    log.info((Object)(">>>> ERROR: Could not find released objectPlanner for CellConnectionResult with id=[" + connRes.getId() + "] -> first NodeResult of documentVersion has id=[" + firstNodeRes.getId() + "]"));
                    ++errorCount;
                    continue;
                }
                Integer connResParticipantId = connRes.getProjectParticipant().getParticipation().getId();
                opRelParticipantId = opRel.getPlanner().getId();
                project = opRel.getPlanner().getProject();
                if (connResParticipantId.equals(opRelParticipantId)) continue;
                orgNames = "'" + connRes.getProjectParticipant().getOrganisationPerson().getOrganisation().getName() + "' != '" + opRel.getPlanner().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + "'";
                log.info((Object)"*****************************************************");
                log.info((Object)("*** Found Inconsistent CellConnectionResult:\norganisations:[" + orgNames + "] \ncellConnResId=[" + connRes.getId() + "] \ndestinationDocVersionNumber=[" + connRes.getDestinationDocumentVersion().getName() + "] docVersionId=[" + connRes.getDestinationDocumentVersion() + "]\n CellConnectionResult participantName=[" + connRes.getProjectParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + "] participantId=[" + connRes.getProjectParticipant().getId() + "] participationId=[" + connResParticipantId + "]\nrelObjPlPlannerParticipationId=[" + opRelParticipantId + "]\nprojectName=[" + project.getName() + "] projectId=[" + project.getId() + "]\nfirst nodeResult of documentVersion has id=[" + firstNodeRes.getId() + "]; releasedObjectPlanner at time of signature has id=[" + opRel.getId() + "]\ndocumentVersion was signed at time=[" + connRes.getSignature().getTime() + "]"));
                ++inconsistentCellConnectionCount;
                if (checkOnly) continue;
                correctParticipant = null;
                pp = opRel.getPlanner();
                for (ProjectParticipant p : pp.getProjectParticipants().values()) {
                    if (!p.getOrganisationPerson().getId().equals(connRes.getProjectParticipant().getOrganisationPerson().getId())) continue;
                    correctParticipant = p;
                    break;
                }
                if (correctParticipant == null) {
                    for (ProjectParticipant p : pp.getInvalidProjectParticipants().values()) {
                        if (!p.getOrganisationPerson().getId().equals(connRes.getProjectParticipant().getOrganisationPerson().getId())) continue;
                        for (ProjectParticipantDateHistoryPart hist : p.getDateHistory().values()) {
                            if (hist.getStartDate() != null && !hist.getStartDate().before(connRes.getSignature().getTime()) || hist.getEndDate() != null && !hist.getEndDate().after(connRes.getSignature().getTime())) continue;
                            correctParticipant = p;
                            break;
                        }
                        if (correctParticipant == null) continue;
                        break;
                    }
                }
                if (correctParticipant == null) {
                    log.info((Object)">>>> ERROR: could not find correct Participant for this participation!");
                    ++errorCount;
                    continue;
                }
                connRes.setProjectParticipant(correctParticipant);
                this.reviewCycleCellConnectionResultDAO.update(connRes);
                log.info((Object)("### Successfully repaired cellConnectionResult! new ProjectParticipant has id=[" + correctParticipant.getId() + "] and name=[" + correctParticipant.getOrganisationPerson().getPerson().getInverseCommonName() + "]"));
                ++repairedCellConnectionResults;
            }
            catch (Exception e) {
                log.info((Object)(">>>> ERROR: caught Exception for CellConnectionResult with id=[" + connRes.getId() + "] --> \n" + e.getMessage()));
                ++errorCount;
            }
        }
        if (networkId == null) {
            log.info((Object)"fetching all ReviewCycleEntryResults, network id is null");
            allEntryResults = this.reviewCycleEntryResultDAO.getAll();
        } else {
            log.info((Object)("fetching all ReviewCycleEntryResults of network with id=[" + networkId + "]"));
            allEntryResults = this.reviewCycleEntryResultDAO.getAllByNetwork(networkId);
        }
        log.info((Object)"---------------------------------------------------------------------------------------------");
        log.info((Object)(">> Starting to loop through ReviewCycleEntryResults, size=[" + allEntryResults.size() + "]"));
        for (ReviewCycleEntryResultImpl entryRes : allEntryResults) {
            log.info((Object)("+++++++++++++          working on EntryResult " + checkedEntryResultsCount + " from " + allEntryResults.size()));
            ++checkedEntryResultsCount;
            if (entryRes.getSignature() == null) continue;
            try {
                opRel = (ReleasedObjectPlanner)entryRes.getDestinationObjectPlanner();
                if (opRel == null) {
                    log.info((Object)(">>>> ERROR: Could not find released objectPlanner for EntryResult with id=[" + entryRes.getId() + "]"));
                    ++errorCount;
                    continue;
                }
                Integer entryResParticipantId = entryRes.getProjectParticipant().getParticipation().getId();
                opRelParticipantId = opRel.getPlanner().getId();
                project = opRel.getPlanner().getProject();
                if (entryResParticipantId.equals(opRelParticipantId)) continue;
                orgNames = "'" + entryRes.getProjectParticipant().getOrganisationPerson().getOrganisation().getName() + "' != '" + opRel.getPlanner().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + "'";
                log.info((Object)"*****************************************************");
                log.info((Object)("Found Inconsisten ReviewCycleEntryResult: organisations:[" + orgNames + "] \nentryResultId=[" + entryRes.getId() + "] \ndestinationDocVersionNumber=[" + entryRes.getDocumentVersion().getName() + "] \nReleasedObjectPlannerId=[" + opRel.getId() + "] \nentryResultParticipationId=[" + entryResParticipantId + "] \nrelObjPlPlannerParticipationId=[" + opRelParticipantId + "] \nprojectName=[" + project.getName() + "] \nprojectId=[" + project.getId() + "]\ndocumentVersion was signed at time=[" + entryRes.getResultDate() + "]"));
                ++inconsistentEntryResultsCount;
                if (checkOnly) continue;
                correctParticipant = null;
                pp = opRel.getPlanner();
                for (ProjectParticipant p : pp.getProjectParticipants().values()) {
                    if (!p.getOrganisationPerson().getId().equals(entryRes.getProjectParticipant().getOrganisationPerson().getId())) continue;
                    correctParticipant = p;
                    break;
                }
                if (correctParticipant == null) {
                    for (ProjectParticipant p : pp.getInvalidProjectParticipants().values()) {
                        if (!p.getOrganisationPerson().getId().equals(entryRes.getProjectParticipant().getOrganisationPerson().getId())) continue;
                        for (ProjectParticipantDateHistoryPart hist : p.getDateHistory().values()) {
                            if (hist.getStartDate() != null && !hist.getStartDate().before(entryRes.getResultDate()) || hist.getEndDate() != null && !hist.getEndDate().after(entryRes.getResultDate())) continue;
                            correctParticipant = p;
                            break;
                        }
                        if (correctParticipant == null) continue;
                        break;
                    }
                }
                if (correctParticipant == null) {
                    log.info((Object)">>>> ERROR: could not find correct Participant for this participation!");
                    ++errorCount;
                    continue;
                }
                entryRes.setProjectParticipant(correctParticipant);
                this.reviewCycleEntryResultDAO.update(entryRes);
                log.info((Object)("### Successfully repaired entryResult! new ProjectParticipant has id=[" + correctParticipant.getId() + "] and name=[" + correctParticipant.getOrganisationPerson().getPerson().getInverseCommonName() + "]"));
                ++repairedEntryResults;
            }
            catch (Exception e) {
                log.info((Object)(">>>> ERROR: caught Exception for ReviewCycleEntryResult with id=[" + entryRes.getId() + "] --> \n" + e.getMessage()));
                ++errorCount;
            }
        }
        log.info((Object)"######################################################################################################");
        log.info((Object)("finished function InsertRepairConnectionAndEntryResults() with " + errorCount + " errors"));
        log.info((Object)("found [" + inconsistentCellConnectionCount + "] inconsistent ReviewCycleCellConnectionResults"));
        log.info((Object)("found [" + inconsistentEntryResultsCount + "] inconsistent ReviewCycleEntryResults"));
        log.info((Object)("repaired [" + repairedCellConnectionResults + "] inconsistent ReviewCycleCellConnectionResults"));
        log.info((Object)("repaired [" + repairedEntryResults + "] inconsistent ReviewCycleEntryResults"));
        log.info((Object)"######################################################################################################");
    }

    @Override
    public void deleteTemporaryDocumentVersion(TemporaryDocumentVersion tdv) {
        if (tdv.getFileName() == null) {
            return;
        }
        log.info((Object)("Deleting uploaded file of TemporaryDocumentVersion, documentVersionName=[" + tdv.getName() + "] filename=[" + tdv.getFileName() + "]"));
        this.uploadFileHandler.deleteUploadFile(tdv.getFileName());
    }

    @Override
    public boolean hasProjectParticipationAttachedReviewTasks(Integer projectParticipationId) {
        return this.taskOperations.getAllAttachedReviewTasksByParticipation(projectParticipationId).isEmpty();
    }

    @Override
    public List getAttachedReviewTasksByProjectParticipation(Integer projectParticipationId) {
        return this.taskOperations.getAllAttachedReviewTasksByParticipation(projectParticipationId);
    }

    @Override
    public DocumentVersion getDocumentVersionByName(String documentVersionName, Integer projectId) {
        return this.documentVersionDAO.getDocumentVersionByName(documentVersionName, projectId);
    }

    @Override
    public List testCompactReviewStatus(Integer activeObjectListId, Integer activeDocumentListId, ReviewCycleStatusSearch search, I18n i18n) {
        return this.documentDAO.getCompactReviewStatus(activeObjectListId, activeDocumentListId, search, i18n, this.hibernateDialect, null);
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setHolidayCalculatorFactory(HolidayCalculatorFactory holidayCalculatorFactory) {
        this.holidayCalculatorFactory = holidayCalculatorFactory;
    }

    @Override
    public SubProjectCopyContainer insertCopyOfDocumentVersionReviewCycleForSubProject(Integer sourceSubProjectId, Integer destinationSubProjectId, SubProjectCopyContainer subProjectCopyContainer) {
        DocumentVersion destVersion;
        DocumentVersion sourceVersion;
        for (Integer sourceDocumentVersionId : subProjectCopyContainer.getDocumentVersionIds().keySet()) {
            sourceVersion = this.documentVersionDAO.get(sourceDocumentVersionId);
            destVersion = this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceDocumentVersionId));
            ReviewCycleCellResultImpl sourceCellResult = (ReviewCycleCellResultImpl)this.getReviewCycleCellResult(sourceVersion.getActualReviewCycleNode().getReviewCycleCell().getId(), sourceVersion.getId());
            ReviewCycleCellResultImpl destCellResult = new ReviewCycleCellResultImpl();
            destCellResult.setDocumentArrivalDate(sourceCellResult.getDocumentArrivalDate());
            destCellResult.setDocumentDepartureDate(sourceCellResult.getDocumentDepartureDate());
            destCellResult.setDocumentVersion(destVersion);
            destCellResult.setFinished(sourceCellResult.isFinished());
            destCellResult.setNextReviewCycleCell(sourceCellResult.getNextReviewCycleCell());
            destCellResult.setPreviousReviewCycleCell(sourceCellResult.getPreviousReviewCycleCell());
            destCellResult.setReviewCycleCell(sourceCellResult.getReviewCycleCell());
            destCellResult.setReviewCycleResultOption(sourceCellResult.getReviewCycleResultOption());
            destCellResult = (ReviewCycleCellResultImpl)this.reviewCycleCellResultDAO.save(destCellResult);
            subProjectCopyContainer.getCellResultIds().put(sourceCellResult.getId(), destCellResult.getId());
            ArrayList sourceNodeResults = new ArrayList(sourceCellResult.getReviewCycleNodeResults().values());
            for (Object sourceNodeResult : sourceNodeResults) {
                ReviewCycleNodeResultImpl destNodeResult = new ReviewCycleNodeResultImpl();
                if (((ReviewCycleNodeResultImpl)sourceNodeResult).getActiveObjectListOfDocumentArrival() != null) {
                    destNodeResult.setActiveObjectListOfDocumentArrival(this.objectOperations.getReleasedObjectList(subProjectCopyContainer.getObjectListReleaseIds().get(((ReviewCycleNodeResultImpl)sourceNodeResult).getActiveObjectListOfDocumentArrival().getId())));
                }
                if (((ReviewCycleNodeResultImpl)sourceNodeResult).getActiveObjectListOfDocumentDeparture() != null) {
                    destNodeResult.setActiveObjectListOfDocumentDeparture(this.objectOperations.getReleasedObjectList(subProjectCopyContainer.getObjectListReleaseIds().get(((ReviewCycleNodeResultImpl)sourceNodeResult).getActiveObjectListOfDocumentDeparture().getId())));
                }
                destNodeResult.setDocumentArrivalDate(((ReviewCycleNodeResultImpl)sourceNodeResult).getDocumentArrivalDate());
                destNodeResult.setDocumentDepartureDate(((ReviewCycleNodeResultImpl)sourceNodeResult).getDocumentDepartureDate());
                destNodeResult.setDocumentVersion(destVersion);
                destNodeResult.setFinished(((ReviewCycleNodeResultImpl)sourceNodeResult).isFinished());
                destNodeResult.setReviewCycleCellResult(destCellResult);
                destNodeResult.setReviewCycleNode(((ReviewCycleNodeResultImpl)sourceNodeResult).getReviewCycleNode());
                destNodeResult.setReviewCycleResultOption(((ReviewCycleNodeResultImpl)sourceNodeResult).getReviewCycleResultOption());
                destNodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.save(destNodeResult);
                subProjectCopyContainer.getNodeResultIds().put(((ReviewCycleNodeResultImpl)sourceNodeResult).getId(), destNodeResult.getId());
            }
        }
        for (Integer sourceDocumentVersionId : subProjectCopyContainer.getDocumentVersionIds().keySet()) {
            HashMap<Integer, ReviewCycleStatementResult> destStatements;
            sourceVersion = this.documentVersionDAO.get(sourceDocumentVersionId);
            destVersion = this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceDocumentVersionId));
            ReviewCycleCellConnectionResultImpl sourceCellConnectionResult = (ReviewCycleCellConnectionResultImpl)this.getReviewCycleCellConnectionResultByDocumentVersion(sourceVersion.getId());
            if (sourceCellConnectionResult != null) {
                ReviewCycleCellConnectionResultImpl destCellConnectionResult = new ReviewCycleCellConnectionResultImpl();
                destCellConnectionResult.setComment(sourceCellConnectionResult.getComment());
                destCellConnectionResult.setDestinationDocumentVersion(this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceCellConnectionResult.getDestinationDocumentVersion().getId())));
                destCellConnectionResult.setSourceDocumentVersion(this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceCellConnectionResult.getSourceDocumentVersion().getId())));
                destCellConnectionResult.setDestinationReviewCycleCellResult(this.reviewCycleCellResultDAO.get(subProjectCopyContainer.getCellResultIds().get(sourceCellConnectionResult.getDestinationReviewCycleCellResult().getId())));
                destCellConnectionResult.setSourceReviewCycleCellResult(this.reviewCycleCellResultDAO.get(subProjectCopyContainer.getCellResultIds().get(sourceCellConnectionResult.getSourceReviewCycleCellResult().getId())));
                destCellConnectionResult.setDigest(sourceCellConnectionResult.getDigest());
                destCellConnectionResult.setDigestCalculatorType(sourceCellConnectionResult.getDigestCalculatorType());
                destCellConnectionResult.setProjectParticipant(sourceCellConnectionResult.getProjectParticipant());
                destCellConnectionResult.setResultDate(sourceCellConnectionResult.getResultDate());
                destCellConnectionResult.setRule(sourceCellConnectionResult.getRule());
                destCellConnectionResult.setSignature(sourceCellConnectionResult.getSignature());
                destCellConnectionResult = (ReviewCycleCellConnectionResultImpl)this.reviewCycleCellConnectionResultDAO.save(destCellConnectionResult);
                if (sourceCellConnectionResult.getStatements() == null || sourceCellConnectionResult.getStatements().isEmpty()) continue;
                ArrayList sourceStatements = new ArrayList(sourceCellConnectionResult.getStatements().values());
                destStatements = new HashMap();
                for (ReviewCycleCellConnectionStatementResultImpl sourceStatement : sourceStatements) {
                    ReviewCycleCellConnectionStatementResultImpl destStatement = new ReviewCycleCellConnectionStatementResultImpl();
                    destStatement.setComment(sourceStatement.getComment());
                    destStatement.setRealm(sourceStatement.getRealm());
                    destStatement.setReviewCycleCellConnectionResult(destCellConnectionResult);
                    destStatement.setReviewCycleResultOption(sourceStatement.getReviewCycleResultOption());
                    destStatement = (ReviewCycleCellConnectionStatementResultImpl)this.reviewCycleCellConnectionResultDAO.save(destStatement);
                    destStatements.put(destStatement.getId(), destStatement);
                }
                destCellConnectionResult.setStatements(destStatements);
                this.reviewCycleCellConnectionResultDAO.update(destCellConnectionResult);
                continue;
            }
            ReviewCycleEntryResult sourceEntryResult = this.getReviewCycleEntryResultByDocumentVersion(sourceVersion.getId());
            ReviewCycleEntryResultImpl destEntryResult = new ReviewCycleEntryResultImpl();
            destEntryResult.setComment(sourceEntryResult.getComment());
            if (sourceEntryResult.getDestinationObjectPlanner() != null) {
                destEntryResult.setDestinationObjectPlanner(this.objectPlannerDAO.getReleasedObjectPlanner(subProjectCopyContainer.getObjectPlannerReleaseIds().get(sourceEntryResult.getDestinationObjectPlanner().getId())));
            }
            if (sourceEntryResult.getSourceObjectPlanner() != null) {
                destEntryResult.setSourceObjectPlanner(this.objectPlannerDAO.getReleasedObjectPlanner(subProjectCopyContainer.getObjectPlannerReleaseIds().get(sourceEntryResult.getSourceObjectPlanner().getId())));
            }
            destEntryResult.setDigest(sourceEntryResult.getDigest());
            destEntryResult.setDigestCalculatorType(sourceEntryResult.getDigestCalculatorType());
            destEntryResult.setDocumentVersion(destVersion);
            destEntryResult.setProjectParticipant(sourceEntryResult.getProjectParticipant());
            destEntryResult.setResultDate(sourceEntryResult.getResultDate());
            destEntryResult.setSignature(sourceEntryResult.getSignature());
            destEntryResult = (ReviewCycleEntryResultImpl)this.reviewCycleEntryResultDAO.save(destEntryResult);
            if (sourceEntryResult.getStatements() == null || sourceEntryResult.getStatements().isEmpty()) continue;
            destStatements = new HashMap<Integer, ReviewCycleStatementResult>();
            ArrayList sourceStatements = new ArrayList(sourceEntryResult.getStatements().values());
            for (ReviewCycleEntryStatementResultImpl sourceStatement : sourceStatements) {
                ReviewCycleEntryStatementResultImpl destStatement = new ReviewCycleEntryStatementResultImpl();
                destStatement.setComment(sourceStatement.getComment());
                destStatement.setRealm(sourceStatement.getRealm());
                destStatement.setReviewCycleEntryResult(destEntryResult);
                destStatement.setReviewCycleResultOption(sourceStatement.getReviewCycleResultOption());
                destStatement = (ReviewCycleEntryStatementResultImpl)this.reviewCycleEntryResultDAO.save(destStatement);
                destStatements.put(destStatement.getId(), destStatement);
            }
            destEntryResult.setStatements(destStatements);
            this.reviewCycleEntryResultDAO.update(destEntryResult);
        }
        List sourceResults = this.reviewCyclePositionResultDAO.getAllPositionResultsOfSubProject(sourceSubProjectId);
        POJOComparatorFactory pf = new POJOComparatorFactory();
        try {
            Collections.sort(sourceResults, pf.getComparator(ReviewCyclePositionResultImpl.class, "resultDate", true));
        }
        catch (InvalidExpressionSyntaxException e) {
            throw new DefaultException("Could not sort reviewCyclePositionResults", e);
        }
        for (ReviewCyclePositionResultImpl sourceResult : sourceResults) {
            ReviewCyclePositionResultImpl destResult = new ReviewCyclePositionResultImpl();
            if (sourceResult.getActiveDocumentList() != null) {
                destResult.setActiveDocumentList(this.documentListDAO.get(subProjectCopyContainer.getDocumentListReleaseIds().get(sourceResult.getActiveDocumentList().getId())));
            }
            if (sourceResult.getActiveObjectList() != null) {
                destResult.setActiveObjectList(this.objectOperations.getReleasedObjectList(subProjectCopyContainer.getObjectListReleaseIds().get(sourceResult.getActiveObjectList().getId())));
            }
            destResult.setAuthorized(sourceResult.isAuthorized());
            destResult.setComment(sourceResult.getComment());
            destResult.setDigest(sourceResult.getDigest());
            destResult.setDocumentVersion(this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(sourceResult.getDocumentVersion().getId())));
            destResult.setOverridingProjectParticipant(sourceResult.getOverridingProjectParticipant());
            destResult.setProjectParticipant(sourceResult.getProjectParticipant());
            destResult.setRealm(sourceResult.getRealm());
            destResult.setResultDate(sourceResult.getResultDate());
            destResult.setReviewCycleCommentOption(sourceResult.getReviewCycleCommentOption());
            destResult.setReviewCycleNode(sourceResult.getReviewCycleNode());
            if (sourceResult.getReviewCycleNodeResult() != null) {
                destResult.setReviewCycleNodeResult(this.reviewCycleNodeResultDAO.get(subProjectCopyContainer.getNodeResultIds().get(sourceResult.getReviewCycleNodeResult().getId())));
            }
            destResult.setReviewCycleResultOption(sourceResult.getReviewCycleResultOption());
            destResult.setSignature(sourceResult.getSignature());
            if (sourceResult.getCommentReference() != null) {
                Integer destReferenceId = subProjectCopyContainer.getPositionResultIds().get(sourceResult.getCommentReference().getId());
                if (destReferenceId != null) {
                    destResult.setCommentReference(this.reviewCyclePositionResultDAO.get(destReferenceId));
                } else {
                    subProjectCopyContainer.getInconsistentNotCopiedReviewCyclePositionResults().add(sourceResult.getCommentReference().getId());
                }
            }
            destResult = (ReviewCyclePositionResultImpl)this.reviewCyclePositionResultDAO.save(destResult);
            subProjectCopyContainer.getPositionResultIds().put(sourceResult.getId(), destResult.getId());
            if (sourceResult.getAttachments() == null || sourceResult.getAttachments().isEmpty()) continue;
            ArrayList sourceAttachments = new ArrayList(sourceResult.getAttachments().values());
            for (Attachment sourceAttachment : sourceAttachments) {
                Attachment attachment = this.attachmentDAO.get(subProjectCopyContainer.getAttachmentIds().get(sourceAttachment.getId()));
                if (attachment.getResults() == null) {
                    attachment.setResults(new HashMap());
                }
                if (!attachment.getResults().containsKey(destResult.getId())) {
                    attachment.getResults().put(destResult.getId(), destResult);
                }
                this.attachmentDAO.update(attachment);
                if (destResult.getAttachments() == null) {
                    destResult.setAttachments(new HashMap());
                }
                destResult.getAttachments().put(attachment.getId(), attachment);
                this.reviewCyclePositionResultDAO.update(destResult);
            }
        }
        List<OEBBComment> sourceOebbComments = this.reviewCyclePositionResultDAO.getAllOebbCommentsForSubProject(sourceSubProjectId);
        for (OEBBComment sourceComment : sourceOebbComments) {
            OEBBComment destComment = new OEBBComment();
            destComment.setComment(sourceComment.getComment());
            destComment.setRealm(sourceComment.getRealm());
            destComment.setResult(sourceComment.getResult());
            destComment.setReviewer(sourceComment.getReviewer());
            destComment.setReviewCycleNodeResult(this.reviewCycleNodeResultDAO.get(subProjectCopyContainer.getNodeResultIds().get(sourceComment.getReviewCycleNodeResult().getId())));
            if (sourceComment.getCommentingResult() != null) {
                destComment.setCommentingResult(this.reviewCycleNodeResultDAO.get(subProjectCopyContainer.getNodeResultIds().get(sourceComment.getCommentingResult().getId())));
            }
            this.reviewCyclePositionResultDAO.save(destComment);
        }
        return subProjectCopyContainer;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    @Override
    public List<AsBuiltObjectTO> insertCopiesOfAsBuiltDocumentVersions(Integer subProjectId, List<AsBuiltObjectTO> objectTOs, ProjectParticipant signer, String password, CDESCertificate cert, String uploadComment) throws WrongPasswordException {
        I18n i18n = I18nFactory.getI18n(new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale()));
        SubProject sp = this.subProjectDAO.get(subProjectId);
        Calendar now = Calendar.getInstance();
        for (AsBuiltObjectTO objectTO : objectTOs) {
            if (!objectTO.isContainingSelectedDocumentVersions()) continue;
            for (AsBuiltDocumentTO docTO : objectTO.getDocumentVersions()) {
                if (!docTO.isSelected() || !docTO.isPossibleToTakeOver() || docTO.isAlreadyCopied()) continue;
                DocumentImpl sourceDocument = this.getDocument(docTO.getId());
                ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(docTO.getObjectPlannerId());
                DocumentImpl destDocument = this.documentDAO.getForAsBuiltReference(sourceDocument.getId(), rop.getObjectPlanner().getId());
                if (destDocument == null) {
                    destDocument = new DocumentImpl();
                    destDocument.setAsBuiltReference(sourceDocument);
                    destDocument.setContent(sourceDocument.getContent());
                    destDocument.setComment(sourceDocument.getComment());
                    destDocument.setDocumentList(sp.getEditDocumentList());
                    destDocument.setModified(1);
                    destDocument.setNumber(sourceDocument.getNumber());
                    destDocument.setObjectPlanner(rop.getObjectPlanner());
                    destDocument.setScale(sourceDocument.getScale());
                    destDocument.setDocumentType(sourceDocument.getDocumentType());
                    try {
                        destDocument.setName(this.ognlNumberCalculator.getDocumentNumberRetroactively(destDocument, sp.getProject()));
                    }
                    catch (NumberCalculatorException e) {
                        throw new ActionException("create as-built document", e);
                    }
                }
                destDocument.setVersionSet(true);
                destDocument = this.documentDAO.save(destDocument);
                DocumentVersion sourceDocumentVersion = this.getDocumentVersion(docTO.getDocumentVersionId());
                DocumentVersion destDocumentVersion = new DocumentVersion();
                Collection reviewCycleCellInstances = rop.getReviewCycleInstance().getReviewCycleCellInstances().values();
                ReviewCycleCellInstance destinationCell = null;
                for (ReviewCycleCellInstance cellInst : reviewCycleCellInstances) {
                    if (!cellInst.getReviewCycleCell().isAsBuiltUnchangedDestination()) continue;
                    destinationCell = cellInst;
                    break;
                }
                if (destinationCell == null || destinationCell.getReviewCycleNodeInstances() == null || destinationCell.getReviewCycleNodeInstances().isEmpty()) {
                    throw new ActionException(i18n.tr("F\u00fcr das zugeordnete Pr\u00fcfblatt existiert keine Zielzelle, welche f\u00fcr eine Unver\u00e4nderte \u00dcbernahme geeignet ist!"));
                }
                destDocumentVersion.setActualReviewCycleNodeInstance(((ReviewCycleNodeInstanceRelease)destinationCell.getFirstNodeInstance()).getReviewCycleNodeInstance());
                destDocumentVersion.setAlternativeName(sourceDocumentVersion.getAlternativeName());
                destDocumentVersion.setComment(sourceDocumentVersion.getComment());
                destDocumentVersion.setDocument(destDocument);
                destDocumentVersion.setFileDigest(sourceDocumentVersion.getFileDigest());
                destDocumentVersion.setFileDigester(sourceDocumentVersion.getFileDigester());
                destDocumentVersion.setFileName(sourceDocumentVersion.getFileName());
                destDocumentVersion.setFileType(sourceDocumentVersion.getFileType());
                destDocumentVersion.setIssued(now.getTime());
                Integer labelId_default = null;
                Integer labelId_asBuiltUnchanged = null;
                Integer labelId_renderableOutside = null;
                if (rop.getReviewCycleInstance().getLabel() != null) {
                    Collection labelContents = rop.getReviewCycleInstance().getLabel().getLabelContents().values();
                    for (LabelContent lc : labelContents) {
                        if (lc.isDefaultLabelContent()) {
                            labelId_default = lc.getId();
                        }
                        if (lc.isAsBuiltUnchangedDestination()) {
                            labelId_asBuiltUnchanged = lc.getId();
                        }
                        if (!lc.isRenderableOutside()) continue;
                        labelId_renderableOutside = lc.getId();
                    }
                }
                Label labelWithoutReference = null;
                List labelsWithoutReference = this.labelDAO.getLabelsWithoutReference(sp.getProject().getNetwork().getMaintainer().getId());
                if (!labelsWithoutReference.isEmpty()) {
                    labelWithoutReference = (Label)labelsWithoutReference.toArray()[0];
                    Collection labelContentsWithoutReference = labelWithoutReference.getLabelContents().values();
                    for (LabelContent labelContentWithoutReference : labelContentsWithoutReference) {
                        if (!labelContentWithoutReference.isRenderableOutside()) continue;
                        labelId_renderableOutside = labelContentWithoutReference.getId();
                    }
                }
                if (sourceDocumentVersion.getLabelContentId() != null) {
                    destDocumentVersion.setLabelContentId(sourceDocumentVersion.getLabelContentId());
                } else {
                    destDocumentVersion.setLabelContentId(labelId_renderableOutside);
                }
                destDocumentVersion.setLabelCorrelation(sourceDocumentVersion.getLabelCorrelation());
                destDocumentVersion.setLabelOverlap(sourceDocumentVersion.getLabelOverlap());
                destDocumentVersion.setLabelSeparation(sourceDocumentVersion.getLabelSeparation());
                destDocumentVersion.setLabelXOffset(sourceDocumentVersion.getLabelXOffset());
                destDocumentVersion.setLabelYOffset(sourceDocumentVersion.getLabelYOffset());
                destDocumentVersion.setLlx(sourceDocumentVersion.getLlx());
                destDocumentVersion.setLly(sourceDocumentVersion.getLly());
                destDocumentVersion.setUrx(sourceDocumentVersion.getUrx());
                destDocumentVersion.setUry(sourceDocumentVersion.getUry());
                destDocumentVersion.setNativeRotation(sourceDocumentVersion.getNativeRotation());
                destDocumentVersion.setPreviewRotation(sourceDocumentVersion.getPreviewRotation());
                destDocumentVersion.setUploaded(now.getTime());
                destDocumentVersion.setAsBuiltReference(sourceDocumentVersion);
                destDocumentVersion.setName(docTO.getDestinationDocumentVersionName());
                destDocumentVersion.setVersionPartA(docTO.getVersionPartA());
                destDocumentVersion.setVersionPartB(docTO.getVersionPartB());
                destDocumentVersion.setVersionPartSeperator(docTO.getVersionPartSeparator());
                destDocumentVersion = this.documentVersionDAO.save(destDocumentVersion);
                docTO.setStatus(1);
                docTO.setSelected(false);
                ReviewCycleEntryCondition entryCondition = destinationCell.getReviewCycleCell().getReviewCycleEntryCondition();
                destDocumentVersion.setStatus(1);
                Integer reviewCycleStatusChange = entryCondition.getDocumentVersionStatus();
                if (reviewCycleStatusChange != null) {
                    destDocumentVersion.setStatus(reviewCycleStatusChange);
                }
                DocumentVersionStatusChange change = new DocumentVersionStatusChange();
                change.setChangeDate(now);
                change.setDocumentVersionId(destDocumentVersion.getId());
                change.setFileName(destDocumentVersion.getFileName());
                change.setName(destDocumentVersion.getName());
                change.setNewStatus(destDocumentVersion.getStatus());
                this.documentVersionDAO.saveStatusChange(change);
                ReviewCycleEntryResultImpl res = new ReviewCycleEntryResultImpl();
                res.setDestinationObjectPlanner(rop);
                this.generateNextCellResults(destDocumentVersion, (ReleasedObjectList)rop.getObject().getObjectList(), rop.getReviewCycleInstance());
                res.setDocumentVersion(destDocumentVersion);
                res.setProjectParticipant(signer);
                res.setResultDate(now.getTime());
                res.setComment(uploadComment);
                Network network = signer.getParticipation().getProject().getNetwork();
                try {
                    DigestCalculator dig = this.digestCalculatorFactory.getDigestCalculator(network, res);
                    DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
                    res.setDigestCalculatorType(t);
                    res.setDigest(dig.getDigest(res));
                    SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(network, res);
                    CDESSignature sign = sig.createSignature(signer, dig.getSignableContent(res), cert, password);
                    sign = this.signatureDAO.save(sign);
                    try {
                        this.reviewCycleCellResultDAO.get(destinationCell.getReviewCycleCell().getId(), destDocumentVersion.getId());
                    }
                    catch (Exception e) {
                        throw new ActionException(i18n.tr("Die Dokumentversion wurde schon upgeloadet"), e);
                    }
                    res.setSignature(sign);
                    this.documentVersionDAO.update(destDocumentVersion);
                    this.documentDAO.update((DocumentImpl)destDocumentVersion.getDocument());
                    res = (ReviewCycleEntryResultImpl)this.reviewCycleEntryResultDAO.save(res);
                }
                catch (DigestCalculatorException e) {
                    throw new ActionException("Unable to create digest for as-built documentVersion transfer.");
                }
                catch (SignatureCalculatorException e) {
                    throw new ActionException("Unable to create signature for as-built documentVersion transfer.");
                }
            }
        }
        return objectTOs;
    }

    public void setHibernateDialect(String sqlDialect) {
        this.hibernateDialect = sqlDialect;
    }

    @Override
    public boolean evaluateConnectionsForResultOption(Integer reviewTaskId, Integer reviewCycleResultOptionId) {
        DocumentVersionTask task = (DocumentVersionTask)this.taskOperations.getTask(reviewTaskId);
        DocumentVersion dv = task.getDocumentVersion();
        ReviewCycleResultOption option = this.reviewCycleResultOptionDAO.get(reviewCycleResultOptionId);
        ReviewCycleCellInstance cellInstance = dv.getActualReviewCycleNodeInstance().getReviewCycleCellInstance();
        Collection cellConnections = cellInstance.getReviewCycleCell().getLeavingConnections().values();
        if (cellConnections == null || cellConnections.isEmpty()) {
            return false;
        }
        ReleasedObjectPlanner opRel = this.objectOperations.getActiveReleasedObjectPlanner(dv.getDocument().getObjectPlanner().getId());
        for (ReviewCycleCellConnection cellConnection : cellConnections) {
            ReviewCycleCellInstanceRelease cellInstanceRelease = this.reviewCycleCellInstanceDAO.getReleased(opRel.getReviewCycleInstance().getId(), cellConnection.getDestinationCell().getId());
            if (cellInstanceRelease == null) {
                log.info((Object)("No ReviewCycleCellInstanceRelease found for resultOption=[" + reviewCycleResultOptionId + "] and reviewTask=[" + reviewTaskId + "] - skipping cellConnection with id=[" + cellConnection.getId() + "]"));
                continue;
            }
            ReviewCycleCellResultImpl dummyResult = new ReviewCycleCellResultImpl();
            dummyResult.setDocumentVersion(dv);
            dummyResult.setReviewCycleResultOption(option);
            try {
                if (!this.reviewCycleCellConnectionEvaluator.evaluateConnection(dummyResult, cellConnection)) continue;
                return true;
            }
            catch (EvaluationException e) {
                log.error((Object)"Could not evaluate reviewCycleCellConnection with dummy result!", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void signSignatureFolder(Collection<Integer> taskIds, Integer organisationPersonId, CDESCertificate cert, String password, Locale locale) throws WrongPasswordException, ReviewException {
        Date resultDate = Calendar.getInstance().getTime();
        for (Integer taskId : taskIds) {
            ReviewableTask task = (ReviewableTask)this.taskOperations.getTask(taskId);
            if (task == null) {
                throw new ReviewException(2);
            }
            DocumentVersion documentVersion = task.getDocumentVersion();
            SubProject subProject = task.getDocumentVersion().getDocument().getDocumentList().getSubProject();
            Network network = subProject.getProject().getNetwork();
            ReleasedDocumentList activeDocumentList = subProject.getActiveDocumentList();
            ReleasedObjectList activeObjectList = subProject.getActiveObjectList();
            String documentVersionName = "documentVersionId [" + documentVersion.getId() + "] name [" + documentVersion.getName() + "]";
            log.info((Object)("orgPersonId [" + organisationPersonId + "], certId [" + cert.getId() + "] will going to sign the follwing taskId of signatureFolder: [" + taskId + "] " + documentVersionName));
            ObjectPlannerImpl opImpl = (ObjectPlannerImpl)documentVersion.getDocument().getObjectPlanner();
            ReleasedObjectPlanner opRel = this.objectPlannerDAO.getReleasedObjectPlanner(activeObjectList.getId(), opImpl.getId());
            if (opRel == null) {
                throw new ReviewException(8);
            }
            ReviewCycleNode actualNode = documentVersion.getActualReviewCycleNode();
            ReviewCycleNodeInstanceRelease actualNodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(opRel.getReviewCycleInstance().getId(), actualNode.getId());
            boolean hasBreakingResult = false;
            if (log.isDebugEnabled()) {
                log.info((Object)("****subProjectId [" + (subProject != null ? subProject.getId() : "null") + "]"));
                log.info((Object)("****activeObjectListId [" + (subProject.getActiveObjectList() != null ? subProject.getActiveObjectList().getId() : "null") + "]"));
                log.info((Object)("****objectPlannerImplId [" + (opImpl != null ? opImpl.getId() : "null") + "]"));
                log.info((Object)("****relObjectPlannerId [" + (opRel != null ? opRel.getId() : "null") + "]"));
                log.info((Object)("****reviewCycleInstanceId [" + (opRel.getReviewCycleInstance() != null ? opRel.getReviewCycleInstance().getId() : "null") + "]"));
                log.info((Object)("****actualReviewCycleNodeId [" + (documentVersion.getActualReviewCycleNode() != null ? documentVersion.getActualReviewCycleNode().getId() : "null") + "]"));
            }
            if (task != null) {
                for (ReviewCyclePosition pos : task.getReviewCyclePositionReleases().values()) {
                    if (pos.getReviewCycleNodeInstance().getReviewCycleNode().getId().equals(actualNode.getId())) continue;
                    String msg = "The reviewCyclePosition " + pos.getReviewCycleNodeInstance().getReviewCycleNode().getId() + " of the reviewTask position does not match the current position " + actualNode.getId() + " of the documentVersion " + documentVersion.getId() + ".";
                    log.error((Object)msg);
                    throw new ReviewException(9, new Throwable(msg));
                }
            }
            ReviewCycleNodeResult reviewCycleNodeResult = this.reviewCycleNodeResultDAO.get(actualNode, documentVersion);
            Collection nodePositions = task.getReviewCyclePositionReleases().values();
            ProjectParticipation pp = this.projectParticipationDAO.get(task.getProjectParticipationId());
            ArrayList<ReviewCyclePositionResult> positionResultsToSign = new ArrayList<ReviewCyclePositionResult>();
            ArrayList<Integer> donePositionIds = new ArrayList<Integer>();
            ReviewCycleNodeInstanceRelease actualNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(opRel.getReviewCycleInstance().getId(), actualNode.getId());
            DigestCalculator dig = null;
            for (ReviewCyclePositionRelease nodePosition : nodePositions) {
                Map crossCommentConnections;
                block42: {
                    ReviewCyclePositionResult positionResult = this.getReviewCyclePositionResult2(nodePosition, documentVersion, reviewCycleNodeResult.getId());
                    if (positionResult == null) {
                        throw new ReviewException(10);
                    }
                    if (positionResult.getReviewCycleResultOption() == null) continue;
                    donePositionIds.add(nodePosition.getId());
                    try {
                        ArrayList<Attachment> att2Delete = new ArrayList<Attachment>();
                        if (positionResult.getAttachments() != null) {
                            for (Attachment attachment : positionResult.getAttachments().values()) {
                                if (attachment.getFileName() == null || attachment.getFileName().length() == 0) {
                                    att2Delete.add(attachment);
                                    continue;
                                }
                                this.attachmentOperations.updateFileDigest(attachment, network);
                            }
                        }
                        for (Attachment attachment : att2Delete) {
                            positionResult.getAttachments().remove(attachment.getId());
                            this.attachmentOperations.deleteAttachment(attachment.getId());
                        }
                        if (dig == null) {
                            dig = this.digestCalculatorFactory.getDigestCalculator(network, positionResult);
                        }
                        DigestCalculatorType t = this.digestCalculatorDAO.get(dig.getClass().getName());
                        positionResult.setDigestCalculatorType(t);
                        positionResult.setDigest(dig.getDigest(positionResult));
                        positionResult.setResultDate(resultDate);
                        positionResult = this.reviewCyclePositionResultDAO.update(positionResult);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Checking if ReviewCycleNode [" + TapestryI18nHelper.getLocalizedString(positionResult.getReviewCycleNode().getName()) + "] with id [" + positionResult.getId() + "] is finished and the DocumentVersion should be moved to next node."));
                        }
                        positionResultsToSign.add(positionResult);
                        if (positionResult.getReviewCycleResultOption().isFinishCell()) {
                            hasBreakingResult = true;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"ReviewCycleNode is finishing Cell, the ReviewCycle is over");
                            }
                        } else if (!hasBreakingResult && this.isNodeFinished(actualNodeInstance, positionResult.getReviewCycleNodeResult(), documentVersion)) {
                            DocumentVersionStatusChange change;
                            Calendar now;
                            DocumentVersion revisedVersion;
                            this.moveDocumentVersionToNextNode(actualNodeInstance, subProject.getActiveObjectList(), (ReviewCycleNodeResultImpl)positionResult.getReviewCycleNodeResult(), documentVersion, false);
                            if (documentVersion.getRevisedDocumentVersion() != null && documentVersion.getStatus() == 2) {
                                revisedVersion = documentVersion.getRevisedDocumentVersion();
                                revisedVersion.setStatus(4);
                                revisedVersion = this.documentVersionDAO.update(revisedVersion);
                                now = Calendar.getInstance();
                                change = new DocumentVersionStatusChange();
                                change.setChangeDate(now);
                                change.setDocumentVersionId(revisedVersion.getId());
                                change.setFileName(revisedVersion.getFileName());
                                change.setName(revisedVersion.getName());
                                change.setNewStatus(revisedVersion.getStatus());
                                this.documentVersionDAO.saveStatusChange(change);
                                this.createObjectPlannerDefinitionEMailSnippets(revisedVersion, opRel, now);
                            } else if (documentVersion.getRevisedDocumentVersion() != null && documentVersion.getStatus() == 10) {
                                revisedVersion = documentVersion.getRevisedDocumentVersion();
                                revisedVersion.setStatus(12);
                                revisedVersion = this.documentVersionDAO.update(revisedVersion);
                                now = Calendar.getInstance();
                                change = new DocumentVersionStatusChange();
                                change.setChangeDate(now);
                                change.setDocumentVersionId(revisedVersion.getId());
                                change.setFileName(revisedVersion.getFileName());
                                change.setName(revisedVersion.getName());
                                change.setNewStatus(revisedVersion.getStatus());
                                this.documentVersionDAO.saveStatusChange(change);
                                this.createObjectPlannerDefinitionEMailSnippets(revisedVersion, opRel, now);
                            }
                        }
                    }
                    catch (DigestCalculatorException e) {
                        throw new ActionException("SignReview", e);
                    }
                    catch (ActionException e) {
                        if (!(e.getCause() instanceof FileHandleException)) break block42;
                        throw new ReviewException(11, (Throwable)e);
                    }
                }
                if ((crossCommentConnections = actualNode.getNodeCrossCommentConnections()) == null || crossCommentConnections.isEmpty()) continue;
                for (ReviewCycleNodeResult nodeResult : reviewCycleNodeResult.getReviewCycleCellResult().getReviewCycleNodeResultsSortedByPosition(true)) {
                    if (!crossCommentConnections.containsKey(nodeResult.getReviewCycleNode().getId())) continue;
                    for (ReviewCyclePositionResult commentReference : nodeResult.getReviewCycleNodePositionResults().values()) {
                        ReviewCyclePositionResult commentResult = this.getReviewCyclePositionResult3(commentReference, pp, actualNode);
                        if (commentResult == null) continue;
                        if ((commentResult.getComment() == null || commentResult.getComment().isEmpty()) && commentResult.getReviewCycleResultOption() == null && !this.attachmentOperations.isRedliningAttachmentExistent(commentResult.getId())) {
                            this.reviewCyclePositionResultDAO.delete(commentResult);
                            continue;
                        }
                        ArrayList<Attachment> att2Delete = new ArrayList<Attachment>();
                        if (commentResult.getAttachments() != null) {
                            for (Attachment attachment : commentResult.getAttachments().values()) {
                                if (attachment.getFileName() == null || attachment.getFileName().length() == 0) {
                                    att2Delete.add(attachment);
                                    continue;
                                }
                                this.attachmentOperations.updateFileDigest(attachment, network);
                            }
                        }
                        for (Attachment attachment : att2Delete) {
                            commentResult.getAttachments().remove(attachment.getId());
                            this.attachmentOperations.deleteAttachment(attachment.getId());
                        }
                        commentResult.setDigestCalculatorType(this.digestCalculatorDAO.get(dig.getClass().getName()));
                        try {
                            commentResult.setDigest(dig.getDigest(commentResult));
                        }
                        catch (DigestCalculatorException e) {
                            throw new ActionException("SignReview", e);
                        }
                        commentResult.setResultDate(resultDate);
                        if (commentResult.getReviewCycleNodeResult() == null) {
                            commentResult.setReviewCycleNodeResult(reviewCycleNodeResult);
                        }
                        this.reviewCyclePositionResultDAO.update(commentResult);
                    }
                }
            }
            try {
                for (ReviewCyclePositionResult res : positionResultsToSign) {
                    SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(network, res);
                    ProjectParticipant signer = this.getSignerByParticipation(organisationPersonId, pp.getId());
                    CDESSignature sign = sig.createSignature(signer, dig.getSignableContent(res), cert, password);
                    ReviewCyclePositionResult pres = this.reviewCyclePositionResultDAO.get(res.getRealm(), res.getReviewCycleNodeResult(), res.getProjectParticipant().getParticipation());
                    if (pres != null && pres.getSignature() != null) {
                        throw new ActionException("Der Pr\u00fcfbereich wurde schon signiert");
                    }
                    sign = this.signatureDAO.save(sign);
                    res.setSignature(sign);
                    if (((res = this.reviewCyclePositionResultDAO.update(res)).getReviewCycleResultOption().getCellChangePartA() == null || res.getReviewCycleResultOption().getCellChangePartA().length() <= 0) && (res.getReviewCycleResultOption().getCellChangePartB() == null || res.getReviewCycleResultOption().getCellChangePartB().length() <= 0)) continue;
                    documentVersion = this.ognlNumberCalculator.getNumber(documentVersion.getDocument(), pp.getProject(), res.getReviewCycleResultOption(), documentVersion, opImpl.getReviewCycleInstance().getReviewCycle().getDocumentNumberVersionPart().getSeperator());
                    documentVersion = this.documentVersionDAO.update(documentVersion);
                }
            }
            catch (SignatureCalculatorException e) {
                throw new ActionException("SignReview", e);
            }
            catch (DigestCalculatorException e) {
                throw new ActionException("SignReview", e);
            }
            catch (NumberCalculatorException e) {
                throw new ActionException("SignReview", e);
            }
            if (hasBreakingResult) {
                this.moveDocumentVersionToNextNode(actualNodeInstance, subProject.getActiveObjectList(), (ReviewCycleNodeResultImpl)reviewCycleNodeResult, documentVersion, true);
            }
            if (task instanceof ReviewTask) {
                this.taskOperations.doReviewTask((ReviewTask)task, positionResultsToSign, donePositionIds);
                continue;
            }
            if (!(task instanceof AttachedReviewTask)) continue;
            this.taskOperations.doAttachedReviewTask((AttachedReviewTask)task, positionResultsToSign, donePositionIds);
        }
    }

    @Override
    public ReviewHistoryDTO getReviewHistoryDTOForOrgPerson(Integer documentId, Integer orgPersonId) {
        DocumentImpl doc = this.documentDAO.get(documentId);
        SubProject sp = doc.getDocumentList().getSubProject();
        OrganisationPerson organisationPerson = this.organisationPersonDAO.get(orgPersonId);
        CDESContext context = CdesDTOHelper.getContext(sp, organisationPerson);
        return this.getReviewHistoryDTO(documentId, context);
    }

    @Override
    public ReviewHistoryDTO getReviewHistoryDTO2(Integer documentId, Integer orgPersonId) {
        DocumentImpl doc = this.documentDAO.get(documentId);
        OrganisationPerson op = this.organisationPersonDAO.get(orgPersonId);
        CDESContext context = CdesDTOHelper.getContext(doc.getDocumentList().getSubProject(), op);
        return this.getReviewHistoryDTO(documentId, context);
    }

    @Override
    public ReviewHistoryDTO getReviewHistoryDTO(Integer documentId, CDESContext pageContext) {
        DocumentImpl doc = this.documentDAO.get(documentId);
        ArrayList<DocumentVersion> documentVersions = new ArrayList<DocumentVersion>(doc.getAllDocumentVersions());
        Collections.sort(documentVersions, new DocumentVersionComparator());
        SubProject sp = doc.getDocumentList().getSubProject();
        ReleasedObjectList objectList = sp.getActiveObjectList();
        ObjectPlannerImpl op = (ObjectPlannerImpl)doc.getObjectPlanner();
        ReleasedObjectPlanner rop = this.objectOperations.getReleasedObjectPlannerFromList(op.getId(), objectList.getId());
        if (rop == null) {
            rop = this.objectOperations.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(op.getId(), sp.getId());
        }
        ReviewHistoryDTO history = new ReviewHistoryDTO(pageContext);
        ArrayList<DocumentVersionDTO> documentVersionDTOs = new ArrayList<DocumentVersionDTO>();
        for (DocumentVersion dv : documentVersions) {
            Collection statements;
            boolean hasSignedRedlings = false;
            UploadResultDTO uploadResult = null;
            ReviewCycleCellConnectionResult cellConnectionResult = this.getReviewCycleCellConnectionResultByDocumentVersion(dv.getId());
            ReviewCycleEntryResult entryResult = null;
            if (cellConnectionResult == null) {
                entryResult = this.getReviewCycleEntryResultByDocumentVersion(dv.getId());
                uploadResult = CdesDTOHelper.getUploadResult(entryResult);
            } else {
                uploadResult = CdesDTOHelper.getUploadResult(cellConnectionResult);
            }
            ArrayList<VersionStatementDTO> versionStatementDTOs = new ArrayList<VersionStatementDTO>();
            if (cellConnectionResult != null && cellConnectionResult.getStatements() != null && !cellConnectionResult.getStatements().isEmpty()) {
                statements = cellConnectionResult.getStatements().values();
                for (ReviewCycleStatementResult statement : statements) {
                    versionStatementDTOs.add(CdesDTOHelper.getVersionStatementDTO(statement));
                }
            } else if (entryResult != null && entryResult.getStatements() != null && !entryResult.getStatements().isEmpty()) {
                statements = entryResult.getStatements().values();
                for (ReviewCycleStatementResult statement : statements) {
                    versionStatementDTOs.add(CdesDTOHelper.getVersionStatementDTO((ReviewCycleEntryStatementResultImpl)statement));
                }
            }
            ArrayList<ReviewCycleNodeResultDTO> nodeResultDTOs = new ArrayList<ReviewCycleNodeResultDTO>();
            ReviewCycleCellResult reviewCycleCellResult = this.getReviewCycleCellResult(dv.getActualReviewCycleNode().getReviewCycleCell().getId(), dv.getId());
            ArrayList<ReviewCycleNodeResult> previousNodeResults = new ArrayList<ReviewCycleNodeResult>();
            ArrayList<ReviewCyclePositionResultDTO> invalidationResults = new ArrayList<ReviewCyclePositionResultDTO>();
            for (ReviewCycleNodeResult nodeResult : reviewCycleCellResult.getReviewCycleNodeResultsSortedByPosition(true)) {
                Object positionResult22;
                ReviewCycleNodeInstanceRelease rnir = null;
                List<Object> positions = new ArrayList();
                ArrayList<Object> emptyPositions = new ArrayList<Object>();
                if (nodeResult.isFinished()) {
                    ObjectList nodeResultsObjectList = nodeResult.getActiveObjectListOfDocumentDeparture();
                    ReleasedObjectPlanner nodeResultsRop = this.objectOperations.getReleasedObjectPlannerFromList(op.getId(), nodeResultsObjectList.getId());
                    ReviewCycleInstanceRelease rel = (ReviewCycleInstanceRelease)nodeResultsRop.getReviewCycleInstance();
                    rnir = this.getReleasedReviewCycleNodeInstance3(nodeResult.getReviewCycleNode().getId(), rel.getId());
                } else {
                    ReviewCycleInstanceRelease rel = (ReviewCycleInstanceRelease)rop.getReviewCycleInstance();
                    rnir = this.getReleasedReviewCycleNodeInstance3(nodeResult.getReviewCycleNode().getId(), rel.getId());
                    positions = this.getReviewRelevantPositions(rnir, dv);
                    emptyPositions.addAll(positions);
                }
                if (positions.isEmpty() && nodeResult.getReviewCycleNodePositionResults().isEmpty() && !nodeResult.getReviewCycleNode().isEndNode()) continue;
                ArrayList<ReviewCyclePositionResultDTO> positionResultDTOs = new ArrayList<ReviewCyclePositionResultDTO>();
                ArrayList positionResults = new ArrayList(nodeResult.getReviewCycleNodePositionResults().values());
                Collections.sort(positionResults, new ReviewCyclePositionResultDateComparator());
                for (Object positionResult22 : positionResults) {
                    if (((ReviewCyclePositionResultImpl)positionResult22).getSignature() != null && ((ReviewCyclePositionResultImpl)positionResult22).getReviewCycleResultOption() != null && ((ReviewCyclePositionResultImpl)positionResult22).getReviewCycleResultOption().getValue() > -9) {
                        boolean isAttachedPositionResult = this.taskOperations.isAttachedReviewPositionResult(((ReviewCyclePositionResultImpl)positionResult22).getId());
                        ReviewCyclePositionResultDTO positionResultDTO = CdesDTOHelper.getReviewCyclePositionResultDTO((ReviewCyclePositionResult)positionResult22, isAttachedPositionResult);
                        positionResultDTOs.add(positionResultDTO);
                        if (((ReviewCyclePositionResultImpl)positionResult22).getAttachments() != null && !((ReviewCyclePositionResultImpl)positionResult22).getAttachments().isEmpty()) {
                            for (Attachment attachment : ((ReviewCyclePositionResultImpl)positionResult22).getAttachments().values()) {
                                if (!attachment.isRedliningDelta()) continue;
                                hasSignedRedlings = true;
                                break;
                            }
                        }
                        for (ReviewCyclePosition reviewCyclePosition : positions) {
                            if (!((ReviewCyclePositionResultImpl)positionResult22).getRealm().getId().equals(reviewCyclePosition.getRealm().getId()) || !((ReviewCyclePositionResultImpl)positionResult22).getProjectParticipant().getParticipation().getId().equals(reviewCyclePosition.getProjectParticipation().getId())) continue;
                            emptyPositions.remove(reviewCyclePosition);
                            break;
                        }
                    }
                    if (((ReviewCyclePositionResultImpl)positionResult22).getReviewCycleResultOption() == null || ((ReviewCyclePositionResultImpl)positionResult22).getReviewCycleResultOption().getValue() >= -8) continue;
                    ReviewCyclePositionResultDTO positionResultDTO = CdesDTOHelper.getReviewCyclePositionResultDTO((ReviewCyclePositionResult)positionResult22, false);
                    invalidationResults.add(positionResultDTO);
                }
                ArrayList<ReviewCycleNodePositionDTO> emptyPositionDTOs = new ArrayList<ReviewCycleNodePositionDTO>();
                positionResult22 = emptyPositions.iterator();
                while (positionResult22.hasNext()) {
                    ReviewCyclePosition position = (ReviewCyclePosition)positionResult22.next();
                    ReviewCycleNodePositionDTO nodePositionDTO = CdesDTOHelper.getReviewCycleNodePositionDTO((ReviewCyclePositionRelease)position, null, null);
                    emptyPositionDTOs.add(nodePositionDTO);
                }
                ArrayList<ReviewCyclePositionResultDTO> commentResultDTOs = new ArrayList<ReviewCyclePositionResultDTO>();
                if (!previousNodeResults.isEmpty() && (nodeResult.getReviewCycleResultOption() != null && nodeResult.getReviewCycleResultOption().getValue() != -8 || nodeResult.getReviewCycleNode().isEndNode()) && nodeResult.getReviewCycleNode().getNodeCrossCommentConnections() != null && !nodeResult.getReviewCycleNode().getNodeCrossCommentConnections().isEmpty()) {
                    for (ReviewCycleNodeResult previousNodeResult : previousNodeResults) {
                        if (!nodeResult.getReviewCycleNode().getNodeCrossCommentConnections().containsKey(previousNodeResult.getReviewCycleNode().getId())) continue;
                        List commentResults = this.getReviewCyclePositionResults(previousNodeResult, nodeResult);
                        boolean bl = false;
                        if (commentResults != null && !commentResults.isEmpty()) {
                            ArrayList tempCommentList = new ArrayList();
                            for (ReviewCyclePositionResultImpl commentResult : commentResults) {
                                if (commentResult.getDigest() == null || (commentResult.getComment() == null || commentResult.getComment().isEmpty()) && commentResult.getReviewCycleCommentOption() == null && !this.attachmentOperations.isRedliningAttachmentExistent(commentResult.getId())) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl) continue;
                        for (ReviewCyclePositionResultImpl commentResult : commentResults) {
                            commentResultDTOs.add(CdesDTOHelper.getReviewCyclePositionResultDTO(commentResult, false));
                        }
                    }
                }
                previousNodeResults.add(nodeResult);
                ReviewCycleNodeInstanceDTO nodeInstanceDTO = CdesDTOHelper.getReviewCycleNodeInstanceDTO(rnir, emptyPositionDTOs);
                ReviewCycleResultOptionDTO reviewCycleResultOptionDTO = CdesDTOHelper.getReviewCycleResultOptionDTO(nodeResult.getReviewCycleResultOption(), false, false);
                ReviewCycleNodeResultDTO reviewCycleNodeResultDTO = CdesDTOHelper.getReviewCycleNodeResultDTO(nodeResult, nodeInstanceDTO, positionResultDTOs, commentResultDTOs, emptyPositionDTOs, null, reviewCycleResultOptionDTO);
                nodeResultDTOs.add(reviewCycleNodeResultDTO);
            }
            DocumentVersionDTO asBuiltReference = null;
            if (dv.getAsBuiltReference() != null && dv.getDocument().getFirstDocumentVersion().getId().equals(dv.getId())) {
                asBuiltReference = CdesDTOHelper.getDocumentVersionDTO(dv.getAsBuiltReference(), null, null, true);
                UploadResultDTO asBuiltReferenceUploadResult = null;
                ReviewCycleCellConnectionResult asBuiltReferenceCellConnectionResult = this.getReviewCycleCellConnectionResultByDocumentVersion(asBuiltReference.getId());
                ReviewCycleEntryResult asBuiltReferenceEntryResult = null;
                if (asBuiltReferenceCellConnectionResult == null) {
                    asBuiltReferenceEntryResult = this.getReviewCycleEntryResultByDocumentVersion(asBuiltReference.getId());
                    asBuiltReferenceUploadResult = CdesDTOHelper.getUploadResult(asBuiltReferenceEntryResult);
                } else {
                    asBuiltReferenceUploadResult = CdesDTOHelper.getUploadResult(asBuiltReferenceCellConnectionResult);
                }
                asBuiltReference.setUploadResult(asBuiltReferenceUploadResult);
                documentVersionDTOs.add(asBuiltReference);
            }
            DocumentVersionDTO documentVersionDTO = CdesDTOHelper.getDocumentVersionDTO(dv, null, versionStatementDTOs, nodeResultDTOs, false);
            documentVersionDTO.setHasSignedRedlings(hasSignedRedlings);
            documentVersionDTO.setUploadResult(uploadResult);
            documentVersionDTO.setInvalidationResults(invalidationResults);
            documentVersionDTOs.add(documentVersionDTO);
        }
        Document releasedOrImplDocument = doc.getLastReleasedOrImplDocument();
        history.setDocument(CdesDTOHelper.getDocumentDTO(releasedOrImplDocument, documentVersionDTOs));
        Collection<DocumentRef> docRefs = doc.getDocumentRefs().values();
        for (DocumentRef docRef : docRefs) {
            history.getDocumentReferences().add(CdesDTOHelper.getDocumentReferenceDTO(docRef));
        }
        return history;
    }

    @Override
    public ReviewContextDTO insertNewOrGetExistingReviewContext(Integer reviewableTaskId, Integer organisationPersonId, Integer overridingProjectParticipantId) {
        ReviewableTask task = (ReviewableTask)this.taskOperations.getTask(reviewableTaskId);
        OrganisationPerson op = this.organisationPersonDAO.get(organisationPersonId);
        DocumentVersion version = task.getDocumentVersion();
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(version.getActualReviewCycleNode(), version);
        SubProject sp = version.getDocument().getDocumentList().getSubProject();
        Collection resultOptions = version.getActualReviewCycleNode().getReviewCyclePositionType().getReviewCycleResultOptions().values();
        ReleasedObjectPlanner rop = this.objectOperations.getReleasedObjectPlannerFromActiveObjectList(version.getDocument().getObjectPlanner().getId(), sp.getId());
        ReviewContextDTO reviewContextResult = CdesDTOHelper.getReviewContextDTO(task, version, sp, op, rop, this.getReviewHistoryDTOForOrgPerson(version.getDocument().getId(), organisationPersonId));
        Map reviewCyclePositionReleases = task.getReviewCyclePositionReleases();
        for (ReviewCyclePositionRelease position : reviewCyclePositionReleases.values()) {
            ProjectParticipant participant = this.getSignerByTask(organisationPersonId, position.getId(), task);
            ReviewCyclePositionResult result = null;
            if (overridingProjectParticipantId != null) {
                result = this.reviewCyclePositionResultDAO.getUnsignedOverridingReviewCyclePositionResult(position, version, nodeResult.getId(), overridingProjectParticipantId);
            }
            if (result == null && (result = this.getReviewCyclePositionResult2(position, version, nodeResult.getId())) != null) {
                if (overridingProjectParticipantId != null) {
                    result.setOverridingProjectParticipant(this.projectParticipantDAO.get(overridingProjectParticipantId));
                    result.setProjectParticipant(position.getProjectParticipation().getMainParticipant());
                } else {
                    result.setProjectParticipant(participant);
                }
            }
            if (result == null) {
                result = new ReviewCyclePositionResultImpl();
                result.setActiveObjectList(sp.getActiveObjectList());
                result.setActiveDocumentList(sp.getActiveDocumentList());
                result.setDocumentVersion(version);
                if (overridingProjectParticipantId != null) {
                    result.setOverridingProjectParticipant(this.projectParticipantDAO.get(overridingProjectParticipantId));
                    result.setProjectParticipant(position.getProjectParticipation().getMainParticipant());
                } else {
                    result.setProjectParticipant(participant);
                }
                result.setResultDate(Calendar.getInstance().getTime());
                result.setReviewCycleNode(nodeResult.getReviewCycleNode());
                result.setReviewCycleNodeResult(nodeResult);
                result.setRealm(position.getRealm());
                result = this.reviewCyclePositionResultDAO.save(result);
            }
            boolean attachedPositionResult = this.taskOperations.isAttachedReviewPositionResult(result.getId());
            ReviewCyclePositionResultDTO resultDTO = CdesDTOHelper.getReviewCyclePositionResultDTO(result, attachedPositionResult);
            ArrayList<ReviewCycleResultOptionDTO> resultOptionDTOs = new ArrayList<ReviewCycleResultOptionDTO>();
            for (ReviewCycleResultOption option : resultOptions) {
                boolean validConnection = true;
                if (option.isEvaluateCellConnections() && !this.evaluateConnectionsForResultOption(task.getId(), option.getId())) {
                    validConnection = false;
                }
                resultOptionDTOs.add(CdesDTOHelper.getReviewCycleResultOptionDTO(option, result.getReviewCycleResultOption() != null && result.getReviewCycleResultOption().getId().equals(option.getId()) && result.getReviewCycleResultOption().isAuthorized(), !validConnection));
            }
            boolean attachedPosition = false;
            if (position instanceof AttachedReviewCyclePositionImpl) {
                attachedPosition = true;
            }
            ReviewCycleNodePositionDTO positionDTO = new ReviewCycleNodePositionDTO(position.getId(), CdesDTOHelper.getRealmDTO(position.getRealm()), CdesDTOHelper.getProjectParticipantDTO(position.getProjectParticipation().getMainParticipant(), false), resultDTO, resultOptionDTOs, attachedPosition, TapestryI18nHelper.getLocalizedString(position.getReviewCycleNodeInstance().getReviewCycleNode().getName()));
            ProjectParticipant commentingParticipant = null;
            commentingParticipant = overridingProjectParticipantId == null ? participant : this.projectParticipationDAO.get(task.getProjectParticipationId()).getMainParticipant();
            List<ReviewCycleCommentResultNodeDTO> commentResultNodes = this.getCommentResultDTOs(nodeResult, task, commentingParticipant, sp.getActiveObjectList(), sp.getActiveDocumentList());
            reviewContextResult.setCommentResultNodes(commentResultNodes);
            reviewContextResult.getPositions().add(positionDTO);
        }
        ArrayList<ReviewCycleCommentOption> commentOptions = new ArrayList<ReviewCycleCommentOption>();
        if (version.getActualReviewCycleNode().getReviewCycleCommentType() != null && version.getActualReviewCycleNode().getReviewCycleCommentType().getReviewCycleCommentOptions() != null) {
            commentOptions.addAll(version.getActualReviewCycleNode().getReviewCycleCommentType().getReviewCycleCommentOptions().values());
        }
        reviewContextResult.setCommentOptions(CdesDTOHelper.getReviewCycleCommentOptionDTOs(commentOptions));
        return reviewContextResult;
    }

    @Override
    public int getDocumentVersionCount(Integer projectId) {
        return this.documentVersionDAO.getDocumentVersionCount(projectId);
    }

    @Override
    public int getDocumentVersionCountGroupedByDoc(Integer projectId) {
        return this.documentVersionDAO.getDocumentVersionCountGroupedByDoc(projectId);
    }

    @Override
    public int getSignatureCount(Integer projectId) {
        return this.signatureDAO.getSignatureCount(projectId);
    }

    @Override
    public int getRedliningCount() {
        return this.attachmentDAO.getRedliningCount();
    }

    @Override
    public void saveUnsignedReviewPositionResultDTOs(List<ReviewCycleNodePositionDTO> nodePositions, List<ReviewCyclePositionResultDTO> commentReferences, Integer taskId, Integer organisationPersonId, Integer overridingProjectParticipantId, boolean saveToSignatureFolder) throws ReviewException {
        ReviewableTask task = (ReviewableTask)this.taskOperations.getTask(taskId);
        if (task == null) {
            throw new ReviewException(2);
        }
        DocumentVersion documentVersion = task.getDocumentVersion();
        SubProject subProject = documentVersion.getDocument().getDocumentList().getSubProject();
        ReleasedDocumentList activeDocumentList = subProject.getActiveDocumentList();
        ReleasedObjectList activeObjectList = subProject.getActiveObjectList();
        ProjectParticipant projectParticipant = null;
        ProjectParticipant overridingProjectParticipant = null;
        ReviewCycleNode actualNode = documentVersion.getActualReviewCycleNode();
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(actualNode, documentVersion);
        if (overridingProjectParticipantId != null) {
            overridingProjectParticipant = this.projectParticipantDAO.get(overridingProjectParticipantId);
            projectParticipant = this.projectParticipationDAO.get(task.getProjectParticipationId()).getMainParticipant();
        } else {
            projectParticipant = this.projectParticipantDAO.get(task.getProjectParticipationId(), organisationPersonId);
        }
        Date now = Calendar.getInstance().getTime();
        for (ReviewCycleNodePositionDTO nodePosition : nodePositions) {
            Realm realm = this.realmDAO.get(nodePosition.getRealm().getId());
            ReviewCyclePositionResultDTO resultDTO = nodePosition.getUnsignedResult();
            ReviewCyclePositionResult result = this.getReviewCyclePositionResult(resultDTO.getId());
            if (result.getDigest() != null) {
                return;
            }
            String comment = this.CleanHTMLComments(resultDTO.getComment());
            result.setComment(comment);
            result.setAuthorized(resultDTO.isAuthorized());
            ReviewCycleResultOptionDTO resultOptionDTO = resultDTO.getReviewCycleResultOption();
            ReviewCycleResultOption resultOption = null;
            if (resultOptionDTO != null && resultOptionDTO.getId() != null) {
                resultOption = this.getReviewCycleResultOption(resultOptionDTO.getId());
            }
            result.setReviewCycleResultOption(resultOption);
            result.setActiveDocumentList(activeDocumentList);
            result.setActiveObjectList(activeObjectList);
            result.setProjectParticipant(projectParticipant);
            result.setOverridingProjectParticipant(overridingProjectParticipant);
            result.setResultDate(now);
            result.setRealm(realm);
            if (result.getOverridingProjectParticipant() != null && overridingProjectParticipantId == null) {
                result.setOverridingProjectParticipant(null);
            }
            result = this.reviewCyclePositionResultDAO.update(result);
        }
        if (commentReferences != null) {
            for (ReviewCyclePositionResultDTO commentReferenceDTO : commentReferences) {
                ReviewCyclePositionResult commentResult = this.reviewCyclePositionResultDAO.get(commentReferenceDTO.getId());
                commentResult.setActiveObjectList(activeObjectList);
                commentResult.setActiveDocumentList(activeDocumentList);
                String commentReference = this.CleanHTMLComments(commentReferenceDTO.getComment());
                commentResult.setComment(commentReference);
                if (commentReferenceDTO.getReviewCycleCommentOption() != null) {
                    commentResult.setReviewCycleCommentOption(this.reviewCycleCommentOptionDAO.get(commentReferenceDTO.getReviewCycleCommentOption().getId()));
                }
                commentResult.setResultDate(now);
                commentResult.setReviewCycleNode(actualNode);
                commentResult.setReviewCycleNodeResult(nodeResult);
                commentResult = this.reviewCyclePositionResultDAO.update(commentResult);
            }
        }
        if (saveToSignatureFolder) {
            this.taskOperations.updateTaskStatus(taskId, 1);
        }
    }

    @Override
    public void signReviewDTOs(ArrayList<ReviewCycleNodePositionDTO> nodePositions, List<ReviewCyclePositionResultDTO> commentReferences, Integer taskId, Integer organisationPersonId, Integer overridingProjectParticipantId, String password) throws MissingSignatureRightsException, MissingSignerCertificateException, NumberCalculatorException, WrongPasswordException, ReviewException {
        this.saveUnsignedReviewPositionResultDTOs(nodePositions, commentReferences, taskId, organisationPersonId, overridingProjectParticipantId, false);
        ReviewableTask task = (ReviewableTask)this.taskOperations.getTask(taskId);
        DocumentVersion documentVersion = task.getDocumentVersion();
        SubProject subProject = documentVersion.getDocument().getDocumentList().getSubProject();
        ReleasedDocumentList activeDocumentList = subProject.getActiveDocumentList();
        ReleasedObjectList activeObjectList = subProject.getActiveObjectList();
        ObjectPlannerImpl opImpl = (ObjectPlannerImpl)documentVersion.getDocument().getObjectPlanner();
        ReleasedObjectPlanner opRel = this.objectPlannerDAO.getReleasedObjectPlanner(activeObjectList.getId(), opImpl.getId());
        ReviewCycleNode actualNode = documentVersion.getActualReviewCycleNode();
        ReviewCycleNodeInstanceRelease actualNodeInstanceRelease = this.reviewCycleNodeInstanceDAO.getReleased(opRel.getReviewCycleInstance().getId(), actualNode.getId());
        Network network = subProject.getProject().getNetwork();
        Calendar now = Calendar.getInstance();
        ProjectParticipant signer = null;
        signer = overridingProjectParticipantId == null ? this.getSignerByTask(organisationPersonId, nodePositions.get(0).getId(), task) : this.getSigner(organisationPersonId, subProject.getProject().getId(), "overrideLateReviews");
        if (signer == null) {
            throw new MissingSignatureRightsException();
        }
        CDESCertificate signerCertificate = this.certificateOperations.getSignerCertificate(organisationPersonId, false);
        if (signerCertificate == null) {
            throw new MissingSignerCertificateException();
        }
        ProjectParticipant projectParticipant = null;
        ProjectParticipant overridingProjectParticipant = null;
        if (overridingProjectParticipantId != null) {
            overridingProjectParticipant = this.projectParticipantDAO.get(overridingProjectParticipantId);
            projectParticipant = this.projectParticipationDAO.get(task.getProjectParticipationId()).getMainParticipant();
        } else {
            projectParticipant = this.projectParticipantDAO.get(task.getProjectParticipationId(), organisationPersonId);
        }
        if (task != null) {
            for (ReviewCyclePosition pos : task.getReviewCyclePositionReleases().values()) {
                if (pos.getReviewCycleNodeInstance().getReviewCycleNode().getId().equals(actualNode.getId())) continue;
                String msg = "The reviewCyclePosition " + pos.getReviewCycleNodeInstance().getReviewCycleNode().getId() + " of the reviewTask position does not match the current position " + actualNode.getId() + " of the documentVersion " + documentVersion.getId() + ".";
                log.error((Object)msg);
                throw new ReviewException(9, new Throwable(msg));
            }
        }
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(actualNode, documentVersion);
        DigestCalculator dig = null;
        DigestCalculatorType digType = null;
        ArrayList<ReviewCyclePositionResult> positionResultsToSign = new ArrayList<ReviewCyclePositionResult>();
        ArrayList<Integer> donePositionIds = new ArrayList<Integer>();
        boolean hasBreakingResult = false;
        for (ReviewCycleNodePositionDTO nodePosition : nodePositions) {
            ReviewCyclePositionResult result;
            block36: {
                ReviewCyclePositionResultDTO unsignedResult = nodePosition.getUnsignedResult();
                if (unsignedResult.getReviewCycleResultOption() == null) continue;
                if (!task.getReviewCyclePositionReleases().containsKey(nodePosition.getId())) {
                    throw new ReviewException(9, new Throwable("The review position release to be signed [ID=" + nodePosition.getId() + "] has not been found in the ReviewTask."));
                }
                donePositionIds.add(nodePosition.getId());
                result = this.reviewCyclePositionResultDAO.get(unsignedResult.getId());
                positionResultsToSign.add(result);
                ArrayList<Attachment> att2Delete = new ArrayList<Attachment>();
                try {
                    if (result.getAttachments() != null) {
                        for (Attachment attachment : result.getAttachments().values()) {
                            if (attachment.getFileName() == null || attachment.getFileName().length() == 0) {
                                att2Delete.add(attachment);
                                continue;
                            }
                            this.attachmentOperations.updateFileDigest(attachment, network);
                        }
                    }
                    for (Attachment attachment : att2Delete) {
                        result.getAttachments().remove(attachment.getId());
                        this.attachmentOperations.deleteAttachment(attachment.getId());
                    }
                }
                catch (ActionException e) {
                    if (!(e.getCause() instanceof FileHandleException)) break block36;
                    throw new ReviewException(11, (Throwable)e);
                }
            }
            try {
                DocumentVersionStatusChange change;
                DocumentVersion revisedVersion;
                if (dig == null) {
                    dig = this.digestCalculatorFactory.getDigestCalculator(network, result);
                }
                if (digType == null) {
                    digType = this.digestCalculatorDAO.get(dig.getClass().getName());
                }
                result.setDigestCalculatorType(digType);
                result.setDigest(dig.getDigest(result));
                this.reviewCyclePositionResultDAO.update(result);
                if (result.getReviewCycleResultOption().isFinishCell()) {
                    ((ReviewCycleNodeResultImpl)nodeResult).setReviewCycleResultOption(result.getReviewCycleResultOption());
                    hasBreakingResult = true;
                    continue;
                }
                if (hasBreakingResult || !this.isNodeFinished(actualNodeInstanceRelease, nodeResult, documentVersion)) continue;
                ((ReviewCycleNodeResultImpl)nodeResult).setReviewCycleResultOption(result.getReviewCycleResultOption());
                this.moveDocumentVersionToNextNode(actualNodeInstanceRelease, activeObjectList, (ReviewCycleNodeResultImpl)nodeResult, documentVersion, hasBreakingResult);
                if (documentVersion.getRevisedDocumentVersion() != null && documentVersion.getStatus() == 2) {
                    revisedVersion = documentVersion.getRevisedDocumentVersion();
                    revisedVersion.setStatus(4);
                    revisedVersion = this.documentVersionDAO.update(revisedVersion);
                    change = new DocumentVersionStatusChange();
                    change.setChangeDate(now);
                    change.setDocumentVersionId(revisedVersion.getId());
                    change.setFileName(revisedVersion.getFileName());
                    change.setName(revisedVersion.getName());
                    change.setNewStatus(revisedVersion.getStatus());
                    this.documentVersionDAO.saveStatusChange(change);
                    this.createObjectPlannerDefinitionEMailSnippets(revisedVersion, opRel, now);
                    continue;
                }
                if (documentVersion.getRevisedDocumentVersion() == null || documentVersion.getStatus() != 10) continue;
                revisedVersion = documentVersion.getRevisedDocumentVersion();
                revisedVersion.setStatus(12);
                revisedVersion = this.documentVersionDAO.update(revisedVersion);
                change = new DocumentVersionStatusChange();
                change.setChangeDate(now);
                change.setDocumentVersionId(revisedVersion.getId());
                change.setFileName(revisedVersion.getFileName());
                change.setName(revisedVersion.getName());
                change.setNewStatus(revisedVersion.getStatus());
                this.documentVersionDAO.saveStatusChange(change);
                this.createObjectPlannerDefinitionEMailSnippets(revisedVersion, opRel, now);
            }
            catch (DigestCalculatorException e) {
                throw new ReviewException(-1, new Throwable("DigestCalculator caught exception:" + e.getMessage()));
            }
        }
        try {
            if (commentReferences != null) {
                for (ReviewCyclePositionResultDTO commentResultDTO : commentReferences) {
                    ReviewCyclePositionResult commentResult = this.reviewCyclePositionResultDAO.get(commentResultDTO.getId());
                    commentResult.setActiveObjectList(activeObjectList);
                    commentResult.setActiveDocumentList(activeDocumentList);
                    commentResult.setComment(commentResultDTO.getComment());
                    commentResult.setProjectParticipant(signer);
                    commentResult.setResultDate(now.getTime());
                    commentResult.setReviewCycleNode(actualNode);
                    commentResult.setReviewCycleNodeResult(nodeResult);
                    this.reviewCyclePositionResultDAO.update(commentResult);
                    ArrayList<Attachment> att2Delete = new ArrayList<Attachment>();
                    if (commentResult.getAttachments() != null) {
                        for (Attachment attachment : commentResult.getAttachments().values()) {
                            if (attachment.getFileName() == null || attachment.getFileName().length() == 0) {
                                att2Delete.add(attachment);
                                continue;
                            }
                            this.attachmentOperations.updateFileDigest(attachment, network);
                        }
                    }
                    for (Attachment attachment : att2Delete) {
                        commentResult.getAttachments().remove(attachment.getId());
                        this.attachmentOperations.deleteAttachment(attachment.getId());
                    }
                    commentResult.setDigestCalculatorType(digType);
                    commentResult.setDigest(dig.getDigest(commentResult));
                }
            }
            for (ReviewCyclePositionResult result : positionResultsToSign) {
                ReviewCyclePositionResult previouslySignedResult = this.reviewCyclePositionResultDAO.get(result.getRealm(), result.getReviewCycleNodeResult(), result.getProjectParticipant().getParticipation());
                if (previouslySignedResult != null && previouslySignedResult.getSignature() != null) {
                    throw new ReviewException(5, new Throwable("Der Pr\u00fcfbereich wurde bereits signiert."));
                }
                SignatureCalculator sigCalc = this.signatureCalculatorFactory.getSignatureCalculator(network, result);
                CDESSignature signature = sigCalc.createSignature(signer, dig.getSignableContent(result), signerCertificate, password);
                signature = this.signatureDAO.save(signature);
                result.setSignature(signature);
                if (((result = this.reviewCyclePositionResultDAO.update(result)).getReviewCycleResultOption().getCellChangePartA() == null || result.getReviewCycleResultOption().getCellChangePartA().length() <= 0) && (result.getReviewCycleResultOption().getCellChangePartB() == null || result.getReviewCycleResultOption().getCellChangePartB().length() <= 0)) continue;
                documentVersion = this.ognlNumberCalculator.getNumber(documentVersion.getDocument(), subProject.getProject(), result.getReviewCycleResultOption(), documentVersion, opImpl.getReviewCycleInstance().getReviewCycle().getDocumentNumberVersionPart().getSeperator());
                documentVersion = this.documentVersionDAO.update(documentVersion);
            }
        }
        catch (DigestCalculatorException e) {
            log.error((Object)e);
            throw new ReviewException(-1, new Throwable("DigestCalculator caught exception:" + e.getMessage()));
        }
        catch (SignatureCalculatorException e) {
            log.error((Object)e);
            throw new ReviewException(-1, new Throwable("SignatureCalculator caught exception:" + e.getMessage()));
        }
        if (hasBreakingResult) {
            this.moveDocumentVersionToNextNode(actualNodeInstanceRelease, activeObjectList, (ReviewCycleNodeResultImpl)nodeResult, documentVersion, hasBreakingResult);
        }
        if (task != null) {
            if (task instanceof ReviewTask) {
                this.taskOperations.doReviewTask((ReviewTask)task, positionResultsToSign, donePositionIds);
            } else if (task instanceof AttachedReviewTask) {
                this.taskOperations.doAttachedReviewTask((AttachedReviewTask)task, positionResultsToSign, donePositionIds);
            }
        }
    }

    private List<ReviewCycleCommentResultNodeDTO> getCommentResultDTOs(ReviewCycleNodeResult actualNodeResult, ReviewableTask task, ProjectParticipant participant, ReleasedObjectList activeObjectList, ReleasedDocumentList activeDocumentList) {
        ArrayList<ReviewCycleCommentResultNodeDTO> commentResultNodes = new ArrayList<ReviewCycleCommentResultNodeDTO>();
        ReviewCycleNode actualNode = task.getDocumentVersion().getActualReviewCycleNode();
        if (actualNode.getNodeCrossCommentConnections() == null || actualNode.getNodeCrossCommentConnections().isEmpty()) {
            return commentResultNodes;
        }
        ReviewCycleCellResult cellResult = actualNodeResult.getReviewCycleCellResult();
        ProjectParticipation signer = this.projectParticipationDAO.get(task.getProjectParticipationId());
        Collection<ReviewCycleNodeResult> nodeResultsSortedByPosition = cellResult.getReviewCycleNodeResultsSortedByPosition(true);
        for (ReviewCycleNodeResult nodeResult : nodeResultsSortedByPosition) {
            if (!actualNode.getNodeCrossCommentConnections().containsKey(nodeResult.getReviewCycleNode().getId())) continue;
            ArrayList comments = new ArrayList();
            ArrayList positionResults = new ArrayList(nodeResult.getReviewCycleNodePositionResults().values());
            Collections.sort(positionResults, new ReviewCyclePositionResultDateComparator());
            ArrayList<ReviewCyclePositionResultDTO> commentResults = new ArrayList<ReviewCyclePositionResultDTO>();
            for (ReviewCyclePositionResult positionResult : positionResults) {
                if (positionResult.getDigest() == null || positionResult.getReviewCycleResultOption() != null && positionResult.getReviewCycleResultOption().getValue() < 0) continue;
                ReviewCyclePositionResult commentResult = this.insertNewOrGetExistingReviewCyclePositionResult2(positionResult, signer, actualNode, participant, task.getDocumentVersion(), activeDocumentList, activeObjectList, null);
                String sCommentReferenceComment = Jsoup.clean((String)commentResult.getCommentReference().getComment(), (Whitelist)Whitelist.basic());
                commentResult.getCommentReference().setComment(sCommentReferenceComment);
                ReviewCyclePositionResultDTO commentResultDTO = CdesDTOHelper.getReviewCyclePositionResultDTO(commentResult, false);
                commentResults.add(commentResultDTO);
            }
            if (commentResults.isEmpty()) continue;
            commentResultNodes.add(new ReviewCycleCommentResultNodeDTO(nodeResult.getDocumentVersion().getVersionPart(), TapestryI18nHelper.getLocalizedString(nodeResult.getReviewCycleNode().getName()), commentResults));
        }
        return commentResultNodes;
    }

    public void setCertificateOperations(CertificateOperations certificateOperations) {
        this.certificateOperations = certificateOperations;
    }

    @Override
    public void signSignatureFolderTaskDTOs(ArrayList<Integer> taskIds, Integer orgPersonId, String password, String userLocale) throws MissingSignerCertificateException, WrongPasswordException {
        CDESCertificate signerCertificate = this.certificateOperations.getSignerCertificate(orgPersonId, false);
        if (signerCertificate == null) {
            throw new MissingSignerCertificateException();
        }
        Locale locale = new Locale(userLocale);
        this.signSignatureFolder(taskIds, orgPersonId, signerCertificate, password, locale);
    }

    @Override
    public void signNonReviewTasksDTOs(ArrayList<Integer> taskIds, Integer orgPersonId, String comment, String password, String userLocale) throws MissingSignerCertificateException, FrontendException {
        CDESCertificate signerCertificate = this.certificateOperations.getSignerCertificate(orgPersonId, false);
        if (signerCertificate == null) {
            throw new MissingSignerCertificateException();
        }
        ArrayList<ReviewableTask> tasks = new ArrayList<ReviewableTask>();
        for (Integer taskId : taskIds) {
            ReviewableTask task = (ReviewableTask)this.taskOperations.getTask(taskId);
            if (task == null) {
                throw new ReviewException(2);
            }
            tasks.add(task);
        }
        this.signNonReviewTasks(tasks, orgPersonId, comment, password, signerCertificate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlanningNotificationDTO saveOrUpdatePlanningNotification(PlanningNotificationDTO planningNotificationDTO, List<PlanningNotificationMetaInformationDTO> metaInformationDTOs, String originalFileName, IMimeInputStream fileInputStream) throws MissingPropertyException, IOError, FileHandleException, IOException {
        planningNotificationDTO = this.saveOrUpdatePlanningNotification_intern(planningNotificationDTO, metaInformationDTOs);
        PlanningNotification planningNotification = this.planningNotificationDAO.get(planningNotificationDTO.getId());
        InputStream fis = null;
        String filePath = null;
        if (fileInputStream != null && originalFileName != null) {
            try {
                fis = DataSourceHelper.toDataSource(fileInputStream).getInputStream();
                filePath = this.uploadFileHandler.savePlanningNotificationFile(planningNotification, originalFileName, fis);
                planningNotification.setFilename(originalFileName);
                planningNotification.setPath(filePath);
                planningNotification = this.planningNotificationDAO.update(planningNotification);
            }
            catch (Exception e) {
                log.info((Object)"error occurred while saving the attachment", (Throwable)e);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return CdesDTOHelper.getPlanningNotificationDTO(planningNotification, false);
    }

    private PlanningNotificationDTO saveOrUpdatePlanningNotification_intern(PlanningNotificationDTO planningNotificationDTO, List<PlanningNotificationMetaInformationDTO> metaInformationDTOs) throws MissingPropertyException {
        PlanningNotification planningNotification = null;
        planningNotification = planningNotificationDTO.getId() != null ? this.planningNotificationDAO.get(planningNotificationDTO.getId()) : new PlanningNotification();
        planningNotification.setTitle(planningNotificationDTO.getTitle());
        planningNotification.setComment(planningNotificationDTO.getComment());
        planningNotification.setFilename(planningNotificationDTO.getFilename());
        planningNotification.setPath(planningNotificationDTO.getPath());
        planningNotification.setType(planningNotificationDTO.getType());
        if (planningNotificationDTO.getNetwork() == null) {
            throw new MissingPropertyException(NetworkDTO.class.getName());
        }
        Network network = this.networkDAO.get(planningNotificationDTO.getNetwork().getId());
        planningNotification.setNetwork(network);
        PlanningNotificationTemplate template = this.planningNotificationDAO.getTemplate(planningNotificationDTO.getPlanningNotificationTemplate().getId());
        planningNotification.setPlanningNotificationTemplate(template);
        if (planningNotification.getId() == null) {
            planningNotification = this.planningNotificationDAO.save(planningNotification);
        }
        if (planningNotificationDTO.getProjects() == null || planningNotificationDTO.getProjects().isEmpty()) {
            ArrayList projects = new ArrayList(this.projectDAO.getAllPlanningNotificationProjectsFromNetwork(network.getId()));
            if (projects == null || projects.isEmpty()) {
                throw new MissingPropertyException(ProjectDTO.class.getName());
            }
            if (planningNotification.getAssociatedProjects() == null) {
                planningNotification.setAssociatedProjects(new HashMap<Integer, Project>());
            }
            for (Project project : projects) {
                planningNotification.getAssociatedProjects().put(project.getId(), project);
            }
        }
        if (planningNotificationDTO.getProjects() != null) {
            if (planningNotification.getAssociatedProjects() == null) {
                planningNotification.setAssociatedProjects(new HashMap<Integer, Project>());
            }
            for (ProjectDTO projectDTO : planningNotificationDTO.getProjects().values()) {
                Project project;
                project = this.projectDAO.get(projectDTO.getId());
                planningNotification.getAssociatedProjects().put(project.getId(), project);
            }
        }
        if (metaInformationDTOs != null) {
            planningNotification.setPlanningNotificationMetaInformations(new HashMap<Integer, PlanningNotificationMetaInformation>());
            for (PlanningNotificationMetaInformationDTO metaDTO : metaInformationDTOs) {
                Calendar metaInfoDate;
                Date value;
                if (metaDTO.getPlanningNotificationMetaTag() == null) {
                    throw new MissingPropertyException(MetaTagDTO.class.getName());
                }
                MetaInformation meta = null;
                if (metaDTO.getId() != null) {
                    meta = this.metaInformationDAO.get(metaDTO.getId());
                    if (meta instanceof PlanningNotificationTextMetaInformation) {
                        if (((PlanningNotificationTextMetaInformationDTO)metaDTO).getValue().isEmpty()) {
                            this.metaInformationDAO.delete(meta);
                            planningNotification.getPlanningNotificationMetaInformations().remove(meta.getId());
                            continue;
                        }
                        ((PlanningNotificationTextMetaInformation)meta).setValue(((PlanningNotificationTextMetaInformationDTO)metaDTO).getValue());
                    } else if (meta instanceof PlanningNotificationDateMetaInformation) {
                        if (((PlanningNotificationDateMetaInformationDTO)metaDTO).getValue() == null) {
                            this.metaInformationDAO.delete(meta);
                            planningNotification.getPlanningNotificationMetaInformations().remove(meta.getId());
                            continue;
                        }
                        value = ((PlanningNotificationDateMetaInformationDTO)metaDTO).getValue();
                        metaInfoDate = Calendar.getInstance();
                        metaInfoDate.setTime(value);
                        ((PlanningNotificationDateMetaInformation)meta).setValue(metaInfoDate);
                    }
                } else if (metaDTO instanceof PlanningNotificationTextMetaInformationDTO) {
                    if (((PlanningNotificationTextMetaInformationDTO)metaDTO).getValue().isEmpty()) continue;
                    meta = new PlanningNotificationTextMetaInformation();
                    ((PlanningNotificationTextMetaInformation)meta).setValue(((PlanningNotificationTextMetaInformationDTO)metaDTO).getValue());
                } else if (metaDTO instanceof PlanningNotificationDateMetaInformationDTO) {
                    if (((PlanningNotificationDateMetaInformationDTO)metaDTO).getValue() == null) continue;
                    meta = new PlanningNotificationDateMetaInformation();
                    value = ((PlanningNotificationDateMetaInformationDTO)metaDTO).getValue();
                    metaInfoDate = Calendar.getInstance();
                    metaInfoDate.setTime(value);
                    ((PlanningNotificationDateMetaInformation)meta).setValue(metaInfoDate);
                }
                ((PlanningNotificationMetaInformation)meta).setPlanningNotification(planningNotification);
                MetaTag metaTag = null;
                if (metaDTO.getPlanningNotificationMetaTag().getId() == null) {
                    metaTag = new MetaTag();
                    metaTag.setName(metaDTO.getPlanningNotificationMetaTag().getName());
                    metaTag = this.metaTagDAO.save(metaTag);
                } else {
                    metaTag = this.metaTagDAO.get(metaDTO.getPlanningNotificationMetaTag().getId());
                }
                meta.setMetaTag(metaTag);
                meta = metaDTO.getId() == null ? this.metaInformationDAO.save(meta) : this.metaInformationDAO.update(meta);
                planningNotification.getPlanningNotificationMetaInformations().put(meta.getId(), (PlanningNotificationMetaInformation)meta);
            }
        }
        planningNotification = this.planningNotificationDAO.update(planningNotification);
        return CdesDTOHelper.getPlanningNotificationDTO(planningNotification, false);
    }

    @Override
    public void deletePlanningNotification(Integer planningNotificationId) {
        PlanningNotification planningNotification = this.planningNotificationDAO.get(planningNotificationId);
        ArrayList<PlanningNotificationOrder> orders = new ArrayList<PlanningNotificationOrder>(planningNotification.getPlanningNotificationOrders().values());
        for (PlanningNotificationOrder order : orders) {
            this.deletePlanningNotificationOrder(order.getId());
            planningNotification.getPlanningNotificationOrders().remove(order.getId());
        }
        ArrayList<PlanningNotificationMetaInformation> PNMetaInfos = new ArrayList<PlanningNotificationMetaInformation>(planningNotification.getPlanningNotificationMetaInformations().values());
        for (PlanningNotificationMetaInformation PNMetaInfo : PNMetaInfos) {
            PNMetaInfo.getId();
            MetaInformation metaInfo = this.metaInformationDAO.get(PNMetaInfo.getId());
            this.metaInformationDAO.delete(metaInfo);
            planningNotification.getPlanningNotificationMetaInformations().remove(metaInfo.getId());
        }
        if ((planningNotification = this.planningNotificationDAO.update(planningNotification)).getType() != 1) {
            this.deletePlanningNotificationFile(planningNotificationId);
        }
        this.planningNotificationDAO.delete(planningNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BBoxWithPage> getPlanningNotificationPageBBoxes(Integer planningNotificationId, String domain, String username, String password) throws FileHandleException, PreviewException {
        PlanningNotification planningNotification = this.planningNotificationDAO.get(planningNotificationId);
        FileMimeInputStream stream = null;
        File file = null;
        String unique = null;
        if (planningNotification.getType() == 1) {
            SharepointFileClient client = new SharepointFileClient();
            client.initialize(domain, username, password);
            InputStream is = client.getFile(planningNotification.getPath());
            OutputStream os = null;
            try {
                file = this.fileFinder.buildFile(planningNotification.getFilename(), CDESFileRepository.TEMPREPOSITORY);
                unique = this.fileFinder.makeUniqueName(planningNotification.getFilename(), CDESFileRepository.TEMPREPOSITORY);
                os = FileUtils.openOutputStream((File)file);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = is.read(bytes)) != -1) {
                    os.write(bytes, 0, read);
                }
                is.close();
                os.flush();
                os.close();
            }
            catch (FileNotFoundException e) {
                log.error((Object)("File '" + planningNotification.getFilename() + "' not found."), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error while operation on file '" + planningNotification.getFilename() + "'."), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Could not close streams.", (Throwable)e);
                }
            }
        } else {
            file = this.fileFinder.findFile(planningNotification.getPath(), CDESFileRepository.PLANNINGNOTIFICATIONREPOSITORY);
            unique = this.fileFinder.makeUniqueName(planningNotification.getPath(), CDESFileRepository.PLANNINGNOTIFICATIONREPOSITORY);
        }
        stream = new FileMimeInputStream(file, unique, planningNotification.getFilename(), DefaultHttpContext.getInstance().getMimeType(planningNotification.getPath()));
        List r = new ArrayList();
        try {
            r = this.hpglRenderer.getPageBoundingBoxes((IMimeInputStream)stream);
        }
        catch (PreviewException e) {
            log.error((Object)"hpglRenderer.getPageBoundingBoxes throws PreviewException.", (Throwable)e);
            throw new PreviewException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"hpglRenderer.getPageBoundingBoxes throws exception.", (Throwable)e);
        }
        ArrayList<BBoxWithPage> ret = new ArrayList<BBoxWithPage>(r.size());
        for (int i = 0; i < r.size(); ++i) {
            BoundingBoxWithAngle bb = (BoundingBoxWithAngle)r.get(i);
            BBoxWithPage bbox = new BBoxWithPage();
            bbox.setIpage(i);
            bbox.setLlx(bb.getLlx());
            bbox.setLly(bb.getLly());
            bbox.setUrx(bb.getUrx());
            bbox.setUry(bb.getUry());
            ret.add(bbox);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String extractPlanningNotificationText(Integer planningNotificationId, BBoxWithPage bbox) throws FileHandleException, IOException {
        PlanningNotificationDTO planningNotification = this.getPlanningNotificationDTO(planningNotificationId);
        File file = null;
        file = planningNotification.getType() == PlanningNotificationDTO.TYPE_REFERENCED ? this.fileFinder.findFile(planningNotification.getFilename(), CDESFileRepository.TEMPREPOSITORY) : this.fileFinder.findFile(planningNotification.getPath(), CDESFileRepository.PLANNINGNOTIFICATIONREPOSITORY);
        try (PDDocument doc = PDDocument.load((File)file);){
            PDPage page = (PDPage)doc.getPrintable(bbox.getIpage());
            PDFTextStripperByArea stripper = new PDFTextStripperByArea();
            stripper.setLineSeparator("\n");
            stripper.setParagraphEnd("\n");
            Rectangle2D.Double rect = new Rectangle2D.Double(bbox.getLlx(), (double)page.getMediaBox().getUpperRightY() - bbox.getUry(), bbox.getUrx() - bbox.getLlx(), bbox.getUry() - bbox.getLly());
            stripper.addRegion("default", (Rectangle2D)rect);
            stripper.extractRegions(page);
            String string = stripper.getTextForRegion("default");
            return string;
        }
    }

    @Override
    public List<PlanningNotificationOrderDTO> getPlanningNotificationOrdersByFilter(OrderFilterDTO filter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting getPlanningNotificationOrdersByFilter");
        }
        ArrayList<PlanningNotificationOrderDTO> dtoList = new ArrayList<PlanningNotificationOrderDTO>();
        List<PlanningNotificationOrder> orders = this.workflowEntityDAO.getPlanningNotificationOrders(filter);
        if (log.isDebugEnabled()) {
            log.debug((Object)("loaded [" + orders.size() + "] orders"));
        }
        long initializedMillis = 0L;
        long workflowNodeLoopMillis = 0L;
        long dtoMillis = 0L;
        if (orders.size() < 20) {
            for (PlanningNotificationOrder order : orders) {
                long prevMillis = System.currentTimeMillis();
                order.getWorkflow().setInitialized(this.workflowTokenDAO.isWorkflowInitialized(order.getWorkflow().getId()));
                initializedMillis += System.currentTimeMillis() - prevMillis;
                prevMillis = System.currentTimeMillis();
                for (WorkflowNode workflowNode : order.getWorkflow().getWorkflowNodes().values()) {
                    Iterator<WorkflowNodePosition> iterator = workflowNode.getWorkflowNodePositions().values().iterator();
                    while (iterator.hasNext()) {
                        WorkflowNodePosition workflowNodePosition;
                        List<WorkflowToken> positionsTokens = this.workflowTokenDAO.getAllTokensByOwnerPosition((workflowNodePosition = iterator.next()).getId());
                        workflowNodePosition.setHasOwnerToken(!positionsTokens.isEmpty());
                    }
                }
                workflowNodeLoopMillis += System.currentTimeMillis() - prevMillis;
                prevMillis = System.currentTimeMillis();
                dtoList.add(CdesDTOHelper.getPlanningNotificationOrderDTO(order, CdesDTOHelper.getPlanningNotificationDTO(order.getPlanningNotification(), true), CdesDTOHelper.getWorkflowDTO(order.getWorkflow())));
                dtoMillis += System.currentTimeMillis() - prevMillis;
                prevMillis = System.currentTimeMillis();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("InitializedMillis = [" + initializedMillis + "]"));
                log.debug((Object)("workflowNodeLoopMillis = [" + workflowNodeLoopMillis + "]"));
                log.debug((Object)("dtoMillis = [" + dtoMillis + "]"));
            }
            return dtoList;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"About to pre-fetch using getAll");
        }
        List<Workflow> workflows = this.workflowDAO.getAll();
        List<WorkflowNode> workflowNodes = this.workflowNodeDAO.getAll();
        List<WorkflowNodePosition> workflowNodePositions = this.workflowNodePositionDAO.getAll();
        List<WorkflowToken> workflowTokens = this.workflowTokenDAO.getAll();
        List<PlanningNotificationOrder> planningNotificationOrders = this.planningNotificationDAO.getAllOrders();
        List<WorkflowNodeTemplate> workflowNodeTemplates = this.workflowNodeTemplateDAO.getAll();
        HashMap<Integer, List<WorkflowNode>> workflowIdToWorkflowNodes = new HashMap<Integer, List<WorkflowNode>>();
        HashMap<Integer, WorkflowNodeTemplate> workflowNodeToTemplate = new HashMap<Integer, WorkflowNodeTemplate>();
        for (WorkflowNode workflowNode : workflowNodes) {
            Integer workflowId = workflowNode.getWorkflow().getId();
            if (!workflowIdToWorkflowNodes.containsKey(workflowId)) {
                workflowIdToWorkflowNodes.put(workflowId, new ArrayList());
            }
            ((List)workflowIdToWorkflowNodes.get(workflowId)).add(workflowNode);
            workflowNodeToTemplate.put(workflowNode.getId(), workflowNode.getWorkflowNodeTemplate());
        }
        HashMap<Integer, List<WorkflowNodePosition>> workflowNodeIdToWorkflowNodePositions = new HashMap<Integer, List<WorkflowNodePosition>>();
        for (WorkflowNodePosition workflowNodePosition : workflowNodePositions) {
            Integer workflowNodeId = workflowNodePosition.getWorkflowNode().getId();
            if (!workflowNodeIdToWorkflowNodePositions.containsKey(workflowNodeId)) {
                workflowNodeIdToWorkflowNodePositions.put(workflowNodeId, new ArrayList());
            }
            ((List)workflowNodeIdToWorkflowNodePositions.get(workflowNodeId)).add(workflowNodePosition);
        }
        HashMap hashMap = new HashMap();
        for (WorkflowToken workflowToken : workflowTokens) {
            Integer workflowNodePositionId = workflowToken.getOwner().getId();
            if (!hashMap.containsKey(workflowNodePositionId)) {
                hashMap.put(workflowNodePositionId, new ArrayList());
            }
            ((List)hashMap.get(workflowNodePositionId)).add(workflowToken);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Finished pre-fetching using getAll");
        }
        for (PlanningNotificationOrder order : orders) {
            long prevMillis = System.currentTimeMillis();
            boolean initialized = false;
            Integer workflowId = order.getWorkflow().getId();
            if (workflowIdToWorkflowNodes.containsKey(workflowId)) {
                for (WorkflowNode workflowNode : (List)workflowIdToWorkflowNodes.get(workflowId)) {
                    if (!workflowNodeIdToWorkflowNodePositions.containsKey(workflowNode.getId())) continue;
                    for (WorkflowNodePosition workflowNodePosition : (List)workflowNodeIdToWorkflowNodePositions.get(workflowNode.getId())) {
                        initialized |= hashMap.containsKey(workflowNodePosition.getId());
                    }
                }
            }
            order.getWorkflow().setInitialized(initialized);
            initializedMillis += System.currentTimeMillis() - prevMillis;
            prevMillis = System.currentTimeMillis();
            if (workflowIdToWorkflowNodes.containsKey(workflowId)) {
                for (WorkflowNode workflowNode : (List)workflowIdToWorkflowNodes.get(workflowId)) {
                    if (!workflowNodeIdToWorkflowNodePositions.containsKey(workflowNode.getId())) continue;
                    for (WorkflowNodePosition workflowNodePosition : (List)workflowNodeIdToWorkflowNodePositions.get(workflowNode.getId())) {
                        workflowNodePosition.setHasOwnerToken(hashMap.containsKey(workflowNodePosition.getId()));
                    }
                }
            }
            workflowNodeLoopMillis += System.currentTimeMillis() - prevMillis;
            prevMillis = System.currentTimeMillis();
            dtoList.add(CdesDTOHelper.getPlanningNotificationOrderDTO(order, CdesDTOHelper.getPlanningNotificationDTO(order.getPlanningNotification(), true), CdesDTOHelper.getWorkflowDTO(order.getWorkflow(), workflowNodeToTemplate, workflowIdToWorkflowNodes, workflowNodeIdToWorkflowNodePositions)));
            dtoMillis += System.currentTimeMillis() - prevMillis;
            prevMillis = System.currentTimeMillis();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("InitializedMillis = [" + initializedMillis + "]"));
            log.debug((Object)("workflowNodeLoopMillis = [" + workflowNodeLoopMillis + "]"));
            log.debug((Object)("dtoMillis = [" + dtoMillis + "]"));
        }
        return dtoList;
    }

    @Override
    public PlanningNotificationOrderDTO getPlanningNotificationOrder(Integer planningNotificationOrderId) {
        PlanningNotificationOrder order = this.workflowEntityDAO.getPlanningNotificationOrder(planningNotificationOrderId);
        PlanningNotificationOrderDTO planningNotificationOrderDTO = CdesDTOHelper.getPlanningNotificationOrderDTO(order, CdesDTOHelper.getPlanningNotificationDTO(order.getPlanningNotification(), true), CdesDTOHelper.getWorkflowDTO(order.getWorkflow()));
        return planningNotificationOrderDTO;
    }

    @Override
    public WorkflowTemplate getWorkflowTemplateForPlanningNotification(PlanningNotification planningNotification) {
        List<WorkflowTemplate> allTemplates = this.workflowTemplateDAO.getAll();
        if (allTemplates == null) {
            return null;
        }
        return allTemplates.get(0);
    }

    @Override
    public PlanningNotificationOrderDTO saveOrUpdatePlanningNotificationOrder(PlanningNotificationOrderDTO planningNotificationOrderDTO, Integer planningNotificationId, Long prevSerialNumber, Integer networkId) throws MissingPropertyException {
        if (planningNotificationOrderDTO.getPlanningNotification() == null || planningNotificationOrderDTO.getPlanningNotification().getId() == null) {
            throw new MissingPropertyException(PlanningNotificationDTO.class.getName());
        }
        List statutoryDuties = this.gwtDelegateService.getStatutoryDutiesByNetworkId(networkId);
        Long statutoryDutyTrueId = null;
        Long statutoryDutyFalseId = null;
        for (StatutoryDuty statutoryDuty : statutoryDuties) {
            if ((networkId != null || statutoryDuty.getNetworkId() != null) && (networkId == null || statutoryDuty.getNetworkId() == null || networkId.intValue() != statutoryDuty.getNetworkId().intValue())) continue;
            if ("Dauerhafte Rechtspflicht".equals(statutoryDuty.getName())) {
                statutoryDutyTrueId = statutoryDuty.getId();
                continue;
            }
            if (!"Keine Rechtspflicht".equals(statutoryDuty.getName())) continue;
            statutoryDutyFalseId = statutoryDuty.getId();
        }
        PlanningNotificationOrder order = null;
        if (planningNotificationOrderDTO.getId() != null) {
            order = this.workflowEntityDAO.getPlanningNotificationOrder(planningNotificationOrderDTO.getId());
            order.setSerialNumber(planningNotificationOrderDTO.getSerialNumber());
        } else {
            order = new PlanningNotificationOrder();
            order.setCreated(Calendar.getInstance().getTime());
            Long serialNumber = this.getNextSerialNumberWithStart(planningNotificationId, prevSerialNumber);
            order.setSerialNumber(serialNumber);
        }
        order.setText(planningNotificationOrderDTO.getText());
        order.setPlanningNotification(this.planningNotificationDAO.get(planningNotificationOrderDTO.getPlanningNotification().getId()));
        order.setAuthorizedInspector(planningNotificationOrderDTO.getAuthorizedInspector());
        order.setChanged(Calendar.getInstance().getTime());
        order.setComment(planningNotificationOrderDTO.getComment());
        order.setDocumentPosition(planningNotificationOrderDTO.getDocumentPosition());
        order.setStatutoryDutyId(planningNotificationOrderDTO.getStatutoryDutyId() != null ? Integer.valueOf(planningNotificationOrderDTO.getStatutoryDutyId().intValue()) : null);
        order.setDocumentOccurances(planningNotificationOrderDTO.getDocumentOccurances());
        order.setDocumentPage(planningNotificationOrderDTO.getDocumentPage());
        order.setSource(planningNotificationOrderDTO.getSource());
        order.setSubmitAuthority(planningNotificationOrderDTO.getSubmitAuthority());
        order.setInvalidated(planningNotificationOrderDTO.getInvalidated());
        order.setStatutoryDutyFrom(planningNotificationOrderDTO.getStatutoryDutyFrom());
        order.setStatutoryDutyTo(planningNotificationOrderDTO.getStatutoryDutyTo());
        order.setStatutoryDutyInterval(planningNotificationOrderDTO.getStatutoryDutyInterval());
        order.setStatutoryDutyLeadTime(planningNotificationOrderDTO.getStatutoryDutyLeadTime());
        order.setStatutoryDutyExpired(planningNotificationOrderDTO.getStatutoryDutyExpired());
        order.setSubjectAreaId(planningNotificationOrderDTO.getSubjectAreaId() != null ? new Integer(planningNotificationOrderDTO.getSubjectAreaId().intValue()) : null);
        order.setPersonInChargeId(planningNotificationOrderDTO.getPersonInChargeId() != null ? new Integer(planningNotificationOrderDTO.getPersonInChargeId().intValue()) : null);
        if (order.getId() == null || order.getWorkflow() == null) {
            WorkflowTemplate workflowTemplate = this.getWorkflowTemplateForPlanningNotification(order.getPlanningNotification());
            order = this.savePlanningNotificationOrderAndCreateWorfklow(order, workflowTemplate);
        } else {
            order = this.workflowEntityDAO.updatePlanningNotificationOrder(order);
        }
        return CdesDTOHelper.getPlanningNotificationOrderDTO(order, CdesDTOHelper.getPlanningNotificationDTO(order.getPlanningNotification(), true), CdesDTOHelper.getWorkflowDTO(order.getWorkflow()));
    }

    @Override
    public Long getNextSerialNumber(Integer planningNotificationId) {
        return this.getNextSerialNumberWithStart(planningNotificationId, null);
    }

    private Long getNextSerialNumberWithStart(Integer planningNotificationId, Long start) {
        PlanningNotification planningNotification = this.planningNotificationDAO.get(planningNotificationId);
        Map<Integer, Project> projectIdToProject = planningNotification.getAssociatedProjects();
        Project someProject = projectIdToProject != null && projectIdToProject.size() > 0 ? projectIdToProject.values().iterator().next() : null;
        HashSet<Long> serialNumbers = new HashSet<Long>();
        if (someProject != null) {
            List<PlanningNotification> planningNotifications = this.planningNotificationDAO.getByNetworkAndProject(someProject.getNetwork().getId(), someProject.getId());
            for (PlanningNotification p : planningNotifications) {
                Map<Integer, PlanningNotificationOrder> planningNotificationOrders = p.getPlanningNotificationOrders();
                if (planningNotificationOrders == null) continue;
                for (PlanningNotificationOrder pp : planningNotificationOrders.values()) {
                    if (pp.getSerialNumber() == null) continue;
                    serialNumbers.add(pp.getSerialNumber());
                }
            }
        }
        Long n = (start == null ? 0L : start) + 1L;
        while (serialNumbers.contains(n)) {
            Long l = n;
            Long l2 = n = Long.valueOf(n + 1L);
        }
        return n;
    }

    @Override
    public void deletePlanningNotificationOrder(Integer planningNotificationOrderId) {
        WorkflowEntity workflowEntity = this.workflowEntityDAO.get(planningNotificationOrderId);
        List<WorkflowActivityPositionResult> workflowActivityPositionResults = this.workflowActivityDAO.getPositionResultsByWorkflow(workflowEntity.getWorkflow().getId());
        for (WorkflowActivityPositionResult workflowActivityPositionResult : workflowActivityPositionResults) {
            this.signatureDAO.delete(workflowActivityPositionResult.getSignature());
            ArrayList planningNotificationAttachments = new ArrayList(workflowActivityPositionResult.getPlanningNotificationAttachments().values());
            for (Object planningNotificationAttachment : planningNotificationAttachments) {
                this.attachmentOperations.deletePlanningNotificationAttachment(((PlanningNotificationAttachment)planningNotificationAttachment).getId());
            }
            this.workflowActivityDAO.delete(workflowActivityPositionResult);
        }
        ArrayList<WorkflowNode> workflowNodes = new ArrayList<WorkflowNode>(workflowEntity.getWorkflow().getWorkflowNodes().values());
        for (WorkflowNode workflowNode : workflowNodes) {
            ArrayList<WorkflowToken> workflowTokens = new ArrayList<WorkflowToken>(this.workflowTokenDAO.getAllTokensOwnedByWorkflowNode(workflowNode.getId()));
            for (WorkflowToken workflowToken : workflowTokens) {
                this.workflowTokenDAO.delete(workflowToken);
            }
            ArrayList<WorkflowNodePosition> workflowNodePositions = new ArrayList<WorkflowNodePosition>(workflowNode.getWorkflowNodePositions().values());
            for (WorkflowNodePosition workflowNodePosition : workflowNodePositions) {
                this.workflowNodePositionDAO.delete(workflowNodePosition);
                workflowNode.getWorkflowNodePositions().remove(workflowNodePosition.getId());
            }
            this.workflowNodeDAO.delete(workflowNode);
            workflowEntity.getWorkflow().getWorkflowNodes().remove(workflowNode.getId());
        }
        List<WorkflowActivity> list = this.workflowActivityDAO.getByWorkflow(workflowEntity.getWorkflow().getId());
        for (WorkflowActivity workflowActivity : list) {
            this.workflowActivityDAO.delete(workflowActivity);
        }
        this.workflowDAO.delete(workflowEntity.getWorkflow());
        this.workflowEntityDAO.delete(workflowEntity);
    }

    private PlanningNotificationOrder savePlanningNotificationOrderAndCreateWorfklow(PlanningNotificationOrder planningNotificationOrder, WorkflowTemplate workflowTemplate) {
        if (planningNotificationOrder.getId() == null) {
            planningNotificationOrder = this.workflowEntityDAO.savePlanningNotificationOrder(planningNotificationOrder);
        }
        Workflow workflow = new Workflow();
        workflow.setWorkflowTemplate(workflowTemplate);
        workflow.setWorkflowNodes(new HashMap<Integer, WorkflowNode>());
        workflow = this.workflowDAO.save(workflow);
        for (WorkflowNodeTemplate nodeTemplate : workflowTemplate.getWorkflowNodeTemplates().values()) {
            WorkflowNode node = new WorkflowNode();
            node.setWorkflow(workflow);
            node.setWorkflowNodeTemplate(nodeTemplate);
            node = this.workflowNodeDAO.save(node);
            workflow.getWorkflowNodes().put(node.getId(), node);
        }
        workflow = this.workflowDAO.update(workflow);
        planningNotificationOrder.setWorkflow(workflow);
        planningNotificationOrder = this.workflowEntityDAO.updatePlanningNotificationOrder(planningNotificationOrder);
        return planningNotificationOrder;
    }

    @Override
    public WorkflowDTO updateWorkflow(WorkflowDTO workflowDTO) {
        Workflow workflow = this.workflowDAO.get(workflowDTO.getId());
        for (WorkflowNodeDTO workflowNodeDTO : workflowDTO.getWorkflowNodes().values()) {
        }
        return CdesDTOHelper.getWorkflowDTO(this.workflowDAO.update(workflow));
    }

    @Override
    public boolean deleteWorkflowNodePosition(Integer workflowNodePositionId) {
        log.info((Object)("deleting nodePosition with id=[" + workflowNodePositionId + "]"));
        WorkflowNodePosition position = this.workflowNodePositionDAO.get(workflowNodePositionId);
        if (position == null) {
            return false;
        }
        if (this.workflowTokenDAO.isWorkflowInitialized(position.getWorkflowNode().getWorkflow().getId())) {
            WorkflowToken initiatorToken = this.workflowTokenDAO.getTokenByInitiatorPosition(workflowNodePositionId);
            if (initiatorToken != null && initiatorToken.getInitiator().getId().equals(workflowNodePositionId) && initiatorToken.getOwner().getId().equals(workflowNodePositionId)) {
                this.workflowTokenDAO.delete(initiatorToken);
                this.workflowNodePositionDAO.delete(position);
                if (!this.checkWorkflowHasTokens(position.getWorkflowNode().getWorkflow().getId())) {
                    this.resetWorkflowEntityStatus(position.getWorkflowNode().getWorkflow());
                }
                log.info((Object)("deleted nodePosition with id=[" + workflowNodePositionId + "] and token[id, initiatorPositionId, ownerPositionId]= " + initiatorToken.getId() + "," + initiatorToken.getInitiator().getId() + "," + initiatorToken.getOwner().getId()));
                return true;
            }
            if (initiatorToken != null && initiatorToken.getInitiator().getId().equals(workflowNodePositionId)) {
                return false;
            }
            return false;
        }
        this.workflowNodePositionDAO.delete(position);
        log.info((Object)("deleted nodePosition with id=[" + workflowNodePositionId + "]"));
        return true;
    }

    @Override
    public WorkflowNodePositionDTO insertOrUpdateWorklfowNodePositionWithMetaInformation(Integer workflowNodeId, Integer participationId, Integer metaInfoId, Date dueDate, Date optionalDueDate, String dueDateRemark) {
        WorkflowNode workflowNode = this.workflowNodeDAO.get(workflowNodeId);
        if (workflowNode.getWorkflowNodePositions() == null) {
            workflowNode.setWorkflowNodePositions(new HashMap<Integer, WorkflowNodePosition>());
        }
        WorkflowNodePosition nodePosition = new WorkflowNodePosition();
        nodePosition.setProjectParticipation(this.projectParticipationDAO.get(participationId));
        nodePosition.setWorkflowNode(workflowNode);
        MetaInformation metaInformation = null;
        if (metaInfoId != null) {
            metaInformation = this.metaInformationDAO.get(metaInfoId);
            if (nodePosition.getMetaInformations() == null) {
                nodePosition.setMetaInformations(new HashMap<Integer, MetaInformation>());
            }
            nodePosition.getMetaInformations().put(metaInformation.getId(), metaInformation);
        }
        if (dueDate != null) {
            nodePosition.setDueDate(dueDate);
        }
        if (dueDateRemark != null) {
            nodePosition.setDueDateRemark(dueDateRemark);
        }
        if (optionalDueDate != null) {
            nodePosition.setOptionalDueDate(optionalDueDate);
        }
        nodePosition = this.workflowNodePositionDAO.save(nodePosition);
        workflowNode.getWorkflowNodePositions().put(nodePosition.getId(), nodePosition);
        workflowNode = this.workflowNodeDAO.update(workflowNode);
        if (workflowNode.getWorkflowNodeTemplate().isStartNode() && this.checkWorkflowIsInitialized(workflowNode.getWorkflow().getId())) {
            this.addInitialToken(nodePosition);
            this.initializeWorkflowEntityStatus(workflowNode.getWorkflow());
        }
        return CdesDTOHelper.getWorkflowNodePositionDTO(nodePosition, CdesDTOHelper.getWorkflowNodeDTO(workflowNode, CdesDTOHelper.getWorkflowDTO(workflowNode.getWorkflow())));
    }

    @Override
    public WorkflowNodePositionDTO insertOrUpdateWorklfowNodePosition(Integer workflowNodeId, Integer participationId) {
        return this.insertOrUpdateWorklfowNodePositionWithMetaInformation(workflowNodeId, participationId, null, null, null, null);
    }

    @Override
    public List<WorkflowNodePositionDTO> saveOrUpdateWorklfowNodePositions(List<WorkflowNodePositionDTO> nodePositions) {
        if (nodePositions == null || nodePositions.isEmpty()) {
            return null;
        }
        WorkflowNode workflowNode = this.workflowNodeDAO.get(nodePositions.get(0).getWorkflowNode().getId());
        if (workflowNode.getWorkflowNodePositions() == null) {
            workflowNode.setWorkflowNodePositions(new HashMap<Integer, WorkflowNodePosition>());
        }
        if (nodePositions != null) {
            if (workflowNode.getWorkflowNodePositions() == null) {
                workflowNode.setWorkflowNodePositions(new HashMap<Integer, WorkflowNodePosition>());
            }
            for (WorkflowNodePositionDTO nodePositionDTO : nodePositions) {
                WorkflowActivity activity;
                WorkflowNodePosition nodePosition;
                boolean newlyAdded = false;
                boolean intermediateResultRequested = false;
                WorkflowToken token = null;
                if (nodePositionDTO.getId() != null) {
                    nodePosition = this.workflowNodePositionDAO.get(nodePositionDTO.getId());
                    nodePosition.setDueDate(nodePositionDTO.getDueDate() != null ? nodePositionDTO.getDueDate() : null);
                    nodePosition.setDueDateRemark(nodePositionDTO.getDueDateRemark() != null ? nodePositionDTO.getDueDateRemarkValue() : null);
                    List<WorkflowToken> positionsTokens = this.workflowTokenDAO.getAllTokensByOwnerPosition(nodePositionDTO.getId());
                    nodePosition.setHasOwnerToken(!positionsTokens.isEmpty());
                    if (nodePosition.isHasOwnerToken() && nodePositionDTO.getOptionalDueDate() != null) {
                        if (nodePosition.getOptionalDueDate() == null && nodePositionDTO.getOptionalDueDate() != null || nodePosition.getOptionalDueDate().after(nodePositionDTO.getOptionalDueDate()) || nodePosition.getOptionalDueDate().before(nodePositionDTO.getOptionalDueDate())) {
                            intermediateResultRequested = true;
                        }
                        token = (WorkflowToken)positionsTokens.get(0);
                    }
                    nodePosition.setOptionalDueDate(nodePositionDTO.getOptionalDueDate() != null ? nodePositionDTO.getOptionalDueDate() : null);
                    nodePosition = this.workflowNodePositionDAO.update(nodePosition);
                } else {
                    newlyAdded = true;
                    nodePosition = new WorkflowNodePosition();
                    nodePosition.setProjectParticipation(this.projectParticipationDAO.get(nodePositionDTO.getProjectParticipation().getId()));
                    nodePosition.setWorkflowNode(workflowNode);
                    if (nodePositionDTO.getMetaInfos() != null) {
                        for (PlanningNotificationMetaInformationDTO metaInfoDTO : nodePositionDTO.getMetaInfos().values()) {
                            if (metaInfoDTO.getId() == null) continue;
                            MetaInformation metaInformation = this.metaInformationDAO.get(metaInfoDTO.getId());
                            if (nodePosition.getMetaInformations() == null) {
                                nodePosition.setMetaInformations(new HashMap<Integer, MetaInformation>());
                            }
                            nodePosition.getMetaInformations().put(metaInformation.getId(), metaInformation);
                        }
                    }
                    nodePosition.setDueDate(nodePositionDTO.getDueDate() != null ? nodePositionDTO.getDueDate() : null);
                    nodePosition.setDueDateRemark(nodePositionDTO.getDueDateRemark() != null ? nodePositionDTO.getDueDateRemarkValue() : null);
                    nodePosition.setOptionalDueDate(nodePositionDTO.getOptionalDueDate() != null ? nodePositionDTO.getOptionalDueDate() : null);
                    nodePosition = this.workflowNodePositionDAO.save(nodePosition);
                }
                workflowNode.getWorkflowNodePositions().put(nodePosition.getId(), nodePosition);
                if (newlyAdded && workflowNode.getWorkflowNodeTemplate().isStartNode() && this.checkWorkflowIsInitialized(workflowNode.getWorkflow().getId())) {
                    token = this.addInitialToken(nodePosition);
                    activity = this.recordTokenCreation(token);
                    this.createWorkflowActivityNotificationSnippets(activity, token.getWorkflowEntity());
                    this.initializeWorkflowEntityStatus(workflowNode.getWorkflow());
                    continue;
                }
                if (!intermediateResultRequested || token == null) continue;
                activity = this.recordIntermediateResultRequested(token);
                this.createWorkflowActivityNotificationSnippets(activity, token.getWorkflowEntity());
            }
            workflowNode = this.workflowNodeDAO.update(workflowNode);
        }
        workflowNode.getWorkflow().setInitialized(this.workflowTokenDAO.isWorkflowInitialized(workflowNode.getWorkflow().getId()));
        Iterator<Serializable> iterator = workflowNode.getWorkflowNodePositions().values().iterator();
        while (iterator.hasNext()) {
            WorkflowNodePosition workflowNodePosition;
            List<WorkflowToken> positionsTokens = this.workflowTokenDAO.getAllTokensByOwnerPosition((workflowNodePosition = (WorkflowNodePosition)iterator.next()).getId());
            workflowNodePosition.setHasOwnerToken(!positionsTokens.isEmpty());
        }
        return new ArrayList<WorkflowNodePositionDTO>(CdesDTOHelper.getWorkflowNodeDTO(workflowNode, CdesDTOHelper.getWorkflowDTO(workflowNode.getWorkflow())).getWorkflowNodePositions().values());
    }

    @Override
    public void deletePlanningNotificationFile(Integer id) {
        PlanningNotification p = null;
        if (id != null && (p = this.planningNotificationDAO.get(id)) != null) {
            try {
                this.uploadFileHandler.deletePlanningNotificationFile(p.getPath());
            }
            catch (FileHandleException e) {
                e.printStackTrace();
            }
            p.setFilename(null);
            p.setPath(null);
            this.planningNotificationDAO.update(p);
        }
    }

    @Override
    public boolean checkWorkflowIsInitialized(Integer workflowId) {
        return this.workflowTokenDAO.isWorkflowInitialized(workflowId);
    }

    @Override
    public void initializeWorkflow(Integer workflowId) throws WorkflowException {
        WorkflowNode startNode;
        if (this.checkWorkflowIsInitialized(workflowId)) {
            return;
        }
        Workflow workflow = this.workflowDAO.getWithNodes(workflowId);
        if (workflow.getWorkflowNodes() != null) {
            startNode = workflow.getStartNode();
            if (startNode == null) {
                throw new WorkflowException("Missing declaration of start node in workflow.");
            }
            if (startNode.getWorkflowNodePositions() == null || startNode.getWorkflowNodePositions().isEmpty()) {
                throw new WorkflowException("Workflow node '" + startNode.getWorkflowNodeTemplate().getName() + "' must at least have one position.");
            }
            WorkflowNode endNode = this.getWorkflowNodeAtPosition(workflow, 3);
            if (endNode.getWorkflowNodePositions() == null || endNode.getWorkflowNodePositions().isEmpty()) {
                throw new WorkflowException("Workflow node '" + endNode.getWorkflowNodeTemplate().getName() + "' must at least have one position.");
            }
            for (WorkflowNodePosition position : startNode.getWorkflowNodePositions().values()) {
                List<WorkflowActivityPositionResult> initiatorPositionResults = this.workflowActivityDAO.getPositionResultsByInitiator(position.getId());
                if (!initiatorPositionResults.isEmpty()) continue;
                this.addInitialToken(position);
            }
        } else {
            throw new WorkflowException("Workflow has no nodes.");
        }
        WorkflowActivity activity = this.recordWorkflowInitialization(startNode);
        this.createWorkflowActivityNotificationSnippets(activity, workflow.getWorkflowEntities().values().iterator().next());
        this.initializeWorkflowEntityStatus(workflow);
    }

    private WorkflowToken addInitialToken(WorkflowNodePosition position) {
        WorkflowToken token = new WorkflowToken();
        token.setInitiator(position);
        token.setOwner(position);
        token = this.workflowTokenDAO.save(token);
        return token;
    }

    private void initializeWorkflowEntityStatus(Workflow workflow) {
        WorkflowEntityStatus initialStatus = this.workflowEntityStatusDAO.getInitialEntityStatus();
        for (WorkflowEntity entity : workflow.getWorkflowEntities().values()) {
            entity.setStatus(initialStatus);
            this.workflowEntityDAO.update(entity);
        }
    }

    private void resetWorkflowEntityStatus(Workflow workflow) {
        for (WorkflowEntity entity : workflow.getWorkflowEntities().values()) {
            entity.setStatus(null);
            this.workflowEntityDAO.update(entity);
        }
    }

    @Override
    public void savePlanningNotificationAttachments(WorkflowReviewContainerDTO workflowContainer, IMimeInputStream stream, String originalFileName, WorkflowActivityPositionResultDTO positionResultDTO) {
        ProjectParticipant signer = null;
        if (workflowContainer != null) {
            signer = this.projectParticipantDAO.get(workflowContainer.getSignerParticipantDTO().getId());
        }
        PlanningNotificationAttachment pna = null;
        WorkflowActivityPositionResult positionResult = (WorkflowActivityPositionResult)this.workflowActivityDAO.get(positionResultDTO.getId());
        if (signer != null && stream != null && (pna = this.attachmentOperations.savePlanningNotificationAttachment(signer.getParticipation().getProject().getNetwork().getId(), positionResult, stream, originalFileName)) != null) {
            if (positionResult.getPlanningNotificationAttachments() == null) {
                positionResult.setPlanningNotificationAttachments(new HashMap());
            }
            positionResult.getPlanningNotificationAttachments().put(pna.getId(), pna);
            this.workflowActivityDAO.update(positionResult);
        }
    }

    @Override
    public WorkflowActivityPositionResultDTO signWorkflowNodePositionResult(WorkflowReviewContainerDTO reviewContainer) throws WorkflowException, WrongPasswordException, FileUploadException {
        ProjectParticipant signer = this.projectParticipantDAO.get(reviewContainer.getSignerParticipantDTO().getId());
        CDESCertificate cert = this.certificateOperations.getSignerCertificate(signer.getOrganisationPerson().getId(), false);
        WorkflowActivityPositionResult result = null;
        List<WorkflowActivityPositionResultDTO> positionResultDTOs = reviewContainer.getPositionResultDTOs();
        for (WorkflowActivityPositionResultDTO positionResultDTO : positionResultDTOs) {
            DigestCalculator dig;
            result = new WorkflowActivityPositionResult();
            WorkflowToken token = this.workflowTokenDAO.get(positionResultDTO.getWorkflowTokenId());
            WorkflowNodePositionResultOption resultOption = this.workflowNodePositionResultOptionDAO.get(positionResultDTO.getWorkflowNodePositionResultOptionId());
            WorkflowNode activeNode = token.getOwner().getWorkflowNode();
            WorkflowEntity workflowEntity = this.workflowEntityDAO.getPlanningNotificationOrder(reviewContainer.getWorkflowEntityId());
            OrganisationPerson initiator = token.getInitiator().getProjectParticipation().getMainParticipant().getOrganisationPerson();
            OrganisationPerson owner = token.getOwner().getProjectParticipation().getMainParticipant().getOrganisationPerson();
            OrganisationPerson reviewer = signer.getOrganisationPerson();
            I18n i18n = I18nFactory.getI18n(new Locale(reviewer.getPerson().getPersonVariables(false).getUserLocale()));
            result.setTokenInitiatorObj(token.getInitiator());
            ArrayList<MetaInformation> metaInfos = new ArrayList<MetaInformation>(token.getInitiator().getMetaInformations().values());
            for (MetaInformation metaInfo : metaInfos) {
                if (!metaInfo.getMetaTag().getName().equals("Baulos")) continue;
                if (result.getMetaInformations() == null) {
                    result.setMetaInformations(new HashMap());
                }
                result.getMetaInformations().put(result.getId(), metaInfo);
            }
            result.setEntityStatus(workflowEntity.getStatus().getName());
            result.setWorkflow(token.getOwner().getWorkflowNode().getWorkflow());
            String comment = this.CleanHTMLComments(positionResultDTO.getComment());
            result.setComment(comment);
            result.setResult(resultOption.getTitle());
            result.setIssued(Calendar.getInstance().getTime());
            result.setReviewer(positionResultDTO.getReviewer());
            result.setTokenInitiator(initiator.getOrganisation().getName() + " (" + initiator.getPerson().getInverseCommonName() + ")");
            result.setTokenOwner(owner.getOrganisation().getName() + " (" + owner.getPerson().getInverseCommonName() + ")");
            result.setWorkflowNodeName(activeNode.getWorkflowNodeTemplate().getName());
            result.setDescription("<b>" + i18n.tr("Zeichnung") + ":</b><br/><small><b>" + i18n.tr("Zeichnungsverantwortlicher") + ":</b> " + result.getReviewer() + "<br/><b>" + i18n.tr("Knoten") + ":</b> " + result.getWorkflowNodeName() + "</small><br/><b>" + i18n.tr("Ergebnis") + ":</b> " + result.getResult() + "</small>");
            try {
                dig = this.digestCalculatorFactory.getDigestCalculator(signer.getParticipation().getProject().getNetwork(), result);
                result.setDigestCalculatorType(this.digestCalculatorDAO.get(dig.getClass().getName()));
                result.setDigest(dig.getDigest(result));
                result = (WorkflowActivityPositionResult)this.workflowActivityDAO.save(result);
                this.createWorkflowActivityNotificationSnippets((WorkflowActivity)result, token.getWorkflowEntity());
            }
            catch (DigestCalculatorException e) {
                throw new ActionException("Saving workflowActivity failed", e);
            }
            Object fis = null;
            Object path = null;
            try {
                SignatureCalculator sig = this.signatureCalculatorFactory.getSignatureCalculator(signer.getParticipation().getProject().getNetwork(), result);
                CDESSignature sign = sig.createSignature(signer, dig.getSignableContent(result), cert, reviewContainer.getSignaturePassword());
                sign = this.signatureDAO.save(sign);
                result.setSignature(sign);
                result = (WorkflowActivityPositionResult)this.workflowActivityDAO.update(result);
            }
            catch (SignatureCalculatorException e) {
                throw new ActionException("DocumentVersion invalidation failed", e);
            }
            catch (DigestCalculatorException e) {
                throw new ActionException("DocumentVersion invalidation failed", e);
            }
            for (WorkflowAction action : resultOption.getWorkflowActions().values()) {
                if (action instanceof WorkflowActionTokenTransition) {
                    token = this.doTokenTransition((WorkflowActionTokenTransition)action, token, i18n, signer);
                    continue;
                }
                if (action instanceof WorkflowActionTokenDeletion) {
                    this.doDeleteToken((WorkflowActionTokenDeletion)action, token, i18n);
                    break;
                }
                if (action instanceof WorkflowActionEntityStatusChange) {
                    workflowEntity = this.doEntityStatusChange((WorkflowActionEntityStatusChange)action, workflowEntity, activeNode, i18n);
                    continue;
                }
                if (!(action instanceof WorkflowActionTokenEmailNotification)) continue;
            }
            result.setEntityStatus(workflowEntity.getStatus().getName());
            result = (WorkflowActivityPositionResult)this.workflowActivityDAO.update(result);
            ArrayList<WorkflowActionNodeEmailNotification> nodeEmailNotificationActions = new ArrayList<WorkflowActionNodeEmailNotification>();
            for (WorkflowActionListener actionListener : activeNode.getWorkflowNodeTemplate().getWorkflowActionListeners().values()) {
                boolean preconditionsSatisfied = true;
                for (WorkflowActionPrecondition precondition : actionListener.getWorkflowActionPreconditions().values()) {
                    if (this.isWorkflowActionPreconditionSatisfied(precondition, workflowEntity, activeNode)) continue;
                    preconditionsSatisfied = false;
                    break;
                }
                if (!preconditionsSatisfied) continue;
                for (WorkflowAction action : actionListener.getWorkflowActions().values()) {
                    if (action instanceof WorkflowActionEntityStatusChange) {
                        workflowEntity = this.doEntityStatusChange((WorkflowActionEntityStatusChange)action, workflowEntity, activeNode, i18n);
                    }
                    if (!(action instanceof WorkflowActionNodeEmailNotification)) continue;
                    nodeEmailNotificationActions.add((WorkflowActionNodeEmailNotification)action);
                }
            }
        }
        return CdesDTOHelper.getWorkflowActivityPositionResultDTO(result);
    }

    private boolean isWorkflowActionPreconditionSatisfied(WorkflowActionPrecondition precondition, WorkflowEntity workflowEntity, WorkflowNode activeNode) {
        if (precondition.getType() == 0) {
            return workflowEntity.getStatus().getId().equals(precondition.getTargetWorkflowEntityStatus().getId());
        }
        if (precondition.getType() == 1) {
            for (WorkflowNode node : workflowEntity.getWorkflow().getWorkflowNodes().values()) {
                if (!node.getWorkflowNodeTemplate().getId().equals(precondition.getTargetWorkflowNodeTemplate().getId())) continue;
                return this.workflowTokenDAO.getAllTokensOwnedByWorkflowNode(node.getId()).isEmpty();
            }
            return false;
        }
        return false;
    }

    private void doDeleteToken(WorkflowActionTokenDeletion action, WorkflowToken token, I18n i18n) {
        WorkflowActivity workflowActivity = this.recordTokenDeletion(i18n, action, token);
        this.createWorkflowActivityNotificationSnippets(workflowActivity, token.getWorkflowEntity());
        this.workflowTokenDAO.delete(token);
    }

    private WorkflowToken doTokenTransition(WorkflowActionTokenTransition action, WorkflowToken token, I18n i18n, ProjectParticipant signer) throws WorkflowException {
        WorkflowNodePosition previousOwner = token.getOwner();
        if (action.isOnlyToTokenInitiator()) {
            token.setOwner(token.getInitiator());
        } else {
            Workflow workflow = token.getInitiator().getWorkflowNode().getWorkflow();
            WorkflowNode nextWorkflowNode = null;
            for (WorkflowNode workflowNode : workflow.getWorkflowNodes().values()) {
                if (!workflowNode.getWorkflowNodeTemplate().getId().equals(action.getTargetNode().getId())) continue;
                if (workflowNode.getWorkflowNodePositions() == null || workflowNode.getWorkflowNodePositions().isEmpty()) {
                    nextWorkflowNode = this.getWorkflowNodeAtPosition(workflow, workflowNode.getWorkflowNodeTemplate().getPosition() + 1);
                    if (nextWorkflowNode != null) break;
                    throw new WorkflowException("Workflow node '" + nextWorkflowNode.getWorkflowNodeTemplate().getName() + "' does not have a successor!");
                }
                nextWorkflowNode = workflowNode;
                break;
            }
            if (nextWorkflowNode.getWorkflowNodePositions() == null || nextWorkflowNode.getWorkflowNodePositions().size() != 1) {
                throw new WorkflowException("Could not move token to node " + nextWorkflowNode.getWorkflowNodeTemplate().getName() + ", number of positions is not 1.");
            }
            token.setOwner(nextWorkflowNode.getWorkflowNodePositions().values().iterator().next());
        }
        WorkflowActivity activity = this.recordTokenTransition(i18n, previousOwner, token.getOwner(), token.getInitiator(), signer);
        this.createWorkflowActivityNotificationSnippets(activity, token.getWorkflowEntity());
        token = this.workflowTokenDAO.update(token);
        return token;
    }

    private WorkflowNode getWorkflowNodeAtPosition(Workflow workflow, int nodePosition) {
        for (WorkflowNode node : workflow.getWorkflowNodes().values()) {
            if (node.getWorkflowNodeTemplate().getPosition() != nodePosition) continue;
            return node;
        }
        return null;
    }

    private WorkflowEntity doEntityStatusChange(WorkflowActionEntityStatusChange action, WorkflowEntity workflowEntity, WorkflowNode currentNode, I18n i18n) {
        if (!workflowEntity.getStatus().getId().equals(action.getTargetStatus().getId())) {
            WorkflowActivity workflowActivity = this.recordEntityStatusChange(i18n, action, workflowEntity.getStatus(), currentNode);
            this.createWorkflowActivityNotificationSnippets(workflowActivity, workflowEntity);
            workflowEntity.setStatus(action.getTargetStatus());
            workflowEntity = this.workflowEntityDAO.update(workflowEntity);
        }
        return workflowEntity;
    }

    private WorkflowActivity recordTokenTransition(I18n i18n, WorkflowNodePosition previousOwnerPosition, WorkflowNodePosition newOwnerPosition, WorkflowNodePosition initiatorPosition, ProjectParticipant signer) {
        WorkflowActivityHistoryEntry activity = new WorkflowActivityHistoryEntry();
        OrganisationPerson initiator = initiatorPosition.getProjectParticipation().getMainParticipant().getOrganisationPerson();
        OrganisationPerson owner = newOwnerPosition.getProjectParticipation().getMainParticipant().getOrganisationPerson();
        OrganisationPerson previousOwner = previousOwnerPosition.getProjectParticipation().getMainParticipant().getOrganisationPerson();
        String previousNode = previousOwnerPosition.getWorkflowNode().getWorkflowNodeTemplate().getName();
        String nextNode = newOwnerPosition.getWorkflowNode().getWorkflowNodeTemplate().getName();
        activity.setAdministrative(false);
        String previousOwnerString = previousOwner.getOrganisation().getName() + " (" + previousOwner.getPerson().getInverseCommonName() + ")";
        activity.setDescription("Knoten " + previousNode + " - " + previousOwnerString + " abgeschlossen und an Knoten " + nextNode + " - " + owner.getOrganisation().getName() + " (" + owner.getPerson().getInverseCommonName() + ") weitergereicht.");
        activity.setIssued(Calendar.getInstance().getTime());
        activity.setTokenInitiator(initiator.getOrganisation().getName() + " (" + initiator.getPerson().getInverseCommonName() + ")");
        activity.setTokenOwner(owner.getOrganisation().getName() + " (" + owner.getPerson().getInverseCommonName() + ")");
        activity.setWorkflow(initiatorPosition.getWorkflowNode().getWorkflow());
        activity.setWorkflowNodeName(initiatorPosition.getWorkflowNode().getWorkflowNodeTemplate().getName());
        activity = (WorkflowActivityHistoryEntry)this.workflowActivityDAO.save(activity);
        return activity;
    }

    private WorkflowActivity recordTokenDeletion(I18n i18n, WorkflowActionTokenDeletion action, WorkflowToken token) {
        WorkflowActivityHistoryEntry activity = new WorkflowActivityHistoryEntry();
        OrganisationPerson mainInitiator = token.getInitiator().getProjectParticipation().getMainParticipant().getOrganisationPerson();
        OrganisationPerson mainOwner = token.getOwner().getProjectParticipation().getMainParticipant().getOrganisationPerson();
        activity.setAdministrative(true);
        activity.setDescription("Aufgabe gel\u00f6scht durch Aktion [" + action.getName() + "]");
        activity.setIssued(Calendar.getInstance().getTime());
        activity.setTokenInitiator(mainInitiator.getOrganisation().getName() + " (" + mainInitiator.getPerson().getInverseCommonName() + ")");
        activity.setTokenOwner(mainOwner.getOrganisation().getName() + " (" + mainOwner.getPerson().getInverseCommonName() + ")");
        activity.setWorkflow(token.getInitiator().getWorkflowNode().getWorkflow());
        activity.setWorkflowNodeName(token.getInitiator().getWorkflowNode().getWorkflowNodeTemplate().getName());
        activity.setType(2);
        activity = (WorkflowActivityHistoryEntry)this.workflowActivityDAO.save(activity);
        return activity;
    }

    private WorkflowActivity recordEntityStatusChange(I18n i18n, WorkflowActionEntityStatusChange action, WorkflowEntityStatus previousStatus, WorkflowNode workflowNode) {
        WorkflowActivityHistoryEntry activity = new WorkflowActivityHistoryEntry();
        activity.setAdministrative(false);
        activity.setDescription("Automatische Status\u00e4nderung von \"" + previousStatus.getName() + "\" in \"" + action.getTargetStatus().getName() + "\"");
        activity.setIssued(Calendar.getInstance().getTime());
        activity.setWorkflow(workflowNode.getWorkflow());
        activity.setWorkflowNodeName(workflowNode.getWorkflowNodeTemplate().getName());
        activity.setType(4);
        activity = (WorkflowActivityHistoryEntry)this.workflowActivityDAO.save(activity);
        return activity;
    }

    private WorkflowActivity recordWorkflowInitialization(WorkflowNode workflowNode) {
        WorkflowActivityHistoryEntry activity = new WorkflowActivityHistoryEntry();
        activity.setAdministrative(false);
        activity.setDescription("Pr\u00fcflauf wurde initialisiert");
        activity.setIssued(Calendar.getInstance().getTime());
        activity.setWorkflow(workflowNode.getWorkflow());
        activity.setWorkflowNodeName(workflowNode.getWorkflowNodeTemplate().getName());
        activity.setType(5);
        activity = (WorkflowActivityHistoryEntry)this.workflowActivityDAO.save(activity);
        return activity;
    }

    private WorkflowActivity recordTokenCreation(WorkflowToken token) {
        WorkflowActivityHistoryEntry activity = new WorkflowActivityHistoryEntry();
        OrganisationPerson initiator = token.getInitiator().getProjectParticipation().getMainParticipant().getOrganisationPerson();
        OrganisationPerson owner = token.getOwner().getProjectParticipation().getMainParticipant().getOrganisationPerson();
        String node = token.getOwner().getWorkflowNode().getWorkflowNodeTemplate().getName();
        String ownerString = owner.getOrganisation().getName() + " (" + owner.getPerson().getInverseCommonName() + ")";
        activity.setAdministrative(false);
        activity.setDescription("Neue Aufgabe f\u00fcr Knoten " + node + " - " + ownerString + " hinzugef\u00fcgt");
        activity.setIssued(Calendar.getInstance().getTime());
        activity.setTokenInitiator(initiator.getOrganisation().getName() + " (" + initiator.getPerson().getInverseCommonName() + ")");
        activity.setTokenOwner(owner.getOrganisation().getName() + " (" + owner.getPerson().getInverseCommonName() + ")");
        activity.setWorkflow(token.getInitiator().getWorkflowNode().getWorkflow());
        activity.setWorkflowNodeName(token.getInitiator().getWorkflowNode().getWorkflowNodeTemplate().getName());
        activity.setType(1);
        activity = (WorkflowActivityHistoryEntry)this.workflowActivityDAO.save(activity);
        return activity;
    }

    private WorkflowActivity recordIntermediateResultRequested(WorkflowToken token) {
        WorkflowActivityHistoryEntry activity = new WorkflowActivityHistoryEntry();
        OrganisationPerson initiator = token.getInitiator().getProjectParticipation().getMainParticipant().getOrganisationPerson();
        OrganisationPerson owner = token.getOwner().getProjectParticipation().getMainParticipant().getOrganisationPerson();
        String node = token.getOwner().getWorkflowNode().getWorkflowNodeTemplate().getName();
        String ownerString = owner.getOrganisation().getName() + " (" + owner.getPerson().getInverseCommonName() + ")";
        String optionalDueDate = DateHelper.formatDefaultDate(token.getOwner().getOptionalDueDate());
        activity.setAdministrative(false);
        activity.setDescription("Zwischenergebnis zum " + optionalDueDate + " f\u00fcr Knoten " + node + " - " + ownerString + " angefordert");
        activity.setIssued(Calendar.getInstance().getTime());
        activity.setTokenInitiator(initiator.getOrganisation().getName() + " (" + initiator.getPerson().getInverseCommonName() + ")");
        activity.setTokenOwner(owner.getOrganisation().getName() + " (" + owner.getPerson().getInverseCommonName() + ")");
        activity.setWorkflow(token.getInitiator().getWorkflowNode().getWorkflow());
        activity.setWorkflowNodeName(token.getInitiator().getWorkflowNode().getWorkflowNodeTemplate().getName());
        activity.setType(3);
        activity = (WorkflowActivityHistoryEntry)this.workflowActivityDAO.save(activity);
        return activity;
    }

    @Override
    public WorkflowReviewContainerDTO getPlanningNotificationReviewContainerDTO(Integer workflowTokenId, Integer activeOrganisationPersonId) throws WorkflowException {
        WorkflowToken workflowToken = this.workflowTokenDAO.get(workflowTokenId);
        WorkflowNode workflowNode = workflowToken.getOwner().getWorkflowNode();
        Workflow workflow = workflowNode.getWorkflow();
        WorkflowNodeDTO workflowNodeDTO = CdesDTOHelper.getWorkflowNodeDTO(workflowNode, CdesDTOHelper.getWorkflowDTO(workflow));
        WorkflowEntity workflowEntity = workflowToken.getWorkflowEntity();
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(activeOrganisationPersonId);
        WorkflowTemplateDTO workflowTemplateDTO = CdesDTOHelper.getWorkflowTemplateDTO(workflow.getWorkflowTemplate());
        WorkflowNodeTemplateDTO nodeTemplateDTO = CdesDTOHelper.getWorkflowNodeTemplateDTO(workflowNode.getWorkflowNodeTemplate(), workflowTemplateDTO);
        ProjectParticipant signer = null;
        Collection tokenOwnerParticipants = workflowToken.getOwner().getProjectParticipation().getProjectParticipants().values();
        for (ProjectParticipant p : tokenOwnerParticipants) {
            if (!p.getOrganisationPerson().getId().equals(activeOrganisationPersonId)) continue;
            signer = this.projectParticipantDAO.get(p.getParticipation().getId(), activeOrganisationPersonId);
        }
        if (signer == null) {
            throw new WorkflowException("Could not find any possible signer participations.");
        }
        ProjectParticipantDTO signerDTO = CdesDTOHelper.getProjectParticipantDTO(signer, false);
        List<WorkflowNodePosition> workflowNodePositions = this.workflowNodePositionDAO.getPositionsForNode(workflowNode.getId(), activeOrganisationPersonId);
        WorkflowReviewContainerDTO container = new WorkflowReviewContainerDTO();
        container.setWorkflowEntityId(workflowEntity.getId());
        container.setWorkflowNodeId(workflowNode.getId());
        container.setSignerParticipantDTO(signerDTO);
        if (workflowNode.getWorkflowNodeTemplate().getWorkflowNodePositionResultOptions() == null || workflowNode.getWorkflowNodeTemplate().getWorkflowNodePositionResultOptions().isEmpty()) {
            throw new WorkflowException("WorkflowNode does not contain any ResultOptions");
        }
        Collection<WorkflowNodePositionResultOption> resultOptions = workflowNode.getWorkflowNodeTemplate().getWorkflowNodePositionResultOptions().values();
        for (WorkflowNodePositionResultOption resultOption : resultOptions) {
            WorkflowNodePositionResultOptionDTO workflowNodePositionResultOptionDTO = CdesDTOHelper.getWorkflowNodePositionResultOptionDTO(resultOption, nodeTemplateDTO);
            container.getPossibleResultOptions().add(workflowNodePositionResultOptionDTO);
        }
        for (WorkflowNodePosition position : workflowNodePositions) {
            WorkflowNodePositionDTO workflowNodePositionDTO = CdesDTOHelper.getWorkflowNodePositionDTO(this.workflowNodePositionDAO.get(position.getId()), workflowNodeDTO);
            container.getWorkflowNodePositions().add(workflowNodePositionDTO);
            List<WorkflowToken> tokens = this.workflowTokenDAO.getAllTokensByOwnerPosition(position.getId());
            if (tokens == null || tokens.isEmpty()) continue;
            for (WorkflowToken token : tokens) {
                container.getWorkflowTokens().add(CdesDTOHelper.getWorkflowTokenDTO(token));
            }
        }
        if (container.getWorkflowTokens() == null || container.getWorkflowTokens().isEmpty()) {
            throw new WorkflowException(orgPerson.getPerson().getInverseCommonName() + " does not own a Token in Node " + workflowNode.getWorkflowNodeTemplate().getName());
        }
        return container;
    }

    @Override
    public PlanningNotificationDTO getPlanningNotificationDTO(Integer planningNotificationId) {
        PlanningNotification pn = this.planningNotificationDAO.get(planningNotificationId);
        return CdesDTOHelper.getPlanningNotificationDTO(pn, false);
    }

    @Override
    public List<PlanningNotificationDTO> getPlanningNotifications(PNFilterDTO filter, Integer networkId) {
        List<PlanningNotification> pns = this.workflowEntityDAO.getPlanningNotifications(filter, networkId);
        ArrayList<PlanningNotificationDTO> pnDTOs = new ArrayList<PlanningNotificationDTO>();
        for (PlanningNotification pn : pns) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing dto [" + pn.getId() + "]"));
            }
            pnDTOs.add(CdesDTOHelper.getPlanningNotificationDTO(pn, true));
        }
        log.info((Object)"Finished at.cdes.controller.actionhandler.ReviewOperationsImpl.getPlanningNotifications(PNFilterDTO, Integer)");
        return pnDTOs;
    }

    @Override
    public List<PlanningNotificationDTO> getPlanningNotificationsByNetworkAndProject(Integer networkId, Integer projectId) {
        List<PlanningNotification> pns = this.planningNotificationDAO.getByNetworkAndProject(networkId, projectId);
        ArrayList<PlanningNotificationDTO> pnDTOs = new ArrayList<PlanningNotificationDTO>();
        for (PlanningNotification pn : pns) {
            pnDTOs.add(CdesDTOHelper.getPlanningNotificationDTO(pn, false));
        }
        return pnDTOs;
    }

    public void setPlanningNotificationDAO(PlanningNotificationDAO planningNotificationDAO) {
        this.planningNotificationDAO = planningNotificationDAO;
    }

    public void setMetaInformationDAO(MetaInformationDAO metaInformationDAO) {
        this.metaInformationDAO = metaInformationDAO;
    }

    public void setMetaTagDAO(MetaTagDAO metaTagDAO) {
        this.metaTagDAO = metaTagDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    @Override
    public void updateReviewCyclePositionResultComment(Integer positionResultId, String comment) {
        ReviewCyclePositionResult reviewCyclePositionResult = this.reviewCyclePositionResultDAO.get(positionResultId);
        reviewCyclePositionResult.setComment(comment);
        this.reviewCyclePositionResultDAO.update(reviewCyclePositionResult);
    }

    @Override
    public List<NetworkDTO> getVisibleNetworksForPlanningNotificationCatalogue(Integer orgPersonId) {
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(orgPersonId);
        ArrayList<NetworkDTO> networkDTOs = new ArrayList<NetworkDTO>();
        ArrayList networks = new ArrayList(orgPerson.getOrganisation().getNetworks().values());
        Collections.sort(networks, new NetworkNameComparator());
        for (Network network : networks) {
            networkDTOs.add(CdesDTOHelper.getNetworkDTO(network, this.projectDAO.getAllPlanningNotificationProjectsFromNetwork(network.getId())));
        }
        return networkDTOs;
    }

    @Override
    public List<NetworkDTO> getVisibleNetworks(Integer orgPersonId) {
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(orgPersonId);
        ArrayList<NetworkDTO> networkDTOs = new ArrayList<NetworkDTO>();
        ArrayList networks = new ArrayList(orgPerson.getOrganisation().getNetworks().values());
        Collections.sort(networks, new NetworkNameComparator());
        for (Network network : networks) {
            ArrayList<Project> projects = new ArrayList<Project>(this.projectDAO.getAllActiveFromNetwork(network.getId()));
            projects.addAll(this.projectDAO.getAllPlanningNotificationProjectsFromNetwork(network.getId()));
            networkDTOs.add(CdesDTOHelper.getNetworkDTO(network, projects));
        }
        return networkDTOs;
    }

    @Override
    public Triple<List<NetworkDTO>, PlanningNotificationTemplateDTO, Map<Integer, List<String>>> getNetworksAndTemplateForPlanningNotificationUpload(Integer orgPersonId, Integer activeNetworkId, Integer activeProjectId) {
        ArrayList<NetworkDTO> networkDTOs = new ArrayList<NetworkDTO>(this.getVisibleNetworksForPlanningNotificationCatalogue(orgPersonId));
        PlanningNotificationTemplate globalTemplate = this.planningNotificationDAO.getGlobalTemplate();
        HashMap projectIdToPlanningNotificationTitles = new HashMap();
        for (NetworkDTO networkDTO : networkDTOs) {
            if (activeNetworkId != null && !networkDTO.getId().equals(activeNetworkId)) continue;
            for (ProjectDTO project : networkDTO.getProjects()) {
                Integer projectId = project.getId();
                List<PlanningNotification> planningNotifications = this.planningNotificationDAO.getByNetworkAndProject(networkDTO.getId(), projectId);
                for (PlanningNotification planningNotification : planningNotifications) {
                    if (!projectIdToPlanningNotificationTitles.containsKey(projectId)) {
                        projectIdToPlanningNotificationTitles.put(projectId, new ArrayList());
                    }
                    ((List)projectIdToPlanningNotificationTitles.get(projectId)).add(planningNotification.getTitle());
                }
            }
            if (activeNetworkId == null) continue;
            break;
        }
        return new Triple<List<NetworkDTO>, PlanningNotificationTemplateDTO, Map<Integer, List<String>>>(networkDTOs, CdesDTOHelper.getPlanningNotificationTemplateDTO(globalTemplate), projectIdToPlanningNotificationTitles);
    }

    @Override
    public List<PlanningNotificationTemplateDTO> getAllPlanningNotificationTemplateDTOs() {
        List<PlanningNotificationTemplate> allPlanningNotificationTemplates = this.planningNotificationDAO.getAllPlanningNotificationTemplates();
        ArrayList<PlanningNotificationTemplateDTO> ret = new ArrayList<PlanningNotificationTemplateDTO>();
        for (PlanningNotificationTemplate templ : allPlanningNotificationTemplates) {
            ret.add(CdesDTOHelper.getPlanningNotificationTemplateDTO(templ));
        }
        return ret;
    }

    @Override
    public List<MetaTagDTO> getAvaillablePlanningNotificationMetaTags() {
        List<MetaTag> tags = this.metaTagDAO.getAll();
        ArrayList<MetaTagDTO> tagDTOs = new ArrayList<MetaTagDTO>();
        for (MetaTag tag : tags) {
            tagDTOs.add(CdesDTOHelper.getPlanningNotificationMetaTagDTO(tag));
        }
        return tagDTOs;
    }

    @Override
    public PlanningNotificationTemplateDTO getDefaultPlanningNotificationTemplate() {
        return CdesDTOHelper.getPlanningNotificationTemplateDTO(this.planningNotificationDAO.getGlobalTemplate());
    }

    @Override
    public PlanningNotificationTemplateDTO getPlanningNotificationTemplateDTO(Integer id) {
        return CdesDTOHelper.getPlanningNotificationTemplateDTO(this.planningNotificationDAO.getTemplate(id));
    }

    @Override
    public PlanningNotificationTemplateDTO saveOrUpdatePlanningNotificationTemplate(PlanningNotificationTemplateDTO template, List<MetaTagDTO> metaTags) {
        PlanningNotificationTemplate templateImpl = null;
        if (template.getId() != null) {
            templateImpl = this.planningNotificationDAO.getTemplate(template.getId());
            templateImpl.setName(template.getName());
            templateImpl.setComment(template.getComment());
            templateImpl.setGlobalTemplate(template.isGlobalTemplate());
            templateImpl.setMetaTags(new HashMap<Integer, MetaTag>());
        } else {
            templateImpl = new PlanningNotificationTemplate();
            templateImpl.setName(template.getName());
            templateImpl.setComment(template.getComment());
            templateImpl.setGlobalTemplate(template.isGlobalTemplate());
            templateImpl.setMetaTags(new HashMap<Integer, MetaTag>());
            templateImpl = this.planningNotificationDAO.saveTemplate(templateImpl);
        }
        for (MetaTagDTO tagDTO : metaTags) {
            if (tagDTO.getName() == null || tagDTO.getName().isEmpty()) continue;
            MetaTag tag = null;
            if (tagDTO.getId() != null) {
                tag = this.metaTagDAO.get(tagDTO.getId());
            }
            if (tag == null) {
                tag = new MetaTag();
                tag.setName(tagDTO.getName());
                tag.setSharepointReferenceName(tagDTO.getSharepointReferenceName());
                tag.setTagFormat(tagDTO.getTagFormat());
                tag.setMultiple(tagDTO.isMultiple());
                tag.setPosition(tagDTO.getPosition());
                tag.setType(tagDTO.getType());
                tag = this.metaTagDAO.save(tag);
            } else {
                tag.setName(tagDTO.getName());
                tag.setSharepointReferenceName(tagDTO.getSharepointReferenceName());
                tag.setMultiple(tagDTO.isMultiple());
                tag.setPosition(tagDTO.getPosition());
                tag.setType(tagDTO.getType());
                tag = this.metaTagDAO.update(tag);
            }
            templateImpl.getMetaTags().put(tag.getId(), tag);
        }
        templateImpl = this.planningNotificationDAO.updateTemplate(templateImpl);
        return CdesDTOHelper.getPlanningNotificationTemplateDTO(templateImpl);
    }

    public void setWorkflowNodeDAO(WorkflowNodeDAO workflowNodeDAO) {
        this.workflowNodeDAO = workflowNodeDAO;
    }

    public void setWorkflowDAO(WorkflowDAO workflowDAO) {
        this.workflowDAO = workflowDAO;
    }

    public void setWorkflowActivityDAO(WorkflowActivityDAO workflowActivityDAO) {
        this.workflowActivityDAO = workflowActivityDAO;
    }

    @Override
    public List<WorkflowActivityDTO> getWorkflowActivityDTOsByWorkflow(Integer workflowId) {
        ArrayList<WorkflowActivityDTO> list = new ArrayList<WorkflowActivityDTO>();
        for (WorkflowActivity activity : this.workflowActivityDAO.getByWorkflow(workflowId)) {
            list.add(CdesDTOHelper.getWorkflowActivityDTO(activity));
        }
        return list;
    }

    @Override
    public List<WorkflowActivityPositionResultDTO> getWorkflowActivityPositionResultDTOsByWorkflow(Integer workflowId) {
        ArrayList<WorkflowActivityPositionResultDTO> list = new ArrayList<WorkflowActivityPositionResultDTO>();
        for (WorkflowActivityPositionResult activity : this.workflowActivityDAO.getPositionResultsByWorkflow(workflowId)) {
            list.add(CdesDTOHelper.getWorkflowActivityPositionResultDTO(activity));
        }
        return list;
    }

    @Override
    public List<WorkflowActivityHistoryEntryDTO> getWorkflowActivityHistoryEntryDTOsByWorkflow(Integer workflowId) {
        ArrayList<WorkflowActivityHistoryEntryDTO> list = new ArrayList<WorkflowActivityHistoryEntryDTO>();
        for (WorkflowActivityHistoryEntry activity : this.workflowActivityDAO.getWorkflowActivityHistoryEntriesByWorkflow(workflowId)) {
            list.add(CdesDTOHelper.getWorkflowActivityHistoryEntry(activity));
        }
        return list;
    }

    @Override
    public WorkflowDTO getWorkflowDTO(Integer workflowId) {
        return CdesDTOHelper.getWorkflowDTO(this.workflowDAO.get(workflowId));
    }

    public void setWorkflowEntityDAO(WorkflowEntityDAO workflowEntityDAO) {
        this.workflowEntityDAO = workflowEntityDAO;
    }

    public void setWorkflowNodePositionDAO(WorkflowNodePositionDAO workflowNodePositionDAO) {
        this.workflowNodePositionDAO = workflowNodePositionDAO;
    }

    public void setWorkflowTemplateDAO(WorkflowTemplateDAO workflowTemplateDAO) {
        this.workflowTemplateDAO = workflowTemplateDAO;
    }

    public void setWorkflowTokenDAO(WorkflowTokenDAO workflowTokenDAO) {
        this.workflowTokenDAO = workflowTokenDAO;
    }

    public void setWorkflowNodePositionResultOptionDAO(WorkflowNodePositionResultOptionDAO workflowNodePositionResultOptionDAO) {
        this.workflowNodePositionResultOptionDAO = workflowNodePositionResultOptionDAO;
    }

    public void setWorkflowEntityStatusDAO(WorkflowEntityStatusDAO workflowEntityStatusDAO) {
        this.workflowEntityStatusDAO = workflowEntityStatusDAO;
    }

    @Override
    public List<PlanningNotificationTaskDTO> getPlanningNotificationTaskDTOs(Integer organisationPersonId) {
        ArrayList<PlanningNotificationTaskDTO> planningNotificationTasks = new ArrayList<PlanningNotificationTaskDTO>();
        List<WorkflowToken> tokens = this.workflowTokenDAO.getAllTokensOwnedByOrganisationPerson(organisationPersonId);
        for (WorkflowToken token : tokens) {
            Iterator<WorkflowEntity> iterator;
            if (token.getOwner().getWorkflowNode().getWorkflow().getWorkflowEntities() == null || !(iterator = token.getOwner().getWorkflowNode().getWorkflow().getWorkflowEntities().values().iterator()).hasNext()) continue;
            WorkflowEntity entity = iterator.next();
            PlanningNotificationTaskDTO planningNotificationTask = CdesDTOHelper.getPlanningNotificationTaskDTO((PlanningNotificationOrder)entity, token);
            planningNotificationTasks.add(planningNotificationTask);
        }
        return planningNotificationTasks;
    }

    @Override
    public List<PlanningNotificationTaskDTO> getPlanningNotificationTasksByFilter(OrderFilterDTO filter, Integer organisationPersonId) {
        ArrayList<PlanningNotificationTaskDTO> planningNotificationTasks = new ArrayList<PlanningNotificationTaskDTO>();
        for (WorkflowToken token : this.workflowEntityDAO.getPlanningNotificationTasksByFilter(filter, organisationPersonId)) {
            Iterator<WorkflowEntity> iterator;
            if (token.getOwner().getWorkflowNode().getWorkflow().getWorkflowEntities() == null || !(iterator = token.getOwner().getWorkflowNode().getWorkflow().getWorkflowEntities().values().iterator()).hasNext()) continue;
            WorkflowEntity entity = iterator.next();
            PlanningNotificationTaskDTO planningNotificationTask = CdesDTOHelper.getPlanningNotificationTaskDTO((PlanningNotificationOrder)entity, token);
            planningNotificationTasks.add(planningNotificationTask);
        }
        return planningNotificationTasks;
    }

    @Override
    public List<ProjectParticipationDTO> getProjectParticipationsForRoleTypeAndProjects(Integer organisationPersonId, List<ProjectDTO> projects, Integer roleTypeId) {
        ArrayList<ProjectParticipationDTO> list = new ArrayList<ProjectParticipationDTO>();
        ArrayList<Project> projectsList = new ArrayList<Project>();
        for (ProjectDTO project : projects) {
            projectsList.add(this.projectDAO.get(project.getId()));
        }
        for (ProjectParticipation participation : this.projectParticipationDAO.getAllForRoleTypeAndProjects(organisationPersonId, projectsList, roleTypeId)) {
            list.add(CdesDTOHelper.getProjectParticipationDTO(participation));
        }
        return list;
    }

    @Override
    public void deleteTasksAndReleaseDocumentVersionsForSubProject(Integer subProjectId) {
        log.info((Object)("---> Critical action: starting to delete all tasks of subproject with id=[" + subProjectId + "]"));
        this.taskOperations.deleteAllTasksOfSubProject(subProjectId);
        log.info((Object)("---> Critical action: deletion of tasks for subproject with id=[" + subProjectId + "] successful."));
        log.info((Object)("---> Critical action: starting to change all documentVersion stati to RELEASEDPOSITIV in subproject with id=[" + subProjectId + "]"));
        List documentVersions = this.documentVersionDAO.getDocumentVersions(subProjectId, 0);
        for (DocumentVersion dv : documentVersions) {
            log.info((Object)("---> Critical action: changing documentVersion status from [" + dv.getStatus() + "] to RELEASEDPOSITIV"));
            dv.setStatus(2);
            this.documentVersionDAO.update(dv);
        }
        log.info((Object)("---> Critical action: change of documentVersion stati to RELEASEDPOSITIV in subproject with id=[" + subProjectId + "] successful"));
    }

    @Override
    public void insertPlanningNotificationOrdersImport(List<PlanningNotificationOrderDTO> orders, Integer planningNotificationId, Integer networkId) throws MissingPropertyException {
        Long prevSerialNumber = null;
        for (PlanningNotificationOrderDTO order : orders) {
            PlanningNotificationOrderDTO result = this.saveOrUpdatePlanningNotificationOrder(order, planningNotificationId, prevSerialNumber, networkId);
            prevSerialNumber = result.getSerialNumber();
        }
    }

    @Override
    public boolean checkWorkflowNodePositionHasTokens(Integer workflowNodePositionId) {
        WorkflowToken tokenByInitiatorPosition = this.workflowTokenDAO.getTokenByInitiatorPosition(workflowNodePositionId);
        if (tokenByInitiatorPosition != null) {
            log.info((Object)("checking workflowNodePositionwith id=[" + workflowNodePositionId + "] for token: has token as initiator, returning true"));
            return true;
        }
        List<WorkflowToken> allTokensByOwnerPosition = this.workflowTokenDAO.getAllTokensByOwnerPosition(workflowNodePositionId);
        if (allTokensByOwnerPosition != null && !allTokensByOwnerPosition.isEmpty()) {
            log.info((Object)("checking workflowNodePositionwith id=[" + workflowNodePositionId + "] for token: has token(s) as owner, returning true"));
            return true;
        }
        return false;
    }

    @Override
    public boolean checkWorkflowHasTokens(Integer workflowId) {
        Workflow workflow = this.workflowDAO.getWithNodes(workflowId);
        WorkflowNode startNode = workflow.getStartNode();
        Map<Integer, WorkflowNodePosition> startNodePositions = startNode.getWorkflowNodePositions();
        for (WorkflowNodePosition nodePosition : startNodePositions.values()) {
            if (!this.checkWorkflowNodePositionHasTokens(nodePosition.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkWorkflowNodePositionHasPositionResults(Integer workflowNodePositionId) {
        List<WorkflowActivityPositionResult> positionResultsByInitiatorPosition = this.workflowActivityDAO.getPositionResultsByInitiator(workflowNodePositionId);
        if (positionResultsByInitiatorPosition != null && !positionResultsByInitiatorPosition.isEmpty()) {
            log.info((Object)("checking workflowNodePositionwith id=[" + workflowNodePositionId + "] for positionResults: has positionResults as initiator, returning true"));
            return true;
        }
        return false;
    }

    public void setWorkflowActivityNotificationSnippetDAO(WorkflowActivityNotificationSnippetDAO workflowActivityNotificationSnippetDAO) {
        this.workflowActivityNotificationSnippetDAO = workflowActivityNotificationSnippetDAO;
    }

    private void createWorkflowActivityNotificationSnippets(WorkflowActivity workflowActivity, WorkflowEntity workflowEntity) {
        ArrayList<Integer> processedOrgPersonIds = new ArrayList<Integer>();
        for (WorkflowNode workflowNode : workflowEntity.getWorkflow().getWorkflowNodes().values()) {
            for (WorkflowNodePosition position : workflowNode.getWorkflowNodePositions().values()) {
                for (ProjectParticipant pp : position.getProjectParticipation().getAllParticipants()) {
                    if (processedOrgPersonIds.contains(pp.getOrganisationPerson().getId()) || pp.getOrganisationPerson().isInActive()) continue;
                    this.createWorkflowActivityNotificationSnippets(workflowActivity, pp);
                    processedOrgPersonIds.add(pp.getOrganisationPerson().getId());
                }
            }
        }
    }

    private void createWorkflowActivityNotificationSnippets(WorkflowActivity workflowActivity, ProjectParticipant pp) {
        Calendar nextSendTime = Calendar.getInstance();
        nextSendTime = pp.getOrganisationPerson().getNextEMailSendTime(nextSendTime);
        if (nextSendTime != null) {
            WorkflowActivityNotificationSnippet snippet = new WorkflowActivityNotificationSnippet();
            snippet.setOrganisationPerson(pp.getOrganisationPerson());
            snippet.setWorkflowActivity(workflowActivity);
            snippet.setSendTime(nextSendTime);
            this.workflowActivityNotificationSnippetDAO.save(snippet);
        }
    }

    @Override
    public boolean isAsBuiltReferenced(Integer documentVersionId) {
        return this.documentVersionDAO.isAsBuiltReferenced(documentVersionId);
    }

    @Override
    public String CleanHTMLComments(String sTextHTML) {
        int iEnd;
        int iStart;
        String sStartComment = "<!--";
        String sEndComment = "-->";
        while ((iStart = sTextHTML.indexOf(sStartComment)) != -1 && (iEnd = sTextHTML.indexOf(sEndComment, iStart)) != -1) {
            sTextHTML = sTextHTML.substring(0, iStart) + sTextHTML.substring(iEnd + sEndComment.length());
        }
        sStartComment = "&lt;!--";
        sEndComment = "--&gt;";
        while ((iStart = sTextHTML.indexOf(sStartComment)) != -1 && (iEnd = sTextHTML.indexOf(sEndComment, iStart)) != -1) {
            sTextHTML = sTextHTML.substring(0, iStart) + sTextHTML.substring(iEnd + sEndComment.length());
        }
        String unescTextHTML = StringEscapeUtils.unescapeHtml((String)sTextHTML);
        String junescTextHTML = Jsoup.clean((String)unescTextHTML, (Whitelist)Whitelist.basic());
        return junescTextHTML;
    }

    @Override
    public Map<Long, String> getStatutoryDutyIdToName(Integer networkId) {
        List statutoryDuties = this.gwtDelegateService.getStatutoryDutiesByNetworkId(networkId);
        HashMap<Long, String> statutoryDutyIdToName = new HashMap<Long, String>();
        for (StatutoryDuty statutoryDuty : statutoryDuties) {
            statutoryDutyIdToName.put(statutoryDuty.getId(), statutoryDuty.getName());
        }
        return statutoryDutyIdToName;
    }

    @Override
    public boolean verifyReviewCycleNodeSkippingRuleForProject(ReviewCycleNode node, Project project) throws ReviewException {
        return this.reviewCycleInterpretationHelper.verifyReviewCycleNodeSkippingRuleForProject(node, project);
    }
}

