/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db;

import at.cdes.db.SchemaCheckerBean;
import at.cdes.util.Configuration;
import at.cdes.util.ConfigurationHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class SchemaChecker {
    private static final Logger logger = Logger.getLogger(SchemaChecker.class);

    public static void main(String[] args) throws FileNotFoundException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, CertificateException, SAXException {
        String instanceName = ConfigurationHelper.getInstanceNameStatic();
        Configuration config = new Configuration(instanceName);
        SchemaCheckerBean schemaCheckerBean = new SchemaCheckerBean();
        schemaCheckerBean.setDatabaseConnection(SchemaChecker.createDBConnection(config));
        schemaCheckerBean.setDisableSchemaCheck(false);
        Vector<String> commands = new Vector<String>();
        commands.add("checkDBSchema");
        logger.info((Object)("SchemaChecker.main(): Going to execute " + commands.size() + " commands"));
        for (String command : commands) {
            logger.info((Object)("SchemaChecker.main(): Going to execute command " + command + " ..."));
            if (command.equalsIgnoreCase("checkDBSchema")) {
                schemaCheckerBean.checkSchema();
                continue;
            }
            logger.warn((Object)("SchemaChecker.main(): Command " + command.toUpperCase() + " is unknown!"));
        }
        logger.info((Object)("SchemaChecker.main(): Done " + commands.size() + " commands"));
    }

    public static Connection createDBConnection(Configuration config) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection dbConn;
        block15: {
            Class<?> dbDriverClass;
            if (logger.isDebugEnabled() && logger != null) {
                logger.debug((Object)"SchemaChecker.createDBConnection() called");
            }
            if (logger.isDebugEnabled() && logger != null) {
                logger.debug((Object)("SchemaChecker.createDBConnection(): searching dbDriver " + config.getDatabaseDriver()));
            }
            try {
                dbDriverClass = Class.forName(config.getDatabaseDriver());
            }
            catch (ClassNotFoundException e) {
                if (logger != null) {
                    logger.fatal((Object)("SchemaChecker.createDBConnection(): Could not find dbDriver class " + config.getDatabaseDriver()));
                }
                throw e;
            }
            try {
                dbDriverClass.newInstance();
            }
            catch (InstantiationException e) {
                if (logger != null) {
                    logger.fatal((Object)("SchemaChecker.createDBConnection(): Could not instantiate dbDriver class " + config.getDatabaseDriver()));
                }
                throw e;
            }
            catch (IllegalAccessException e) {
                if (logger != null) {
                    logger.fatal((Object)("SchemaChecker.createDBConnection(): Not allowed to instatiate dbDriver class " + config.getDatabaseDriver()));
                }
                throw e;
            }
            dbConn = null;
            if (logger.isDebugEnabled() && logger != null) {
                logger.debug((Object)("SchemaChecker.createDBConnection(): trying to connect using:\n" + config.getDatabaseURL()));
            }
            try {
                dbConn = DriverManager.getConnection(config.getDatabaseURL(), config.getDatabaseUser(), config.getDatabasePassword());
            }
            catch (SQLException e) {
                if (logger == null) break block15;
                logger.fatal((Object)("SchemaChecker.checkDBSchema(): Could not connect to DB " + config.getDatabaseName() + ", if the DB does not exist, please let mysql execute these:\n" + SchemaChecker.proposeCreateDBCommand(config)));
            }
        }
        if (dbConn == null && logger != null) {
            logger.fatal((Object)("SchemaChecker.createDBConnection(): Could not connect to DB using url " + config.getDatabaseURL()));
        }
        if (logger.isDebugEnabled() && logger != null) {
            logger.debug((Object)"SchemaChecker.createDBConnection() done");
        }
        return dbConn;
    }

    public static String proposeCreateDBCommand(Configuration config) {
        String createCmd = "CREATE DATABASE " + config.getDatabaseName() + ";\nGRANT ALL PRIVILEGES \n  ON CDES.*\n  TO cdes@'localhost';\nGRANT ALL PRIVILEGES \n  ON CDES.*\n  TO cdes@'%';\nFLUSH PRIVILEGES;\nCOMMIT;\n";
        return createCmd;
    }
}

