/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipantDateHistoryPart;
import at.cdes.db.dao.ProjectParticipantDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ProjectParticipantDAOHibernate
extends HibernateDaoSupport
implements ProjectParticipantDAO {
    @Override
    public ProjectParticipant get(Integer id) {
        return (ProjectParticipant)this.getSession().load(ProjectParticipant.class, (Serializable)id);
    }

    @Override
    public List getAll(Integer projectParticipationId) {
        if (projectParticipationId == null) {
            return this.loadAllHibernate(ProjectParticipant.class);
        }
        return this.findHibernate("from ProjectParticipant where participation.id = ?", projectParticipationId);
    }

    @Override
    public ProjectParticipant save(ProjectParticipant projectParticipant) {
        return this.get((Integer)this.getSession().save((Object)projectParticipant));
    }

    @Override
    public ProjectParticipant update(ProjectParticipant projectParticipant) {
        this.getSession().merge((Object)projectParticipant);
        return projectParticipant;
    }

    @Override
    public void delete(ProjectParticipant projectParticipant) {
        this.getSession().delete((Object)projectParticipant);
    }

    @Override
    public List getAll(OrganisationPerson organisationPerson, boolean active_only) {
        Criteria crit = this.getSession().createCriteria(ProjectParticipant.class);
        crit.createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPerson.getId()));
        if (active_only) {
            crit.add((Criterion)Restrictions.eq((String)"inactive", (Object)false));
        }
        return crit.list();
    }

    @Override
    public List getAll(OrganisationPerson organisationPerson, Project project, boolean withInactive) {
        Criteria criteria = this.getSession().createCriteria(ProjectParticipant.class);
        criteria.createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPerson.getId()));
        Criteria critParticipation = criteria.createCriteria("participation").createCriteria("project").add(Restrictions.idEq((Object)project.getId()));
        if (!withInactive) {
            criteria.add((Criterion)Restrictions.eq((String)"inactive", (Object)false));
        }
        return criteria.list();
    }

    @Override
    public ProjectParticipant get(Integer projectParticipationId, Integer organisationPersonId) {
        Criteria crit = this.getSession().createCriteria(ProjectParticipant.class);
        crit.createCriteria("participation").add(Restrictions.idEq((Object)projectParticipationId));
        crit.createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPersonId));
        crit.add((Criterion)Restrictions.eq((String)"inactive", (Object)false));
        return (ProjectParticipant)crit.uniqueResult();
    }

    public ProjectParticipantDateHistoryPart getProjectParticipantDateHistoryPart(Integer id) {
        return (ProjectParticipantDateHistoryPart)this.getSession().get(ProjectParticipantDateHistoryPart.class, (Serializable)id);
    }

    @Override
    public ProjectParticipantDateHistoryPart save(ProjectParticipantDateHistoryPart hist) {
        return this.getProjectParticipantDateHistoryPart((Integer)this.getSession().save((Object)hist));
    }

    @Override
    public ProjectParticipantDateHistoryPart update(ProjectParticipantDateHistoryPart hist) {
        this.getSession().merge((Object)hist);
        return hist;
    }

    @Override
    public void delete(ProjectParticipantDateHistoryPart hist) {
        this.getSession().delete((Object)hist);
    }

    @Override
    public List getAllPersons(Integer personId) {
        Criteria crit = this.getSession().createCriteria(ProjectParticipant.class);
        crit.createCriteria("organisationPerson").createCriteria("person").add(Restrictions.idEq((Object)personId));
        return crit.list();
    }

    @Override
    public List getForProjectAndOrganisationPerson(Project project, OrganisationPerson organisationPerson) {
        Criteria crit = this.getSession().createCriteria(ProjectParticipant.class);
        crit.createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPerson.getId()));
        if (project != null) {
            crit.createCriteria("participation").createCriteria("project").add(Restrictions.idEq((Object)project.getId()));
        }
        crit.add((Criterion)Restrictions.eq((String)"inactive", (Object)false));
        return crit.list();
    }
}

