/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.controller.actionhandler.login.URLMapper;
import at.cdes.db.dao.AttachmentDAO;
import at.cdes.db.dao.PersonDAO;
import at.cdes.db.dao.ProjectParticipantDAO;
import at.cdes.db.dao.ReviewCyclePositionResultDAO;
import at.cdes.ext.preview.DocumentVersionPdfMimeSource;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PDFProperty;
import at.cdes.preview.api.PDFPropertyType;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.service.AttachmentOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.FileHandleException;
import at.cdes.util.ImplContextHelper;
import at.cdes.util.ParameterHelper;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.UnsupportedDataTypeException;
import org.clazzes.util.io.IOUtil;
import org.xnap.commons.i18n.I18n;

public class DocumentVersionRedliningMimeSource
extends DocumentVersionPdfMimeSource {
    private URLMapper urlMapper;
    private PersonDAO personDAO;
    private AttachmentDAO attachmentDAO;
    private ReviewCyclePositionResultDAO reviewCyclePositionResultDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private AttachmentOperations attachmentOperations;
    private String applicationPath;

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    private String constructUrl(Object[] params, Integer personId) throws UnsupportedDataTypeException {
        StringBuffer s = new StringBuffer();
        s.append(this.urlMapper.getURL(this.personDAO.get(personId)) + this.applicationPath);
        s.append("?service=RedliningService&");
        s.append(ParameterHelper.constructURLParametersString("sp", params));
        s.append("#FDF");
        return s.toString();
    }

    private static String buildWSScript(String url) {
        StringBuffer sb = new StringBuffer();
        sb.append("this.submitForm({\n");
        sb.append("     cURL: \"");
        sb.append(url);
        sb.append("\",\n");
        sb.append("     cSubmitAs: \"FDF\",\n");
        sb.append("     bAnnotations: true,\n");
        sb.append("     bInclNMKey: true\n");
        sb.append("});\n");
        return sb.toString();
    }

    @Override
    protected List<PDFProperty> getPDFProperties(DocumentVersion dv, Object[] parameters, I18n i18n) throws UnsupportedDataTypeException {
        Object[] params;
        List<PDFProperty> ret = super.getPDFProperties(dv, parameters, i18n);
        Integer documentVersionId = (Integer)parameters[0];
        Integer reviewCyclePositionResultId = (Integer)parameters[1];
        Integer projectParticipantId = (Integer)parameters[2];
        Long attachmentKey = (Long)parameters[3];
        ReviewCyclePositionResult res = this.reviewCyclePositionResultDAO.get(reviewCyclePositionResultId);
        List<Attachment> attachments = this.attachmentDAO.getAll(res.getId(), true);
        Attachment attachment = null;
        if (attachmentKey != null) {
            attachment = this.attachmentDAO.getByKey(attachmentKey, projectParticipantId);
        }
        if (attachment == null) {
            attachment = new Attachment();
            attachment.setCreated(new Date());
            attachment.setRedliningDelta(true);
            attachment.setProjectParticipantId(projectParticipantId);
            attachment.setDocumentVersionId(documentVersionId);
            attachment.setKey(attachmentKey);
            attachment = this.attachmentOperations.saveReviewAttachmentSimple(attachment, res);
        }
        Iterator it = attachments.iterator();
        long lastDate = 0L;
        Integer last_id = null;
        if (it.hasNext()) {
            Attachment att = (Attachment)it.next();
            if (att.getFileName() != null && att.getFileName().length() > 0) {
                lastDate = att.getCreated().getTime();
                last_id = att.getId();
            }
            while (it.hasNext()) {
                att = (Attachment)it.next();
                if (att.getFileName() == null || att.getFileName().length() == 0 || att.getCreated().getTime() <= lastDate) continue;
                lastDate = att.getCreated().getTime();
                last_id = att.getId();
            }
        }
        if (last_id != null) {
            params = new Object[parameters.length + 2];
            System.arraycopy(parameters, 0, params, 0, parameters.length);
            params[parameters.length] = attachment.getId();
            params[parameters.length + 1] = last_id;
        } else {
            params = new Object[parameters.length + 1];
            System.arraycopy(parameters, 0, params, 0, parameters.length);
            params[parameters.length] = attachment.getId();
        }
        String url = this.constructUrl(params, ImplContextHelper.getLoginPersonId());
        ret.add(new PDFProperty(PDFPropertyType.WS_SCRIPT, DocumentVersionRedliningMimeSource.buildWSScript(url)));
        ret.add(new PDFProperty(PDFPropertyType.SUBMIT_MSG, i18n.tr("Bitte tragen Sie Ihre grafischen Komentare mit den angebotenen Kommentierwerkzeugen ein und speichern Sie diese anschlie\u00dfend mittels des Men\u00fcpunkts \"Speichern\" oder der Tastenkombination Strg-S.")));
        return ret;
    }

    @Override
    public List<Annotation> getAnnotations(DocumentVersion documentVersion, Object[] parameters) throws IOException, IOError, FileHandleException {
        Integer reviewCyclePositionResultId = (Integer)parameters[1];
        Integer projectParticipantId = (Integer)parameters[2];
        ReviewCyclePositionResult res = this.reviewCyclePositionResultDAO.get(reviewCyclePositionResultId);
        ProjectParticipation participation = res.getProjectParticipant().getParticipation();
        if (!participation.getProjectParticipants().containsKey(projectParticipantId) && res.getOverridingProjectParticipant() != null && !res.getOverridingProjectParticipant().getId().equals(projectParticipantId)) {
            throw new ActionException("The result Id and the project participant id are not consistent.");
        }
        if (res.getSignature() != null) {
            throw new ActionException("The result has already been signed.");
        }
        List<Annotation> ret = super.getAnnotations(documentVersion, parameters);
        List<ReviewCycleNode> nodes = documentVersion.getActualReviewCycleNode().getReviewCycleCell().getReviewCycleNodesSortedByPosition();
        nodes.addAll(documentVersion.getActualReviewCycleNode().getReviewCycleCell().getFreeReviewCycleNodesSortedByPosition());
        for (ReviewCycleNode node : nodes) {
            List<Attachment> attachments = this.attachmentDAO.getAll(documentVersion.getId(), node.getId(), true);
            for (Attachment att : attachments) {
                Iterator rit;
                File file = this.getFileFinder().findFile(att.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
                ByteArrayMimeInputStream fdf_stream = new ByteArrayMimeInputStream(IOUtil.readByteArrayFromFile((File)file), (double)att.getCreated().getTime() * 0.001, att.getOriginalName(), "application/vnd.fdf");
                ProjectParticipant pp = this.projectParticipantDAO.get(att.getProjectParticipantId());
                String reviewer_name = pp.getOrganisationPerson().getPerson().getCommonName() + ", " + pp.getOrganisationPerson().getOrganisation().getName();
                Map results = att.getResults();
                if (results == null || !(rit = results.values().iterator()).hasNext()) continue;
                ReviewCyclePositionResult res2 = (ReviewCyclePositionResult)rit.next();
                String color = "";
                if (res2.getRealm() != null) {
                    if (res2.getRealm().getRedliningColor() != null) {
                        color = res2.getRealm().getRedliningColor();
                    }
                } else {
                    color = "#FF0000";
                }
                boolean read_only = true;
                if (res.getId().equals(res2.getId())) {
                    read_only = false;
                } else if (!res.getProjectParticipant().getId().equals(res2.getProjectParticipant().getId()) && res2.getDigest() == null) continue;
                ret.add(new Annotation((IMimeInputStream)fdf_stream, node.getName(), reviewer_name, color, read_only ? 1 : 0));
            }
        }
        return ret;
    }

    @Override
    public boolean needPDFPostProcessing(DocumentVersion documentVersion, Object[] parameters) {
        return true;
    }

    public void setReviewCyclePositionResultDAO(ReviewCyclePositionResultDAO reviewCyclePositionResultDAO) {
        this.reviewCyclePositionResultDAO = reviewCyclePositionResultDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setAttachmentOperations(AttachmentOperations attachmentOperations) {
        this.attachmentOperations = attachmentOperations;
    }

    public void setUrlMapper(URLMapper urlMapper) {
        this.urlMapper = urlMapper;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }
}

