/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.svg;

import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnection;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceBase;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceRelease;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.DocumentsReviewCycleData;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.task.DocumentTask;
import at.cdes.bo.data.task.DocumentVersionTask;
import at.cdes.bo.data.task.ReviewCycleEntryTask;
import at.cdes.bo.data.task.Task;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.bo.service.ReviewCycleNodeInstanceHelper;
import at.cdes.db.dao.PersonDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.service.ObjectOperations;
import at.cdes.service.PlanDeliverCatalogueOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.ReviewCycleOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import at.cdes.svg.IMarkupWriter;
import at.cdes.svg.SvgRenderKit;
import at.cdes.svg.SvgReviewHelper;
import at.cdes.svg.XMLWriter;
import at.cdes.util.DateHelper;
import at.cdes.util.TapestryI18nHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.clazzes.util.lang.Triple;
import org.xnap.commons.i18n.I18n;

public class SmallReviewCycleSvgRenderer {
    static final Logger logger = Logger.getLogger(SmallReviewCycleSvgRenderer.class);
    private HolidayCalculatorFactory holifactory = null;
    private HolidayCalculator holiCalc = null;
    private SimpleDateFormat df = new SimpleDateFormat("dd.MM.yy");
    private Calendar startAxis;
    private Calendar endAxis;
    private Calendar plannedEnd = null;
    private Calendar plannedStart = null;
    private Calendar lastnodeEnd = null;
    private int toDraw = 0;
    private double height;
    private double xStart;
    private double xEnd;
    private double yStart;
    private double bottom;
    private double width;
    private double height_bar = 20.0;
    private double placePerUnit;
    private double currentXnodeEnd;
    private Calendar toDay;
    private double xtoDay;
    private boolean showOnlyCurrentNode;
    private boolean withCycleDelayLabel;
    private boolean withNodeDurationLabel;
    private boolean withNodeDelayLabelExtended;
    private int urgency = 0;
    private boolean showDocumentStatus;
    private boolean currentPositionShown = false;
    private boolean oOOMode = false;
    Calendar actualStartOfReviewCycle;
    String linestyle = "stroke:black; stroke-width:0.5px;";
    private ReviewOperations reviewOperations = null;
    private ReviewCycleOperations reviewCycleOperations;
    private PlanDeliverCatalogueOperations planDeliverCatalogueOperations;
    private TaskOperations taskOperations;
    private ProjectOperations projectOperations;
    private ObjectOperations objectOperations;
    private PersonDAO personDAO;
    boolean usePDCStartDate = false;
    static final double HEIGHT = 60.0;

    public SmallReviewCycleSvgRenderer(ReviewOperations reviewOp, ReviewCycleOperations reviewCycleOp, TaskOperations taskOp, PlanDeliverCatalogueOperations planDelCatOp, ObjectOperations objectOperations, HolidayCalculatorFactory holiCalc, ProjectOperations projectOperations, PersonDAO personDAO) {
        this.reviewOperations = reviewOp;
        this.reviewCycleOperations = reviewCycleOp;
        this.taskOperations = taskOp;
        this.planDeliverCatalogueOperations = planDelCatOp;
        this.holifactory = new HolidayCalculatorFactory();
        this.projectOperations = projectOperations;
        this.objectOperations = objectOperations;
        this.personDAO = personDAO;
    }

    public void render(XMLWriter writer, XMLWriter popupWriter, int inheight, int inwidth, Integer documentId, boolean withNodeDuration, boolean withNodeDelayExtended, boolean withCycleDelay, boolean onlyCurrentNode, Integer taskId, boolean oooMode, Integer personId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SmallReviewCycleSvgRenderer.render: Width [" + inwidth + "], height [" + inheight + "]"));
        }
        if (taskId == null) {
            this.showDocumentStatus = true;
        }
        this.oOOMode = oooMode;
        this.height = inheight;
        this.width = inwidth;
        this.showOnlyCurrentNode = onlyCurrentNode;
        this.withNodeDurationLabel = withNodeDuration;
        this.withNodeDelayLabelExtended = withNodeDelayExtended;
        this.withCycleDelayLabel = withCycleDelay;
        DocumentImpl doc = this.reviewOperations.getDocument(documentId);
        DocumentVersion docVersion = doc.getLastDocumentVersion();
        ReleasedDocument reldoc = this.getReleasedDocument(doc);
        DocumentsReviewCycleData docCycle = new DocumentsReviewCycleData(doc);
        ReleasedObjectList activeObjectList = doc.getDocumentList().getSubProject().getActiveObjectList();
        ReleasedObjectPlanner opRel = this.objectOperations.getReleasedObjectPlannerFromList(doc.getObjectPlanner().getId(), activeObjectList.getId());
        if (opRel == null) {
            opRel = this.objectOperations.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(doc.getObjectPlanner().getId(), doc.getDocumentList().getSubProject().getId());
        }
        ReviewCycleInstanceRelease cycleInstanceRel = (ReviewCycleInstanceRelease)opRel.getReviewCycleInstance();
        int preDuration = cycleInstanceRel.getPreDuration();
        Person person = this.personDAO.get(personId);
        Locale locale = new Locale(person.getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        boolean isReleasedOrInvalidatedAll = false;
        if (docVersion != null && (docVersion.isReleased() || docVersion.isInvalidatedAll())) {
            isReleasedOrInvalidatedAll = true;
        }
        boolean isInvalidatedOrDeleted = false;
        if (docVersion != null && (docVersion.isDeleted() || docVersion.isInvalidated())) {
            isInvalidatedOrDeleted = true;
        }
        docCycle.setCellResults(this.reviewOperations.getReviewCycleCellResults(doc));
        ReviewCycleNodeResult actualNodeResult = null;
        Calendar earliestEndDate = null;
        Project project = doc.getObjectPlanner().getObject().getObjectList().getSubProject().getProject();
        this.setGlobalVariables(project);
        this.usePDCStartDate = project.isUsePDCStartDateForTasks();
        if (!doc.isVersionSet() && (reldoc == null || reldoc != null && reldoc.getStartDate() == null) || isReleasedOrInvalidatedAll) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("----------------  " + doc.getName() + " rendering of svg grafic was canceled  -------------------"));
                logger.debug((Object)("doc.id: " + doc.getId() + " doc.isVersionSet: " + doc.isVersionSet() + " reldoc==null: " + (reldoc == null) + " reldoc.getStartDate: " + (reldoc != null && reldoc.getStartDate() == null) + " isReleasedOrInvalidatedAll: " + isReleasedOrInvalidatedAll));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("----------------  " + doc.getName() + " start  -------------------"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Drawing timeline: xStart [" + this.xStart + "], yStart [" + this.yStart + "], width [" + this.width + "], lineStyle [" + this.linestyle + "]"));
            logger.debug((Object)("... startAxis [" + this.startAxis.getTimeInMillis() + "] --> formatted to [" + SvgReviewHelper.getDateFormat(this.df, this.startAxis) + "]"));
            logger.debug((Object)("... endAxis [" + this.endAxis.getTimeInMillis() + "] --> formatted to [" + SvgReviewHelper.getDateFormat(this.df, this.endAxis) + "]"));
        }
        SvgRenderKit.addLine(writer, this.xStart, this.yStart + 12.0, this.xStart + this.width, this.yStart + 12.0, this.linestyle);
        SvgRenderKit.addText(writer, 0.0, this.yStart + 10.0, "font-family:verdana; font-size:8px;", SvgReviewHelper.getDateFormat(this.df, this.startAxis), null);
        SvgRenderKit.addText(writer, this.xStart + this.width - 30.0, this.yStart + 10.0, "font-family:verdana; font-size:8px;", SvgReviewHelper.getDateFormat(this.df, this.endAxis), null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Drawing line to indicate today: xtoDay [" + this.xtoDay + "], bottom [" + this.bottom + "]"));
            logger.debug((Object)("... toDay [" + this.toDay.getTimeInMillis() + "] --> formatted to [" + SvgReviewHelper.getDateFormat(this.df, this.toDay) + "]"));
        }
        SvgRenderKit.addLine(writer, this.xtoDay, this.yStart + 12.0, this.xtoDay, this.bottom, this.linestyle);
        SvgRenderKit.addText(writer, this.width / 2.0 - 10.0, this.yStart + 10.0, "font-family:verdana; font-size:8px;", SvgReviewHelper.getDateFormat(this.df, this.toDay), null);
        this.drawBackground(writer, docCycle, reldoc, activeObjectList);
        if (!isReleasedOrInvalidatedAll && docCycle.getCellResults() != null && docCycle.getCellResults().size() > 0) {
            actualNodeResult = this.drawDoneCells(writer, docCycle.getCellResults(), activeObjectList, cycleInstanceRel, popupWriter, i18n);
            earliestEndDate = this.drawRemainingCells(writer, actualNodeResult, doc, this.lastnodeEnd, this.currentXnodeEnd, activeObjectList, docCycle.getCellResults());
        } else if (reldoc != null) {
            this.drawEntryNode(writer, reldoc, activeObjectList, popupWriter, i18n);
        }
        Task task = null;
        if (taskId != null) {
            task = this.taskOperations.getTask(taskId);
        }
        if (this.plannedEnd != null && earliestEndDate != null && docCycle.getCellResults() != null && docCycle.getCellResults().size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("project localisation " + doc.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getLocalisation().getCountry().getCode2()));
                logger.debug((Object)("review cycle's planned end " + SvgReviewHelper.getDateFormat(this.df, this.plannedEnd)));
                logger.debug((Object)("review cycle's earliest end  " + SvgReviewHelper.getDateFormat(this.df, earliestEndDate)));
            }
            if (preDuration > 0 && this.taskOperations.isReversePreduration()) {
                earliestEndDate = this.holiCalc.addWorkingDays(earliestEndDate, preDuration);
            }
            int reviewCycleDelay = this.holiCalc.getWorkingDaysBetween(earliestEndDate, this.plannedEnd);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("review cycle's delay " + reviewCycleDelay));
            }
            if (this.withCycleDelayLabel && !isInvalidatedOrDeleted) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Drawing text, case withCycleDelayLabel and not isInvalidatedOrDeleted");
                    logger.debug((Object)("... xEnd [" + this.xEnd + "], bottom [" + this.bottom + "], height_bar [" + this.height_bar + "], reviewCycleDelay [" + reviewCycleDelay + "]"));
                }
                SvgRenderKit.addText(writer, this.xEnd - 10.0, this.bottom - this.height_bar - 8.0, "font-family:verdana; font-size:10px;" + (reviewCycleDelay < 0 ? "stroke:red;" : "stroke:blue;"), Integer.toString(reviewCycleDelay), null);
            }
            this.evalPopupCycleProgress(popupWriter, reldoc.getStartDate(), reldoc.getEndDate(), reviewCycleDelay, TapestryI18nHelper.getLocalizedString(docVersion.getActualReviewCycleNode().getReviewCycleCell().getName()), TapestryI18nHelper.getLocalizedString(docVersion.getActualReviewCycleNode().getName()), taskId == null, isInvalidatedOrDeleted, i18n);
        }
        if (task == null && docVersion != null) {
            String nodeName = TapestryI18nHelper.getLocalizedString(docVersion.getActualReviewCycleNode().getName());
            List<DocumentVersionTask> tasks = this.taskOperations.getTasksOfDocumentVersion(docVersion.getId());
            if (tasks != null && !tasks.isEmpty()) {
                DocumentVersionTask dTask = tasks.get(0);
                this.evalPopupActions(popupWriter, dTask.getOptimalDeadline(), dTask.getContractualDeadline(), this.urgency, nodeName, i18n);
            }
        }
        if (task == null && docVersion != null) {
            this.evalPopupDocumentVersionStatus(popupWriter, docVersion, i18n);
        }
        if (task == null && docVersion == null) {
            ReviewCycleEntryTask rtask = this.taskOperations.getReviewCycleEntryTask(doc.getId());
            if (reldoc == null) {
                if (this.oOOMode) {
                    popupWriter.printRaw(i18n.tr("\nDer Planlieferkatalog zu diesem Dokument ist nicht freigegeben!"));
                } else {
                    popupWriter.beginEmpty("br");
                    popupWriter.print(i18n.tr("Der Planlieferkatalog zu diesem Dokument ist nicht freigegeben!"));
                }
            }
            if (rtask != null) {
                this.evalPlanner(popupWriter, rtask, doc.getObjectPlanner(), i18n);
            }
        }
        if (taskId != null && task instanceof DocumentVersionTask) {
            this.evalPopupActions(popupWriter, ((DocumentVersionTask)task).getOptimalDeadline(), ((DocumentVersionTask)task).getContractualDeadline(), this.urgency, null, i18n);
        }
    }

    private void setGlobalVariables(Project project) {
        this.endAxis = Calendar.getInstance();
        this.endAxis.add(5, 30);
        this.startAxis = (Calendar)this.endAxis.clone();
        this.startAxis.add(5, -60);
        this.toDraw = SvgReviewHelper.calculateDaysToDraw(this.startAxis, this.endAxis);
        this.height = 60.0;
        this.xStart = 0.0;
        this.yStart = 0.0;
        this.bottom = 60.0;
        this.placePerUnit = this.width / (double)this.toDraw;
        this.width = this.placePerUnit * (double)this.toDraw;
        this.xEnd = this.xStart + this.width;
        this.currentXnodeEnd = 0.0;
        this.toDay = Calendar.getInstance();
        this.xtoDay = SvgReviewHelper.getXPositionFromDate(this.startAxis, this.toDay, this.placePerUnit) + this.xStart;
        this.holiCalc = this.holifactory.getInstance(project);
    }

    private ReleasedDocument getReleasedDocument(DocumentImpl document) {
        ReleasedDocumentList rdl = document.getDocumentList().getSubProject().getActiveDocumentList();
        if (rdl != null) {
            return this.planDeliverCatalogueOperations.getReleasedDocumentFromList(document.getId(), rdl.getId());
        }
        return null;
    }

    private ReviewCycleNodeResult drawDoneCells(IMarkupWriter writer, List<ReviewCycleCellResult> cellResults, ReleasedObjectList objectList, ReviewCycleInstanceRelease cycleInstanceRel, XMLWriter popupWriter, I18n i18n) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"================================================");
            logger.debug((Object)"drawDoneCells");
            logger.debug((Object)"================================================");
        }
        ReviewCycleNodeResult lastNodeResult = null;
        Calendar lastContractualDeadline = null;
        int lastNodeDelay = 0;
        boolean firstNotEmptyNode = true;
        boolean lastDocumentVersionHasCellResult = false;
        if (cellResults.size() > 0) {
            DocumentVersion possibleLastVersion = this.reviewOperations.getDocumentVersion(cellResults.get(cellResults.size() - 1).getDocumentVersion().getId());
            lastDocumentVersionHasCellResult = possibleLastVersion.isLastDocumentVersion();
            this.actualStartOfReviewCycle = DateHelper.getCalendar(cellResults.get(0).getDocumentArrivalDate());
        }
        if (this.usePDCStartDate && (this.plannedStart == null || !this.plannedStart.after(this.actualStartOfReviewCycle))) {
            this.usePDCStartDate = false;
        }
        for (ReviewCycleCellResult cellResult : cellResults) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("... Processing cellResultId [" + cellResult.getId() + "]"));
            }
            if (!cellResult.isFinished() && cellResult.getPreviousReviewCycleCell() == null && cellResult.getNextReviewCycleCell() == null && cellResults.size() > 1 || cellResult == null) continue;
            boolean lastCellResult = cellResults.lastIndexOf(cellResult) == cellResults.size() - 1;
            String cellColor = cellResult.getReviewCycleCell().getSvgColor();
            int emptyNodeOptionId = cellResult.getReviewCycleCell().getReviewCycle().getEmptyNodeOption().getId();
            int invalidateNodeOptionId = cellResult.getReviewCycleCell().getReviewCycle().getDocumentVersionInvalidationOption().getId();
            int deletedNodeOptionId = cellResult.getReviewCycleCell().getReviewCycle().getDocumentVersionDeletedOption().getId();
            if (cellResult.getDocumentDepartureDate() == null || DateHelper.getCalendar(cellResult.getDocumentDepartureDate()).after(this.startAxis)) {
                ArrayList nodeResults = (ArrayList)cellResult.getReviewCycleNodeResultsSortedByPosition(true);
                for (ReviewCycleNodeResult nodeResult : nodeResults) {
                    boolean lastCellResultIsInvalidated;
                    boolean isLastNodeResult;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("...... Processing nodeResult [" + nodeResult.getId() + "]"));
                    }
                    boolean bl = isLastNodeResult = nodeResults.lastIndexOf(nodeResult) == nodeResults.size() - 1;
                    if (nodeResult.getReviewCycleNode().isFree()) continue;
                    boolean bl2 = lastCellResultIsInvalidated = lastCellResult && nodeResult.getReviewCycleResultOption() != null && (nodeResult.getReviewCycleResultOption().getId().equals(invalidateNodeOptionId) || nodeResult.getReviewCycleResultOption().getId().equals(deletedNodeOptionId)) || lastCellResult && !lastDocumentVersionHasCellResult;
                    if ((nodeResult.getReviewCycleResultOption() == null || !nodeResult.getReviewCycleResultOption().getId().equals(emptyNodeOptionId)) && (nodeResult.getDocumentDepartureDate() == null || DateHelper.getCalendar(nodeResult.getDocumentDepartureDate()).after(this.startAxis)) || lastCellResultIsInvalidated) {
                        int typeOfEdges2;
                        int typeOfEdges;
                        double XnodeEnd;
                        double XnodeStart;
                        int nodesDelay = 0;
                        Calendar nodeStart = DateHelper.getCalendar(nodeResult.getDocumentArrivalDate());
                        if (!nodeResult.isFinished() && firstNotEmptyNode && this.usePDCStartDate) {
                            nodeStart = this.plannedStart;
                        }
                        firstNotEmptyNode = false;
                        Calendar actualNodeEnd = ReviewCycleNodeInstanceHelper.verifyDocumentDepartureDate(nodeResult);
                        Calendar nodeEnd = null;
                        ReleasedObjectList relObjectListValidOnNodeDeparture = nodeResult.getActiveObjectListOfDocumentDeparture() != null ? (ReleasedObjectList)nodeResult.getActiveObjectListOfDocumentDeparture() : objectList;
                        Triple<Calendar, Integer, Integer> nodesData = ReviewCycleNodeInstanceHelper.calcDelayOfActualNode(this.objectOperations, this.taskOperations, this.reviewOperations, this.holiCalc, nodeResult, nodeStart, false, relObjectListValidOnNodeDeparture);
                        Calendar contractualDeadline = (Calendar)nodesData.getFirst();
                        nodesDelay = (Integer)nodesData.getSecond();
                        int duration = (Integer)nodesData.getThird();
                        if (lastCellResultIsInvalidated && isLastNodeResult) {
                            nodeEnd = nodesDelay < 0 ? contractualDeadline : actualNodeEnd;
                            XnodeStart = nodeStart != null && nodeStart.after(this.startAxis) ? SvgReviewHelper.getXPositionFromDate(this.startAxis, nodeStart, this.placePerUnit) + this.xStart : this.xStart;
                            this.currentXnodeEnd = XnodeEnd = nodeEnd != null ? SvgReviewHelper.getXPositionFromDate(this.startAxis, nodeEnd, this.placePerUnit) + this.xStart : this.xtoDay;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("......... axisStart [" + this.startAxis + "], placePerUnit [" + this.placePerUnit + "], xStart [" + this.xStart + "], xToday [" + this.xtoDay + "], XnodeStart [" + XnodeStart + "] ==> Setting XnodeEnd [" + XnodeEnd + "]"));
                            }
                            typeOfEdges = SvgReviewHelper.calculateTypeOfEdges(nodeResult.getReviewCycleNode(), "[DrawDoneCells] ", nodesDelay < 0 || actualNodeEnd == null);
                            if (XnodeStart != this.xtoDay && actualNodeEnd != null && !this.showOnlyCurrentNode) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Clause 'draw done nodes checking the showOnlyCurrentNode flag', if-clause");
                                    logger.debug((Object)("... XnodeStart [" + XnodeStart + "], nodeEnd [" + (nodeEnd != null ? Long.valueOf(nodeEnd.getTimeInMillis()) : "null") + "], toDay [" + this.toDay + "], height_bar [" + this.height_bar + "], cellColor [" + cellColor + "], duration [" + duration + "], typeOfEdges [" + typeOfEdges + "]"));
                                }
                                this.drawNode(writer, XnodeStart, nodeEnd != null ? nodeEnd : this.toDay, this.height_bar / 2.0, this.height_bar, cellColor, false, duration, typeOfEdges);
                            } else if (XnodeStart != this.xtoDay && actualNodeEnd == null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Clause 'draw done nodes checking the showOnlyCurrentNode flag', else-clause");
                                    logger.debug((Object)("... XnodeStart [" + XnodeStart + "], nodeEnd [" + (nodeEnd != null ? Long.valueOf(nodeEnd.getTimeInMillis()) : "null") + "], toDay [" + this.toDay + "], height_bar [" + this.height_bar + "], cellColor [" + cellColor + "], duration [" + duration + "], typeOfEdges [" + typeOfEdges + "]"));
                                }
                                this.drawNode(writer, XnodeStart, nodeEnd != null ? nodeEnd : this.toDay, this.height_bar / 2.0, this.height_bar, cellColor, false, duration, typeOfEdges);
                            }
                            XnodeStart = XnodeEnd;
                            if (actualNodeEnd != null && nodesDelay < 0) {
                                nodeEnd = actualNodeEnd;
                                typeOfEdges2 = SvgReviewHelper.calculateTypeOfEdges(nodeResult.getReviewCycleNode(), "[DrawDoneCells] ", false);
                                if (!this.showOnlyCurrentNode) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)"draw the delayed not section of done nodes");
                                        logger.debug((Object)("... XnodeStart [" + XnodeStart + "], nodeEnd [" + (nodeEnd != null ? Long.valueOf(nodeEnd.getTimeInMillis()) : "null") + "], toDay [" + this.toDay + "], height_bar [" + this.height_bar + "]"));
                                    }
                                    this.drawNode(writer, XnodeStart, nodeEnd != null ? nodeEnd : this.toDay, this.height_bar / 2.0, this.height_bar, "#ff0000; opacity:0.5", false, nodesDelay, typeOfEdges2 - typeOfEdges);
                                }
                            }
                            nodeStart = nodeEnd;
                            contractualDeadline = this.holiCalc.addWorkingDays(actualNodeEnd, duration);
                            nodesDelay = this.holiCalc.getWorkingDaysBetween(this.toDay, contractualDeadline);
                        }
                        lastContractualDeadline = contractualDeadline;
                        lastNodeDelay = nodesDelay;
                        if (actualNodeEnd == null || lastCellResultIsInvalidated && isLastNodeResult) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("node delay=" + nodesDelay + " contractualDeadline: " + SvgReviewHelper.getDateFormat(this.df, contractualDeadline)));
                            }
                            nodeEnd = nodesDelay < 0 || this.usePDCStartDate ? contractualDeadline : this.toDay;
                            if (this.withNodeDelayLabelExtended) {
                                String nodesDelayStr = "";
                                nodesDelayStr = nodesDelay < -1 || nodesDelay > 1 ? nodesDelayStr + (nodesDelay < -1 ? String.format(i18n.tr("vor %s Tagen"), String.valueOf(Math.abs(nodesDelay))) : String.format(i18n.tr("in %s Tagen"), String.valueOf(Math.abs(nodesDelay)))) : nodesDelayStr + (nodesDelay == -1 ? i18n.tr("vor 1 Tag") : (nodesDelay == 1 ? i18n.tr("in 1 Tag") : i18n.tr("heute")));
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Drawing text, case withNodeDelayLabelExtended");
                                    logger.debug((Object)("... xtoDay [" + this.xtoDay + "], withNodeDelayLabelExtended [" + this.withNodeDelayLabelExtended + "], bottom [" + this.bottom + "], height_bar [" + this.height_bar + "], nodesDelay [" + nodesDelay + "], nodesDelayStr [" + nodesDelayStr + "]"));
                                }
                                SvgRenderKit.addText(writer, this.xtoDay - (double)(this.withNodeDelayLabelExtended ? 40 : 20), this.bottom - this.height_bar - 8.0, "font-family:verdana; font-size:12px;" + (nodesDelay < 0 ? "stroke:red;" : "stroke:black;"), nodesDelayStr, null);
                            } else {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Drawing text, case NOT withNodeDelayLabelExtended");
                                    logger.debug((Object)("... xtoDay [" + this.xtoDay + "], bottom [" + this.bottom + "], height_bar [" + this.height_bar + "], nodesDelayStr [" + Integer.toString(nodesDelay) + "]"));
                                }
                                SvgRenderKit.addText(writer, this.xtoDay - 20.0, this.bottom - this.height_bar - 8.0, "font-family:verdana; font-size:12px;" + (nodesDelay < 0 ? "stroke:red;" : "stroke:black;"), Integer.toString(nodesDelay), null);
                            }
                        } else {
                            nodeEnd = nodesDelay < 0 ? contractualDeadline : actualNodeEnd;
                        }
                        XnodeStart = nodeStart != null && nodeStart.after(this.startAxis) ? SvgReviewHelper.getXPositionFromDate(this.startAxis, nodeStart, this.placePerUnit) + this.xStart : this.xStart;
                        this.currentXnodeEnd = XnodeEnd = nodeEnd != null ? SvgReviewHelper.getXPositionFromDate(this.startAxis, nodeEnd, this.placePerUnit) + this.xStart : this.xtoDay;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(i18n.tr("Knoten") + " " + TapestryI18nHelper.getLocalizedString(nodeResult.getReviewCycleNode().getName()) + " " + i18n.tr("Start:") + " " + SvgReviewHelper.getDateFormat(this.df, nodeStart) + " " + i18n.tr("End:") + " " + SvgReviewHelper.getDateFormat(this.df, nodeEnd) + i18n.tr("postition") + " " + nodeResult.getReviewCycleNode().getPosition()));
                        }
                        typeOfEdges = SvgReviewHelper.calculateTypeOfEdges(nodeResult.getReviewCycleNode(), "[DrawDoneCells] ", nodesDelay < 0 || actualNodeEnd == null || lastCellResultIsInvalidated && isLastNodeResult && nodesDelay >= 0);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"draw done nodes checking the showOnlyCurrentNode flag");
                            logger.debug((Object)("XnodeStart [" + XnodeStart + "], nodeEnd [" + (nodeEnd != null ? Long.valueOf(nodeEnd.getTimeInMillis()) : "null") + "], toDay [" + this.toDay.getTimeInMillis() + "], height_bar [" + this.height_bar + "], duration [" + duration + "], typeOfEdges [" + typeOfEdges + "]"));
                        }
                        if (XnodeStart != this.xtoDay && actualNodeEnd != null && !this.showOnlyCurrentNode) {
                            this.drawNode(writer, XnodeStart, nodeEnd != null ? nodeEnd : this.toDay, this.height_bar / 2.0, this.height_bar, cellColor, false, duration, typeOfEdges);
                        } else if (actualNodeEnd == null || lastCellResultIsInvalidated && isLastNodeResult) {
                            this.drawNode(writer, XnodeStart, nodeEnd != null ? nodeEnd : this.toDay, this.height_bar / 2.0, this.height_bar, cellColor, false, duration, typeOfEdges);
                        }
                        XnodeStart = XnodeEnd;
                        if (actualNodeEnd != null && nodesDelay < 0 && !this.showOnlyCurrentNode) {
                            nodeEnd = lastCellResultIsInvalidated && isLastNodeResult ? this.toDay : actualNodeEnd;
                            typeOfEdges2 = SvgReviewHelper.calculateTypeOfEdges(nodeResult.getReviewCycleNode(), "[DrawDoneCells] ", false);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"draw the delayed node section of done nodes");
                                logger.debug((Object)("XnodeStart [" + XnodeStart + "], nodeEnd [" + (nodeEnd != null ? Long.valueOf(nodeEnd.getTimeInMillis()) : "null") + "], toDay [" + this.toDay.getTimeInMillis() + "], height_bar [" + this.height_bar + "], duration [" + duration + "], typeOfEdges [" + typeOfEdges + "]"));
                            }
                            this.drawNode(writer, XnodeStart, nodeEnd != null ? nodeEnd : this.toDay, this.height_bar / 2.0, this.height_bar, "#ff0000; opacity:0.5", false, nodesDelay, typeOfEdges2 - typeOfEdges);
                        }
                        lastNodeResult = nodeResult;
                        this.lastnodeEnd = nodeEnd;
                    }
                    if (nodeResult.getReviewCycleResultOption() == null || nodeResult.getReviewCycleResultOption().getId().equals(emptyNodeOptionId)) continue;
                    firstNotEmptyNode = false;
                }
            }
            firstNotEmptyNode = false;
        }
        if (lastContractualDeadline != null) {
            this.evalPopupTaskNodeProgress(popupWriter, lastContractualDeadline, lastNodeDelay, i18n);
        }
        return lastNodeResult;
    }

    private Calendar drawRemainingCells(IMarkupWriter writer, ReviewCycleNodeResult lastNodeResult, DocumentImpl document, Calendar lastNodeEnd, double lastXnodeEnd, ReleasedObjectList objectList, List<ReviewCycleCellResult> cellResults) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"================================================");
            logger.debug((Object)"drawRemainingCells");
            logger.debug((Object)"================================================");
        }
        Calendar desiredNodeEnd = lastNodeEnd;
        double XnodeStart = lastXnodeEnd;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("... lastNodeEnd [" + (lastNodeEnd != null ? Long.valueOf(lastNodeEnd.getTimeInMillis()) : "null") + "], lastXnodeEnd [" + lastXnodeEnd + "]"));
        }
        ReviewCycleInstanceRelease cycleInstanceRel = (ReviewCycleInstanceRelease)this.objectOperations.getReleasedObjectPlannerFromList(document.getObjectPlanner().getId(), objectList.getId()).getReviewCycleInstance();
        ReviewCycleCellInstanceBase cellInstanceRelease = null;
        String cellColor = null;
        int nodeDelay = 0;
        int typeOfEdges = 0;
        if (lastNodeResult != null) {
            boolean lastCellResult = cellResults.lastIndexOf(lastNodeResult.getReviewCycleCellResult()) == cellResults.size() - 1;
            int emptyNodeOptionId = cycleInstanceRel.getReviewCycle().getEmptyNodeOption().getId();
            int invalidateNodeOptionId = cycleInstanceRel.getReviewCycle().getDocumentVersionInvalidationOption().getId();
            int deletedNodeOptionId = cycleInstanceRel.getReviewCycle().getDocumentVersionDeletedOption().getId();
            boolean lastCellResultIsInvalidated = lastCellResult && lastNodeResult.getReviewCycleResultOption() != null && (lastNodeResult.getReviewCycleResultOption().getId() == invalidateNodeOptionId || lastNodeResult.getReviewCycleResultOption().getId() == deletedNodeOptionId);
            cellInstanceRelease = (ReviewCycleCellInstanceRelease)cycleInstanceRel.getReviewCycleCellInstanceByCellId(lastNodeResult.getReviewCycleNode().getReviewCycleCell().getId());
            cellColor = cellInstanceRelease.getReviewCycleCell().getSvgColor();
            boolean allPreviousNodesAreNotEmpty = true;
            ReviewCycleResultOption emptyNodeOption = lastNodeResult.getReviewCycleCellResult().getReviewCycleCell().getReviewCycle().getEmptyNodeOption();
            ArrayList reviewCycleNodeResults = (ArrayList)lastNodeResult.getReviewCycleCellResult().getReviewCycleNodeResultsSortedByPosition(true);
            for (ReviewCycleNodeResult reviewCycleNodeResult : reviewCycleNodeResults) {
                if (!reviewCycleNodeResult.isFinished() || reviewCycleNodeResult.getReviewCycleNode().isEndNode()) continue;
                allPreviousNodesAreNotEmpty &= reviewCycleNodeResult.getReviewCycleResultOption().getValue() != emptyNodeOption.getValue();
            }
            if (lastCellResultIsInvalidated) {
                Calendar actualNodeEnd = ReviewCycleNodeInstanceHelper.verifyDocumentDepartureDate(lastNodeResult);
                ReviewCycleNodeInstanceRelease nodeInstanceRel = this.reviewOperations.getReleasedReviewCycleNodeInstance3(lastNodeResult.getReviewCycleNode().getId(), cycleInstanceRel.getId());
                int duration = nodeInstanceRel.getDuration();
                Calendar contractualDeadline = this.holiCalc.addWorkingDays(actualNodeEnd, duration);
                nodeDelay = this.holiCalc.getWorkingDaysBetween(this.toDay, contractualDeadline);
            } else {
                nodeDelay = (Integer)ReviewCycleNodeInstanceHelper.calcDelayOfActualNode(this.objectOperations, this.taskOperations, this.reviewOperations, this.holiCalc, lastNodeResult, null, false, objectList).getSecond();
            }
            int n = typeOfEdges = lastNodeResult.getReviewCycleNode().isEndOfCell() ? 1 : 0;
        }
        if (lastNodeResult != null && !lastNodeResult.getReviewCycleNode().isFree()) {
            if (nodeDelay >= 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("node in time, delay=" + nodeDelay));
                }
                if (!this.usePDCStartDate) {
                    desiredNodeEnd = this.holiCalc.addWorkingDays(desiredNodeEnd, nodeDelay);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Finish actual node, if-clause");
                        logger.debug((Object)("XnodeStart [" + XnodeStart + "], desiredNodeEnd [" + desiredNodeEnd.getTimeInMillis() + "], height_bar [" + this.height_bar + "], cellColor [" + cellColor + "], nodeDelay [" + nodeDelay + "], typeOfEdges [" + typeOfEdges + "]"));
                    }
                    XnodeStart = this.drawNode(writer, XnodeStart, desiredNodeEnd, this.height_bar / 2.0, this.height_bar, cellColor + "; opacity:0.7", true, nodeDelay, typeOfEdges);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("node delayed, delay=" + nodeDelay));
                }
                desiredNodeEnd = this.toDay;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Finish actual node, else-clause");
                    logger.debug((Object)("XnodeStart [" + XnodeStart + "], desiredNodeEnd [" + desiredNodeEnd.getTimeInMillis() + "], height_bar [" + this.height_bar + "], cellColor [" + cellColor + "], nodeDelay [" + nodeDelay + "], typeOfEdges [" + typeOfEdges + "]"));
                }
                XnodeStart = this.drawNode(writer, XnodeStart, desiredNodeEnd, this.height_bar / 2.0, this.height_bar, "#ff0000; opacity:0.5", false, nodeDelay, typeOfEdges);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"About to enter section 'finish actual cell'");
        }
        ArrayList nodeInstances = null;
        if (lastNodeResult != null && cellInstanceRelease != null) {
            nodeInstances = (ArrayList)cellInstanceRelease.getReviewCycleNodeInstancesSortedByPosition();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("... Having lastNodeResult and cellInstanceRelease; found [" + nodeInstances.size() + "] nodeInstances."));
            }
            for (int i = lastNodeResult.getReviewCycleNode().getPosition().intValue(); i < nodeInstances.size(); ++i) {
                ReviewCycleNodeInstanceRelease nodeInstanceRel = (ReviewCycleNodeInstanceRelease)nodeInstances.get(i);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("...... Processing nodeInstanceRel [" + nodeInstanceRel.getId() + "], position [" + nodeInstanceRel.getReviewCycleNode().getPosition() + "], lastNodeResult.node.position [" + lastNodeResult.getReviewCycleNode().getPosition() + "], count [" + nodeInstances.size() + "]"));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("......... Position count [" + nodeInstanceRel.getReviewCyclePositions().size() + "], isEndCell [" + cellInstanceRelease.getReviewCycleCell().isEndCell() + "], duration [" + nodeInstanceRel.getDuration() + "], nodeId [" + nodeInstanceRel.getReviewCycleNode().getId() + "], isEndNode [" + nodeInstanceRel.getReviewCycleNode().isEndNode() + "]"));
                }
                if (nodeInstanceRel.getReviewCyclePositions().size() <= 0 && (cellInstanceRelease.getReviewCycleCell().isEndCell() || !nodeInstanceRel.getReviewCycleNode().isEndNode())) continue;
                desiredNodeEnd = this.holiCalc.addWorkingDays(desiredNodeEnd, nodeInstanceRel.getDuration());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("......... desiredNodeEnd [" + (desiredNodeEnd != null ? Long.valueOf(desiredNodeEnd.getTimeInMillis()) : "null") + "], showOnlyCurrentNode [" + this.showOnlyCurrentNode + "]"));
                }
                if (this.showOnlyCurrentNode) continue;
                int n = typeOfEdges = nodeInstanceRel.getReviewCycleNode().isEndOfCell() ? 1 : 0;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"......... FinishActualCell");
                    logger.debug((Object)("......... XnodeStart [" + XnodeStart + "], desiredNodeEnd [" + desiredNodeEnd.getTimeInMillis() + "], height_bar [" + this.height_bar + "], cellColor [" + cellColor + "], nodeDelay [" + nodeDelay + "], typeOfEdges [" + typeOfEdges + "]"));
                }
                XnodeStart = this.drawNode(writer, XnodeStart, desiredNodeEnd, this.height_bar / 2.0, this.height_bar, cellColor + "; opacity:0.3", true, nodeInstanceRel.getDuration(), typeOfEdges);
            }
        }
        ArrayList restOfCells = (ArrayList)cycleInstanceRel.getReviewCycleCellInstancesSortedByPosition();
        boolean start = false;
        ReviewCycleCell prevCell = null;
        for (ReviewCycleCellInstanceRelease restCellInstRel : restOfCells) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing restCellInstRel [" + restCellInstRel.getId() + "], start [" + start + "]"));
            }
            boolean defaultWay = false;
            if (start) {
                cellColor = restCellInstRel.getReviewCycleCell().getSvgColor();
                nodeInstances = (ArrayList)restCellInstRel.getReviewCycleNodeInstancesSortedByPosition();
                Collection connections = restCellInstRel.getReviewCycleCell().getIncommingConnections().values();
                for (ReviewCycleCellConnection connection : connections) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("... evaluating ReviewCycleCellConnection [" + connection.getId() + "]"));
                    }
                    if (!connection.getSourceCell().getId().equals(prevCell.getId()) || !connection.isDefaultConnection()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("...... defaultWay = true since sourceCell = [" + prevCell.getId() + "] and defaultConnection"));
                    }
                    defaultWay = true;
                    break;
                }
                prevCell = restCellInstRel.getReviewCycleCell();
                if (!defaultWay) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("... returning desiredNodeEnd [" + desiredNodeEnd.getTimeInMillis() + "] because of !defaultWay"));
                    }
                    return desiredNodeEnd;
                }
                for (ReviewCycleNodeInstanceRelease restNodeInstanceRel : nodeInstances) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("... Processing restNodeInstanceRel [" + restNodeInstanceRel.getId() + "] with isFree = [" + restNodeInstanceRel.getReviewCycleNode().isFree() + "]"));
                    }
                    if (restNodeInstanceRel.getReviewCycleNode().isFree()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("...... #positions [" + restNodeInstanceRel.getReviewCyclePositions().size() + "]; cellIsEndCell [" + restCellInstRel.getReviewCycleCell().isEndCell() + "]; nodeIsEndNode [" + restNodeInstanceRel.getReviewCycleNode().isEndNode() + "]"));
                    }
                    if (restNodeInstanceRel.getReviewCyclePositions().size() <= 0 && (restCellInstRel.getReviewCycleCell().isEndCell() || !restNodeInstanceRel.getReviewCycleNode().isEndNode())) continue;
                    desiredNodeEnd = this.holiCalc.addWorkingDays(desiredNodeEnd, restNodeInstanceRel.getDuration());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Knoten " + TapestryI18nHelper.getLocalizedString(restNodeInstanceRel.getReviewCycleNode().getName()) + " desiredEnd: " + SvgReviewHelper.getDateFormat(this.df, desiredNodeEnd)));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("......... duration [" + restNodeInstanceRel.getDuration() + "], desiredNodeEnd [" + desiredNodeEnd + "], showOnlyCurrentNode [" + this.showOnlyCurrentNode + "]"));
                    }
                    if (this.showOnlyCurrentNode) continue;
                    typeOfEdges = SvgReviewHelper.calculateTypeOfEdges(restNodeInstanceRel.getReviewCycleNode(), "rest ", false);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"analyse remaining cells and nodes");
                        logger.debug((Object)("XnodeStart [" + XnodeStart + "], desiredNodeEnd [" + desiredNodeEnd.getTimeInMillis() + "], height_bar [" + this.height_bar + "], cellColor [" + cellColor + "], nodeDelay [" + nodeDelay + "], typeOfEdges [" + typeOfEdges + "]"));
                    }
                    XnodeStart = this.drawNode(writer, XnodeStart, desiredNodeEnd, this.height_bar / 2.0, this.height_bar, cellColor + "; opacity:0.3", true, restNodeInstanceRel.getDuration(), typeOfEdges);
                }
            }
            if (!restCellInstRel.equals(cellInstanceRelease)) continue;
            start = true;
            prevCell = cellInstanceRelease.getReviewCycleCell();
        }
        return desiredNodeEnd;
    }

    private double drawNode(IMarkupWriter writer, double XstartNode, Calendar endNode, double posCenter, double bHight, String fill, boolean dashed, int duration, int typeEdges) {
        double XendNode = SvgReviewHelper.getXPositionFromDate(this.startAxis, endNode, this.placePerUnit) + this.xStart;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("............ drawNode, XendNode now [" + XendNode + "], input startAxis [" + (this.startAxis != null ? Long.valueOf(this.startAxis.getTimeInMillis()) : "null") + "], endNode [" + (endNode != null ? Long.valueOf(endNode.getTimeInMillis()) : "null") + "], placePerUnit [" + this.placePerUnit + "]"));
        }
        if (XendNode > this.xStart + this.width) {
            XendNode = this.xStart + this.width;
        }
        if (XendNode > this.xStart && XstartNode < this.xStart + this.width) {
            if (XstartNode != XendNode) {
                String style = "fill:" + fill + ";stroke:black;" + (dashed ? "stroke-width:1px;stroke-dasharray:3,2;" : "stroke-width:0.5px;");
                switch (typeEdges) {
                    case 0: {
                        SvgRenderKit.addRec(writer, XstartNode, this.bottom - posCenter - bHight / 2.0, 0.0, 0.0, XendNode - XstartNode, bHight, style, null);
                        break;
                    }
                    case 2: {
                        SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(XstartNode, this.bottom - posCenter - bHight / 2.0, -bHight / 4.0, bHight / 2.0, 0.0, 0.0, XendNode - XstartNode, bHight), style, false, true);
                        break;
                    }
                    case 1: {
                        SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(XstartNode, this.bottom - posCenter - bHight / 2.0, 0.0, 0.0, bHight / 4.0, bHight / 2.0, XendNode - XstartNode, bHight), style, true, false);
                        break;
                    }
                    case 3: {
                        SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(XstartNode, this.bottom - posCenter - bHight / 2.0, -bHight / 4.0, bHight / 2.0, bHight / 4.0, bHight / 2.0, XendNode - XstartNode, bHight), style, false, false);
                        break;
                    }
                    case -3: {
                        SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(XstartNode, this.bottom - posCenter - bHight / 2.0, -bHight / 4.0, bHight / 2.0, -bHight / 4.0, bHight / 2.0, XendNode - XstartNode, bHight), style, false, false);
                    }
                }
            } else {
                SvgRenderKit.addCircle(writer, XstartNode, this.bottom - posCenter, 2.0, "fill:black;");
            }
            if (this.withNodeDurationLabel) {
                SvgRenderKit.addText(writer, XstartNode, this.bottom - posCenter - bHight / 2.0, "font-family:verdana; font-size:8px;", Integer.toString(duration), null);
            }
        }
        return XendNode;
    }

    private void drawEntryNode(IMarkupWriter writer, ReleasedDocument reldoc, ReleasedObjectList objectList, XMLWriter popupWriter, I18n i18n) {
        Calendar popupDeadline;
        double XnodeStart;
        ReviewCycleInstanceRelease cycleInstanceRel;
        int preDuration;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====================================");
            logger.debug((Object)"Called drawEntryNode");
            logger.debug((Object)"====================================");
        }
        int nodesDelay = 0;
        Calendar now = Calendar.getInstance();
        Calendar nodeStart = DateHelper.getCalendar(reldoc.getStartDate());
        if (nodeStart == null) {
            return;
        }
        ReleasedObjectList activeObjectList = reldoc.getDocumentList().getSubProject().getActiveObjectList();
        ReleasedObjectPlanner opRel = this.objectOperations.getReleasedObjectPlannerFromList(reldoc.getObjectPlanner().getId(), activeObjectList.getId());
        if (opRel == null) {
            opRel = this.objectOperations.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(reldoc.getObjectPlanner().getId(), reldoc.getDocumentList().getSubProject().getId());
        }
        if ((preDuration = (cycleInstanceRel = (ReviewCycleInstanceRelease)opRel.getReviewCycleInstance()).getPreDuration()) != 0 && !this.taskOperations.isReversePreduration()) {
            Calendar nodePreStart = this.holiCalc.addWorkingDays(nodeStart, -preDuration);
            double d = XnodeStart = nodePreStart.after(this.startAxis) ? SvgReviewHelper.getXPositionFromDate(this.startAxis, nodePreStart, this.placePerUnit) + this.xStart : this.xStart;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Sonderbalken Vorlaufdauer am Anfang des Pr\u00fcflaufs");
                logger.debug((Object)("XnodeStart [" + XnodeStart + "], nodeStart [" + (nodeStart != null ? Long.valueOf(nodeStart.getTimeInMillis()) : "null") + "], height_bar [" + this.height_bar + "], preDuration [" + preDuration + "]"));
            }
            this.drawNode(writer, XnodeStart, nodeStart, this.height_bar / 2.0, this.height_bar / 2.0, "#ffff00; opacity:0.8;", false, preDuration, -3);
            nodesDelay = this.holiCalc.getWorkingDaysBetween(now, nodePreStart);
            popupDeadline = nodePreStart;
        } else {
            nodesDelay = this.holiCalc.getWorkingDaysBetween(now, nodeStart);
            popupDeadline = nodeStart;
        }
        double d = XnodeStart = nodeStart.after(this.startAxis) ? SvgReviewHelper.getXPositionFromDate(this.startAxis, nodeStart, this.placePerUnit) + this.xStart : this.xStart;
        if (preDuration != 0 && !this.taskOperations.isReversePreduration() && nodeStart.after(this.startAxis)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("addMilestone, XnodeStart [" + XnodeStart + "], bottom [" + this.bottom + "], height [" + this.height + "], height_bar [" + this.height_bar + "]"));
            }
            SvgRenderKit.addMilestone(writer, XnodeStart, this.bottom - this.height / 2.0 + this.height_bar, this.height_bar * 6.0 / 8.0, this.height_bar / 2.0 * 6.0 / 8.0, "fill:#000077;stroke:black;stroke-width:0.5px;");
        }
        if (nodesDelay < 0 && preDuration == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"entryNode is delayed");
                logger.debug((Object)("XnodeStart [" + XnodeStart + "], now [" + now.getTimeInMillis() + "], height_bar [" + this.height_bar + "], nodesDelay [" + nodesDelay + "], xStart [" + this.xStart + "]"));
            }
            XnodeStart = this.drawNode(writer, XnodeStart + (XnodeStart > this.xStart ? this.height_bar / 4.0 * 6.0 / 8.0 : 0.0), now, this.height_bar / 2.0, this.height_bar * 6.0 / 8.0, "#ff0000; opacity:0.5", true, nodesDelay, XnodeStart > this.xStart ? 3 : 1);
            nodeStart = now;
        }
        ArrayList cellInstances = (ArrayList)cycleInstanceRel.getReviewCycleCellInstancesSortedByPosition();
        for (ReviewCycleCellInstance cellInst : cellInstances) {
            String color = cellInst.getReviewCycleCell().getSvgColor();
            ArrayList nodeInstances = (ArrayList)cellInst.getReviewCycleNodeInstancesSortedByPosition();
            for (ReviewCycleNodeInstance nodeInstanceRel : nodeInstances) {
                if (nodeInstanceRel == null || nodeInstanceRel.getReviewCyclePositions().size() <= 0 && (cellInst.getReviewCycleCell().isEndCell() || !nodeInstanceRel.getReviewCycleNode().isEndNode())) continue;
                Calendar nodeEnd = this.holiCalc.addWorkingDays(nodeStart, nodeInstanceRel.getDuration());
                int typeOfEdges = !this.showOnlyCurrentNode ? SvgReviewHelper.calculateTypeOfEdges(nodeInstanceRel.getReviewCycleNode(), "", false) : 3;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"analyse remaining cells and nodes");
                    logger.debug((Object)("XnodeStart [" + XnodeStart + "], nodeEnd [" + (nodeEnd != null ? Long.valueOf(nodeEnd.getTimeInMillis()) : "null") + "], height_bar [" + this.height_bar + "], duration [" + nodeInstanceRel.getDuration() + "], typeOfEdges [" + typeOfEdges + "]"));
                }
                XnodeStart = this.drawNode(writer, XnodeStart, nodeEnd, this.height_bar / 2.0, this.height_bar, color + "; opacity:0.3", true, nodeInstanceRel.getDuration(), typeOfEdges);
                nodeStart = nodeEnd;
                if (!this.showOnlyCurrentNode) continue;
                break;
            }
            if (!this.showOnlyCurrentNode) continue;
            break;
        }
        if (this.withNodeDelayLabelExtended) {
            String nodesDelayStr = "";
            nodesDelayStr = nodesDelay < -1 || nodesDelay > 1 ? nodesDelayStr + (nodesDelay < -1 ? String.format(i18n.tr("vor %s Tagen"), Math.abs(nodesDelay)) : String.format(i18n.tr("in %s Tagen"), Math.abs(nodesDelay))) : nodesDelayStr + (nodesDelay == -1 ? i18n.tr("vor 1 Tag") : (nodesDelay == 1 ? i18n.tr("in 1 Tag") : i18n.tr("heute")));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Case withNodeDelayLabelExtended, xtoDay [" + this.xtoDay + "], bottom [" + this.bottom + "], height_bar [" + this.height_bar + "], nodesDelay [" + nodesDelay + "], nodesDelayStr [" + nodesDelayStr + "]"));
            }
            SvgRenderKit.addText(writer, this.xtoDay - (double)(this.withNodeDelayLabelExtended ? 40 : 20), this.bottom - this.height_bar - 8.0, "font-family:verdana; font-size:12px;" + (nodesDelay < 0 ? "stroke:red;" : "stroke:blue;"), nodesDelayStr, null);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Case NOT withNodeDelayLabelExtended, xtoDay [" + this.xtoDay + "], bottom [" + this.bottom + "], height_bar [" + this.height_bar + "], nodesDelay [" + nodesDelay + "], nodesDelayString [" + Integer.toString(nodesDelay) + "]"));
            }
            SvgRenderKit.addText(writer, this.xtoDay - 20.0, this.bottom - this.height_bar - 8.0, "font-family:verdana; font-size:12px;" + (nodesDelay < 0 ? "stroke:red;" : "stroke:black;"), Integer.toString(nodesDelay), null);
        }
        if (this.showDocumentStatus) {
            this.evalPopupDocumentNodeProgress(popupWriter, popupDeadline, nodesDelay, preDuration, i18n);
        } else {
            this.evalPopupTaskNodeProgress(popupWriter, popupDeadline, nodesDelay, i18n);
        }
    }

    private void drawBackground(IMarkupWriter writer, DocumentsReviewCycleData docCycle, ReleasedDocument reldoc, ReleasedObjectList objectList) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====================================");
            logger.debug((Object)"Called drawBackground");
            logger.debug((Object)"====================================");
        }
        if (docCycle != null && reldoc != null && (reldoc.getStartDate() != null || reldoc.getEndDate() != null)) {
            ReleasedObjectList activeObjectList = reldoc.getDocumentList().getSubProject().getActiveObjectList();
            ReleasedObjectPlanner opRel = this.objectOperations.getReleasedObjectPlannerFromList(reldoc.getObjectPlanner().getId(), activeObjectList.getId());
            if (opRel == null) {
                opRel = this.objectOperations.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(reldoc.getObjectPlanner().getId(), reldoc.getDocumentList().getSubProject().getId());
            }
            ReviewCycleInstanceRelease cycleInstanceRel = (ReviewCycleInstanceRelease)opRel.getReviewCycleInstance();
            this.plannedEnd = DateHelper.getCalendar(reldoc.getEndDate());
            if (this.plannedEnd == null) {
                return;
            }
            if (reldoc.getStartDate() != null) {
                this.plannedStart = DateHelper.getCalendar(reldoc.getStartDate());
            } else {
                this.plannedStart = (Calendar)this.plannedEnd.clone();
                this.plannedStart = this.holiCalc.addWorkingDays(this.plannedStart, -cycleInstanceRel.getDuration());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[drawBackground");
            }
            Calendar extraTime = null;
            int addBuffer = cycleInstanceRel.getDuration() - cycleInstanceRel.getDurationMin();
            if (addBuffer > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("addBuffer " + addBuffer));
                }
                extraTime = this.holiCalc.addWorkingDays(this.plannedEnd, -addBuffer);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("planned End" + SvgReviewHelper.getDateFormat(this.df, this.plannedEnd)));
                logger.debug((Object)("planned End (min duration) " + SvgReviewHelper.getDateFormat(this.df, extraTime)));
            }
            double XplannedEnd = SvgReviewHelper.getXPositionFromDate(this.startAxis, this.plannedEnd, this.placePerUnit) + this.xStart;
            double XextraTimeStart = -1.0;
            if (extraTime != null) {
                XextraTimeStart = SvgReviewHelper.getXPositionFromDate(this.startAxis, extraTime, this.placePerUnit) + this.xStart;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Xplanned End" + XplannedEnd));
            }
            String red = "fill:#ff0000; opacity:0.1;";
            String yellow = "fill:#ffff00; opacity:0.1;";
            String green = "fill:#00ff00; opacity:0.1;";
            if (this.plannedEnd.before(this.startAxis)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"red rectangle, plannedEnd before beginn of time axis");
                    logger.debug((Object)("... xStart [" + this.xStart + "], yStart [" + this.yStart + "], width [" + this.width + "], height [" + this.height + "], red [" + red + "]"));
                }
                SvgRenderKit.addRec(writer, this.xStart, this.yStart, this.width, this.height, red, null);
                this.urgency = 3;
            } else if (extraTime == null) {
                if (this.plannedEnd.before(this.endAxis)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"green + red, planned End within axis, extraTime not defined");
                        logger.debug((Object)("... xStart [" + this.xStart + "], yStart [" + this.yStart + "], width [" + this.width + "], height [" + this.height + "], green [" + green + "]"));
                        logger.debug((Object)("... XplannedEnd [" + XplannedEnd + "]"));
                    }
                    SvgRenderKit.addRec(writer, this.xStart, this.yStart, XplannedEnd - this.xStart, this.height, green, null);
                    SvgRenderKit.addRec(writer, XplannedEnd, this.yStart, this.width - (XplannedEnd - this.xStart), this.height, red, null);
                    this.urgency = 3;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"green");
                        logger.debug((Object)("... xStart [" + this.xStart + "], yStart [" + this.yStart + "], width [" + this.width + "], height [" + this.height + "], green [" + green + "]"));
                    }
                    SvgRenderKit.addRec(writer, this.xStart, this.yStart, this.width, this.height, green, null);
                    this.urgency = 0;
                }
            } else if (this.plannedEnd.after(this.endAxis) && extraTime.before(this.endAxis)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"green + yellow, extraTime within timeaxis, planned end not");
                    logger.debug((Object)("... xStart [" + this.xStart + "], yStart [" + this.yStart + ", XextraTimeStart [" + XextraTimeStart + "], width [" + this.width + "], height [" + this.height + "], green [" + green + "], yellow [" + yellow + "]"));
                }
                SvgRenderKit.addRec(writer, this.xStart, this.yStart, XextraTimeStart - this.xStart, this.height, green, null);
                SvgRenderKit.addRec(writer, XextraTimeStart, this.yStart, this.width - (XextraTimeStart - this.xStart), this.height, yellow, null);
                this.urgency = extraTime.before(Calendar.getInstance()) ? 1 : 0;
            } else if (extraTime.before(this.endAxis)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"extraTime before ending of time axis");
                }
                if (this.plannedEnd.before(this.endAxis)) {
                    if (extraTime.after(this.startAxis)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("green+yellow+red, xStart [" + this.xStart + "], yStart [" + this.yStart + "], XextraTimeStart [" + XextraTimeStart + "], XplannedEnd [" + XplannedEnd + "], width [" + this.width + "], height [" + this.height + "]"));
                            logger.debug((Object)("green [" + green + "], yellow [" + yellow + "], red [" + red + "]"));
                        }
                        SvgRenderKit.addRec(writer, this.xStart, this.yStart, XextraTimeStart - this.xStart, this.height, green, null);
                        SvgRenderKit.addRec(writer, XextraTimeStart, this.yStart, XextraTimeStart - XplannedEnd, this.height, yellow, null);
                        SvgRenderKit.addRec(writer, XplannedEnd, this.yStart, this.width - (XplannedEnd - this.xStart), this.height, red, null);
                        this.urgency = extraTime.before(Calendar.getInstance()) && this.plannedEnd.before(Calendar.getInstance()) ? 3 : (extraTime.before(Calendar.getInstance()) && this.plannedEnd.after(Calendar.getInstance()) ? 1 : 0);
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("yellow+red, xStart [" + this.xStart + "], yStart [" + this.yStart + "], XplannedEnd [" + XplannedEnd + "], width [" + this.width + "], height [" + this.height + "]"));
                            logger.debug((Object)("yellow [" + yellow + "], red [" + red + "]"));
                        }
                        SvgRenderKit.addRec(writer, this.xStart, this.yStart, XplannedEnd - this.xStart, this.height, yellow, null);
                        SvgRenderKit.addRec(writer, XplannedEnd, this.yStart, this.width - (XplannedEnd - this.xStart), this.height, red, null);
                        this.urgency = this.plannedEnd.after(Calendar.getInstance()) ? 1 : 3;
                    }
                } else if (extraTime.after(this.startAxis)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("green+yellow: xStart [" + this.xStart + "], yStart [" + this.yStart + "], XextraTimeStart [" + XextraTimeStart + "], width [" + this.width + "], height [" + this.height + "]"));
                        logger.debug((Object)("green [" + green + "], yellow [" + yellow + "], red [" + red + "]"));
                    }
                    SvgRenderKit.addRec(writer, this.xStart, this.yStart, XextraTimeStart - this.xStart, this.height, green, null);
                    SvgRenderKit.addRec(writer, XextraTimeStart, this.yStart, this.width - (XextraTimeStart - this.xStart), this.height, yellow, null);
                    this.urgency = extraTime.before(Calendar.getInstance()) ? 1 : 0;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("yellow: xStart [" + this.xStart + "], yStart [" + this.yStart + "], width [" + this.width + "], height [" + this.height + "], yellow [" + yellow + "]"));
                    }
                    SvgRenderKit.addRec(writer, this.xStart, this.yStart, this.width, this.height, yellow, null);
                    this.urgency = 1;
                }
            } else if (extraTime.after(this.endAxis)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"green, extraTime after time axis");
                    logger.debug((Object)("... xStart [" + this.xStart + "], yStart [" + this.yStart + "], width [" + this.width + "], height [" + this.height + "], green [" + green + "]"));
                }
                SvgRenderKit.addRec(writer, this.xStart, this.yStart, this.width, this.height, green, null);
                this.urgency = 0;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"extraTime and planned end within timeaxis");
                    logger.debug((Object)("... green+yellow+red, xStart [" + this.xStart + "], yStart [" + this.yStart + "], XextraTimeStart [" + XextraTimeStart + "], XplannedEnd [" + XplannedEnd + "], width [" + this.width + "], height [" + this.height + "]"));
                    logger.debug((Object)("... green [" + green + "], yellow [" + yellow + "], red [" + red + "]"));
                }
                SvgRenderKit.addRec(writer, this.xStart, this.yStart, XextraTimeStart - this.xStart, this.height, green, null);
                SvgRenderKit.addRec(writer, XextraTimeStart, this.yStart, XextraTimeStart - XplannedEnd, this.height, yellow, null);
                SvgRenderKit.addRec(writer, XplannedEnd, this.yStart, this.width - (XplannedEnd - this.xStart), this.height, red, null);
                this.urgency = extraTime.before(Calendar.getInstance()) && this.plannedEnd.before(Calendar.getInstance()) ? 3 : (extraTime.before(Calendar.getInstance()) && this.plannedEnd.after(Calendar.getInstance()) ? 1 : 0);
            }
        } else {
            if (logger.isDebugEnabled()) {
                if (docCycle == null) {
                    logger.debug((Object)"reldoc == null");
                } else {
                    logger.debug((Object)"no start and end date");
                }
                logger.debug((Object)("... xStart [" + this.xStart + "], yStart [" + this.yStart + "], width [" + this.width + "], height [" + this.height + "]"));
            }
            SvgRenderKit.addRec(writer, this.xStart, this.yStart, this.width, this.height, "fill:#ffffff; opacity:0.1; ", null);
        }
    }

    private void evalPopupTaskNodeProgress(XMLWriter writer, Calendar deadline, int remainingTime, I18n i18n) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
        if (this.oOOMode) {
            writer.printRaw(i18n.tr("Termin:") + " " + dateFormat.format(deadline.getTime()));
            if (remainingTime < 0) {
                if (Math.abs(remainingTime) == 1) {
                    writer.printRaw(i18n.tr("\nDie Aufgabe ist 1 Tag versp\u00e4tet"));
                } else {
                    writer.printRaw(String.format(i18n.tr("\nDie Aufgabe ist %s Tage versp\u00e4tet"), Math.abs(remainingTime)));
                }
            } else if (remainingTime == 0) {
                writer.printRaw(i18n.tr("\nDie Aufgabe ist heute zu erledigen"));
            } else if (remainingTime == 1) {
                writer.printRaw(i18n.tr("\nDie Aufgabe ist in 1 Tag zu erledigen"));
            } else {
                writer.printRaw(String.format(i18n.tr("\nDie Aufgabe ist in %s Tagen zu erledigen"), remainingTime));
            }
            return;
        }
        writer.begin("small");
        writer.print(i18n.tr("Termin:") + " ");
        writer.end();
        writer.print("" + dateFormat.format(deadline.getTime()));
        writer.beginEmpty("br");
        if (remainingTime < 0) {
            writer.begin("span");
            writer.attribute("style", "color:red;");
            if (Math.abs(remainingTime) == 1) {
                writer.print(i18n.tr("Die Aufgabe ist 1 Tag versp\u00e4tet"));
            } else {
                writer.print(String.format(i18n.tr("Die Aufgabe ist %s Tage versp\u00e4tet"), Math.abs(remainingTime)));
            }
            writer.end();
        } else if (remainingTime == 0) {
            writer.begin("span");
            writer.attribute("style", "font-weight:bold;");
            writer.print(i18n.tr("Die Aufgabe ist heute zu erledigen"));
            writer.end();
        } else {
            writer.begin("span");
            writer.attribute("style", "font-weight:bold");
            if (remainingTime == 1) {
                writer.print(i18n.tr("Die Aufgabe ist in 1 Tag zu erledigen"));
            } else {
                writer.print(String.format(i18n.tr("Die Aufgabe ist in %s Tagen zu erledigen"), remainingTime));
            }
            writer.end();
        }
    }

    private void evalPopupDocumentNodeProgress(XMLWriter writer, Calendar deadline, int remainingTime, int preDuration, I18n i18n) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
        if (this.oOOMode) {
            writer.printRaw(i18n.tr("Termin:") + " " + dateFormat.format(deadline.getTime()));
            if (remainingTime == 1) {
                writer.printRaw(i18n.tr("Der Uploadzeitpunkt ist 1 Tag vor dem SOLL"));
            } else if (remainingTime == -1) {
                writer.printRaw(i18n.tr("Der Uploadzeitpunkt ist 1 Tag versp\u00e4tet"));
            } else if (remainingTime < -1) {
                writer.printRaw(String.format(i18n.tr("Der Uploadzeitpunkt ist %s Tage versp\u00e4tet"), Math.abs(remainingTime)));
            } else if (remainingTime > 1) {
                writer.printRaw(String.format(i18n.tr("Der Uploadzeitpunkt ist %s Tage vor dem SOLL"), Math.abs(remainingTime)));
            }
            if (preDuration != 0) {
                if (!this.taskOperations.isReversePreduration()) {
                    writer.printRaw(String.format(preDuration == 1 ? i18n.tr("Vorlaufdauer %s Tag") : i18n.tr("Vorlaufdauer %s Tage"), Math.abs(preDuration)));
                } else {
                    writer.printRaw(String.format(preDuration == 1 ? i18n.tr("Pufferzeit %s Tag") : i18n.tr("Pufferzeit %s Tage"), Math.abs(preDuration)));
                }
            }
            return;
        }
        writer.begin("small");
        writer.print(i18n.tr("Termin:") + " ");
        writer.end();
        writer.print("" + dateFormat.format(deadline.getTime()));
        writer.beginEmpty("br");
        if (remainingTime < 0 || remainingTime >= 0 && remainingTime <= 3) {
            writer.begin("span");
            writer.attribute("style", remainingTime < 0 ? "color:red;" : "font-weight:bold;");
            if (remainingTime == 1) {
                writer.print(i18n.tr("Der Uploadzeitpunkt ist 1 Tag vor dem SOLL"));
            } else if (remainingTime == -1) {
                writer.print(i18n.tr("Der Uploadzeitpunkt ist 1 Tag versp\u00e4tet"));
            } else if (remainingTime < 1) {
                writer.print(String.format(i18n.tr("Der Uploadzeitpunkt ist %s Tage versp\u00e4tet"), Math.abs(remainingTime)));
            } else {
                writer.print(String.format(i18n.tr("Der Uploadzeitpunkt ist %s Tage vor dem SOLL"), remainingTime));
            }
            writer.end();
        } else {
            writer.print(String.format(i18n.tr("Der Uploadzeitpunkt ist %s Tage vor dem SOLL"), Math.abs(remainingTime)));
        }
        if (preDuration != 0) {
            writer.beginEmpty("br");
            if (!this.taskOperations.isReversePreduration()) {
                writer.printRaw(String.format(preDuration == 1 ? i18n.tr("Vorlaufdauer %s Tag") : i18n.tr("Vorlaufdauer %s Tage"), Math.abs(preDuration)));
            } else {
                writer.printRaw(String.format(preDuration == 1 ? i18n.tr("Pufferzeit %s Tag") : i18n.tr("Pufferzeit %s Tage"), Math.abs(preDuration)));
            }
        }
    }

    private void evalPopupCycleProgress(XMLWriter writer, Date docStartDate, Date docEndDate, int overallDelay, String actualReviewCycleCellName, String actualReviewCycleNodeName, boolean showCurrentPosition, boolean showOnlyPDCSchedule, I18n i18n) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
        String targetDeadline = i18n.tr("nicht definiert");
        if (docStartDate != null) {
            targetDeadline = dateFormat.format(docStartDate);
        }
        targetDeadline = docEndDate != null ? targetDeadline + " " + i18n.tr("bis") + " " + dateFormat.format(docEndDate) : targetDeadline + " " + i18n.tr("bis nicht definiert");
        if (this.oOOMode) {
            writer.printRaw(String.format(i18n.tr("\nSOLL Termine Planlieferkatalog\n%s"), targetDeadline));
            if (showOnlyPDCSchedule) {
                return;
            }
            if (docEndDate != null) {
                if (overallDelay == 0) {
                    writer.printRaw(i18n.tr("\nDer Pr\u00fcflauf ist im SOLL."));
                } else if (overallDelay == -1) {
                    writer.printRaw(i18n.tr("\nDer Pr\u00fcflauf ist 1 Tag versp\u00e4tet"));
                } else if (overallDelay == 1) {
                    writer.printRaw(i18n.tr("\nDer Pr\u00fcflauf ist 1 Tag vor dem SOLL"));
                } else if (overallDelay < -1) {
                    writer.printRaw(String.format(i18n.tr("\nDer Pr\u00fcflauf ist %s Tage versp\u00e4tet"), Math.abs(overallDelay)));
                } else {
                    writer.printRaw(String.format(i18n.tr("\nDer Pr\u00fcflauf ist %s Tage vor dem SOLL"), overallDelay));
                }
            } else {
                writer.printRaw(i18n.tr("\nkein Endtermin vereinbart"));
            }
            return;
        }
        writer.beginEmpty("br");
        writer.print(i18n.tr("SOLL Termine Planlieferkatalog"));
        writer.beginEmpty("br");
        writer.print("" + targetDeadline);
        if (showOnlyPDCSchedule) {
            return;
        }
        if (docEndDate != null) {
            writer.beginEmpty("br");
            if (overallDelay == 0) {
                writer.printRaw(i18n.tr("\nDer Pr\u00fcflauf ist im SOLL."));
            } else if (overallDelay == -1) {
                writer.printRaw(i18n.tr("\nDer Pr\u00fcflauf ist 1 Tag versp\u00e4tet"));
            } else if (overallDelay == 1) {
                writer.printRaw(i18n.tr("\nDer Pr\u00fcflauf ist 1 Tag vor dem SOLL"));
            } else if (overallDelay < -1) {
                writer.printRaw(String.format(i18n.tr("\nDer Pr\u00fcflauf ist %s Tage versp\u00e4tet"), Math.abs(overallDelay)));
            } else {
                writer.printRaw(String.format(i18n.tr("\nDer Pr\u00fcflauf ist %s Tage vor dem SOLL"), overallDelay));
            }
        } else {
            writer.beginEmpty("br");
            writer.print(i18n.tr("\nkein Endtermin vereinbart"));
        }
    }

    private void evalPopupActions(XMLWriter writer, Calendar optimalDeadline, Calendar deadline, int urgency, String nodeName, I18n i18n) {
        if (urgency == 0) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
        if (this.oOOMode) {
            writer.printRaw(i18n.tr("\nMa\u00dfnahmen:"));
            if (nodeName == null) {
                if (urgency == 1 || urgency == 2) {
                    writer.printRaw(String.format(i18n.tr("Termin durch verk\u00fcrzte Pr\u00fcfung einzuhalten.\nDie Aufgabe sollte bis zum %s erledigt werden"), dateFormat.format(optimalDeadline.getTime())));
                } else if (urgency == 3) {
                    writer.printRaw(i18n.tr("Termin nicht mehr einzuhalten"));
                }
            } else if (urgency == 1 || urgency == 2) {
                writer.print(String.format(i18n.tr("Termin durch verk\u00fcrzte Pr\u00fcfung einzuhalten.\n%s sollte bis zum %s erledigt werden"), nodeName, dateFormat.format(optimalDeadline.getTime())));
            } else if (urgency == 3) {
                writer.printRaw(i18n.tr("Termin nicht mehr einzuhalten"));
            }
            return;
        }
        writer.beginEmpty("br");
        writer.print(i18n.tr("Ma\u00dfnahmen:"));
        if (nodeName == null) {
            if (urgency == 1 || urgency == 2) {
                writer.print(i18n.tr("Termin durch verk\u00fcrzte Pr\u00fcfung einzuhalten."));
                writer.beginEmpty("br");
                writer.print(String.format(i18n.tr("Die Aufgabe sollte bis zum %s erledigt werden"), dateFormat.format(optimalDeadline.getTime())));
            } else if (urgency == 3) {
                writer.print(i18n.tr("Termin nicht mehr einzuhalten"));
            }
        } else if (urgency == 1 || urgency == 2) {
            writer.print(i18n.tr("Termin durch verk\u00fcrzte Pr\u00fcfung einzuhalten."));
            writer.beginEmpty("br");
            writer.begin("i");
            writer.print(nodeName);
            writer.end();
            writer.print(String.format(i18n.tr(" sollte bis zum %s erledigt werden"), dateFormat.format(optimalDeadline.getTime())));
        } else if (urgency == 3) {
            writer.print(i18n.tr("Termin nicht mehr einzuhalten"));
        }
    }

    private void evalPopupDocumentVersionStatus(XMLWriter writer, DocumentVersion docVersion, I18n i18n) {
        ReviewCycleNodeInstanceImpl nodeInstance = null;
        ReviewCycleNodeInstanceRelease rel = null;
        List<ReviewCyclePosition> allPositions = null;
        Collection<Object> allPositionResults = new ArrayList();
        ArrayList<ReviewCyclePositionResult> signedPositionResults = null;
        ArrayList<ReviewCyclePosition> openPositions = null;
        try {
            nodeInstance = docVersion.getActualReviewCycleNodeInstance();
            rel = this.reviewOperations.getReviewCycleNodeInstanceRelease(nodeInstance.getReviewCycleNode(), docVersion.getDocument());
            allPositions = this.reviewOperations.getReviewRelevantPositions(rel, docVersion);
            ReviewCycleNodeResult nodeResult = this.reviewOperations.getReviewCycleNodeResult(nodeInstance.getReviewCycleNode(), docVersion);
            if (nodeResult != null && nodeResult.getReviewCycleNodePositionResults() != null) {
                allPositionResults = nodeResult.getReviewCycleNodePositionResults().values();
            }
            signedPositionResults = new ArrayList<ReviewCyclePositionResult>();
            openPositions = new ArrayList<ReviewCyclePosition>();
        }
        catch (Exception e) {
            logger.error((Object)("Caught exception: nodeInstance = [" + (nodeInstance == null ? "null" : nodeInstance.getId()) + "]; rel = [" + (rel == null ? "null" : rel.getId()) + "]; docVersion = [" + (docVersion == null ? "null" : docVersion.getId()) + "]"), (Throwable)e);
            throw e;
        }
        for (ReviewCyclePositionResult reviewCyclePositionResult : allPositionResults) {
            if (reviewCyclePositionResult.getSignature() == null || reviewCyclePositionResult.getReviewCycleResultOption() == null || reviewCyclePositionResult.getReviewCycleResultOption().getValue() <= -9) continue;
            signedPositionResults.add(reviewCyclePositionResult);
        }
        for (ReviewCyclePosition reviewCyclePosition : allPositions) {
            boolean isOpen = true;
            for (ReviewCyclePositionResult res : signedPositionResults) {
                if (!res.getRealm().getId().equals(reviewCyclePosition.getRealm().getId()) || !res.getProjectParticipant().getParticipation().getId().equals(reviewCyclePosition.getProjectParticipation().getId())) continue;
                isOpen = false;
                break;
            }
            if (!isOpen) continue;
            openPositions.add(reviewCyclePosition);
        }
        Integer totalPositions = signedPositionResults.size() + openPositions.size();
        if (this.oOOMode) {
            if (!this.currentPositionShown) {
                writer.printRaw(String.format(i18n.tr("\nderzeitiger Aufenthalt: %s - %s"), TapestryI18nHelper.getLocalizedString(docVersion.getActualReviewCycleNode().getReviewCycleCell().getName()), TapestryI18nHelper.getLocalizedString(docVersion.getActualReviewCycleNode().getName())));
            }
            if (!nodeInstance.getReviewCycleNode().isEndNode()) {
                if (openPositions.size() != 0 || signedPositionResults.size() != 0) {
                    if (openPositions.size() == totalPositions.intValue()) {
                        if (totalPositions == 1) {
                            writer.printRaw(i18n.tr("1 Pr\u00fcfung offen"));
                        } else {
                            writer.printRaw(String.format(i18n.tr("Alle (%s) Pr\u00fcfungen offen"), openPositions.size()));
                        }
                    } else {
                        writer.printRaw(String.format(i18n.tr("%s von %s Pr\u00fcfungen offen"), openPositions.size(), totalPositions));
                    }
                } else {
                    writer.print("\n (-)");
                }
            }
            if (openPositions.size() != 0) {
                this.evalReviewers(writer, openPositions, i18n);
            }
            return;
        }
        writer.beginEmpty("hr");
        if (!this.currentPositionShown) {
            writer.begin("small");
            writer.print(i18n.tr("derzeitiger Aufenthalt:"));
            writer.end();
            writer.beginEmpty("br");
            writer.print(TapestryI18nHelper.getLocalizedString(TapestryI18nHelper.getLocalizedString(docVersion.getActualReviewCycleNode().getReviewCycleCell().getName())) + " - " + TapestryI18nHelper.getLocalizedString(docVersion.getActualReviewCycleNode().getName()));
        }
        if (!nodeInstance.getReviewCycleNode().isEndNode()) {
            if (openPositions.size() != 0 || signedPositionResults.size() != 0) {
                writer.beginEmpty("br");
                if (openPositions.size() == totalPositions.intValue()) {
                    if (totalPositions == 1) {
                        writer.printRaw(i18n.tr("1 Pr\u00fcfung offen"));
                    } else {
                        writer.printRaw(String.format(i18n.tr("Alle (%s) Pr\u00fcfungen offen"), openPositions.size()));
                    }
                } else {
                    writer.printRaw(String.format(i18n.tr("%s von %s Pr\u00fcfungen offen"), openPositions.size(), totalPositions));
                }
            } else {
                writer.print(" (-)");
            }
        }
        if (openPositions.size() != 0) {
            this.evalReviewers(writer, openPositions, i18n);
        }
    }

    private void evalReviewers(XMLWriter writer, List<ReviewCyclePosition> openPositions, I18n i18n) {
        if (!this.oOOMode) {
            writer.beginEmpty("br");
            writer.begin("small");
        }
        writer.print(i18n.tr("Projektteilnehmer mit offenen Pr\u00fcfungen:"));
        if (!this.oOOMode) {
            writer.end();
        }
        HashMap<Integer, ProjectParticipation> participations = new HashMap<Integer, ProjectParticipation>();
        for (ReviewCyclePosition pos : openPositions) {
            participations.put(pos.getProjectParticipation().getId(), pos.getProjectParticipation());
        }
        for (Integer i : participations.keySet()) {
            if (!this.oOOMode) {
                writer.beginEmpty("br");
            } else {
                writer.printRaw("\n");
            }
            writer.print("- " + ((ProjectParticipation)participations.get(i)).getOrganisation().getName() + " (" + ((ProjectParticipation)participations.get(i)).getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + ")");
        }
    }

    private void evalPlanner(XMLWriter writer, DocumentTask task, ObjectPlanner op, I18n i18n) {
        if (this.oOOMode) {
            writer.printRaw(i18n.tr("\nPlaner: "));
        } else {
            writer.beginEmpty("br");
            writer.begin("small");
            writer.print(i18n.tr("Planer: "));
            writer.end();
        }
        if (task != null) {
            ProjectParticipation taskPp = null;
            taskPp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
            writer.print(taskPp.getOrganisation().getName() + " (" + taskPp.getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + ")");
        } else {
            ProjectParticipation docPp = op.getPlanner();
            if (docPp != null) {
                writer.print(docPp.getOrganisation().getName() + " (" + docPp.getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + ")");
            } else {
                writer.print(i18n.tr("nicht definiert"));
            }
        }
    }
}

