/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SvnVersion {
    public static long processXmlEntries(String path) throws SAXException, TransformerException, IOException {
        FileInputStream is = new FileInputStream(path);
        DOMResult result = new DOMResult();
        InputSource source = new InputSource(is);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://xml.org/sax/features/validation", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SAXSource src = new SAXSource(reader, source);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(src, result);
        Document doc = (Document)result.getNode();
        Element root = doc.getDocumentElement();
        for (Node n = root.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.getNodeName().equals("entry") || !n.getAttributes().getNamedItem("name").getNodeValue().equals("")) continue;
            return Long.valueOf(n.getAttributes().getNamedItem("committed-rev").getNodeValue());
        }
        throw new IOException("Directory entry not found in file " + path);
    }

    static long processNewASCII(InputStream is) throws IOException {
        Scanner scanner = new Scanner(is, "ISO-8859-1");
        scanner.nextLine();
        scanner.nextLine();
        scanner.nextLine();
        return scanner.nextLong();
    }

    public static long processDirectory(String dir) throws IOException, TransformerException, SAXException {
        String path = dir + File.separator + ".svn" + File.separator + "entries";
        FileInputStream fis = new FileInputStream(path);
        fis.mark(65536);
        int c = fis.read();
        if (c >= 48 && c <= 57) {
            return SvnVersion.processNewASCII(fis);
        }
        fis.close();
        return SvnVersion.processXmlEntries(path);
    }

    public static void main(String[] args) {
        try {
            String fileName = args[args.length - 1];
            FileOutputStream outputStream = new FileOutputStream(fileName);
            PrintStream printStream = new PrintStream((OutputStream)outputStream, false, "UTF-8");
            for (int i = 0; i < args.length - 1; ++i) {
                if (args[i].equals("--date")) {
                    SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    printStream.println("date=" + f.format(new Date()));
                    continue;
                }
                if (args[i].equals("--version")) {
                    printStream.println("version=" + args[++i]);
                    continue;
                }
                printStream.println("release=" + SvnVersion.processDirectory(args[i]));
            }
            printStream.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(127);
        }
    }
}

