/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.db.SchemaUpdateSnippet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.util.lang.Pair;

public class SchemaUpdate_0_xxxFUTURE
implements SchemaUpdateSnippet {
    protected static final Logger logger = Logger.getLogger(SchemaUpdate_0_xxxFUTURE.class);

    @Override
    public String getTargetVersion() {
        return "0.188";
    }

    @Override
    public String getUpdateComment() {
        return "add column review_cycle_instance_released_id to table document_version and update existing entries";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        int lastSigId = 0;
        int sigcount = 0;
        logger.info((Object)"##################  start update on table SIGNATURE  ####################");
        while (true) {
            Statement selectSig;
            ResultSet sigRs;
            if (!(sigRs = (selectSig = schemaEngine.getConnection().createStatement()).executeQuery("select id, content from signature where id>" + lastSigId + " and time like '200_-__-__ 00:00:00' order by id LIMIT 100")).first()) break;
            sigRs.beforeFirst();
            logger.info((Object)("fetched SIGNATURE currently 100 from id=[" + lastSigId + "] - already fetched " + sigcount));
            while (sigRs.next()) {
                int sigId;
                ++sigcount;
                Blob contentBlob = sigRs.getBlob("content");
                lastSigId = sigId = sigRs.getInt("id");
                String content = this.getContentString(contentBlob.getBinaryStream());
                StringTokenizer tok = new StringTokenizer(content, "\n");
                String dateString = "";
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (!token.contains("date")) continue;
                    String[] ds = token.split(" ");
                    dateString = ds[1] + " " + ds[2];
                    break;
                }
                if (dateString.length() > 1) {
                    Statement statement = schemaEngine.getConnection().createStatement();
                    String sqlStatement = "UPDATE signature set time='" + dateString + "' where id=" + sigId;
                    statement.execute(sqlStatement);
                    statement.close();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("-> updated signature with id=[" + sigId + "] date to [" + dateString + "]"));
                    continue;
                }
                logger.error((Object)("ERROR: signature with id=[" + sigId + "] could not be updated! No date found in content blob.."));
            }
            sigRs.close();
            selectSig.close();
        }
        logger.info((Object)"##################  finished update on table SIGNATURE  ####################");
        logger.info((Object)"##################  start update on table DOCUMENT_VERSION  ####################");
        TableInfo ti = schemaEngine.fetchTableInfo("document_version", null);
        schemaEngine.addColumn(ti, new ColumnInfo("review_cycle_instance_release_id", 4, Integer.valueOf(20), null, false, "0"));
        schemaEngine.commit();
        int lastId = 0;
        int docCount = 0;
        block8: while (true) {
            Statement selectDV;
            ResultSet dvRs;
            if (!(dvRs = (selectDV = schemaEngine.getConnection().createStatement()).executeQuery("select id, document_id, uploaded, name from document_version where id>" + lastId + " order by id LIMIT 1000")).first()) {
                logger.info((Object)("updating document_versions: finished iterating through document_versions, passed " + docCount));
                return;
            }
            dvRs.beforeFirst();
            logger.info((Object)("updating document_versions: fetching 1000 from id=[" + lastId + "] - already passed:[" + docCount + "]"));
            PreparedStatement selectDocument = schemaEngine.getConnection().prepareStatement("select id, object_planner_id from document where id=?");
            PreparedStatement selectObjectPlanner = schemaEngine.getConnection().prepareStatement("select id, object_id, review_cycle_instance_id from object_planner where id=?");
            PreparedStatement selectObject = schemaEngine.getConnection().prepareStatement("select id, object_list_id from object where id=?");
            PreparedStatement selectObjectListsReleased = schemaEngine.getConnection().prepareStatement("select id, signature_id from object_list_release where object_list_id=?");
            PreparedStatement selectSignature = schemaEngine.getConnection().prepareStatement("select id, time from signature where id=? order by time");
            PreparedStatement selectReleasedObject = schemaEngine.getConnection().prepareStatement("select id from object_release where object_list_release_id=? and object_id=?");
            PreparedStatement selectReleasedObjectPlanner = schemaEngine.getConnection().prepareStatement("select id, review_cycle_instance_id from object_planner_release where object_planner_id=? and object_id=?");
            PreparedStatement selectReviewCycleInstanceRelease = schemaEngine.getConnection().prepareStatement("select review_cycle_instance_id from review_cycle_instance_released where id=?");
            Calendar c = Calendar.getInstance();
            try {
                while (true) {
                    int documentVersionId;
                    if (!dvRs.next()) continue block8;
                    int documentId = dvRs.getInt("document_id");
                    lastId = documentVersionId = dvRs.getInt("id");
                    Timestamp dvUploaded = dvRs.getTimestamp("uploaded", c);
                    selectDocument.setInt(1, documentId);
                    ResultSet docRs = selectDocument.executeQuery();
                    docRs.first();
                    int objectPlannerId = docRs.getInt("object_planner_id");
                    docRs.close();
                    selectObjectPlanner.setInt(1, objectPlannerId);
                    ResultSet opRs = selectObjectPlanner.executeQuery();
                    opRs.first();
                    int objectId = opRs.getInt("object_id");
                    int reviewCycleInstanceId = opRs.getInt("review_cycle_instance_id");
                    opRs.close();
                    selectObject.setInt(1, objectId);
                    ResultSet oRs = selectObject.executeQuery();
                    oRs.first();
                    int objectListId = oRs.getInt("object_list_id");
                    oRs.close();
                    selectObjectListsReleased.setInt(1, objectListId);
                    ResultSet relOLRs = selectObjectListsReleased.executeQuery();
                    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    Pair resultOlist = new Pair();
                    String bestDateLog = "\n  ==>result: dvdate=[" + sdf.format(dvUploaded) + "]";
                    String earlierDates = "\n  ==>earlier dates:";
                    String laterDates = "\n  ==>later dates:";
                    while (relOLRs.next()) {
                        int objectListReleaseId = relOLRs.getInt("id");
                        int signatureId = relOLRs.getInt("signature_id");
                        selectSignature.setInt(1, signatureId);
                        ResultSet sigRs = selectSignature.executeQuery();
                        sigRs.first();
                        Timestamp releaseDate = sigRs.getTimestamp(2, c);
                        if (releaseDate != null && releaseDate.before(dvUploaded) && (resultOlist.getSecond() == null || ((Timestamp)resultOlist.getSecond()).before(releaseDate))) {
                            resultOlist.setFirst((Object)objectListReleaseId);
                            resultOlist.setSecond((Object)releaseDate);
                            earlierDates = earlierDates + ">[(" + sdf.format(releaseDate) + ")+(" + objectListReleaseId + ")]";
                        } else {
                            laterDates = laterDates + "<[(" + (releaseDate != null ? sdf.format(releaseDate) : "NULL") + ")+(" + objectListReleaseId + ")]";
                        }
                        sigRs.close();
                    }
                    bestDateLog = bestDateLog + "final result date=[(" + (resultOlist.getSecond() != null ? sdf.format((Date)resultOlist.getSecond()) : "NULL") + ")+(" + resultOlist.getFirst() + ")]";
                    if (dvUploaded.before((Timestamp)resultOlist.getSecond())) {
                        logger.error((Object)("\n############ ERROR: Compared dates are wrong! ->[" + bestDateLog + earlierDates + laterDates + "\n] DocumentVersion with id=[" + documentVersionId + "] not updated!"));
                    }
                    if (++docCount % 1000 == 0 && logger.isDebugEnabled()) {
                        logger.debug((Object)("DEBUG: showing random documentVersion - dv=[" + documentVersionId + "] document=[" + documentId + "] objectPlanner=[" + objectPlannerId + "] object=[" + objectId + "] reviewCycleInstance=[" + reviewCycleInstanceId + "] \ncalculated date: " + bestDateLog + earlierDates + laterDates));
                    }
                    if (resultOlist.getFirst() != null && resultOlist.getSecond() != null) {
                        selectReleasedObject.setInt(1, (Integer)resultOlist.getFirst());
                        selectReleasedObject.setInt(2, objectId);
                        ResultSet relORs = selectReleasedObject.executeQuery();
                        if (relORs.first()) {
                            int releasedObjectId = relORs.getInt("id");
                            selectReleasedObjectPlanner.setInt(1, objectPlannerId);
                            selectReleasedObjectPlanner.setInt(2, releasedObjectId);
                            ResultSet relOPRs = selectReleasedObjectPlanner.executeQuery();
                            if (relOPRs.first()) {
                                int releasedObjectPlannerId = relOPRs.getInt("id");
                                int reviewCycleInstanceReleaseId = relOPRs.getInt("review_cycle_instance_id");
                                selectReviewCycleInstanceRelease.setInt(1, reviewCycleInstanceReleaseId);
                                ResultSet rcirRs = selectReviewCycleInstanceRelease.executeQuery();
                                if (rcirRs.first()) {
                                    int rcirToRciId = rcirRs.getInt("review_cycle_instance_id");
                                    if (rcirToRciId != reviewCycleInstanceId) {
                                        logger.warn((Object)("WARNING: reviewCycleInstanceRelease points to another reviewCycleInstance than the documentVersion! a detached copy of a reviewCycleInstance? rcir=[" + reviewCycleInstanceReleaseId + "] rci=[" + reviewCycleInstanceId + "] docVersion=[" + documentVersionId + "] " + bestDateLog + earlierDates + laterDates));
                                    }
                                    Statement statement = schemaEngine.getConnection().createStatement();
                                    String sqlStatement = "UPDATE document_version set review_cycle_instance_release_id=" + reviewCycleInstanceReleaseId + " where id=" + documentVersionId;
                                    statement.execute(sqlStatement);
                                    statement.close();
                                } else {
                                    logger.error((Object)("ERROR: ResultSet of selectReviewCycleInstanceRelease is empty! DocumentVersion with id=[" + documentVersionId + "] not updated! releaseObjectId=[" + releasedObjectId + "] releasedObjectPlannerId=[" + releasedObjectPlannerId + "] released_object_list_id=[" + resultOlist.getFirst() + "] " + bestDateLog + earlierDates + laterDates));
                                }
                                rcirRs.close();
                            } else {
                                logger.error((Object)("ERROR: ResultSet of selectReleasedObjectPlanner is empty! DocumentVersion with id=[" + documentVersionId + "] not updated! releaseObjectId=[" + releasedObjectId + "] released_object_list_id=[" + resultOlist.getFirst() + "] " + bestDateLog + earlierDates + laterDates));
                            }
                            relOPRs.close();
                        } else {
                            logger.error((Object)("ERROR: ResultSet of selectReleasedObject is empty! DocumentVersion with id=[" + documentVersionId + "] not updated! released_object_list_id=[" + resultOlist.getFirst() + "] objectId=[" + objectId + "] " + bestDateLog + earlierDates + laterDates));
                        }
                        relORs.close();
                        continue;
                    }
                    logger.error((Object)("ERROR updating documentVersion: id=[" + documentVersionId + "], releasedObjectListId=[" + resultOlist.getFirst() + "] releaseDate=[" + (resultOlist.getSecond() != null ? sdf.format((Date)resultOlist.getSecond()) : "null") + "] object_list_impl_id=[" + objectListId + "] " + bestDateLog + earlierDates + laterDates));
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                dvRs.close();
                selectDV.close();
                selectDocument.close();
                selectObjectPlanner.close();
                selectObject.close();
                selectObjectListsReleased.close();
                selectSignature.close();
                selectReviewCycleInstanceRelease.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

