/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class StringBlobType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Blob blob = rs.getBlob(names[0]);
        if (blob == null) {
            return new String();
        }
        try {
            return new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HibernateException("Fatal: UTF-8 no supported.", (Throwable)e);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        String s = (String)value;
        if (s == null || s.length() == 0) {
            st.setNull(index, 2004);
            return;
        }
        try {
            st.setBytes(index, ((String)value).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new HibernateException("Fatal: UTF-8 no supported.", (Throwable)e);
        }
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        String string = value.toString();
        byte[] bytes = string.getBytes();
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return new String(result);
    }

    public boolean isMutable() {
        return true;
    }

    public int hashCode(Object arg0) throws HibernateException {
        throw new HibernateException("HashCode in BinaryBlob is called");
    }

    public Serializable disassemble(Object arg) throws HibernateException {
        if (arg == null) {
            return null;
        }
        String string = (String)arg;
        String result = new String(string);
        return result;
    }

    public Object assemble(Serializable arg0, Object arg1) throws HibernateException {
        if (arg0 == null) {
            return null;
        }
        String string = (String)((Object)arg0);
        String result = new String(string);
        return result;
    }

    public Object replace(Object arg0, Object arg1, Object arg2) throws HibernateException {
        return arg0;
    }
}

