/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.ext.preview.AbstractDocumentVersionMimeSource;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class CompareDocumentVersionPngMimeSource
extends AbstractDocumentVersionMimeSource {
    @Override
    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        int angle2;
        int angle1;
        Integer id1 = (Integer)parameters[0];
        Integer id2 = (Integer)parameters[1];
        Integer pixel_sz = (Integer)parameters[2];
        DocumentVersion dv1 = this.getDocumentVersionDAO().get(id1);
        DocumentVersion dv2 = this.getDocumentVersionDAO().get(id2);
        if (!(dv1.getDocument().getId().equals(dv2.getDocument().getId()) || ((DocumentImpl)dv1.getDocument()).getAsBuiltReference() != null && ((DocumentImpl)dv1.getDocument()).getAsBuiltReference().getId().equals(dv2.getDocument().getId()) || ((DocumentImpl)dv2.getDocument()).getAsBuiltReference() != null && ((DocumentImpl)dv2.getDocument()).getAsBuiltReference().getId().equals(dv1.getDocument().getId()))) {
            throw new IOError("The two document versions belong to different documents.");
        }
        boolean antialias = false;
        Double resolution = null;
        if (parameters[3] instanceof Boolean) {
            double xsize2;
            double ysize2;
            angle1 = parameters.length > 4 ? ((Integer)parameters[4]).intValue() : dv1.getPreviewRotation();
            int da = dv2.getPreviewRotation() - dv1.getPreviewRotation();
            angle2 = angle1 + da;
            double xsize1 = dv1.getUrx() - dv1.getLlx();
            double ysize1 = dv1.getUry() - dv1.getLly();
            switch ((da + 360) / 90 % 4) {
                case 1: 
                case 3: {
                    ysize2 = dv2.getUrx() - dv2.getLlx();
                    xsize2 = dv2.getUry() - dv2.getLly();
                    break;
                }
                default: {
                    xsize2 = dv2.getUrx() - dv2.getLlx();
                    ysize2 = dv2.getUry() - dv2.getLly();
                }
            }
            double xsize = Math.max(xsize1, xsize2);
            double ysize = Math.max(ysize1, ysize2);
            double xres = 72.0 * (double)pixel_sz.intValue() / xsize;
            double yres = 72.0 * (double)pixel_sz.intValue() / ysize;
            resolution = Math.min(xres, yres);
        } else {
            angle1 = (Integer)parameters[3];
            angle2 = (Integer)parameters[4];
            if (parameters.length > 5) {
                antialias = (Boolean)parameters[5];
            }
        }
        FileMimeInputStream stream1 = null;
        FileMimeInputStream stream2 = null;
        try {
            File file1 = this.getFileFinder().findFile(dv1.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique1 = this.getFileFinder().makeUniqueName(dv1.getFileName(), CDESFileRepository.PLANREPOSITORY);
            stream1 = new FileMimeInputStream(file1, unique1, dv1.getName() + "." + dv1.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv1.getFileName()));
            File file2 = this.getFileFinder().findFile(dv2.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique2 = this.getFileFinder().makeUniqueName(dv2.getFileName(), CDESFileRepository.PLANREPOSITORY);
            stream2 = new FileMimeInputStream(file2, unique2, dv2.getName() + "." + dv2.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv2.getFileName()));
            IHPGLRenderer renderer = this.getHpglRenderer();
            IMimeInputStream ret = resolution == null ? renderer.comparePngByPixelSize((IMimeInputStream)stream2, angle2, (IMimeInputStream)stream1, angle1, pixel_sz.intValue(), antialias) : renderer.comparePngByResolution((IMimeInputStream)stream2, angle2, (IMimeInputStream)stream1, angle1, resolution.doubleValue(), antialias);
            IMimeInputStream iMimeInputStream = ret;
            return iMimeInputStream;
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the documentversion", (Throwable)e);
        }
        finally {
            if (stream1 != null) {
                stream1.close();
            }
            if (stream2 != null) {
                stream2.close();
            }
        }
    }
}

