/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.ext.preview.AbstractDocumentVersionPdfMimeSource;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PDFProperty;
import at.cdes.preview.api.PDFPropertyType;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.UnsupportedDataTypeException;
import org.xnap.commons.i18n.I18n;

public class DocumentVersionCustomLabelPdfMimeSource
extends AbstractDocumentVersionPdfMimeSource {
    @Override
    protected List<PDFProperty> getPDFProperties(DocumentVersion dv, Object[] parameters, I18n i18n) throws UnsupportedDataTypeException {
        ArrayList<PDFProperty> ret = new ArrayList<PDFProperty>();
        ret.add(new PDFProperty(PDFPropertyType.ANNOTATION, i18n.tr("Automatisch generiert durch die Planpr\u00fcfplattform c.des")));
        return ret;
    }

    @Override
    public List<Annotation> getAnnotations(DocumentVersion documentVersion, Object[] parameters) throws PreviewException, IOException {
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        List customTextFields = (List)parameters[1];
        List customTextFieldValues = (List)parameters[2];
        if (documentVersion.getLabelContentId() != null) {
            LabelContent label = this.getLabelOperations().getLabelContent(documentVersion.getLabelContentId());
            byte[] fdf_data = this.getLabelOperations().formatFDFCustomLabel(documentVersion, customTextFieldValues, customTextFields, true);
            ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, (double)documentVersion.getUploaded().getTime(), label.getName(), "application/vnd.fdf");
            ret.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
        }
        return ret;
    }

    @Override
    public boolean needPDFPostProcessing(DocumentVersion documentVersion, Object[] parameters) {
        if (super.needPDFPostProcessing(documentVersion, parameters)) {
            return true;
        }
        return documentVersion.getLabelContentId() != null;
    }
}

