/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.order.OrderAddress;
import at.cdes.bo.data.order.OrderStep;
import at.cdes.bo.data.order.OrderStepImpl;
import at.cdes.bo.data.order.orig.OriginalDocumentOrder;
import at.cdes.bo.data.order.orig.OriginalDocumentOrderItem;
import at.cdes.bo.data.order.plott.PlottOrder;
import at.cdes.bo.data.order.plott.PlottOrderItem;
import at.cdes.bo.data.order.plott.PlottOrderItemTemplate;
import at.cdes.bo.data.order.plott.PlottOrderTemplate;
import at.cdes.bo.data.order.plott.PlottProperties;
import at.cdes.db.dao.OrderDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class OrderDAOHibernate
extends HibernateDaoSupport
implements OrderDAO,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public List getAll() {
        Criteria crit = this.getSession().createCriteria(PlottOrder.class);
        return crit.list();
    }

    @Override
    public PlottOrder getPlottOrder(Integer id) {
        return (PlottOrder)this.getSession().get(PlottOrder.class, (Serializable)id);
    }

    @Override
    public PlottOrder savePlottOrder(PlottOrder cons) {
        return this.getPlottOrder((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public PlottOrder updateMergePlottOrder(PlottOrder cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public PlottOrder updatePlottOrder(PlottOrder cons) {
        ArrayList orderSteps = new ArrayList(cons.getReceived().values());
        cons = (PlottOrder)this.getSession().merge((Object)cons);
        for (OrderStepImpl os : orderSteps) {
            cons.getReceived().put(os.getId(), os);
        }
        this.getSession().update((Object)cons);
        return cons;
    }

    @Override
    public void delete(PlottOrder cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public PlottOrderTemplate getPlottOrderTemplate(Integer id) {
        return (PlottOrderTemplate)this.getSession().get(PlottOrderTemplate.class, (Serializable)id);
    }

    @Override
    public PlottOrderTemplate savePlottOrderTemplate(PlottOrderTemplate cons) {
        return this.getPlottOrderTemplate((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public PlottOrderTemplate updatePlottOrderTemplate(PlottOrderTemplate cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(PlottOrderTemplate cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public PlottOrderItem getPlottOrderItem(Integer id) {
        return (PlottOrderItem)this.getSession().get(PlottOrderItem.class, (Serializable)id);
    }

    @Override
    public PlottOrderItem savePlottOrderItem(PlottOrderItem cons) {
        return this.getPlottOrderItem((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public PlottOrderItem updatePlottOrderItem(PlottOrderItem cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(PlottOrderItem cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public PlottOrderItemTemplate getPlottOrderItemTemplate(Integer id) {
        return (PlottOrderItemTemplate)this.getSession().get(PlottOrderItemTemplate.class, (Serializable)id);
    }

    @Override
    public PlottOrderItemTemplate savePlottOrderItemTemplate(PlottOrderItemTemplate cons) {
        return this.getPlottOrderItemTemplate((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public PlottOrderItemTemplate updatePlottOrderItemTemplate(PlottOrderItemTemplate cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(PlottOrderItemTemplate cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public OrderAddress saveOrderAddress(OrderAddress oa) {
        Integer id = (Integer)this.getSession().save((Object)oa);
        return (OrderAddress)this.getSession().get(OrderAddress.class, (Serializable)id);
    }

    @Override
    public OrderAddress getOrderAddress(Integer id) {
        return (OrderAddress)this.getSession().get(OrderAddress.class, (Serializable)id);
    }

    @Override
    public void deleteOrderAddress(OrderAddress oa) {
        this.getSession().delete((Object)oa);
    }

    @Override
    public PlottProperties savePlottProperties(PlottProperties oa) {
        Integer id = (Integer)this.getSession().save((Object)oa);
        return (PlottProperties)this.getSession().get(PlottProperties.class, (Serializable)id);
    }

    @Override
    public PlottProperties updatePlottProperties(PlottProperties oa) {
        this.getSession().merge((Object)oa);
        return oa;
    }

    @Override
    public void deletePlottProperties(PlottProperties props) {
        this.getSession().delete((Object)props);
    }

    @Override
    public PlottProperties getPlottProperties(Integer id) {
        return (PlottProperties)this.getSession().load(PlottProperties.class, (Serializable)id);
    }

    @Override
    public OrderAddress updateOrderAddress(OrderAddress oa) {
        this.getSession().merge((Object)oa);
        return oa;
    }

    @Override
    public OrderStepImpl saveOrderStep(OrderStepImpl cons) {
        Integer id = (Integer)this.getSession().save((Object)cons);
        return (OrderStepImpl)this.getSession().get(OrderStepImpl.class, (Serializable)id);
    }

    @Override
    public OrderStepImpl updateOrderStep(OrderStepImpl cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public Collection getTemplatesOfProject(Integer projectId) {
        return this.getSession().createCriteria(PlottOrderTemplate.class).createCriteria("project").add(Restrictions.idEq((Object)projectId)).list();
    }

    @Override
    public Collection getValidTemplatesOfProject(Integer projectId) {
        Criteria crit = this.getSession().createCriteria(PlottOrderTemplate.class);
        crit.add((Criterion)Restrictions.like((String)"invalidated", (Object)false));
        crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        return crit.list();
    }

    @Override
    public OrderStepImpl getOrderStep(Integer id) {
        return (OrderStepImpl)this.getSession().get(OrderStepImpl.class, (Serializable)id);
    }

    @Override
    public Collection getPlottOrders(Integer projectId) {
        Criteria crit = this.getSession().createCriteria(PlottOrder.class);
        if (projectId != null) {
            crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        return crit.list();
    }

    @Override
    public Collection getPlottOrdersByPlotter(Integer projectId, Integer plotterOrgId, boolean unaccepted) {
        Criteria crit = this.getSession().createCriteria(PlottOrder.class);
        if (projectId != null) {
            crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        if (plotterOrgId != null) {
            crit.createCriteria("plotter").add(Restrictions.idEq((Object)plotterOrgId));
        }
        if (unaccepted) {
            crit.add(Restrictions.isNotNull((String)"acceptance"));
            crit.createCriteria("acceptance").add(Restrictions.isNull((String)"finished"));
        }
        crit.addOrder(Order.desc((String)"jobNumber"));
        return crit.list();
    }

    @Override
    public OrderStepImpl getOrderStepByOrderItemId(Integer id) {
        Criteria crit = this.getSession().createCriteria(OrderStepImpl.class);
        crit.add((Criterion)Restrictions.eq((String)"orderItemId", (Object)id));
        return (OrderStepImpl)crit.uniqueResult();
    }

    @Override
    public OriginalDocumentOrder updateOriginalDocumentOrder(OriginalDocumentOrder order) {
        ArrayList orderSteps = new ArrayList(order.getReceived().values());
        order = (OriginalDocumentOrder)this.getSession().merge((Object)order);
        for (OrderStepImpl os : orderSteps) {
            order.getReceived().put(os.getId(), os);
        }
        this.getSession().update((Object)order);
        return order;
    }

    @Override
    public OriginalDocumentOrderItem getOriginalDocumentOrderItem(Integer orderItemId) {
        return (OriginalDocumentOrderItem)this.getSession().get(OriginalDocumentOrderItem.class, (Serializable)orderItemId);
    }

    @Override
    public OriginalDocumentOrder getOriginalDocumentOrder(Integer orderItemId) {
        return (OriginalDocumentOrder)this.getSession().get(OriginalDocumentOrder.class, (Serializable)orderItemId);
    }

    @Override
    public OriginalDocumentOrderItem saveOriginalDocumentOrderItem(OriginalDocumentOrderItem item) {
        Integer id = (Integer)this.getSession().save((Object)item);
        return (OriginalDocumentOrderItem)this.getSession().get(OriginalDocumentOrderItem.class, (Serializable)id);
    }

    @Override
    public OriginalDocumentOrder saveOriginalDocumentOrder(OriginalDocumentOrder order) {
        Integer id = (Integer)this.getSession().save((Object)order);
        return (OriginalDocumentOrder)this.getSession().get(OriginalDocumentOrder.class, (Serializable)id);
    }

    @Override
    public Collection<OriginalDocumentOrder> getOriginalDocumentOrders(Integer activeSubProjectId) {
        Criteria crit = this.getSession().createCriteria(OriginalDocumentOrder.class);
        if (activeSubProjectId != null) {
            crit.createCriteria("subProject").add(Restrictions.idEq((Object)activeSubProjectId));
        }
        crit.add((Criterion)Restrictions.eq((String)"outdated", (Object)Boolean.FALSE));
        return crit.list();
    }

    @Override
    public void delete(OrderStep item) {
        this.getSession().delete((Object)item);
    }

    @Override
    public void delete(OriginalDocumentOrderItem item) {
        this.getSession().delete((Object)item);
    }

    @Override
    public void delete(OriginalDocumentOrder item) {
        this.getSession().delete((Object)item);
    }

    @Override
    public List<OrderAddress> getOrderAddresses(Integer projectId, Integer type) {
        Criteria crit = this.getSession().createCriteria(OrderAddress.class);
        if (type != null) {
            crit.add((Criterion)Restrictions.eq((String)"type", (Object)type));
        }
        return crit.list();
    }

    @Override
    public List getPlottOrderItemsReferencingTemplateItem(Integer plottOrderTemplateItemId) {
        Criteria crit = this.getSession().createCriteria(PlottOrderItem.class);
        crit.createCriteria("template").add(Restrictions.idEq((Object)plottOrderTemplateItemId));
        return crit.list();
    }

    @Override
    public List getAllOrderItemsOfReceiverAndPlottOrder(Integer projectParticipationId, Integer orderId) {
        Criteria crit = this.getSession().createCriteria(PlottOrderItem.class);
        crit.add((Criterion)Restrictions.like((String)"receiverId", (Object)projectParticipationId));
        if (orderId != null) {
            crit.createCriteria("orderContract").add(Restrictions.idEq((Object)orderId));
        }
        return crit.list();
    }

    @Override
    public List getPlottOrdersByCompletionDate(Integer projectId, Date from, Date until) {
        Criteria crit = this.getSession().createCriteria(PlottOrder.class);
        if (projectId != null) {
            crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        if (from != null && until != null) {
            crit.createCriteria("completed").add((Criterion)Restrictions.ge((String)"finished", (Object)from)).add((Criterion)Restrictions.le((String)"finished", (Object)until));
        } else if (from != null && until == null) {
            crit.createCriteria("completed").add((Criterion)Restrictions.ge((String)"finished", (Object)from));
        } else if (from == null && until != null) {
            crit.createCriteria("completed").add((Criterion)Restrictions.le((String)"finished", (Object)until));
        }
        return crit.list();
    }

    @Override
    public List getOriginalDocumentOrdersCompletedBeforeDate(Date completionDate) {
        Criteria crit = this.getSession().createCriteria(OriginalDocumentOrder.class);
        crit.createCriteria("completed").add((Criterion)Restrictions.le((String)"finished", (Object)completionDate));
        crit.add((Criterion)Restrictions.eq((String)"outdated", (Object)Boolean.FALSE));
        return crit.list();
    }

    @Override
    public List getOpenPlotOrderItemsBySubProject(Integer projectId, Integer subProjectId) {
        Criteria itemCrit = this.getSession().createCriteria(PlottOrderItem.class);
        Criteria orderCrit = itemCrit.createCriteria("orderContract");
        orderCrit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        orderCrit.createCriteria("acceptance").add(Restrictions.isNull((String)"signature")).add(Restrictions.isNotNull((String)"created"));
        itemCrit.createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        return itemCrit.list();
    }

    @Override
    public List getPlotOrderItemsByDocumentVersion(Integer documentVersionId) {
        Criteria itemCrit = this.getSession().createCriteria(PlottOrderItem.class);
        itemCrit.createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersionId));
        return itemCrit.list();
    }
}

