/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.MatrixEditItem;
import at.cdes.bo.data.MatrixEditMap;
import at.cdes.bo.data.NodeInstanceLine;
import at.cdes.bo.data.cycle.Realm;
import at.cdes.bo.data.cycle.RealmCodeNameComparator;
import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.cycle.ReviewCycleCommentOption;
import at.cdes.bo.data.cycle.ReviewCycleCommentType;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCycleInstanceImpl;
import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.ReviewCyclePositionReleaseImpl;
import at.cdes.bo.data.cycle.ReviewCyclePositionType;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnection;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceBase;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceImpl;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceRelease;
import at.cdes.bo.data.cycle.cell.ReviewCycleEntryCondition;
import at.cdes.bo.data.cycle.cell.ReviewCycleEntryConditionImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeInstanceListener;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeListener;
import at.cdes.bo.data.label.Label;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.notification.ReviewCycleNodeInstanceNotification;
import at.cdes.bo.data.number.DocumentNumberVersionPart;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.order.plott.PlottOrderItemTemplate;
import at.cdes.bo.data.order.plott.PlottOrderTemplate;
import at.cdes.bo.data.order.plott.ReviewCycleNodeInstancePlottOrderListener;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.ProjectParticipationComparator;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.workflow.WorkflowAction;
import at.cdes.bo.data.workflow.WorkflowActionListener;
import at.cdes.bo.data.workflow.WorkflowActionPrecondition;
import at.cdes.bo.data.workflow.WorkflowEntityStatus;
import at.cdes.bo.data.workflow.WorkflowNodePositionResultOption;
import at.cdes.bo.data.workflow.WorkflowNodeTemplate;
import at.cdes.bo.data.workflow.WorkflowTemplate;
import at.cdes.controller.apiHelper.SubProjectCopyContainer;
import at.cdes.controller.helper.CdesDTOHelper;
import at.cdes.db.dao.DocumentVersionDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.NotificationDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.PersonDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.RealmDAO;
import at.cdes.db.dao.ReviewCycleCellConnectionDAO;
import at.cdes.db.dao.ReviewCycleCellDAO;
import at.cdes.db.dao.ReviewCycleCellInstanceDAO;
import at.cdes.db.dao.ReviewCycleCommentOptionDAO;
import at.cdes.db.dao.ReviewCycleCommentTypeDAO;
import at.cdes.db.dao.ReviewCycleDAO;
import at.cdes.db.dao.ReviewCycleInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeListenerDAO;
import at.cdes.db.dao.ReviewCyclePositionDAO;
import at.cdes.db.dao.ReviewCyclePositionTypeDAO;
import at.cdes.db.dao.ReviewCycleResultOptionDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.db.dao.WorkflowActionDAO;
import at.cdes.db.dao.WorkflowActionListenerDAO;
import at.cdes.db.dao.WorkflowActionPreconditionDAO;
import at.cdes.db.dao.WorkflowEntityStatusDAO;
import at.cdes.db.dao.WorkflowNodePositionResultOptionDAO;
import at.cdes.db.dao.WorkflowNodeTemplateDAO;
import at.cdes.db.dao.WorkflowTemplateDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.oldGwtDto.WorkflowEntityStatusDTO;
import at.cdes.oldGwtDto.WorkflowNodePositionResultOptionDTO;
import at.cdes.oldGwtDto.WorkflowNodeTemplateDTO;
import at.cdes.oldGwtDto.WorkflowTemplateDTO;
import at.cdes.service.LabelOperations;
import at.cdes.service.ReviewCycleOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.NoIdException;
import at.cdes.util.OgnlComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.clazzes.util.lang.Pair;
import org.xnap.commons.i18n.I18n;

public class ReviewCycleOperationsImpl
implements ReviewCycleOperations {
    static Logger logger = Logger.getLogger((String)"review cycle operation");
    private ReviewCyclePositionTypeDAO reviewCyclePositionTypeDAO;
    private RealmDAO realmDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private ReviewCycleCellDAO reviewCycleCellDAO;
    private ReviewCycleNodeDAO reviewCycleNodeDAO;
    private ReviewCycleCellConnectionDAO reviewCycleCellConnectionDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private ProjectDAO projectDAO;
    private SubProjectDAO subProjectDAO;
    private ReviewCycleInstanceDAO reviewCycleInstanceDAO;
    private ReviewCycleCellInstanceDAO reviewCycleCellInstanceDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ReviewCyclePositionDAO reviewCyclePositionDAO;
    private NetworkDAO networkDAO;
    private NotificationDAO notificationDAO;
    private ReviewCycleCommentTypeDAO reviewCycleCommentTypeDAO;
    private ReviewCycleCommentOptionDAO reviewCycleCommentOptionDAO;
    private ReviewCycleNodeListenerDAO reviewCycleNodeListenerDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private DocumentVersionDAO documentVersionDAO;
    private PersonDAO personDAO;
    private LabelOperations labelOperations;
    private boolean reversePreduration;
    private WorkflowTemplateDAO workflowTemplateDAO;
    private WorkflowNodeTemplateDAO workflowNodeTemplateDAO;
    private WorkflowEntityStatusDAO workflowEntityStatusDAO;
    private WorkflowActionListenerDAO workflowActionListenerDAO;
    private WorkflowActionDAO workflowActionDAO;
    private WorkflowNodePositionResultOptionDAO workflowNodePositionResultOptionDAO;
    private WorkflowActionPreconditionDAO workflowActionPreconditionDAO;
    private ReviewOperations reviewOperations;

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    @Override
    public ReviewCycleNode getReviewCycleNode(Integer id) {
        return this.reviewCycleNodeDAO.get(id);
    }

    @Override
    public List<ReviewCycleNode> getReviewCycleNodesByPositionType(Integer positionTypeId) {
        return this.reviewCycleNodeDAO.getByPositionType(positionTypeId);
    }

    @Override
    public List getPositionTypes() {
        return this.reviewCyclePositionTypeDAO.getAll();
    }

    @Override
    public ReviewCyclePositionType getReviewCyclePositionType(Integer id) {
        return this.reviewCyclePositionTypeDAO.get(id);
    }

    @Override
    public ReviewCyclePositionType insertReviewCyclePositionType(ReviewCyclePositionType type, List updates) {
        ReviewCycleResultOption sropt = type.getSampleControlReviewCyclePositionType();
        type = this.reviewCyclePositionTypeDAO.save(type);
        type.setReviewCycleResultOptions(new HashMap());
        if (sropt != null && sropt.getName() != null && sropt.getName().length() > 0) {
            sropt.setReviewCyclePositionType(type);
            sropt.setSampleControlReview(true);
            sropt = this.reviewCycleResultOptionDAO.save(sropt);
            type.setSampleControlReviewCyclePositionType(sropt);
        } else {
            type.setSampleControlReviewCyclePositionType(null);
        }
        for (int i = 0; i < updates.size(); ++i) {
            ReviewCycleResultOption opt = (ReviewCycleResultOption)updates.get(i);
            if (opt.getName() == null || opt.getName().length() == 0 || opt.isSampleControlReview()) continue;
            opt.setReviewCyclePositionType(type);
            opt.setId(null);
            opt = this.reviewCycleResultOptionDAO.save(opt);
            type.getReviewCycleResultOptions().put(opt.getId(), opt);
        }
        return type;
    }

    @Override
    public ReviewCyclePositionType updateReviewCyclePositionType(ReviewCyclePositionType type, List updates, List deletedKeys) {
        int i;
        ReviewCycleResultOption sropt = type.getSampleControlReviewCyclePositionType();
        if (sropt != null && sropt.getName() != null && sropt.getName().length() > 0) {
            sropt.setReviewCyclePositionType(type);
            sropt.setSampleControlReview(true);
            sropt = sropt.getId() == null ? this.reviewCycleResultOptionDAO.save(sropt) : this.reviewCycleResultOptionDAO.update(sropt);
            type.setSampleControlReviewCyclePositionType(sropt);
        } else {
            type.setSampleControlReviewCyclePositionType(null);
        }
        for (i = 0; i < updates.size(); ++i) {
            ReviewCycleResultOption opt = (ReviewCycleResultOption)updates.get(i);
            opt.setReviewCyclePositionType(type);
            if (opt.getId() == null && opt.getName() != null && opt.getName().length() > 0) {
                opt.setId(null);
                opt = this.reviewCycleResultOptionDAO.save(opt);
                type.getReviewCycleResultOptions().put(opt.getId(), opt);
                continue;
            }
            if (opt.getId() == null) continue;
            this.reviewCycleResultOptionDAO.update(opt);
        }
        for (i = 0; i < deletedKeys.size(); ++i) {
            this.reviewCycleResultOptionDAO.delete((ReviewCycleResultOption)type.getReviewCycleResultOptions().get(deletedKeys.get(i)));
            type.getReviewCycleResultOptions().remove(deletedKeys.get(i));
        }
        return this.reviewCyclePositionTypeDAO.merge(type);
    }

    @Override
    public void deleteReviewCyclePositionType(Integer reviewCyclePositionTypeId) {
        List realms;
        ReviewCyclePositionType type = this.reviewCyclePositionTypeDAO.get(reviewCyclePositionTypeId);
        if (type.getReviewCycleResultOptions() != null && type.getReviewCycleResultOptions().size() > 0) {
            Collection values = type.getReviewCycleResultOptions().values();
            for (ReviewCycleResultOption opt : values) {
                this.reviewCycleResultOptionDAO.delete(opt);
            }
            type.getReviewCycleResultOptions().clear();
        }
        if (!(realms = this.getRealmTemplates(type.getId())).isEmpty()) {
            for (Realm realm : realms) {
                this.deleteProjectRealm(realm);
            }
        }
        if (type.getSampleControlReviewCyclePositionType() != null) {
            ReviewCycleResultOption scrcp = type.getSampleControlReviewCyclePositionType();
            type.setSampleControlReviewCyclePositionType(null);
            this.reviewCycleResultOptionDAO.delete(scrcp);
        }
        type = this.reviewCyclePositionTypeDAO.update(type);
        this.reviewCyclePositionTypeDAO.delete(type);
    }

    @Override
    public ReviewCycle getReviewCycle(Integer id) {
        return this.reviewCycleDAO.get(id);
    }

    @Override
    public ReviewCycle checkReviewCycle(Integer id) {
        ReviewCycle cycle = this.reviewCycleDAO.get(id);
        this.updateReviewCycle(cycle, null, null, null);
        return cycle;
    }

    @Override
    public ReviewCycle insertReviewCycle(ReviewCycle cycle, List<Integer> inserts, List<Integer> deletes, DocumentNumberVersionPart part) {
        int i;
        ReviewCycleResultOption dvio = new ReviewCycleResultOption();
        dvio.setValue(-10);
        dvio.setName("Dokumentversion ung\u00fcltig");
        dvio.setFinishCell(true);
        dvio.setDocumentVersionStatus(4);
        dvio = this.reviewCycleResultOptionDAO.save(dvio);
        cycle.setDocumentVersionInvalidationOption(dvio);
        ReviewCycleResultOption dio = new ReviewCycleResultOption();
        dio.setValue(-9);
        dio.setName("Dokument ung\u00fcltig");
        dio.setFinishCell(true);
        dio.setDocumentVersionStatus(5);
        dio = this.reviewCycleResultOptionDAO.save(dio);
        cycle.setDocumentInvalidationOption(dio);
        ReviewCycleResultOption eno = new ReviewCycleResultOption();
        eno.setValue(-8);
        eno.setName("Knoten leer");
        eno.setFinishCell(false);
        eno = this.reviewCycleResultOptionDAO.save(eno);
        cycle.setEmptyNodeOption(eno);
        ReviewCycleResultOption del = new ReviewCycleResultOption();
        del.setValue(-11);
        del.setName("Dokumentversion l\u00f6schen");
        del.setFinishCell(true);
        del.setDocumentVersionStatus(7);
        del = this.reviewCycleResultOptionDAO.save(del);
        cycle.setDocumentVersionDeletedOption(del);
        ReviewCycleResultOption abort = new ReviewCycleResultOption();
        abort.setValue(-13);
        abort.setName("Pr\u00fcfung abbrechen");
        abort.setFinishCell(true);
        abort.setDocumentVersionStatus(13);
        abort = this.reviewCycleResultOptionDAO.save(abort);
        cycle.setDocumentVersionAbortedOption(abort);
        if (cycle.getNetworks() == null) {
            cycle.setNetworks(new HashMap());
        }
        for (i = 0; i < inserts.size(); ++i) {
            Network n = this.networkDAO.get(inserts.get(i));
            cycle.getNetworks().put(n.getId(), n);
        }
        for (i = 0; i < deletes.size(); ++i) {
            cycle.getNetworks().remove(deletes.get(i));
        }
        if (part != null) {
            cycle.setDocumentNumberVersionPart(this.reviewCycleDAO.saveDocumentNumberVersionPart(part));
        }
        return this.reviewCycleDAO.save(cycle);
    }

    @Override
    public ReviewCycle updateReviewCycle(ReviewCycle cycle, List<Integer> inserts, List<Integer> deletes, DocumentNumberVersionPart part) {
        if (cycle.getDocumentVersionInvalidationOption() == null) {
            ReviewCycleResultOption dvio = new ReviewCycleResultOption();
            dvio.setValue(-10);
            dvio.setName("Dokumentversion ung\u00fcltig");
            dvio.setFinishCell(true);
            dvio.setDocumentVersionStatus(4);
            dvio = this.reviewCycleResultOptionDAO.save(dvio);
            cycle.setDocumentVersionInvalidationOption(dvio);
        } else {
            this.reviewCycleResultOptionDAO.update(cycle.getDocumentVersionInvalidationOption());
        }
        if (cycle.getDocumentInvalidationOption() == null) {
            ReviewCycleResultOption dio = new ReviewCycleResultOption();
            dio.setValue(-9);
            dio.setName("Dokument ung\u00fcltig");
            dio.setFinishCell(true);
            dio.setDocumentVersionStatus(5);
            dio = this.reviewCycleResultOptionDAO.save(dio);
            cycle.setDocumentInvalidationOption(dio);
        } else {
            this.reviewCycleResultOptionDAO.update(cycle.getDocumentInvalidationOption());
        }
        if (cycle.getEmptyNodeOption() == null) {
            ReviewCycleResultOption eno = new ReviewCycleResultOption();
            eno.setValue(-8);
            eno.setName("Knoten leer");
            eno.setFinishCell(false);
            eno = this.reviewCycleResultOptionDAO.save(eno);
            cycle.setEmptyNodeOption(eno);
        } else {
            this.reviewCycleResultOptionDAO.update(cycle.getEmptyNodeOption());
        }
        if (cycle.getDocumentVersionDeletedOption() == null) {
            ReviewCycleResultOption del = new ReviewCycleResultOption();
            del.setValue(-11);
            del.setName("Dokumentversion l\u00f6schen");
            del.setFinishCell(true);
            del.setDocumentVersionStatus(7);
            del = this.reviewCycleResultOptionDAO.save(del);
            cycle.setDocumentVersionDeletedOption(del);
        } else {
            this.reviewCycleResultOptionDAO.update(cycle.getDocumentVersionDeletedOption());
        }
        if (cycle.getDocumentVersionAbortedOption() == null) {
            ReviewCycleResultOption abort = new ReviewCycleResultOption();
            abort.setValue(-13);
            abort.setName("Pr\u00fcfung abbrechen");
            abort.setFinishCell(true);
            abort.setDocumentVersionStatus(13);
            abort = this.reviewCycleResultOptionDAO.save(abort);
            cycle.setDocumentVersionAbortedOption(abort);
        } else {
            this.reviewCycleResultOptionDAO.update(cycle.getDocumentVersionAbortedOption());
        }
        if (part != null) {
            part = this.reviewCycleDAO.mergeDocumentNumberVersionPart(part);
            cycle.setDocumentNumberVersionPart(part);
            cycle = this.reviewCycleDAO.merge(cycle);
        }
        if (cycle.getNetworks() == null) {
            cycle.setNetworks(new HashMap());
        }
        if (inserts != null) {
            for (int i = 0; i < inserts.size(); ++i) {
                Network n = this.networkDAO.get(inserts.get(i));
                cycle.getNetworks().put(n.getId(), n);
            }
        }
        if (deletes != null) {
            for (int i = 0; i < deletes.size(); ++i) {
                cycle.getNetworks().remove(deletes.get(i));
            }
        }
        return this.reviewCycleDAO.update(cycle);
    }

    @Override
    public ReviewCycleCell getReviewCycleCell(Integer id) {
        return this.reviewCycleCellDAO.get(id);
    }

    @Override
    public List getReviewCycleCells(Integer cycleId) {
        return this.reviewCycleCellDAO.getAll(cycleId);
    }

    @Override
    public ReviewCycleCell insertReviewCycleCell(ReviewCycleCell cell, Integer reviewCycleId, List inserts, List freeInserts, List connectionInserts) {
        ReviewCycleNode node;
        int i;
        ReviewCycle cycle = this.reviewCycleDAO.get(reviewCycleId);
        cell.setReviewCycle(cycle);
        if (cell.getReviewCycleEntryCondition() != null) {
            this.reviewCycleCellDAO.saveEntryCondition((ReviewCycleEntryConditionImpl)cell.getReviewCycleEntryCondition());
        }
        cell = this.reviewCycleCellDAO.save(cell);
        cell.setReviewCycleNodes(new HashMap());
        for (i = 0; i < inserts.size(); ++i) {
            node = (ReviewCycleNode)inserts.get(i);
            if (node.getName() == null || node.getPosition() == null) continue;
            node.setReviewCycleCell(cell);
            node.setReviewCyclePositionType(this.reviewCyclePositionTypeDAO.get(node.getReviewCyclePositionType().getId()));
            node.setFree(false);
            node = this.reviewCycleNodeDAO.save(node);
            cell.getReviewCycleNodes().put(node.getId(), node);
        }
        cell.setFreeReviewCycleNodes(new HashMap());
        for (i = 0; i < freeInserts.size(); ++i) {
            node = (ReviewCycleNode)freeInserts.get(i);
            if (node.getName() == null || node.getPosition() == null) continue;
            node.setReviewCycleCell(cell);
            node.setReviewCyclePositionType(this.reviewCyclePositionTypeDAO.get(node.getReviewCyclePositionType().getId()));
            node.setFree(true);
            node = this.reviewCycleNodeDAO.save(node);
            cell.getFreeReviewCycleNodes().put(node.getId(), node);
        }
        cell.setIncommingConnections(new HashMap());
        for (i = 0; i < connectionInserts.size(); ++i) {
            ReviewCycleCellConnection connection = (ReviewCycleCellConnection)connectionInserts.get(i);
            if (connection.getRule() == null || connection.getSourceCell() == null) continue;
            connection.setDestinationCell(cell);
            connection.setSourceCell(this.reviewCycleCellDAO.get(connection.getSourceCell().getId()));
            this.reviewCycleCellConnectionDAO.save(connection);
            cell.getIncommingConnections().put(connection.getId(), connection);
        }
        return this.reviewCycleCellDAO.merge(cell);
    }

    @Override
    public ReviewCycleCell updateReviewCycleCell(ReviewCycleCell cell, List updates, List deletes, List freeInserts, List freeDeletes, List conncetionUpdates, List connectionDeletes) {
        ReviewCycleCellConnection connection;
        ReviewCycleNode node;
        int i;
        ReviewCycleCell dbcell = this.reviewCycleCellDAO.get(cell.getId());
        cell.setReviewCycle(dbcell.getReviewCycle());
        ReviewCycleEntryCondition entryCondition = cell.getReviewCycleEntryCondition();
        cell = this.reviewCycleCellDAO.merge(cell);
        this.reviewCycleCellDAO.mergeEntryCondition((ReviewCycleEntryConditionImpl)entryCondition);
        cell.setReviewCycleEntryCondition(entryCondition);
        if (cell.getReviewCycleNodes() == null) {
            cell.setReviewCycleNodes(new HashMap());
        }
        for (i = 0; i < updates.size(); ++i) {
            node = (ReviewCycleNode)updates.get(i);
            node.setReviewCycleCell(cell);
            if (node.getName() == null || node.getPosition() == null) continue;
            node.setReviewCyclePositionType(this.reviewCyclePositionTypeDAO.get(node.getReviewCyclePositionType().getId()));
            if (node.getId() == null) {
                node.setFree(false);
                node = this.reviewCycleNodeDAO.save(node);
                cell.getReviewCycleNodes().put(node.getId(), node);
                continue;
            }
            node = this.reviewCycleNodeDAO.update(node);
        }
        for (i = 0; i < deletes.size(); ++i) {
            node = this.reviewCycleNodeDAO.get((Integer)deletes.get(i));
            this.reviewCycleNodeDAO.delete(node);
            cell.getReviewCycleNodes().remove(node.getId());
        }
        if (cell.getFreeReviewCycleNodes() == null) {
            cell.setFreeReviewCycleNodes(new HashMap());
        }
        for (i = 0; i < freeInserts.size(); ++i) {
            node = (ReviewCycleNode)freeInserts.get(i);
            node.setReviewCycleCell(cell);
            if (node.getName() == null || node.getName().length() <= 0) continue;
            node.setReviewCyclePositionType(this.reviewCyclePositionTypeDAO.get(node.getReviewCyclePositionType().getId()));
            node.setPosition(0);
            if (node.getId() == null) {
                node.setFree(true);
                node = this.reviewCycleNodeDAO.save(node);
                cell.getFreeReviewCycleNodes().put(node.getId(), node);
                continue;
            }
            node = this.reviewCycleNodeDAO.update(node);
        }
        for (i = 0; i < freeDeletes.size(); ++i) {
            node = this.reviewCycleNodeDAO.get((Integer)freeDeletes.get(i));
            this.reviewCycleNodeDAO.delete(node);
            cell.getFreeReviewCycleNodes().remove(node.getId());
        }
        if (cell.getIncommingConnections() == null) {
            cell.setIncommingConnections(new HashMap());
        }
        for (i = 0; i < conncetionUpdates.size(); ++i) {
            connection = (ReviewCycleCellConnection)conncetionUpdates.get(i);
            if (connection.getRule() == null || connection.getRule().length() <= 0) continue;
            connection.setDestinationCell(cell);
            if (connection.getSourceCell() != null) {
                connection.setSourceCell(this.reviewCycleCellDAO.get(connection.getSourceCell().getId()));
            }
            if (connection.getId() == null) {
                connection = this.reviewCycleCellConnectionDAO.save(connection);
                cell.getIncommingConnections().put(connection.getId(), connection);
                continue;
            }
            connection = this.reviewCycleCellConnectionDAO.update(connection);
        }
        for (i = 0; i < connectionDeletes.size(); ++i) {
            connection = this.reviewCycleCellConnectionDAO.get((Integer)connectionDeletes.get(i));
            this.reviewCycleCellConnectionDAO.delete(connection);
            cell.getIncommingConnections().remove(connection.getId());
        }
        return this.reviewCycleCellDAO.update(cell);
    }

    @Override
    public List getProjectRealms(Integer projectId) {
        return this.realmDAO.getAllofProject(projectId, null);
    }

    @Override
    public List getProjectRealmsForType(Integer projectId, Integer typeId) {
        return this.realmDAO.getAllofProject(projectId, typeId);
    }

    @Override
    public List getValidProjectRealms(Integer projectId, Integer typeId) {
        return this.realmDAO.getAllValidOfProject(projectId, typeId);
    }

    @Override
    public Realm getRealm(Integer realmId) {
        return this.realmDAO.get(realmId);
    }

    @Override
    public void updateProjectRealms(Integer typeId, Integer projectId, List realms, List deletes) {
        if (projectId == null) {
            throw new NoIdException(1);
        }
        this.updateRealms(typeId, projectId, realms, deletes);
    }

    private void updateRealms(Integer typeId, Integer projectId, List realms, List deletes) {
        Realm realm;
        int i;
        ReviewCyclePositionType type = this.reviewCyclePositionTypeDAO.get(typeId);
        Project project = null;
        if (projectId != null) {
            project = this.projectDAO.get(projectId);
        }
        for (i = 0; i < realms.size(); ++i) {
            realm = (Realm)realms.get(i);
            realm.setProject(project);
            realm.setReviewCyclePositionType(type);
            if (project != null && realm.getValidFromDate() == null && realm.getValidToDate() == null && realm.getId() == null) {
                realm.setValidFromDate(new Date(System.currentTimeMillis()));
            }
            if (realm.getName() == null || realm.getName().length() <= 0) continue;
            realm = realm.getId() == null ? this.realmDAO.save(realm) : this.realmDAO.update(realm);
        }
        if (deletes != null && !deletes.isEmpty()) {
            for (i = 0; i < deletes.size(); ++i) {
                realm = this.realmDAO.get((Integer)deletes.get(i));
                this.realmDAO.delete(realm);
            }
        }
    }

    @Override
    public List getReviewCycleInstances(Integer subProjectId, Locale locale) {
        ArrayList ret = new ArrayList();
        ret.addAll(this.reviewCycleInstanceDAO.getAll(subProjectId));
        Collections.sort(ret, new OgnlComparator("name", true, locale));
        return ret;
    }

    @Override
    public ReviewCycleInstanceImpl getReviewCycleInstance(Integer id, boolean checkProjectsAllowedFinalReviewCycleCell) {
        if (checkProjectsAllowedFinalReviewCycleCell) {
            ReviewCycleInstanceImpl reviewCycleInstance = this.reviewCycleInstanceDAO.get(id);
            List reviewCycleCellInstances = reviewCycleInstance.getReviewCycleCellInstancesSortedByPosition();
            HashMap<Integer, ReviewCycleCellInstanceImpl> validReviewCycleCellInstances = new HashMap<Integer, ReviewCycleCellInstanceImpl>();
            for (ReviewCycleCellInstanceImpl reviewCycleCellInstance : reviewCycleCellInstances) {
                reviewCycleCellInstance.setProjectsAllowedFinalReviewCycleCell(this.isProjectsAllowedFinalReviewCycleCell(reviewCycleCellInstance));
                if (!reviewCycleCellInstance.isProjectsAllowedFinalReviewCycleCell()) continue;
                validReviewCycleCellInstances.put(reviewCycleCellInstance.getId(), reviewCycleCellInstance);
            }
            reviewCycleInstance.setReviewCycleCellInstances(validReviewCycleCellInstances);
            return reviewCycleInstance;
        }
        return this.reviewCycleInstanceDAO.get(id);
    }

    @Override
    public ReviewCycleInstanceImpl insertReviewCycleInstance(ReviewCycleInstanceImpl instance, Integer subProjectId) {
        ReviewCycle cycle = this.reviewCycleDAO.get(instance.getReviewCycle().getId());
        SubProject subProject = this.subProjectDAO.get(subProjectId);
        instance.setReviewCycle(cycle);
        instance.setSubProject(subProject);
        instance.setChanged(2);
        ReviewCycleInstanceImpl ret = this.reviewCycleInstanceDAO.save(instance);
        Map cells = cycle.getReviewCycleCells();
        if (cells != null) {
            HashMap<Integer, ReviewCycleCellInstanceImpl> cellInstances = new HashMap<Integer, ReviewCycleCellInstanceImpl>();
            for (ReviewCycleCell cell : cells.values()) {
                ReviewCycleCellInstanceImpl cellInstance = new ReviewCycleCellInstanceImpl();
                cellInstance.setDuration(0);
                cellInstance.setReviewCycleCell(cell);
                cellInstance.setReviewCycleInstance(ret);
                cellInstance.setStartCell(false);
                cellInstance = this.reviewCycleCellInstanceDAO.save(cellInstance);
                cellInstances.put(cellInstance.getId(), cellInstance);
                Map nodes = cell.getReviewCycleNodes();
                if (nodes == null) continue;
                HashMap<Integer, ReviewCycleNodeInstanceImpl> nodeInstances = new HashMap<Integer, ReviewCycleNodeInstanceImpl>();
                for (ReviewCycleNode node : nodes.values()) {
                    ReviewCycleNodeInstanceImpl nodeInstance = new ReviewCycleNodeInstanceImpl();
                    nodeInstance.setDuration(0);
                    nodeInstance.setDurationMin(0);
                    nodeInstance.setFree(node.isFree());
                    nodeInstance.setReviewCycleCellInstance(cellInstance);
                    nodeInstance.setReviewCycleNode(node);
                    nodeInstance = this.reviewCycleNodeInstanceDAO.save(nodeInstance);
                    nodeInstances.put(nodeInstance.getId(), nodeInstance);
                }
                cellInstance.setReviewCycleNodeInstances(nodeInstances);
            }
            ret.setReviewCycleCellInstances(cellInstances);
        }
        return ret;
    }

    @Override
    public ReviewCycleInstanceImpl copyReviewCycleInstance(Integer reviewCycleInstanceImplId) {
        ReviewCycleInstanceImpl rci = this.reviewCycleInstanceDAO.get(reviewCycleInstanceImplId);
        ReviewCycleInstanceImpl cycleCopy = new ReviewCycleInstanceImpl(rci);
        cycleCopy.setReviewCycleCellInstances(null);
        cycleCopy.setName("Kopie_" + cycleCopy.getName());
        cycleCopy.setChanged(2);
        cycleCopy = this.reviewCycleInstanceDAO.save(cycleCopy);
        cycleCopy.setReviewCycleCellInstances(new HashMap());
        if (rci.getReviewCycleCellInstances() != null) {
            for (ReviewCycleCellInstanceImpl cellInstance : rci.getReviewCycleCellInstancesSortedByPosition()) {
                ReviewCycleNodeInstanceNotification notCopy;
                ReviewCycleNodeInstanceNotification not;
                Iterator it4;
                Object notifications;
                ReviewCyclePositionImpl posCopy;
                Collection<ReviewCycleNodeInstanceListener> nodeListeners;
                ReviewCycleNodeInstanceImpl nodeCopy;
                ReviewCycleCellInstanceImpl cellCopy = new ReviewCycleCellInstanceImpl(cellInstance);
                cellCopy.setReviewCycleInstance(cycleCopy);
                cellCopy.setReviewCycleNodeInstances(null);
                cellCopy = this.reviewCycleCellInstanceDAO.save(cellCopy);
                cellCopy.setReviewCycleNodeInstances(new HashMap());
                if (cellInstance.getReviewCycleNodeInstances() != null) {
                    for (ReviewCycleNodeInstanceImpl nodeInstance : cellInstance.getReviewCycleNodeInstances().values()) {
                        nodeCopy = new ReviewCycleNodeInstanceImpl(nodeInstance);
                        nodeCopy.setReviewCycleCellInstance(cellCopy);
                        nodeCopy.setReviewCyclePositions(null);
                        nodeCopy = this.reviewCycleNodeInstanceDAO.save(nodeCopy);
                        nodeCopy.setReviewCyclePositions(new HashMap());
                        nodeListeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(nodeInstance.getId());
                        for (ReviewCycleNodeInstanceListener listener : nodeListeners) {
                            listener.setReviewCycleNodeInstance(nodeCopy);
                            this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listener);
                        }
                        if (nodeInstance.getReviewCyclePositions() != null) {
                            for (ReviewCyclePositionImpl pos : nodeInstance.getReviewCyclePositions().values()) {
                                posCopy = new ReviewCyclePositionImpl(pos);
                                posCopy.setReviewCycleNodeInstance(nodeCopy);
                                posCopy = this.reviewCyclePositionDAO.save(posCopy);
                                nodeCopy.getReviewCyclePositions().put(posCopy.getId(), posCopy);
                            }
                        }
                        if ((notifications = this.notificationDAO.getAll(nodeInstance.getId())) != null) {
                            it4 = notifications.iterator();
                            while (it4.hasNext()) {
                                not = (ReviewCycleNodeInstanceNotification)it4.next();
                                notCopy = new ReviewCycleNodeInstanceNotification(not);
                                notCopy.setReviewCycleNodeInstance(nodeCopy);
                                notCopy.setReviewCycleNodeListener(not.getReviewCycleNodeListener());
                                notCopy = (ReviewCycleNodeInstanceNotification)this.notificationDAO.save(notCopy);
                            }
                        }
                        cellCopy.getReviewCycleNodeInstances().put(nodeCopy.getId(), nodeCopy);
                        this.reviewCycleNodeInstanceDAO.merge(nodeCopy);
                    }
                    cycleCopy.getReviewCycleCellInstances().put(cellCopy.getId(), cellCopy);
                    this.reviewCycleCellInstanceDAO.merge(cellCopy);
                }
                if (cellInstance.getFreeReviewCycleNodeInstances() != null) {
                    for (ReviewCycleNodeInstanceImpl nodeInstance : cellInstance.getFreeReviewCycleNodeInstances().values()) {
                        nodeCopy = new ReviewCycleNodeInstanceImpl(nodeInstance);
                        nodeCopy.setReviewCycleCellInstance(cellCopy);
                        nodeCopy.setReviewCyclePositions(null);
                        nodeCopy = this.reviewCycleNodeInstanceDAO.save(nodeCopy);
                        nodeCopy.setReviewCyclePositions(new HashMap());
                        nodeListeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(nodeInstance.getId());
                        notifications = nodeListeners.iterator();
                        while (notifications.hasNext()) {
                            ReviewCycleNodeInstanceListener listenerCopy;
                            ReviewCycleNodeInstanceListener listener;
                            listener = notifications.next();
                            if (listener instanceof ReviewCycleNodeInstanceNotification) {
                                listenerCopy = new ReviewCycleNodeInstanceNotification();
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeInstance(nodeCopy);
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeListener(listener.getReviewCycleNodeListener());
                                Collection refs = ((ReviewCycleNodeInstanceNotification)listener).getReference().values();
                                HashMap<Integer, ProjectParticipation> copyRefs = new HashMap<Integer, ProjectParticipation>();
                                for (ProjectParticipation ref : refs) {
                                    copyRefs.put(ref.getId(), ref);
                                }
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReference(copyRefs);
                                this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                                continue;
                            }
                            listenerCopy = new ReviewCycleNodeInstancePlottOrderListener();
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeInstance(nodeCopy);
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeListener(listener.getReviewCycleNodeListener());
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReference(((ReviewCycleNodeInstancePlottOrderListener)listener).getReference());
                            this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                        }
                        if (nodeInstance.getReviewCyclePositions() != null) {
                            for (ReviewCyclePositionImpl pos : nodeInstance.getReviewCyclePositions().values()) {
                                posCopy = new ReviewCyclePositionImpl(pos);
                                posCopy.setReviewCycleNodeInstance(nodeCopy);
                                posCopy = this.reviewCyclePositionDAO.save(posCopy);
                                nodeCopy.getReviewCyclePositions().put(posCopy.getId(), posCopy);
                            }
                        }
                        if ((notifications = this.notificationDAO.getAll(nodeInstance.getId())) != null) {
                            it4 = notifications.iterator();
                            while (it4.hasNext()) {
                                not = (ReviewCycleNodeInstanceNotification)it4.next();
                                notCopy = new ReviewCycleNodeInstanceNotification(not);
                                notCopy.setReviewCycleNodeInstance(nodeCopy);
                                notCopy.setReviewCycleNodeListener(not.getReviewCycleNodeListener());
                                notCopy = (ReviewCycleNodeInstanceNotification)this.notificationDAO.save(notCopy);
                            }
                        }
                        cellCopy.getReviewCycleNodeInstances().put(nodeCopy.getId(), nodeCopy);
                        this.reviewCycleNodeInstanceDAO.merge(nodeCopy);
                    }
                    cycleCopy.getReviewCycleCellInstances().put(cellCopy.getId(), cellCopy);
                    this.reviewCycleCellInstanceDAO.merge(cellCopy);
                }
                this.reviewCycleInstanceDAO.update(cycleCopy);
            }
        }
        return cycleCopy;
    }

    @Override
    public ReviewCycleInstanceImpl updateReviewCycleInstance(ReviewCycleInstanceImpl instance, Integer subProjectId) {
        ReviewCycle cycle = this.reviewCycleDAO.get(instance.getReviewCycle().getId());
        SubProject subProject = this.subProjectDAO.get(subProjectId);
        instance.setReviewCycle(cycle);
        instance.setSubProject(subProject);
        if (subProject.getActiveObjectList() != null) {
            ReviewCycleInstanceRelease releasedInstance = this.getReleased(subProject.getActiveObjectList().getId(), instance.getId());
            if (this.hasChangedSinceLastReleased(instance, releasedInstance)) {
                instance.setChanged(1);
            } else if (instance.getChanged() != 2) {
                instance.setChanged(0);
            }
        }
        this.updateReviewCycleInstanceDurations(instance);
        return this.reviewCycleInstanceDAO.update(instance);
    }

    public ReviewCycleCellInstanceImpl createReviewCycleCellInstance(ReviewCycleCell cell, ReviewCycleInstanceImpl icycle) {
        Iterator it;
        ReviewCycleCellInstanceImpl inst = new ReviewCycleCellInstanceImpl();
        inst.setReviewCycleInstance(icycle);
        inst.setReviewCycleCell(cell);
        inst.setReviewCycleNodeInstances(new HashMap());
        Iterator iterator = it = cell.getReviewCycleNodes() != null ? cell.getReviewCycleNodes().values().iterator() : null;
        while (it.hasNext()) {
            ReviewCycleNode node = (ReviewCycleNode)it.next();
            ReviewCycleNodeInstanceImpl nodeInst = this.createReviewCycleNodeInstance(node, inst);
            inst.getReviewCycleNodeInstances().put(nodeInst.getId(), nodeInst);
        }
        return inst;
    }

    public ReviewCycleNodeInstanceImpl createReviewCycleNodeInstance(ReviewCycleNode node, ReviewCycleCellInstanceImpl icell) {
        ReviewCycleNodeInstanceImpl inst = new ReviewCycleNodeInstanceImpl();
        inst.setReviewCycleCellInstance(icell);
        inst.setReviewCycleNode(node);
        return inst;
    }

    @Override
    public List getReviewCycles() {
        return this.reviewCycleDAO.getAll();
    }

    public void setReviewCyclePositionTypeDAO(ReviewCyclePositionTypeDAO reviewCyclePositionTypeDAO) {
        this.reviewCyclePositionTypeDAO = reviewCyclePositionTypeDAO;
    }

    public void setRealmDAO(RealmDAO realmDAO) {
        this.realmDAO = realmDAO;
    }

    public void setReviewCycleCellDAO(ReviewCycleCellDAO reviewCycleCellDAO) {
        this.reviewCycleCellDAO = reviewCycleCellDAO;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    public void setReviewCycleNodeDAO(ReviewCycleNodeDAO reviewCycleNodeDAO) {
        this.reviewCycleNodeDAO = reviewCycleNodeDAO;
    }

    public ReviewCycleCellConnectionDAO getReviewCycleCellConnectionDAO() {
        return this.reviewCycleCellConnectionDAO;
    }

    public void setReviewCycleCellConnectionDAO(ReviewCycleCellConnectionDAO reviewCycleCellConnectionDAO) {
        this.reviewCycleCellConnectionDAO = reviewCycleCellConnectionDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setReviewCycleInstanceDAO(ReviewCycleInstanceDAO reviewCycleInstanceDAO) {
        this.reviewCycleInstanceDAO = reviewCycleInstanceDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    @Override
    public ReviewCycleCellInstanceImpl getReviewCycleCellInstance(Integer id) {
        return this.reviewCycleCellInstanceDAO.get(id);
    }

    @Override
    public ReviewCycleCellInstanceImpl insertReviewCycleCellInstance(ReviewCycleCellInstanceImpl instance, List nodes, List freeNodes) {
        instance = this.reviewCycleCellInstanceDAO.save(instance);
        if ((instance = this.updateReviewCycleCellInstance(instance, nodes, freeNodes)).getReviewCycleInstance().getReviewCycleCellInstances() == null) {
            instance.getReviewCycleInstance().setReviewCycleCellInstances(new HashMap());
        }
        instance.getReviewCycleInstance().getReviewCycleCellInstances().put(instance.getId(), instance);
        this.reviewCycleInstanceDAO.update((ReviewCycleInstanceImpl)instance.getReviewCycleInstance());
        return instance;
    }

    @Override
    public ReviewCycleCellInstanceImpl updateReviewCycleCellInstance(ReviewCycleCellInstanceImpl instance, List nodes, List freeNodes) {
        ReviewCycleNodeInstanceImpl nInstance;
        NodeInstanceLine line;
        int i;
        if ((instance = this.reviewCycleCellInstanceDAO.merge(instance)).getReviewCycleNodeInstances() == null) {
            instance.setReviewCycleNodeInstances(new HashMap());
        }
        for (i = 0; i < nodes.size(); ++i) {
            line = (NodeInstanceLine)nodes.get(i);
            nInstance = line.getReviewCycleNodeInstance();
            nInstance.setFree(false);
            nInstance = this.saveOrUpdateReviewCycleNodeInstance(nInstance, line);
            instance.getReviewCycleNodeInstances().put(nInstance.getId(), nInstance);
        }
        if (instance.getFreeReviewCycleNodeInstances() == null) {
            instance.setFreeReviewCycleNodeInstances(new HashMap());
        }
        for (i = 0; i < freeNodes.size(); ++i) {
            line = (NodeInstanceLine)freeNodes.get(i);
            nInstance = line.getReviewCycleNodeInstance();
            nInstance.setFree(true);
            nInstance = this.saveOrUpdateReviewCycleNodeInstance(nInstance, line);
            instance.getFreeReviewCycleNodeInstances().put(nInstance.getId(), nInstance);
        }
        instance = this.reviewCycleCellInstanceDAO.merge(instance);
        ReviewCycleCellInstanceRelease releasedInstance = null;
        ReleasedObjectList relOList = instance.getReviewCycleInstance().getSubProject().getActiveObjectList();
        if (relOList != null) {
            releasedInstance = this.reviewCycleCellInstanceDAO.getReleasedCell(relOList, instance.getReviewCycleInstance(), instance.getReviewCycleCell());
        }
        if (releasedInstance != null && this.hasChangedSinceLastReleased(instance, releasedInstance)) {
            instance.setChanged(1);
        } else if (instance.getChanged() != 2) {
            instance.setChanged(0);
        }
        instance = this.reviewCycleCellInstanceDAO.update(instance);
        this.updateReviewCycleInstanceDurations((ReviewCycleInstanceImpl)instance.getReviewCycleInstance());
        return instance;
    }

    private ReviewCycleNodeInstanceImpl saveOrUpdateReviewCycleNodeInstance(ReviewCycleNodeInstanceImpl nInstance, NodeInstanceLine line) {
        block10: {
            block9: {
                List realms;
                ProjectParticipation participation;
                block11: {
                    if (nInstance.getReviewCyclePositions() != null) {
                        for (ReviewCyclePositionImpl pos : nInstance.getReviewCyclePositions().values()) {
                            this.reviewCyclePositionDAO.delete(pos);
                        }
                        nInstance.getReviewCyclePositions().clear();
                    }
                    if (nInstance.getId() == null || nInstance.getId() < 1) {
                        nInstance.setId(null);
                        nInstance = this.reviewCycleNodeInstanceDAO.save(nInstance);
                    } else {
                        nInstance = this.reviewCycleNodeInstanceDAO.merge(nInstance);
                    }
                    if (nInstance.getReviewCycleNode().getReviewType() != 1 && nInstance.getReviewCycleNode().getReviewType() != 2 && (nInstance.getReviewCycleNode().getReviewType() != 5 || line.getMatrixEditMap().getX().size() != 1)) break block9;
                    ProjectParticipation par = line.getSingleSelected();
                    participation = null;
                    if (par == null) break block10;
                    participation = this.projectParticipationDAO.get(par.getId());
                    realms = this.getRealmsByType(nInstance.getReviewCycleNode().getReviewCyclePositionType().getId(), participation.getProject().getId());
                    if (realms != null && realms.size() != 0) break block11;
                    ReviewCyclePositionImpl pos = new ReviewCyclePositionImpl();
                    pos.setReviewCycleNodeInstance(nInstance);
                    pos.setProjectParticipation(participation);
                    pos.setReviewCycleNodeInstance(nInstance);
                    pos = this.reviewCyclePositionDAO.save(pos);
                    if (nInstance.getReviewCyclePositions() == null) {
                        nInstance.setReviewCyclePositions(new HashMap());
                    }
                    nInstance.getReviewCyclePositions().put(pos.getId(), pos);
                    break block10;
                }
                Iterator rIt = realms.iterator();
                if (!rIt.hasNext()) break block10;
                Realm realm = (Realm)rIt.next();
                ReviewCyclePositionImpl pos = new ReviewCyclePositionImpl();
                pos.setReviewCycleNodeInstance(nInstance);
                pos.setProjectParticipation(participation);
                pos.setRealm(realm);
                pos.setReviewCycleNodeInstance(nInstance);
                pos = this.reviewCyclePositionDAO.save(pos);
                if (nInstance.getReviewCyclePositions() == null) {
                    nInstance.setReviewCyclePositions(new HashMap());
                }
                nInstance.getReviewCyclePositions().put(pos.getId(), pos);
                break block10;
            }
            MatrixEditMap map = line.getMatrixEditMap();
            Collection selected = map.getSelected();
            if (selected != null) {
                for (MatrixEditItem item : selected) {
                    ReviewCyclePositionImpl pos = new ReviewCyclePositionImpl();
                    pos.setReviewCycleNodeInstance(nInstance);
                    ProjectParticipation participation = this.projectParticipationDAO.get(item.getYId());
                    Realm realm = this.realmDAO.get(item.getXId());
                    pos.setProjectParticipation(participation);
                    pos.setRealm(realm);
                    pos.setReviewCycleNodeInstance(nInstance);
                    pos = this.reviewCyclePositionDAO.save(pos);
                    if (nInstance.getReviewCyclePositions() == null) {
                        nInstance.setReviewCyclePositions(new HashMap());
                    }
                    nInstance.getReviewCyclePositions().put(pos.getId(), pos);
                }
            }
        }
        return this.reviewCycleNodeInstanceDAO.update(nInstance);
    }

    @Override
    public void updateReviewCycleInstanceDurations(ReviewCycleInstanceImpl instance) {
        Iterator cellIt = instance.getReviewCycleCellInstances().values().iterator();
        instance.setDurationMin(0);
        instance.setDuration(0);
        while (cellIt.hasNext()) {
            ReviewCycleCellInstance cellInstance = (ReviewCycleCellInstance)cellIt.next();
            if (!cellInstance.getReviewCycleCell().getReviewCycleEntryCondition().isDefaultStartCell()) continue;
            Pair<Integer, Integer> durations = this.recursiveCalculateDurations(cellInstance.getFirstNodeInstance());
            int preDuration = cellInstance.getReviewCycleInstance().getPreDuration();
            if (preDuration > 0 && this.isReversePreduration()) {
                instance.setDuration((Integer)durations.getFirst() + preDuration);
                instance.setDurationMin((Integer)durations.getSecond() + preDuration);
                break;
            }
            instance.setDuration((Integer)durations.getFirst());
            instance.setDurationMin((Integer)durations.getSecond());
            break;
        }
        this.reviewCycleInstanceDAO.update(instance);
    }

    @Override
    public Pair<Integer, Integer> calculateReviewCycleInstanceRemainingDurations(ReviewCycleNodeInstance node) {
        Pair<Integer, Integer> durations = this.recursiveCalculateDurations(node);
        int Duration2 = (Integer)durations.getFirst();
        int DurationMin = (Integer)durations.getSecond();
        Integer preDuration = node.getReviewCycleCellInstance().getReviewCycleInstance().getPreDuration();
        if (preDuration > 0 && this.isReversePreduration()) {
            Duration2 += preDuration.intValue();
            DurationMin += preDuration.intValue();
        }
        return new Pair((Object)Duration2, (Object)DurationMin);
    }

    private Pair<Integer, Integer> recursiveCalculateDurations(ReviewCycleNodeInstance firstNodeInstance) {
        ReviewCycleCellInstanceBase nextCellInstance;
        Integer total_duration = new Integer(0);
        Integer total_duration_min = new Integer(0);
        ReviewCycleCellInstance cellInstance = firstNodeInstance.getReviewCycleCellInstance();
        Iterator it = cellInstance.getReviewCycleCell().getLeavingConnections() != null ? cellInstance.getReviewCycleCell().getLeavingConnections().values().iterator() : null;
        ReviewCycleCellConnection connection = null;
        ReviewCycleNodeInstance nodeInstance = firstNodeInstance;
        Project project = firstNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getSubProject().getProject();
        while (nodeInstance != null) {
            boolean skipNode = false;
            ReviewCycleNode node = nodeInstance.getReviewCycleNode();
            if (node.getSkippingRule() != null && !node.getSkippingRule().isEmpty() && this.reviewOperations.verifyReviewCycleNodeSkippingRuleForProject(node, project)) {
                skipNode = true;
            }
            if (!skipNode && (nodeInstance.getReviewCyclePositions() != null && !nodeInstance.getReviewCyclePositions().isEmpty() || nodeInstance.getReviewCycleNode().isEndNode() && !nodeInstance.getReviewCycleNode().getReviewCycleCell().isEndCell())) {
                total_duration_min = total_duration_min + nodeInstance.getDurationMin();
                total_duration = total_duration + nodeInstance.getDuration();
            }
            nodeInstance = cellInstance.getNextNodeInstance(nodeInstance);
        }
        while (it != null && it.hasNext() && !(connection = (ReviewCycleCellConnection)it.next()).isDefaultConnection()) {
        }
        if (connection != null && connection.isDefaultConnection() && (nextCellInstance = firstNodeInstance instanceof ReviewCycleNodeInstanceRelease ? this.reviewCycleCellInstanceDAO.getReleased(cellInstance.getReviewCycleInstance().getId(), connection.getDestinationCell().getId()) : this.reviewCycleCellInstanceDAO.getUnreleased(cellInstance.getReviewCycleInstance(), connection.getDestinationCell())) != null && nextCellInstance.getFirstNodeInstance() != null) {
            Pair<Integer, Integer> sub = this.recursiveCalculateDurations(nextCellInstance.getFirstNodeInstance());
            total_duration = total_duration + (Integer)sub.getFirst();
            total_duration_min = total_duration_min + (Integer)sub.getSecond();
        }
        return new Pair((Object)total_duration, (Object)total_duration_min);
    }

    @Override
    public List createReleasable(Integer subProjectId) {
        List instances = this.reviewCycleInstanceDAO.getAll(subProjectId);
        ArrayList<ReviewCycleInstanceRelease> result = new ArrayList<ReviewCycleInstanceRelease>();
        for (int i = 0; i < instances.size(); ++i) {
            Iterator cells;
            ReviewCycleInstance r = (ReviewCycleInstance)instances.get(i);
            ReviewCycleInstanceRelease rr = new ReviewCycleInstanceRelease(r);
            Iterator iterator = cells = r.getReviewCycleCellInstances() != null ? r.getReviewCycleCellInstances().values().iterator() : null;
            while (cells != null && cells.hasNext()) {
                ReviewCyclePositionReleaseImpl rp;
                ReviewCyclePosition p;
                Iterator positions;
                ReviewCycleNodeInstanceRelease rn;
                ReviewCycleNodeInstanceImpl n;
                Iterator nodes;
                ReviewCycleCellInstance c = (ReviewCycleCellInstance)cells.next();
                ReviewCycleCellInstanceRelease rc = new ReviewCycleCellInstanceRelease(c);
                rc.setReviewCycleNodeInstances(new HashMap());
                rc.setFreeReviewCycleNodeInstances(new HashMap());
                rc.setReviewCycleInstance(rr);
                rc.setId(c.getId());
                rr.getReviewCycleCellInstances().put(rc.getId(), rc);
                Iterator iterator2 = nodes = c.getReviewCycleNodeInstances() != null ? c.getReviewCycleNodeInstances().values().iterator() : null;
                while (nodes != null && nodes.hasNext()) {
                    n = (ReviewCycleNodeInstanceImpl)nodes.next();
                    rn = new ReviewCycleNodeInstanceRelease(n);
                    rn.setReviewCyclePositions(new HashMap());
                    rn.setReviewCycleCellInstance(rc);
                    rn.setId(n.getId());
                    rc.getReviewCycleNodeInstances().put(rn.getId(), rn);
                    Iterator iterator3 = positions = n.getReviewCyclePositions() != null ? n.getReviewCyclePositions().values().iterator() : null;
                    while (positions != null && positions.hasNext()) {
                        p = (ReviewCyclePosition)positions.next();
                        rp = new ReviewCyclePositionReleaseImpl(p);
                        rp.setReviewCycleNodeInstance(rn);
                        rp.setId(p.getId());
                        rn.getReviewCyclePositions().put(rp.getId(), rp);
                    }
                    rn.setReviewCycleCellInstance(rc);
                }
                Iterator iterator4 = nodes = c.getFreeReviewCycleNodeInstances() != null ? c.getFreeReviewCycleNodeInstances().values().iterator() : null;
                while (nodes != null && nodes.hasNext()) {
                    n = (ReviewCycleNodeInstanceImpl)nodes.next();
                    rn = new ReviewCycleNodeInstanceRelease(n);
                    rn.setReviewCyclePositions(new HashMap());
                    rn.setReviewCycleCellInstance(rc);
                    rn.setId(n.getId());
                    rc.getFreeReviewCycleNodeInstances().put(rn.getId(), rn);
                    Iterator iterator5 = positions = n.getReviewCyclePositions() != null ? n.getReviewCyclePositions().values().iterator() : null;
                    while (positions != null && positions.hasNext()) {
                        p = (ReviewCyclePosition)positions.next();
                        rp = new ReviewCyclePositionReleaseImpl(p);
                        rp.setReviewCycleNodeInstance(rn);
                        rp.setId(p.getId());
                        rn.getReviewCyclePositions().put(rp.getId(), rp);
                    }
                    rn.setReviewCycleCellInstance(rc);
                }
                rc.setReviewCycleInstance(rr);
            }
            result.add(rr);
        }
        return result;
    }

    @Override
    public List releaseReviewCycleInstances(List releases, ReleasedObjectList objectList) {
        ArrayList<ReviewCycleInstanceRelease> res = new ArrayList<ReviewCycleInstanceRelease>();
        for (int i = 0; i < releases.size(); ++i) {
            res.add(this.releaseReviewCycleInstance((ReviewCycleInstanceRelease)releases.get(i), objectList));
        }
        return res;
    }

    @Override
    public ReviewCycleInstanceRelease updateReviewCycleInstanceRelease(ReviewCycleInstanceRelease rr) {
        return this.reviewCycleInstanceDAO.update(rr);
    }

    public ReviewCycleInstanceRelease releaseReviewCycleInstance(ReviewCycleInstanceRelease rr, ReleasedObjectList objectList) {
        Iterator cells;
        rr.setId(null);
        rr.setObjectList(objectList);
        Map cellMap = rr.getReviewCycleCellInstances();
        rr.setReviewCycleCellInstances(new HashMap());
        rr = this.reviewCycleInstanceDAO.save(rr);
        Iterator iterator = cells = cellMap != null ? cellMap.values().iterator() : null;
        while (cells != null && cells.hasNext()) {
            Map posMap;
            ReviewCycleNodeInstanceRelease rn;
            Object o;
            Iterator nodes;
            ReviewCycleCellInstanceRelease rc = (ReviewCycleCellInstanceRelease)cells.next();
            rc.setId(null);
            Map nodeMap = rc.getReviewCycleNodeInstances();
            rc.setReviewCycleNodeInstances(new HashMap());
            rc.setReviewCycleInstance(rr);
            int rccchange = this.reviewCycleCellInstanceDAO.get(rc.getReviewCycleCellInstance().getId()).getChanged();
            rc.setChanged(rccchange);
            rc = this.reviewCycleCellInstanceDAO.save(rc);
            rr.getReviewCycleCellInstances().put(rc.getId(), rc);
            Iterator iterator2 = nodes = nodeMap != null ? nodeMap.values().iterator() : null;
            while (nodes != null && nodes.hasNext()) {
                Iterator positions;
                o = nodes.next();
                rn = (ReviewCycleNodeInstanceRelease)o;
                rn.setId(null);
                posMap = rn.getReviewCyclePositions();
                rn.setReviewCycleCellInstance(rc);
                ReviewCycleNodeInstanceImpl nImpl = this.reviewCycleNodeInstanceDAO.get(rn.getReviewCycleNodeInstance().getId());
                rn.setReviewCycleNodeInstance(nImpl);
                rn.setReviewCyclePositions(new HashMap());
                rn = this.reviewCycleNodeInstanceDAO.save(rn);
                rc.getReviewCycleNodeInstances().put(rn.getId(), rn);
                Iterator iterator3 = positions = posMap != null ? posMap.values().iterator() : null;
                while (positions != null && positions.hasNext()) {
                    ReviewCyclePositionReleaseImpl rp = (ReviewCyclePositionReleaseImpl)positions.next();
                    rp.setReviewCycleNodeInstance(rn);
                    rp.setId(null);
                    rp = this.reviewCyclePositionDAO.save(rp);
                    rn.getReviewCyclePositions().put(rp.getId(), rp);
                }
                rn.setReviewCycleCellInstance(rc);
            }
            nodeMap = rc.getFreeReviewCycleNodeInstances();
            rc.setFreeReviewCycleNodeInstances(new HashMap());
            Iterator iterator4 = nodes = nodeMap != null ? nodeMap.values().iterator() : null;
            while (nodes != null && nodes.hasNext()) {
                Iterator positions;
                o = nodes.next();
                rn = (ReviewCycleNodeInstanceRelease)o;
                rn.setId(null);
                posMap = rn.getReviewCyclePositions();
                rn.setReviewCycleCellInstance(rc);
                rn.setReviewCyclePositions(new HashMap());
                rn = this.reviewCycleNodeInstanceDAO.save(rn);
                rc.getFreeReviewCycleNodeInstances().put(rn.getId(), rn);
                Iterator iterator5 = positions = posMap != null ? posMap.values().iterator() : null;
                while (positions != null && positions.hasNext()) {
                    ReviewCyclePositionReleaseImpl rp = (ReviewCyclePositionReleaseImpl)positions.next();
                    rp.setReviewCycleNodeInstance(rn);
                    rp.setId(null);
                    rp = this.reviewCyclePositionDAO.save(rp);
                    rn.getReviewCyclePositions().put(rp.getId(), rp);
                }
                rn.setReviewCycleCellInstance(rc);
            }
            rc.setReviewCycleInstance(rr);
        }
        ReviewCycleInstanceImpl instance = this.getReviewCycleInstance(rr.getReviewCycleInstance().getId(), false);
        ArrayList cellInstances = new ArrayList(instance.getReviewCycleCellInstances().values());
        if (cellInstances != null) {
            for (ReviewCycleCellInstanceImpl cellInstance : cellInstances) {
                cellInstance.setChanged(0);
                this.reviewCycleCellInstanceDAO.merge(cellInstance);
            }
        }
        rr.setChanged(instance.getChanged());
        rr = this.reviewCycleInstanceDAO.update(rr);
        instance.setChanged(0);
        this.reviewCycleInstanceDAO.update(instance);
        return rr;
    }

    @Override
    public ReviewCycleInstanceRelease getReleased(Integer releasedObjectListId, Integer reviewCycleInstanceImplId) {
        if (releasedObjectListId == null || reviewCycleInstanceImplId == null) {
            return null;
        }
        return this.reviewCycleInstanceDAO.getReleased(releasedObjectListId, reviewCycleInstanceImplId);
    }

    @Override
    public List<ReviewCycleInstanceRelease> getAllReleased(ReleasedObjectList objectList) {
        if (objectList == null) {
            return null;
        }
        return this.reviewCycleInstanceDAO.getAllReleased(objectList);
    }

    public void setReviewCycleCellInstanceDAO(ReviewCycleCellInstanceDAO reviewCycleCellInstanceDAO) {
        this.reviewCycleCellInstanceDAO = reviewCycleCellInstanceDAO;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setReviewCyclePositionDAO(ReviewCyclePositionDAO reviewCyclePositionDAO) {
        this.reviewCyclePositionDAO = reviewCyclePositionDAO;
    }

    @Override
    public ReviewCycleNode insertReviewCycleNodeCrossCommentConnection(ReviewCycleNode reviewCycleNode, Integer node2CommentId) {
        ReviewCycleNode node2Comment = this.reviewCycleNodeDAO.get(node2CommentId);
        if (reviewCycleNode.getNodeCrossCommentConnections() == null) {
            reviewCycleNode.setNodeCrossCommentConnections(new HashMap());
        }
        reviewCycleNode.getNodeCrossCommentConnections().put(node2Comment.getId(), node2Comment);
        this.reviewCycleNodeDAO.update(reviewCycleNode);
        return reviewCycleNode;
    }

    @Override
    public ReviewCycleNode deleteReviewCycleNodeCrossCommentConnection(ReviewCycleNode reviewCycleNode, Integer node2CommentId) {
        if (reviewCycleNode.getNodeCrossCommentConnections() == null) {
            return reviewCycleNode;
        }
        reviewCycleNode.getNodeCrossCommentConnections().remove(node2CommentId);
        this.reviewCycleNodeDAO.update(reviewCycleNode);
        return reviewCycleNode;
    }

    @Override
    public ReviewCycleNodeInstanceListener insertAndUpdateReviewCycleNodeInstanceListener(ReviewCycleNodeInstanceListener listener) {
        return this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listener);
    }

    public void setNotificationDAO(NotificationDAO notificationDAO) {
        this.notificationDAO = notificationDAO;
    }

    public List getProjectParticipationsLegacy(Integer projectId, Integer roleTypeId, Locale locale, Integer subProjectId, boolean showMarkedForDeletion) {
        ArrayList<ProjectParticipation> ret = new ArrayList<ProjectParticipation>();
        List<ProjectParticipation> pps = this.projectParticipationDAO.getAll(projectId, roleTypeId, showMarkedForDeletion, false);
        if (this.projectDAO.get(projectId).isWithSubProjectRestrictions() && subProjectId != null) {
            for (ProjectParticipation pp : pps) {
                if (pp.getExcludedSubProjects().containsKey(subProjectId)) continue;
                ret.add(pp);
            }
            Collections.sort(ret, new ProjectParticipationComparator(locale, true));
            return ret;
        }
        Collections.sort(pps, new ProjectParticipationComparator(locale, true));
        return pps;
    }

    @Override
    public List<ProjectParticipation> getProjectParticipations(Integer projectId, Integer roleTypeId, Locale locale, Integer subProjectId, boolean showMarkedForDeletion, boolean showInvalidated) {
        ArrayList<ProjectParticipation> ret = new ArrayList<ProjectParticipation>(this.projectParticipationDAO.getAll(projectId, roleTypeId, showMarkedForDeletion, showInvalidated));
        if (subProjectId != null && this.projectDAO.get(projectId).isWithSubProjectRestrictions()) {
            ArrayList<ProjectParticipation> validPPs = new ArrayList<ProjectParticipation>();
            for (ProjectParticipation pp : ret) {
                if (pp.getExcludedSubProjects().containsKey(subProjectId)) continue;
                validPPs.add(pp);
            }
            Collections.sort(validPPs, new ProjectParticipationComparator(locale, true));
            return validPPs;
        }
        Collections.sort(ret, new ProjectParticipationComparator(locale, true));
        return ret;
    }

    @Override
    public ReviewCycleInstanceRelease getReleasedReviewCycleInstance(Integer reviewCycleInstanceId, boolean checkProjectsAllowedFinalReviewCycleCell) {
        if (checkProjectsAllowedFinalReviewCycleCell) {
            ReviewCycleInstanceRelease reviewCycleInstance = this.reviewCycleInstanceDAO.getReleased(reviewCycleInstanceId);
            List reviewCycleCellInstances = reviewCycleInstance.getReviewCycleCellInstancesSortedByPosition();
            HashMap<Integer, ReviewCycleCellInstanceRelease> validReviewCycleCellInstances = new HashMap<Integer, ReviewCycleCellInstanceRelease>();
            for (ReviewCycleCellInstanceRelease reviewCycleCellInstance : reviewCycleCellInstances) {
                reviewCycleCellInstance.setProjectsAllowedFinalReviewCycleCell(this.isProjectsAllowedFinalReviewCycleCell(reviewCycleCellInstance));
                if (!reviewCycleCellInstance.isProjectsAllowedFinalReviewCycleCell()) continue;
                validReviewCycleCellInstances.put(reviewCycleCellInstance.getId(), reviewCycleCellInstance);
            }
            reviewCycleInstance.setReviewCycleCellInstances(validReviewCycleCellInstances);
            return reviewCycleInstance;
        }
        return this.reviewCycleInstanceDAO.getReleased(reviewCycleInstanceId);
    }

    @Override
    public List getRealmsByType(Integer reviewCyclePositionTypeId, Integer projectId) {
        List list = this.realmDAO.getAllofProject(projectId, reviewCyclePositionTypeId);
        Collections.sort(list, new RealmCodeNameComparator());
        return list;
    }

    @Override
    public List getRealmsForObjectList(Integer reviewCyclePositionTypeId, Integer projectId, Date released) {
        List list = this.realmDAO.getAllOfProjectForObjectList(projectId, reviewCyclePositionTypeId, released);
        Collections.sort(list, new RealmCodeNameComparator());
        return list;
    }

    private List<ReviewCycleInstanceRelease> getAllReviewCycleInstanceReleasesForUnreleased(Integer reviewCycleInstanceImplId) {
        return this.reviewCycleInstanceDAO.getAllReleased(reviewCycleInstanceImplId);
    }

    @Override
    public void deleteReviewCycleInstance(ReviewCycleInstanceImpl instance) {
        List<ReviewCycleInstanceRelease> releases = this.getAllReviewCycleInstanceReleasesForUnreleased(instance.getId());
        for (ReviewCycleInstanceRelease released : releases) {
            if (released.getReviewCycleCellInstances() != null) {
                Iterator it = released.getReviewCycleCellInstances().values().iterator();
                while (it.hasNext()) {
                    this.delete((ReviewCycleCellInstance)it.next());
                }
            }
            this.reviewCycleInstanceDAO.delete(released);
        }
        if (instance.getReviewCycleCellInstances() != null) {
            Iterator it = instance.getReviewCycleCellInstances().values().iterator();
            while (it.hasNext()) {
                this.delete((ReviewCycleCellInstance)it.next());
            }
        }
        this.reviewCycleInstanceDAO.delete(instance);
    }

    public void delete(ReviewCycleCellInstance instance) {
        Iterator it;
        if (instance.getReviewCycleNodeInstances() != null) {
            it = instance.getReviewCycleNodeInstances().values().iterator();
            while (it.hasNext()) {
                this.delete((ReviewCycleNodeInstance)it.next());
            }
        }
        if (instance.getFreeReviewCycleNodeInstances() != null) {
            it = instance.getFreeReviewCycleNodeInstances().values().iterator();
            while (it.hasNext()) {
                this.delete((ReviewCycleNodeInstance)it.next());
            }
        }
        if (instance instanceof ReviewCycleCellInstanceImpl) {
            this.reviewCycleCellInstanceDAO.delete((ReviewCycleCellInstanceImpl)instance);
        } else {
            this.reviewCycleCellInstanceDAO.delete((ReviewCycleCellInstanceRelease)instance);
        }
    }

    public void delete(ReviewCycleNodeInstance instance) {
        List notifications;
        if (instance.getReviewCyclePositions() != null) {
            Iterator it = instance.getReviewCyclePositions().values().iterator();
            while (it.hasNext()) {
                this.delete((ReviewCyclePosition)it.next());
            }
        }
        if ((notifications = this.notificationDAO.getAll(instance.getId())) != null) {
            Iterator it4 = notifications.iterator();
            while (it4.hasNext()) {
                this.delete((ReviewCycleNodeInstanceNotification)it4.next());
            }
        }
        Collection<ReviewCycleNodeInstanceListener> nodeInstPlottOrderListeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(instance.getId());
        for (ReviewCycleNodeInstanceListener listener : nodeInstPlottOrderListeners) {
            if (listener instanceof ReviewCycleNodeInstancePlottOrderListener) {
                this.reviewCycleNodeListenerDAO.delete((ReviewCycleNodeInstancePlottOrderListener)listener);
                continue;
            }
            this.reviewCycleNodeListenerDAO.delete((ReviewCycleNodeInstanceNotification)listener);
        }
        if (instance instanceof ReviewCycleNodeInstanceImpl) {
            this.reviewCycleNodeInstanceDAO.delete((ReviewCycleNodeInstanceImpl)instance);
        } else {
            this.reviewCycleNodeInstanceDAO.delete((ReviewCycleNodeInstanceRelease)instance);
        }
    }

    public void delete(ReviewCyclePosition instance) {
        if (instance instanceof ReviewCyclePositionImpl) {
            this.reviewCyclePositionDAO.delete((ReviewCyclePositionImpl)instance);
        } else {
            this.reviewCyclePositionDAO.delete((ReviewCyclePositionReleaseImpl)instance);
        }
    }

    public void delete(ReviewCycleNodeInstanceNotification notification) {
        this.notificationDAO.delete(notification);
    }

    @Override
    public void deleteProjectRealm(Realm realm) {
        this.realmDAO.delete(realm);
    }

    @Override
    public List getRealms(Integer projectId) {
        return this.realmDAO.getAllofProject(projectId, null);
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setReviewCycleCommentTypeDAO(ReviewCycleCommentTypeDAO reviewCycleCommentTypeDAO) {
        this.reviewCycleCommentTypeDAO = reviewCycleCommentTypeDAO;
    }

    @Override
    public List getReviewCycleCommentTypes() {
        return this.reviewCycleCommentTypeDAO.getAll();
    }

    @Override
    public ReviewCycleCommentType insertReviewCycleCommentType(ReviewCycleCommentType type, List updates) {
        type = this.reviewCycleCommentTypeDAO.save(type);
        type.setReviewCycleCommentOptions(new HashMap());
        for (int i = 0; i < updates.size(); ++i) {
            ReviewCycleCommentOption opt = (ReviewCycleCommentOption)updates.get(i);
            if (opt.getName() == null || opt.getName().length() == 0) continue;
            opt.setReviewCycleCommentType(type);
            opt.setId(null);
            opt = this.reviewCycleCommentOptionDAO.save(opt);
            type.getReviewCycleCommentOptions().put(opt.getId(), opt);
        }
        return type;
    }

    @Override
    public ReviewCycleCommentType updateReviewCycleCommentType(ReviewCycleCommentType type, List updates, List deletedKeys) {
        int i;
        for (i = 0; i < updates.size(); ++i) {
            ReviewCycleCommentOption opt = (ReviewCycleCommentOption)updates.get(i);
            opt.setReviewCycleCommentType(type);
            if (opt.getId() == null && opt.getName() != null && opt.getName().length() > 0) {
                opt.setId(null);
                opt = this.reviewCycleCommentOptionDAO.save(opt);
                type.getReviewCycleCommentOptions().put(opt.getId(), opt);
                continue;
            }
            if (opt.getId() == null) continue;
            this.reviewCycleCommentOptionDAO.update(opt);
        }
        for (i = 0; i < deletedKeys.size(); ++i) {
            this.reviewCycleCommentOptionDAO.delete((ReviewCycleCommentOption)type.getReviewCycleCommentOptions().get(deletedKeys.get(i)));
            type.getReviewCycleCommentOptions().remove(deletedKeys.get(i));
        }
        return this.reviewCycleCommentTypeDAO.update(type);
    }

    public void setReviewCycleCommentOptionDAO(ReviewCycleCommentOptionDAO reviewCycleCommentOptionDAO) {
        this.reviewCycleCommentOptionDAO = reviewCycleCommentOptionDAO;
    }

    @Override
    public ReviewCycleCommentType getReviewCycleCommentType(Integer typeId) {
        return this.reviewCycleCommentTypeDAO.get(typeId);
    }

    @Override
    public ReviewCycleNode updateReviewCycleNode(ReviewCycleNode reviewCycleNode) {
        return this.reviewCycleNodeDAO.update(reviewCycleNode);
    }

    @Override
    public ReviewCycleNodeInstance getReviewCycleNodeInstance(Integer reviewCycleNodeInstanceId) {
        return this.reviewCycleNodeInstanceDAO.get(reviewCycleNodeInstanceId);
    }

    public void setReviewCycleNodeListenerDAO(ReviewCycleNodeListenerDAO reviewCycleNodeListenerDAO) {
        this.reviewCycleNodeListenerDAO = reviewCycleNodeListenerDAO;
    }

    @Override
    public ReviewCycleNode updateReviewCycleNodeListeners(ReviewCycleNode reviewCycleNode, List<ReviewCycleNodeListener> updates, List<Integer> deletedKeys) {
        if (reviewCycleNode.getListeners() == null) {
            reviewCycleNode.setListeners(new HashMap());
        }
        for (ReviewCycleNodeListener listener : updates) {
            listener.setReviewCycleNode(reviewCycleNode);
            if (listener.getId() == null || listener.getId() < 1) {
                if (listener.getName() == null || listener.getPosition() == null) continue;
                this.reviewCycleNodeListenerDAO.save(listener);
                reviewCycleNode.getListeners().put(listener.getId(), listener);
                continue;
            }
            this.reviewCycleNodeListenerDAO.update(listener);
        }
        for (Integer id : deletedKeys) {
            reviewCycleNode.getListeners().remove(id);
            if (id == null) continue;
            this.reviewCycleNodeListenerDAO.delete(this.reviewCycleNodeListenerDAO.get(id));
        }
        return this.reviewCycleNodeDAO.update(reviewCycleNode);
    }

    @Override
    public ReviewCycleNodeListener moveReviewCycleNodeListener(Integer reviewCycleNodeListenerId, Integer newReviewCycleNodeId, boolean isPreListener) {
        ReviewCycleNodeListener reviewCycleNodeListener = this.reviewCycleNodeListenerDAO.get(reviewCycleNodeListenerId);
        ReviewCycleNode newReviewCycleNode = this.reviewCycleNodeDAO.get(newReviewCycleNodeId);
        if (!reviewCycleNodeListener.getReviewCycleNode().getReviewCycleCell().getReviewCycle().getId().equals(newReviewCycleNode.getReviewCycleCell().getReviewCycle().getId())) {
            throw new ActionException("Cannot move a ReviewCycleNodeListener between two different ReviewCycles.");
        }
        Collection<ReviewCycleNodeInstanceListener> instances = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeListenerInstances(reviewCycleNodeListenerId);
        for (ReviewCycleNodeInstanceListener instance : instances) {
            ReviewCycleInstance reviewCycleInstance = instance.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance();
            ReviewCycleNodeInstanceImpl newNodeInstance = this.reviewCycleNodeInstanceDAO.getUnreleased(reviewCycleInstance, newReviewCycleNode);
            instance.setReviewCycleNodeInstance(newNodeInstance);
            this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(instance);
        }
        reviewCycleNodeListener.setPreListener(isPreListener);
        reviewCycleNodeListener.setReviewCycleNode(newReviewCycleNode);
        return this.reviewCycleNodeListenerDAO.update(reviewCycleNodeListener);
    }

    @Override
    public List getRealmTemplates(Integer typeId) {
        return this.realmDAO.getTemplatesOfType(typeId);
    }

    @Override
    public void updateRealmTemplates(Integer typeId, List updates, List deletedKeys) {
        this.updateRealms(typeId, null, updates, deletedKeys);
    }

    @Override
    public void deleteReviewCycleCommentType(Integer reviewCycleCommentTypeId) {
        ReviewCycleCommentType reviewCycleCommentType = this.reviewCycleCommentTypeDAO.get(reviewCycleCommentTypeId);
        if (reviewCycleCommentType.getReviewCycleCommentOptions() != null && reviewCycleCommentType.getReviewCycleCommentOptions().size() != 0) {
            Collection values = reviewCycleCommentType.getReviewCycleCommentOptions().values();
            for (ReviewCycleCommentOption type : values) {
                this.reviewCycleCommentOptionDAO.delete(type);
            }
            reviewCycleCommentType.getReviewCycleCommentOptions().clear();
        }
        this.reviewCycleCommentTypeDAO.delete(reviewCycleCommentType);
    }

    @Override
    public ReviewCycleResultOption getReviewCycleResultOption(Integer id) {
        return this.reviewCycleResultOptionDAO.get(id);
    }

    @Override
    public List<ReviewCycleResultOption> getReviewCycleResultOptionsOfNetwork(Integer networkId) {
        ArrayList<ReviewCycleResultOption> result = new ArrayList<ReviewCycleResultOption>();
        Network network = this.networkDAO.get(networkId);
        for (ReviewCycle reviewCycle : network.getReviewCycles().values()) {
            for (ReviewCycleCell reviewCycleCell : reviewCycle.getReviewCycleCells().values()) {
                if (!reviewCycleCell.isEndCell()) continue;
                for (ReviewCycleNode reviewCycleNode : reviewCycleCell.getReviewCycleNodes().values()) {
                    for (ReviewCycleResultOption reviewCycleResultOption : reviewCycleNode.getReviewCyclePositionType().getReviewCycleResultOptions().values()) {
                        if (!reviewCycleResultOption.isEvaluateCellConnections()) continue;
                        result.add(reviewCycleResultOption);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void deleteReviewCycleResultOption(Integer reviewCycleResultOptionId) {
        ReviewCycleResultOption option = this.reviewCycleResultOptionDAO.get(reviewCycleResultOptionId);
        if (option.isSampleControlReview()) {
            ReviewCyclePositionType reviewCyclePositionType = this.reviewCyclePositionTypeDAO.get(option.getReviewCyclePositionType().getId());
            reviewCyclePositionType.setSampleControlReviewCyclePositionType(null);
            this.reviewCyclePositionTypeDAO.update(reviewCyclePositionType);
        }
        this.reviewCycleResultOptionDAO.delete(option);
    }

    @Override
    public void deleteReviewCycle(ReviewCycle reviewCycle) {
        List<ReviewCycleInstanceImpl> instances = this.reviewCycleInstanceDAO.getAll(reviewCycle);
        for (ReviewCycleInstanceImpl instance : instances) {
            this.deleteReviewCycleInstance(instance);
        }
        if (reviewCycle.getLabels() != null && !reviewCycle.getLabels().isEmpty()) {
            Collection labels = reviewCycle.getLabels().values();
            for (Label label : labels) {
                this.labelOperations.delete(label.getId());
            }
            reviewCycle.getLabels().clear();
        }
        if (reviewCycle.getReviewCycleCells() != null && !reviewCycle.getReviewCycleCells().isEmpty()) {
            Collection cells = reviewCycle.getReviewCycleCells().values();
            for (ReviewCycleCell cell : cells) {
                this.delete(cell);
            }
        }
        if (reviewCycle.getNetworks() != null && !reviewCycle.getNetworks().isEmpty()) {
            Collection nets = reviewCycle.getNetworks().values();
            for (Network net : nets) {
                net.getReviewCycles().remove(reviewCycle.getId());
            }
        }
        this.reviewCycleDAO.delete(reviewCycle);
    }

    public void delete(ReviewCycleCell cell) {
        Collection list;
        Collection nodes;
        if (cell.getReviewCycleNodes() != null && !cell.getReviewCycleNodes().isEmpty()) {
            nodes = cell.getReviewCycleNodes().values();
            for (ReviewCycleNode node : nodes) {
                this.delete(node);
            }
            cell.getReviewCycleNodes().clear();
        }
        if (cell.getFreeReviewCycleNodes() != null && !cell.getFreeReviewCycleNodes().isEmpty()) {
            nodes = cell.getFreeReviewCycleNodes().values();
            for (ReviewCycleNode node : nodes) {
                this.delete(node);
            }
            cell.getFreeReviewCycleNodes().clear();
        }
        if (cell.getIncommingConnections() != null && !cell.getIncommingConnections().isEmpty()) {
            list = cell.getIncommingConnections().values();
            for (ReviewCycleCellConnection item : list) {
                this.reviewCycleCellConnectionDAO.delete(item);
            }
            cell.getIncommingConnections().clear();
        }
        if (cell.getLeavingConnections() != null && !cell.getLeavingConnections().isEmpty()) {
            list = cell.getLeavingConnections().values();
            for (ReviewCycleCellConnection item : list) {
                this.reviewCycleCellConnectionDAO.delete(item);
            }
            cell.getLeavingConnections().clear();
        }
        this.reviewCycleCellDAO.delete(cell);
    }

    public void delete(ReviewCycleNode node) {
        if (node.getNodeCrossCommentConnections() != null && !node.getNodeCrossCommentConnections().isEmpty()) {
            node.getNodeCrossCommentConnections().clear();
        }
        if (node.getListeners() != null && !node.getListeners().isEmpty()) {
            Collection list = node.getListeners().values();
            for (ReviewCycleNodeListener item : list) {
                this.reviewCycleNodeListenerDAO.delete(item);
            }
            node.getListeners().clear();
        }
        this.reviewCycleNodeDAO.delete(node);
    }

    public void setLabelOperations(LabelOperations labelOperations) {
        this.labelOperations = labelOperations;
    }

    @Override
    public ReviewCycleNodeInstanceListener getReviewCycleNodeInstanceListenerByInstance(Integer listenerId, Integer nodeInstanceId) {
        return this.reviewCycleNodeListenerDAO.getReviewCycleNodeInstanceListener(nodeInstanceId, listenerId);
    }

    @Override
    public ReviewCycleNodeInstanceListener getReviewCycleNodeInstanceListener(Integer nodeInstanceListenerId) {
        return this.reviewCycleNodeListenerDAO.getReviewCycleNodeInstanceListener(nodeInstanceListenerId);
    }

    @Override
    public ReviewCycleNodeListener getReviewCycleNodeListener(Integer nodeListenerId) {
        return this.reviewCycleNodeListenerDAO.get(nodeListenerId);
    }

    @Override
    public boolean isRealmDeleteable(Realm realm) {
        return !this.reviewCyclePositionDAO.getHasUnReleased(realm) && !this.reviewCyclePositionDAO.getHasReleased(realm) && !this.reviewCyclePositionDAO.getOccursInPreviosObjectListRelease(realm);
    }

    @Override
    public boolean isRealmWithNodePositions(Realm realm) {
        return this.reviewCyclePositionDAO.getHasUnReleased(realm);
    }

    @Override
    public boolean isRealmWithReleasedNodePositions(Realm realm) {
        return this.reviewCyclePositionDAO.getHasReleased(realm);
    }

    @Override
    public List<ReviewCyclePositionImpl> checkInvolvedReviewCycleNodes(Integer oldRoleId, ProjectParticipation pp) {
        return this.reviewCyclePositionDAO.getPositionByRoleType(oldRoleId, pp);
    }

    @Override
    public ReviewCyclePositionImpl getReviewCyclePosition(Integer Id) {
        return this.reviewCyclePositionDAO.get(Id);
    }

    @Override
    public void deleteReviewCyclePosition(List<ReviewCyclePositionImpl> rcpl) {
        for (int i = 0; i < rcpl.size(); ++i) {
            this.reviewCyclePositionDAO.delete(rcpl.get(i));
        }
    }

    @Override
    public void updateInvalidateProjectRealm(Realm realm) {
        realm.setValidToDate(new Date(System.currentTimeMillis()));
        this.realmDAO.update(realm);
        this.reviewCyclePositionDAO.deleteReviewCyclePositionsByRealm(realm);
    }

    @Override
    public void deleteReviewCyclePositionsByRealm(Realm realm) {
        this.reviewCyclePositionDAO.deleteReviewCyclePositionsByRealm(realm);
    }

    private boolean hasChangedSinceLastReleased(ReviewCycleInstanceImpl instance, ReviewCycleInstanceRelease releasedInstance) {
        if (releasedInstance == null) {
            return false;
        }
        if (!instance.getName().equals(releasedInstance.getName())) {
            return true;
        }
        if (instance.getDescription() != null && releasedInstance.getDescription() != null && !instance.getDescription().equals(releasedInstance.getDescription())) {
            return true;
        }
        if (instance.getDescription() == null || releasedInstance.getDescription() == null) {
            return true;
        }
        return instance.getDuration() != releasedInstance.getDuration() || instance.getDurationMin() != releasedInstance.getDurationMin() || instance.getPreDuration() != releasedInstance.getPreDuration();
    }

    private boolean hasChangedSinceLastReleased(ReviewCycleCellInstanceImpl instance, ReviewCycleCellInstanceRelease releasedInstance) {
        List nodeInstances = instance.getReviewCycleNodeInstancesSortedByPosition();
        List releasedNodeInstances = releasedInstance.getReviewCycleNodeInstancesSortedByPosition();
        if (nodeInstances == null && releasedNodeInstances == null || nodeInstances.size() == 0 && releasedNodeInstances.size() == 0) {
            return false;
        }
        if (nodeInstances == null || nodeInstances.size() == 0 || releasedNodeInstances == null || releasedNodeInstances.size() == 0 || nodeInstances.size() != releasedNodeInstances.size()) {
            return true;
        }
        for (int i = 0; i < nodeInstances.size(); ++i) {
            ReviewCycleNodeInstanceImpl nodeInstance = (ReviewCycleNodeInstanceImpl)nodeInstances.get(i);
            ReviewCycleNodeInstanceRelease releasedNodeInstance = (ReviewCycleNodeInstanceRelease)releasedNodeInstances.get(i);
            if (nodeInstance.getDuration() != releasedNodeInstance.getDuration() || nodeInstance.getDurationMin() != releasedNodeInstance.getDurationMin()) {
                return true;
            }
            ArrayList positions = new ArrayList(nodeInstance.getReviewCyclePositions().values());
            ArrayList releasedPositions = new ArrayList(releasedNodeInstance.getReviewCyclePositions().values());
            if (positions == null && releasedPositions == null || positions.size() == 0 && releasedPositions.size() == 0) continue;
            if (positions == null || positions.size() == 0 || releasedPositions == null || releasedPositions.size() == 0 || positions.size() != releasedPositions.size()) {
                return true;
            }
            for (int j = 0; j < positions.size(); ++j) {
                boolean positionDeleted = true;
                for (int k = 0; k < releasedPositions.size(); ++k) {
                    if (((ReviewCyclePositionReleaseImpl)releasedPositions.get(k)).getRealm().getId() != ((ReviewCyclePositionImpl)positions.get(j)).getRealm().getId()) continue;
                    positionDeleted = false;
                    if (((ReviewCyclePositionReleaseImpl)releasedPositions.get(k)).getProjectParticipation().getId() == ((ReviewCyclePositionImpl)positions.get(j)).getProjectParticipation().getId()) continue;
                    return true;
                }
                if (!positionDeleted) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateReviewCycleCellInstanceRelease(ReviewCycleCellInstanceRelease release) {
        this.reviewCycleCellInstanceDAO.update(release);
    }

    @Override
    public void insertDetachedCopyOfReviewCycleInstance(ObjectPlannerImpl op) {
        int idx = 0;
        boolean unique = false;
        List allCycleInstances = this.reviewCycleInstanceDAO.getAll(op.getObject().getObjectList().getSubProject().getId());
        ReviewCycleInstance oldRci = op.getReviewCycleInstance();
        while (!unique) {
            boolean foundSame = false;
            for (ReviewCycleInstance cycle : allCycleInstances) {
                if (cycle.getName() == null || !cycle.getName().equals(oldRci.getName() + "~" + idx)) continue;
                ++idx;
                foundSame = true;
                break;
            }
            if (foundSame) continue;
            unique = true;
        }
        ReviewCycleInstanceImpl newRci = new ReviewCycleInstanceImpl();
        newRci.setName(oldRci.getName() + "~" + idx);
        newRci.setChanged(2);
        newRci.setDescription(oldRci.getDescription());
        newRci.setDuration(oldRci.getDuration());
        newRci.setDurationMin(oldRci.getDurationMin());
        newRci.setLabel(oldRci.getLabel());
        newRci.setPreDuration(oldRci.getPreDuration());
        newRci.setReviewCycle(oldRci.getReviewCycle());
        newRci.setSubProject(oldRci.getSubProject());
        newRci = this.reviewCycleInstanceDAO.save(newRci);
        if (oldRci.getReviewCycleCellInstances() != null) {
            Collection oldCellInstances = oldRci.getReviewCycleCellInstances().values();
            for (ReviewCycleCellInstanceImpl oldCellInstance : oldCellInstances) {
                HashMap<Integer, ProjectParticipation> copyRefs;
                Collection refs;
                ReviewCycleNodeInstanceListener listenerCopy;
                Collection<ReviewCycleNodeInstanceListener> nodeListeners;
                ReviewCycleCellInstanceImpl newCellInstance = new ReviewCycleCellInstanceImpl();
                newCellInstance.setChanged(2);
                newCellInstance.setDuration(oldCellInstance.getDuration());
                newCellInstance.setReviewCycleCell(oldCellInstance.getReviewCycleCell());
                newCellInstance.setStartCell(oldCellInstance.isStartCell());
                newCellInstance.setReviewCycleInstance(newRci);
                newCellInstance = this.reviewCycleCellInstanceDAO.save(newCellInstance);
                if (oldCellInstance.getReviewCycleNodeInstances() != null) {
                    Collection oldNodes = oldCellInstance.getReviewCycleNodeInstances().values();
                    for (ReviewCycleNodeInstanceImpl oldNode : oldNodes) {
                        ReviewCycleNodeInstanceImpl newNode = new ReviewCycleNodeInstanceImpl();
                        newNode.setDuration(oldNode.getDuration());
                        newNode.setDurationMin(oldNode.getDurationMin());
                        newNode.setFree(oldNode.isFree());
                        newNode.setReviewCycleNode(oldNode.getReviewCycleNode());
                        newNode.setReviewCycleCellInstance(newCellInstance);
                        newNode = this.reviewCycleNodeInstanceDAO.save(newNode);
                        nodeListeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(oldNode.getId());
                        for (ReviewCycleNodeInstanceListener reviewCycleNodeInstanceListener : nodeListeners) {
                            if (reviewCycleNodeInstanceListener instanceof ReviewCycleNodeInstanceNotification) {
                                listenerCopy = new ReviewCycleNodeInstanceNotification();
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeInstance(newNode);
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeListener(reviewCycleNodeInstanceListener.getReviewCycleNodeListener());
                                refs = ((ReviewCycleNodeInstanceNotification)reviewCycleNodeInstanceListener).getReference().values();
                                copyRefs = new HashMap<Integer, ProjectParticipation>();
                                for (ProjectParticipation ref : refs) {
                                    copyRefs.put(ref.getId(), ref);
                                }
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReference(copyRefs);
                                this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                                continue;
                            }
                            listenerCopy = new ReviewCycleNodeInstancePlottOrderListener();
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeInstance(newNode);
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeListener(reviewCycleNodeInstanceListener.getReviewCycleNodeListener());
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReference(((ReviewCycleNodeInstancePlottOrderListener)reviewCycleNodeInstanceListener).getReference());
                            this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                        }
                        if (oldNode.getReviewCyclePositions() != null) {
                            Collection oldPositions = oldNode.getReviewCyclePositions().values();
                            Iterator iterator = oldPositions.iterator();
                            while (iterator.hasNext()) {
                                ReviewCyclePositionImpl oldPosition = (ReviewCyclePositionImpl)iterator.next();
                                ReviewCyclePositionImpl newPosition = new ReviewCyclePositionImpl();
                                newPosition.setProjectParticipation(oldPosition.getProjectParticipation());
                                newPosition.setRealm(oldPosition.getRealm());
                                newPosition.setReviewCycleNodeInstance(newNode);
                                newPosition = this.reviewCyclePositionDAO.save(newPosition);
                            }
                        }
                        newNode = this.reviewCycleNodeInstanceDAO.merge(newNode);
                    }
                }
                if (oldCellInstance.getFreeReviewCycleNodeInstances() != null) {
                    Collection rcnis = oldCellInstance.getFreeReviewCycleNodeInstances().values();
                    for (ReviewCycleNodeInstanceImpl rcniOriginal : rcnis) {
                        ReviewCycleNodeInstanceImpl rcniCopy = new ReviewCycleNodeInstanceImpl();
                        rcniCopy.setDuration(rcniOriginal.getDuration());
                        rcniCopy.setDurationMin(rcniOriginal.getDurationMin());
                        rcniCopy.setFree(rcniOriginal.isFree());
                        rcniCopy.setReviewCycleNode(rcniOriginal.getReviewCycleNode());
                        rcniCopy.setReviewCycleCellInstance(newCellInstance);
                        rcniCopy = this.reviewCycleNodeInstanceDAO.save(rcniCopy);
                        nodeListeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(rcniOriginal.getId());
                        for (ReviewCycleNodeInstanceListener reviewCycleNodeInstanceListener : nodeListeners) {
                            if (reviewCycleNodeInstanceListener instanceof ReviewCycleNodeInstanceNotification) {
                                listenerCopy = new ReviewCycleNodeInstanceNotification();
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeInstance(rcniCopy);
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeListener(reviewCycleNodeInstanceListener.getReviewCycleNodeListener());
                                refs = ((ReviewCycleNodeInstanceNotification)reviewCycleNodeInstanceListener).getReference().values();
                                copyRefs = new HashMap();
                                for (ProjectParticipation ref : refs) {
                                    copyRefs.put(ref.getId(), ref);
                                }
                                ((ReviewCycleNodeInstanceNotification)listenerCopy).setReference(copyRefs);
                                this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                                continue;
                            }
                            listenerCopy = new ReviewCycleNodeInstancePlottOrderListener();
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeInstance(rcniCopy);
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeListener(reviewCycleNodeInstanceListener.getReviewCycleNodeListener());
                            ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReference(((ReviewCycleNodeInstancePlottOrderListener)reviewCycleNodeInstanceListener).getReference());
                            this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                        }
                        if (rcniOriginal.getReviewCyclePositions() != null) {
                            Collection rcpis = rcniOriginal.getReviewCyclePositions().values();
                            for (ReviewCyclePositionImpl rcpiOriginal : rcpis) {
                                ReviewCyclePositionImpl rcpiCopy = new ReviewCyclePositionImpl();
                                rcpiCopy.setProjectParticipation(rcpiOriginal.getProjectParticipation());
                                rcpiCopy.setRealm(rcpiOriginal.getRealm());
                                rcpiCopy.setReviewCycleNodeInstance(rcniCopy);
                                rcpiCopy = this.reviewCyclePositionDAO.save(rcpiCopy);
                            }
                        }
                        rcniCopy = this.reviewCycleNodeInstanceDAO.merge(rcniCopy);
                    }
                }
                newCellInstance = this.reviewCycleCellInstanceDAO.merge(newCellInstance);
            }
        }
        newRci = this.reviewCycleInstanceDAO.update(newRci);
        op.setReviewCycleInstance(newRci);
        op = this.objectPlannerDAO.update(op);
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    @Override
    public void copyReviewCycleInstances(Integer destinationSubProjectId, List<Integer> reviewCycleInstanceIds, Integer personId) {
        SubProject subProject = this.subProjectDAO.get(destinationSubProjectId);
        Person person = this.personDAO.get(personId);
        Locale locale = new Locale(person.getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        for (Integer rcid : reviewCycleInstanceIds) {
            ReviewCycleInstanceImpl rciOriginal = this.getReviewCycleInstance(rcid, false);
            List allCycleInstances = this.reviewCycleInstanceDAO.getAll(destinationSubProjectId);
            String prefix = i18n.tr("Kopie") + "_";
            int prefixcount = 1;
            String originalName = rciOriginal.getName();
            ArrayList<String> cycleNames = new ArrayList<String>();
            for (ReviewCycleInstance rci : allCycleInstances) {
                if (rci.getName().equals(originalName)) continue;
                cycleNames.add(rci.getName());
            }
            Collections.sort(cycleNames);
            for (String cycleName : cycleNames) {
                if (!cycleName.equals(prefix + prefixcount + originalName)) continue;
                ++prefixcount;
            }
            prefix = prefix + prefixcount;
            ReviewCycleInstanceImpl rciCopy = new ReviewCycleInstanceImpl();
            rciCopy.setName(prefix + rciOriginal.getName());
            rciCopy.setChanged(2);
            rciCopy.setDescription(rciOriginal.getDescription());
            rciCopy.setDuration(rciOriginal.getDuration());
            rciCopy.setDurationMin(rciOriginal.getDurationMin());
            rciCopy.setLabel(rciOriginal.getLabel());
            rciCopy.setPreDuration(rciOriginal.getPreDuration());
            rciCopy.setReviewCycle(rciOriginal.getReviewCycle());
            rciCopy.setSubProject(subProject);
            rciCopy = this.reviewCycleInstanceDAO.save(rciCopy);
            if (rciOriginal.getReviewCycleCellInstances() != null) {
                Collection rccis = rciOriginal.getReviewCycleCellInstances().values();
                for (ReviewCycleCellInstanceImpl rcciOriginal : rccis) {
                    ReviewCyclePositionImpl rcpiCopy;
                    Collection rcpis;
                    HashMap<Integer, ProjectParticipation> copyRefs;
                    Collection refs;
                    ReviewCycleNodeInstanceListener listenerCopy;
                    Collection<ReviewCycleNodeInstanceListener> nodeListeners;
                    ReviewCycleNodeInstanceImpl rcniCopy;
                    Collection rcnis;
                    ReviewCycleCellInstanceImpl rcciCopy = new ReviewCycleCellInstanceImpl();
                    rcciCopy.setChanged(2);
                    rcciCopy.setDuration(rcciOriginal.getDuration());
                    rcciCopy.setReviewCycleCell(rcciOriginal.getReviewCycleCell());
                    rcciCopy.setStartCell(rcciOriginal.isStartCell());
                    rcciCopy.setReviewCycleInstance(rciCopy);
                    rcciCopy = this.reviewCycleCellInstanceDAO.save(rcciCopy);
                    if (rcciOriginal.getReviewCycleNodeInstances() != null) {
                        rcnis = rcciOriginal.getReviewCycleNodeInstances().values();
                        for (ReviewCycleNodeInstanceImpl rcniOriginal : rcnis) {
                            rcniCopy = new ReviewCycleNodeInstanceImpl();
                            rcniCopy.setDuration(rcniOriginal.getDuration());
                            rcniCopy.setDurationMin(rcniOriginal.getDurationMin());
                            rcniCopy.setFree(rcniOriginal.isFree());
                            rcniCopy.setReviewCycleNode(rcniOriginal.getReviewCycleNode());
                            rcniCopy.setReviewCycleCellInstance(rcciCopy);
                            rcniCopy = this.reviewCycleNodeInstanceDAO.save(rcniCopy);
                            nodeListeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(rcniOriginal.getId());
                            for (ReviewCycleNodeInstanceListener reviewCycleNodeInstanceListener : nodeListeners) {
                                if (reviewCycleNodeInstanceListener instanceof ReviewCycleNodeInstanceNotification) {
                                    listenerCopy = new ReviewCycleNodeInstanceNotification();
                                    ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeInstance(rcniCopy);
                                    ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeListener(reviewCycleNodeInstanceListener.getReviewCycleNodeListener());
                                    refs = ((ReviewCycleNodeInstanceNotification)reviewCycleNodeInstanceListener).getReference().values();
                                    copyRefs = new HashMap<Integer, ProjectParticipation>();
                                    for (ProjectParticipation ref : refs) {
                                        copyRefs.put(ref.getId(), ref);
                                    }
                                    ((ReviewCycleNodeInstanceNotification)listenerCopy).setReference(copyRefs);
                                    this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                                    continue;
                                }
                                listenerCopy = new ReviewCycleNodeInstancePlottOrderListener();
                                ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeInstance(rcniCopy);
                                ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeListener(reviewCycleNodeInstanceListener.getReviewCycleNodeListener());
                                ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReference(((ReviewCycleNodeInstancePlottOrderListener)reviewCycleNodeInstanceListener).getReference());
                                this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                            }
                            if (rcniOriginal.getReviewCyclePositions() != null) {
                                rcpis = rcniOriginal.getReviewCyclePositions().values();
                                for (ReviewCyclePositionImpl rcpiOriginal : rcpis) {
                                    if (rcpiOriginal.getProjectParticipation() != null && rcpiOriginal.getProjectParticipation().getExcludedSubProjects().containsKey(destinationSubProjectId)) continue;
                                    rcpiCopy = new ReviewCyclePositionImpl();
                                    rcpiCopy.setProjectParticipation(rcpiOriginal.getProjectParticipation());
                                    rcpiCopy.setRealm(rcpiOriginal.getRealm());
                                    rcpiCopy.setReviewCycleNodeInstance(rcniCopy);
                                    rcpiCopy = this.reviewCyclePositionDAO.save(rcpiCopy);
                                }
                            }
                            rcniCopy = this.reviewCycleNodeInstanceDAO.update(rcniCopy);
                        }
                    }
                    if (rcciOriginal.getFreeReviewCycleNodeInstances() != null) {
                        rcnis = rcciOriginal.getFreeReviewCycleNodeInstances().values();
                        for (ReviewCycleNodeInstanceImpl rcniOriginal : rcnis) {
                            rcniCopy = new ReviewCycleNodeInstanceImpl();
                            rcniCopy.setDuration(rcniOriginal.getDuration());
                            rcniCopy.setDurationMin(rcniOriginal.getDurationMin());
                            rcniCopy.setFree(rcniOriginal.isFree());
                            rcniCopy.setReviewCycleNode(rcniOriginal.getReviewCycleNode());
                            rcniCopy.setReviewCycleCellInstance(rcciCopy);
                            rcniCopy = this.reviewCycleNodeInstanceDAO.save(rcniCopy);
                            nodeListeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(rcniOriginal.getId());
                            for (ReviewCycleNodeInstanceListener reviewCycleNodeInstanceListener : nodeListeners) {
                                if (reviewCycleNodeInstanceListener instanceof ReviewCycleNodeInstanceNotification) {
                                    listenerCopy = new ReviewCycleNodeInstanceNotification();
                                    ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeInstance(rcniCopy);
                                    ((ReviewCycleNodeInstanceNotification)listenerCopy).setReviewCycleNodeListener(reviewCycleNodeInstanceListener.getReviewCycleNodeListener());
                                    refs = ((ReviewCycleNodeInstanceNotification)reviewCycleNodeInstanceListener).getReference().values();
                                    copyRefs = new HashMap();
                                    for (ProjectParticipation ref : refs) {
                                        copyRefs.put(ref.getId(), ref);
                                    }
                                    ((ReviewCycleNodeInstanceNotification)listenerCopy).setReference(copyRefs);
                                    this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                                    continue;
                                }
                                listenerCopy = new ReviewCycleNodeInstancePlottOrderListener();
                                ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeInstance(rcniCopy);
                                ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReviewCycleNodeListener(reviewCycleNodeInstanceListener.getReviewCycleNodeListener());
                                ((ReviewCycleNodeInstancePlottOrderListener)listenerCopy).setReference(((ReviewCycleNodeInstancePlottOrderListener)reviewCycleNodeInstanceListener).getReference());
                                this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(listenerCopy);
                            }
                            if (rcniOriginal.getReviewCyclePositions() != null) {
                                rcpis = rcniOriginal.getReviewCyclePositions().values();
                                for (ReviewCyclePositionImpl rcpiOriginal : rcpis) {
                                    if (rcpiOriginal.getProjectParticipation() != null && rcpiOriginal.getProjectParticipation().getExcludedSubProjects().containsKey(destinationSubProjectId)) continue;
                                    rcpiCopy = new ReviewCyclePositionImpl();
                                    rcpiCopy.setProjectParticipation(rcpiOriginal.getProjectParticipation());
                                    rcpiCopy.setRealm(rcpiOriginal.getRealm());
                                    rcpiCopy.setReviewCycleNodeInstance(rcniCopy);
                                    rcpiCopy = this.reviewCyclePositionDAO.save(rcpiCopy);
                                }
                            }
                            rcniCopy = this.reviewCycleNodeInstanceDAO.update(rcniCopy);
                        }
                    }
                    rcciCopy = this.reviewCycleCellInstanceDAO.update(rcciCopy);
                }
            }
            rciCopy = this.reviewCycleInstanceDAO.update(rciCopy);
        }
    }

    private boolean isProjectsAllowedFinalReviewCycleCell(ReviewCycleCellInstance reviewCycleCellInstance) {
        Integer projectsAllowedFinalReviewCycleResultOptionId;
        Project project = reviewCycleCellInstance.getReviewCycleInstance().getSubProject().getProject();
        Integer n = projectsAllowedFinalReviewCycleResultOptionId = project.getAllowedFinalReviewCycleResultOption() != null ? project.getAllowedFinalReviewCycleResultOption().getId() : null;
        if (!reviewCycleCellInstance.getReviewCycleCell().isEndCell()) {
            return true;
        }
        Collection incommingConnections = reviewCycleCellInstance.getReviewCycleCell().getIncommingConnections().values();
        for (ReviewCycleCellConnection reviewCycleCellConnection : incommingConnections) {
            if (reviewCycleCellConnection.getSourceCell().getId().equals(reviewCycleCellInstance.getReviewCycleCell().getId())) continue;
            List<ReviewCycleNode> reviewCycleNodes = reviewCycleCellConnection.getSourceCell().getReviewCycleNodesSortedByPosition();
            for (ReviewCycleNode reviewCycleNode : reviewCycleNodes) {
                Collection reviewCycleResultOptions = reviewCycleNode.getReviewCyclePositionType().getReviewCycleResultOptions().values();
                for (ReviewCycleResultOption reviewCycleResultOption : reviewCycleResultOptions) {
                    if (!reviewCycleResultOption.isEvaluateCellConnections() || projectsAllowedFinalReviewCycleResultOptionId != null && projectsAllowedFinalReviewCycleResultOptionId.equals(reviewCycleResultOption.getId())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public List<ReviewCycleCellInstanceImpl> getReviewCycleCellInstances(Integer reviewCycleInstanceId) {
        List reviewCycleCellInstances = this.reviewCycleCellInstanceDAO.getAll(reviewCycleInstanceId);
        ArrayList<ReviewCycleCellInstanceImpl> validReviewCycleCellInstances = new ArrayList<ReviewCycleCellInstanceImpl>();
        for (ReviewCycleCellInstanceImpl reviewCycleCellInstance : reviewCycleCellInstances) {
            reviewCycleCellInstance.setProjectsAllowedFinalReviewCycleCell(true);
            if (!this.isProjectsAllowedFinalReviewCycleCell(reviewCycleCellInstance)) {
                reviewCycleCellInstance.setProjectsAllowedFinalReviewCycleCell(false);
            }
            validReviewCycleCellInstances.add(reviewCycleCellInstance);
        }
        return validReviewCycleCellInstances;
    }

    @Override
    public boolean isParticipationAssignedInReviewCycleInstance(Integer subProjectId, Integer projectParticipationId) {
        List releasedPositions;
        SubProject sp = this.subProjectDAO.get(subProjectId);
        if (sp.getActiveObjectList() != null && (releasedPositions = this.reviewCyclePositionDAO.getReleasedByProjectParticipation(projectParticipationId, sp.getActiveObjectList().getId())) != null && releasedPositions.size() > 0) {
            return true;
        }
        List unreleasedPositions = this.reviewCyclePositionDAO.getUnreleasedByProjectParticipation(projectParticipationId, sp.getEditObjectList().getId());
        if (unreleasedPositions != null && unreleasedPositions.size() > 0) {
            return true;
        }
        List listeners = this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListenersOfSubProject(subProjectId);
        for (ReviewCycleNodeInstanceListener listener : listeners) {
            if (listener instanceof ReviewCycleNodeInstanceNotification) {
                if (!((ReviewCycleNodeInstanceNotification)listener).getReference().containsKey(projectParticipationId)) continue;
                return true;
            }
            if (!(listener instanceof ReviewCycleNodeInstancePlottOrderListener) || ((ReviewCycleNodeInstancePlottOrderListener)listener).getReference() == null || ((ReviewCycleNodeInstancePlottOrderListener)listener).getReference().getOrderItems() == null) continue;
            Collection items = ((ReviewCycleNodeInstancePlottOrderListener)listener).getReference().getOrderItems().values();
            for (PlottOrderItemTemplate item : items) {
                if (item.getDeliveryAddressId() == null || !item.getDeliveryAddressId().equals(projectParticipationId)) continue;
                return true;
            }
        }
        return false;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    @Override
    public boolean hasPositionSignaturesOnLabel(Integer reviewCycleCellInstanceReleaseId) {
        return this.reviewCyclePositionDAO.hasPositionSignaturesOnLabel(reviewCycleCellInstanceReleaseId);
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public PersonDAO getPersonDAO() {
        return this.personDAO;
    }

    @Override
    public void updateReviewCycleNetworks(Integer reviewCycleId, List<Integer> networkIds) {
        ReviewCycle cycle = this.reviewCycleDAO.get(reviewCycleId);
        cycle.getNetworks().clear();
        for (Integer networkId : networkIds) {
            Network network = this.networkDAO.get(networkId);
            cycle.getNetworks().put(networkId, network);
        }
        this.reviewCycleDAO.update(cycle);
    }

    @Override
    public ReviewCycleNodeInstanceRelease getLatestReviewCycleNodeInstanceRelease(Integer reviewCycleNodeInstanceImplId) {
        return this.reviewCycleNodeInstanceDAO.getLatestReleased(reviewCycleNodeInstanceImplId);
    }

    @Override
    public SubProjectCopyContainer insertCopyOfReviewCycleInstancesWithSubElements(Integer sourceSubProjectId, Integer destinationSubProjectId, SubProjectCopyContainer subProjectCopyContainer) {
        SubProject sourceSubProject = this.subProjectDAO.get(sourceSubProjectId);
        SubProject destinationSubProject = this.subProjectDAO.get(destinationSubProjectId);
        ArrayList sourceRcis = new ArrayList(sourceSubProject.getReviewCycleInstances().values());
        for (ReviewCycleInstanceImpl sourceRci : sourceRcis) {
            ReviewCycleInstanceImpl destRci = new ReviewCycleInstanceImpl();
            destRci.setChanged(sourceRci.getChanged());
            destRci.setDescription(sourceRci.getDescription());
            destRci.setDuration(sourceRci.getDuration());
            destRci.setDurationMin(sourceRci.getDurationMin());
            destRci.setName(sourceRci.getName());
            destRci.setPreDuration(sourceRci.getPreDuration());
            destRci.setReviewCycle(sourceRci.getReviewCycle());
            destRci.setSubProject(destinationSubProject);
            destRci.setLabel(sourceRci.getLabel());
            destRci = this.reviewCycleInstanceDAO.save(destRci);
            subProjectCopyContainer.getReviewCycleInstanceImplIds().put(sourceRci.getId(), destRci.getId());
            ArrayList sourceCells = new ArrayList(sourceRci.getReviewCycleCellInstances().values());
            for (ReviewCycleCellInstanceImpl sourceCell : sourceCells) {
                ReviewCycleCellInstanceImpl destCell = new ReviewCycleCellInstanceImpl();
                destCell.setChanged(sourceCell.getChanged());
                destCell.setDuration(sourceCell.getDuration());
                destCell.setStartCell(sourceCell.isStartCell());
                destCell.setReviewCycleInstance(destRci);
                destCell.setReviewCycleCell(sourceCell.getReviewCycleCell());
                destCell = this.reviewCycleCellInstanceDAO.save(destCell);
                subProjectCopyContainer.getReviewCycleCellInstanceImplIds().put(sourceCell.getId(), destCell.getId());
                if (destCell.getReviewCycleCell() == null) {
                    logger.error((Object)("cell is null -> sourceCellInstanceId=" + sourceCell.getId()));
                }
                ArrayList sourceNodeInstances = new ArrayList(sourceCell.getReviewCycleNodeInstances().values());
                sourceNodeInstances.addAll(sourceCell.getFreeReviewCycleNodeInstances().values());
                for (ReviewCycleNodeInstanceImpl sourceNode : sourceNodeInstances) {
                    ReviewCycleNodeInstanceImpl destNode = new ReviewCycleNodeInstanceImpl();
                    destNode.setDuration(sourceNode.getDuration());
                    destNode.setDurationMin(sourceNode.getDurationMin());
                    destNode.setFree(sourceNode.isFree());
                    destNode.setReviewCycleCellInstance(destCell);
                    destNode.setReviewCycleNode(sourceNode.getReviewCycleNode());
                    destNode = this.reviewCycleNodeInstanceDAO.save(destNode);
                    subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().put(sourceNode.getId(), destNode.getId());
                    ArrayList sourcePositions = new ArrayList(sourceNode.getReviewCyclePositions().values());
                    for (ReviewCyclePositionImpl sourcePosition : sourcePositions) {
                        ReviewCyclePositionImpl destPosition = new ReviewCyclePositionImpl();
                        destPosition.setProjectParticipation(sourcePosition.getProjectParticipation());
                        destPosition.setRealm(sourcePosition.getRealm());
                        destPosition.setReviewCycleNodeInstance(destNode);
                        destPosition = this.reviewCyclePositionDAO.save(destPosition);
                        subProjectCopyContainer.getReviewCycleNodePositionImplIds().put(sourcePosition.getId(), destPosition.getId());
                    }
                    ArrayList<ReviewCycleNodeInstanceListener> sourceNodeInstanceListeners = new ArrayList<ReviewCycleNodeInstanceListener>(this.reviewCycleNodeListenerDAO.getAllReviewCycleNodeInstanceListeners(sourceNode.getId()));
                    for (ReviewCycleNodeInstanceListener sourceListener : sourceNodeInstanceListeners) {
                        ReviewCycleNodeInstanceListener destListener;
                        if (sourceListener instanceof ReviewCycleNodeInstanceNotification) {
                            destListener = new ReviewCycleNodeInstanceNotification();
                            ArrayList pps = new ArrayList(((Map)sourceListener.getReference()).values());
                            HashMap<Integer, ProjectParticipation> ppMap = new HashMap<Integer, ProjectParticipation>();
                            for (ProjectParticipation pp : pps) {
                                ppMap.put(pp.getId(), pp);
                            }
                            ((ReviewCycleNodeInstanceNotification)destListener).setReference(ppMap);
                            ((ReviewCycleNodeInstanceNotification)destListener).setReviewCycleNodeInstance(destNode);
                            ((ReviewCycleNodeInstanceNotification)destListener).setReviewCycleNodeListener(sourceListener.getReviewCycleNodeListener());
                            this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(destListener);
                            continue;
                        }
                        destListener = new ReviewCycleNodeInstancePlottOrderListener();
                        ((ReviewCycleNodeInstancePlottOrderListener)destListener).setReference((PlottOrderTemplate)sourceListener.getReference());
                        ((ReviewCycleNodeInstancePlottOrderListener)destListener).setReviewCycleNodeInstance(destNode);
                        ((ReviewCycleNodeInstancePlottOrderListener)destListener).setReviewCycleNodeListener(sourceListener.getReviewCycleNodeListener());
                        this.reviewCycleNodeListenerDAO.saveOrUpdateReviewCycleNodeInstanceListener(destListener);
                    }
                }
            }
        }
        return subProjectCopyContainer;
    }

    @Override
    public SubProjectCopyContainer insertCopyOfReleasedReviewCycleInstancesWithSubElements(ReleasedObjectList sourceObjectListRelease, ReleasedObjectList destObjectListRelease, SubProjectCopyContainer subProjectCopyContainer) {
        List<ReviewCycleInstanceRelease> sourceRcis = this.reviewCycleInstanceDAO.getAllReleased(sourceObjectListRelease);
        for (ReviewCycleInstanceRelease sourceRci : sourceRcis) {
            ReviewCycleInstanceRelease destRci = new ReviewCycleInstanceRelease();
            destRci.setChanged(sourceRci.getChanged());
            destRci.setDescription(sourceRci.getDescription());
            destRci.setDuration(sourceRci.getDuration());
            destRci.setDurationMin(sourceRci.getDurationMin());
            destRci.setName(sourceRci.getName());
            destRci.setPreDuration(sourceRci.getPreDuration());
            destRci.setReviewCycle(sourceRci.getReviewCycle());
            destRci.setSubProject(destObjectListRelease.getSubProject());
            destRci.setObjectList(destObjectListRelease);
            destRci.setDigest(sourceRci.getDigest());
            destRci.setDigestCalculatorType(sourceRci.getDigestCalculatorType());
            ReviewCycleInstanceImpl unreleasedDestinationRCI = this.reviewCycleInstanceDAO.get(subProjectCopyContainer.getReviewCycleInstanceImplIds().get(sourceRci.getReviewCycleInstance().getId()));
            destRci.setReviewCycleInstance(unreleasedDestinationRCI);
            destRci.setLabel(sourceRci.getLabel());
            destRci = this.reviewCycleInstanceDAO.save(destRci);
            subProjectCopyContainer.getReviewCycleInstanceReleaseIds().put(sourceRci.getId(), destRci.getId());
            ArrayList sourceCells = new ArrayList(sourceRci.getReviewCycleCellInstances().values());
            for (ReviewCycleCellInstanceRelease sourceCell : sourceCells) {
                ReviewCycleCellInstanceRelease destCell = new ReviewCycleCellInstanceRelease();
                destCell.setChanged(sourceCell.getChanged());
                destCell.setDuration(sourceCell.getDuration());
                destCell.setStartCell(sourceCell.isStartCell());
                destCell.setReviewCycleInstance(destRci);
                destCell.setReviewCycleCell(sourceCell.getReviewCycleCell());
                ReviewCycleCellInstanceImpl unreleasedDestinationCell = this.reviewCycleCellInstanceDAO.get(subProjectCopyContainer.getReviewCycleCellInstanceImplIds().get(sourceCell.getReviewCycleCellInstance().getId()));
                destCell.setReviewCycleCellInstance(unreleasedDestinationCell);
                destCell = this.reviewCycleCellInstanceDAO.save(destCell);
                ArrayList sourceNodeInstances = new ArrayList(sourceCell.getReviewCycleNodeInstances().values());
                sourceNodeInstances.addAll(sourceCell.getFreeReviewCycleNodeInstances().values());
                for (ReviewCycleNodeInstanceRelease sourceNode : sourceNodeInstances) {
                    ReviewCycleNodeInstanceRelease destNode = new ReviewCycleNodeInstanceRelease();
                    destNode.setDuration(sourceNode.getDuration());
                    destNode.setDurationMin(sourceNode.getDurationMin());
                    destNode.setFree(sourceNode.isFree());
                    destNode.setReviewCycleCellInstance(destCell);
                    destNode.setReviewCycleNode(sourceNode.getReviewCycleNode());
                    ReviewCycleNodeInstanceImpl unreleasedDestinationNode = this.reviewCycleNodeInstanceDAO.get(subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().get(sourceNode.getReviewCycleNodeInstance().getId()));
                    destNode.setReviewCycleNodeInstance(unreleasedDestinationNode);
                    destNode = this.reviewCycleNodeInstanceDAO.save(destNode);
                    ArrayList sourcePositions = new ArrayList(sourceNode.getReviewCyclePositions().values());
                    for (ReviewCyclePositionReleaseImpl sourcePosition : sourcePositions) {
                        ReviewCyclePositionReleaseImpl destPosition = new ReviewCyclePositionReleaseImpl();
                        destPosition.setProjectParticipation(sourcePosition.getProjectParticipation());
                        destPosition.setRealm(sourcePosition.getRealm());
                        destPosition.setReviewCycleNodeInstance(destNode);
                        destPosition = this.reviewCyclePositionDAO.save(destPosition);
                        subProjectCopyContainer.getReviewCycleNodePositionReleaseIds().put(sourcePosition.getId(), destPosition.getId());
                    }
                }
            }
        }
        return subProjectCopyContainer;
    }

    @Override
    public boolean isReviewCycleInstanceAssigned(Integer reviewCycleInstanceId) {
        return !this.objectPlannerDAO.getAllUnreleasedObjectPlannersForReviewCycleInstance(reviewCycleInstanceId).isEmpty();
    }

    @Override
    public boolean isReviewCycleInstanceWithUploads(Integer reviewCycleInstanceId) {
        return !this.documentVersionDAO.getDocumentVersionsForReviewCycleInstance(reviewCycleInstanceId).isEmpty();
    }

    @Override
    public List<ReviewCycleInstanceImpl> getValidReviewCycleInstancesForAsbuiltSubproject(Integer subProjectId, boolean onlyAsBuiltReviewCycles) {
        SubProject subProject = this.subProjectDAO.get(subProjectId);
        ArrayList<ReviewCycleInstanceImpl> allRCIs = new ArrayList<ReviewCycleInstanceImpl>(subProject.getReviewCycleInstances().values());
        if (onlyAsBuiltReviewCycles) {
            ArrayList<ReviewCycleInstanceImpl> asBuiltRCIs = new ArrayList<ReviewCycleInstanceImpl>();
            for (ReviewCycleInstanceImpl rci : allRCIs) {
                for (ReviewCycleCellInstanceImpl rcc : rci.getReviewCycleCellInstances().values()) {
                    if (!rcc.getReviewCycleCell().isAsBuiltUnchangedDestination()) continue;
                    asBuiltRCIs.add(rci);
                }
            }
            return asBuiltRCIs;
        }
        return allRCIs;
    }

    public boolean isReversePreduration() {
        return this.reversePreduration;
    }

    public void setReversePreduration(boolean reversePreduration) {
        this.reversePreduration = reversePreduration;
    }

    public void setWorkflowTemplateDAO(WorkflowTemplateDAO workflowTemplateDAO) {
        this.workflowTemplateDAO = workflowTemplateDAO;
    }

    public void setWorkflowNodeTemplateDAO(WorkflowNodeTemplateDAO workflowNodeTemplateDAO) {
        this.workflowNodeTemplateDAO = workflowNodeTemplateDAO;
    }

    public void setWorkflowEntityStatusDAO(WorkflowEntityStatusDAO workflowEntityStatusDAO) {
        this.workflowEntityStatusDAO = workflowEntityStatusDAO;
    }

    public void setWorkflowActionListenerDAO(WorkflowActionListenerDAO workflowActionListenerDAO) {
        this.workflowActionListenerDAO = workflowActionListenerDAO;
    }

    public void setWorkflowActionDAO(WorkflowActionDAO workflowActionDAO) {
        this.workflowActionDAO = workflowActionDAO;
    }

    public void setWorkflowNodePositionResultOptionDAO(WorkflowNodePositionResultOptionDAO workflowNodePositionResultOptionDAO) {
        this.workflowNodePositionResultOptionDAO = workflowNodePositionResultOptionDAO;
    }

    public void setWorkflowActionPreconditionDAO(WorkflowActionPreconditionDAO workflowActionPreconditionDAO) {
        this.workflowActionPreconditionDAO = workflowActionPreconditionDAO;
    }

    @Override
    public List<WorkflowTemplateDTO> getAllWorkflowTemplateDTOs() {
        ArrayList<WorkflowTemplateDTO> list = new ArrayList<WorkflowTemplateDTO>();
        for (WorkflowTemplate template : this.workflowTemplateDAO.getAll()) {
            list.add(CdesDTOHelper.getWorkflowTemplateDTO(template));
        }
        return list;
    }

    @Override
    public WorkflowNodeTemplateDTO getWorkflowNodeTemplateDTO(Integer workflowNodeTemplateId) {
        WorkflowNodeTemplate workflowNodeTemplate = this.workflowNodeTemplateDAO.get(workflowNodeTemplateId);
        return CdesDTOHelper.getWorkflowNodeTemplateDTO(workflowNodeTemplate, CdesDTOHelper.getWorkflowTemplateDTO(workflowNodeTemplate.getWorkflowTemplate()));
    }

    @Override
    public List<WorkflowNodeTemplateDTO> getAllWorkflowNodeTemplateDTOs(Integer workflowTemplateId) {
        WorkflowTemplateDTO workflowTemplateDTO = CdesDTOHelper.getWorkflowTemplateDTO(this.workflowTemplateDAO.get(workflowTemplateId));
        ArrayList<WorkflowNodeTemplateDTO> list = new ArrayList<WorkflowNodeTemplateDTO>();
        for (WorkflowNodeTemplate template : this.workflowNodeTemplateDAO.getByWorkflowTemplate(workflowTemplateId)) {
            list.add(CdesDTOHelper.getWorkflowNodeTemplateDTO(template, workflowTemplateDTO));
        }
        return list;
    }

    @Override
    public List<WorkflowEntityStatusDTO> getAllWorkflowEntityStatusDTOs() {
        ArrayList<WorkflowEntityStatusDTO> list = new ArrayList<WorkflowEntityStatusDTO>();
        for (WorkflowEntityStatus status : this.workflowEntityStatusDAO.getAll()) {
            list.add(CdesDTOHelper.getWorkflowEntitiyStatusDTO(status));
        }
        return list;
    }

    @Override
    public List<WorkflowNodePositionResultOptionDTO> getWorkflowNodePositionResultOptionDTOs(Integer workflowNodeTemplateId) {
        WorkflowNodeTemplateDTO workflowNodeTemplateDTO = this.getWorkflowNodeTemplateDTO(workflowNodeTemplateId);
        ArrayList<WorkflowNodePositionResultOptionDTO> list = new ArrayList<WorkflowNodePositionResultOptionDTO>();
        for (WorkflowNodePositionResultOption option : this.workflowNodePositionResultOptionDAO.getByWorkflowNodeTemplate(workflowNodeTemplateId)) {
            list.add(CdesDTOHelper.getWorkflowNodePositionResultOptionDTO(option, workflowNodeTemplateDTO));
        }
        return list;
    }

    @Override
    public WorkflowTemplateDTO saveOrUpdateWorkflowTemplateDTO(WorkflowTemplateDTO workflowTemplateDTO, List<WorkflowEntityStatusDTO> entityStatusListDTO) {
        if (workflowTemplateDTO == null) {
            return null;
        }
        WorkflowTemplate workflowTemplate = null;
        if (workflowTemplateDTO.getId() == null) {
            workflowTemplate = new WorkflowTemplate();
        } else {
            workflowTemplate = this.workflowTemplateDAO.get(workflowTemplateDTO.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loading template id=[" + workflowTemplate.getId() + "]"));
            }
        }
        workflowTemplate.setName(workflowTemplateDTO.getName());
        workflowTemplate.setComment(workflowTemplateDTO.getComment());
        if (workflowTemplateDTO.getWorkflowNodeTemplates() != null) {
            if (workflowTemplate.getWorkflowNodeTemplates() == null) {
                workflowTemplate.setWorkflowNodeTemplates(new HashMap<Integer, WorkflowNodeTemplate>());
            }
            for (WorkflowNodeTemplateDTO nodeTemplateDTO : workflowTemplateDTO.getWorkflowNodeTemplates().values()) {
                WorkflowNodeTemplate nodeTemplate = this.workflowNodeTemplateDAO.get(nodeTemplateDTO.getId());
                workflowTemplate.getWorkflowNodeTemplates().put(nodeTemplate.getId(), nodeTemplate);
            }
        }
        if (workflowTemplateDTO.getId() == null) {
            workflowTemplate = this.workflowTemplateDAO.save(workflowTemplate);
        } else {
            workflowTemplate = this.workflowTemplateDAO.update(workflowTemplate);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updating template id=[" + workflowTemplate.getId() + "]"));
            }
        }
        if (entityStatusListDTO != null) {
            for (WorkflowEntityStatusDTO statusDTO : entityStatusListDTO) {
                WorkflowEntityStatus status = null;
                if (statusDTO.getId() == null) {
                    status = new WorkflowEntityStatus();
                    logger.info((Object)"Hlloooo");
                } else {
                    status = this.workflowEntityStatusDAO.get(statusDTO.getId());
                }
                logger.info(status != null ? status.getId() : "null");
                status.setName(statusDTO.getName());
                status.setDescription(statusDTO.getDescription());
                status.setInitialStatus(statusDTO.isInitialStatus());
                if (statusDTO.getId() == null) {
                    this.workflowEntityStatusDAO.save(status);
                    continue;
                }
                this.workflowEntityStatusDAO.update(status);
            }
        }
        return CdesDTOHelper.getWorkflowTemplateDTO(workflowTemplate);
    }

    @Override
    public WorkflowNodeTemplateDTO saveOrUpdateWorkflowNodeTemplateDTO(WorkflowNodeTemplateDTO workflowNodeTemplateDTO) {
        if (workflowNodeTemplateDTO == null) {
            return null;
        }
        WorkflowNodeTemplate workflowNodeTemplate = null;
        workflowNodeTemplate = workflowNodeTemplateDTO.getId() == null ? new WorkflowNodeTemplate() : this.workflowNodeTemplateDAO.get(workflowNodeTemplateDTO.getId());
        workflowNodeTemplate.setName(workflowNodeTemplateDTO.getName());
        workflowNodeTemplate.setStartNode(workflowNodeTemplateDTO.isStartNode());
        workflowNodeTemplate.setPosition(workflowNodeTemplateDTO.getPosition());
        workflowNodeTemplate.setWithMultiplePositions(workflowNodeTemplateDTO.isWithMultiplePositions());
        workflowNodeTemplate = workflowNodeTemplateDTO.getId() == null ? this.workflowNodeTemplateDAO.save(workflowNodeTemplate) : this.workflowNodeTemplateDAO.update(workflowNodeTemplate);
        return CdesDTOHelper.getWorkflowNodeTemplateDTO(workflowNodeTemplate, workflowNodeTemplateDTO.getWorkflowTemplate());
    }

    @Override
    public WorkflowNodePositionResultOptionDTO saveOrUpdateWorkflowNodePositionResultOptionDTO(WorkflowNodePositionResultOptionDTO nodePositionResultOptionDTO) {
        if (nodePositionResultOptionDTO == null) {
            return null;
        }
        WorkflowNodePositionResultOption nodePositionResultOption = null;
        nodePositionResultOption = nodePositionResultOptionDTO.getId() == null ? new WorkflowNodePositionResultOption() : this.workflowNodePositionResultOptionDAO.get(nodePositionResultOptionDTO.getId());
        nodePositionResultOption.setTitle(nodePositionResultOptionDTO.getTitle());
        nodePositionResultOption.setDescription(nodePositionResultOptionDTO.getDescription());
        nodePositionResultOption.setWorkflowNodeTemplate(this.workflowNodeTemplateDAO.get(nodePositionResultOptionDTO.getWorkflowNodeTemplate().getId()));
        if (nodePositionResultOptionDTO.getId() == null) {
            this.workflowNodePositionResultOptionDAO.save(nodePositionResultOption);
        } else {
            this.workflowNodePositionResultOptionDAO.update(nodePositionResultOption);
        }
        return CdesDTOHelper.getWorkflowNodePositionResultOptionDTO(nodePositionResultOption, nodePositionResultOptionDTO.getWorkflowNodeTemplate());
    }

    @Override
    public void deleteWorkflowTemplate(Integer workflowTemplateId) {
        this.deleteWorkflowTemplate(this.workflowTemplateDAO.get(workflowTemplateId));
    }

    @Override
    public void deleteWorkflowNodeTemplate(Integer workflowNodeTemplateId) {
        this.deleteWorkflowNodeTemplate(this.workflowNodeTemplateDAO.get(workflowNodeTemplateId));
    }

    @Override
    public void deleteWorkflowActionListener(Integer workflowActionListenerId) {
        this.deleteWorkflowActionListener(this.workflowActionListenerDAO.get(workflowActionListenerId));
    }

    @Override
    public void deleteWorkflowActionPrecondition(Integer workflowActionPreconditionId) {
        this.deleteWorkflowActionPrecondition(this.workflowActionPreconditionDAO.get(workflowActionPreconditionId));
    }

    @Override
    public void deleteWorkflowAction(Integer workflowActionId) {
        this.deleteWorkflowAction(this.workflowActionDAO.get(workflowActionId));
    }

    @Override
    public void deleteWorkflowNodePositionResultOption(Integer nodePositionResultOptionId) {
        this.deleteWorkflowNodePositionResultOption(this.workflowNodePositionResultOptionDAO.get(nodePositionResultOptionId));
    }

    @Override
    public void deleteWorkflowEntityStatus(Integer workflowEntityStatusId) {
        this.workflowEntityStatusDAO.delete(this.workflowEntityStatusDAO.get(workflowEntityStatusId));
    }

    private void deleteWorkflowTemplate(WorkflowTemplate workflowTemplate) {
        for (WorkflowNodeTemplate workflowNodeTemplate : workflowTemplate.getWorkflowNodeTemplates().values()) {
            this.deleteWorkflowNodeTemplate(workflowNodeTemplate);
        }
        this.workflowTemplateDAO.delete(workflowTemplate);
    }

    private void deleteWorkflowNodeTemplate(WorkflowNodeTemplate workflowNodeTemplate) {
        for (WorkflowActionListener listener : workflowNodeTemplate.getWorkflowActionListeners().values()) {
            this.deleteWorkflowActionListener(listener);
        }
        this.workflowNodeTemplateDAO.delete(workflowNodeTemplate);
    }

    private void deleteWorkflowActionListener(WorkflowActionListener workflowActionListener) {
        for (WorkflowActionPrecondition workflowActionPrecondition : workflowActionListener.getWorkflowActionPreconditions().values()) {
            this.deleteWorkflowActionPrecondition(workflowActionPrecondition);
        }
        for (WorkflowAction workflowAction : workflowActionListener.getWorkflowActions().values()) {
            this.deleteWorkflowAction(workflowAction);
        }
        this.workflowActionListenerDAO.delete(workflowActionListener);
    }

    private void deleteWorkflowActionPrecondition(WorkflowActionPrecondition workflowActionPrecondition) {
        this.workflowActionPreconditionDAO.delete(workflowActionPrecondition);
    }

    private void deleteWorkflowAction(WorkflowAction workflowAction) {
        this.workflowActionDAO.delete(workflowAction);
    }

    private void deleteWorkflowNodePositionResultOption(WorkflowNodePositionResultOption nodePositionResultOption) {
        this.workflowNodePositionResultOptionDAO.delete(nodePositionResultOption);
    }

    @Override
    public List<Label> getAssignedLabelsForSubProject(Integer SubProjectId) {
        ArrayList<Label> ret = new ArrayList<Label>();
        ArrayList reviewCycleInstances = new ArrayList(this.reviewCycleInstanceDAO.getAll(SubProjectId));
        for (ReviewCycleInstance reviewCycleInstance : reviewCycleInstances) {
            if (reviewCycleInstance.getLabel() == null || ret.contains(reviewCycleInstance.getLabel().getId())) continue;
            ret.add((Label)((Object)reviewCycleInstance.getLabel().getId()));
        }
        return ret;
    }
}

