/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.plot.BoundingBox;
import at.cdes.bo.plot.SimpleBoundingBox;
import at.cdes.bo.plot.TiledImage;
import at.cdes.ext.preview.AbstractDocumentVersionMimeSource;
import at.cdes.preview.api.BoundingBoxWithAngle;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import org.apache.log4j.Logger;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class CompareDocumentVersionPngTileMimeSource
extends AbstractDocumentVersionMimeSource {
    private static Logger log = Logger.getLogger(CompareDocumentVersionPngTileMimeSource.class);
    private static final byte[] BLACK_PIXEL_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 1, 0, 0, 0, 1, 8, 0, 0, 0, 0, 58, 126, -101, 85, 0, 0, 0, 9, 112, 72, 89, 115, 0, 0, 11, 19, 0, 0, 11, 19, 1, 0, -102, -100, 24, 0, 0, 0, 7, 116, 73, 77, 69, 7, -41, 10, 21, 13, 15, 51, -34, 8, -41, -79, 0, 0, 0, 29, 116, 69, 88, 116, 67, 111, 109, 109, 101, 110, 116, 0, 67, 114, 101, 97, 116, 101, 100, 32, 119, 105, 116, 104, 32, 84, 104, 101, 32, 71, 73, 77, 80, -17, 100, 37, 110, 0, 0, 0, 10, 73, 68, 65, 84, 8, -41, 99, 96, 0, 0, 0, 2, 0, 1, -30, 33, -68, 51, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};

    private static double getBoundingBoxXSize(BoundingBox bbox, int angle) {
        switch ((angle + 360) / 90 % 4) {
            case 1: 
            case 3: {
                return bbox.getUry() - bbox.getLly();
            }
        }
        return bbox.getUrx() - bbox.getLlx();
    }

    private static double getBoundingBoxYSize(BoundingBox bbox, int angle) {
        switch ((angle + 360) / 90 % 4) {
            case 1: 
            case 3: {
                return bbox.getUrx() - bbox.getLlx();
            }
        }
        return bbox.getUry() - bbox.getLly();
    }

    private static BoundingBox expandBoundingBox(BoundingBox o_bbox, int angle, double xsize, double ysize) {
        SimpleBoundingBox bbox = new SimpleBoundingBox();
        bbox.setUserUnit(o_bbox.getUserUnit());
        switch ((angle + 360) / 90 % 4) {
            default: {
                bbox.setLlx(o_bbox.getUrx() - xsize);
                bbox.setLly(o_bbox.getLly());
                bbox.setUrx(o_bbox.getUrx());
                bbox.setUry(o_bbox.getLly() + ysize);
                break;
            }
            case 1: {
                bbox.setLlx(o_bbox.getLlx());
                bbox.setLly(o_bbox.getLly());
                bbox.setUrx(o_bbox.getLlx() + ysize);
                bbox.setUry(o_bbox.getLly() + xsize);
                break;
            }
            case 2: {
                bbox.setLlx(o_bbox.getLlx());
                bbox.setLly(o_bbox.getUry() - ysize);
                bbox.setUrx(o_bbox.getLlx() + xsize);
                bbox.setUry(o_bbox.getUry());
                break;
            }
            case 3: {
                bbox.setLlx(o_bbox.getUrx() - ysize);
                bbox.setLly(o_bbox.getUry() - xsize);
                bbox.setUrx(o_bbox.getUrx());
                bbox.setUry(o_bbox.getUry());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("angle=[" + angle + "] bbox=[" + bbox.getLlx() + "," + bbox.getLly() + "," + bbox.getUrx() + "," + bbox.getUry() + "] o_bbox=[" + o_bbox.getLlx() + "," + o_bbox.getLly() + "," + o_bbox.getUrx() + "," + o_bbox.getUry() + "]"));
        }
        return bbox;
    }

    private static boolean isBoundingBoxEmpty(BoundingBoxWithAngle bbox) {
        return bbox.getLlx() >= bbox.getUrx() || bbox.getLly() >= bbox.getUry();
    }

    @Override
    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        Integer id1 = (Integer)parameters[0];
        Integer id2 = (Integer)parameters[1];
        int baseSize = (Integer)parameters[2];
        boolean antialias = (Boolean)parameters[3];
        double resolution = (Double)parameters[4];
        int itile = (Integer)parameters[5];
        int jtile = (Integer)parameters[6];
        DocumentVersion dv1 = this.getDocumentVersionDAO().get(id1);
        DocumentVersion dv2 = this.getDocumentVersionDAO().get(id2);
        if (!(dv1.getDocument().getId().equals(dv2.getDocument().getId()) || ((DocumentImpl)dv1.getDocument()).getAsBuiltReference() != null && ((DocumentImpl)dv1.getDocument()).getAsBuiltReference().getId().equals(dv2.getDocument().getId()) || ((DocumentImpl)dv2.getDocument()).getAsBuiltReference() != null && ((DocumentImpl)dv2.getDocument()).getAsBuiltReference().getId().equals(dv1.getDocument().getId()))) {
            throw new IOError("The two document versions belong to different documents.");
        }
        int angle1 = dv1.getPreviewRotation();
        if (parameters.length > 7) {
            angle1 = (Integer)parameters[7];
        }
        int da = dv2.getPreviewRotation() - dv1.getPreviewRotation();
        int angle2 = angle1 + da;
        FileMimeInputStream stream1 = null;
        FileMimeInputStream stream2 = null;
        try {
            ByteArrayMimeInputStream ret;
            File file1 = this.getFileFinder().findFile(dv1.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique1 = this.getFileFinder().makeUniqueName(dv1.getFileName(), CDESFileRepository.PLANREPOSITORY);
            File file2 = this.getFileFinder().findFile(dv2.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique2 = this.getFileFinder().makeUniqueName(dv2.getFileName(), CDESFileRepository.PLANREPOSITORY);
            IHPGLRenderer renderer = this.getHpglRenderer();
            double xsize1 = CompareDocumentVersionPngTileMimeSource.getBoundingBoxXSize(dv1, angle1);
            double ysize1 = CompareDocumentVersionPngTileMimeSource.getBoundingBoxYSize(dv1, angle1);
            double xsize2 = CompareDocumentVersionPngTileMimeSource.getBoundingBoxXSize(dv2, angle2);
            double ysize2 = CompareDocumentVersionPngTileMimeSource.getBoundingBoxYSize(dv2, angle2);
            double xsize = Math.max(xsize1, xsize2);
            double ysize = Math.max(ysize1, ysize2);
            BoundingBox bbox1 = CompareDocumentVersionPngTileMimeSource.expandBoundingBox(dv1, angle1, xsize, ysize);
            BoundingBox bbox2 = CompareDocumentVersionPngTileMimeSource.expandBoundingBox(dv2, angle2, xsize, ysize);
            TiledImage ti1 = new TiledImage(bbox1, baseSize, resolution, angle1);
            TiledImage ti2 = new TiledImage(bbox2, baseSize, resolution, angle2);
            BoundingBoxWithAngle tbox1 = ti1.getTileBox(itile, jtile, dv1);
            BoundingBoxWithAngle tbox2 = ti2.getTileBox(itile, jtile, dv2);
            if (CompareDocumentVersionPngTileMimeSource.isBoundingBoxEmpty(tbox1) && CompareDocumentVersionPngTileMimeSource.isBoundingBoxEmpty(tbox2)) {
                ret = new ByteArrayMimeInputStream(BLACK_PIXEL_PNG, "blackpixel.png", "image/png");
            } else {
                stream1 = new FileMimeInputStream(file1, unique1, dv1.getName() + "." + dv1.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv1.getFileName()));
                stream2 = new FileMimeInputStream(file2, unique2, dv2.getName() + "." + dv2.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv2.getFileName()));
                ret = renderer.comparePngTileByResolution((IMimeInputStream)stream2, tbox2, (IMimeInputStream)stream1, tbox1, resolution, antialias, ti1.getTileWidth(itile), ti1.getTileHeight(jtile));
            }
            ByteArrayMimeInputStream byteArrayMimeInputStream = ret;
            return byteArrayMimeInputStream;
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the documentversion", (Throwable)e);
        }
        finally {
            if (stream1 != null) {
                stream1.close();
            }
            if (stream2 != null) {
                stream2.close();
            }
        }
    }
}

