/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview.seed.impl;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.plot.TiledImage;
import at.cdes.ext.preview.seed.DocumentVersionSeeder;
import at.cdes.ext.preview.seed.SeedItem;
import at.cdes.ext.preview.seed.Seeder;
import org.apache.log4j.Logger;

public class DocumentVersionSeederImpl
implements DocumentVersionSeeder {
    private static final Logger log = Logger.getLogger(DocumentVersionSeederImpl.class);
    private Seeder seeder;
    private int pngPreviewSize;
    private int tileBaseSize;
    private double[] tileResolutions;
    private int[] tileResolutionPriorities;
    private boolean antialias;

    @Override
    public void queueDocumentVersion(DocumentVersion dv) {
        if (this.seeder == null || !this.seeder.isActive()) {
            return;
        }
        if (this.pngPreviewSize > 0) {
            this.seeder.queueItem(new SeedItem(1, "documentVersionPngMimeSource", dv.getId(), this.pngPreviewSize, this.antialias, dv.getPreviewRotation()));
        }
        if (this.tileBaseSize > 0 && this.tileResolutions != null) {
            for (int ir = 0; ir < this.tileResolutions.length; ++ir) {
                TiledImage ti = new TiledImage(dv, this.tileBaseSize, this.tileResolutions[ir], dv.getPreviewRotation());
                for (int i = 0; i < ti.getXtiles(); ++i) {
                    for (int j = 0; j < ti.getYtiles(); ++j) {
                        this.seeder.queueItem(new SeedItem(this.tileResolutionPriorities[ir], "documentVersionPngTileMimeSource", dv.getId(), this.tileBaseSize, this.antialias, this.tileResolutions[ir], i, j, dv.getPreviewRotation()));
                    }
                }
            }
        }
    }

    public void setSeeder(Seeder seeder) {
        this.seeder = seeder;
    }

    public void setPngPreviewSize(int pngPreviewSize) {
        this.pngPreviewSize = pngPreviewSize;
    }

    public void setTileResolutions(String tileResolutions) {
        String[] res = tileResolutions.split(",");
        this.tileResolutions = new double[res.length / 2];
        this.tileResolutionPriorities = new int[res.length / 2];
        for (int i = 0; i < res.length / 2; ++i) {
            this.tileResolutions[i] = Double.parseDouble(res[2 * i]);
            this.tileResolutionPriorities[i] = Integer.parseInt(res[2 * i + 1]);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Adding resolution [" + this.tileResolutions[i] + "] with priority [" + this.tileResolutionPriorities[i] + "]."));
        }
    }

    public void setTileBaseSize(int tileBaseSize) {
        this.tileBaseSize = tileBaseSize;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    @Override
    public boolean isActive() {
        return this.seeder != null && this.seeder.isActive();
    }
}

