/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.document;

import at.cdes.bo.data.document.BaseDocumentVersion;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentBase;
import at.cdes.bo.data.document.DocumentDateHistoryPart;
import at.cdes.bo.data.document.DocumentDateHistoryPartComparator;
import at.cdes.bo.data.document.DocumentListImpl;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.DocumentVersionComparator;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.document.ReleasedDocumentDocumentListVersionComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DocumentImpl
extends DocumentBase
implements Serializable,
Document {
    static final long serialVersionUID = 1L;
    public static final int NOTMODIFIED = 0;
    public static final int NEW = 1;
    public static final int DATEMODIFIED = 2;
    public static final int CONTENTMODIFIED = 3;
    private Map documentVersions;
    private Map deleteDocumentVersions;
    private int modified;
    private Map releasedVersions;
    private Map documentRefs;
    private Map dateHistory;
    private DocumentListImpl documentList;
    private boolean invalidated;
    private DocumentImpl asBuiltReference;

    public DocumentImpl() {
    }

    public DocumentImpl(DocumentImpl doc) {
        super(doc);
        this.documentVersions = doc.getDocumentVersions();
        this.deleteDocumentVersions = doc.getDeletedDocumentVersions();
        this.modified = doc.getModified();
        this.releasedVersions = doc.getReleasedVersions();
        this.documentRefs = doc.getDocumentRefs();
        this.dateHistory = doc.getDateHistory();
        this.documentList = doc.getDocumentList();
        this.invalidated = doc.isInvalidated();
    }

    public Map getReleasedVersions() {
        return this.releasedVersions;
    }

    public void setReleasedVersions(Map relasedVersions) {
        this.releasedVersions = relasedVersions;
    }

    @Override
    public Map<Integer, DocumentVersion> getDocumentVersions() {
        return this.documentVersions;
    }

    @Override
    public void setDocumentVersions(Map<Integer, DocumentVersion> documentVersions) {
        this.documentVersions = documentVersions;
    }

    @Override
    public DocumentVersion getLastDocumentVersion() {
        BaseDocumentVersion dv;
        ArrayList<DocumentVersion> ret = new ArrayList<DocumentVersion>();
        ret.addAll(this.getAllDocumentVersions());
        BaseDocumentVersion baseDocumentVersion = dv = ret.isEmpty() ? null : (DocumentVersion)ret.get(ret.size() - 1);
        if (dv != null && dv.getReactivatedDocumentVersion() != null) {
            dv = dv.getReactivatedDocumentVersion();
        }
        return dv;
    }

    @Override
    public DocumentVersion getFirstDocumentVersion() {
        List<DocumentVersion> ret = this.getDocumentVersionsSortedByVersion();
        return ret == null || ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<DocumentVersion> getDocumentVersionsSortedByVersion() {
        if (this.getDocumentVersions() == null) {
            return null;
        }
        ArrayList<DocumentVersion> ret = new ArrayList<DocumentVersion>();
        ret.addAll(this.getDocumentVersions().values());
        Collections.sort(ret, new DocumentVersionComparator());
        return ret;
    }

    public List<ReleasedDocument> getReleasedVersionsSortedByVersion() {
        ArrayList<ReleasedDocument> releasedVersions = new ArrayList<ReleasedDocument>();
        if (this.getReleasedVersions() != null && !this.getReleasedVersions().isEmpty()) {
            releasedVersions.addAll(this.getReleasedVersions().values());
        }
        Collections.sort(releasedVersions, new ReleasedDocumentDocumentListVersionComparator());
        return releasedVersions;
    }

    public Document getLastReleasedOrImplDocument() {
        List<ReleasedDocument> releasedVersions = this.getReleasedVersionsSortedByVersion();
        return releasedVersions == null || releasedVersions.isEmpty() ? this : (Document)releasedVersions.get(0);
    }

    @Override
    public Map<Integer, DocumentRef> getDocumentRefs() {
        return this.documentRefs;
    }

    @Override
    public void setDocumentRefs(Map<Integer, DocumentRef> documentRefs) {
        this.documentRefs = documentRefs;
    }

    @Override
    public Map getDateHistory() {
        return this.dateHistory;
    }

    @Override
    public void setDateHistory(Map dateHistory) {
        this.dateHistory = dateHistory;
    }

    public DocumentDateHistoryPart getLastDocumentDateHistoryPart() {
        List<DocumentDateHistoryPart> parts = this.getDateHistorySortedByDate(false);
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        return parts.get(0);
    }

    public List<DocumentDateHistoryPart> getDateHistorySortedByDate(boolean asc) {
        if (this.getDateHistory() == null) {
            return null;
        }
        ArrayList<DocumentDateHistoryPart> ret = new ArrayList<DocumentDateHistoryPart>();
        ret.addAll(this.getDateHistory().values());
        Collections.sort(ret, new DocumentDateHistoryPartComparator(asc));
        return ret;
    }

    @Override
    public DocumentListImpl getDocumentList() {
        return this.documentList;
    }

    public void setDocumentList(DocumentListImpl documentList) {
        this.documentList = documentList;
    }

    public int getModified() {
        return this.modified;
    }

    public void setModified(int modified) {
        this.modified = modified;
    }

    public Map<Integer, DocumentVersion> getDeletedDocumentVersions() {
        return this.deleteDocumentVersions;
    }

    public void setDeletedDocumentVersions(Map<Integer, DocumentVersion> deleteDocumentVersions) {
        this.deleteDocumentVersions = deleteDocumentVersions;
    }

    @Override
    public Collection<DocumentVersion> getAllDocumentVersions() {
        ArrayList<DocumentVersion> versions = new ArrayList<DocumentVersion>();
        if (this.getDocumentVersions() != null) {
            versions.addAll(this.getDocumentVersions().values());
        }
        if (this.getDeletedDocumentVersions() != null) {
            versions.addAll(this.getDeletedDocumentVersions().values());
        }
        Collections.sort(versions, new DocumentVersionComparator());
        return versions;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public void setInvalidated(boolean invalidated) {
        this.invalidated = invalidated;
    }

    public void setAsBuiltReference(DocumentImpl asBuiltReference) {
        this.asBuiltReference = asBuiltReference;
    }

    public DocumentImpl getAsBuiltReference() {
        return this.asBuiltReference;
    }
}

