/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.order.OrderStep;
import at.cdes.bo.data.order.OrderStepVisitor;
import at.cdes.bo.data.order.OrganisationPersonOrderStep;
import at.cdes.bo.data.order.ProjectParticipationOrderStep;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestList;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.log4j.Logger;

public abstract class OrderStepDigestCalculator
implements DigestCalculator,
OrderStepVisitor,
Serializable {
    static Logger logger = Logger.getLogger(OrderStepDigestCalculator.class);

    @Override
    public abstract String visit(OrganisationPersonOrderStep var1);

    @Override
    public abstract String visit(ProjectParticipationOrderStep var1);

    @Override
    public String getSignableContent(Object o) throws DigestCalculatorException {
        DigestList<String> list = new DigestList<String>();
        this.getSignableContentIteration(o, list);
        return list.toString();
    }

    public void getSignableContentIteration(Object o, DigestList<String> list) throws DigestCalculatorException {
        if (o == null) {
            return;
        }
        if (o instanceof OrderStep) {
            OrderStep step = (OrderStep)o;
            if (step.getDigest() == null) {
                step.accept(this);
            } else {
                list.add(step.getDigest());
            }
        } else {
            throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation (OrderStepDigestCalculator)");
        }
    }

    protected MessageDigest getMessageDigest() throws DigestCalculatorException {
        try {
            return MessageDigest.getInstance("SHA1", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
        catch (NoSuchProviderException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
    }

    @Override
    public String getDigest(Object o) throws DigestCalculatorException {
        if (o instanceof OrderStep) {
            return (String)((OrderStep)o).accept(this);
        }
        throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation (ReviewResultDigestCalculator)");
    }

    @Override
    public boolean validate(byte[] digest, Object o) throws DigestCalculatorException {
        byte[] newDigest = this.getDigest(o).getBytes();
        return MessageDigest.isEqual(newDigest, digest);
    }
}

