/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.batik.BatikSvgException;
import at.cdes.batik.BatikSvgRendererOperations;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.svg.SvgDataContainer;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.db.dao.PersonDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.service.ObjectOperations;
import at.cdes.service.PlanDeliverCatalogueOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.ReviewCycleOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.SvgOperations;
import at.cdes.service.TaskOperations;
import at.cdes.svg.ReviewProtocollSvgRenderer;
import at.cdes.svg.SmallReviewCycleSvgRenderer;
import at.cdes.svg.UploadStatisticSvgRenderer;
import at.cdes.svg.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.xnap.commons.i18n.I18n;

public class SvgOperationsImpl
implements SvgOperations {
    static final Logger logger = Logger.getLogger(SvgOperationsImpl.class);
    private ReviewOperations reviewOperations;
    private ReviewCycleOperations reviewCycleOperations;
    private TaskOperations taskOperations;
    private PlanDeliverCatalogueOperations planDeliveryCatalogueOperations;
    private HolidayCalculatorFactory holidayCalculatorFactory;
    private ProjectOperations projectOperations;
    private ObjectOperations objectOperations;
    private PersonDAO personDAO;
    private BatikSvgRendererOperations renderer;

    @Override
    public SvgDataContainer renderSmallReviewSummary(int height, int width, Integer documentId, boolean withNodeDurationLabel, boolean withNodeDelayLabelExtended, boolean withCycleDelayLabel, boolean onlyCurrentNode, Integer taskId, boolean oOOMode, Integer personId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"renderSmallReviewSummary starting ...");
        }
        CharArrayWriter w = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(w);
        XMLWriter xw = new XMLWriter(pw);
        CharArrayWriter popupW = new CharArrayWriter();
        PrintWriter popupPW = new PrintWriter(popupW);
        XMLWriter popupXW = new XMLWriter(popupPW);
        SmallReviewCycleSvgRenderer r = new SmallReviewCycleSvgRenderer(this.reviewOperations, this.reviewCycleOperations, this.taskOperations, this.planDeliveryCatalogueOperations, this.objectOperations, this.holidayCalculatorFactory, this.projectOperations, this.personDAO);
        r.render(xw, popupXW, height, width, documentId, withNodeDurationLabel, withNodeDelayLabelExtended, withCycleDelayLabel, onlyCurrentNode, taskId, oOOMode, personId);
        xw.close();
        popupXW.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendered svg: [" + w.toString() + "]"));
        }
        SvgDataContainer ret = new SvgDataContainer(w.toString(), null);
        String popupdata = popupW.toString();
        ret.setPopupData(popupdata);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"renderSmallReviewSummary finished");
        }
        return ret;
    }

    public SvgDataContainer renderReviewProtocollGWT(int height, int width, Integer docVersionId) {
        CharArrayWriter w = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(w);
        XMLWriter xw = new XMLWriter(pw);
        DocumentVersion docVersion = this.reviewOperations.getDocumentVersion(docVersionId);
        List<ReviewCycleCellResult> rccResults = this.reviewOperations.getReviewCycleCellResults(docVersion.getDocument());
        ReviewProtocollSvgRenderer r = new ReviewProtocollSvgRenderer(this.reviewOperations, this.taskOperations, this.planDeliveryCatalogueOperations, this.objectOperations, this.holidayCalculatorFactory);
        r.setRenderer(this.renderer);
        SvgDataContainer svgData = r.render(xw, height, width, docVersion, rccResults);
        svgData.setSvgData(w.toString());
        svgData.setSvgHeader(r.getSvgHeaderGWT(svgData));
        return svgData;
    }

    @Override
    public SvgDataContainer renderReviewProtocoll(int height, int width, Integer docVersionId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"renderReviewProtocoll...");
        }
        CharArrayWriter w = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(w);
        XMLWriter xw = new XMLWriter(pw);
        DocumentVersion docVersion = this.reviewOperations.getDocumentVersion(docVersionId);
        List<ReviewCycleCellResult> rccResults = this.reviewOperations.getReviewCycleCellResults(docVersion.getDocument());
        ReviewProtocollSvgRenderer r = new ReviewProtocollSvgRenderer(this.reviewOperations, this.taskOperations, this.planDeliveryCatalogueOperations, this.objectOperations, this.holidayCalculatorFactory);
        r.setRenderer(this.renderer);
        SvgDataContainer svgData = r.render(xw, height, width, docVersion, rccResults);
        svgData.setSvgData(w.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing svg data: [" + w.toString() + "]"));
        }
        return svgData;
    }

    @Override
    public SvgDataContainer renderUploadStatistic(int height, int width, Integer projectId, Integer personId, boolean showAll) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"renderUploadStatistic...");
        }
        CharArrayWriter w = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(w);
        XMLWriter xw = new XMLWriter(pw);
        List<SubProject> currentProjectSubProjects = this.projectOperations.getAllProjectsSubProjects(projectId);
        List<DocumentVersion> allDocuments = this.planDeliveryCatalogueOperations.getAllDocumentsOfSubproject(currentProjectSubProjects);
        Person person = this.personDAO.get(personId);
        Locale locale = new Locale(person.getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        UploadStatisticSvgRenderer r = new UploadStatisticSvgRenderer();
        r.render(xw, height, width, showAll, allDocuments, i18n);
        SvgDataContainer ret = new SvgDataContainer(w.toString(), null);
        ret.setPopupData("Choke me!");
        return ret;
    }

    @Override
    public SvgDataContainer renderReviewProtocollGWT(Integer documentId) {
        DocumentImpl document = this.reviewOperations.getDocument(documentId);
        DocumentVersion documentVersion = document.getLastDocumentVersion();
        return this.renderReviewProtocollGWT(250, 1050, documentVersion.getId());
    }

    @Override
    public byte[] convertSvgToPng(String svg, double width, double height, double resolution) throws BatikSvgException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.renderer.renderPng((InputStream)new ByteArrayInputStream(svg.getBytes()), (OutputStream)os, width, height, resolution);
        return os.toByteArray();
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    public void setTaskOperations(TaskOperations taskOp) {
        this.taskOperations = taskOp;
    }

    public void setPlanDeliveryCatalogueOperations(PlanDeliverCatalogueOperations planOp) {
        this.planDeliveryCatalogueOperations = planOp;
    }

    public void setHolidayCalculatorFactory(HolidayCalculatorFactory holiFact) {
        this.holidayCalculatorFactory = holiFact;
    }

    public void setProjectOperations(ProjectOperations proOp) {
        this.projectOperations = proOp;
    }

    public void setObjectOperations(ObjectOperations oOp) {
        this.objectOperations = oOp;
    }

    public void setRenderer(BatikSvgRendererOperations renderer) {
        this.renderer = renderer;
    }

    public void setReviewCycleOperations(ReviewCycleOperations reviewCycleOperations) {
        this.reviewCycleOperations = reviewCycleOperations;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public PersonDAO getPersonDAO() {
        return this.personDAO;
    }
}

