/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.sec.PasswordStatus;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.sec.TapestryPasswordStatusChecker;
import at.cdes.db.dao.PersonDAO;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class TapestryPasswordStatusCheckerImpl
implements TapestryPasswordStatusChecker {
    private Long passwordMaxAge;
    private Long passwordExpireInterval;
    private PersonDAO personDAO;

    public void setPasswordMaxAge(Long passwordMaxAge) {
        this.passwordMaxAge = passwordMaxAge;
    }

    public void setPasswordExpireInterval(Long passwordExpireInterval) {
        this.passwordExpireInterval = passwordExpireInterval;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    @Override
    public PasswordStatus checkPasswordStatus(Integer personId) {
        Person person = this.personDAO.get(personId);
        if (this.passwordMaxAge == 0L) {
            return PasswordStatus.VALID;
        }
        if (person.getLastPasswordChangeTs() == null) {
            return PasswordStatus.WARN;
        }
        Long days = ChronoUnit.DAYS.between(Instant.ofEpochMilli(person.getLastPasswordChangeTs()), Instant.now());
        if (days < this.passwordMaxAge - this.passwordExpireInterval) {
            return PasswordStatus.VALID;
        }
        if (days <= this.passwordMaxAge) {
            return PasswordStatus.WARN;
        }
        return PasswordStatus.EXPIRED;
    }
}

