/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.signature;

import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.sec.CDESSignature;
import at.cdes.bo.data.sec.SignatureCalculatorType;
import at.cdes.bo.sec.certificate.KeyHelper;
import at.cdes.bo.sec.signature.SignatureCalculator;
import at.cdes.bo.sec.signature.SignatureCalculatorException;
import at.cdes.service.exception.WrongPasswordException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class PKCS7SignatureCalculatorV1
implements SignatureCalculator {
    private SignatureCalculatorType signatureType;
    static Logger logger = Logger.getLogger((String)"PKCS7SignatureCalculatorV1");

    public byte[] getSignature(byte[] bytes, CDESCertificate cert, String password) throws SignatureCalculatorException, WrongPasswordException {
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        PEMParser pr = null;
        try {
            KeyPair kp = KeyHelper.openKeyPair(cert.getPrivateKey(), password);
            PrivateKey privKey = kp.getPrivate();
            StringReader sr = new StringReader(cert.getCertificate());
            pr = new PEMParser((Reader)sr);
            Object o = pr.readObject();
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)o;
            X509Certificate x509Cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(privKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha1Signer, x509Cert));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(x509Cert);
            JcaCertStore certs = new JcaCertStore(certList);
            gen.addCertificates((Store)certs);
            CMSProcessableByteArray content = new CMSProcessableByteArray(bytes);
            CMSSignedData data = gen.generate((CMSTypedData)content, true);
            logger.info((Object)("signed content =" + data.getSignedContent().getContent()));
            byte[] byArray = data.getEncoded();
            return byArray;
        }
        catch (OperatorCreationException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        catch (CertificateException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        catch (CMSException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        catch (IOException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
            }
            catch (IOException e) {
                throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
            }
        }
    }

    public boolean verify(byte[] encoded, byte[] data2verify, CDESCertificate cert) throws SignatureCalculatorException {
        CMSProcessableByteArray content = new CMSProcessableByteArray(data2verify);
        PEMParser pr = null;
        try {
            CMSSignedData data = new CMSSignedData((CMSProcessable)content, encoded);
            SignerInformationStore signers = data.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            StringReader sr = new StringReader(cert.getCertificate());
            pr = new PEMParser((Reader)sr);
            Object o = pr.readObject();
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)o;
            X509Certificate x509Cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                logger.info((Object)("signer = " + signer.getSID()));
                if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Cert))) continue;
                boolean bl = true;
                return bl;
            }
            logger.warn((Object)"has no signers");
            boolean bl = true;
            return bl;
        }
        catch (CMSException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (CertificateException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (OperatorCreationException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (IOException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
            }
            catch (IOException e) {
                throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
            }
        }
    }

    public boolean verify(String signature, byte[] data2verify, CDESCertificate cert) throws SignatureCalculatorException {
        CMSProcessableByteArray content = new CMSProcessableByteArray(data2verify);
        PEMParser pr = null;
        try {
            StringReader sr = new StringReader(cert.getCertificate());
            pr = new PEMParser((Reader)sr);
            Object o = pr.readObject();
            ContentInfo info = (ContentInfo)o;
            CMSSignedData data = new CMSSignedData((CMSProcessable)content, info.getEncoded());
            SignerInformationStore signers = data.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            o = pr.readObject();
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)o;
            X509Certificate x509Cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                logger.info((Object)("signer = " + signer.getSID()));
                if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Cert))) continue;
                boolean bl = true;
                return bl;
            }
            logger.warn((Object)"has no signers");
            boolean bl = true;
            return bl;
        }
        catch (CMSException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (CertificateException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (OperatorCreationException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (IOException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
            }
            catch (IOException e) {
                throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
            }
        }
    }

    public CMSSignedData getSignature2(byte[] bytes, CDESCertificate cert, String password) throws SignatureCalculatorException {
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        PEMParser pr = null;
        try {
            KeyPair kp = KeyHelper.openKeyPair(cert.getPrivateKey(), password);
            PrivateKey privKey = kp.getPrivate();
            StringReader sr = new StringReader(cert.getCertificate());
            pr = new PEMParser((Reader)sr);
            Object o = pr.readObject();
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)o;
            X509Certificate x509Cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            sr = new StringReader(cert.getCertificateAuthority().getCertificate());
            o = pr.readObject();
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(privKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha1Signer, x509Cert));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(x509Cert);
            JcaCertStore certs = new JcaCertStore(certList);
            gen.addCertificates((Store)certs);
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            list.add(x509Cert);
            CMSProcessableByteArray content = new CMSProcessableByteArray(bytes);
            CMSSignedData data = gen.generate((CMSTypedData)content, true);
            logger.info((Object)("signed content =" + data.getSignedContent().getContent()));
            CMSSignedData cMSSignedData = data;
            return cMSSignedData;
        }
        catch (CMSException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        catch (CertificateException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        catch (OperatorCreationException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        catch (IOException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        catch (WrongPasswordException e) {
            throw new SignatureCalculatorException("Calculating PKCS7 Signature", e);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
            }
            catch (IOException e) {
                throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
            }
        }
    }

    public boolean verify(ContentInfo info, CDESCertificate cert) throws SignatureCalculatorException {
        PEMParser pr = null;
        try {
            CMSSignedData data = new CMSSignedData(info.getEncoded());
            SignerInformationStore signers = data.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            StringReader sr = new StringReader(cert.getCertificate());
            pr = new PEMParser((Reader)sr);
            Object o = pr.readObject();
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)o;
            X509Certificate x509Cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                logger.info((Object)("signer = " + signer.getSID()));
                if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Cert))) continue;
                boolean bl = true;
                return bl;
            }
            logger.warn((Object)"has no signers");
            boolean bl = true;
            return bl;
        }
        catch (CMSException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (CertificateException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (OperatorCreationException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        catch (IOException e) {
            throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
            }
            catch (IOException e) {
                throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
            }
        }
    }

    @Override
    public CDESSignature createSignature(ProjectParticipant pp, String content, CDESCertificate cert, String password) throws SignatureCalculatorException, WrongPasswordException {
        CDESSignature sign = new CDESSignature();
        sign.setProjectParticipant(pp);
        sign.setTime(new Date(System.currentTimeMillis()));
        sign.setType(this.signatureType);
        sign.setContent(content);
        sign.setCertificate(cert);
        sign.setSignature(this.getPKCS7String(this.getSignature(content.getBytes(), cert, password)));
        return sign;
    }

    public String getPKCS7String(byte[] content) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-----BEGIN PKCS7-----\n");
        char[] buf = new char[64];
        byte[] bytes = Base64.encode((byte[])content);
        for (int i = 0; i < bytes.length; i += buf.length) {
            int index;
            for (index = 0; index != buf.length && i + index < bytes.length; ++index) {
                buf[index] = (char)bytes[i + index];
            }
            buffer.append(buf, 0, index);
            buffer.append("\n");
        }
        buffer.append("-----END PKCS7-----\n");
        return buffer.toString();
    }

    @Override
    public void setSignatureType(SignatureCalculatorType signatureType) {
        this.signatureType = signatureType;
    }

    @Override
    public boolean verifySignature(CDESSignature sign) throws SignatureCalculatorException {
        PEMParser pemParser = null;
        try {
            StringReader sr = new StringReader(sign.getSignature());
            pemParser = new PEMParser((Reader)sr);
            ContentInfo d = (ContentInfo)pemParser.readObject();
            boolean bl = this.verify(d, sign.getCertificate());
            return bl;
        }
        catch (IOException e) {
            throw new SignatureCalculatorException("Verify Signature", e);
        }
        finally {
            try {
                if (pemParser != null) {
                    pemParser.close();
                }
            }
            catch (IOException e) {
                throw new SignatureCalculatorException("Verifying PKCS7 Signature", e);
            }
        }
    }
}

