/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.file;

import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.service.exception.FileHandleException;
import java.io.Serializable;

public class CDESDataFile
implements Serializable {
    private static final long serialVersionUID = -1532965768967905323L;
    private String path;
    private CDESFileRepository repository;

    public CDESDataFile(String path, CDESFileRepository repository) {
        this.path = path;
        this.repository = repository;
    }

    public CDESDataFile(String spec) throws FileHandleException {
        int colonPos = spec.indexOf(58);
        if (colonPos < 0) {
            throw new FileHandleException("The data file spec [" + spec + "] contains no colon.");
        }
        this.repository = CDESFileRepository.fromPrefix(spec.substring(0, colonPos));
        this.path = spec.substring(colonPos + 1);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public CDESFileRepository getRepository() {
        return this.repository;
    }

    public void setRepository(CDESFileRepository repository) {
        this.repository = repository;
    }

    public String toString() {
        return this.repository.toPrefix() + ":" + this.path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!CDESDataFile.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        CDESDataFile other = (CDESDataFile)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals((Object)other.repository));
    }
}

