/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionStatementResult;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.ReviewCycleCellConnectionResultDigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.util.Collection;
import org.bouncycastle.util.encoders.Base64;

public class ReviewCycleCellConnectionResultDigesterV1
extends ReviewCycleCellConnectionResultDigestCalculator {
    @Override
    public String getReviewCycleEntryHash(ReviewCycleCellConnectionResult res) throws DigestCalculatorException {
        if (res.getDigest() != null) {
            return res.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + res.getId()).getBytes());
            dos.write(("source_document_version_id=" + res.getSourceDocumentVersion().getId()).getBytes());
            dos.write(("destination_document_version_id=" + res.getDestinationDocumentVersion().getId()).getBytes());
            dos.write(("project_participant_id=" + res.getProjectParticipant().getId()).getBytes());
            dos.write(("rule=" + res.getRule()).getBytes());
            dos.write(("source_cell_result_id=" + res.getSourceReviewCycleCellResult().getId()).getBytes());
            dos.write(("destination_cell_result_id=" + res.getDestinationReviewCycleCellResult().getId()).getBytes());
            if (res.getStatements() != null) {
                Collection stats = res.getStatements().values();
                for (ReviewCycleCellConnectionStatementResult result : stats) {
                    String s = "stat=" + result.getId() + " com=" + result.getComment() + " res=" + (result.getReviewCycleResultOption() != null ? Integer.valueOf(result.getReviewCycleResultOption().getValue()) : null);
                    dos.write(s.getBytes());
                }
            }
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing ReviewCycleCellConnection = ", e);
        }
        String result = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return result;
    }
}

