/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.hibernate;

import java.util.Properties;
import javax.transaction.Synchronization;
import org.apache.commons.lang.NotImplementedException;
import org.clazzes.util.aop.ThreadLocalManager;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.JDBCTransactionFactory;
import org.hibernate.transaction.TransactionFactory;

public class HibernateJdbcTransactionFactory
implements TransactionFactory {
    private TransactionFactory delegate = new JDBCTransactionFactory();

    public Transaction createTransaction(JDBCContext jdbcContext, TransactionFactory.Context context) throws HibernateException {
        if (this.isInInterceptorTransaction()) {
            return new Transaction(){

                public void begin() throws HibernateException {
                }

                public void commit() throws HibernateException {
                }

                public void rollback() throws HibernateException {
                }

                public boolean wasRolledBack() throws HibernateException {
                    return false;
                }

                public boolean wasCommitted() throws HibernateException {
                    return false;
                }

                public boolean isActive() throws HibernateException {
                    return true;
                }

                public void registerSynchronization(Synchronization synchronization) throws HibernateException {
                    throw new NotImplementedException();
                }

                public void setTimeout(int seconds) {
                }
            };
        }
        return this.delegate.createTransaction(jdbcContext, context);
    }

    public void configure(Properties props) throws HibernateException {
        this.delegate.configure(props);
    }

    public ConnectionReleaseMode getDefaultReleaseMode() {
        return this.delegate.getDefaultReleaseMode();
    }

    public boolean isTransactionManagerRequired() {
        return this.delegate.isTransactionManagerRequired();
    }

    public boolean areCallbacksLocalToHibernateTransactions() {
        return this.delegate.areCallbacksLocalToHibernateTransactions();
    }

    private boolean isInInterceptorTransaction() {
        return ThreadLocalManager.getBoundResource((String)"at.cdes.dojo-impl::DataSource") != null;
    }

    public boolean isTransactionInProgress(JDBCContext jdbcContext, TransactionFactory.Context transactionContext, Transaction transaction) {
        boolean prev = this.delegate.isTransactionInProgress(jdbcContext, transactionContext, transaction);
        if (prev) {
            return prev;
        }
        return this.isInInterceptorTransaction();
    }
}

