/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.object;

import at.cdes.bo.data.HashedObject;
import at.cdes.bo.data.object.CDESObject;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectList;
import at.cdes.bo.data.object.ObjectType;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.sec.DigestCalculatorType;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;

public class ReleasedCDESObject
implements CDESObject,
HashedObject {
    static final long serialVersionUID = 1L;
    private Integer id;
    private String codeWithoutType;
    private float stretchKmTo;
    private float stretchKmFrom;
    private boolean inactive;
    private String name;
    private String comment;
    private CDESObjectImpl object;
    private ObjectList objectList;
    private String digest;
    private DigestCalculatorType digestCalculatorType;
    private Map objectPlanners;
    private ObjectType objectType;
    private int modified;

    @Override
    public int getModified() {
        return this.modified;
    }

    @Override
    public void setModified(int modified) {
        this.modified = modified;
    }

    @Override
    public Map getObjectPlanners() {
        return this.objectPlanners;
    }

    @Override
    public void setObjectPlanners(Map objectPlanners) {
        this.objectPlanners = objectPlanners;
    }

    public ReleasedCDESObject() {
    }

    public ReleasedCDESObject(CDESObjectImpl object) {
        this.codeWithoutType = object.getCodeWithoutType();
        this.stretchKmFrom = object.getStretchKmFrom();
        this.stretchKmTo = object.getStretchKmTo();
        this.inactive = object.isInactive();
        this.name = object.getName();
        this.comment = object.getComment();
        this.object = object;
        this.objectType = object.getObjectType();
    }

    @Override
    public String getKms() {
        return String.format(Locale.US, "%.3f", Float.valueOf(this.stretchKmFrom)) + " - " + String.format(Locale.US, "%.3f", Float.valueOf(this.stretchKmTo));
    }

    @Override
    public String getPlannerReviewCycleString() {
        String res = "";
        Collection objectPlanners = this.getObjectPlanners().values();
        for (ReleasedObjectPlanner objectPlanner : objectPlanners) {
            res = res + objectPlanner.getCode() + " " + objectPlanner.getArea() + " ";
            res = res + objectPlanner.getReviewCycleInstance().getName() + " ";
            res = res + objectPlanner.getPlanner().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " ";
            res = res + objectPlanner.getPlanner().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + " ";
        }
        return res;
    }

    @Override
    public String getCode() {
        if (this.objectType != null) {
            return this.codeWithoutType + this.objectType.getCode();
        }
        return this.codeWithoutType;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public boolean isInactive() {
        return this.inactive;
    }

    @Override
    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public CDESObjectImpl getObject() {
        return this.object;
    }

    public void setObject(CDESObjectImpl object) {
        this.object = object;
    }

    @Override
    public float getStretchKmFrom() {
        return this.stretchKmFrom;
    }

    @Override
    public void setStretchKmFrom(float stretchKmFrom) {
        this.stretchKmFrom = stretchKmFrom;
    }

    @Override
    public float getStretchKmTo() {
        return this.stretchKmTo;
    }

    @Override
    public void setStretchKmTo(float stretchKmTo) {
        this.stretchKmTo = stretchKmTo;
    }

    @Override
    public void setDigest(String digest) {
        this.digest = digest;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public ObjectList getObjectList() {
        return this.objectList;
    }

    @Override
    public void setObjectList(ObjectList objectList) {
        this.objectList = objectList;
    }

    @Override
    public DigestCalculatorType getDigestCalculatorType() {
        return this.digestCalculatorType;
    }

    @Override
    public void setDigestCalculatorType(DigestCalculatorType calc) {
        this.digestCalculatorType = calc;
    }

    @Override
    public String getCodeWithoutType() {
        return this.codeWithoutType;
    }

    @Override
    public void setCodeWithoutType(String codeWithoutType) {
        this.codeWithoutType = codeWithoutType;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ReleasedCDESObject.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ReleasedCDESObject other = (ReleasedCDESObject)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public boolean isReadOnly() {
        return this.object.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.object.setReadOnly(readOnly);
    }
}

