/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.file.FileFinder;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.LabelOperations;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class LabelPngMimeSource
implements VisitlessMimeSource {
    private IHPGLRenderer hpglRenderer;
    private LabelOperations labelOperations;
    private FileFinder fileFinder;

    public String getActionName() {
        return "labelsOverview";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        Integer id = (Integer)parameters[0];
        LabelContent label = this.getLabelOperations().getLabelContent(id);
        Collection networks = label.getLabel().getOrganisation().getNetworks().values();
        ArrayList ret = new ArrayList(networks.size());
        ret.addAll(networks);
        return ret;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        Integer id = (Integer)parameters[0];
        Integer resolution = (Integer)parameters[1];
        Integer pixelSz = (Integer)parameters[2];
        Integer reviewCycleId = (Integer)parameters[3];
        LabelContent labelContent = this.getLabelOperations().getLabelContent(id);
        try (FileMimeInputStream stream = null;){
            File file = this.getFileFinder().findFile(labelContent.getFileName(), CDESFileRepository.LABELREPOSITORY);
            String unique = this.getFileFinder().makeUniqueName(labelContent.getFileName(), CDESFileRepository.LABELREPOSITORY);
            stream = new FileMimeInputStream(file, unique, labelContent.getName() + "." + labelContent.getFileType(), DefaultHttpContext.getInstance().getMimeType(labelContent.getFileName()));
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            Date creationDate = new Date();
            creationDate.setTime(file.lastModified());
            byte[] fdf_data = this.labelOperations.formatFDFSample(labelContent, creationDate, reviewCycleId);
            ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, 0.001 * (double)file.lastModified(), labelContent.getName() + ".fdf", "application/vnd.fdf");
            annotations.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
            IMimeInputStream ret = resolution == -1 ? this.hpglRenderer.renderPngByPixelSize((IMimeInputStream)stream, pixelSz.intValue(), true, labelContent.getRotationAngle(), "", annotations) : this.hpglRenderer.renderPngByResolution((IMimeInputStream)stream, (double)resolution.intValue(), true, labelContent.getRotationAngle(), "", annotations);
            IMimeInputStream iMimeInputStream = ret;
            return iMimeInputStream;
        }
    }

    protected FileFinder getFileFinder() {
        return this.fileFinder;
    }

    protected IHPGLRenderer getHpglRenderer() {
        return this.hpglRenderer;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setHpglRenderer(IHPGLRenderer hpglRenderer) {
        this.hpglRenderer = hpglRenderer;
    }

    protected LabelOperations getLabelOperations() {
        return this.labelOperations;
    }

    public void setLabelOperations(LabelOperations labelOperations) {
        this.labelOperations = labelOperations;
    }
}

